import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface InsightsEventConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#id InsightsEvent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * event block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#event InsightsEvent#event}
    */
    readonly event: InsightsEventEvent[] | cdktf.IResolvable;
}
export interface InsightsEventEventAttribute {
    /**
    * The name of the attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#key InsightsEvent#key}
    */
    readonly key: string;
    /**
    * Specify the type for the attribute value. This is useful when passing integer or float values to Insights. Allowed values are string, int, or float. Defaults to string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#type InsightsEvent#type}
    */
    readonly type?: string;
    /**
    * The value of the attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#value InsightsEvent#value}
    */
    readonly value: string;
}
export declare function insightsEventEventAttributeToTerraform(struct?: InsightsEventEventAttribute | cdktf.IResolvable): any;
export declare class InsightsEventEventAttributeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): InsightsEventEventAttribute | cdktf.IResolvable | undefined;
    set internalValue(value: InsightsEventEventAttribute | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class InsightsEventEventAttributeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: InsightsEventEventAttribute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): InsightsEventEventAttributeOutputReference;
}
export interface InsightsEventEvent {
    /**
    * Must be a Unix epoch timestamp. You can define timestamps either in seconds or in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#timestamp InsightsEvent#timestamp}
    */
    readonly timestamp?: number;
    /**
    * The event's name. Can be a combination of alphanumeric characters, underscores, and colons.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#type InsightsEvent#type}
    */
    readonly type: string;
    /**
    * attribute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#attribute InsightsEvent#attribute}
    */
    readonly attribute: InsightsEventEventAttribute[] | cdktf.IResolvable;
}
export declare function insightsEventEventToTerraform(struct?: InsightsEventEvent | cdktf.IResolvable): any;
export declare class InsightsEventEventOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): InsightsEventEvent | cdktf.IResolvable | undefined;
    set internalValue(value: InsightsEventEvent | cdktf.IResolvable | undefined);
    private _timestamp?;
    get timestamp(): number;
    set timestamp(value: number);
    resetTimestamp(): void;
    get timestampInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _attribute;
    get attribute(): InsightsEventEventAttributeList;
    putAttribute(value: InsightsEventEventAttribute[] | cdktf.IResolvable): void;
    get attributeInput(): cdktf.IResolvable | InsightsEventEventAttribute[] | undefined;
}
export declare class InsightsEventEventList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: InsightsEventEvent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): InsightsEventEventOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event newrelic_insights_event}
*/
export declare class InsightsEvent extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_insights_event";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event newrelic_insights_event} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options InsightsEventConfig
    */
    constructor(scope: Construct, id: string, config: InsightsEventConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _event;
    get event(): InsightsEventEventList;
    putEvent(value: InsightsEventEvent[] | cdktf.IResolvable): void;
    get eventInput(): cdktf.IResolvable | InsightsEventEvent[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
