import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotificationChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * (Required) The id of the destination.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#destination_id NotificationChannel#destination_id}
    */
    readonly destinationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#id NotificationChannel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * (Required) The name of the channel.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#name NotificationChannel#name}
    */
    readonly name: string;
    /**
    * (Required) The type of the channel product. One of: (ALERTS, DISCUSSIONS, ERROR_TRACKING, NTFC, SHARING, PD, IINT).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#product NotificationChannel#product}
    */
    readonly product: string;
    /**
    * (Required) The type of the channel. One of: (WEBHOOK, EMAIL, SERVICENOW_INCIDENTS, PAGERDUTY_ACCOUNT_INTEGRATION, PAGERDUTY_SERVICE_INTEGRATION).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#type NotificationChannel#type}
    */
    readonly type: string;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#properties NotificationChannel#properties}
    */
    readonly properties?: NotificationChannelProperties[] | cdktf.IResolvable;
}
export interface NotificationChannelProperties {
    /**
    * Notification channel property display key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#display_value NotificationChannel#display_value}
    */
    readonly displayValue?: string;
    /**
    * Notification channel property key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#key NotificationChannel#key}
    */
    readonly key: string;
    /**
    * Notification channel property label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#label NotificationChannel#label}
    */
    readonly label?: string;
    /**
    * Notification channel property value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel#value NotificationChannel#value}
    */
    readonly value: string;
}
export declare function notificationChannelPropertiesToTerraform(struct?: NotificationChannelProperties | cdktf.IResolvable): any;
export declare class NotificationChannelPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NotificationChannelProperties | cdktf.IResolvable | undefined;
    set internalValue(value: NotificationChannelProperties | cdktf.IResolvable | undefined);
    private _displayValue?;
    get displayValue(): string;
    set displayValue(value: string);
    resetDisplayValue(): void;
    get displayValueInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class NotificationChannelPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NotificationChannelProperties[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NotificationChannelPropertiesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel newrelic_notification_channel}
*/
export declare class NotificationChannel extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_notification_channel";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/notification_channel newrelic_notification_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotificationChannelConfig
    */
    constructor(scope: Construct, id: string, config: NotificationChannelConfig);
    private _destinationId?;
    get destinationId(): string;
    set destinationId(value: string);
    get destinationIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _properties;
    get properties(): NotificationChannelPropertiesList;
    putProperties(value: NotificationChannelProperties[] | cdktf.IResolvable): void;
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | NotificationChannelProperties[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
