import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotificationDestinationConfig extends cdktf.TerraformMetaArguments {
    /**
    * A set of key-value pairs to represent a Notification destination auth.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#auth NotificationDestination#auth}
    */
    readonly auth?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#id NotificationDestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * (Required) The name of the destination.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#name NotificationDestination#name}
    */
    readonly name: string;
    /**
    * (Required) The type of the destination. One of: (WEBHOOK, EMAIL, SERVICE_NOW, PAGERDUTY_ACCOUNT_INTEGRATION, PAGERDUTY_SERVICE_INTEGRATION).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#type NotificationDestination#type}
    */
    readonly type: string;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#properties NotificationDestination#properties}
    */
    readonly properties?: NotificationDestinationProperties[] | cdktf.IResolvable;
}
export interface NotificationDestinationProperties {
    /**
    * Notification destination property display key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#display_value NotificationDestination#display_value}
    */
    readonly displayValue?: string;
    /**
    * Notification destination property key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#key NotificationDestination#key}
    */
    readonly key: string;
    /**
    * Notification destination property label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#label NotificationDestination#label}
    */
    readonly label?: string;
    /**
    * Notification destination property value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination#value NotificationDestination#value}
    */
    readonly value: string;
}
export declare function notificationDestinationPropertiesToTerraform(struct?: NotificationDestinationProperties | cdktf.IResolvable): any;
export declare class NotificationDestinationPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NotificationDestinationProperties | cdktf.IResolvable | undefined;
    set internalValue(value: NotificationDestinationProperties | cdktf.IResolvable | undefined);
    private _displayValue?;
    get displayValue(): string;
    set displayValue(value: string);
    resetDisplayValue(): void;
    get displayValueInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class NotificationDestinationPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NotificationDestinationProperties[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NotificationDestinationPropertiesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination newrelic_notification_destination}
*/
export declare class NotificationDestination extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_notification_destination";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/notification_destination newrelic_notification_destination} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotificationDestinationConfig
    */
    constructor(scope: Construct, id: string, config: NotificationDestinationConfig);
    private _auth?;
    get auth(): {
        [key: string]: string;
    };
    set auth(value: {
        [key: string]: string;
    });
    resetAuth(): void;
    get authInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _properties;
    get properties(): NotificationDestinationPropertiesList;
    putProperties(value: NotificationDestinationProperties[] | cdktf.IResolvable): void;
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | NotificationDestinationProperties[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
