import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NrqlDropRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Account with the NRQL drop rule will be put.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_drop_rule#account_id NrqlDropRule#account_id}
    */
    readonly accountId?: number;
    /**
    * The drop rule action (drop_data, drop_attributes, or drop_attributes_from_metric_aggregates).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_drop_rule#action NrqlDropRule#action}
    */
    readonly action: string;
    /**
    * Provides additional information about the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_drop_rule#description NrqlDropRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_drop_rule#id NrqlDropRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Explains which data to apply the drop rule to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_drop_rule#nrql NrqlDropRule#nrql}
    */
    readonly nrql: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_drop_rule newrelic_nrql_drop_rule}
*/
export declare class NrqlDropRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_nrql_drop_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_drop_rule newrelic_nrql_drop_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NrqlDropRuleConfig
    */
    constructor(scope: Construct, id: string, config: NrqlDropRuleConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nrql?;
    get nrql(): string;
    set nrql(value: string);
    get nrqlInput(): string | undefined;
    get ruleId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
