import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OneDashboardRawConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to create the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#account_id OneDashboardRaw#account_id}
    */
    readonly accountId?: number;
    /**
    * The dashboard's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#description OneDashboardRaw#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#id OneDashboardRaw#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The dashboard's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#name OneDashboardRaw#name}
    */
    readonly name: string;
    /**
    * Determines who can see or edit the dashboard. Valid values are private, public_read_only, public_read_write. Defaults to public_read_only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#permissions OneDashboardRaw#permissions}
    */
    readonly permissions?: string;
    /**
    * page block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#page OneDashboardRaw#page}
    */
    readonly page: OneDashboardRawPage[] | cdktf.IResolvable;
}
export interface OneDashboardRawPageWidget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#column OneDashboardRaw#column}
    */
    readonly column: number;
    /**
    * The configuration of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#configuration OneDashboardRaw#configuration}
    */
    readonly configuration: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#height OneDashboardRaw#height}
    */
    readonly height?: number;
    /**
    * (Optional) Related entity GUIDs. Currently only supports Dashboard entity GUIDs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#linked_entity_guids OneDashboardRaw#linked_entity_guids}
    */
    readonly linkedEntityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#row OneDashboardRaw#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#title OneDashboardRaw#title}
    */
    readonly title: string;
    /**
    * The visualization ID of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#visualization_id OneDashboardRaw#visualization_id}
    */
    readonly visualizationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#width OneDashboardRaw#width}
    */
    readonly width?: number;
}
export declare function oneDashboardRawPageWidgetToTerraform(struct?: OneDashboardRawPageWidget | cdktf.IResolvable): any;
export declare class OneDashboardRawPageWidgetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardRawPageWidget | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardRawPageWidget | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _configuration?;
    get configuration(): string;
    set configuration(value: string);
    get configurationInput(): string | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _linkedEntityGuids?;
    get linkedEntityGuids(): string[];
    set linkedEntityGuids(value: string[]);
    resetLinkedEntityGuids(): void;
    get linkedEntityGuidsInput(): string[] | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _visualizationId?;
    get visualizationId(): string;
    set visualizationId(value: string);
    get visualizationIdInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
}
export declare class OneDashboardRawPageWidgetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardRawPageWidget[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardRawPageWidgetOutputReference;
}
export interface OneDashboardRawPage {
    /**
    * The dashboard page's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#description OneDashboardRaw#description}
    */
    readonly description?: string;
    /**
    * The dashboard page's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#name OneDashboardRaw#name}
    */
    readonly name: string;
    /**
    * widget block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#widget OneDashboardRaw#widget}
    */
    readonly widget?: OneDashboardRawPageWidget[] | cdktf.IResolvable;
}
export declare function oneDashboardRawPageToTerraform(struct?: OneDashboardRawPage | cdktf.IResolvable): any;
export declare class OneDashboardRawPageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardRawPage | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardRawPage | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get guid(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _widget;
    get widget(): OneDashboardRawPageWidgetList;
    putWidget(value: OneDashboardRawPageWidget[] | cdktf.IResolvable): void;
    resetWidget(): void;
    get widgetInput(): cdktf.IResolvable | OneDashboardRawPageWidget[] | undefined;
}
export declare class OneDashboardRawPageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardRawPage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardRawPageOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw newrelic_one_dashboard_raw}
*/
export declare class OneDashboardRaw extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_one_dashboard_raw";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw newrelic_one_dashboard_raw} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OneDashboardRawConfig
    */
    constructor(scope: Construct, id: string, config: OneDashboardRawConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get guid(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get permalink(): string;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _page;
    get page(): OneDashboardRawPageList;
    putPage(value: OneDashboardRawPage[] | cdktf.IResolvable): void;
    get pageInput(): cdktf.IResolvable | OneDashboardRawPage[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
