import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OneDashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to create the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The dashboard's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#description OneDashboard#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#id OneDashboard#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The dashboard's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#name OneDashboard#name}
    */
    readonly name: string;
    /**
    * Determines who can see or edit the dashboard. Valid values are private, public_read_only, public_read_write. Defaults to public_read_only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#permissions OneDashboard#permissions}
    */
    readonly permissions?: string;
    /**
    * page block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#page OneDashboard#page}
    */
    readonly page: OneDashboardPage[] | cdktf.IResolvable;
}
export interface OneDashboardPageWidgetAreaNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetAreaNrqlQueryToTerraform(struct?: OneDashboardPageWidgetAreaNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetAreaNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetAreaNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetAreaNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetAreaNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetAreaNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetAreaNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetArea {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetAreaNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetAreaToTerraform(struct?: OneDashboardPageWidgetArea | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetAreaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetArea | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetArea | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetAreaNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetAreaNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetAreaNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetAreaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetArea[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetAreaOutputReference;
}
export interface OneDashboardPageWidgetBarNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetBarNrqlQueryToTerraform(struct?: OneDashboardPageWidgetBarNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetBarNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetBarNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetBarNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetBarNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetBarNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetBarNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetBar {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Use this item to filter the current dashboard
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#filter_current_dashboard OneDashboard#filter_current_dashboard}
    */
    readonly filterCurrentDashboard?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Related entities. Currently only supports Dashboard entities, but may allow other cases in the future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#linked_entity_guids OneDashboard#linked_entity_guids}
    */
    readonly linkedEntityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetBarNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetBarToTerraform(struct?: OneDashboardPageWidgetBar | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetBarOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetBar | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetBar | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _filterCurrentDashboard?;
    get filterCurrentDashboard(): boolean | cdktf.IResolvable;
    set filterCurrentDashboard(value: boolean | cdktf.IResolvable);
    resetFilterCurrentDashboard(): void;
    get filterCurrentDashboardInput(): boolean | cdktf.IResolvable | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _linkedEntityGuids?;
    get linkedEntityGuids(): string[];
    set linkedEntityGuids(value: string[]);
    resetLinkedEntityGuids(): void;
    get linkedEntityGuidsInput(): string[] | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetBarNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetBarNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetBarNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetBarList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetBar[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetBarOutputReference;
}
export interface OneDashboardPageWidgetBillboardNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetBillboardNrqlQueryToTerraform(struct?: OneDashboardPageWidgetBillboardNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetBillboardNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetBillboardNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetBillboardNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetBillboardNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetBillboardNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetBillboardNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetBillboard {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * The critical threshold value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#critical OneDashboard#critical}
    */
    readonly critical?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * The warning threshold value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#warning OneDashboard#warning}
    */
    readonly warning?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetBillboardNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetBillboardToTerraform(struct?: OneDashboardPageWidgetBillboard | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetBillboardOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetBillboard | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetBillboard | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _critical?;
    get critical(): string;
    set critical(value: string);
    resetCritical(): void;
    get criticalInput(): string | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _warning?;
    get warning(): string;
    set warning(value: string);
    resetWarning(): void;
    get warningInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetBillboardNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetBillboardNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetBillboardNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetBillboardList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetBillboard[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetBillboardOutputReference;
}
export interface OneDashboardPageWidgetBulletNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetBulletNrqlQueryToTerraform(struct?: OneDashboardPageWidgetBulletNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetBulletNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetBulletNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetBulletNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetBulletNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetBulletNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetBulletNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetBullet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * The maximum value for the visualization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#limit OneDashboard#limit}
    */
    readonly limit: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetBulletNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetBulletToTerraform(struct?: OneDashboardPageWidgetBullet | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetBulletOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetBullet | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetBullet | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    get limitInput(): number | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetBulletNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetBulletNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetBulletNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetBulletList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetBullet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetBulletOutputReference;
}
export interface OneDashboardPageWidgetFunnelNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetFunnelNrqlQueryToTerraform(struct?: OneDashboardPageWidgetFunnelNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetFunnelNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetFunnelNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetFunnelNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetFunnelNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetFunnelNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetFunnelNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetFunnel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetFunnelNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetFunnelToTerraform(struct?: OneDashboardPageWidgetFunnel | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetFunnelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetFunnel | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetFunnel | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetFunnelNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetFunnelNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetFunnelNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetFunnelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetFunnel[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetFunnelOutputReference;
}
export interface OneDashboardPageWidgetHeatmapNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetHeatmapNrqlQueryToTerraform(struct?: OneDashboardPageWidgetHeatmapNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetHeatmapNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetHeatmapNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetHeatmapNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetHeatmapNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetHeatmapNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetHeatmapNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetHeatmap {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetHeatmapNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetHeatmapToTerraform(struct?: OneDashboardPageWidgetHeatmap | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetHeatmapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetHeatmap | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetHeatmap | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetHeatmapNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetHeatmapNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetHeatmapNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetHeatmapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetHeatmap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetHeatmapOutputReference;
}
export interface OneDashboardPageWidgetHistogramNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetHistogramNrqlQueryToTerraform(struct?: OneDashboardPageWidgetHistogramNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetHistogramNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetHistogramNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetHistogramNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetHistogramNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetHistogramNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetHistogramNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetHistogram {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetHistogramNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetHistogramToTerraform(struct?: OneDashboardPageWidgetHistogram | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetHistogramOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetHistogram | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetHistogram | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetHistogramNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetHistogramNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetHistogramNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetHistogramList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetHistogram[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetHistogramOutputReference;
}
export interface OneDashboardPageWidgetJsonNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetJsonNrqlQueryToTerraform(struct?: OneDashboardPageWidgetJsonNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetJsonNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetJsonNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetJsonNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetJsonNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetJsonNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetJsonNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetJson {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetJsonNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetJsonToTerraform(struct?: OneDashboardPageWidgetJson | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetJsonOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetJson | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetJson | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetJsonNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetJsonNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetJsonNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetJsonList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetJson[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetJsonOutputReference;
}
export interface OneDashboardPageWidgetLineNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetLineNrqlQueryToTerraform(struct?: OneDashboardPageWidgetLineNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetLineNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetLineNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetLineNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetLineNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetLineNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetLineNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetLine {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetLineNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetLineToTerraform(struct?: OneDashboardPageWidgetLine | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetLineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetLine | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetLine | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetLineNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetLineNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetLineNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetLineList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetLine[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetLineOutputReference;
}
export interface OneDashboardPageWidgetLogTableNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetLogTableNrqlQueryToTerraform(struct?: OneDashboardPageWidgetLogTableNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetLogTableNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetLogTableNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetLogTableNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetLogTableNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetLogTableNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetLogTableNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetLogTable {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetLogTableNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetLogTableToTerraform(struct?: OneDashboardPageWidgetLogTable | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetLogTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetLogTable | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetLogTable | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetLogTableNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetLogTableNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetLogTableNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetLogTableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetLogTable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetLogTableOutputReference;
}
export interface OneDashboardPageWidgetMarkdown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#text OneDashboard#text}
    */
    readonly text?: string;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
}
export declare function oneDashboardPageWidgetMarkdownToTerraform(struct?: OneDashboardPageWidgetMarkdown | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetMarkdownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetMarkdown | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetMarkdown | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
}
export declare class OneDashboardPageWidgetMarkdownList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetMarkdown[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetMarkdownOutputReference;
}
export interface OneDashboardPageWidgetPieNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetPieNrqlQueryToTerraform(struct?: OneDashboardPageWidgetPieNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetPieNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetPieNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetPieNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetPieNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetPieNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetPieNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetPie {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Use this item to filter the current dashboard
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#filter_current_dashboard OneDashboard#filter_current_dashboard}
    */
    readonly filterCurrentDashboard?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Related entities. Currently only supports Dashboard entities, but may allow other cases in the future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#linked_entity_guids OneDashboard#linked_entity_guids}
    */
    readonly linkedEntityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetPieNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetPieToTerraform(struct?: OneDashboardPageWidgetPie | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetPieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetPie | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetPie | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _filterCurrentDashboard?;
    get filterCurrentDashboard(): boolean | cdktf.IResolvable;
    set filterCurrentDashboard(value: boolean | cdktf.IResolvable);
    resetFilterCurrentDashboard(): void;
    get filterCurrentDashboardInput(): boolean | cdktf.IResolvable | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _linkedEntityGuids?;
    get linkedEntityGuids(): string[];
    set linkedEntityGuids(value: string[]);
    resetLinkedEntityGuids(): void;
    get linkedEntityGuidsInput(): string[] | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetPieNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetPieNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetPieNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetPieList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetPie[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetPieOutputReference;
}
export interface OneDashboardPageWidgetStackedBarNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetStackedBarNrqlQueryToTerraform(struct?: OneDashboardPageWidgetStackedBarNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetStackedBarNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetStackedBarNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetStackedBarNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetStackedBarNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetStackedBarNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetStackedBarNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetStackedBar {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetStackedBarNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetStackedBarToTerraform(struct?: OneDashboardPageWidgetStackedBar | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetStackedBarOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetStackedBar | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetStackedBar | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetStackedBarNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetStackedBarNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetStackedBarNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetStackedBarList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetStackedBar[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetStackedBarOutputReference;
}
export interface OneDashboardPageWidgetTableNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetTableNrqlQueryToTerraform(struct?: OneDashboardPageWidgetTableNrqlQuery | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetTableNrqlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetTableNrqlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetTableNrqlQuery | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class OneDashboardPageWidgetTableNrqlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetTableNrqlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetTableNrqlQueryOutputReference;
}
export interface OneDashboardPageWidgetTable {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Use this item to filter the current dashboard
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#filter_current_dashboard OneDashboard#filter_current_dashboard}
    */
    readonly filterCurrentDashboard?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#ignore_time_range OneDashboard#ignore_time_range}
    */
    readonly ignoreTimeRange?: boolean | cdktf.IResolvable;
    /**
    * Related entities. Currently only supports Dashboard entities, but may allow other cases in the future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#linked_entity_guids OneDashboard#linked_entity_guids}
    */
    readonly linkedEntityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetTableNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetTableToTerraform(struct?: OneDashboardPageWidgetTable | cdktf.IResolvable): any;
export declare class OneDashboardPageWidgetTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPageWidgetTable | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPageWidgetTable | cdktf.IResolvable | undefined);
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _filterCurrentDashboard?;
    get filterCurrentDashboard(): boolean | cdktf.IResolvable;
    set filterCurrentDashboard(value: boolean | cdktf.IResolvable);
    resetFilterCurrentDashboard(): void;
    get filterCurrentDashboardInput(): boolean | cdktf.IResolvable | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    get id(): string;
    private _ignoreTimeRange?;
    get ignoreTimeRange(): boolean | cdktf.IResolvable;
    set ignoreTimeRange(value: boolean | cdktf.IResolvable);
    resetIgnoreTimeRange(): void;
    get ignoreTimeRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _linkedEntityGuids?;
    get linkedEntityGuids(): string[];
    set linkedEntityGuids(value: string[]);
    resetLinkedEntityGuids(): void;
    get linkedEntityGuidsInput(): string[] | undefined;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _nrqlQuery;
    get nrqlQuery(): OneDashboardPageWidgetTableNrqlQueryList;
    putNrqlQuery(value: OneDashboardPageWidgetTableNrqlQuery[] | cdktf.IResolvable): void;
    get nrqlQueryInput(): cdktf.IResolvable | OneDashboardPageWidgetTableNrqlQuery[] | undefined;
}
export declare class OneDashboardPageWidgetTableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPageWidgetTable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageWidgetTableOutputReference;
}
export interface OneDashboardPage {
    /**
    * The dashboard page's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#description OneDashboard#description}
    */
    readonly description?: string;
    /**
    * The dashboard page's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#name OneDashboard#name}
    */
    readonly name: string;
    /**
    * widget_area block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_area OneDashboard#widget_area}
    */
    readonly widgetArea?: OneDashboardPageWidgetArea[] | cdktf.IResolvable;
    /**
    * widget_bar block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_bar OneDashboard#widget_bar}
    */
    readonly widgetBar?: OneDashboardPageWidgetBar[] | cdktf.IResolvable;
    /**
    * widget_billboard block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_billboard OneDashboard#widget_billboard}
    */
    readonly widgetBillboard?: OneDashboardPageWidgetBillboard[] | cdktf.IResolvable;
    /**
    * widget_bullet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_bullet OneDashboard#widget_bullet}
    */
    readonly widgetBullet?: OneDashboardPageWidgetBullet[] | cdktf.IResolvable;
    /**
    * widget_funnel block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_funnel OneDashboard#widget_funnel}
    */
    readonly widgetFunnel?: OneDashboardPageWidgetFunnel[] | cdktf.IResolvable;
    /**
    * widget_heatmap block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_heatmap OneDashboard#widget_heatmap}
    */
    readonly widgetHeatmap?: OneDashboardPageWidgetHeatmap[] | cdktf.IResolvable;
    /**
    * widget_histogram block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_histogram OneDashboard#widget_histogram}
    */
    readonly widgetHistogram?: OneDashboardPageWidgetHistogram[] | cdktf.IResolvable;
    /**
    * widget_json block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_json OneDashboard#widget_json}
    */
    readonly widgetJson?: OneDashboardPageWidgetJson[] | cdktf.IResolvable;
    /**
    * widget_line block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_line OneDashboard#widget_line}
    */
    readonly widgetLine?: OneDashboardPageWidgetLine[] | cdktf.IResolvable;
    /**
    * widget_log_table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_log_table OneDashboard#widget_log_table}
    */
    readonly widgetLogTable?: OneDashboardPageWidgetLogTable[] | cdktf.IResolvable;
    /**
    * widget_markdown block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_markdown OneDashboard#widget_markdown}
    */
    readonly widgetMarkdown?: OneDashboardPageWidgetMarkdown[] | cdktf.IResolvable;
    /**
    * widget_pie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_pie OneDashboard#widget_pie}
    */
    readonly widgetPie?: OneDashboardPageWidgetPie[] | cdktf.IResolvable;
    /**
    * widget_stacked_bar block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_stacked_bar OneDashboard#widget_stacked_bar}
    */
    readonly widgetStackedBar?: OneDashboardPageWidgetStackedBar[] | cdktf.IResolvable;
    /**
    * widget_table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_table OneDashboard#widget_table}
    */
    readonly widgetTable?: OneDashboardPageWidgetTable[] | cdktf.IResolvable;
}
export declare function oneDashboardPageToTerraform(struct?: OneDashboardPage | cdktf.IResolvable): any;
export declare class OneDashboardPageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OneDashboardPage | cdktf.IResolvable | undefined;
    set internalValue(value: OneDashboardPage | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get guid(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _widgetArea;
    get widgetArea(): OneDashboardPageWidgetAreaList;
    putWidgetArea(value: OneDashboardPageWidgetArea[] | cdktf.IResolvable): void;
    resetWidgetArea(): void;
    get widgetAreaInput(): cdktf.IResolvable | OneDashboardPageWidgetArea[] | undefined;
    private _widgetBar;
    get widgetBar(): OneDashboardPageWidgetBarList;
    putWidgetBar(value: OneDashboardPageWidgetBar[] | cdktf.IResolvable): void;
    resetWidgetBar(): void;
    get widgetBarInput(): cdktf.IResolvable | OneDashboardPageWidgetBar[] | undefined;
    private _widgetBillboard;
    get widgetBillboard(): OneDashboardPageWidgetBillboardList;
    putWidgetBillboard(value: OneDashboardPageWidgetBillboard[] | cdktf.IResolvable): void;
    resetWidgetBillboard(): void;
    get widgetBillboardInput(): cdktf.IResolvable | OneDashboardPageWidgetBillboard[] | undefined;
    private _widgetBullet;
    get widgetBullet(): OneDashboardPageWidgetBulletList;
    putWidgetBullet(value: OneDashboardPageWidgetBullet[] | cdktf.IResolvable): void;
    resetWidgetBullet(): void;
    get widgetBulletInput(): cdktf.IResolvable | OneDashboardPageWidgetBullet[] | undefined;
    private _widgetFunnel;
    get widgetFunnel(): OneDashboardPageWidgetFunnelList;
    putWidgetFunnel(value: OneDashboardPageWidgetFunnel[] | cdktf.IResolvable): void;
    resetWidgetFunnel(): void;
    get widgetFunnelInput(): cdktf.IResolvable | OneDashboardPageWidgetFunnel[] | undefined;
    private _widgetHeatmap;
    get widgetHeatmap(): OneDashboardPageWidgetHeatmapList;
    putWidgetHeatmap(value: OneDashboardPageWidgetHeatmap[] | cdktf.IResolvable): void;
    resetWidgetHeatmap(): void;
    get widgetHeatmapInput(): cdktf.IResolvable | OneDashboardPageWidgetHeatmap[] | undefined;
    private _widgetHistogram;
    get widgetHistogram(): OneDashboardPageWidgetHistogramList;
    putWidgetHistogram(value: OneDashboardPageWidgetHistogram[] | cdktf.IResolvable): void;
    resetWidgetHistogram(): void;
    get widgetHistogramInput(): cdktf.IResolvable | OneDashboardPageWidgetHistogram[] | undefined;
    private _widgetJson;
    get widgetJson(): OneDashboardPageWidgetJsonList;
    putWidgetJson(value: OneDashboardPageWidgetJson[] | cdktf.IResolvable): void;
    resetWidgetJson(): void;
    get widgetJsonInput(): cdktf.IResolvable | OneDashboardPageWidgetJson[] | undefined;
    private _widgetLine;
    get widgetLine(): OneDashboardPageWidgetLineList;
    putWidgetLine(value: OneDashboardPageWidgetLine[] | cdktf.IResolvable): void;
    resetWidgetLine(): void;
    get widgetLineInput(): cdktf.IResolvable | OneDashboardPageWidgetLine[] | undefined;
    private _widgetLogTable;
    get widgetLogTable(): OneDashboardPageWidgetLogTableList;
    putWidgetLogTable(value: OneDashboardPageWidgetLogTable[] | cdktf.IResolvable): void;
    resetWidgetLogTable(): void;
    get widgetLogTableInput(): cdktf.IResolvable | OneDashboardPageWidgetLogTable[] | undefined;
    private _widgetMarkdown;
    get widgetMarkdown(): OneDashboardPageWidgetMarkdownList;
    putWidgetMarkdown(value: OneDashboardPageWidgetMarkdown[] | cdktf.IResolvable): void;
    resetWidgetMarkdown(): void;
    get widgetMarkdownInput(): cdktf.IResolvable | OneDashboardPageWidgetMarkdown[] | undefined;
    private _widgetPie;
    get widgetPie(): OneDashboardPageWidgetPieList;
    putWidgetPie(value: OneDashboardPageWidgetPie[] | cdktf.IResolvable): void;
    resetWidgetPie(): void;
    get widgetPieInput(): cdktf.IResolvable | OneDashboardPageWidgetPie[] | undefined;
    private _widgetStackedBar;
    get widgetStackedBar(): OneDashboardPageWidgetStackedBarList;
    putWidgetStackedBar(value: OneDashboardPageWidgetStackedBar[] | cdktf.IResolvable): void;
    resetWidgetStackedBar(): void;
    get widgetStackedBarInput(): cdktf.IResolvable | OneDashboardPageWidgetStackedBar[] | undefined;
    private _widgetTable;
    get widgetTable(): OneDashboardPageWidgetTableList;
    putWidgetTable(value: OneDashboardPageWidgetTable[] | cdktf.IResolvable): void;
    resetWidgetTable(): void;
    get widgetTableInput(): cdktf.IResolvable | OneDashboardPageWidgetTable[] | undefined;
}
export declare class OneDashboardPageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OneDashboardPage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OneDashboardPageOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard newrelic_one_dashboard}
*/
export declare class OneDashboard extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_one_dashboard";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard newrelic_one_dashboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OneDashboardConfig
    */
    constructor(scope: Construct, id: string, config: OneDashboardConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get guid(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get permalink(): string;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _page;
    get page(): OneDashboardPageList;
    putPage(value: OneDashboardPage[] | cdktf.IResolvable): void;
    get pageInput(): cdktf.IResolvable | OneDashboardPage[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
