import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SyntheticsMonitorScriptConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#id SyntheticsMonitorScript#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the monitor to attach the script to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#monitor_id SyntheticsMonitorScript#monitor_id}
    */
    readonly monitorId: string;
    /**
    * The plaintext representing the monitor script.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#text SyntheticsMonitorScript#text}
    */
    readonly text: string;
    /**
    * location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#location SyntheticsMonitorScript#location}
    */
    readonly location?: SyntheticsMonitorScriptLocation[] | cdktf.IResolvable;
}
export interface SyntheticsMonitorScriptLocation {
    /**
    * The HMAC for the monitor script location. Use only one of `hmac` or `vse_password.`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#hmac SyntheticsMonitorScript#hmac}
    */
    readonly hmac?: string;
    /**
    * The monitor script location name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#name SyntheticsMonitorScript#name}
    */
    readonly name: string;
    /**
    * The password for the monitor script location used to calculate HMAC. Use only one of `vse_password` or `hmac.`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#vse_password SyntheticsMonitorScript#vse_password}
    */
    readonly vsePassword?: string;
}
export declare function syntheticsMonitorScriptLocationToTerraform(struct?: SyntheticsMonitorScriptLocation | cdktf.IResolvable): any;
export declare class SyntheticsMonitorScriptLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SyntheticsMonitorScriptLocation | cdktf.IResolvable | undefined;
    set internalValue(value: SyntheticsMonitorScriptLocation | cdktf.IResolvable | undefined);
    private _hmac?;
    get hmac(): string;
    set hmac(value: string);
    resetHmac(): void;
    get hmacInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _vsePassword?;
    get vsePassword(): string;
    set vsePassword(value: string);
    resetVsePassword(): void;
    get vsePasswordInput(): string | undefined;
}
export declare class SyntheticsMonitorScriptLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SyntheticsMonitorScriptLocation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SyntheticsMonitorScriptLocationOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script newrelic_synthetics_monitor_script}
*/
export declare class SyntheticsMonitorScript extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_synthetics_monitor_script";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script newrelic_synthetics_monitor_script} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SyntheticsMonitorScriptConfig
    */
    constructor(scope: Construct, id: string, config: SyntheticsMonitorScriptConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _monitorId?;
    get monitorId(): string;
    set monitorId(value: string);
    get monitorIdInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    get textInput(): string | undefined;
    private _location;
    get location(): SyntheticsMonitorScriptLocationList;
    putLocation(value: SyntheticsMonitorScriptLocation[] | cdktf.IResolvable): void;
    resetLocation(): void;
    get locationInput(): cdktf.IResolvable | SyntheticsMonitorScriptLocation[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
