import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WorkloadConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to create the workload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#account_id Workload#account_id}
    */
    readonly accountId?: number;
    /**
    * A list of entity GUIDs manually assigned to this workload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#entity_guids Workload#entity_guids}
    */
    readonly entityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#id Workload#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The workload's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#name Workload#name}
    */
    readonly name: string;
    /**
    * A list of account IDs that will be used to get entities from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#scope_account_ids Workload#scope_account_ids}
    */
    readonly scopeAccountIds?: number[];
    /**
    * entity_search_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#entity_search_query Workload#entity_search_query}
    */
    readonly entitySearchQuery?: WorkloadEntitySearchQuery[] | cdktf.IResolvable;
}
export interface WorkloadEntitySearchQuery {
    /**
    * The query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#query Workload#query}
    */
    readonly query: string;
}
export declare function workloadEntitySearchQueryToTerraform(struct?: WorkloadEntitySearchQuery | cdktf.IResolvable): any;
export declare class WorkloadEntitySearchQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WorkloadEntitySearchQuery | cdktf.IResolvable | undefined;
    set internalValue(value: WorkloadEntitySearchQuery | cdktf.IResolvable | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class WorkloadEntitySearchQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WorkloadEntitySearchQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WorkloadEntitySearchQueryOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/workload newrelic_workload}
*/
export declare class Workload extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_workload";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/workload newrelic_workload} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WorkloadConfig
    */
    constructor(scope: Construct, id: string, config: WorkloadConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    get compositeEntitySearchQuery(): string;
    private _entityGuids?;
    get entityGuids(): string[];
    set entityGuids(value: string[]);
    resetEntityGuids(): void;
    get entityGuidsInput(): string[] | undefined;
    get guid(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get permalink(): string;
    private _scopeAccountIds?;
    get scopeAccountIds(): number[];
    set scopeAccountIds(value: number[]);
    resetScopeAccountIds(): void;
    get scopeAccountIdsInput(): number[] | undefined;
    get workloadId(): number;
    private _entitySearchQuery;
    get entitySearchQuery(): WorkloadEntitySearchQueryList;
    putEntitySearchQuery(value: WorkloadEntitySearchQuery[] | cdktf.IResolvable): void;
    resetEntitySearchQuery(): void;
    get entitySearchQueryInput(): cdktf.IResolvable | WorkloadEntitySearchQuery[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
