import asyncio
from .const import ATTR_CHANGED_BY as ATTR_CHANGED_BY, ATTR_CODE_ARM_REQUIRED as ATTR_CODE_ARM_REQUIRED, AlarmControlPanelEntityFeature as AlarmControlPanelEntityFeature, AlarmControlPanelState as AlarmControlPanelState, CodeFormat as CodeFormat, DOMAIN as DOMAIN
from _typeshed import Incomplete
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import ATTR_CODE as ATTR_CODE, ATTR_CODE_FORMAT as ATTR_CODE_FORMAT, SERVICE_ALARM_ARM_AWAY as SERVICE_ALARM_ARM_AWAY, SERVICE_ALARM_ARM_CUSTOM_BYPASS as SERVICE_ALARM_ARM_CUSTOM_BYPASS, SERVICE_ALARM_ARM_HOME as SERVICE_ALARM_ARM_HOME, SERVICE_ALARM_ARM_NIGHT as SERVICE_ALARM_ARM_NIGHT, SERVICE_ALARM_ARM_VACATION as SERVICE_ALARM_ARM_VACATION, SERVICE_ALARM_DISARM as SERVICE_ALARM_DISARM, SERVICE_ALARM_TRIGGER as SERVICE_ALARM_TRIGGER
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import ServiceValidationError as ServiceValidationError
from homeassistant.helpers.config_validation import make_entity_service_schema as make_entity_service_schema
from homeassistant.helpers.entity import Entity as Entity, EntityDescription as EntityDescription
from homeassistant.helpers.entity_component import EntityComponent as EntityComponent
from homeassistant.helpers.entity_platform import EntityPlatform as EntityPlatform
from homeassistant.helpers.frame import ReportBehavior as ReportBehavior, report_usage as report_usage
from homeassistant.helpers.typing import ConfigType as ConfigType
from homeassistant.util.hass_dict import HassKey as HassKey
from propcache.api import cached_property
from typing import Any, Final, final

_LOGGER: Final[Incomplete]
DATA_COMPONENT: HassKey[EntityComponent[AlarmControlPanelEntity]]
ENTITY_ID_FORMAT: Final[Incomplete]
PLATFORM_SCHEMA: Final[Incomplete]
PLATFORM_SCHEMA_BASE: Final[Incomplete]
SCAN_INTERVAL: Final[Incomplete]
CONF_DEFAULT_CODE: str
ALARM_SERVICE_SCHEMA: Final[Incomplete]

async def async_setup(hass: HomeAssistant, config: ConfigType) -> bool: ...
async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
async def async_unload_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...

class AlarmControlPanelEntityDescription(EntityDescription, frozen_or_thawed=True): ...

CACHED_PROPERTIES_WITH_ATTR_: Incomplete

class AlarmControlPanelEntity(Entity, cached_properties=CACHED_PROPERTIES_WITH_ATTR_):
    entity_description: AlarmControlPanelEntityDescription
    _attr_alarm_state: AlarmControlPanelState | None
    _attr_changed_by: str | None
    _attr_code_arm_required: bool
    _attr_code_format: CodeFormat | None
    _attr_supported_features: AlarmControlPanelEntityFeature
    _alarm_control_panel_option_default_code: str | None
    __alarm_legacy_state: bool
    def __init_subclass__(cls, **kwargs: Any) -> None: ...
    def __setattr__(self, name: str, value: Any, /) -> None: ...
    @callback
    def add_to_platform_start(self, hass: HomeAssistant, platform: EntityPlatform, parallel_updates: asyncio.Semaphore | None) -> None: ...
    @callback
    def _report_deprecated_alarm_state_handling(self) -> None: ...
    @final
    @property
    def state(self) -> str | None: ...
    @cached_property
    def alarm_state(self) -> AlarmControlPanelState | None: ...
    @final
    @callback
    def code_or_default_code(self, code: str | None) -> str | None: ...
    @cached_property
    def code_format(self) -> CodeFormat | None: ...
    @cached_property
    def changed_by(self) -> str | None: ...
    @cached_property
    def code_arm_required(self) -> bool: ...
    @final
    @callback
    def check_code_arm_required(self, code: str | None) -> str | None: ...
    @final
    async def async_handle_alarm_disarm(self, code: str | None = None) -> None: ...
    def alarm_disarm(self, code: str | None = None) -> None: ...
    async def async_alarm_disarm(self, code: str | None = None) -> None: ...
    @final
    async def async_handle_alarm_arm_home(self, code: str | None = None) -> None: ...
    def alarm_arm_home(self, code: str | None = None) -> None: ...
    async def async_alarm_arm_home(self, code: str | None = None) -> None: ...
    @final
    async def async_handle_alarm_arm_away(self, code: str | None = None) -> None: ...
    def alarm_arm_away(self, code: str | None = None) -> None: ...
    async def async_alarm_arm_away(self, code: str | None = None) -> None: ...
    @final
    async def async_handle_alarm_arm_night(self, code: str | None = None) -> None: ...
    def alarm_arm_night(self, code: str | None = None) -> None: ...
    async def async_alarm_arm_night(self, code: str | None = None) -> None: ...
    @final
    async def async_handle_alarm_arm_vacation(self, code: str | None = None) -> None: ...
    def alarm_arm_vacation(self, code: str | None = None) -> None: ...
    async def async_alarm_arm_vacation(self, code: str | None = None) -> None: ...
    def alarm_trigger(self, code: str | None = None) -> None: ...
    async def async_alarm_trigger(self, code: str | None = None) -> None: ...
    @final
    async def async_handle_alarm_arm_custom_bypass(self, code: str | None = None) -> None: ...
    def alarm_arm_custom_bypass(self, code: str | None = None) -> None: ...
    async def async_alarm_arm_custom_bypass(self, code: str | None = None) -> None: ...
    @cached_property
    def supported_features(self) -> AlarmControlPanelEntityFeature: ...
    @final
    @property
    def state_attributes(self) -> dict[str, Any] | None: ...
    async def async_internal_added_to_hass(self) -> None: ...
    @callback
    def async_registry_entry_updated(self) -> None: ...
    @callback
    def _async_read_entity_options(self) -> None: ...
