from .const import SAMPLE_CHANNELS as SAMPLE_CHANNELS, SAMPLE_RATE as SAMPLE_RATE, SAMPLE_WIDTH as SAMPLE_WIDTH
from _typeshed import Incomplete
from collections.abc import Callable as Callable, Iterable
from dataclasses import dataclass
from enum import StrEnum

_LOGGER: Incomplete

class VadSensitivity(StrEnum):
    DEFAULT = 'default'
    RELAXED = 'relaxed'
    AGGRESSIVE = 'aggressive'
    @staticmethod
    def to_seconds(sensitivity: VadSensitivity | str) -> float: ...

class AudioBuffer:
    _buffer: Incomplete
    _length: int
    def __init__(self, maxlen: int) -> None: ...
    @property
    def length(self) -> int: ...
    def clear(self) -> None: ...
    def append(self, data: bytes) -> None: ...
    def bytes(self) -> bytes: ...
    def __len__(self) -> int: ...
    def __bool__(self) -> bool: ...

@dataclass
class VoiceCommandSegmenter:
    speech_seconds: float = ...
    command_seconds: float = ...
    silence_seconds: float = ...
    timeout_seconds: float = ...
    reset_seconds: float = ...
    in_command: bool = ...
    timed_out: bool = ...
    before_command_speech_threshold: float = ...
    in_command_speech_threshold: float = ...
    _speech_seconds_left: float = ...
    _command_seconds_left: float = ...
    _silence_seconds_left: float = ...
    _timeout_seconds_left: float = ...
    _reset_seconds_left: float = ...
    def __post_init__(self) -> None: ...
    def reset(self) -> None: ...
    def process(self, chunk_seconds: float, speech_probability: float | None) -> bool: ...
    def process_with_vad(self, chunk: bytes, vad_samples_per_chunk: int | None, vad_is_speech: Callable[[bytes], bool], leftover_chunk_buffer: AudioBuffer | None) -> bool: ...

@dataclass
class VoiceActivityTimeout:
    silence_seconds: float
    reset_seconds: float = ...
    speech_threshold: float = ...
    _silence_seconds_left: float = ...
    _reset_seconds_left: float = ...
    def __post_init__(self) -> None: ...
    def reset(self) -> None: ...
    def process(self, chunk_seconds: float, speech_probability: float | None) -> bool: ...

def chunk_samples(samples: bytes, bytes_per_chunk: int, leftover_chunk_buffer: AudioBuffer) -> Iterable[bytes]: ...
