import abc
from .const import CONF_DNSMASQ as CONF_DNSMASQ, CONF_INTERFACE as CONF_INTERFACE, CONF_REQUIRE_IP as CONF_REQUIRE_IP, CONF_SSH_KEY as CONF_SSH_KEY, DEFAULT_DNSMASQ as DEFAULT_DNSMASQ, DEFAULT_INTERFACE as DEFAULT_INTERFACE, KEY_METHOD as KEY_METHOD, KEY_SENSORS as KEY_SENSORS, PROTOCOL_HTTP as PROTOCOL_HTTP, PROTOCOL_HTTPS as PROTOCOL_HTTPS, PROTOCOL_TELNET as PROTOCOL_TELNET, SENSORS_BYTES as SENSORS_BYTES, SENSORS_LOAD_AVG as SENSORS_LOAD_AVG, SENSORS_MEMORY as SENSORS_MEMORY, SENSORS_RATES as SENSORS_RATES, SENSORS_TEMPERATURES_LEGACY as SENSORS_TEMPERATURES_LEGACY, SENSORS_UPTIME as SENSORS_UPTIME
from .helpers import clean_dict as clean_dict, translate_to_legacy as translate_to_legacy
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from aioasuswrt.asuswrt import AsusWrt as AsusWrtLegacy
from aiohttp import ClientSession as ClientSession
from asusrouter import AsusRouter
from asusrouter.modules.client import AsusClient as AsusClient
from asusrouter.modules.data import AsusData
from collections.abc import Awaitable, Callable, Coroutine
from homeassistant.const import CONF_HOST as CONF_HOST, CONF_MODE as CONF_MODE, CONF_PASSWORD as CONF_PASSWORD, CONF_PORT as CONF_PORT, CONF_PROTOCOL as CONF_PROTOCOL, CONF_USERNAME as CONF_USERNAME
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.aiohttp_client import async_create_clientsession as async_create_clientsession
from homeassistant.helpers.device_registry import format_mac as format_mac
from homeassistant.helpers.update_coordinator import UpdateFailed as UpdateFailed
from typing import Any, NamedTuple

SENSORS_TYPE_BYTES: str
SENSORS_TYPE_COUNT: str
SENSORS_TYPE_CPU: str
SENSORS_TYPE_LOAD_AVG: str
SENSORS_TYPE_MEMORY: str
SENSORS_TYPE_RATES: str
SENSORS_TYPE_TEMPERATURES: str
SENSORS_TYPE_UPTIME: str

class WrtDevice(NamedTuple):
    ip: Incomplete
    name: Incomplete
    connected_to: Incomplete

_LOGGER: Incomplete
type _FuncType[_T] = Callable[[_T], Awaitable[list[Any] | tuple[Any] | dict[str, Any]]]
type _ReturnFuncType[_T] = Callable[[_T], Coroutine[Any, Any, dict[str, Any]]]

def handle_errors_and_zip[_AsusWrtBridgeT: AsusWrtBridge](exceptions: type[Exception] | tuple[type[Exception], ...], keys: list[str] | None) -> Callable[[_FuncType[_AsusWrtBridgeT]], _ReturnFuncType[_AsusWrtBridgeT]]: ...

class AsusWrtBridge(ABC, metaclass=abc.ABCMeta):
    @staticmethod
    def get_bridge(hass: HomeAssistant, conf: dict[str, Any], options: dict[str, Any] | None = None) -> AsusWrtBridge: ...
    _host: Incomplete
    _firmware: str | None
    _label_mac: str | None
    _model: str | None
    def __init__(self, host: str) -> None: ...
    @property
    def host(self) -> str: ...
    @property
    def firmware(self) -> str | None: ...
    @property
    def label_mac(self) -> str | None: ...
    @property
    def model(self) -> str | None: ...
    @property
    @abstractmethod
    def is_connected(self) -> bool: ...
    @abstractmethod
    async def async_connect(self) -> None: ...
    @abstractmethod
    async def async_disconnect(self) -> None: ...
    @abstractmethod
    async def async_get_connected_devices(self) -> dict[str, WrtDevice]: ...
    @abstractmethod
    async def async_get_available_sensors(self) -> dict[str, dict[str, Any]]: ...

class AsusWrtLegacyBridge(AsusWrtBridge):
    _protocol: str
    _api: AsusWrtLegacy
    def __init__(self, conf: dict[str, Any], options: dict[str, Any] | None = None) -> None: ...
    @staticmethod
    def _get_api(conf: dict[str, Any], options: dict[str, Any] | None = None) -> AsusWrtLegacy: ...
    @property
    def is_connected(self) -> bool: ...
    async def async_connect(self) -> None: ...
    async def async_disconnect(self) -> None: ...
    async def async_get_connected_devices(self) -> dict[str, WrtDevice]: ...
    async def _get_nvram_info(self, info_type: str) -> dict[str, Any]: ...
    _label_mac: Incomplete
    async def _get_label_mac(self) -> None: ...
    _firmware: Incomplete
    async def _get_firmware(self) -> None: ...
    _model: Incomplete
    async def _get_model(self) -> None: ...
    async def async_get_available_sensors(self) -> dict[str, dict[str, Any]]: ...
    async def _get_available_temperature_sensors(self) -> list[str]: ...
    async def _get_bytes(self) -> Any: ...
    async def _get_rates(self) -> Any: ...
    async def _get_load_avg(self) -> Any: ...
    async def _get_temperatures(self) -> Any: ...

class AsusWrtHttpBridge(AsusWrtBridge):
    _api: Incomplete
    def __init__(self, conf: dict[str, Any], session: ClientSession) -> None: ...
    @staticmethod
    def _get_api(conf: dict[str, Any], session: ClientSession) -> AsusRouter: ...
    @property
    def is_connected(self) -> bool: ...
    _label_mac: Incomplete
    _firmware: Incomplete
    _model: Incomplete
    async def async_connect(self) -> None: ...
    async def async_disconnect(self) -> None: ...
    async def _get_data(self, datatype: AsusData, force: bool = False) -> dict[str, Any]: ...
    async def _get_sensors(self, datatype: AsusData) -> list[str]: ...
    async def async_get_connected_devices(self) -> dict[str, WrtDevice]: ...
    async def async_get_available_sensors(self) -> dict[str, dict[str, Any]]: ...
    async def _get_bytes(self) -> Any: ...
    async def _get_rates(self) -> Any: ...
    async def _get_load_avg(self) -> Any: ...
    async def _get_temperatures(self) -> Any: ...
    async def _get_cpu_usage(self) -> Any: ...
    async def _get_memory_usage(self) -> Any: ...
    async def _get_uptime(self) -> dict[str, Any]: ...
