import logging
import pathlib
from .const import BLUEPRINT_FOLDER as BLUEPRINT_FOLDER, CONF_BLUEPRINT as CONF_BLUEPRINT, CONF_HOMEASSISTANT as CONF_HOMEASSISTANT, CONF_INPUT as CONF_INPUT, CONF_MIN_VERSION as CONF_MIN_VERSION, CONF_SOURCE_URL as CONF_SOURCE_URL, CONF_USE_BLUEPRINT as CONF_USE_BLUEPRINT, DOMAIN as DOMAIN
from .errors import BlueprintException as BlueprintException, BlueprintInUse as BlueprintInUse, FailedToLoad as FailedToLoad, FileAlreadyExists as FileAlreadyExists, InvalidBlueprint as InvalidBlueprint, InvalidBlueprintInputs as InvalidBlueprintInputs, MissingInput as MissingInput
from .schemas import BLUEPRINT_INSTANCE_FIELDS as BLUEPRINT_INSTANCE_FIELDS
from _typeshed import Incomplete
from collections.abc import Awaitable, Callable as Callable
from homeassistant import loader as loader
from homeassistant.const import CONF_DEFAULT as CONF_DEFAULT, CONF_DOMAIN as CONF_DOMAIN, CONF_NAME as CONF_NAME, CONF_PATH as CONF_PATH, __version__ as __version__
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from typing import Any

class Blueprint:
    domain: Incomplete
    def __init__(self, data: dict[str, Any], *, path: str | None = None, expected_domain: str | None = None, schema: Callable[[Any], Any]) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def inputs(self) -> dict[str, Any]: ...
    @property
    def metadata(self) -> dict[str, Any]: ...
    def update_metadata(self, *, source_url: str | None = None) -> None: ...
    def yaml(self) -> str: ...
    @callback
    def validate(self) -> list[str] | None: ...

class BlueprintInputs:
    blueprint: Incomplete
    config_with_inputs: Incomplete
    def __init__(self, blueprint: Blueprint, config_with_inputs: dict[str, Any]) -> None: ...
    @property
    def inputs(self) -> dict[str, Any]: ...
    @property
    def inputs_with_default(self) -> dict[str, Any]: ...
    def validate(self) -> None: ...
    @callback
    def async_substitute(self) -> dict: ...

class DomainBlueprints:
    hass: Incomplete
    domain: Incomplete
    logger: Incomplete
    _blueprint_in_use: Incomplete
    _reload_blueprint_consumers: Incomplete
    _blueprints: dict[str, Blueprint | None]
    _load_lock: Incomplete
    _blueprint_schema: Incomplete
    def __init__(self, hass: HomeAssistant, domain: str, logger: logging.Logger, blueprint_in_use: Callable[[HomeAssistant, str], bool], reload_blueprint_consumers: Callable[[HomeAssistant, str], Awaitable[None]], blueprint_schema: Callable[[Any], Any]) -> None: ...
    @property
    def blueprint_folder(self) -> pathlib.Path: ...
    async def async_reset_cache(self) -> None: ...
    def _load_blueprint(self, blueprint_path: str) -> Blueprint: ...
    def _load_blueprints(self) -> dict[str, Blueprint | BlueprintException | None]: ...
    async def async_get_blueprints(self) -> dict[str, Blueprint | BlueprintException | None]: ...
    async def async_get_blueprint(self, blueprint_path: str) -> Blueprint: ...
    async def async_inputs_from_config(self, config_with_blueprint: dict) -> BlueprintInputs: ...
    async def async_remove_blueprint(self, blueprint_path: str) -> None: ...
    def _create_file(self, blueprint: Blueprint, blueprint_path: str, allow_override: bool) -> bool: ...
    async def async_add_blueprint(self, blueprint: Blueprint, blueprint_path: str, allow_override: bool = False) -> bool: ...
    async def async_populate(self) -> None: ...
