from .const import DATA_MANAGER as DATA_MANAGER
from .manager import HomeAssistantBluetoothManager as HomeAssistantBluetoothManager
from .match import BluetoothCallbackMatcher as BluetoothCallbackMatcher
from .models import BluetoothCallback as BluetoothCallback, BluetoothChange as BluetoothChange, ProcessAdvertisementCallback as ProcessAdvertisementCallback
from bleak.backends.device import BLEDevice as BLEDevice
from collections.abc import Callable as Callable, Iterable
from habluetooth import BaseHaScanner as BaseHaScanner, BluetoothScannerDevice as BluetoothScannerDevice, BluetoothScanningMode as BluetoothScanningMode, HaBleakScannerWrapper
from home_assistant_bluetooth import BluetoothServiceInfoBleak as BluetoothServiceInfoBleak
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, HomeAssistant as HomeAssistant, callback as hass_callback
from homeassistant.helpers.singleton import singleton as singleton

def _get_manager(hass: HomeAssistant) -> HomeAssistantBluetoothManager: ...
@hass_callback
def async_get_scanner(hass: HomeAssistant) -> HaBleakScannerWrapper: ...
@hass_callback
def async_scanner_by_source(hass: HomeAssistant, source: str) -> BaseHaScanner | None: ...
@hass_callback
def async_scanner_count(hass: HomeAssistant, connectable: bool = True) -> int: ...
@hass_callback
def async_discovered_service_info(hass: HomeAssistant, connectable: bool = True) -> Iterable[BluetoothServiceInfoBleak]: ...
@hass_callback
def async_last_service_info(hass: HomeAssistant, address: str, connectable: bool = True) -> BluetoothServiceInfoBleak | None: ...
@hass_callback
def async_ble_device_from_address(hass: HomeAssistant, address: str, connectable: bool = True) -> BLEDevice | None: ...
@hass_callback
def async_scanner_devices_by_address(hass: HomeAssistant, address: str, connectable: bool = True) -> list[BluetoothScannerDevice]: ...
@hass_callback
def async_address_present(hass: HomeAssistant, address: str, connectable: bool = True) -> bool: ...
@hass_callback
def async_register_callback(hass: HomeAssistant, callback: BluetoothCallback, match_dict: BluetoothCallbackMatcher | None, mode: BluetoothScanningMode) -> Callable[[], None]: ...
async def async_process_advertisements(hass: HomeAssistant, callback: ProcessAdvertisementCallback, match_dict: BluetoothCallbackMatcher, mode: BluetoothScanningMode, timeout: int) -> BluetoothServiceInfoBleak: ...
@hass_callback
def async_track_unavailable(hass: HomeAssistant, callback: Callable[[BluetoothServiceInfoBleak], None], address: str, connectable: bool = True) -> Callable[[], None]: ...
@hass_callback
def async_rediscover_address(hass: HomeAssistant, address: str) -> None: ...
@hass_callback
def async_register_scanner(hass: HomeAssistant, scanner: BaseHaScanner, connection_slots: int | None = None, source_domain: str | None = None, source_model: str | None = None, source_config_entry_id: str | None = None, source_device_id: str | None = None) -> CALLBACK_TYPE: ...
@hass_callback
def async_remove_scanner(hass: HomeAssistant, source: str) -> None: ...
@hass_callback
def async_get_advertisement_callback(hass: HomeAssistant) -> Callable[[BluetoothServiceInfoBleak], None]: ...
@hass_callback
def async_get_learned_advertising_interval(hass: HomeAssistant, address: str) -> float | None: ...
@hass_callback
def async_get_fallback_availability_interval(hass: HomeAssistant, address: str) -> float | None: ...
@hass_callback
def async_set_fallback_availability_interval(hass: HomeAssistant, address: str, interval: float) -> None: ...
