from .const import DOMAIN as DOMAIN
from _typeshed import Incomplete
from collections.abc import Callable as Callable, Sequence
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import CONF_HOST as CONF_HOST, CONF_PASSWORD as CONF_PASSWORD, CONF_USERNAME as CONF_USERNAME, Platform as Platform
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import ConfigEntryNotReady as ConfigEntryNotReady
from homeassistant.helpers.debounce import Debouncer as Debouncer
from homeassistant.helpers.update_coordinator import DataUpdateCoordinator as DataUpdateCoordinator
from pyheos import HeosNowPlayingMedia as HeosNowPlayingMedia, HeosPlayer as HeosPlayer, MediaItem as MediaItem, PlayerUpdateResult as PlayerUpdateResult
from typing import Any

_LOGGER: Incomplete
type HeosConfigEntry = ConfigEntry[HeosCoordinator]

class HeosCoordinator(DataUpdateCoordinator[None]):
    heos: Incomplete
    _platform_callbacks: list[Callable[[Sequence[HeosPlayer]], None]]
    _update_sources_debouncer: Incomplete
    _source_list: list[str]
    _favorites: dict[int, MediaItem]
    _inputs: Sequence[MediaItem]
    def __init__(self, hass: HomeAssistant, config_entry: HeosConfigEntry) -> None: ...
    @property
    def host(self) -> str: ...
    @property
    def inputs(self) -> Sequence[MediaItem]: ...
    @property
    def favorites(self) -> dict[int, MediaItem]: ...
    async def async_setup(self) -> None: ...
    async def async_shutdown(self) -> None: ...
    def async_add_listener(self, update_callback: CALLBACK_TYPE, context: Any = None) -> Callable[[], None]: ...
    def async_add_platform_callback(self, add_entities_callback: Callable[[Sequence[HeosPlayer]], None]) -> None: ...
    def _async_handle_player_update_result(self, update_result: PlayerUpdateResult) -> None: ...
    async def _async_on_auth_failure(self) -> None: ...
    async def _async_on_disconnected(self) -> None: ...
    async def _async_on_reconnected(self) -> None: ...
    async def _async_on_controller_event(self, event: str, data: PlayerUpdateResult | None = None) -> None: ...
    def _async_update_player_ids(self, updated_player_ids: dict[int, int]) -> None: ...
    async def _async_update_groups(self) -> None: ...
    async def _async_update_sources(self) -> None: ...
    @callback
    def async_get_source_list(self) -> list[str]: ...
    @callback
    def async_get_favorite_index(self, name: str) -> int | None: ...
    @callback
    def async_get_current_source(self, now_playing_media: HeosNowPlayingMedia) -> str | None: ...
