import abc
import asyncio
from .const import OTBR_DOMAIN as OTBR_DOMAIN, ZHA_DOMAIN as ZHA_DOMAIN
from .util import ApplicationType as ApplicationType, FirmwareInfo as FirmwareInfo, OwningAddon as OwningAddon, OwningIntegration as OwningIntegration, async_flash_silabs_firmware as async_flash_silabs_firmware, get_otbr_addon_manager as get_otbr_addon_manager, guess_firmware_info as guess_firmware_info, guess_hardware_owners as guess_hardware_owners, probe_silabs_firmware_info as probe_silabs_firmware_info
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from homeassistant.components.hassio import AddonError as AddonError, AddonInfo as AddonInfo, AddonManager as AddonManager, AddonState as AddonState
from homeassistant.config_entries import ConfigEntry as ConfigEntry, ConfigEntryBaseFlow as ConfigEntryBaseFlow, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, OptionsFlow as OptionsFlow
from homeassistant.core import callback as callback
from homeassistant.data_entry_flow import AbortFlow as AbortFlow
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.aiohttp_client import async_get_clientsession as async_get_clientsession
from homeassistant.helpers.hassio import is_hassio as is_hassio
from typing import Any

_LOGGER: Incomplete
STEP_PICK_FIRMWARE_THREAD: str
STEP_PICK_FIRMWARE_ZIGBEE: str

class BaseFirmwareInstallFlow(ConfigEntryBaseFlow, ABC, metaclass=abc.ABCMeta):
    _failed_addon_name: str
    _failed_addon_reason: str
    _probed_firmware_info: FirmwareInfo | None
    _device: str | None
    _hardware_name: str
    addon_install_task: asyncio.Task | None
    addon_start_task: asyncio.Task | None
    addon_uninstall_task: asyncio.Task | None
    firmware_install_task: asyncio.Task | None
    installing_firmware_name: str | None
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def _get_translation_placeholders(self) -> dict[str, str]: ...
    async def _async_get_addon_info(self, addon_manager: AddonManager) -> AddonInfo: ...
    async def async_step_pick_firmware(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _probe_firmware_info(self, probe_methods: tuple[ApplicationType, ...] = ...) -> bool: ...
    async def _install_firmware_step(self, fw_update_url: str, fw_type: str, firmware_name: str, expected_installed_firmware_type: ApplicationType, step_id: str, next_step_id: str) -> ConfigFlowResult: ...
    async def async_step_firmware_download_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_firmware_install_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_pick_firmware_zigbee(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_install_zigbee_firmware(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_addon_operation_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_pre_confirm_zigbee(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_confirm_zigbee(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _ensure_thread_addon_setup(self) -> ConfigFlowResult | None: ...
    async def async_step_pick_firmware_thread(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_install_thread_firmware(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_install_otbr_addon(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_start_otbr_addon(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_pre_confirm_otbr(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_confirm_otbr(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    @abstractmethod
    def _async_flow_finished(self) -> ConfigFlowResult: ...

class BaseFirmwareConfigFlow(BaseFirmwareInstallFlow, ConfigFlow, metaclass=abc.ABCMeta):
    @staticmethod
    @callback
    @abstractmethod
    def async_get_options_flow(config_entry: ConfigEntry) -> OptionsFlow: ...
    _probed_firmware_info: Incomplete
    async def async_step_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...

class BaseFirmwareOptionsFlow(BaseFirmwareInstallFlow, OptionsFlow, metaclass=abc.ABCMeta):
    _probed_firmware_info: FirmwareInfo
    _config_entry: Incomplete
    context: Incomplete
    def __init__(self, config_entry: ConfigEntry, *args: Any, **kwargs: Any) -> None: ...
    async def async_step_init(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_pick_firmware_zigbee(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_pick_firmware_thread(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
