from .entity import ISYAuxControlEntity as ISYAuxControlEntity, ISYNodeEntity as ISYNodeEntity, ISYProgramEntity as ISYProgramEntity
from .models import IsyConfigEntry as IsyConfigEntry
from _typeshed import Incomplete
from dataclasses import dataclass
from homeassistant.components.switch import SwitchDeviceClass as SwitchDeviceClass, SwitchEntity as SwitchEntity, SwitchEntityDescription as SwitchEntityDescription
from homeassistant.const import EntityCategory as EntityCategory, Platform as Platform
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.device_registry import DeviceInfo as DeviceInfo
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from pyisy.helpers import EventListener as EventListener
from pyisy.nodes import Node as Node, NodeChangedEvent as NodeChangedEvent
from typing import Any

@dataclass(frozen=True)
class ISYSwitchEntityDescription(SwitchEntityDescription):
    name: str = ...

async def async_setup_entry(hass: HomeAssistant, entry: IsyConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class ISYSwitchEntity(ISYNodeEntity, SwitchEntity):
    @property
    def is_on(self) -> bool | None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...
    async def async_turn_on(self, **kwargs: Any) -> None: ...
    @property
    def icon(self) -> str | None: ...

class ISYSwitchProgramEntity(ISYProgramEntity, SwitchEntity):
    _attr_icon: str
    @property
    def is_on(self) -> bool: ...
    async def async_turn_on(self, **kwargs: Any) -> None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...

class ISYEnableSwitchEntity(ISYAuxControlEntity, SwitchEntity):
    _attr_name: Incomplete
    _change_handler: EventListener | None
    def __init__(self, node: Node, control: str, unique_id: str, description: ISYSwitchEntityDescription, device_info: DeviceInfo | None) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    @callback
    def async_on_update(self, event: NodeChangedEvent, key: str) -> None: ...
    @property
    def available(self) -> bool: ...
    @property
    def is_on(self) -> bool | None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...
    async def async_turn_on(self, **kwargs: Any) -> None: ...
