from .const import CONTROLLER_MODES as CONTROLLER_MODES, CURRENT_HVAC_ACTIONS as CURRENT_HVAC_ACTIONS, KNX_MODULE_KEY as KNX_MODULE_KEY
from .entity import KnxYamlEntity as KnxYamlEntity
from .knx_module import KNXModule as KNXModule
from .schema import ClimateSchema as ClimateSchema
from _typeshed import Incomplete
from homeassistant import config_entries as config_entries
from homeassistant.components.climate import ClimateEntity as ClimateEntity, ClimateEntityFeature as ClimateEntityFeature, FAN_HIGH as FAN_HIGH, FAN_LOW as FAN_LOW, FAN_MEDIUM as FAN_MEDIUM, FAN_ON as FAN_ON, HVACAction as HVACAction, HVACMode as HVACMode, SWING_OFF as SWING_OFF, SWING_ON as SWING_ON
from homeassistant.const import ATTR_TEMPERATURE as ATTR_TEMPERATURE, CONF_ENTITY_CATEGORY as CONF_ENTITY_CATEGORY, CONF_NAME as CONF_NAME, Platform as Platform, UnitOfTemperature as UnitOfTemperature
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from homeassistant.helpers.typing import ConfigType as ConfigType
from typing import Any
from xknx import XKNX as XKNX
from xknx.devices import Climate as XknxClimate, Device as XknxDevice

ATTR_COMMAND_VALUE: str
CONTROLLER_MODES_INV: Incomplete

async def async_setup_entry(hass: HomeAssistant, config_entry: config_entries.ConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...
def _create_climate(xknx: XKNX, config: ConfigType) -> XknxClimate: ...

class KNXClimate(KnxYamlEntity, ClimateEntity):
    _device: XknxClimate
    _attr_temperature_unit: Incomplete
    _attr_translation_key: str
    _attr_entity_category: Incomplete
    _attr_supported_features: Incomplete
    _attr_preset_modes: Incomplete
    _fan_modes_percentages: Incomplete
    fan_zero_mode: str
    _attr_fan_modes: Incomplete
    _attr_swing_modes: Incomplete
    _attr_swing_horizontal_modes: Incomplete
    _attr_target_temperature_step: Incomplete
    _attr_unique_id: Incomplete
    default_hvac_mode: HVACMode
    _last_hvac_mode: HVACMode
    def __init__(self, knx_module: KNXModule, config: ConfigType) -> None: ...
    @property
    def current_temperature(self) -> float | None: ...
    @property
    def target_temperature(self) -> float | None: ...
    @property
    def min_temp(self) -> float: ...
    @property
    def max_temp(self) -> float: ...
    async def async_turn_on(self) -> None: ...
    async def async_turn_off(self) -> None: ...
    async def async_set_temperature(self, **kwargs: Any) -> None: ...
    @property
    def hvac_mode(self) -> HVACMode: ...
    @property
    def hvac_modes(self) -> list[HVACMode]: ...
    @property
    def hvac_action(self) -> HVACAction | None: ...
    async def async_set_hvac_mode(self, hvac_mode: HVACMode) -> None: ...
    @property
    def preset_mode(self) -> str | None: ...
    async def async_set_preset_mode(self, preset_mode: str) -> None: ...
    @property
    def fan_mode(self) -> str: ...
    async def async_set_fan_mode(self, fan_mode: str) -> None: ...
    async def async_set_swing_mode(self, swing_mode: str) -> None: ...
    async def async_set_swing_horizontal_mode(self, swing_horizontal_mode: str) -> None: ...
    @property
    def swing_mode(self) -> str | None: ...
    @property
    def swing_horizontal_mode(self) -> str | None: ...
    @property
    def current_humidity(self) -> float | None: ...
    @property
    def extra_state_attributes(self) -> dict[str, Any] | None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    def after_update_callback(self, device: XknxDevice) -> None: ...
