import pypck
from .const import CONF_DOMAIN_DATA as CONF_DOMAIN_DATA, CONF_MOTOR as CONF_MOTOR, CONF_POSITIONING_MODE as CONF_POSITIONING_MODE, CONF_REVERSE_TIME as CONF_REVERSE_TIME
from .entity import LcnEntity as LcnEntity
from .helpers import InputType as InputType, LcnConfigEntry as LcnConfigEntry
from _typeshed import Incomplete
from collections.abc import Iterable
from homeassistant.components.cover import ATTR_POSITION as ATTR_POSITION, CoverEntity as CoverEntity, CoverEntityFeature as CoverEntityFeature
from homeassistant.const import CONF_DOMAIN as CONF_DOMAIN, CONF_ENTITIES as CONF_ENTITIES
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from homeassistant.helpers.typing import ConfigType as ConfigType
from typing import Any

PARALLEL_UPDATES: int

def add_lcn_entities(config_entry: LcnConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback, entity_configs: Iterable[ConfigType]) -> None: ...
async def async_setup_entry(hass: HomeAssistant, config_entry: LcnConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class LcnOutputsCover(LcnEntity, CoverEntity):
    _attr_is_closed: bool
    _attr_is_closing: bool
    _attr_is_opening: bool
    _attr_assumed_state: bool
    output_ids: Incomplete
    reverse_time: Incomplete
    def __init__(self, config: ConfigType, config_entry: LcnConfigEntry) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_close_cover(self, **kwargs: Any) -> None: ...
    async def async_open_cover(self, **kwargs: Any) -> None: ...
    async def async_stop_cover(self, **kwargs: Any) -> None: ...
    def input_received(self, input_obj: InputType) -> None: ...

class LcnRelayCover(LcnEntity, CoverEntity):
    _attr_is_closed: bool
    _attr_is_closing: bool
    _attr_is_opening: bool
    _attr_assumed_state: bool
    _attr_supported_features: Incomplete
    positioning_mode: pypck.lcn_defs.MotorPositioningMode
    motor: Incomplete
    motor_port_onoff: Incomplete
    motor_port_updown: Incomplete
    _is_closed: bool
    _is_closing: bool
    _is_opening: bool
    def __init__(self, config: ConfigType, config_entry: LcnConfigEntry) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_close_cover(self, **kwargs: Any) -> None: ...
    async def async_open_cover(self, **kwargs: Any) -> None: ...
    async def async_stop_cover(self, **kwargs: Any) -> None: ...
    _attr_current_cover_position: Incomplete
    async def async_set_cover_position(self, **kwargs: Any) -> None: ...
    def input_received(self, input_obj: InputType) -> None: ...
