from .const import CONF_DOMAIN_DATA as CONF_DOMAIN_DATA, CONF_OUTPUT as CONF_OUTPUT, OUTPUT_PORTS as OUTPUT_PORTS, RELAY_PORTS as RELAY_PORTS, SETPOINTS as SETPOINTS
from .entity import LcnEntity as LcnEntity
from .helpers import InputType as InputType, LcnConfigEntry as LcnConfigEntry
from _typeshed import Incomplete
from collections.abc import Iterable
from homeassistant.components.switch import SwitchEntity as SwitchEntity
from homeassistant.const import CONF_DOMAIN as CONF_DOMAIN, CONF_ENTITIES as CONF_ENTITIES
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from homeassistant.helpers.typing import ConfigType as ConfigType
from typing import Any

PARALLEL_UPDATES: int

def add_lcn_switch_entities(config_entry: LcnConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback, entity_configs: Iterable[ConfigType]) -> None: ...
async def async_setup_entry(hass: HomeAssistant, config_entry: LcnConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class LcnOutputSwitch(LcnEntity, SwitchEntity):
    _attr_is_on: bool
    output: Incomplete
    def __init__(self, config: ConfigType, config_entry: LcnConfigEntry) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_turn_on(self, **kwargs: Any) -> None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...
    def input_received(self, input_obj: InputType) -> None: ...

class LcnRelaySwitch(LcnEntity, SwitchEntity):
    _attr_is_on: bool
    output: Incomplete
    def __init__(self, config: ConfigType, config_entry: LcnConfigEntry) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_turn_on(self, **kwargs: Any) -> None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...
    def input_received(self, input_obj: InputType) -> None: ...

class LcnRegulatorLockSwitch(LcnEntity, SwitchEntity):
    _attr_is_on: bool
    setpoint_variable: Incomplete
    reg_id: Incomplete
    def __init__(self, config: ConfigType, config_entry: LcnConfigEntry) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_turn_on(self, **kwargs: Any) -> None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...
    def input_received(self, input_obj: InputType) -> None: ...

class LcnKeyLockSwitch(LcnEntity, SwitchEntity):
    _attr_is_on: bool
    key: Incomplete
    table_id: Incomplete
    key_id: Incomplete
    def __init__(self, config: ConfigType, config_entry: LcnConfigEntry) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_turn_on(self, **kwargs: Any) -> None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...
    def input_received(self, input_obj: InputType) -> None: ...
