from . import get_device_info as get_device_info
from .const import ATTRIBUTION as ATTRIBUTION, CONDITION_MAP as CONDITION_MAP, DAILY_FORECAST_ATTRIBUTE_MAP as DAILY_FORECAST_ATTRIBUTE_MAP, DAY_FORECAST_ATTRIBUTE_MAP as DAY_FORECAST_ATTRIBUTE_MAP, DOMAIN as DOMAIN, HOURLY_FORECAST_ATTRIBUTE_MAP as HOURLY_FORECAST_ATTRIBUTE_MAP, METOFFICE_COORDINATES as METOFFICE_COORDINATES, METOFFICE_DAILY_COORDINATOR as METOFFICE_DAILY_COORDINATOR, METOFFICE_HOURLY_COORDINATOR as METOFFICE_HOURLY_COORDINATOR, METOFFICE_NAME as METOFFICE_NAME, METOFFICE_TWICE_DAILY_COORDINATOR as METOFFICE_TWICE_DAILY_COORDINATOR, NIGHT_FORECAST_ATTRIBUTE_MAP as NIGHT_FORECAST_ATTRIBUTE_MAP
from .helpers import get_attribute as get_attribute
from _typeshed import Incomplete
from datapoint.Forecast import Forecast as ForecastData
from homeassistant.components.weather import ATTR_FORECAST_CONDITION as ATTR_FORECAST_CONDITION, ATTR_FORECAST_IS_DAYTIME as ATTR_FORECAST_IS_DAYTIME, ATTR_FORECAST_NATIVE_APPARENT_TEMP as ATTR_FORECAST_NATIVE_APPARENT_TEMP, ATTR_FORECAST_NATIVE_PRESSURE as ATTR_FORECAST_NATIVE_PRESSURE, ATTR_FORECAST_NATIVE_TEMP as ATTR_FORECAST_NATIVE_TEMP, ATTR_FORECAST_NATIVE_TEMP_LOW as ATTR_FORECAST_NATIVE_TEMP_LOW, ATTR_FORECAST_NATIVE_WIND_GUST_SPEED as ATTR_FORECAST_NATIVE_WIND_GUST_SPEED, ATTR_FORECAST_NATIVE_WIND_SPEED as ATTR_FORECAST_NATIVE_WIND_SPEED, ATTR_FORECAST_PRECIPITATION as ATTR_FORECAST_PRECIPITATION, ATTR_FORECAST_PRECIPITATION_PROBABILITY as ATTR_FORECAST_PRECIPITATION_PROBABILITY, ATTR_FORECAST_UV_INDEX as ATTR_FORECAST_UV_INDEX, ATTR_FORECAST_WIND_BEARING as ATTR_FORECAST_WIND_BEARING, CoordinatorWeatherEntity as CoordinatorWeatherEntity, Forecast as Forecast, WeatherEntityFeature as WeatherEntityFeature
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import UnitOfLength as UnitOfLength, UnitOfPressure as UnitOfPressure, UnitOfSpeed as UnitOfSpeed, UnitOfTemperature as UnitOfTemperature
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from homeassistant.helpers.update_coordinator import TimestampDataUpdateCoordinator as TimestampDataUpdateCoordinator
from typing import Any

async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...
def _build_hourly_forecast_data(timestep: dict[str, Any]) -> Forecast: ...
def _build_daily_forecast_data(timestep: dict[str, Any]) -> Forecast: ...
def _build_twice_daily_forecast_data(timestep: dict[str, Any]) -> Forecast: ...
def _populate_forecast_data(forecast: Forecast, timestep: dict[str, Any], mapping: dict[str, str]) -> None: ...

class MetOfficeWeather(CoordinatorWeatherEntity[TimestampDataUpdateCoordinator[ForecastData], TimestampDataUpdateCoordinator[ForecastData], TimestampDataUpdateCoordinator[ForecastData]]):
    _attr_attribution = ATTRIBUTION
    _attr_has_entity_name: bool
    _attr_name: Incomplete
    _attr_native_temperature_unit: Incomplete
    _attr_native_pressure_unit: Incomplete
    _attr_native_precipitation_unit: Incomplete
    _attr_native_visibility_unit: Incomplete
    _attr_native_wind_speed_unit: Incomplete
    _attr_supported_features: Incomplete
    _attr_device_info: Incomplete
    _attr_unique_id: Incomplete
    def __init__(self, coordinator_daily: TimestampDataUpdateCoordinator[ForecastData], coordinator_hourly: TimestampDataUpdateCoordinator[ForecastData], coordinator_twice_daily: TimestampDataUpdateCoordinator[ForecastData], hass_data: dict[str, Any]) -> None: ...
    @property
    def condition(self) -> str | None: ...
    @property
    def native_temperature(self) -> float | None: ...
    @property
    def native_dew_point(self) -> float | None: ...
    @property
    def native_pressure(self) -> float | None: ...
    @property
    def humidity(self) -> float | None: ...
    @property
    def uv_index(self) -> float | None: ...
    @property
    def native_visibility(self) -> float | None: ...
    @property
    def native_wind_speed(self) -> float | None: ...
    @property
    def wind_bearing(self) -> float | None: ...
    @callback
    def _async_forecast_daily(self) -> list[Forecast] | None: ...
    @callback
    def _async_forecast_hourly(self) -> list[Forecast] | None: ...
    @callback
    def _async_forecast_twice_daily(self) -> list[Forecast] | None: ...
