import voluptuous as vol
from .const import ATTR_DEVICES as ATTR_DEVICES, ATTR_GATEWAY_ID as ATTR_GATEWAY_ID, ATTR_NODE_ID as ATTR_NODE_ID, DOMAIN as DOMAIN, DevId as DevId, FLAT_PLATFORM_TYPES as FLAT_PLATFORM_TYPES, GatewayId as GatewayId, MYSENSORS_DISCOVERED_NODES as MYSENSORS_DISCOVERED_NODES, MYSENSORS_DISCOVERY as MYSENSORS_DISCOVERY, MYSENSORS_NODE_DISCOVERY as MYSENSORS_NODE_DISCOVERY, SensorType as SensorType, TYPE_TO_PLATFORMS as TYPE_TO_PLATFORMS, ValueType as ValueType
from _typeshed import Incomplete
from collections import defaultdict
from collections.abc import Callable as Callable
from homeassistant.const import CONF_NAME as CONF_NAME, Platform as Platform
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.dispatcher import async_dispatcher_send as async_dispatcher_send
from homeassistant.util.decorator import Registry as Registry
from mysensors import BaseAsyncGateway as BaseAsyncGateway, Message as Message
from mysensors.sensor import ChildSensor as ChildSensor

_LOGGER: Incomplete
SCHEMAS: Registry[tuple[str, str], Callable[[BaseAsyncGateway, ChildSensor, ValueType], vol.Schema]]

@callback
def discover_mysensors_platform(hass: HomeAssistant, gateway_id: GatewayId, platform: str, new_devices: list[DevId]) -> None: ...
@callback
def discover_mysensors_node(hass: HomeAssistant, gateway_id: GatewayId, node_id: int) -> None: ...
def default_schema(gateway: BaseAsyncGateway, child: ChildSensor, value_type_name: ValueType) -> vol.Schema: ...
def light_dimmer_schema(gateway: BaseAsyncGateway, child: ChildSensor, value_type_name: ValueType) -> vol.Schema: ...
def light_percentage_schema(gateway: BaseAsyncGateway, child: ChildSensor, value_type_name: ValueType) -> vol.Schema: ...
def light_rgb_schema(gateway: BaseAsyncGateway, child: ChildSensor, value_type_name: ValueType) -> vol.Schema: ...
def light_rgbw_schema(gateway: BaseAsyncGateway, child: ChildSensor, value_type_name: ValueType) -> vol.Schema: ...
def switch_ir_send_schema(gateway: BaseAsyncGateway, child: ChildSensor, value_type_name: ValueType) -> vol.Schema: ...
def get_child_schema(gateway: BaseAsyncGateway, child: ChildSensor, value_type_name: ValueType, schema: dict) -> vol.Schema: ...
def invalid_msg(gateway: BaseAsyncGateway, child: ChildSensor, value_type_name: ValueType) -> str: ...
def validate_set_msg(gateway_id: GatewayId, msg: Message) -> dict[Platform, list[DevId]]: ...
def validate_node(gateway: BaseAsyncGateway, node_id: int) -> bool: ...
def validate_child(gateway_id: GatewayId, gateway: BaseAsyncGateway, node_id: int, child: ChildSensor, value_type: int | None = None) -> defaultdict[Platform, list[DevId]]: ...
