import voluptuous as vol
from . import PyNUTData as PyNUTData, _unique_id_from_status as _unique_id_from_status
from .const import DEFAULT_HOST as DEFAULT_HOST, DEFAULT_PORT as DEFAULT_PORT, DOMAIN as DOMAIN
from _typeshed import Incomplete
from collections.abc import Mapping
from homeassistant.config_entries import ConfigEntry as ConfigEntry, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult
from homeassistant.const import CONF_ALIAS as CONF_ALIAS, CONF_BASE as CONF_BASE, CONF_HOST as CONF_HOST, CONF_PASSWORD as CONF_PASSWORD, CONF_PORT as CONF_PORT, CONF_USERNAME as CONF_USERNAME
from homeassistant.data_entry_flow import AbortFlow as AbortFlow
from homeassistant.helpers.service_info.zeroconf import ZeroconfServiceInfo as ZeroconfServiceInfo
from typing import Any

_LOGGER: Incomplete
REAUTH_SCHEMA: Incomplete
PASSWORD_NOT_CHANGED: str

def _base_schema(nut_config: Mapping[str, Any], use_password_not_changed: bool = False) -> vol.Schema: ...
def _ups_schema(ups_list: dict[str, str]) -> vol.Schema: ...
async def validate_input(data: dict[str, Any]) -> dict[str, Any]: ...
def _check_host_port_alias_match(first: Mapping[str, Any], second: Mapping[str, Any]) -> bool: ...
def _format_host_port_alias(user_input: Mapping[str, Any]) -> str: ...

class NutConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    nut_config: dict[str, Any]
    ups_list: dict[str, str] | None
    title: str | None
    reauth_entry: ConfigEntry | None
    def __init__(self) -> None: ...
    async def async_step_zeroconf(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_ups(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reconfigure_ups(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    def _host_port_alias_already_configured(self, user_input: dict[str, Any]) -> bool: ...
    async def _async_validate_or_error(self, config: dict[str, Any]) -> tuple[dict[str, Any], dict[str, str], dict[str, str]]: ...
    async def async_step_reauth(self, entry_data: Mapping[str, Any]) -> ConfigFlowResult: ...
    async def async_step_reauth_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
