import dataclasses
import python_otbr_api
from . import OTBRConfigEntry as OTBRConfigEntry
from .const import DOMAIN as DOMAIN
from _typeshed import Incomplete
from collections.abc import Callable as Callable, Coroutine
from homeassistant.components.homeassistant_hardware.silabs_multiprotocol_addon import MultiprotocolAddonManager as MultiprotocolAddonManager, get_multiprotocol_addon_manager as get_multiprotocol_addon_manager, is_multiprotocol_url as is_multiprotocol_url
from homeassistant.config_entries import SOURCE_USER as SOURCE_USER
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from typing import Any, Concatenate

_LOGGER: Incomplete
INSECURE_NETWORK_KEYS: Incomplete
INSECURE_PASSPHRASES: Incomplete

class GetBorderAgentIdNotSupported(HomeAssistantError): ...

def compose_default_network_name(pan_id: int) -> str: ...
def generate_random_pan_id() -> int: ...
def _handle_otbr_error[**_P, _R](func: Callable[Concatenate[OTBRData, _P], Coroutine[Any, Any, _R]]) -> Callable[Concatenate[OTBRData, _P], Coroutine[Any, Any, _R]]: ...

@dataclasses.dataclass
class OTBRData:
    url: str
    api: python_otbr_api.OTBR
    entry_id: str
    @_handle_otbr_error
    async def factory_reset(self, hass: HomeAssistant) -> None: ...
    @_handle_otbr_error
    async def get_border_agent_id(self) -> bytes: ...
    @_handle_otbr_error
    async def set_enabled(self, enabled: bool) -> None: ...
    @_handle_otbr_error
    async def get_active_dataset(self) -> python_otbr_api.ActiveDataSet | None: ...
    @_handle_otbr_error
    async def get_active_dataset_tlvs(self) -> bytes | None: ...
    @_handle_otbr_error
    async def get_pending_dataset_tlvs(self) -> bytes | None: ...
    @_handle_otbr_error
    async def create_active_dataset(self, dataset: python_otbr_api.ActiveDataSet) -> None: ...
    @_handle_otbr_error
    async def delete_active_dataset(self) -> None: ...
    @_handle_otbr_error
    async def set_active_dataset_tlvs(self, dataset: bytes) -> None: ...
    @_handle_otbr_error
    async def set_channel(self, channel: int, delay: float = ...) -> None: ...
    @_handle_otbr_error
    async def get_extended_address(self) -> bytes: ...
    @_handle_otbr_error
    async def get_coprocessor_version(self) -> str: ...

async def get_allowed_channel(hass: HomeAssistant, otbr_url: str) -> int | None: ...
async def _warn_on_channel_collision(hass: HomeAssistant, otbrdata: OTBRData, dataset_tlvs: bytes) -> None: ...
def _warn_on_default_network_settings(hass: HomeAssistant, otbrdata: OTBRData, dataset_tlvs: bytes) -> None: ...
async def update_issues(hass: HomeAssistant, otbrdata: OTBRData, dataset_tlvs: bytes) -> None: ...
async def update_unique_id(hass: HomeAssistant, entry: OTBRConfigEntry | None, border_agent_id: bytes) -> None: ...
