from .coordinator import QbusConfigEntry as QbusConfigEntry
from .entity import QbusEntity as QbusEntity, create_new_entities as create_new_entities
from _typeshed import Incomplete
from homeassistant.components.cover import ATTR_POSITION as ATTR_POSITION, ATTR_TILT_POSITION as ATTR_TILT_POSITION, CoverDeviceClass as CoverDeviceClass, CoverEntity as CoverEntity, CoverEntityFeature as CoverEntityFeature
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from qbusmqttapi.discovery import QbusMqttOutput as QbusMqttOutput
from qbusmqttapi.state import QbusMqttShutterState
from typing import Any

PARALLEL_UPDATES: int

async def async_setup_entry(hass: HomeAssistant, entry: QbusConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class QbusCover(QbusEntity, CoverEntity):
    _state_cls = QbusMqttShutterState
    _attr_name: Incomplete
    _attr_supported_features: CoverEntityFeature
    _attr_device_class: Incomplete
    _attr_assumed_state: bool
    _attr_current_cover_position: int
    _attr_current_cover_tilt_position: int
    _attr_is_closed: bool
    _target_shutter_position: int | None
    _target_slat_position: int | None
    _target_state: str | None
    _previous_state: str | None
    def __init__(self, mqtt_output: QbusMqttOutput) -> None: ...
    async def async_open_cover(self, **kwargs: Any) -> None: ...
    async def async_close_cover(self, **kwargs: Any) -> None: ...
    async def async_stop_cover(self, **kwargs: Any) -> None: ...
    async def async_set_cover_position(self, **kwargs: Any) -> None: ...
    async def async_open_cover_tilt(self, **kwargs: Any) -> None: ...
    async def async_close_cover_tilt(self, **kwargs: Any) -> None: ...
    async def async_set_cover_tilt_position(self, **kwargs: Any) -> None: ...
    async def _handle_state_received(self, state: QbusMqttShutterState) -> None: ...
    def _update_is_closed(self) -> None: ...
    def _update_cover_position(self) -> None: ...
    def _update_tilt_position(self) -> None: ...
