import RFXtrx as rfxtrxmod
from . import DOMAIN as DOMAIN, DeviceTuple as DeviceTuple, get_device_id as get_device_id, get_device_tuple_from_identifiers as get_device_tuple_from_identifiers, get_rfx_object as get_rfx_object
from .const import CONF_AUTOMATIC_ADD as CONF_AUTOMATIC_ADD, CONF_DATA_BITS as CONF_DATA_BITS, CONF_OFF_DELAY as CONF_OFF_DELAY, CONF_PROTOCOLS as CONF_PROTOCOLS, CONF_REPLACE_DEVICE as CONF_REPLACE_DEVICE, CONF_VENETIAN_BLIND_MODE as CONF_VENETIAN_BLIND_MODE, CONST_VENETIAN_BLIND_MODE_DEFAULT as CONST_VENETIAN_BLIND_MODE_DEFAULT, CONST_VENETIAN_BLIND_MODE_EU as CONST_VENETIAN_BLIND_MODE_EU, CONST_VENETIAN_BLIND_MODE_US as CONST_VENETIAN_BLIND_MODE_US, DEVICE_PACKET_TYPE_LIGHTING4 as DEVICE_PACKET_TYPE_LIGHTING4
from _typeshed import Incomplete
from homeassistant.config_entries import ConfigEntry as ConfigEntry, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, OptionsFlow as OptionsFlow
from homeassistant.const import CONF_COMMAND_OFF as CONF_COMMAND_OFF, CONF_COMMAND_ON as CONF_COMMAND_ON, CONF_DEVICE as CONF_DEVICE, CONF_DEVICES as CONF_DEVICES, CONF_DEVICE_ID as CONF_DEVICE_ID, CONF_HOST as CONF_HOST, CONF_PORT as CONF_PORT, CONF_TYPE as CONF_TYPE
from homeassistant.core import Event as Event, EventStateChangedData as EventStateChangedData, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers import device_registry as dr
from homeassistant.helpers.event import async_track_state_change_event as async_track_state_change_event
from homeassistant.helpers.typing import VolDictType as VolDictType
from typing import Any, TypedDict

CONF_EVENT_CODE: str
CONF_MANUAL_PATH: str
RECV_MODES: Incomplete

class DeviceData(TypedDict):
    event_code: str | None
    device_id: DeviceTuple

def none_or_int(value: str | None, base: int) -> int | None: ...

class RfxtrxOptionsFlow(OptionsFlow):
    _device_registry: dr.DeviceRegistry
    _device_entries: list[dr.DeviceEntry]
    _global_options: dict[str, Any]
    _selected_device: dict[str, Any]
    _selected_device_entry_id: str | None
    _selected_device_event_code: str | None
    _selected_device_object: rfxtrxmod.RFXtrxEvent | None
    def __init__(self) -> None: ...
    async def async_step_init(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_prompt_options(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_set_device_options(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_replace_device(self, replace_device: str) -> None: ...
    def _can_add_device(self, new_rfx_obj: rfxtrxmod.RFXtrxEvent) -> bool: ...
    def _can_replace_device(self, entry_id: str) -> bool: ...
    def _get_device_event_code(self, entry_id: str) -> str | None: ...
    def _get_device_data(self, entry_id: str) -> DeviceData: ...
    @callback
    def update_config_data(self, global_options: dict[str, Any] | None = None, devices: dict[str, Any] | None = None) -> None: ...

class RfxtrxConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_setup_network(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_setup_serial(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_setup_serial_manual_path(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_validate_rfx(self, host: str | None = None, port: int | None = None, device: str | None = None) -> dict[str, Any]: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: ConfigEntry) -> RfxtrxOptionsFlow: ...

def _test_transport(host: str | None, port: int | None, device: str | None) -> bool: ...
def get_serial_by_id(dev_path: str) -> str: ...

class CannotConnect(HomeAssistantError): ...
