from .const import CONF_SLEEP_PERIOD as CONF_SLEEP_PERIOD, DOMAIN as DOMAIN, LOGGER as LOGGER
from .coordinator import ShellyBlockCoordinator as ShellyBlockCoordinator, ShellyConfigEntry as ShellyConfigEntry, ShellyRpcCoordinator as ShellyRpcCoordinator
from .utils import async_remove_shelly_entity as async_remove_shelly_entity, get_block_device_info as get_block_device_info, get_block_entity_name as get_block_entity_name, get_rpc_device_info as get_rpc_device_info, get_rpc_entity_name as get_rpc_entity_name, get_rpc_key_instances as get_rpc_key_instances
from _typeshed import Incomplete
from aioshelly.block_device import Block as Block
from collections.abc import Awaitable, Callable as Callable, Coroutine, Mapping
from dataclasses import dataclass
from homeassistant.core import HomeAssistant as HomeAssistant, State as State, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.device_registry import DeviceInfo as DeviceInfo
from homeassistant.helpers.entity import Entity as Entity, EntityDescription as EntityDescription
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from homeassistant.helpers.entity_registry import RegistryEntry as RegistryEntry
from homeassistant.helpers.typing import StateType as StateType
from homeassistant.helpers.update_coordinator import CoordinatorEntity as CoordinatorEntity
from typing import Any, Concatenate

@callback
def async_setup_entry_attribute_entities(hass: HomeAssistant, config_entry: ShellyConfigEntry, async_add_entities: AddEntitiesCallback, sensors: Mapping[tuple[str, str], BlockEntityDescription], sensor_class: Callable) -> None: ...
@callback
def async_setup_block_attribute_entities(hass: HomeAssistant, async_add_entities: AddEntitiesCallback, coordinator: ShellyBlockCoordinator, sensors: Mapping[tuple[str, str], BlockEntityDescription], sensor_class: Callable) -> None: ...
@callback
def async_restore_block_attribute_entities(hass: HomeAssistant, config_entry: ShellyConfigEntry, async_add_entities: AddEntitiesCallback, coordinator: ShellyBlockCoordinator, sensors: Mapping[tuple[str, str], BlockEntityDescription], sensor_class: Callable) -> None: ...
@callback
def async_setup_entry_rpc(hass: HomeAssistant, config_entry: ShellyConfigEntry, async_add_entities: AddEntitiesCallback, sensors: Mapping[str, RpcEntityDescription], sensor_class: Callable) -> None: ...
@callback
def async_setup_rpc_attribute_entities(hass: HomeAssistant, config_entry: ShellyConfigEntry, async_add_entities: AddEntitiesCallback, sensors: Mapping[str, RpcEntityDescription], sensor_class: Callable) -> None: ...
@callback
def async_restore_rpc_attribute_entities(hass: HomeAssistant, config_entry: ShellyConfigEntry, async_add_entities: AddEntitiesCallback, coordinator: ShellyRpcCoordinator, sensors: Mapping[str, RpcEntityDescription], sensor_class: Callable) -> None: ...
@callback
def async_setup_entry_rest(hass: HomeAssistant, config_entry: ShellyConfigEntry, async_add_entities: AddEntitiesCallback, sensors: Mapping[str, RestEntityDescription], sensor_class: Callable) -> None: ...

@dataclass(frozen=True)
class BlockEntityDescription(EntityDescription):
    name: str = ...
    unit_fn: Callable[[dict], str] | None = ...
    value: Callable[[Any], Any] = ...
    available: Callable[[Block], bool] | None = ...
    removal_condition: Callable[[dict, Block], bool] | None = ...
    extra_state_attributes: Callable[[Block], dict | None] | None = ...

@dataclass(frozen=True, kw_only=True)
class RpcEntityDescription(EntityDescription):
    name: str = ...
    sub_key: str
    value: Callable[[Any, Any], Any] | None = ...
    available: Callable[[dict], bool] | None = ...
    removal_condition: Callable[[dict, dict, str], bool] | None = ...
    use_polling_coordinator: bool = ...
    supported: Callable = ...
    unit: Callable[[dict], str | None] | None = ...
    options_fn: Callable[[dict], list[str]] | None = ...
    entity_class: Callable | None = ...

@dataclass(frozen=True)
class RestEntityDescription(EntityDescription):
    name: str = ...
    value: Callable[[dict, Any], Any] | None = ...

def rpc_call[_T: ShellyRpcEntity, **_P](func: Callable[Concatenate[_T, _P], Awaitable[None]]) -> Callable[Concatenate[_T, _P], Coroutine[Any, Any, None]]: ...

class ShellyBlockEntity(CoordinatorEntity[ShellyBlockCoordinator]):
    _attr_has_entity_name: bool
    block: Incomplete
    _attr_name: Incomplete
    _attr_device_info: Incomplete
    _attr_unique_id: Incomplete
    def __init__(self, coordinator: ShellyBlockCoordinator, block: Block) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    @callback
    def _update_callback(self) -> None: ...
    async def set_state(self, **kwargs: Any) -> Any: ...

class ShellyRpcEntity(CoordinatorEntity[ShellyRpcCoordinator]):
    _attr_has_entity_name: bool
    key: Incomplete
    _attr_device_info: Incomplete
    _attr_unique_id: Incomplete
    _attr_name: Incomplete
    def __init__(self, coordinator: ShellyRpcCoordinator, key: str) -> None: ...
    @property
    def available(self) -> bool: ...
    @property
    def status(self) -> dict: ...
    async def async_added_to_hass(self) -> None: ...
    @callback
    def _update_callback(self) -> None: ...
    @rpc_call
    async def call_rpc(self, method: str, params: Any, timeout: float | None = None) -> Any: ...

class ShellyBlockAttributeEntity(ShellyBlockEntity, Entity):
    entity_description: BlockEntityDescription
    attribute: Incomplete
    _attr_unique_id: str
    _attr_name: Incomplete
    def __init__(self, coordinator: ShellyBlockCoordinator, block: Block, attribute: str, description: BlockEntityDescription) -> None: ...
    @property
    def attribute_value(self) -> StateType: ...
    @property
    def available(self) -> bool: ...
    @property
    def extra_state_attributes(self) -> dict[str, Any] | None: ...

class ShellyRestAttributeEntity(CoordinatorEntity[ShellyBlockCoordinator]):
    _attr_has_entity_name: bool
    entity_description: RestEntityDescription
    block_coordinator: Incomplete
    attribute: Incomplete
    _attr_name: Incomplete
    _attr_unique_id: Incomplete
    _attr_device_info: Incomplete
    _last_value: Incomplete
    def __init__(self, coordinator: ShellyBlockCoordinator, attribute: str, description: RestEntityDescription) -> None: ...
    @property
    def available(self) -> bool: ...
    @property
    def attribute_value(self) -> StateType: ...

class ShellyRpcAttributeEntity(ShellyRpcEntity, Entity):
    entity_description: RpcEntityDescription
    attribute: Incomplete
    _attr_unique_id: Incomplete
    _attr_name: Incomplete
    _last_value: Incomplete
    _id: Incomplete
    _attr_native_unit_of_measurement: Incomplete
    option_map: dict[str, str]
    reversed_option_map: dict[str, str]
    def __init__(self, coordinator: ShellyRpcCoordinator, key: str, attribute: str, description: RpcEntityDescription) -> None: ...
    @property
    def sub_status(self) -> Any: ...
    @property
    def attribute_value(self) -> StateType: ...
    @property
    def available(self) -> bool: ...

class ShellySleepingBlockAttributeEntity(ShellyBlockAttributeEntity):
    last_state: State | None
    coordinator: Incomplete
    attribute: Incomplete
    block: Block | None
    entity_description: Incomplete
    _attr_device_info: Incomplete
    _attr_unique_id: Incomplete
    _attr_name: Incomplete
    def __init__(self, coordinator: ShellyBlockCoordinator, block: Block | None, attribute: str, description: BlockEntityDescription, entry: RegistryEntry | None = None) -> None: ...
    @callback
    def _update_callback(self) -> None: ...
    async def async_update(self) -> None: ...

class ShellySleepingRpcAttributeEntity(ShellyRpcAttributeEntity):
    entity_description: RpcEntityDescription
    last_state: State | None
    coordinator: Incomplete
    key: Incomplete
    attribute: Incomplete
    _attr_device_info: Incomplete
    _attr_unique_id: Incomplete
    _last_value: Incomplete
    _attr_name: Incomplete
    def __init__(self, coordinator: ShellyRpcCoordinator, key: str, attribute: str, description: RpcEntityDescription, entry: RegistryEntry | None = None) -> None: ...
    async def async_update(self) -> None: ...

def get_entity_class(sensor_class: Callable, description: RpcEntityDescription) -> Callable: ...
def get_entity_block_device_info(coordinator: ShellyBlockCoordinator, block: Block | None = None) -> DeviceInfo: ...
def get_entity_rpc_device_info(coordinator: ShellyRpcCoordinator, key: str | None = None, emeter_phase: str | None = None) -> DeviceInfo: ...
