from .common import async_build_source_set as async_build_source_set
from .const import DOMAIN as DOMAIN
from _typeshed import Incomplete
from async_upnp_client.const import AddressTupleVXType as AddressTupleVXType, DeviceOrServiceType as DeviceOrServiceType, SsdpSource
from async_upnp_client.description_cache import DescriptionCache
from async_upnp_client.ssdp_listener import SsdpDevice as SsdpDevice, SsdpListener
from async_upnp_client.utils import CaseInsensitiveDict
from collections.abc import Callable as Callable, Coroutine, Mapping
from homeassistant import config_entries as config_entries
from homeassistant.const import EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP, MATCH_ALL as MATCH_ALL
from homeassistant.core import HassJob as HassJob, HomeAssistant as HomeAssistant, callback as core_callback
from homeassistant.helpers import discovery_flow as discovery_flow
from homeassistant.helpers.aiohttp_client import async_get_clientsession as async_get_clientsession
from homeassistant.helpers.dispatcher import async_dispatcher_connect as async_dispatcher_connect
from homeassistant.helpers.event import async_track_time_interval as async_track_time_interval
from homeassistant.helpers.service_info.ssdp import SsdpServiceInfo as _SsdpServiceInfo
from homeassistant.util.async_ import create_eager_task as create_eager_task
from typing import Any

SCAN_INTERVAL: Incomplete
IPV4_BROADCAST: Incomplete
PRIMARY_MATCH_KEYS: Incomplete
_LOGGER: Incomplete
SsdpChange: Incomplete
type SsdpHassJobCallback = HassJob[[_SsdpServiceInfo, SsdpChange], Coroutine[Any, Any, None] | None]
SSDP_SOURCE_SSDP_CHANGE_MAPPING: Mapping[SsdpSource, SsdpChange]

@core_callback
def _async_process_callbacks(hass: HomeAssistant, callbacks: list[SsdpHassJobCallback], discovery_info: _SsdpServiceInfo, ssdp_change: SsdpChange) -> None: ...
@core_callback
def _async_headers_match(headers: CaseInsensitiveDict, lower_match_dict: dict[str, str]) -> bool: ...

class IntegrationMatchers:
    _match_by_key: dict[str, dict[str, list[tuple[str, dict[str, str]]]]] | None
    def __init__(self) -> None: ...
    @core_callback
    def async_setup(self, integration_matchers: dict[str, list[dict[str, str]]]) -> None: ...
    @core_callback
    def async_matching_domains(self, info_with_desc: CaseInsensitiveDict) -> set[str]: ...

class Scanner:
    hass: Incomplete
    _cancel_scan: Callable[[], None] | None
    _ssdp_listeners: list[SsdpListener]
    _device_tracker: Incomplete
    _callbacks: list[tuple[SsdpHassJobCallback, dict[str, str]]]
    _description_cache: DescriptionCache | None
    integration_matchers: Incomplete
    def __init__(self, hass: HomeAssistant, integration_matchers: IntegrationMatchers) -> None: ...
    @property
    def _ssdp_devices(self) -> list[SsdpDevice]: ...
    async def async_register_callback(self, callback: SsdpHassJobCallback, match_dict: dict[str, str] | None = None) -> Callable[[], None]: ...
    async def async_stop(self, *_: Any) -> None: ...
    async def _async_stop_ssdp_listeners(self) -> None: ...
    async def async_scan(self, *_: Any) -> None: ...
    async def async_scan_multicast(self, *_: Any) -> None: ...
    async def async_scan_broadcast(self, *_: Any) -> None: ...
    async def async_start(self) -> None: ...
    async def _async_start_ssdp_listeners(self) -> None: ...
    @core_callback
    def _async_get_matching_callbacks(self, combined_headers: CaseInsensitiveDict) -> list[SsdpHassJobCallback]: ...
    def _ssdp_listener_callback(self, ssdp_device: SsdpDevice, dst: DeviceOrServiceType, source: SsdpSource) -> None: ...
    async def _ssdp_listener_process_callback_with_lookup(self, ssdp_device: SsdpDevice, dst: DeviceOrServiceType, source: SsdpSource) -> None: ...
    def _ssdp_listener_process_callback(self, ssdp_device: SsdpDevice, dst: DeviceOrServiceType, source: SsdpSource, info_desc: Mapping[str, Any], skip_callbacks: bool = False) -> None: ...
    def _async_dismiss_discoveries(self, byebye_discovery_info: _SsdpServiceInfo) -> None: ...
    async def _async_get_description_dict(self, location: str | None) -> Mapping[str, str]: ...
    async def _async_headers_to_discovery_info(self, ssdp_device: SsdpDevice, headers: CaseInsensitiveDict) -> _SsdpServiceInfo: ...
    async def async_get_discovery_info_by_udn_st(self, udn: str, st: str) -> _SsdpServiceInfo | None: ...
    async def async_get_discovery_info_by_st(self, st: str) -> list[_SsdpServiceInfo]: ...
    async def async_get_discovery_info_by_udn(self, udn: str) -> list[_SsdpServiceInfo]: ...
    @core_callback
    def _handle_config_entry_removed(self, entry: config_entries.ConfigEntry) -> None: ...

def discovery_info_from_headers_and_description(ssdp_device: SsdpDevice, combined_headers: CaseInsensitiveDict, info_desc: Mapping[str, Any]) -> _SsdpServiceInfo: ...
def _udn_from_usn(usn: str | None) -> str | None: ...
