import abc
import io
from .const import ATTR_ARGS as ATTR_ARGS, ATTR_AUTHENTICATION as ATTR_AUTHENTICATION, ATTR_CAPTION as ATTR_CAPTION, ATTR_CHAT_ID as ATTR_CHAT_ID, ATTR_CHAT_INSTANCE as ATTR_CHAT_INSTANCE, ATTR_DATA as ATTR_DATA, ATTR_DATE as ATTR_DATE, ATTR_DISABLE_NOTIF as ATTR_DISABLE_NOTIF, ATTR_DISABLE_WEB_PREV as ATTR_DISABLE_WEB_PREV, ATTR_FILE as ATTR_FILE, ATTR_FROM_FIRST as ATTR_FROM_FIRST, ATTR_FROM_LAST as ATTR_FROM_LAST, ATTR_KEYBOARD as ATTR_KEYBOARD, ATTR_KEYBOARD_INLINE as ATTR_KEYBOARD_INLINE, ATTR_MESSAGE as ATTR_MESSAGE, ATTR_MESSAGEID as ATTR_MESSAGEID, ATTR_MESSAGE_TAG as ATTR_MESSAGE_TAG, ATTR_MESSAGE_THREAD_ID as ATTR_MESSAGE_THREAD_ID, ATTR_MSG as ATTR_MSG, ATTR_MSGID as ATTR_MSGID, ATTR_ONE_TIME_KEYBOARD as ATTR_ONE_TIME_KEYBOARD, ATTR_OPEN_PERIOD as ATTR_OPEN_PERIOD, ATTR_PARSER as ATTR_PARSER, ATTR_PASSWORD as ATTR_PASSWORD, ATTR_REPLYMARKUP as ATTR_REPLYMARKUP, ATTR_REPLY_TO_MSGID as ATTR_REPLY_TO_MSGID, ATTR_RESIZE_KEYBOARD as ATTR_RESIZE_KEYBOARD, ATTR_STICKER_ID as ATTR_STICKER_ID, ATTR_TEXT as ATTR_TEXT, ATTR_TIMEOUT as ATTR_TIMEOUT, ATTR_TITLE as ATTR_TITLE, ATTR_URL as ATTR_URL, ATTR_USERNAME as ATTR_USERNAME, ATTR_USER_ID as ATTR_USER_ID, ATTR_VERIFY_SSL as ATTR_VERIFY_SSL, CONF_CHAT_ID as CONF_CHAT_ID, CONF_PROXY_URL as CONF_PROXY_URL, DOMAIN as DOMAIN, EVENT_TELEGRAM_CALLBACK as EVENT_TELEGRAM_CALLBACK, EVENT_TELEGRAM_COMMAND as EVENT_TELEGRAM_COMMAND, EVENT_TELEGRAM_SENT as EVENT_TELEGRAM_SENT, EVENT_TELEGRAM_TEXT as EVENT_TELEGRAM_TEXT, PARSER_HTML as PARSER_HTML, PARSER_MD as PARSER_MD, PARSER_MD2 as PARSER_MD2, PARSER_PLAIN_TEXT as PARSER_PLAIN_TEXT, SERVICE_EDIT_CAPTION as SERVICE_EDIT_CAPTION, SERVICE_EDIT_MESSAGE as SERVICE_EDIT_MESSAGE, SERVICE_SEND_ANIMATION as SERVICE_SEND_ANIMATION, SERVICE_SEND_DOCUMENT as SERVICE_SEND_DOCUMENT, SERVICE_SEND_PHOTO as SERVICE_SEND_PHOTO, SERVICE_SEND_STICKER as SERVICE_SEND_STICKER, SERVICE_SEND_VIDEO as SERVICE_SEND_VIDEO, SERVICE_SEND_VOICE as SERVICE_SEND_VOICE
from _typeshed import Incomplete
from abc import abstractmethod
from collections.abc import Callable as Callable, Sequence
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import ATTR_COMMAND as ATTR_COMMAND, CONF_API_KEY as CONF_API_KEY, HTTP_BASIC_AUTHENTICATION as HTTP_BASIC_AUTHENTICATION, HTTP_BEARER_AUTHENTICATION as HTTP_BEARER_AUTHENTICATION, HTTP_DIGEST_AUTHENTICATION as HTTP_DIGEST_AUTHENTICATION
from homeassistant.core import Context as Context, HomeAssistant as HomeAssistant
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError, ServiceValidationError as ServiceValidationError
from homeassistant.util.ssl import get_default_context as get_default_context, get_default_no_verify_context as get_default_no_verify_context
from ssl import SSLContext
from telegram import Bot, CallbackQuery as CallbackQuery, InputPollOption as InputPollOption, Message, Update as Update, User as User
from telegram.ext import CallbackContext as CallbackContext
from types import MappingProxyType
from typing import Any

_LOGGER: Incomplete
type TelegramBotConfigEntry = ConfigEntry[TelegramNotificationService]

def _get_bot_info(bot: Bot, config_entry: ConfigEntry) -> dict[str, Any]: ...

class BaseTelegramBot(metaclass=abc.ABCMeta):
    hass: Incomplete
    config: Incomplete
    _bot: Incomplete
    def __init__(self, hass: HomeAssistant, config: TelegramBotConfigEntry, bot: Bot) -> None: ...
    @abstractmethod
    async def shutdown(self) -> None: ...
    async def handle_update(self, update: Update, context: CallbackContext) -> bool: ...
    @staticmethod
    def _get_command_event_data(command_text: str | None) -> dict[str, str | list]: ...
    def _get_message_event_data(self, message: Message) -> tuple[str, dict[str, Any]]: ...
    def _get_user_event_data(self, user: User) -> dict[str, Any]: ...
    def _get_callback_query_event_data(self, callback_query: CallbackQuery) -> tuple[str, dict[str, Any]]: ...
    def authorize_update(self, update: Update) -> bool: ...

class TelegramNotificationService:
    app: Incomplete
    config: Incomplete
    _parsers: dict[str, str | None]
    parse_mode: Incomplete
    bot: Incomplete
    hass: Incomplete
    _last_message_id: dict[int, int]
    def __init__(self, hass: HomeAssistant, app: BaseTelegramBot, bot: Bot, config: TelegramBotConfigEntry, parser: str) -> None: ...
    def _get_allowed_chat_ids(self) -> list[int]: ...
    def _get_msg_ids(self, msg_data: dict[str, Any], chat_id: int) -> tuple[Any | None, int | None]: ...
    def get_target_chat_ids(self, target: int | list[int] | None) -> list[int]: ...
    def _get_msg_kwargs(self, data: dict[str, Any]) -> dict[str, Any]: ...
    async def _send_msg(self, func_send: Callable, msg_error: str, message_tag: str | None, *args_msg: Any, context: Context | None = None, **kwargs_msg: Any) -> Any: ...
    async def send_message(self, message: str = '', target: Any = None, context: Context | None = None, **kwargs: dict[str, Any]) -> dict[int, int]: ...
    async def delete_message(self, chat_id: int | None = None, context: Context | None = None, **kwargs: dict[str, Any]) -> bool: ...
    async def edit_message(self, type_edit: str, chat_id: int | None = None, context: Context | None = None, **kwargs: dict[str, Any]) -> Any: ...
    async def answer_callback_query(self, message: str | None, callback_query_id: str, show_alert: bool = False, context: Context | None = None, **kwargs: dict[str, Any]) -> None: ...
    async def send_file(self, file_type: str, target: Any = None, context: Context | None = None, **kwargs: Any) -> dict[int, int]: ...
    async def send_sticker(self, target: Any = None, context: Context | None = None, **kwargs: Any) -> dict[int, int]: ...
    async def send_location(self, latitude: Any, longitude: Any, target: Any = None, context: Context | None = None, **kwargs: dict[str, Any]) -> dict[int, int]: ...
    async def send_poll(self, question: str, options: Sequence[str | InputPollOption], is_anonymous: bool | None, allows_multiple_answers: bool | None, target: Any = None, context: Context | None = None, **kwargs: dict[str, Any]) -> dict[int, int]: ...
    async def leave_chat(self, chat_id: int | None = None, context: Context | None = None, **kwargs: dict[str, Any]) -> Any: ...
    async def set_message_reaction(self, reaction: str, chat_id: int | None = None, is_big: bool = False, context: Context | None = None, **kwargs: dict[str, Any]) -> None: ...

def initialize_bot(hass: HomeAssistant, p_config: MappingProxyType[str, Any]) -> Bot: ...
async def load_data(hass: HomeAssistant, url: str | None, filepath: str | None, username: str, password: str, authentication: str | None, verify_ssl: SSLContext, num_retries: int = 5) -> io.BytesIO: ...
def _validate_credentials_input(authentication: str | None, username: str | None, password: str | None) -> None: ...
def _read_file_as_bytesio(file_path: str) -> io.BytesIO: ...
