from .const import COVER_POSITION_PROPERTY_KEYS as COVER_POSITION_PROPERTY_KEYS, COVER_TILT_PROPERTY_KEYS as COVER_TILT_PROPERTY_KEYS, LOGGER as LOGGER
from .discovery_data_template import BaseDiscoverySchemaDataTemplate as BaseDiscoverySchemaDataTemplate, ConfigurableFanValueMappingDataTemplate as ConfigurableFanValueMappingDataTemplate, CoverTiltDataTemplate as CoverTiltDataTemplate, DynamicCurrentTempClimateDataTemplate as DynamicCurrentTempClimateDataTemplate, FanValueMapping as FanValueMapping, FixedFanValueMappingDataTemplate as FixedFanValueMappingDataTemplate, NumericSensorDataTemplate as NumericSensorDataTemplate
from .entity import NewZwaveDiscoveryInfo as NewZwaveDiscoveryInfo
from .models import FirmwareVersionRange as FirmwareVersionRange, NewZWaveDiscoverySchema as NewZWaveDiscoverySchema, ValueType as ValueType, ZWaveValueDiscoverySchema as ZWaveValueDiscoverySchema, ZwaveDiscoveryInfo as ZwaveDiscoveryInfo, ZwaveValueID as ZwaveValueID
from _typeshed import Incomplete
from collections.abc import Generator
from dataclasses import dataclass
from homeassistant.const import EntityCategory as EntityCategory, Platform as Platform
from homeassistant.core import callback as callback
from homeassistant.helpers.device_registry import DeviceEntry as DeviceEntry
from zwave_js_server.model.node import Node as ZwaveNode
from zwave_js_server.model.value import ConfigurationValue, Value as ZwaveValue

NEW_DISCOVERY_SCHEMAS: dict[Platform, list[NewZWaveDiscoverySchema]]
SUPPORTED_PLATFORMS: Incomplete

@dataclass
class ZWaveDiscoverySchema:
    platform: Platform
    primary_value: ZWaveValueDiscoverySchema
    hint: str | None = ...
    data_template: BaseDiscoverySchemaDataTemplate | None = ...
    manufacturer_id: set[int] | None = ...
    product_id: set[int] | None = ...
    product_type: set[int] | None = ...
    firmware_version_range: FirmwareVersionRange | None = ...
    device_class_generic: set[str] | None = ...
    device_class_specific: set[str] | None = ...
    required_values: list[ZWaveValueDiscoverySchema] | None = ...
    absent_values: list[ZWaveValueDiscoverySchema] | None = ...
    allow_multi: bool = ...
    assumed_state: bool = ...
    entity_registry_enabled_default: bool = ...
    entity_category: EntityCategory | None = ...

DOOR_LOCK_CURRENT_MODE_SCHEMA: Incomplete
SWITCH_MULTILEVEL_CURRENT_VALUE_SCHEMA: Incomplete
SWITCH_MULTILEVEL_TARGET_VALUE_SCHEMA: Incomplete
SWITCH_BINARY_CURRENT_VALUE_SCHEMA: Incomplete
COLOR_SWITCH_CURRENT_VALUE_SCHEMA: Incomplete
SIREN_TONE_SCHEMA: Incomplete
WINDOW_COVERING_COVER_CURRENT_VALUE_SCHEMA: Incomplete
WINDOW_COVERING_SLAT_CURRENT_VALUE_SCHEMA: Incomplete
DISCOVERY_SCHEMAS: Incomplete

@callback
def async_discover_node_values(node: ZwaveNode, device: DeviceEntry, discovered_value_ids: dict[str, set[str]]) -> Generator[ZwaveDiscoveryInfo | NewZwaveDiscoveryInfo]: ...
@callback
def async_discover_single_value(value: ZwaveValue, device: DeviceEntry, discovered_value_ids: dict[str, set[str]]) -> Generator[ZwaveDiscoveryInfo | NewZwaveDiscoveryInfo]: ...
@callback
def async_discover_single_configuration_value(value: ConfigurationValue) -> Generator[ZwaveDiscoveryInfo]: ...
@callback
def check_value(value: ZwaveValue, schema: ZWaveValueDiscoverySchema, primary_value: ZwaveValue | None = None) -> bool: ...
