import logging
from . import discovery as discovery, entity as entity, service as service
from .entity_platform import EntityPlatform as EntityPlatform, async_calculate_suggested_object_id as async_calculate_suggested_object_id
from .typing import ConfigType as ConfigType, DiscoveryInfoType as DiscoveryInfoType, VolDictType as VolDictType, VolSchemaType as VolSchemaType
from _typeshed import Incomplete
from collections.abc import Callable as Callable, Iterable
from datetime import timedelta
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import CONF_ENTITY_NAMESPACE as CONF_ENTITY_NAMESPACE, CONF_SCAN_INTERVAL as CONF_SCAN_INTERVAL, EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP
from homeassistant.core import Event as Event, HassJob as HassJob, HassJobType as HassJobType, HomeAssistant as HomeAssistant, ServiceCall as ServiceCall, ServiceResponse as ServiceResponse, SupportsResponse as SupportsResponse, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.loader import async_get_integration as async_get_integration, bind_hass as bind_hass
from homeassistant.setup import async_prepare_setup_platform as async_prepare_setup_platform
from homeassistant.util.hass_dict import HassKey as HassKey
from types import ModuleType
from typing import Any

DEFAULT_SCAN_INTERVAL: Incomplete
DATA_INSTANCES: HassKey[dict[str, EntityComponent]]

@bind_hass
async def async_update_entity(hass: HomeAssistant, entity_id: str) -> None: ...
@callback
def async_get_entity_suggested_object_id(hass: HomeAssistant, entity_id: str) -> str | None: ...

class EntityComponent[_EntityT: entity.Entity = entity.Entity]:
    logger: Incomplete
    hass: Incomplete
    domain: Incomplete
    scan_interval: Incomplete
    config: ConfigType | None
    _platforms: dict[str | tuple[str, timedelta | None, str | None], EntityPlatform]
    async_add_entities: Incomplete
    add_entities: Incomplete
    _entities: dict[str, entity.Entity]
    def __init__(self, logger: logging.Logger, domain: str, hass: HomeAssistant, scan_interval: timedelta = ...) -> None: ...
    @property
    def entities(self) -> Iterable[_EntityT]: ...
    def get_entity(self, entity_id: str) -> _EntityT | None: ...
    def register_shutdown(self) -> None: ...
    def setup(self, config: ConfigType) -> None: ...
    async def async_setup(self, config: ConfigType) -> None: ...
    async def _async_component_platform_discovered(self, platform: str, info: dict[str, Any] | None) -> None: ...
    async def async_setup_entry(self, config_entry: ConfigEntry) -> bool: ...
    async def async_unload_entry(self, config_entry: ConfigEntry) -> bool: ...
    async def async_extract_from_service(self, service_call: ServiceCall, expand_group: bool = True) -> list[_EntityT]: ...
    @callback
    def async_register_legacy_entity_service(self, name: str, schema: VolDictType | VolSchemaType, func: str | Callable[..., Any], required_features: list[int] | None = None, supports_response: SupportsResponse = ...) -> None: ...
    @callback
    def async_register_entity_service(self, name: str, schema: VolDictType | VolSchemaType | None, func: str | Callable[..., Any], required_features: list[int] | None = None, supports_response: SupportsResponse = ...) -> None: ...
    async def async_setup_platform(self, platform_type: str, platform_config: ConfigType, discovery_info: DiscoveryInfoType | None = None) -> None: ...
    async def _async_reset(self) -> None: ...
    async def async_remove_entity(self, entity_id: str) -> None: ...
    async def async_prepare_reload(self, *, skip_reset: bool = False) -> ConfigType | None: ...
    @callback
    def _async_init_entity_platform(self, platform_type: str, platform: ModuleType | None, scan_interval: timedelta | None = None, entity_namespace: str | None = None) -> EntityPlatform: ...
    @callback
    def _async_shutdown(self, event: Event) -> None: ...
