from _typeshed import Incomplete
from collections.abc import Iterable
from dataclasses import dataclass
from homeassistant.const import MATCH_ALL as MATCH_ALL

SEPARATOR_RE: Incomplete
SAME_LANGUAGES: Incomplete

def preferred_regions(language: str, country: str | None = None, code: str | None = None) -> Iterable[str]: ...
def is_region(language: str, region: str | None) -> bool: ...
def is_language_match(lang_1: str, lang_2: str) -> bool: ...

@dataclass
class Dialect:
    language: str
    region: str | None
    code: str | None = ...
    def __post_init__(self) -> None: ...
    def score(self, dialect: Dialect, country: str | None = None) -> tuple[float, float]: ...
    @staticmethod
    def parse(tag: str) -> Dialect: ...

def matches(target: str, supported: Iterable[str], country: str | None = None) -> list[str]: ...
def intersect(languages_1: set[str], languages_2: set[str]) -> set[str]: ...
