# mypy-boto3-pinpoint<a id="mypy-boto3-pinpoint"></a>

[![PyPI - mypy-boto3-pinpoint](https://img.shields.io/pypi/v/mypy-boto3-pinpoint.svg?color=blue)](https://pypi.org/project/mypy-boto3-pinpoint)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-pinpoint.svg?color=blue)](https://pypi.org/project/mypy-boto3-pinpoint)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-pinpoint?color=blue)](https://pypistats.org/packages/mypy-boto3-pinpoint)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Pinpoint 1.17.85](https://boto3.amazonaws.com/v1/documentation/api/1.17.85/reference/services/pinpoint.html#Pinpoint)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-pinpoint docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pinpoint/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-pinpoint](#mypy-boto3-pinpoint)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `Pinpoint` service.

```bash
python -m pip install boto3-stubs[pinpoint]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[pinpoint]` in your environment:
  `python -m pip install 'boto3-stubs[pinpoint]'`

Both type checking and auto-complete should work for `Pinpoint` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[pinpoint]` in your environment:
  `python -m pip install 'boto3-stubs[pinpoint]'`

Both type checking and auto-complete should work for `Pinpoint` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[pinpoint]` in your environment:
  `python -m pip install 'boto3-stubs[pinpoint]'`
- Run `mypy` as usual

Type checking should work for `Pinpoint` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[pinpoint]` in your environment:
  `python -m pip install 'boto3-stubs[pinpoint]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Pinpoint` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`PinpointClient` provides annotations for `boto3.client("pinpoint")`.

```python
import boto3

from mypy_boto3_pinpoint import PinpointClient

client: PinpointClient = boto3.client("pinpoint")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: PinpointClient = session.client("pinpoint")
```

### Literals<a id="literals"></a>

`mypy_boto3_pinpoint.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_pinpoint.literals import (
    ActionType,
    AttributeTypeType,
    CampaignStatusType,
    ChannelTypeType,
    DeliveryStatusType,
    DimensionTypeType,
    DurationType,
    FilterTypeType,
    FormatType,
    FrequencyType,
    IncludeType,
    JobStatusType,
    MessageTypeType,
    ModeType,
    OperatorType,
    RecencyTypeType,
    SegmentTypeType,
    SourceTypeType,
    StateType,
    TemplateTypeType,
    TypeType,
    __EndpointTypesElementType,
)

def check_value(value: ActionType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_pinpoint.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_pinpoint.type_defs import (
    ADMChannelRequestTypeDef,
    ADMChannelResponseTypeDef,
    ADMMessageTypeDef,
    APNSChannelRequestTypeDef,
    APNSChannelResponseTypeDef,
    APNSMessageTypeDef,
    APNSPushNotificationTemplateTypeDef,
    APNSSandboxChannelRequestTypeDef,
    APNSSandboxChannelResponseTypeDef,
    APNSVoipChannelRequestTypeDef,
    APNSVoipChannelResponseTypeDef,
    APNSVoipSandboxChannelRequestTypeDef,
    APNSVoipSandboxChannelResponseTypeDef,
    ActivitiesResponseTypeDef,
    ActivityResponseTypeDef,
    ActivityTypeDef,
    AddressConfigurationTypeDef,
    AndroidPushNotificationTemplateTypeDef,
    ApplicationDateRangeKpiResponseTypeDef,
    ApplicationResponseTypeDef,
    ApplicationSettingsResourceTypeDef,
    ApplicationsResponseTypeDef,
    AttributeDimensionTypeDef,
    AttributesResourceTypeDef,
    BaiduChannelRequestTypeDef,
    BaiduChannelResponseTypeDef,
    BaiduMessageTypeDef,
    BaseKpiResultTypeDef,
    CampaignCustomMessageTypeDef,
    CampaignDateRangeKpiResponseTypeDef,
    CampaignEmailMessageTypeDef,
    CampaignEventFilterTypeDef,
    CampaignHookTypeDef,
    CampaignLimitsTypeDef,
    CampaignResponseTypeDef,
    CampaignSmsMessageTypeDef,
    CampaignStateTypeDef,
    CampaignsResponseTypeDef,
    ChannelResponseTypeDef,
    ChannelsResponseTypeDef,
    ConditionTypeDef,
    ConditionalSplitActivityTypeDef,
    CreateAppResponseTypeDef,
    CreateApplicationRequestTypeDef,
    CreateCampaignResponseTypeDef,
    CreateEmailTemplateResponseTypeDef,
    CreateExportJobResponseTypeDef,
    CreateImportJobResponseTypeDef,
    CreateJourneyResponseTypeDef,
    CreatePushTemplateResponseTypeDef,
    CreateRecommenderConfigurationResponseTypeDef,
    CreateRecommenderConfigurationTypeDef,
    CreateSegmentResponseTypeDef,
    CreateSmsTemplateResponseTypeDef,
    CreateTemplateMessageBodyTypeDef,
    CreateVoiceTemplateResponseTypeDef,
    CustomDeliveryConfigurationTypeDef,
    CustomMessageActivityTypeDef,
    DefaultMessageTypeDef,
    DefaultPushNotificationMessageTypeDef,
    DefaultPushNotificationTemplateTypeDef,
    DeleteAdmChannelResponseTypeDef,
    DeleteApnsChannelResponseTypeDef,
    DeleteApnsSandboxChannelResponseTypeDef,
    DeleteApnsVoipChannelResponseTypeDef,
    DeleteApnsVoipSandboxChannelResponseTypeDef,
    DeleteAppResponseTypeDef,
    DeleteBaiduChannelResponseTypeDef,
    DeleteCampaignResponseTypeDef,
    DeleteEmailChannelResponseTypeDef,
    DeleteEmailTemplateResponseTypeDef,
    DeleteEndpointResponseTypeDef,
    DeleteEventStreamResponseTypeDef,
    DeleteGcmChannelResponseTypeDef,
    DeleteJourneyResponseTypeDef,
    DeletePushTemplateResponseTypeDef,
    DeleteRecommenderConfigurationResponseTypeDef,
    DeleteSegmentResponseTypeDef,
    DeleteSmsChannelResponseTypeDef,
    DeleteSmsTemplateResponseTypeDef,
    DeleteUserEndpointsResponseTypeDef,
    DeleteVoiceChannelResponseTypeDef,
    DeleteVoiceTemplateResponseTypeDef,
    DirectMessageConfigurationTypeDef,
    EmailChannelRequestTypeDef,
    EmailChannelResponseTypeDef,
    EmailMessageActivityTypeDef,
    EmailMessageTypeDef,
    EmailTemplateRequestTypeDef,
    EmailTemplateResponseTypeDef,
    EndpointBatchItemTypeDef,
    EndpointBatchRequestTypeDef,
    EndpointDemographicTypeDef,
    EndpointItemResponseTypeDef,
    EndpointLocationTypeDef,
    EndpointMessageResultTypeDef,
    EndpointRequestTypeDef,
    EndpointResponseTypeDef,
    EndpointSendConfigurationTypeDef,
    EndpointUserTypeDef,
    EndpointsResponseTypeDef,
    EventConditionTypeDef,
    EventDimensionsTypeDef,
    EventFilterTypeDef,
    EventItemResponseTypeDef,
    EventStartConditionTypeDef,
    EventStreamTypeDef,
    EventTypeDef,
    EventsBatchTypeDef,
    EventsRequestTypeDef,
    EventsResponseTypeDef,
    ExportJobRequestTypeDef,
    ExportJobResourceTypeDef,
    ExportJobResponseTypeDef,
    ExportJobsResponseTypeDef,
    GCMChannelRequestTypeDef,
    GCMChannelResponseTypeDef,
    GCMMessageTypeDef,
    GPSCoordinatesTypeDef,
    GPSPointDimensionTypeDef,
    GetAdmChannelResponseTypeDef,
    GetApnsChannelResponseTypeDef,
    GetApnsSandboxChannelResponseTypeDef,
    GetApnsVoipChannelResponseTypeDef,
    GetApnsVoipSandboxChannelResponseTypeDef,
    GetAppResponseTypeDef,
    GetApplicationDateRangeKpiResponseTypeDef,
    GetApplicationSettingsResponseTypeDef,
    GetAppsResponseTypeDef,
    GetBaiduChannelResponseTypeDef,
    GetCampaignActivitiesResponseTypeDef,
    GetCampaignDateRangeKpiResponseTypeDef,
    GetCampaignResponseTypeDef,
    GetCampaignVersionResponseTypeDef,
    GetCampaignVersionsResponseTypeDef,
    GetCampaignsResponseTypeDef,
    GetChannelsResponseTypeDef,
    GetEmailChannelResponseTypeDef,
    GetEmailTemplateResponseTypeDef,
    GetEndpointResponseTypeDef,
    GetEventStreamResponseTypeDef,
    GetExportJobResponseTypeDef,
    GetExportJobsResponseTypeDef,
    GetGcmChannelResponseTypeDef,
    GetImportJobResponseTypeDef,
    GetImportJobsResponseTypeDef,
    GetJourneyDateRangeKpiResponseTypeDef,
    GetJourneyExecutionActivityMetricsResponseTypeDef,
    GetJourneyExecutionMetricsResponseTypeDef,
    GetJourneyResponseTypeDef,
    GetPushTemplateResponseTypeDef,
    GetRecommenderConfigurationResponseTypeDef,
    GetRecommenderConfigurationsResponseTypeDef,
    GetSegmentExportJobsResponseTypeDef,
    GetSegmentImportJobsResponseTypeDef,
    GetSegmentResponseTypeDef,
    GetSegmentVersionResponseTypeDef,
    GetSegmentVersionsResponseTypeDef,
    GetSegmentsResponseTypeDef,
    GetSmsChannelResponseTypeDef,
    GetSmsTemplateResponseTypeDef,
    GetUserEndpointsResponseTypeDef,
    GetVoiceChannelResponseTypeDef,
    GetVoiceTemplateResponseTypeDef,
    HoldoutActivityTypeDef,
    ImportJobRequestTypeDef,
    ImportJobResourceTypeDef,
    ImportJobResponseTypeDef,
    ImportJobsResponseTypeDef,
    ItemResponseTypeDef,
    JourneyCustomMessageTypeDef,
    JourneyDateRangeKpiResponseTypeDef,
    JourneyEmailMessageTypeDef,
    JourneyExecutionActivityMetricsResponseTypeDef,
    JourneyExecutionMetricsResponseTypeDef,
    JourneyLimitsTypeDef,
    JourneyPushMessageTypeDef,
    JourneyResponseTypeDef,
    JourneySMSMessageTypeDef,
    JourneyScheduleTypeDef,
    JourneyStateRequestTypeDef,
    JourneysResponseTypeDef,
    ListJourneysResponseTypeDef,
    ListRecommenderConfigurationsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTemplateVersionsResponseTypeDef,
    ListTemplatesResponseTypeDef,
    MessageBodyTypeDef,
    MessageConfigurationTypeDef,
    MessageRequestTypeDef,
    MessageResponseTypeDef,
    MessageResultTypeDef,
    MessageTypeDef,
    MetricDimensionTypeDef,
    MultiConditionalBranchTypeDef,
    MultiConditionalSplitActivityTypeDef,
    NumberValidateRequestTypeDef,
    NumberValidateResponseTypeDef,
    PhoneNumberValidateResponseTypeDef,
    PublicEndpointTypeDef,
    PushMessageActivityTypeDef,
    PushNotificationTemplateRequestTypeDef,
    PushNotificationTemplateResponseTypeDef,
    PutEventStreamResponseTypeDef,
    PutEventsResponseTypeDef,
    QuietTimeTypeDef,
    RandomSplitActivityTypeDef,
    RandomSplitEntryTypeDef,
    RawEmailTypeDef,
    RecencyDimensionTypeDef,
    RecommenderConfigurationResponseTypeDef,
    RemoveAttributesResponseTypeDef,
    ResultRowTypeDef,
    ResultRowValueTypeDef,
    SMSChannelRequestTypeDef,
    SMSChannelResponseTypeDef,
    SMSMessageActivityTypeDef,
    SMSMessageTypeDef,
    SMSTemplateRequestTypeDef,
    SMSTemplateResponseTypeDef,
    ScheduleTypeDef,
    SegmentBehaviorsTypeDef,
    SegmentConditionTypeDef,
    SegmentDemographicsTypeDef,
    SegmentDimensionsTypeDef,
    SegmentGroupListTypeDef,
    SegmentGroupTypeDef,
    SegmentImportResourceTypeDef,
    SegmentLocationTypeDef,
    SegmentReferenceTypeDef,
    SegmentResponseTypeDef,
    SegmentsResponseTypeDef,
    SendMessagesResponseTypeDef,
    SendUsersMessageRequestTypeDef,
    SendUsersMessageResponseTypeDef,
    SendUsersMessagesResponseTypeDef,
    SessionTypeDef,
    SetDimensionTypeDef,
    SimpleConditionTypeDef,
    SimpleEmailPartTypeDef,
    SimpleEmailTypeDef,
    StartConditionTypeDef,
    TagsModelTypeDef,
    TemplateActiveVersionRequestTypeDef,
    TemplateConfigurationTypeDef,
    TemplateResponseTypeDef,
    TemplateTypeDef,
    TemplateVersionResponseTypeDef,
    TemplateVersionsResponseTypeDef,
    TemplatesResponseTypeDef,
    TreatmentResourceTypeDef,
    UpdateAdmChannelResponseTypeDef,
    UpdateApnsChannelResponseTypeDef,
    UpdateApnsSandboxChannelResponseTypeDef,
    UpdateApnsVoipChannelResponseTypeDef,
    UpdateApnsVoipSandboxChannelResponseTypeDef,
    UpdateApplicationSettingsResponseTypeDef,
    UpdateAttributesRequestTypeDef,
    UpdateBaiduChannelResponseTypeDef,
    UpdateCampaignResponseTypeDef,
    UpdateEmailChannelResponseTypeDef,
    UpdateEmailTemplateResponseTypeDef,
    UpdateEndpointResponseTypeDef,
    UpdateEndpointsBatchResponseTypeDef,
    UpdateGcmChannelResponseTypeDef,
    UpdateJourneyResponseTypeDef,
    UpdateJourneyStateResponseTypeDef,
    UpdatePushTemplateResponseTypeDef,
    UpdateRecommenderConfigurationResponseTypeDef,
    UpdateRecommenderConfigurationTypeDef,
    UpdateSegmentResponseTypeDef,
    UpdateSmsChannelResponseTypeDef,
    UpdateSmsTemplateResponseTypeDef,
    UpdateTemplateActiveVersionResponseTypeDef,
    UpdateVoiceChannelResponseTypeDef,
    UpdateVoiceTemplateResponseTypeDef,
    VoiceChannelRequestTypeDef,
    VoiceChannelResponseTypeDef,
    VoiceMessageTypeDef,
    VoiceTemplateRequestTypeDef,
    VoiceTemplateResponseTypeDef,
    WaitActivityTypeDef,
    WaitTimeTypeDef,
    WriteApplicationSettingsRequestTypeDef,
    WriteCampaignRequestTypeDef,
    WriteEventStreamTypeDef,
    WriteJourneyRequestTypeDef,
    WriteSegmentRequestTypeDef,
    WriteTreatmentResourceTypeDef,
)

def get_structure() -> ADMChannelRequestTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-pinpoint` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-pinpoint docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pinpoint/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
