from .player import Player, BATTLE_MOUNTS, Role
from collections import Counter, defaultdict
import pickle

class BattleStat: # Need to handle n team
    def __init__(self, battleJson: dict, guildName = 'O M B R A'):
        self.battle = battleJson
        self.equipments = {}
        self.team1 = set()
        self.team2 = set()
        self.killsTeam1 = 0
        self.killsTeam2 = 0
        self.killboard = defaultdict(int)
        self.deathboard = defaultdict(int)

        for kill in battleJson:
            victim = kill['Victim']
            killer = kill['Killer']
            self.killboard[killer['Name']] +=1
            self.deathboard[victim['Name']] +=1
            if killer['GuildName'] == guildName:
                team1Kill = True
                self.addTeam(killer, 1)
                self.addTeam(victim, 2)
                self.killsTeam1 += 1
            elif victim['GuildName'] == guildName:
                team1Kill = False
                self.addTeam(killer, 2)
                self.addTeam(victim, 1)
                self.killsTeam2 += 1
            else:
                continue

            participants = [] #kill['Participants']
            groupMembers = kill['GroupMembers']
            for party in [participants, groupMembers]:
                for member in party:
                    if team1Kill:
                        self.addTeam(member, 1)
                    else:
                        self.addTeam(member, 2)
        
    def addTeam(self, playerData:dict, team:int):
        if playerData is None:
            return
        if team == 1:
            self.team1.add(playerData['Name'])
        else:
            self.team2.add(playerData['Name'])
        self.addEquipments(playerData)
    
        
    def addEquipments(self, playerData:dict):
        try:
            if((playerData['Equipment']['Mount']) and (playerData['Equipment']['Mount']['Type'] in BATTLE_MOUNTS)):
                weapon = {'Type':"BATTLE_MOUNTS"}
            elif (playerData['Name'] in self.equipments) and (playerData['Equipment']['MainHand'] is None):
                return
            elif (playerData['Name'] in self.equipments) and (self.equipments[playerData['Name']].getType() == Role.BATTLE_MOUNTS):
                return
            else:
                weapon = playerData['Equipment']['MainHand']

            self.equipments[playerData['Name']] = Player(playerData['Name'], weapon, playerData['AverageItemPower'], playerData['GuildName'], playerData['AllianceName'] )
        except:
            print("Error in addEquipments: "+ str(playerData))
            
    def getGuildFromTeam(self, team:int):
        if team == 1:
            team = self.team1
        elif team == 2:
            team = self.team2
        else:
            raise Exception('Team must be 1 or 2')
            
        return Counter([self.equipments[player].guild for player in team])
    
    def getAllianceFromTeam(self, team:int):
        if team == 1:
            team = self.team1
        elif team == 2:
            team = self.team2
        else:
            raise Exception('Team must be 1 or 2')
            
        return Counter([self.equipments[player].alliance for player in team])
    
    def getDominationScore(self):
        if (self.killsTeam1 + self.killsTeam2) != 0:
            return self.killsTeam1 / (self.killsTeam1 + self.killsTeam2)

        return float('nan')
    
    def save(self, path):
        with open(path + 'battleData/'+str(self.battle[0] ['EventId'])+'.pkl', 'wb') as f:
            pickle.dump(self, f)
            
    def isValid(self):
        return len(self.team1) >0 and len(self.team2) >0

    def __str__(self):
        return f"Battle: {len(self.team1)} vs {len(self.team2)} result: {self.killsTeam1} kills to {self.killsTeam2} kills"
