# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_polardb20170801 import models as polardb_20170801_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-qingdao': 'polardb.aliyuncs.com',
            'cn-beijing': 'polardb.aliyuncs.com',
            'cn-wulanchabu': 'polardb.aliyuncs.com',
            'cn-hangzhou': 'polardb.aliyuncs.com',
            'cn-shanghai': 'polardb.aliyuncs.com',
            'cn-shenzhen': 'polardb.aliyuncs.com',
            'cn-guangzhou': 'polardb.aliyuncs.com',
            'cn-hongkong': 'polardb.aliyuncs.com',
            'cn-hangzhou-finance': 'polardb.aliyuncs.com',
            'cn-shanghai-finance-1': 'polardb.aliyuncs.com',
            'cn-shenzhen-finance-1': 'polardb.aliyuncs.com',
            'cn-north-2-gov-1': 'polardb.aliyuncs.com',
            'ap-northeast-2-pop': 'polardb.aliyuncs.com',
            'cn-beijing-finance-1': 'polardb.aliyuncs.com',
            'cn-beijing-finance-pop': 'polardb.aliyuncs.com',
            'cn-beijing-gov-1': 'polardb.aliyuncs.com',
            'cn-beijing-nu16-b01': 'polardb.aliyuncs.com',
            'cn-edge-1': 'polardb.aliyuncs.com',
            'cn-fujian': 'polardb.aliyuncs.com',
            'cn-haidian-cm12-c01': 'polardb.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'polardb.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'polardb.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'polardb.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'polardb.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'polardb.aliyuncs.com',
            'cn-hangzhou-test-306': 'polardb.aliyuncs.com',
            'cn-hongkong-finance-pop': 'polardb.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'polardb.aliyuncs.com',
            'cn-qingdao-nebula': 'polardb.aliyuncs.com',
            'cn-shanghai-et15-b01': 'polardb.aliyuncs.com',
            'cn-shanghai-et2-b01': 'polardb.aliyuncs.com',
            'cn-shanghai-inner': 'polardb.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'polardb.aliyuncs.com',
            'cn-shenzhen-inner': 'polardb.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'polardb.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'polardb.aliyuncs.com',
            'cn-wuhan': 'polardb.aliyuncs.com',
            'cn-yushanfang': 'polardb.aliyuncs.com',
            'cn-zhangbei': 'polardb.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'polardb.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'polardb.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'polardb.aliyuncs.com',
            'eu-west-1-oxs': 'polardb.aliyuncs.com',
            'rus-west-1-pop': 'polardb.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('polardb', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def abort_dbcluster_migration_with_options(
        self,
        request: polardb_20170801_models.AbortDBClusterMigrationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AbortDBClusterMigrationResponse:
        """
        @param request: AbortDBClusterMigrationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AbortDBClusterMigrationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AbortDBClusterMigration',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AbortDBClusterMigrationResponse(),
            self.call_api(params, req, runtime)
        )

    async def abort_dbcluster_migration_with_options_async(
        self,
        request: polardb_20170801_models.AbortDBClusterMigrationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AbortDBClusterMigrationResponse:
        """
        @param request: AbortDBClusterMigrationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AbortDBClusterMigrationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AbortDBClusterMigration',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AbortDBClusterMigrationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def abort_dbcluster_migration(
        self,
        request: polardb_20170801_models.AbortDBClusterMigrationRequest,
    ) -> polardb_20170801_models.AbortDBClusterMigrationResponse:
        """
        @param request: AbortDBClusterMigrationRequest
        @return: AbortDBClusterMigrationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.abort_dbcluster_migration_with_options(request, runtime)

    async def abort_dbcluster_migration_async(
        self,
        request: polardb_20170801_models.AbortDBClusterMigrationRequest,
    ) -> polardb_20170801_models.AbortDBClusterMigrationResponse:
        """
        @param request: AbortDBClusterMigrationRequest
        @return: AbortDBClusterMigrationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.abort_dbcluster_migration_with_options_async(request, runtime)

    def add_encryption_dbrole_privilege_with_options(
        self,
        request: polardb_20170801_models.AddEncryptionDBRolePrivilegeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AddEncryptionDBRolePrivilegeResponse:
        """
        @summary 添加角色权限
        
        @param request: AddEncryptionDBRolePrivilegeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddEncryptionDBRolePrivilegeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role_privilege_config):
            query['RolePrivilegeConfig'] = request.role_privilege_config
        if not UtilClient.is_unset(request.role_privilege_name):
            query['RolePrivilegeName'] = request.role_privilege_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddEncryptionDBRolePrivilege',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AddEncryptionDBRolePrivilegeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_encryption_dbrole_privilege_with_options_async(
        self,
        request: polardb_20170801_models.AddEncryptionDBRolePrivilegeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AddEncryptionDBRolePrivilegeResponse:
        """
        @summary 添加角色权限
        
        @param request: AddEncryptionDBRolePrivilegeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddEncryptionDBRolePrivilegeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role_privilege_config):
            query['RolePrivilegeConfig'] = request.role_privilege_config
        if not UtilClient.is_unset(request.role_privilege_name):
            query['RolePrivilegeName'] = request.role_privilege_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddEncryptionDBRolePrivilege',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AddEncryptionDBRolePrivilegeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_encryption_dbrole_privilege(
        self,
        request: polardb_20170801_models.AddEncryptionDBRolePrivilegeRequest,
    ) -> polardb_20170801_models.AddEncryptionDBRolePrivilegeResponse:
        """
        @summary 添加角色权限
        
        @param request: AddEncryptionDBRolePrivilegeRequest
        @return: AddEncryptionDBRolePrivilegeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_encryption_dbrole_privilege_with_options(request, runtime)

    async def add_encryption_dbrole_privilege_async(
        self,
        request: polardb_20170801_models.AddEncryptionDBRolePrivilegeRequest,
    ) -> polardb_20170801_models.AddEncryptionDBRolePrivilegeResponse:
        """
        @summary 添加角色权限
        
        @param request: AddEncryptionDBRolePrivilegeRequest
        @return: AddEncryptionDBRolePrivilegeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_encryption_dbrole_privilege_with_options_async(request, runtime)

    def add_firewall_rules_with_options(
        self,
        request: polardb_20170801_models.AddFirewallRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AddFirewallRulesResponse:
        """
        @summary 添加sql防火墙配置
        
        @param request: AddFirewallRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddFirewallRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_config):
            query['RuleConfig'] = request.rule_config
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddFirewallRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AddFirewallRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_firewall_rules_with_options_async(
        self,
        request: polardb_20170801_models.AddFirewallRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AddFirewallRulesResponse:
        """
        @summary 添加sql防火墙配置
        
        @param request: AddFirewallRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddFirewallRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_config):
            query['RuleConfig'] = request.rule_config
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddFirewallRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AddFirewallRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_firewall_rules(
        self,
        request: polardb_20170801_models.AddFirewallRulesRequest,
    ) -> polardb_20170801_models.AddFirewallRulesResponse:
        """
        @summary 添加sql防火墙配置
        
        @param request: AddFirewallRulesRequest
        @return: AddFirewallRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_firewall_rules_with_options(request, runtime)

    async def add_firewall_rules_async(
        self,
        request: polardb_20170801_models.AddFirewallRulesRequest,
    ) -> polardb_20170801_models.AddFirewallRulesResponse:
        """
        @summary 添加sql防火墙配置
        
        @param request: AddFirewallRulesRequest
        @return: AddFirewallRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_firewall_rules_with_options_async(request, runtime)

    def add_polar_fs_quota_with_options(
        self,
        request: polardb_20170801_models.AddPolarFsQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AddPolarFsQuotaResponse:
        """
        @summary 新增PolarFs Quota规则
        
        @param request: AddPolarFsQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPolarFsQuotaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.quotas):
            query['Quotas'] = request.quotas
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPolarFsQuota',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AddPolarFsQuotaResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_polar_fs_quota_with_options_async(
        self,
        request: polardb_20170801_models.AddPolarFsQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AddPolarFsQuotaResponse:
        """
        @summary 新增PolarFs Quota规则
        
        @param request: AddPolarFsQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPolarFsQuotaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.quotas):
            query['Quotas'] = request.quotas
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPolarFsQuota',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AddPolarFsQuotaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_polar_fs_quota(
        self,
        request: polardb_20170801_models.AddPolarFsQuotaRequest,
    ) -> polardb_20170801_models.AddPolarFsQuotaResponse:
        """
        @summary 新增PolarFs Quota规则
        
        @param request: AddPolarFsQuotaRequest
        @return: AddPolarFsQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_polar_fs_quota_with_options(request, runtime)

    async def add_polar_fs_quota_async(
        self,
        request: polardb_20170801_models.AddPolarFsQuotaRequest,
    ) -> polardb_20170801_models.AddPolarFsQuotaResponse:
        """
        @summary 新增PolarFs Quota规则
        
        @param request: AddPolarFsQuotaRequest
        @return: AddPolarFsQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_polar_fs_quota_with_options_async(request, runtime)

    def add_sqlrate_limiting_rules_with_options(
        self,
        request: polardb_20170801_models.AddSQLRateLimitingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AddSQLRateLimitingRulesResponse:
        """
        @summary 添加SQL限流规则
        
        @param request: AddSQLRateLimitingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSQLRateLimitingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_config):
            query['RuleConfig'] = request.rule_config
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSQLRateLimitingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AddSQLRateLimitingRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_sqlrate_limiting_rules_with_options_async(
        self,
        request: polardb_20170801_models.AddSQLRateLimitingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AddSQLRateLimitingRulesResponse:
        """
        @summary 添加SQL限流规则
        
        @param request: AddSQLRateLimitingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSQLRateLimitingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_config):
            query['RuleConfig'] = request.rule_config
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSQLRateLimitingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AddSQLRateLimitingRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_sqlrate_limiting_rules(
        self,
        request: polardb_20170801_models.AddSQLRateLimitingRulesRequest,
    ) -> polardb_20170801_models.AddSQLRateLimitingRulesResponse:
        """
        @summary 添加SQL限流规则
        
        @param request: AddSQLRateLimitingRulesRequest
        @return: AddSQLRateLimitingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_sqlrate_limiting_rules_with_options(request, runtime)

    async def add_sqlrate_limiting_rules_async(
        self,
        request: polardb_20170801_models.AddSQLRateLimitingRulesRequest,
    ) -> polardb_20170801_models.AddSQLRateLimitingRulesResponse:
        """
        @summary 添加SQL限流规则
        
        @param request: AddSQLRateLimitingRulesRequest
        @return: AddSQLRateLimitingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_sqlrate_limiting_rules_with_options_async(request, runtime)

    def attach_application_polar_fswith_options(
        self,
        request: polardb_20170801_models.AttachApplicationPolarFSRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AttachApplicationPolarFSResponse:
        """
        @summary 挂载PolarFS到PolarDB应用
        
        @param request: AttachApplicationPolarFSRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachApplicationPolarFSResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        if not UtilClient.is_unset(request.polar_fsaccess_key_id):
            query['PolarFSAccessKeyId'] = request.polar_fsaccess_key_id
        if not UtilClient.is_unset(request.polar_fsaccess_key_secret):
            query['PolarFSAccessKeySecret'] = request.polar_fsaccess_key_secret
        if not UtilClient.is_unset(request.polar_fsinstance_id):
            query['PolarFSInstanceId'] = request.polar_fsinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachApplicationPolarFS',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AttachApplicationPolarFSResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_application_polar_fswith_options_async(
        self,
        request: polardb_20170801_models.AttachApplicationPolarFSRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.AttachApplicationPolarFSResponse:
        """
        @summary 挂载PolarFS到PolarDB应用
        
        @param request: AttachApplicationPolarFSRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachApplicationPolarFSResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        if not UtilClient.is_unset(request.polar_fsaccess_key_id):
            query['PolarFSAccessKeyId'] = request.polar_fsaccess_key_id
        if not UtilClient.is_unset(request.polar_fsaccess_key_secret):
            query['PolarFSAccessKeySecret'] = request.polar_fsaccess_key_secret
        if not UtilClient.is_unset(request.polar_fsinstance_id):
            query['PolarFSInstanceId'] = request.polar_fsinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachApplicationPolarFS',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.AttachApplicationPolarFSResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_application_polar_fs(
        self,
        request: polardb_20170801_models.AttachApplicationPolarFSRequest,
    ) -> polardb_20170801_models.AttachApplicationPolarFSResponse:
        """
        @summary 挂载PolarFS到PolarDB应用
        
        @param request: AttachApplicationPolarFSRequest
        @return: AttachApplicationPolarFSResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_application_polar_fswith_options(request, runtime)

    async def attach_application_polar_fs_async(
        self,
        request: polardb_20170801_models.AttachApplicationPolarFSRequest,
    ) -> polardb_20170801_models.AttachApplicationPolarFSResponse:
        """
        @summary 挂载PolarFS到PolarDB应用
        
        @param request: AttachApplicationPolarFSRequest
        @return: AttachApplicationPolarFSResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_application_polar_fswith_options_async(request, runtime)

    def cancel_active_operation_tasks_with_options(
        self,
        request: polardb_20170801_models.CancelActiveOperationTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CancelActiveOperationTasksResponse:
        """
        @summary Cancels O\\&M events at a time.
        
        @param request: CancelActiveOperationTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelActiveOperationTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.task_ids):
            query['TaskIds'] = request.task_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelActiveOperationTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CancelActiveOperationTasksResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_active_operation_tasks_with_options_async(
        self,
        request: polardb_20170801_models.CancelActiveOperationTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CancelActiveOperationTasksResponse:
        """
        @summary Cancels O\\&M events at a time.
        
        @param request: CancelActiveOperationTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelActiveOperationTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.task_ids):
            query['TaskIds'] = request.task_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelActiveOperationTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CancelActiveOperationTasksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_active_operation_tasks(
        self,
        request: polardb_20170801_models.CancelActiveOperationTasksRequest,
    ) -> polardb_20170801_models.CancelActiveOperationTasksResponse:
        """
        @summary Cancels O\\&M events at a time.
        
        @param request: CancelActiveOperationTasksRequest
        @return: CancelActiveOperationTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_active_operation_tasks_with_options(request, runtime)

    async def cancel_active_operation_tasks_async(
        self,
        request: polardb_20170801_models.CancelActiveOperationTasksRequest,
    ) -> polardb_20170801_models.CancelActiveOperationTasksResponse:
        """
        @summary Cancels O\\&M events at a time.
        
        @param request: CancelActiveOperationTasksRequest
        @return: CancelActiveOperationTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_active_operation_tasks_with_options_async(request, runtime)

    def cancel_cron_job_policy_serverless_with_options(
        self,
        request: polardb_20170801_models.CancelCronJobPolicyServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CancelCronJobPolicyServerlessResponse:
        """
        @summary 取消周期任务策略
        
        @param request: CancelCronJobPolicyServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCronJobPolicyServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCronJobPolicyServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CancelCronJobPolicyServerlessResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_cron_job_policy_serverless_with_options_async(
        self,
        request: polardb_20170801_models.CancelCronJobPolicyServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CancelCronJobPolicyServerlessResponse:
        """
        @summary 取消周期任务策略
        
        @param request: CancelCronJobPolicyServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCronJobPolicyServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCronJobPolicyServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CancelCronJobPolicyServerlessResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_cron_job_policy_serverless(
        self,
        request: polardb_20170801_models.CancelCronJobPolicyServerlessRequest,
    ) -> polardb_20170801_models.CancelCronJobPolicyServerlessResponse:
        """
        @summary 取消周期任务策略
        
        @param request: CancelCronJobPolicyServerlessRequest
        @return: CancelCronJobPolicyServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_cron_job_policy_serverless_with_options(request, runtime)

    async def cancel_cron_job_policy_serverless_async(
        self,
        request: polardb_20170801_models.CancelCronJobPolicyServerlessRequest,
    ) -> polardb_20170801_models.CancelCronJobPolicyServerlessResponse:
        """
        @summary 取消周期任务策略
        
        @param request: CancelCronJobPolicyServerlessRequest
        @return: CancelCronJobPolicyServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_cron_job_policy_serverless_with_options_async(request, runtime)

    def cancel_polar_fs_file_quota_with_options(
        self,
        request: polardb_20170801_models.CancelPolarFsFileQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CancelPolarFsFileQuotaResponse:
        """
        @summary 取消目录的配额
        
        @param request: CancelPolarFsFileQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelPolarFsFileQuotaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.file_path_ids):
            query['FilePathIds'] = request.file_path_ids
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPolarFsFileQuota',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CancelPolarFsFileQuotaResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_polar_fs_file_quota_with_options_async(
        self,
        request: polardb_20170801_models.CancelPolarFsFileQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CancelPolarFsFileQuotaResponse:
        """
        @summary 取消目录的配额
        
        @param request: CancelPolarFsFileQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelPolarFsFileQuotaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.file_path_ids):
            query['FilePathIds'] = request.file_path_ids
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPolarFsFileQuota',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CancelPolarFsFileQuotaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_polar_fs_file_quota(
        self,
        request: polardb_20170801_models.CancelPolarFsFileQuotaRequest,
    ) -> polardb_20170801_models.CancelPolarFsFileQuotaResponse:
        """
        @summary 取消目录的配额
        
        @param request: CancelPolarFsFileQuotaRequest
        @return: CancelPolarFsFileQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_polar_fs_file_quota_with_options(request, runtime)

    async def cancel_polar_fs_file_quota_async(
        self,
        request: polardb_20170801_models.CancelPolarFsFileQuotaRequest,
    ) -> polardb_20170801_models.CancelPolarFsFileQuotaResponse:
        """
        @summary 取消目录的配额
        
        @param request: CancelPolarFsFileQuotaRequest
        @return: CancelPolarFsFileQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_polar_fs_file_quota_with_options_async(request, runtime)

    def cancel_schedule_tasks_with_options(
        self,
        request: polardb_20170801_models.CancelScheduleTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CancelScheduleTasksResponse:
        """
        @summary Cancels scheduled tasks that are not yet started.
        
        @param request: CancelScheduleTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelScheduleTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelScheduleTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CancelScheduleTasksResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_schedule_tasks_with_options_async(
        self,
        request: polardb_20170801_models.CancelScheduleTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CancelScheduleTasksResponse:
        """
        @summary Cancels scheduled tasks that are not yet started.
        
        @param request: CancelScheduleTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelScheduleTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelScheduleTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CancelScheduleTasksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_schedule_tasks(
        self,
        request: polardb_20170801_models.CancelScheduleTasksRequest,
    ) -> polardb_20170801_models.CancelScheduleTasksResponse:
        """
        @summary Cancels scheduled tasks that are not yet started.
        
        @param request: CancelScheduleTasksRequest
        @return: CancelScheduleTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_schedule_tasks_with_options(request, runtime)

    async def cancel_schedule_tasks_async(
        self,
        request: polardb_20170801_models.CancelScheduleTasksRequest,
    ) -> polardb_20170801_models.CancelScheduleTasksResponse:
        """
        @summary Cancels scheduled tasks that are not yet started.
        
        @param request: CancelScheduleTasksRequest
        @return: CancelScheduleTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_schedule_tasks_with_options_async(request, runtime)

    def check_account_name_with_options(
        self,
        request: polardb_20170801_models.CheckAccountNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckAccountNameResponse:
        """
        @summary Checks whether an account name is valid or unique in a cluster.
        
        @param request: CheckAccountNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckAccountNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckAccountName',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckAccountNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_account_name_with_options_async(
        self,
        request: polardb_20170801_models.CheckAccountNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckAccountNameResponse:
        """
        @summary Checks whether an account name is valid or unique in a cluster.
        
        @param request: CheckAccountNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckAccountNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckAccountName',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckAccountNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_account_name(
        self,
        request: polardb_20170801_models.CheckAccountNameRequest,
    ) -> polardb_20170801_models.CheckAccountNameResponse:
        """
        @summary Checks whether an account name is valid or unique in a cluster.
        
        @param request: CheckAccountNameRequest
        @return: CheckAccountNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_account_name_with_options(request, runtime)

    async def check_account_name_async(
        self,
        request: polardb_20170801_models.CheckAccountNameRequest,
    ) -> polardb_20170801_models.CheckAccountNameResponse:
        """
        @summary Checks whether an account name is valid or unique in a cluster.
        
        @param request: CheckAccountNameRequest
        @return: CheckAccountNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_account_name_with_options_async(request, runtime)

    def check_account_name_zonal_with_options(
        self,
        request: polardb_20170801_models.CheckAccountNameZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckAccountNameZonalResponse:
        """
        @summary 检查PolarDB账号名称
        
        @param request: CheckAccountNameZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckAccountNameZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckAccountNameZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckAccountNameZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_account_name_zonal_with_options_async(
        self,
        request: polardb_20170801_models.CheckAccountNameZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckAccountNameZonalResponse:
        """
        @summary 检查PolarDB账号名称
        
        @param request: CheckAccountNameZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckAccountNameZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckAccountNameZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckAccountNameZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_account_name_zonal(
        self,
        request: polardb_20170801_models.CheckAccountNameZonalRequest,
    ) -> polardb_20170801_models.CheckAccountNameZonalResponse:
        """
        @summary 检查PolarDB账号名称
        
        @param request: CheckAccountNameZonalRequest
        @return: CheckAccountNameZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_account_name_zonal_with_options(request, runtime)

    async def check_account_name_zonal_async(
        self,
        request: polardb_20170801_models.CheckAccountNameZonalRequest,
    ) -> polardb_20170801_models.CheckAccountNameZonalResponse:
        """
        @summary 检查PolarDB账号名称
        
        @param request: CheckAccountNameZonalRequest
        @return: CheckAccountNameZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_account_name_zonal_with_options_async(request, runtime)

    def check_connection_string_with_options(
        self,
        request: polardb_20170801_models.CheckConnectionStringRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckConnectionStringResponse:
        """
        @summary 检查连接串
        
        @param request: CheckConnectionStringRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckConnectionStringResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string_prefix):
            query['ConnectionStringPrefix'] = request.connection_string_prefix
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckConnectionString',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckConnectionStringResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_connection_string_with_options_async(
        self,
        request: polardb_20170801_models.CheckConnectionStringRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckConnectionStringResponse:
        """
        @summary 检查连接串
        
        @param request: CheckConnectionStringRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckConnectionStringResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string_prefix):
            query['ConnectionStringPrefix'] = request.connection_string_prefix
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckConnectionString',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckConnectionStringResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_connection_string(
        self,
        request: polardb_20170801_models.CheckConnectionStringRequest,
    ) -> polardb_20170801_models.CheckConnectionStringResponse:
        """
        @summary 检查连接串
        
        @param request: CheckConnectionStringRequest
        @return: CheckConnectionStringResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_connection_string_with_options(request, runtime)

    async def check_connection_string_async(
        self,
        request: polardb_20170801_models.CheckConnectionStringRequest,
    ) -> polardb_20170801_models.CheckConnectionStringResponse:
        """
        @summary 检查连接串
        
        @param request: CheckConnectionStringRequest
        @return: CheckConnectionStringResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_connection_string_with_options_async(request, runtime)

    def check_dbname_with_options(
        self,
        request: polardb_20170801_models.CheckDBNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckDBNameResponse:
        """
        @summary Checks whether a database name is valid or whether the name is already used by another database in the current cluster.
        
        @param request: CheckDBNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckDBNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckDBName',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckDBNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_dbname_with_options_async(
        self,
        request: polardb_20170801_models.CheckDBNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckDBNameResponse:
        """
        @summary Checks whether a database name is valid or whether the name is already used by another database in the current cluster.
        
        @param request: CheckDBNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckDBNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckDBName',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckDBNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_dbname(
        self,
        request: polardb_20170801_models.CheckDBNameRequest,
    ) -> polardb_20170801_models.CheckDBNameResponse:
        """
        @summary Checks whether a database name is valid or whether the name is already used by another database in the current cluster.
        
        @param request: CheckDBNameRequest
        @return: CheckDBNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_dbname_with_options(request, runtime)

    async def check_dbname_async(
        self,
        request: polardb_20170801_models.CheckDBNameRequest,
    ) -> polardb_20170801_models.CheckDBNameResponse:
        """
        @summary Checks whether a database name is valid or whether the name is already used by another database in the current cluster.
        
        @param request: CheckDBNameRequest
        @return: CheckDBNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_dbname_with_options_async(request, runtime)

    def check_dbname_zonal_with_options(
        self,
        request: polardb_20170801_models.CheckDBNameZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckDBNameZonalResponse:
        """
        @summary 检查PolarDB边缘云数据库名
        
        @param request: CheckDBNameZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckDBNameZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckDBNameZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckDBNameZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_dbname_zonal_with_options_async(
        self,
        request: polardb_20170801_models.CheckDBNameZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckDBNameZonalResponse:
        """
        @summary 检查PolarDB边缘云数据库名
        
        @param request: CheckDBNameZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckDBNameZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckDBNameZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckDBNameZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_dbname_zonal(
        self,
        request: polardb_20170801_models.CheckDBNameZonalRequest,
    ) -> polardb_20170801_models.CheckDBNameZonalResponse:
        """
        @summary 检查PolarDB边缘云数据库名
        
        @param request: CheckDBNameZonalRequest
        @return: CheckDBNameZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_dbname_zonal_with_options(request, runtime)

    async def check_dbname_zonal_async(
        self,
        request: polardb_20170801_models.CheckDBNameZonalRequest,
    ) -> polardb_20170801_models.CheckDBNameZonalResponse:
        """
        @summary 检查PolarDB边缘云数据库名
        
        @param request: CheckDBNameZonalRequest
        @return: CheckDBNameZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_dbname_zonal_with_options_async(request, runtime)

    def check_kmsauthorized_with_options(
        self,
        request: polardb_20170801_models.CheckKMSAuthorizedRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckKMSAuthorizedResponse:
        """
        @summary Queries whether the cluster is authorized to use Key Management Service (KMS).
        
        @param request: CheckKMSAuthorizedRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckKMSAuthorizedResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tderegion):
            query['TDERegion'] = request.tderegion
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckKMSAuthorized',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckKMSAuthorizedResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_kmsauthorized_with_options_async(
        self,
        request: polardb_20170801_models.CheckKMSAuthorizedRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckKMSAuthorizedResponse:
        """
        @summary Queries whether the cluster is authorized to use Key Management Service (KMS).
        
        @param request: CheckKMSAuthorizedRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckKMSAuthorizedResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tderegion):
            query['TDERegion'] = request.tderegion
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckKMSAuthorized',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckKMSAuthorizedResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_kmsauthorized(
        self,
        request: polardb_20170801_models.CheckKMSAuthorizedRequest,
    ) -> polardb_20170801_models.CheckKMSAuthorizedResponse:
        """
        @summary Queries whether the cluster is authorized to use Key Management Service (KMS).
        
        @param request: CheckKMSAuthorizedRequest
        @return: CheckKMSAuthorizedResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_kmsauthorized_with_options(request, runtime)

    async def check_kmsauthorized_async(
        self,
        request: polardb_20170801_models.CheckKMSAuthorizedRequest,
    ) -> polardb_20170801_models.CheckKMSAuthorizedResponse:
        """
        @summary Queries whether the cluster is authorized to use Key Management Service (KMS).
        
        @param request: CheckKMSAuthorizedRequest
        @return: CheckKMSAuthorizedResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_kmsauthorized_with_options_async(request, runtime)

    def check_service_linked_role_with_options(
        self,
        request: polardb_20170801_models.CheckServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckServiceLinkedRoleResponse:
        """
        @summary Checks whether a service-linked role (SLR) is created.
        
        @param request: CheckServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckServiceLinkedRole',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckServiceLinkedRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_service_linked_role_with_options_async(
        self,
        request: polardb_20170801_models.CheckServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CheckServiceLinkedRoleResponse:
        """
        @summary Checks whether a service-linked role (SLR) is created.
        
        @param request: CheckServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckServiceLinkedRole',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CheckServiceLinkedRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_service_linked_role(
        self,
        request: polardb_20170801_models.CheckServiceLinkedRoleRequest,
    ) -> polardb_20170801_models.CheckServiceLinkedRoleResponse:
        """
        @summary Checks whether a service-linked role (SLR) is created.
        
        @param request: CheckServiceLinkedRoleRequest
        @return: CheckServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_service_linked_role_with_options(request, runtime)

    async def check_service_linked_role_async(
        self,
        request: polardb_20170801_models.CheckServiceLinkedRoleRequest,
    ) -> polardb_20170801_models.CheckServiceLinkedRoleResponse:
        """
        @summary Checks whether a service-linked role (SLR) is created.
        
        @param request: CheckServiceLinkedRoleRequest
        @return: CheckServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_service_linked_role_with_options_async(request, runtime)

    def close_aitask_with_options(
        self,
        request: polardb_20170801_models.CloseAITaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CloseAITaskResponse:
        """
        @summary 关闭DB4AI
        
        @param request: CloseAITaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseAITaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseAITask',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CloseAITaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def close_aitask_with_options_async(
        self,
        request: polardb_20170801_models.CloseAITaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CloseAITaskResponse:
        """
        @summary 关闭DB4AI
        
        @param request: CloseAITaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseAITaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseAITask',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CloseAITaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def close_aitask(
        self,
        request: polardb_20170801_models.CloseAITaskRequest,
    ) -> polardb_20170801_models.CloseAITaskResponse:
        """
        @summary 关闭DB4AI
        
        @param request: CloseAITaskRequest
        @return: CloseAITaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.close_aitask_with_options(request, runtime)

    async def close_aitask_async(
        self,
        request: polardb_20170801_models.CloseAITaskRequest,
    ) -> polardb_20170801_models.CloseAITaskResponse:
        """
        @summary 关闭DB4AI
        
        @param request: CloseAITaskRequest
        @return: CloseAITaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.close_aitask_with_options_async(request, runtime)

    def close_dbcluster_migration_with_options(
        self,
        request: polardb_20170801_models.CloseDBClusterMigrationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CloseDBClusterMigrationResponse:
        """
        @summary Cancels or completes the migration task that upgrades an RDS cluster to a PolarDB cluster.
        
        @description    You can call this operation to cancel the migration task before data migration.
        You can call this operation to perform the migration task after data migration.
        > Before you call this operation, ensure that a one-click upgrade task has been created for the cluster. You can call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation to create an upgrade task. Set the *CreationOption** parameter to **MigrationFromRDS**. For more information, see [Create a PolarDB for MySQL cluster by using the Migration from RDS method](https://help.aliyun.com/document_detail/121582.html).
        
        @param request: CloseDBClusterMigrationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseDBClusterMigrationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.continue_enable_binlog):
            query['ContinueEnableBinlog'] = request.continue_enable_binlog
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseDBClusterMigration',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CloseDBClusterMigrationResponse(),
            self.call_api(params, req, runtime)
        )

    async def close_dbcluster_migration_with_options_async(
        self,
        request: polardb_20170801_models.CloseDBClusterMigrationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CloseDBClusterMigrationResponse:
        """
        @summary Cancels or completes the migration task that upgrades an RDS cluster to a PolarDB cluster.
        
        @description    You can call this operation to cancel the migration task before data migration.
        You can call this operation to perform the migration task after data migration.
        > Before you call this operation, ensure that a one-click upgrade task has been created for the cluster. You can call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation to create an upgrade task. Set the *CreationOption** parameter to **MigrationFromRDS**. For more information, see [Create a PolarDB for MySQL cluster by using the Migration from RDS method](https://help.aliyun.com/document_detail/121582.html).
        
        @param request: CloseDBClusterMigrationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseDBClusterMigrationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.continue_enable_binlog):
            query['ContinueEnableBinlog'] = request.continue_enable_binlog
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseDBClusterMigration',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CloseDBClusterMigrationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def close_dbcluster_migration(
        self,
        request: polardb_20170801_models.CloseDBClusterMigrationRequest,
    ) -> polardb_20170801_models.CloseDBClusterMigrationResponse:
        """
        @summary Cancels or completes the migration task that upgrades an RDS cluster to a PolarDB cluster.
        
        @description    You can call this operation to cancel the migration task before data migration.
        You can call this operation to perform the migration task after data migration.
        > Before you call this operation, ensure that a one-click upgrade task has been created for the cluster. You can call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation to create an upgrade task. Set the *CreationOption** parameter to **MigrationFromRDS**. For more information, see [Create a PolarDB for MySQL cluster by using the Migration from RDS method](https://help.aliyun.com/document_detail/121582.html).
        
        @param request: CloseDBClusterMigrationRequest
        @return: CloseDBClusterMigrationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.close_dbcluster_migration_with_options(request, runtime)

    async def close_dbcluster_migration_async(
        self,
        request: polardb_20170801_models.CloseDBClusterMigrationRequest,
    ) -> polardb_20170801_models.CloseDBClusterMigrationResponse:
        """
        @summary Cancels or completes the migration task that upgrades an RDS cluster to a PolarDB cluster.
        
        @description    You can call this operation to cancel the migration task before data migration.
        You can call this operation to perform the migration task after data migration.
        > Before you call this operation, ensure that a one-click upgrade task has been created for the cluster. You can call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation to create an upgrade task. Set the *CreationOption** parameter to **MigrationFromRDS**. For more information, see [Create a PolarDB for MySQL cluster by using the Migration from RDS method](https://help.aliyun.com/document_detail/121582.html).
        
        @param request: CloseDBClusterMigrationRequest
        @return: CloseDBClusterMigrationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.close_dbcluster_migration_with_options_async(request, runtime)

    def continue_dbcluster_migration_with_options(
        self,
        request: polardb_20170801_models.ContinueDBClusterMigrationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.ContinueDBClusterMigrationResponse:
        """
        @param request: ContinueDBClusterMigrationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ContinueDBClusterMigrationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.force_switch):
            query['ForceSwitch'] = request.force_switch
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ContinueDBClusterMigration',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.ContinueDBClusterMigrationResponse(),
            self.call_api(params, req, runtime)
        )

    async def continue_dbcluster_migration_with_options_async(
        self,
        request: polardb_20170801_models.ContinueDBClusterMigrationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.ContinueDBClusterMigrationResponse:
        """
        @param request: ContinueDBClusterMigrationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ContinueDBClusterMigrationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.force_switch):
            query['ForceSwitch'] = request.force_switch
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ContinueDBClusterMigration',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.ContinueDBClusterMigrationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def continue_dbcluster_migration(
        self,
        request: polardb_20170801_models.ContinueDBClusterMigrationRequest,
    ) -> polardb_20170801_models.ContinueDBClusterMigrationResponse:
        """
        @param request: ContinueDBClusterMigrationRequest
        @return: ContinueDBClusterMigrationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.continue_dbcluster_migration_with_options(request, runtime)

    async def continue_dbcluster_migration_async(
        self,
        request: polardb_20170801_models.ContinueDBClusterMigrationRequest,
    ) -> polardb_20170801_models.ContinueDBClusterMigrationResponse:
        """
        @param request: ContinueDBClusterMigrationRequest
        @return: ContinueDBClusterMigrationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.continue_dbcluster_migration_with_options_async(request, runtime)

    def create_account_with_options(
        self,
        request: polardb_20170801_models.CreateAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateAccountResponse:
        """
        @summary Creates a database account for a PolarDB cluster.
        
        @param request: CreateAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_description):
            query['AccountDescription'] = request.account_description
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.account_privilege):
            query['AccountPrivilege'] = request.account_privilege
        if not UtilClient.is_unset(request.account_type):
            query['AccountType'] = request.account_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.priv_for_all_db):
            query['PrivForAllDB'] = request.priv_for_all_db
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAccount',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateAccountResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_account_with_options_async(
        self,
        request: polardb_20170801_models.CreateAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateAccountResponse:
        """
        @summary Creates a database account for a PolarDB cluster.
        
        @param request: CreateAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_description):
            query['AccountDescription'] = request.account_description
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.account_privilege):
            query['AccountPrivilege'] = request.account_privilege
        if not UtilClient.is_unset(request.account_type):
            query['AccountType'] = request.account_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.priv_for_all_db):
            query['PrivForAllDB'] = request.priv_for_all_db
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAccount',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateAccountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_account(
        self,
        request: polardb_20170801_models.CreateAccountRequest,
    ) -> polardb_20170801_models.CreateAccountResponse:
        """
        @summary Creates a database account for a PolarDB cluster.
        
        @param request: CreateAccountRequest
        @return: CreateAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_account_with_options(request, runtime)

    async def create_account_async(
        self,
        request: polardb_20170801_models.CreateAccountRequest,
    ) -> polardb_20170801_models.CreateAccountResponse:
        """
        @summary Creates a database account for a PolarDB cluster.
        
        @param request: CreateAccountRequest
        @return: CreateAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_account_with_options_async(request, runtime)

    def create_account_zonal_with_options(
        self,
        request: polardb_20170801_models.CreateAccountZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateAccountZonalResponse:
        """
        @summary 创建边缘云账号
        
        @param request: CreateAccountZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAccountZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_description):
            query['AccountDescription'] = request.account_description
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.account_privilege):
            query['AccountPrivilege'] = request.account_privilege
        if not UtilClient.is_unset(request.account_type):
            query['AccountType'] = request.account_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.priv_for_all_db):
            query['PrivForAllDB'] = request.priv_for_all_db
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAccountZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateAccountZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_account_zonal_with_options_async(
        self,
        request: polardb_20170801_models.CreateAccountZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateAccountZonalResponse:
        """
        @summary 创建边缘云账号
        
        @param request: CreateAccountZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAccountZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_description):
            query['AccountDescription'] = request.account_description
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.account_privilege):
            query['AccountPrivilege'] = request.account_privilege
        if not UtilClient.is_unset(request.account_type):
            query['AccountType'] = request.account_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.priv_for_all_db):
            query['PrivForAllDB'] = request.priv_for_all_db
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAccountZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateAccountZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_account_zonal(
        self,
        request: polardb_20170801_models.CreateAccountZonalRequest,
    ) -> polardb_20170801_models.CreateAccountZonalResponse:
        """
        @summary 创建边缘云账号
        
        @param request: CreateAccountZonalRequest
        @return: CreateAccountZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_account_zonal_with_options(request, runtime)

    async def create_account_zonal_async(
        self,
        request: polardb_20170801_models.CreateAccountZonalRequest,
    ) -> polardb_20170801_models.CreateAccountZonalResponse:
        """
        @summary 创建边缘云账号
        
        @param request: CreateAccountZonalRequest
        @return: CreateAccountZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_account_zonal_with_options_async(request, runtime)

    def create_activation_code_with_options(
        self,
        request: polardb_20170801_models.CreateActivationCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateActivationCodeResponse:
        """
        @summary Generates a lightweight license activation code.
        
        @param request: CreateActivationCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateActivationCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.mac_address):
            query['MacAddress'] = request.mac_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_identifier):
            query['SystemIdentifier'] = request.system_identifier
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateActivationCode',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateActivationCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_activation_code_with_options_async(
        self,
        request: polardb_20170801_models.CreateActivationCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateActivationCodeResponse:
        """
        @summary Generates a lightweight license activation code.
        
        @param request: CreateActivationCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateActivationCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.mac_address):
            query['MacAddress'] = request.mac_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_identifier):
            query['SystemIdentifier'] = request.system_identifier
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateActivationCode',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateActivationCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_activation_code(
        self,
        request: polardb_20170801_models.CreateActivationCodeRequest,
    ) -> polardb_20170801_models.CreateActivationCodeResponse:
        """
        @summary Generates a lightweight license activation code.
        
        @param request: CreateActivationCodeRequest
        @return: CreateActivationCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_activation_code_with_options(request, runtime)

    async def create_activation_code_async(
        self,
        request: polardb_20170801_models.CreateActivationCodeRequest,
    ) -> polardb_20170801_models.CreateActivationCodeResponse:
        """
        @summary Generates a lightweight license activation code.
        
        @param request: CreateActivationCodeRequest
        @return: CreateActivationCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_activation_code_with_options_async(request, runtime)

    def create_application_with_options(
        self,
        tmp_req: polardb_20170801_models.CreateApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateApplicationResponse:
        """
        @summary 创建PolarDB应用
        
        @param tmp_req: CreateApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateApplicationResponse
        """
        UtilClient.validate_model(tmp_req)
        request = polardb_20170801_models.CreateApplicationShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.components):
            request.components_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.components, 'Components', 'json')
        if not UtilClient.is_unset(tmp_req.endpoints):
            request.endpoints_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.endpoints, 'Endpoints', 'json')
        query = {}
        if not UtilClient.is_unset(request.application_type):
            query['ApplicationType'] = request.application_type
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.components_shrink):
            query['Components'] = request.components_shrink
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoints_shrink):
            query['Endpoints'] = request.endpoints_shrink
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.polar_fsinstance_id):
            query['PolarFSInstanceId'] = request.polar_fsinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateApplication',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_application_with_options_async(
        self,
        tmp_req: polardb_20170801_models.CreateApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateApplicationResponse:
        """
        @summary 创建PolarDB应用
        
        @param tmp_req: CreateApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateApplicationResponse
        """
        UtilClient.validate_model(tmp_req)
        request = polardb_20170801_models.CreateApplicationShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.components):
            request.components_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.components, 'Components', 'json')
        if not UtilClient.is_unset(tmp_req.endpoints):
            request.endpoints_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.endpoints, 'Endpoints', 'json')
        query = {}
        if not UtilClient.is_unset(request.application_type):
            query['ApplicationType'] = request.application_type
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.components_shrink):
            query['Components'] = request.components_shrink
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoints_shrink):
            query['Endpoints'] = request.endpoints_shrink
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.polar_fsinstance_id):
            query['PolarFSInstanceId'] = request.polar_fsinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateApplication',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_application(
        self,
        request: polardb_20170801_models.CreateApplicationRequest,
    ) -> polardb_20170801_models.CreateApplicationResponse:
        """
        @summary 创建PolarDB应用
        
        @param request: CreateApplicationRequest
        @return: CreateApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_application_with_options(request, runtime)

    async def create_application_async(
        self,
        request: polardb_20170801_models.CreateApplicationRequest,
    ) -> polardb_20170801_models.CreateApplicationResponse:
        """
        @summary 创建PolarDB应用
        
        @param request: CreateApplicationRequest
        @return: CreateApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_application_with_options_async(request, runtime)

    def create_application_endpoint_address_with_options(
        self,
        request: polardb_20170801_models.CreateApplicationEndpointAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateApplicationEndpointAddressResponse:
        """
        @summary 创建PolarDB应用终端节点地址
        
        @param request: CreateApplicationEndpointAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateApplicationEndpointAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateApplicationEndpointAddress',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateApplicationEndpointAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_application_endpoint_address_with_options_async(
        self,
        request: polardb_20170801_models.CreateApplicationEndpointAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateApplicationEndpointAddressResponse:
        """
        @summary 创建PolarDB应用终端节点地址
        
        @param request: CreateApplicationEndpointAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateApplicationEndpointAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateApplicationEndpointAddress',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateApplicationEndpointAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_application_endpoint_address(
        self,
        request: polardb_20170801_models.CreateApplicationEndpointAddressRequest,
    ) -> polardb_20170801_models.CreateApplicationEndpointAddressResponse:
        """
        @summary 创建PolarDB应用终端节点地址
        
        @param request: CreateApplicationEndpointAddressRequest
        @return: CreateApplicationEndpointAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_application_endpoint_address_with_options(request, runtime)

    async def create_application_endpoint_address_async(
        self,
        request: polardb_20170801_models.CreateApplicationEndpointAddressRequest,
    ) -> polardb_20170801_models.CreateApplicationEndpointAddressResponse:
        """
        @summary 创建PolarDB应用终端节点地址
        
        @param request: CreateApplicationEndpointAddressRequest
        @return: CreateApplicationEndpointAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_application_endpoint_address_with_options_async(request, runtime)

    def create_backup_with_options(
        self,
        request: polardb_20170801_models.CreateBackupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateBackupResponse:
        """
        @summary Creates a full snapshot backup for a PolarDB cluster.
        
        @description >
        You can manually create up to three backups for each cluster.
        The `Exceeding the daily backup times of this DB cluster` error message indicates that three manual backups already exist in your cluster. You must delete existing backups before you call this operation to manually create backups. For more information about how to delete backups, see [Delete backups](https://help.aliyun.com/document_detail/98101.html).
        After you call this operation, a backup task is created in the backend. The task may be time-consuming if you want to back up large amounts of data.
        
        @param request: CreateBackupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBackupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBackup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateBackupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_backup_with_options_async(
        self,
        request: polardb_20170801_models.CreateBackupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateBackupResponse:
        """
        @summary Creates a full snapshot backup for a PolarDB cluster.
        
        @description >
        You can manually create up to three backups for each cluster.
        The `Exceeding the daily backup times of this DB cluster` error message indicates that three manual backups already exist in your cluster. You must delete existing backups before you call this operation to manually create backups. For more information about how to delete backups, see [Delete backups](https://help.aliyun.com/document_detail/98101.html).
        After you call this operation, a backup task is created in the backend. The task may be time-consuming if you want to back up large amounts of data.
        
        @param request: CreateBackupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBackupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBackup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateBackupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_backup(
        self,
        request: polardb_20170801_models.CreateBackupRequest,
    ) -> polardb_20170801_models.CreateBackupResponse:
        """
        @summary Creates a full snapshot backup for a PolarDB cluster.
        
        @description >
        You can manually create up to three backups for each cluster.
        The `Exceeding the daily backup times of this DB cluster` error message indicates that three manual backups already exist in your cluster. You must delete existing backups before you call this operation to manually create backups. For more information about how to delete backups, see [Delete backups](https://help.aliyun.com/document_detail/98101.html).
        After you call this operation, a backup task is created in the backend. The task may be time-consuming if you want to back up large amounts of data.
        
        @param request: CreateBackupRequest
        @return: CreateBackupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_backup_with_options(request, runtime)

    async def create_backup_async(
        self,
        request: polardb_20170801_models.CreateBackupRequest,
    ) -> polardb_20170801_models.CreateBackupResponse:
        """
        @summary Creates a full snapshot backup for a PolarDB cluster.
        
        @description >
        You can manually create up to three backups for each cluster.
        The `Exceeding the daily backup times of this DB cluster` error message indicates that three manual backups already exist in your cluster. You must delete existing backups before you call this operation to manually create backups. For more information about how to delete backups, see [Delete backups](https://help.aliyun.com/document_detail/98101.html).
        After you call this operation, a backup task is created in the backend. The task may be time-consuming if you want to back up large amounts of data.
        
        @param request: CreateBackupRequest
        @return: CreateBackupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_backup_with_options_async(request, runtime)

    def create_cold_storage_instance_with_options(
        self,
        request: polardb_20170801_models.CreateColdStorageInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateColdStorageInstanceResponse:
        """
        @summary Creates a cluster that is used to store cold data.
        
        @param request: CreateColdStorageInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateColdStorageInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cold_storage_instance_description):
            query['ColdStorageInstanceDescription'] = request.cold_storage_instance_description
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateColdStorageInstance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateColdStorageInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_cold_storage_instance_with_options_async(
        self,
        request: polardb_20170801_models.CreateColdStorageInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateColdStorageInstanceResponse:
        """
        @summary Creates a cluster that is used to store cold data.
        
        @param request: CreateColdStorageInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateColdStorageInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cold_storage_instance_description):
            query['ColdStorageInstanceDescription'] = request.cold_storage_instance_description
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateColdStorageInstance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateColdStorageInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_cold_storage_instance(
        self,
        request: polardb_20170801_models.CreateColdStorageInstanceRequest,
    ) -> polardb_20170801_models.CreateColdStorageInstanceResponse:
        """
        @summary Creates a cluster that is used to store cold data.
        
        @param request: CreateColdStorageInstanceRequest
        @return: CreateColdStorageInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cold_storage_instance_with_options(request, runtime)

    async def create_cold_storage_instance_async(
        self,
        request: polardb_20170801_models.CreateColdStorageInstanceRequest,
    ) -> polardb_20170801_models.CreateColdStorageInstanceResponse:
        """
        @summary Creates a cluster that is used to store cold data.
        
        @param request: CreateColdStorageInstanceRequest
        @return: CreateColdStorageInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cold_storage_instance_with_options_async(request, runtime)

    def create_cron_job_policy_serverless_with_options(
        self,
        request: polardb_20170801_models.CreateCronJobPolicyServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateCronJobPolicyServerlessResponse:
        """
        @summary serverless创建周期任务策略
        
        @param request: CreateCronJobPolicyServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCronJobPolicyServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_shut_down):
            query['AllowShutDown'] = request.allow_shut_down
        if not UtilClient.is_unset(request.cron_expression):
            query['CronExpression'] = request.cron_expression
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scale_ap_ro_num_max):
            query['ScaleApRoNumMax'] = request.scale_ap_ro_num_max
        if not UtilClient.is_unset(request.scale_ap_ro_num_min):
            query['ScaleApRoNumMin'] = request.scale_ap_ro_num_min
        if not UtilClient.is_unset(request.scale_max):
            query['ScaleMax'] = request.scale_max
        if not UtilClient.is_unset(request.scale_min):
            query['ScaleMin'] = request.scale_min
        if not UtilClient.is_unset(request.scale_ro_num_max):
            query['ScaleRoNumMax'] = request.scale_ro_num_max
        if not UtilClient.is_unset(request.scale_ro_num_min):
            query['ScaleRoNumMin'] = request.scale_ro_num_min
        if not UtilClient.is_unset(request.seconds_until_auto_pause):
            query['SecondsUntilAutoPause'] = request.seconds_until_auto_pause
        if not UtilClient.is_unset(request.serverless_rule_cpu_enlarge_threshold):
            query['ServerlessRuleCpuEnlargeThreshold'] = request.serverless_rule_cpu_enlarge_threshold
        if not UtilClient.is_unset(request.serverless_rule_cpu_shrink_threshold):
            query['ServerlessRuleCpuShrinkThreshold'] = request.serverless_rule_cpu_shrink_threshold
        if not UtilClient.is_unset(request.serverless_rule_mode):
            query['ServerlessRuleMode'] = request.serverless_rule_mode
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCronJobPolicyServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateCronJobPolicyServerlessResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_cron_job_policy_serverless_with_options_async(
        self,
        request: polardb_20170801_models.CreateCronJobPolicyServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateCronJobPolicyServerlessResponse:
        """
        @summary serverless创建周期任务策略
        
        @param request: CreateCronJobPolicyServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCronJobPolicyServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_shut_down):
            query['AllowShutDown'] = request.allow_shut_down
        if not UtilClient.is_unset(request.cron_expression):
            query['CronExpression'] = request.cron_expression
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scale_ap_ro_num_max):
            query['ScaleApRoNumMax'] = request.scale_ap_ro_num_max
        if not UtilClient.is_unset(request.scale_ap_ro_num_min):
            query['ScaleApRoNumMin'] = request.scale_ap_ro_num_min
        if not UtilClient.is_unset(request.scale_max):
            query['ScaleMax'] = request.scale_max
        if not UtilClient.is_unset(request.scale_min):
            query['ScaleMin'] = request.scale_min
        if not UtilClient.is_unset(request.scale_ro_num_max):
            query['ScaleRoNumMax'] = request.scale_ro_num_max
        if not UtilClient.is_unset(request.scale_ro_num_min):
            query['ScaleRoNumMin'] = request.scale_ro_num_min
        if not UtilClient.is_unset(request.seconds_until_auto_pause):
            query['SecondsUntilAutoPause'] = request.seconds_until_auto_pause
        if not UtilClient.is_unset(request.serverless_rule_cpu_enlarge_threshold):
            query['ServerlessRuleCpuEnlargeThreshold'] = request.serverless_rule_cpu_enlarge_threshold
        if not UtilClient.is_unset(request.serverless_rule_cpu_shrink_threshold):
            query['ServerlessRuleCpuShrinkThreshold'] = request.serverless_rule_cpu_shrink_threshold
        if not UtilClient.is_unset(request.serverless_rule_mode):
            query['ServerlessRuleMode'] = request.serverless_rule_mode
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCronJobPolicyServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateCronJobPolicyServerlessResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_cron_job_policy_serverless(
        self,
        request: polardb_20170801_models.CreateCronJobPolicyServerlessRequest,
    ) -> polardb_20170801_models.CreateCronJobPolicyServerlessResponse:
        """
        @summary serverless创建周期任务策略
        
        @param request: CreateCronJobPolicyServerlessRequest
        @return: CreateCronJobPolicyServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cron_job_policy_serverless_with_options(request, runtime)

    async def create_cron_job_policy_serverless_async(
        self,
        request: polardb_20170801_models.CreateCronJobPolicyServerlessRequest,
    ) -> polardb_20170801_models.CreateCronJobPolicyServerlessResponse:
        """
        @summary serverless创建周期任务策略
        
        @param request: CreateCronJobPolicyServerlessRequest
        @return: CreateCronJobPolicyServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cron_job_policy_serverless_with_options_async(request, runtime)

    def create_dbcluster_with_options(
        self,
        request: polardb_20170801_models.CreateDBClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBClusterResponse:
        """
        @summary CreateDBCluster.
        
        @param request: CreateDBClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_shut_down):
            query['AllowShutDown'] = request.allow_shut_down
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.backup_retention_policy_on_cluster_deletion):
            query['BackupRetentionPolicyOnClusterDeletion'] = request.backup_retention_policy_on_cluster_deletion
        if not UtilClient.is_unset(request.bursting_enabled):
            query['BurstingEnabled'] = request.bursting_enabled
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.clone_data_point):
            query['CloneDataPoint'] = request.clone_data_point
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.cluster_network_type):
            query['ClusterNetworkType'] = request.cluster_network_type
        if not UtilClient.is_unset(request.creation_category):
            query['CreationCategory'] = request.creation_category
        if not UtilClient.is_unset(request.creation_option):
            query['CreationOption'] = request.creation_option
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbminor_version):
            query['DBMinorVersion'] = request.dbminor_version
        if not UtilClient.is_unset(request.dbnode_class):
            query['DBNodeClass'] = request.dbnode_class
        if not UtilClient.is_unset(request.dbnode_num):
            query['DBNodeNum'] = request.dbnode_num
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.default_time_zone):
            query['DefaultTimeZone'] = request.default_time_zone
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.gdnid):
            query['GDNId'] = request.gdnid
        if not UtilClient.is_unset(request.hot_standby_cluster):
            query['HotStandbyCluster'] = request.hot_standby_cluster
        if not UtilClient.is_unset(request.loose_polar_log_bin):
            query['LoosePolarLogBin'] = request.loose_polar_log_bin
        if not UtilClient.is_unset(request.loose_xengine):
            query['LooseXEngine'] = request.loose_xengine
        if not UtilClient.is_unset(request.loose_xengine_use_memory_pct):
            query['LooseXEngineUseMemoryPct'] = request.loose_xengine_use_memory_pct
        if not UtilClient.is_unset(request.lower_case_table_names):
            query['LowerCaseTableNames'] = request.lower_case_table_names
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parameter_group_id):
            query['ParameterGroupId'] = request.parameter_group_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.provisioned_iops):
            query['ProvisionedIops'] = request.provisioned_iops
        if not UtilClient.is_unset(request.proxy_class):
            query['ProxyClass'] = request.proxy_class
        if not UtilClient.is_unset(request.proxy_type):
            query['ProxyType'] = request.proxy_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scale_max):
            query['ScaleMax'] = request.scale_max
        if not UtilClient.is_unset(request.scale_min):
            query['ScaleMin'] = request.scale_min
        if not UtilClient.is_unset(request.scale_ro_num_max):
            query['ScaleRoNumMax'] = request.scale_ro_num_max
        if not UtilClient.is_unset(request.scale_ro_num_min):
            query['ScaleRoNumMin'] = request.scale_ro_num_min
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        if not UtilClient.is_unset(request.serverless_type):
            query['ServerlessType'] = request.serverless_type
        if not UtilClient.is_unset(request.source_resource_id):
            query['SourceResourceId'] = request.source_resource_id
        if not UtilClient.is_unset(request.source_uid):
            query['SourceUid'] = request.source_uid
        if not UtilClient.is_unset(request.standby_az):
            query['StandbyAZ'] = request.standby_az
        if not UtilClient.is_unset(request.storage_auto_scale):
            query['StorageAutoScale'] = request.storage_auto_scale
        if not UtilClient.is_unset(request.storage_encryption):
            query['StorageEncryption'] = request.storage_encryption
        if not UtilClient.is_unset(request.storage_encryption_key):
            query['StorageEncryptionKey'] = request.storage_encryption_key
        if not UtilClient.is_unset(request.storage_pay_type):
            query['StoragePayType'] = request.storage_pay_type
        if not UtilClient.is_unset(request.storage_space):
            query['StorageSpace'] = request.storage_space
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        if not UtilClient.is_unset(request.storage_upper_bound):
            query['StorageUpperBound'] = request.storage_upper_bound
        if not UtilClient.is_unset(request.strict_consistency):
            query['StrictConsistency'] = request.strict_consistency
        if not UtilClient.is_unset(request.tdestatus):
            query['TDEStatus'] = request.tdestatus
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.target_minor_version):
            query['TargetMinorVersion'] = request.target_minor_version
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        if not UtilClient.is_unset(request.vpcid):
            query['VPCId'] = request.vpcid
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBCluster',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dbcluster_with_options_async(
        self,
        request: polardb_20170801_models.CreateDBClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBClusterResponse:
        """
        @summary CreateDBCluster.
        
        @param request: CreateDBClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_shut_down):
            query['AllowShutDown'] = request.allow_shut_down
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.backup_retention_policy_on_cluster_deletion):
            query['BackupRetentionPolicyOnClusterDeletion'] = request.backup_retention_policy_on_cluster_deletion
        if not UtilClient.is_unset(request.bursting_enabled):
            query['BurstingEnabled'] = request.bursting_enabled
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.clone_data_point):
            query['CloneDataPoint'] = request.clone_data_point
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.cluster_network_type):
            query['ClusterNetworkType'] = request.cluster_network_type
        if not UtilClient.is_unset(request.creation_category):
            query['CreationCategory'] = request.creation_category
        if not UtilClient.is_unset(request.creation_option):
            query['CreationOption'] = request.creation_option
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbminor_version):
            query['DBMinorVersion'] = request.dbminor_version
        if not UtilClient.is_unset(request.dbnode_class):
            query['DBNodeClass'] = request.dbnode_class
        if not UtilClient.is_unset(request.dbnode_num):
            query['DBNodeNum'] = request.dbnode_num
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.default_time_zone):
            query['DefaultTimeZone'] = request.default_time_zone
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.gdnid):
            query['GDNId'] = request.gdnid
        if not UtilClient.is_unset(request.hot_standby_cluster):
            query['HotStandbyCluster'] = request.hot_standby_cluster
        if not UtilClient.is_unset(request.loose_polar_log_bin):
            query['LoosePolarLogBin'] = request.loose_polar_log_bin
        if not UtilClient.is_unset(request.loose_xengine):
            query['LooseXEngine'] = request.loose_xengine
        if not UtilClient.is_unset(request.loose_xengine_use_memory_pct):
            query['LooseXEngineUseMemoryPct'] = request.loose_xengine_use_memory_pct
        if not UtilClient.is_unset(request.lower_case_table_names):
            query['LowerCaseTableNames'] = request.lower_case_table_names
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parameter_group_id):
            query['ParameterGroupId'] = request.parameter_group_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.provisioned_iops):
            query['ProvisionedIops'] = request.provisioned_iops
        if not UtilClient.is_unset(request.proxy_class):
            query['ProxyClass'] = request.proxy_class
        if not UtilClient.is_unset(request.proxy_type):
            query['ProxyType'] = request.proxy_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scale_max):
            query['ScaleMax'] = request.scale_max
        if not UtilClient.is_unset(request.scale_min):
            query['ScaleMin'] = request.scale_min
        if not UtilClient.is_unset(request.scale_ro_num_max):
            query['ScaleRoNumMax'] = request.scale_ro_num_max
        if not UtilClient.is_unset(request.scale_ro_num_min):
            query['ScaleRoNumMin'] = request.scale_ro_num_min
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        if not UtilClient.is_unset(request.serverless_type):
            query['ServerlessType'] = request.serverless_type
        if not UtilClient.is_unset(request.source_resource_id):
            query['SourceResourceId'] = request.source_resource_id
        if not UtilClient.is_unset(request.source_uid):
            query['SourceUid'] = request.source_uid
        if not UtilClient.is_unset(request.standby_az):
            query['StandbyAZ'] = request.standby_az
        if not UtilClient.is_unset(request.storage_auto_scale):
            query['StorageAutoScale'] = request.storage_auto_scale
        if not UtilClient.is_unset(request.storage_encryption):
            query['StorageEncryption'] = request.storage_encryption
        if not UtilClient.is_unset(request.storage_encryption_key):
            query['StorageEncryptionKey'] = request.storage_encryption_key
        if not UtilClient.is_unset(request.storage_pay_type):
            query['StoragePayType'] = request.storage_pay_type
        if not UtilClient.is_unset(request.storage_space):
            query['StorageSpace'] = request.storage_space
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        if not UtilClient.is_unset(request.storage_upper_bound):
            query['StorageUpperBound'] = request.storage_upper_bound
        if not UtilClient.is_unset(request.strict_consistency):
            query['StrictConsistency'] = request.strict_consistency
        if not UtilClient.is_unset(request.tdestatus):
            query['TDEStatus'] = request.tdestatus
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.target_minor_version):
            query['TargetMinorVersion'] = request.target_minor_version
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        if not UtilClient.is_unset(request.vpcid):
            query['VPCId'] = request.vpcid
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBCluster',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dbcluster(
        self,
        request: polardb_20170801_models.CreateDBClusterRequest,
    ) -> polardb_20170801_models.CreateDBClusterResponse:
        """
        @summary CreateDBCluster.
        
        @param request: CreateDBClusterRequest
        @return: CreateDBClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dbcluster_with_options(request, runtime)

    async def create_dbcluster_async(
        self,
        request: polardb_20170801_models.CreateDBClusterRequest,
    ) -> polardb_20170801_models.CreateDBClusterResponse:
        """
        @summary CreateDBCluster.
        
        @param request: CreateDBClusterRequest
        @return: CreateDBClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dbcluster_with_options_async(request, runtime)

    def create_dbcluster_endpoint_with_options(
        self,
        request: polardb_20170801_models.CreateDBClusterEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBClusterEndpointResponse:
        """
        @summary Creates a custom cluster endpoint for a PolarDB cluster.
        
        @param request: CreateDBClusterEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBClusterEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_add_new_nodes):
            query['AutoAddNewNodes'] = request.auto_add_new_nodes
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_description):
            query['DBEndpointDescription'] = request.dbendpoint_description
        if not UtilClient.is_unset(request.endpoint_config):
            query['EndpointConfig'] = request.endpoint_config
        if not UtilClient.is_unset(request.endpoint_type):
            query['EndpointType'] = request.endpoint_type
        if not UtilClient.is_unset(request.nodes):
            query['Nodes'] = request.nodes
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.polar_scc_timeout_action):
            query['PolarSccTimeoutAction'] = request.polar_scc_timeout_action
        if not UtilClient.is_unset(request.polar_scc_wait_timeout):
            query['PolarSccWaitTimeout'] = request.polar_scc_wait_timeout
        if not UtilClient.is_unset(request.read_write_mode):
            query['ReadWriteMode'] = request.read_write_mode
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scc_mode):
            query['SccMode'] = request.scc_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBClusterEndpoint',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBClusterEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dbcluster_endpoint_with_options_async(
        self,
        request: polardb_20170801_models.CreateDBClusterEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBClusterEndpointResponse:
        """
        @summary Creates a custom cluster endpoint for a PolarDB cluster.
        
        @param request: CreateDBClusterEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBClusterEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_add_new_nodes):
            query['AutoAddNewNodes'] = request.auto_add_new_nodes
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_description):
            query['DBEndpointDescription'] = request.dbendpoint_description
        if not UtilClient.is_unset(request.endpoint_config):
            query['EndpointConfig'] = request.endpoint_config
        if not UtilClient.is_unset(request.endpoint_type):
            query['EndpointType'] = request.endpoint_type
        if not UtilClient.is_unset(request.nodes):
            query['Nodes'] = request.nodes
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.polar_scc_timeout_action):
            query['PolarSccTimeoutAction'] = request.polar_scc_timeout_action
        if not UtilClient.is_unset(request.polar_scc_wait_timeout):
            query['PolarSccWaitTimeout'] = request.polar_scc_wait_timeout
        if not UtilClient.is_unset(request.read_write_mode):
            query['ReadWriteMode'] = request.read_write_mode
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scc_mode):
            query['SccMode'] = request.scc_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBClusterEndpoint',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBClusterEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dbcluster_endpoint(
        self,
        request: polardb_20170801_models.CreateDBClusterEndpointRequest,
    ) -> polardb_20170801_models.CreateDBClusterEndpointResponse:
        """
        @summary Creates a custom cluster endpoint for a PolarDB cluster.
        
        @param request: CreateDBClusterEndpointRequest
        @return: CreateDBClusterEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dbcluster_endpoint_with_options(request, runtime)

    async def create_dbcluster_endpoint_async(
        self,
        request: polardb_20170801_models.CreateDBClusterEndpointRequest,
    ) -> polardb_20170801_models.CreateDBClusterEndpointResponse:
        """
        @summary Creates a custom cluster endpoint for a PolarDB cluster.
        
        @param request: CreateDBClusterEndpointRequest
        @return: CreateDBClusterEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dbcluster_endpoint_with_options_async(request, runtime)

    def create_dbcluster_endpoint_zonal_with_options(
        self,
        request: polardb_20170801_models.CreateDBClusterEndpointZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBClusterEndpointZonalResponse:
        """
        @summary 边缘云创建链接地址接口
        
        @param request: CreateDBClusterEndpointZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBClusterEndpointZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_add_new_nodes):
            query['AutoAddNewNodes'] = request.auto_add_new_nodes
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_description):
            query['DBEndpointDescription'] = request.dbendpoint_description
        if not UtilClient.is_unset(request.endpoint_config):
            query['EndpointConfig'] = request.endpoint_config
        if not UtilClient.is_unset(request.endpoint_type):
            query['EndpointType'] = request.endpoint_type
        if not UtilClient.is_unset(request.nodes):
            query['Nodes'] = request.nodes
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.polar_scc_timeout_action):
            query['PolarSccTimeoutAction'] = request.polar_scc_timeout_action
        if not UtilClient.is_unset(request.polar_scc_wait_timeout):
            query['PolarSccWaitTimeout'] = request.polar_scc_wait_timeout
        if not UtilClient.is_unset(request.read_write_mode):
            query['ReadWriteMode'] = request.read_write_mode
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scc_mode):
            query['SccMode'] = request.scc_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBClusterEndpointZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBClusterEndpointZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dbcluster_endpoint_zonal_with_options_async(
        self,
        request: polardb_20170801_models.CreateDBClusterEndpointZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBClusterEndpointZonalResponse:
        """
        @summary 边缘云创建链接地址接口
        
        @param request: CreateDBClusterEndpointZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBClusterEndpointZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_add_new_nodes):
            query['AutoAddNewNodes'] = request.auto_add_new_nodes
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_description):
            query['DBEndpointDescription'] = request.dbendpoint_description
        if not UtilClient.is_unset(request.endpoint_config):
            query['EndpointConfig'] = request.endpoint_config
        if not UtilClient.is_unset(request.endpoint_type):
            query['EndpointType'] = request.endpoint_type
        if not UtilClient.is_unset(request.nodes):
            query['Nodes'] = request.nodes
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.polar_scc_timeout_action):
            query['PolarSccTimeoutAction'] = request.polar_scc_timeout_action
        if not UtilClient.is_unset(request.polar_scc_wait_timeout):
            query['PolarSccWaitTimeout'] = request.polar_scc_wait_timeout
        if not UtilClient.is_unset(request.read_write_mode):
            query['ReadWriteMode'] = request.read_write_mode
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scc_mode):
            query['SccMode'] = request.scc_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBClusterEndpointZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBClusterEndpointZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dbcluster_endpoint_zonal(
        self,
        request: polardb_20170801_models.CreateDBClusterEndpointZonalRequest,
    ) -> polardb_20170801_models.CreateDBClusterEndpointZonalResponse:
        """
        @summary 边缘云创建链接地址接口
        
        @param request: CreateDBClusterEndpointZonalRequest
        @return: CreateDBClusterEndpointZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dbcluster_endpoint_zonal_with_options(request, runtime)

    async def create_dbcluster_endpoint_zonal_async(
        self,
        request: polardb_20170801_models.CreateDBClusterEndpointZonalRequest,
    ) -> polardb_20170801_models.CreateDBClusterEndpointZonalResponse:
        """
        @summary 边缘云创建链接地址接口
        
        @param request: CreateDBClusterEndpointZonalRequest
        @return: CreateDBClusterEndpointZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dbcluster_endpoint_zonal_with_options_async(request, runtime)

    def create_dbendpoint_address_with_options(
        self,
        request: polardb_20170801_models.CreateDBEndpointAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBEndpointAddressResponse:
        """
        @summary Creates a public endpoint for the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        
        @description > You can create a public endpoint for the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        
        @param request: CreateDBEndpointAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBEndpointAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string_prefix):
            query['ConnectionStringPrefix'] = request.connection_string_prefix
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.vpcid):
            query['VPCId'] = request.vpcid
        if not UtilClient.is_unset(request.zone_info):
            query['ZoneInfo'] = request.zone_info
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBEndpointAddress',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBEndpointAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dbendpoint_address_with_options_async(
        self,
        request: polardb_20170801_models.CreateDBEndpointAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBEndpointAddressResponse:
        """
        @summary Creates a public endpoint for the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        
        @description > You can create a public endpoint for the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        
        @param request: CreateDBEndpointAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBEndpointAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string_prefix):
            query['ConnectionStringPrefix'] = request.connection_string_prefix
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.vpcid):
            query['VPCId'] = request.vpcid
        if not UtilClient.is_unset(request.zone_info):
            query['ZoneInfo'] = request.zone_info
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBEndpointAddress',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBEndpointAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dbendpoint_address(
        self,
        request: polardb_20170801_models.CreateDBEndpointAddressRequest,
    ) -> polardb_20170801_models.CreateDBEndpointAddressResponse:
        """
        @summary Creates a public endpoint for the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        
        @description > You can create a public endpoint for the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        
        @param request: CreateDBEndpointAddressRequest
        @return: CreateDBEndpointAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dbendpoint_address_with_options(request, runtime)

    async def create_dbendpoint_address_async(
        self,
        request: polardb_20170801_models.CreateDBEndpointAddressRequest,
    ) -> polardb_20170801_models.CreateDBEndpointAddressResponse:
        """
        @summary Creates a public endpoint for the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        
        @description > You can create a public endpoint for the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        
        @param request: CreateDBEndpointAddressRequest
        @return: CreateDBEndpointAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dbendpoint_address_with_options_async(request, runtime)

    def create_dblink_with_options(
        self,
        request: polardb_20170801_models.CreateDBLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBLinkResponse:
        """
        @summary Creates a database link.
        
        @description A database link can be used to connect two PolarDB for PostgreSQL(Compatible with Oracle) clusters, or connect a PolarDB for PostgreSQL(Compatible with Oracle) cluster to a user-created PostgreSQL database that is hosted on an Elastic Compute Service (ECS) instance. You can use database links to query data across clusters.
        >    You can create up to 10 database links for a cluster.
        >    Each database link connects a source cluster and a destination cluster.
        >    The source cluster and the destination cluster or the destination ECS instance must be located in the same region.
        
        @param request: CreateDBLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dblink_name):
            query['DBLinkName'] = request.dblink_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_dbname):
            query['SourceDBName'] = request.source_dbname
        if not UtilClient.is_unset(request.target_dbaccount):
            query['TargetDBAccount'] = request.target_dbaccount
        if not UtilClient.is_unset(request.target_dbinstance_name):
            query['TargetDBInstanceName'] = request.target_dbinstance_name
        if not UtilClient.is_unset(request.target_dbname):
            query['TargetDBName'] = request.target_dbname
        if not UtilClient.is_unset(request.target_dbpasswd):
            query['TargetDBPasswd'] = request.target_dbpasswd
        if not UtilClient.is_unset(request.target_ip):
            query['TargetIp'] = request.target_ip
        if not UtilClient.is_unset(request.target_port):
            query['TargetPort'] = request.target_port
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBLink',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBLinkResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dblink_with_options_async(
        self,
        request: polardb_20170801_models.CreateDBLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBLinkResponse:
        """
        @summary Creates a database link.
        
        @description A database link can be used to connect two PolarDB for PostgreSQL(Compatible with Oracle) clusters, or connect a PolarDB for PostgreSQL(Compatible with Oracle) cluster to a user-created PostgreSQL database that is hosted on an Elastic Compute Service (ECS) instance. You can use database links to query data across clusters.
        >    You can create up to 10 database links for a cluster.
        >    Each database link connects a source cluster and a destination cluster.
        >    The source cluster and the destination cluster or the destination ECS instance must be located in the same region.
        
        @param request: CreateDBLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dblink_name):
            query['DBLinkName'] = request.dblink_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_dbname):
            query['SourceDBName'] = request.source_dbname
        if not UtilClient.is_unset(request.target_dbaccount):
            query['TargetDBAccount'] = request.target_dbaccount
        if not UtilClient.is_unset(request.target_dbinstance_name):
            query['TargetDBInstanceName'] = request.target_dbinstance_name
        if not UtilClient.is_unset(request.target_dbname):
            query['TargetDBName'] = request.target_dbname
        if not UtilClient.is_unset(request.target_dbpasswd):
            query['TargetDBPasswd'] = request.target_dbpasswd
        if not UtilClient.is_unset(request.target_ip):
            query['TargetIp'] = request.target_ip
        if not UtilClient.is_unset(request.target_port):
            query['TargetPort'] = request.target_port
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBLink',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBLinkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dblink(
        self,
        request: polardb_20170801_models.CreateDBLinkRequest,
    ) -> polardb_20170801_models.CreateDBLinkResponse:
        """
        @summary Creates a database link.
        
        @description A database link can be used to connect two PolarDB for PostgreSQL(Compatible with Oracle) clusters, or connect a PolarDB for PostgreSQL(Compatible with Oracle) cluster to a user-created PostgreSQL database that is hosted on an Elastic Compute Service (ECS) instance. You can use database links to query data across clusters.
        >    You can create up to 10 database links for a cluster.
        >    Each database link connects a source cluster and a destination cluster.
        >    The source cluster and the destination cluster or the destination ECS instance must be located in the same region.
        
        @param request: CreateDBLinkRequest
        @return: CreateDBLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dblink_with_options(request, runtime)

    async def create_dblink_async(
        self,
        request: polardb_20170801_models.CreateDBLinkRequest,
    ) -> polardb_20170801_models.CreateDBLinkResponse:
        """
        @summary Creates a database link.
        
        @description A database link can be used to connect two PolarDB for PostgreSQL(Compatible with Oracle) clusters, or connect a PolarDB for PostgreSQL(Compatible with Oracle) cluster to a user-created PostgreSQL database that is hosted on an Elastic Compute Service (ECS) instance. You can use database links to query data across clusters.
        >    You can create up to 10 database links for a cluster.
        >    Each database link connects a source cluster and a destination cluster.
        >    The source cluster and the destination cluster or the destination ECS instance must be located in the same region.
        
        @param request: CreateDBLinkRequest
        @return: CreateDBLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dblink_with_options_async(request, runtime)

    def create_dbnodes_with_options(
        self,
        request: polardb_20170801_models.CreateDBNodesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBNodesResponse:
        """
        @summary Adds a read-only node to a PolarDB cluster.
        
        @param request: CreateDBNodesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBNodesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode):
            query['DBNode'] = request.dbnode
        if not UtilClient.is_unset(request.dbnode_type):
            query['DBNodeType'] = request.dbnode_type
        if not UtilClient.is_unset(request.endpoint_bind_list):
            query['EndpointBindList'] = request.endpoint_bind_list
        if not UtilClient.is_unset(request.imci_switch):
            query['ImciSwitch'] = request.imci_switch
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.planned_end_time):
            query['PlannedEndTime'] = request.planned_end_time
        if not UtilClient.is_unset(request.planned_start_time):
            query['PlannedStartTime'] = request.planned_start_time
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBNodes',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBNodesResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dbnodes_with_options_async(
        self,
        request: polardb_20170801_models.CreateDBNodesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDBNodesResponse:
        """
        @summary Adds a read-only node to a PolarDB cluster.
        
        @param request: CreateDBNodesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBNodesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode):
            query['DBNode'] = request.dbnode
        if not UtilClient.is_unset(request.dbnode_type):
            query['DBNodeType'] = request.dbnode_type
        if not UtilClient.is_unset(request.endpoint_bind_list):
            query['EndpointBindList'] = request.endpoint_bind_list
        if not UtilClient.is_unset(request.imci_switch):
            query['ImciSwitch'] = request.imci_switch
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.planned_end_time):
            query['PlannedEndTime'] = request.planned_end_time
        if not UtilClient.is_unset(request.planned_start_time):
            query['PlannedStartTime'] = request.planned_start_time
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBNodes',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDBNodesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dbnodes(
        self,
        request: polardb_20170801_models.CreateDBNodesRequest,
    ) -> polardb_20170801_models.CreateDBNodesResponse:
        """
        @summary Adds a read-only node to a PolarDB cluster.
        
        @param request: CreateDBNodesRequest
        @return: CreateDBNodesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dbnodes_with_options(request, runtime)

    async def create_dbnodes_async(
        self,
        request: polardb_20170801_models.CreateDBNodesRequest,
    ) -> polardb_20170801_models.CreateDBNodesResponse:
        """
        @summary Adds a read-only node to a PolarDB cluster.
        
        @param request: CreateDBNodesRequest
        @return: CreateDBNodesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dbnodes_with_options_async(request, runtime)

    def create_database_with_options(
        self,
        request: polardb_20170801_models.CreateDatabaseRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDatabaseResponse:
        """
        @summary Creates a database for a PolarDB cluster.
        
        @description Before you call this operation, make sure that the following requirements are met:
        The cluster is in the Running state.
        The cluster is unlocked.
        
        @param request: CreateDatabaseRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDatabaseResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_privilege):
            query['AccountPrivilege'] = request.account_privilege
        if not UtilClient.is_unset(request.character_set_name):
            query['CharacterSetName'] = request.character_set_name
        if not UtilClient.is_unset(request.collate):
            query['Collate'] = request.collate
        if not UtilClient.is_unset(request.ctype):
            query['Ctype'] = request.ctype
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbdescription):
            query['DBDescription'] = request.dbdescription
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDatabase',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDatabaseResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_database_with_options_async(
        self,
        request: polardb_20170801_models.CreateDatabaseRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDatabaseResponse:
        """
        @summary Creates a database for a PolarDB cluster.
        
        @description Before you call this operation, make sure that the following requirements are met:
        The cluster is in the Running state.
        The cluster is unlocked.
        
        @param request: CreateDatabaseRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDatabaseResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_privilege):
            query['AccountPrivilege'] = request.account_privilege
        if not UtilClient.is_unset(request.character_set_name):
            query['CharacterSetName'] = request.character_set_name
        if not UtilClient.is_unset(request.collate):
            query['Collate'] = request.collate
        if not UtilClient.is_unset(request.ctype):
            query['Ctype'] = request.ctype
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbdescription):
            query['DBDescription'] = request.dbdescription
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDatabase',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDatabaseResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_database(
        self,
        request: polardb_20170801_models.CreateDatabaseRequest,
    ) -> polardb_20170801_models.CreateDatabaseResponse:
        """
        @summary Creates a database for a PolarDB cluster.
        
        @description Before you call this operation, make sure that the following requirements are met:
        The cluster is in the Running state.
        The cluster is unlocked.
        
        @param request: CreateDatabaseRequest
        @return: CreateDatabaseResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_database_with_options(request, runtime)

    async def create_database_async(
        self,
        request: polardb_20170801_models.CreateDatabaseRequest,
    ) -> polardb_20170801_models.CreateDatabaseResponse:
        """
        @summary Creates a database for a PolarDB cluster.
        
        @description Before you call this operation, make sure that the following requirements are met:
        The cluster is in the Running state.
        The cluster is unlocked.
        
        @param request: CreateDatabaseRequest
        @return: CreateDatabaseResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_database_with_options_async(request, runtime)

    def create_database_zonal_with_options(
        self,
        request: polardb_20170801_models.CreateDatabaseZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDatabaseZonalResponse:
        """
        @summary 创建PolarDB边缘云数据库
        
        @param request: CreateDatabaseZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDatabaseZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_privilege):
            query['AccountPrivilege'] = request.account_privilege
        if not UtilClient.is_unset(request.character_set_name):
            query['CharacterSetName'] = request.character_set_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.collate):
            query['Collate'] = request.collate
        if not UtilClient.is_unset(request.ctype):
            query['Ctype'] = request.ctype
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbdescription):
            query['DBDescription'] = request.dbdescription
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDatabaseZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDatabaseZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_database_zonal_with_options_async(
        self,
        request: polardb_20170801_models.CreateDatabaseZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateDatabaseZonalResponse:
        """
        @summary 创建PolarDB边缘云数据库
        
        @param request: CreateDatabaseZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDatabaseZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_privilege):
            query['AccountPrivilege'] = request.account_privilege
        if not UtilClient.is_unset(request.character_set_name):
            query['CharacterSetName'] = request.character_set_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.collate):
            query['Collate'] = request.collate
        if not UtilClient.is_unset(request.ctype):
            query['Ctype'] = request.ctype
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbdescription):
            query['DBDescription'] = request.dbdescription
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDatabaseZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateDatabaseZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_database_zonal(
        self,
        request: polardb_20170801_models.CreateDatabaseZonalRequest,
    ) -> polardb_20170801_models.CreateDatabaseZonalResponse:
        """
        @summary 创建PolarDB边缘云数据库
        
        @param request: CreateDatabaseZonalRequest
        @return: CreateDatabaseZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_database_zonal_with_options(request, runtime)

    async def create_database_zonal_async(
        self,
        request: polardb_20170801_models.CreateDatabaseZonalRequest,
    ) -> polardb_20170801_models.CreateDatabaseZonalResponse:
        """
        @summary 创建PolarDB边缘云数据库
        
        @param request: CreateDatabaseZonalRequest
        @return: CreateDatabaseZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_database_zonal_with_options_async(request, runtime)

    def create_extensions_with_options(
        self,
        request: polardb_20170801_models.CreateExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateExtensionsResponse:
        """
        @summary 创建插件
        
        @param request: CreateExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnames):
            query['DBNames'] = request.dbnames
        if not UtilClient.is_unset(request.extensions):
            query['Extensions'] = request.extensions
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_dbname):
            query['SourceDBName'] = request.source_dbname
        if not UtilClient.is_unset(request.version):
            query['Version'] = request.version
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExtensions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateExtensionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_extensions_with_options_async(
        self,
        request: polardb_20170801_models.CreateExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateExtensionsResponse:
        """
        @summary 创建插件
        
        @param request: CreateExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnames):
            query['DBNames'] = request.dbnames
        if not UtilClient.is_unset(request.extensions):
            query['Extensions'] = request.extensions
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_dbname):
            query['SourceDBName'] = request.source_dbname
        if not UtilClient.is_unset(request.version):
            query['Version'] = request.version
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExtensions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateExtensionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_extensions(
        self,
        request: polardb_20170801_models.CreateExtensionsRequest,
    ) -> polardb_20170801_models.CreateExtensionsResponse:
        """
        @summary 创建插件
        
        @param request: CreateExtensionsRequest
        @return: CreateExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_extensions_with_options(request, runtime)

    async def create_extensions_async(
        self,
        request: polardb_20170801_models.CreateExtensionsRequest,
    ) -> polardb_20170801_models.CreateExtensionsResponse:
        """
        @summary 创建插件
        
        @param request: CreateExtensionsRequest
        @return: CreateExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_extensions_with_options_async(request, runtime)

    def create_global_data_network_with_options(
        self,
        request: polardb_20170801_models.CreateGlobalDataNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateGlobalDataNetworkResponse:
        """
        @summary 创建全球数据网络
        
        @param request: CreateGlobalDataNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGlobalDataNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_file_system_path):
            query['DestinationFileSystemPath'] = request.destination_file_system_path
        if not UtilClient.is_unset(request.destination_id):
            query['DestinationId'] = request.destination_id
        if not UtilClient.is_unset(request.destination_region):
            query['DestinationRegion'] = request.destination_region
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.freeze_source_during_sync):
            query['FreezeSourceDuringSync'] = request.freeze_source_during_sync
        if not UtilClient.is_unset(request.source_file_system_path):
            query['SourceFileSystemPath'] = request.source_file_system_path
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_region):
            query['SourceRegion'] = request.source_region
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalDataNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateGlobalDataNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_global_data_network_with_options_async(
        self,
        request: polardb_20170801_models.CreateGlobalDataNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateGlobalDataNetworkResponse:
        """
        @summary 创建全球数据网络
        
        @param request: CreateGlobalDataNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGlobalDataNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_file_system_path):
            query['DestinationFileSystemPath'] = request.destination_file_system_path
        if not UtilClient.is_unset(request.destination_id):
            query['DestinationId'] = request.destination_id
        if not UtilClient.is_unset(request.destination_region):
            query['DestinationRegion'] = request.destination_region
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.freeze_source_during_sync):
            query['FreezeSourceDuringSync'] = request.freeze_source_during_sync
        if not UtilClient.is_unset(request.source_file_system_path):
            query['SourceFileSystemPath'] = request.source_file_system_path
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_region):
            query['SourceRegion'] = request.source_region
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalDataNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateGlobalDataNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_global_data_network(
        self,
        request: polardb_20170801_models.CreateGlobalDataNetworkRequest,
    ) -> polardb_20170801_models.CreateGlobalDataNetworkResponse:
        """
        @summary 创建全球数据网络
        
        @param request: CreateGlobalDataNetworkRequest
        @return: CreateGlobalDataNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_global_data_network_with_options(request, runtime)

    async def create_global_data_network_async(
        self,
        request: polardb_20170801_models.CreateGlobalDataNetworkRequest,
    ) -> polardb_20170801_models.CreateGlobalDataNetworkResponse:
        """
        @summary 创建全球数据网络
        
        @param request: CreateGlobalDataNetworkRequest
        @return: CreateGlobalDataNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_global_data_network_with_options_async(request, runtime)

    def create_global_database_network_with_options(
        self,
        request: polardb_20170801_models.CreateGlobalDatabaseNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateGlobalDatabaseNetworkResponse:
        """
        @summary Creates a global database network (GDN).
        
        @description >  A cluster belongs to only one GDN.
        
        @param request: CreateGlobalDatabaseNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGlobalDatabaseNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.enable_global_domain_name):
            query['EnableGlobalDomainName'] = request.enable_global_domain_name
        if not UtilClient.is_unset(request.gdndescription):
            query['GDNDescription'] = request.gdndescription
        if not UtilClient.is_unset(request.gdnversion):
            query['GDNVersion'] = request.gdnversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalDatabaseNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateGlobalDatabaseNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_global_database_network_with_options_async(
        self,
        request: polardb_20170801_models.CreateGlobalDatabaseNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateGlobalDatabaseNetworkResponse:
        """
        @summary Creates a global database network (GDN).
        
        @description >  A cluster belongs to only one GDN.
        
        @param request: CreateGlobalDatabaseNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGlobalDatabaseNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.enable_global_domain_name):
            query['EnableGlobalDomainName'] = request.enable_global_domain_name
        if not UtilClient.is_unset(request.gdndescription):
            query['GDNDescription'] = request.gdndescription
        if not UtilClient.is_unset(request.gdnversion):
            query['GDNVersion'] = request.gdnversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalDatabaseNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateGlobalDatabaseNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_global_database_network(
        self,
        request: polardb_20170801_models.CreateGlobalDatabaseNetworkRequest,
    ) -> polardb_20170801_models.CreateGlobalDatabaseNetworkResponse:
        """
        @summary Creates a global database network (GDN).
        
        @description >  A cluster belongs to only one GDN.
        
        @param request: CreateGlobalDatabaseNetworkRequest
        @return: CreateGlobalDatabaseNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_global_database_network_with_options(request, runtime)

    async def create_global_database_network_async(
        self,
        request: polardb_20170801_models.CreateGlobalDatabaseNetworkRequest,
    ) -> polardb_20170801_models.CreateGlobalDatabaseNetworkResponse:
        """
        @summary Creates a global database network (GDN).
        
        @description >  A cluster belongs to only one GDN.
        
        @param request: CreateGlobalDatabaseNetworkRequest
        @return: CreateGlobalDatabaseNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_global_database_network_with_options_async(request, runtime)

    def create_global_security_ipgroup_with_options(
        self,
        request: polardb_20170801_models.CreateGlobalSecurityIPGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateGlobalSecurityIPGroupResponse:
        """
        @summary Creates a global IP whitelist template.
        
        @param request: CreateGlobalSecurityIPGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGlobalSecurityIPGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gip_list):
            query['GIpList'] = request.gip_list
        if not UtilClient.is_unset(request.global_ig_name):
            query['GlobalIgName'] = request.global_ig_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalSecurityIPGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateGlobalSecurityIPGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_global_security_ipgroup_with_options_async(
        self,
        request: polardb_20170801_models.CreateGlobalSecurityIPGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateGlobalSecurityIPGroupResponse:
        """
        @summary Creates a global IP whitelist template.
        
        @param request: CreateGlobalSecurityIPGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGlobalSecurityIPGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gip_list):
            query['GIpList'] = request.gip_list
        if not UtilClient.is_unset(request.global_ig_name):
            query['GlobalIgName'] = request.global_ig_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalSecurityIPGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateGlobalSecurityIPGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_global_security_ipgroup(
        self,
        request: polardb_20170801_models.CreateGlobalSecurityIPGroupRequest,
    ) -> polardb_20170801_models.CreateGlobalSecurityIPGroupResponse:
        """
        @summary Creates a global IP whitelist template.
        
        @param request: CreateGlobalSecurityIPGroupRequest
        @return: CreateGlobalSecurityIPGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_global_security_ipgroup_with_options(request, runtime)

    async def create_global_security_ipgroup_async(
        self,
        request: polardb_20170801_models.CreateGlobalSecurityIPGroupRequest,
    ) -> polardb_20170801_models.CreateGlobalSecurityIPGroupResponse:
        """
        @summary Creates a global IP whitelist template.
        
        @param request: CreateGlobalSecurityIPGroupRequest
        @return: CreateGlobalSecurityIPGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_global_security_ipgroup_with_options_async(request, runtime)

    def create_network_channel_with_options(
        self,
        request: polardb_20170801_models.CreateNetworkChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateNetworkChannelResponse:
        """
        @summary 创建网络通道
        
        @param request: CreateNetworkChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.notes):
            query['Notes'] = request.notes
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.target_dbcluster_id):
            query['TargetDBClusterId'] = request.target_dbcluster_id
        if not UtilClient.is_unset(request.target_ip):
            query['TargetIp'] = request.target_ip
        if not UtilClient.is_unset(request.target_port):
            query['TargetPort'] = request.target_port
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkChannel',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateNetworkChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_channel_with_options_async(
        self,
        request: polardb_20170801_models.CreateNetworkChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateNetworkChannelResponse:
        """
        @summary 创建网络通道
        
        @param request: CreateNetworkChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.notes):
            query['Notes'] = request.notes
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.target_dbcluster_id):
            query['TargetDBClusterId'] = request.target_dbcluster_id
        if not UtilClient.is_unset(request.target_ip):
            query['TargetIp'] = request.target_ip
        if not UtilClient.is_unset(request.target_port):
            query['TargetPort'] = request.target_port
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkChannel',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateNetworkChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_channel(
        self,
        request: polardb_20170801_models.CreateNetworkChannelRequest,
    ) -> polardb_20170801_models.CreateNetworkChannelResponse:
        """
        @summary 创建网络通道
        
        @param request: CreateNetworkChannelRequest
        @return: CreateNetworkChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_channel_with_options(request, runtime)

    async def create_network_channel_async(
        self,
        request: polardb_20170801_models.CreateNetworkChannelRequest,
    ) -> polardb_20170801_models.CreateNetworkChannelResponse:
        """
        @summary 创建网络通道
        
        @param request: CreateNetworkChannelRequest
        @return: CreateNetworkChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_channel_with_options_async(request, runtime)

    def create_or_get_virtual_license_order_with_options(
        self,
        request: polardb_20170801_models.CreateOrGetVirtualLicenseOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateOrGetVirtualLicenseOrderResponse:
        """
        @summary Creates or obtains a virtual license order.
        
        @param request: CreateOrGetVirtualLicenseOrderRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrGetVirtualLicenseOrderResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.engine):
            query['Engine'] = request.engine
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrGetVirtualLicenseOrder',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateOrGetVirtualLicenseOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_or_get_virtual_license_order_with_options_async(
        self,
        request: polardb_20170801_models.CreateOrGetVirtualLicenseOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateOrGetVirtualLicenseOrderResponse:
        """
        @summary Creates or obtains a virtual license order.
        
        @param request: CreateOrGetVirtualLicenseOrderRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrGetVirtualLicenseOrderResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.engine):
            query['Engine'] = request.engine
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrGetVirtualLicenseOrder',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateOrGetVirtualLicenseOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_or_get_virtual_license_order(
        self,
        request: polardb_20170801_models.CreateOrGetVirtualLicenseOrderRequest,
    ) -> polardb_20170801_models.CreateOrGetVirtualLicenseOrderResponse:
        """
        @summary Creates or obtains a virtual license order.
        
        @param request: CreateOrGetVirtualLicenseOrderRequest
        @return: CreateOrGetVirtualLicenseOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_or_get_virtual_license_order_with_options(request, runtime)

    async def create_or_get_virtual_license_order_async(
        self,
        request: polardb_20170801_models.CreateOrGetVirtualLicenseOrderRequest,
    ) -> polardb_20170801_models.CreateOrGetVirtualLicenseOrderResponse:
        """
        @summary Creates or obtains a virtual license order.
        
        @param request: CreateOrGetVirtualLicenseOrderRequest
        @return: CreateOrGetVirtualLicenseOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_or_get_virtual_license_order_with_options_async(request, runtime)

    def create_parameter_group_with_options(
        self,
        request: polardb_20170801_models.CreateParameterGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateParameterGroupResponse:
        """
        @summary Creates a parameter template.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > You can call this operation only on a PolarDB for MySQL cluster.
        
        @param request: CreateParameterGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateParameterGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parameter_group_desc):
            query['ParameterGroupDesc'] = request.parameter_group_desc
        if not UtilClient.is_unset(request.parameter_group_name):
            query['ParameterGroupName'] = request.parameter_group_name
        if not UtilClient.is_unset(request.parameters):
            query['Parameters'] = request.parameters
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateParameterGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateParameterGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_parameter_group_with_options_async(
        self,
        request: polardb_20170801_models.CreateParameterGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateParameterGroupResponse:
        """
        @summary Creates a parameter template.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > You can call this operation only on a PolarDB for MySQL cluster.
        
        @param request: CreateParameterGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateParameterGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parameter_group_desc):
            query['ParameterGroupDesc'] = request.parameter_group_desc
        if not UtilClient.is_unset(request.parameter_group_name):
            query['ParameterGroupName'] = request.parameter_group_name
        if not UtilClient.is_unset(request.parameters):
            query['Parameters'] = request.parameters
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateParameterGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateParameterGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_parameter_group(
        self,
        request: polardb_20170801_models.CreateParameterGroupRequest,
    ) -> polardb_20170801_models.CreateParameterGroupResponse:
        """
        @summary Creates a parameter template.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > You can call this operation only on a PolarDB for MySQL cluster.
        
        @param request: CreateParameterGroupRequest
        @return: CreateParameterGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_parameter_group_with_options(request, runtime)

    async def create_parameter_group_async(
        self,
        request: polardb_20170801_models.CreateParameterGroupRequest,
    ) -> polardb_20170801_models.CreateParameterGroupResponse:
        """
        @summary Creates a parameter template.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > You can call this operation only on a PolarDB for MySQL cluster.
        
        @param request: CreateParameterGroupRequest
        @return: CreateParameterGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_parameter_group_with_options_async(request, runtime)

    def create_service_linked_role_with_options(
        self,
        request: polardb_20170801_models.CreateServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role (SLR).
        
        @param request: CreateServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceLinkedRole',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateServiceLinkedRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_service_linked_role_with_options_async(
        self,
        request: polardb_20170801_models.CreateServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role (SLR).
        
        @param request: CreateServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceLinkedRole',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateServiceLinkedRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_service_linked_role(
        self,
        request: polardb_20170801_models.CreateServiceLinkedRoleRequest,
    ) -> polardb_20170801_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role (SLR).
        
        @param request: CreateServiceLinkedRoleRequest
        @return: CreateServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_service_linked_role_with_options(request, runtime)

    async def create_service_linked_role_async(
        self,
        request: polardb_20170801_models.CreateServiceLinkedRoleRequest,
    ) -> polardb_20170801_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role (SLR).
        
        @param request: CreateServiceLinkedRoleRequest
        @return: CreateServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_service_linked_role_with_options_async(request, runtime)

    def create_storage_plan_with_options(
        self,
        request: polardb_20170801_models.CreateStoragePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateStoragePlanResponse:
        """
        @summary Purchases a storage plan.
        
        @param request: CreateStoragePlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStoragePlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_class):
            query['StorageClass'] = request.storage_class
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStoragePlan',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateStoragePlanResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_storage_plan_with_options_async(
        self,
        request: polardb_20170801_models.CreateStoragePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.CreateStoragePlanResponse:
        """
        @summary Purchases a storage plan.
        
        @param request: CreateStoragePlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStoragePlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_class):
            query['StorageClass'] = request.storage_class
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStoragePlan',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.CreateStoragePlanResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_storage_plan(
        self,
        request: polardb_20170801_models.CreateStoragePlanRequest,
    ) -> polardb_20170801_models.CreateStoragePlanResponse:
        """
        @summary Purchases a storage plan.
        
        @param request: CreateStoragePlanRequest
        @return: CreateStoragePlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_storage_plan_with_options(request, runtime)

    async def create_storage_plan_async(
        self,
        request: polardb_20170801_models.CreateStoragePlanRequest,
    ) -> polardb_20170801_models.CreateStoragePlanResponse:
        """
        @summary Purchases a storage plan.
        
        @param request: CreateStoragePlanRequest
        @return: CreateStoragePlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_storage_plan_with_options_async(request, runtime)

    def delete_aidbcluster_with_options(
        self,
        request: polardb_20170801_models.DeleteAIDBClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteAIDBClusterResponse:
        """
        @summary 删除AI集群实例
        
        @param request: DeleteAIDBClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAIDBClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAIDBCluster',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteAIDBClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_aidbcluster_with_options_async(
        self,
        request: polardb_20170801_models.DeleteAIDBClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteAIDBClusterResponse:
        """
        @summary 删除AI集群实例
        
        @param request: DeleteAIDBClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAIDBClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAIDBCluster',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteAIDBClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_aidbcluster(
        self,
        request: polardb_20170801_models.DeleteAIDBClusterRequest,
    ) -> polardb_20170801_models.DeleteAIDBClusterResponse:
        """
        @summary 删除AI集群实例
        
        @param request: DeleteAIDBClusterRequest
        @return: DeleteAIDBClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_aidbcluster_with_options(request, runtime)

    async def delete_aidbcluster_async(
        self,
        request: polardb_20170801_models.DeleteAIDBClusterRequest,
    ) -> polardb_20170801_models.DeleteAIDBClusterResponse:
        """
        @summary 删除AI集群实例
        
        @param request: DeleteAIDBClusterRequest
        @return: DeleteAIDBClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_aidbcluster_with_options_async(request, runtime)

    def delete_account_with_options(
        self,
        request: polardb_20170801_models.DeleteAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteAccountResponse:
        """
        @summary Deletes a database account for a PolarDB cluster.
        
        @description > Before you call this operation, make sure that the cluster is in the Running state. Otherwise, the operation fails.
        
        @param request: DeleteAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAccount',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteAccountResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_account_with_options_async(
        self,
        request: polardb_20170801_models.DeleteAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteAccountResponse:
        """
        @summary Deletes a database account for a PolarDB cluster.
        
        @description > Before you call this operation, make sure that the cluster is in the Running state. Otherwise, the operation fails.
        
        @param request: DeleteAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAccount',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteAccountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_account(
        self,
        request: polardb_20170801_models.DeleteAccountRequest,
    ) -> polardb_20170801_models.DeleteAccountResponse:
        """
        @summary Deletes a database account for a PolarDB cluster.
        
        @description > Before you call this operation, make sure that the cluster is in the Running state. Otherwise, the operation fails.
        
        @param request: DeleteAccountRequest
        @return: DeleteAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_account_with_options(request, runtime)

    async def delete_account_async(
        self,
        request: polardb_20170801_models.DeleteAccountRequest,
    ) -> polardb_20170801_models.DeleteAccountResponse:
        """
        @summary Deletes a database account for a PolarDB cluster.
        
        @description > Before you call this operation, make sure that the cluster is in the Running state. Otherwise, the operation fails.
        
        @param request: DeleteAccountRequest
        @return: DeleteAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_account_with_options_async(request, runtime)

    def delete_account_zonal_with_options(
        self,
        request: polardb_20170801_models.DeleteAccountZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteAccountZonalResponse:
        """
        @summary 删除PolarDB边缘云集群账号
        
        @param request: DeleteAccountZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAccountZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAccountZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteAccountZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_account_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DeleteAccountZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteAccountZonalResponse:
        """
        @summary 删除PolarDB边缘云集群账号
        
        @param request: DeleteAccountZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAccountZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAccountZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteAccountZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_account_zonal(
        self,
        request: polardb_20170801_models.DeleteAccountZonalRequest,
    ) -> polardb_20170801_models.DeleteAccountZonalResponse:
        """
        @summary 删除PolarDB边缘云集群账号
        
        @param request: DeleteAccountZonalRequest
        @return: DeleteAccountZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_account_zonal_with_options(request, runtime)

    async def delete_account_zonal_async(
        self,
        request: polardb_20170801_models.DeleteAccountZonalRequest,
    ) -> polardb_20170801_models.DeleteAccountZonalResponse:
        """
        @summary 删除PolarDB边缘云集群账号
        
        @param request: DeleteAccountZonalRequest
        @return: DeleteAccountZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_account_zonal_with_options_async(request, runtime)

    def delete_application_with_options(
        self,
        request: polardb_20170801_models.DeleteApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteApplicationResponse:
        """
        @summary 删除PolarDB应用
        
        @param request: DeleteApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteApplication',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_application_with_options_async(
        self,
        request: polardb_20170801_models.DeleteApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteApplicationResponse:
        """
        @summary 删除PolarDB应用
        
        @param request: DeleteApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteApplication',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_application(
        self,
        request: polardb_20170801_models.DeleteApplicationRequest,
    ) -> polardb_20170801_models.DeleteApplicationResponse:
        """
        @summary 删除PolarDB应用
        
        @param request: DeleteApplicationRequest
        @return: DeleteApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_application_with_options(request, runtime)

    async def delete_application_async(
        self,
        request: polardb_20170801_models.DeleteApplicationRequest,
    ) -> polardb_20170801_models.DeleteApplicationResponse:
        """
        @summary 删除PolarDB应用
        
        @param request: DeleteApplicationRequest
        @return: DeleteApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_application_with_options_async(request, runtime)

    def delete_application_endpoint_address_with_options(
        self,
        request: polardb_20170801_models.DeleteApplicationEndpointAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteApplicationEndpointAddressResponse:
        """
        @summary 删除PolarDB应用终端地址
        
        @param request: DeleteApplicationEndpointAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteApplicationEndpointAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteApplicationEndpointAddress',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteApplicationEndpointAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_application_endpoint_address_with_options_async(
        self,
        request: polardb_20170801_models.DeleteApplicationEndpointAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteApplicationEndpointAddressResponse:
        """
        @summary 删除PolarDB应用终端地址
        
        @param request: DeleteApplicationEndpointAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteApplicationEndpointAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteApplicationEndpointAddress',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteApplicationEndpointAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_application_endpoint_address(
        self,
        request: polardb_20170801_models.DeleteApplicationEndpointAddressRequest,
    ) -> polardb_20170801_models.DeleteApplicationEndpointAddressResponse:
        """
        @summary 删除PolarDB应用终端地址
        
        @param request: DeleteApplicationEndpointAddressRequest
        @return: DeleteApplicationEndpointAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_application_endpoint_address_with_options(request, runtime)

    async def delete_application_endpoint_address_async(
        self,
        request: polardb_20170801_models.DeleteApplicationEndpointAddressRequest,
    ) -> polardb_20170801_models.DeleteApplicationEndpointAddressResponse:
        """
        @summary 删除PolarDB应用终端地址
        
        @param request: DeleteApplicationEndpointAddressRequest
        @return: DeleteApplicationEndpointAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_application_endpoint_address_with_options_async(request, runtime)

    def delete_backup_with_options(
        self,
        request: polardb_20170801_models.DeleteBackupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteBackupResponse:
        """
        @summary Deletes the backup sets of a PolarDB cluster.
        
        @description Before you call this operation, make sure that the cluster meets the following requirements:
        The cluster is in the Running state.
        The backup sets are in the Success state.
        >    You can call the [DescribeBackups](https://help.aliyun.com/document_detail/98102.html) operation to query the status of backup sets.
        >   After you delete the backup set file, the storage space that is occupied by the file is released. The released storage space is smaller than the size of the file because your snapshots share some data blocks
        
        @param request: DeleteBackupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteBackupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_backup_with_options_async(
        self,
        request: polardb_20170801_models.DeleteBackupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteBackupResponse:
        """
        @summary Deletes the backup sets of a PolarDB cluster.
        
        @description Before you call this operation, make sure that the cluster meets the following requirements:
        The cluster is in the Running state.
        The backup sets are in the Success state.
        >    You can call the [DescribeBackups](https://help.aliyun.com/document_detail/98102.html) operation to query the status of backup sets.
        >   After you delete the backup set file, the storage space that is occupied by the file is released. The released storage space is smaller than the size of the file because your snapshots share some data blocks
        
        @param request: DeleteBackupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteBackupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_backup(
        self,
        request: polardb_20170801_models.DeleteBackupRequest,
    ) -> polardb_20170801_models.DeleteBackupResponse:
        """
        @summary Deletes the backup sets of a PolarDB cluster.
        
        @description Before you call this operation, make sure that the cluster meets the following requirements:
        The cluster is in the Running state.
        The backup sets are in the Success state.
        >    You can call the [DescribeBackups](https://help.aliyun.com/document_detail/98102.html) operation to query the status of backup sets.
        >   After you delete the backup set file, the storage space that is occupied by the file is released. The released storage space is smaller than the size of the file because your snapshots share some data blocks
        
        @param request: DeleteBackupRequest
        @return: DeleteBackupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_backup_with_options(request, runtime)

    async def delete_backup_async(
        self,
        request: polardb_20170801_models.DeleteBackupRequest,
    ) -> polardb_20170801_models.DeleteBackupResponse:
        """
        @summary Deletes the backup sets of a PolarDB cluster.
        
        @description Before you call this operation, make sure that the cluster meets the following requirements:
        The cluster is in the Running state.
        The backup sets are in the Success state.
        >    You can call the [DescribeBackups](https://help.aliyun.com/document_detail/98102.html) operation to query the status of backup sets.
        >   After you delete the backup set file, the storage space that is occupied by the file is released. The released storage space is smaller than the size of the file because your snapshots share some data blocks
        
        @param request: DeleteBackupRequest
        @return: DeleteBackupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_backup_with_options_async(request, runtime)

    def delete_dbcluster_with_options(
        self,
        request: polardb_20170801_models.DeleteDBClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBClusterResponse:
        """
        @summary Releases a pay-as-you-go PolarDB cluster.
        
        @param request: DeleteDBClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_retention_policy_on_cluster_deletion):
            query['BackupRetentionPolicyOnClusterDeletion'] = request.backup_retention_policy_on_cluster_deletion
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBCluster',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dbcluster_with_options_async(
        self,
        request: polardb_20170801_models.DeleteDBClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBClusterResponse:
        """
        @summary Releases a pay-as-you-go PolarDB cluster.
        
        @param request: DeleteDBClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_retention_policy_on_cluster_deletion):
            query['BackupRetentionPolicyOnClusterDeletion'] = request.backup_retention_policy_on_cluster_deletion
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBCluster',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dbcluster(
        self,
        request: polardb_20170801_models.DeleteDBClusterRequest,
    ) -> polardb_20170801_models.DeleteDBClusterResponse:
        """
        @summary Releases a pay-as-you-go PolarDB cluster.
        
        @param request: DeleteDBClusterRequest
        @return: DeleteDBClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dbcluster_with_options(request, runtime)

    async def delete_dbcluster_async(
        self,
        request: polardb_20170801_models.DeleteDBClusterRequest,
    ) -> polardb_20170801_models.DeleteDBClusterResponse:
        """
        @summary Releases a pay-as-you-go PolarDB cluster.
        
        @param request: DeleteDBClusterRequest
        @return: DeleteDBClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dbcluster_with_options_async(request, runtime)

    def delete_dbcluster_endpoint_with_options(
        self,
        request: polardb_20170801_models.DeleteDBClusterEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBClusterEndpointResponse:
        """
        @summary Releases a custom cluster endpoint of a PolarDB cluster.
        
        @param request: DeleteDBClusterEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBClusterEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBClusterEndpoint',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBClusterEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dbcluster_endpoint_with_options_async(
        self,
        request: polardb_20170801_models.DeleteDBClusterEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBClusterEndpointResponse:
        """
        @summary Releases a custom cluster endpoint of a PolarDB cluster.
        
        @param request: DeleteDBClusterEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBClusterEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBClusterEndpoint',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBClusterEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dbcluster_endpoint(
        self,
        request: polardb_20170801_models.DeleteDBClusterEndpointRequest,
    ) -> polardb_20170801_models.DeleteDBClusterEndpointResponse:
        """
        @summary Releases a custom cluster endpoint of a PolarDB cluster.
        
        @param request: DeleteDBClusterEndpointRequest
        @return: DeleteDBClusterEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dbcluster_endpoint_with_options(request, runtime)

    async def delete_dbcluster_endpoint_async(
        self,
        request: polardb_20170801_models.DeleteDBClusterEndpointRequest,
    ) -> polardb_20170801_models.DeleteDBClusterEndpointResponse:
        """
        @summary Releases a custom cluster endpoint of a PolarDB cluster.
        
        @param request: DeleteDBClusterEndpointRequest
        @return: DeleteDBClusterEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dbcluster_endpoint_with_options_async(request, runtime)

    def delete_dbcluster_endpoint_zonal_with_options(
        self,
        request: polardb_20170801_models.DeleteDBClusterEndpointZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBClusterEndpointZonalResponse:
        """
        @summary 删除PolarDB 边缘云集群的链接地址
        
        @param request: DeleteDBClusterEndpointZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBClusterEndpointZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBClusterEndpointZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBClusterEndpointZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dbcluster_endpoint_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DeleteDBClusterEndpointZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBClusterEndpointZonalResponse:
        """
        @summary 删除PolarDB 边缘云集群的链接地址
        
        @param request: DeleteDBClusterEndpointZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBClusterEndpointZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBClusterEndpointZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBClusterEndpointZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dbcluster_endpoint_zonal(
        self,
        request: polardb_20170801_models.DeleteDBClusterEndpointZonalRequest,
    ) -> polardb_20170801_models.DeleteDBClusterEndpointZonalResponse:
        """
        @summary 删除PolarDB 边缘云集群的链接地址
        
        @param request: DeleteDBClusterEndpointZonalRequest
        @return: DeleteDBClusterEndpointZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dbcluster_endpoint_zonal_with_options(request, runtime)

    async def delete_dbcluster_endpoint_zonal_async(
        self,
        request: polardb_20170801_models.DeleteDBClusterEndpointZonalRequest,
    ) -> polardb_20170801_models.DeleteDBClusterEndpointZonalResponse:
        """
        @summary 删除PolarDB 边缘云集群的链接地址
        
        @param request: DeleteDBClusterEndpointZonalRequest
        @return: DeleteDBClusterEndpointZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dbcluster_endpoint_zonal_with_options_async(request, runtime)

    def delete_dbendpoint_address_with_options(
        self,
        request: polardb_20170801_models.DeleteDBEndpointAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBEndpointAddressResponse:
        """
        @summary Releases the public endpoints of a PolarDB cluster, including the primary endpoint, default cluster endpoint, and custom cluster endpoint.
        
        @description >    You can delete a public-facing or classic network endpoint of the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        >    Classic network endpoints are supported only on the China site (aliyun.com). Therefore, you do not need to delete classic network endpoints on the International site (alibabacloud.com).
        
        @param request: DeleteDBEndpointAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBEndpointAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBEndpointAddress',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBEndpointAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dbendpoint_address_with_options_async(
        self,
        request: polardb_20170801_models.DeleteDBEndpointAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBEndpointAddressResponse:
        """
        @summary Releases the public endpoints of a PolarDB cluster, including the primary endpoint, default cluster endpoint, and custom cluster endpoint.
        
        @description >    You can delete a public-facing or classic network endpoint of the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        >    Classic network endpoints are supported only on the China site (aliyun.com). Therefore, you do not need to delete classic network endpoints on the International site (alibabacloud.com).
        
        @param request: DeleteDBEndpointAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBEndpointAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBEndpointAddress',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBEndpointAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dbendpoint_address(
        self,
        request: polardb_20170801_models.DeleteDBEndpointAddressRequest,
    ) -> polardb_20170801_models.DeleteDBEndpointAddressResponse:
        """
        @summary Releases the public endpoints of a PolarDB cluster, including the primary endpoint, default cluster endpoint, and custom cluster endpoint.
        
        @description >    You can delete a public-facing or classic network endpoint of the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        >    Classic network endpoints are supported only on the China site (aliyun.com). Therefore, you do not need to delete classic network endpoints on the International site (alibabacloud.com).
        
        @param request: DeleteDBEndpointAddressRequest
        @return: DeleteDBEndpointAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dbendpoint_address_with_options(request, runtime)

    async def delete_dbendpoint_address_async(
        self,
        request: polardb_20170801_models.DeleteDBEndpointAddressRequest,
    ) -> polardb_20170801_models.DeleteDBEndpointAddressResponse:
        """
        @summary Releases the public endpoints of a PolarDB cluster, including the primary endpoint, default cluster endpoint, and custom cluster endpoint.
        
        @description >    You can delete a public-facing or classic network endpoint of the primary endpoint, the default cluster endpoint, or a custom cluster endpoint.
        >    Classic network endpoints are supported only on the China site (aliyun.com). Therefore, you do not need to delete classic network endpoints on the International site (alibabacloud.com).
        
        @param request: DeleteDBEndpointAddressRequest
        @return: DeleteDBEndpointAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dbendpoint_address_with_options_async(request, runtime)

    def delete_dblink_with_options(
        self,
        request: polardb_20170801_models.DeleteDBLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBLinkResponse:
        """
        @summary Deletes a database link from a PolarDB for PostgreSQL (Compatible with Oracle) cluster.
        
        @param request: DeleteDBLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dblink_name):
            query['DBLinkName'] = request.dblink_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBLink',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBLinkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dblink_with_options_async(
        self,
        request: polardb_20170801_models.DeleteDBLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBLinkResponse:
        """
        @summary Deletes a database link from a PolarDB for PostgreSQL (Compatible with Oracle) cluster.
        
        @param request: DeleteDBLinkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBLinkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dblink_name):
            query['DBLinkName'] = request.dblink_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBLink',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBLinkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dblink(
        self,
        request: polardb_20170801_models.DeleteDBLinkRequest,
    ) -> polardb_20170801_models.DeleteDBLinkResponse:
        """
        @summary Deletes a database link from a PolarDB for PostgreSQL (Compatible with Oracle) cluster.
        
        @param request: DeleteDBLinkRequest
        @return: DeleteDBLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dblink_with_options(request, runtime)

    async def delete_dblink_async(
        self,
        request: polardb_20170801_models.DeleteDBLinkRequest,
    ) -> polardb_20170801_models.DeleteDBLinkResponse:
        """
        @summary Deletes a database link from a PolarDB for PostgreSQL (Compatible with Oracle) cluster.
        
        @param request: DeleteDBLinkRequest
        @return: DeleteDBLinkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dblink_with_options_async(request, runtime)

    def delete_dbnodes_with_options(
        self,
        request: polardb_20170801_models.DeleteDBNodesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBNodesResponse:
        """
        @summary Deletes a read-only node from a PolarDB cluster.
        
        @param request: DeleteDBNodesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBNodesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.dbnode_type):
            query['DBNodeType'] = request.dbnode_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBNodes',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBNodesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dbnodes_with_options_async(
        self,
        request: polardb_20170801_models.DeleteDBNodesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDBNodesResponse:
        """
        @summary Deletes a read-only node from a PolarDB cluster.
        
        @param request: DeleteDBNodesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBNodesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.dbnode_type):
            query['DBNodeType'] = request.dbnode_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBNodes',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDBNodesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dbnodes(
        self,
        request: polardb_20170801_models.DeleteDBNodesRequest,
    ) -> polardb_20170801_models.DeleteDBNodesResponse:
        """
        @summary Deletes a read-only node from a PolarDB cluster.
        
        @param request: DeleteDBNodesRequest
        @return: DeleteDBNodesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dbnodes_with_options(request, runtime)

    async def delete_dbnodes_async(
        self,
        request: polardb_20170801_models.DeleteDBNodesRequest,
    ) -> polardb_20170801_models.DeleteDBNodesResponse:
        """
        @summary Deletes a read-only node from a PolarDB cluster.
        
        @param request: DeleteDBNodesRequest
        @return: DeleteDBNodesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dbnodes_with_options_async(request, runtime)

    def delete_database_with_options(
        self,
        request: polardb_20170801_models.DeleteDatabaseRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDatabaseResponse:
        """
        @summary Deletes a database from a PolarDB cluster.
        
        @description >- The cluster must be in the Running state and unlocked. Otherwise, the specified database cannot be deleted.
        >- The delete operation is performed in an asynchronous manner. A long period of time may be required to delete a large database. A success response for this operation only indicates that the request to delete the database is sent. You must query the database to check whether the database is deleted.
        
        @param request: DeleteDatabaseRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDatabaseResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDatabase',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDatabaseResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_database_with_options_async(
        self,
        request: polardb_20170801_models.DeleteDatabaseRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDatabaseResponse:
        """
        @summary Deletes a database from a PolarDB cluster.
        
        @description >- The cluster must be in the Running state and unlocked. Otherwise, the specified database cannot be deleted.
        >- The delete operation is performed in an asynchronous manner. A long period of time may be required to delete a large database. A success response for this operation only indicates that the request to delete the database is sent. You must query the database to check whether the database is deleted.
        
        @param request: DeleteDatabaseRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDatabaseResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDatabase',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDatabaseResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_database(
        self,
        request: polardb_20170801_models.DeleteDatabaseRequest,
    ) -> polardb_20170801_models.DeleteDatabaseResponse:
        """
        @summary Deletes a database from a PolarDB cluster.
        
        @description >- The cluster must be in the Running state and unlocked. Otherwise, the specified database cannot be deleted.
        >- The delete operation is performed in an asynchronous manner. A long period of time may be required to delete a large database. A success response for this operation only indicates that the request to delete the database is sent. You must query the database to check whether the database is deleted.
        
        @param request: DeleteDatabaseRequest
        @return: DeleteDatabaseResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_database_with_options(request, runtime)

    async def delete_database_async(
        self,
        request: polardb_20170801_models.DeleteDatabaseRequest,
    ) -> polardb_20170801_models.DeleteDatabaseResponse:
        """
        @summary Deletes a database from a PolarDB cluster.
        
        @description >- The cluster must be in the Running state and unlocked. Otherwise, the specified database cannot be deleted.
        >- The delete operation is performed in an asynchronous manner. A long period of time may be required to delete a large database. A success response for this operation only indicates that the request to delete the database is sent. You must query the database to check whether the database is deleted.
        
        @param request: DeleteDatabaseRequest
        @return: DeleteDatabaseResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_database_with_options_async(request, runtime)

    def delete_database_zonal_with_options(
        self,
        request: polardb_20170801_models.DeleteDatabaseZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDatabaseZonalResponse:
        """
        @summary 删除PolarDB边缘云集群数据库
        
        @param request: DeleteDatabaseZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDatabaseZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDatabaseZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDatabaseZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_database_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DeleteDatabaseZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteDatabaseZonalResponse:
        """
        @summary 删除PolarDB边缘云集群数据库
        
        @param request: DeleteDatabaseZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDatabaseZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDatabaseZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteDatabaseZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_database_zonal(
        self,
        request: polardb_20170801_models.DeleteDatabaseZonalRequest,
    ) -> polardb_20170801_models.DeleteDatabaseZonalResponse:
        """
        @summary 删除PolarDB边缘云集群数据库
        
        @param request: DeleteDatabaseZonalRequest
        @return: DeleteDatabaseZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_database_zonal_with_options(request, runtime)

    async def delete_database_zonal_async(
        self,
        request: polardb_20170801_models.DeleteDatabaseZonalRequest,
    ) -> polardb_20170801_models.DeleteDatabaseZonalResponse:
        """
        @summary 删除PolarDB边缘云集群数据库
        
        @param request: DeleteDatabaseZonalRequest
        @return: DeleteDatabaseZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_database_zonal_with_options_async(request, runtime)

    def delete_encryption_dbrole_privilege_with_options(
        self,
        request: polardb_20170801_models.DeleteEncryptionDBRolePrivilegeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteEncryptionDBRolePrivilegeResponse:
        """
        @summary 删除角色
        
        @param request: DeleteEncryptionDBRolePrivilegeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEncryptionDBRolePrivilegeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role_privilege_name_list):
            query['RolePrivilegeNameList'] = request.role_privilege_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEncryptionDBRolePrivilege',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteEncryptionDBRolePrivilegeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_encryption_dbrole_privilege_with_options_async(
        self,
        request: polardb_20170801_models.DeleteEncryptionDBRolePrivilegeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteEncryptionDBRolePrivilegeResponse:
        """
        @summary 删除角色
        
        @param request: DeleteEncryptionDBRolePrivilegeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEncryptionDBRolePrivilegeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role_privilege_name_list):
            query['RolePrivilegeNameList'] = request.role_privilege_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEncryptionDBRolePrivilege',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteEncryptionDBRolePrivilegeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_encryption_dbrole_privilege(
        self,
        request: polardb_20170801_models.DeleteEncryptionDBRolePrivilegeRequest,
    ) -> polardb_20170801_models.DeleteEncryptionDBRolePrivilegeResponse:
        """
        @summary 删除角色
        
        @param request: DeleteEncryptionDBRolePrivilegeRequest
        @return: DeleteEncryptionDBRolePrivilegeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_encryption_dbrole_privilege_with_options(request, runtime)

    async def delete_encryption_dbrole_privilege_async(
        self,
        request: polardb_20170801_models.DeleteEncryptionDBRolePrivilegeRequest,
    ) -> polardb_20170801_models.DeleteEncryptionDBRolePrivilegeResponse:
        """
        @summary 删除角色
        
        @param request: DeleteEncryptionDBRolePrivilegeRequest
        @return: DeleteEncryptionDBRolePrivilegeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_encryption_dbrole_privilege_with_options_async(request, runtime)

    def delete_extensions_with_options(
        self,
        request: polardb_20170801_models.DeleteExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteExtensionsResponse:
        """
        @summary 删除插件
        
        @param request: DeleteExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnames):
            query['DBNames'] = request.dbnames
        if not UtilClient.is_unset(request.extensions):
            query['Extensions'] = request.extensions
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteExtensions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteExtensionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_extensions_with_options_async(
        self,
        request: polardb_20170801_models.DeleteExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteExtensionsResponse:
        """
        @summary 删除插件
        
        @param request: DeleteExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnames):
            query['DBNames'] = request.dbnames
        if not UtilClient.is_unset(request.extensions):
            query['Extensions'] = request.extensions
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteExtensions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteExtensionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_extensions(
        self,
        request: polardb_20170801_models.DeleteExtensionsRequest,
    ) -> polardb_20170801_models.DeleteExtensionsResponse:
        """
        @summary 删除插件
        
        @param request: DeleteExtensionsRequest
        @return: DeleteExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_extensions_with_options(request, runtime)

    async def delete_extensions_async(
        self,
        request: polardb_20170801_models.DeleteExtensionsRequest,
    ) -> polardb_20170801_models.DeleteExtensionsResponse:
        """
        @summary 删除插件
        
        @param request: DeleteExtensionsRequest
        @return: DeleteExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_extensions_with_options_async(request, runtime)

    def delete_firewall_rules_with_options(
        self,
        request: polardb_20170801_models.DeleteFirewallRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteFirewallRulesResponse:
        """
        @summary 删除sql防火墙
        
        @param request: DeleteFirewallRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFirewallRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFirewallRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteFirewallRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_firewall_rules_with_options_async(
        self,
        request: polardb_20170801_models.DeleteFirewallRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteFirewallRulesResponse:
        """
        @summary 删除sql防火墙
        
        @param request: DeleteFirewallRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFirewallRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFirewallRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteFirewallRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_firewall_rules(
        self,
        request: polardb_20170801_models.DeleteFirewallRulesRequest,
    ) -> polardb_20170801_models.DeleteFirewallRulesResponse:
        """
        @summary 删除sql防火墙
        
        @param request: DeleteFirewallRulesRequest
        @return: DeleteFirewallRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_firewall_rules_with_options(request, runtime)

    async def delete_firewall_rules_async(
        self,
        request: polardb_20170801_models.DeleteFirewallRulesRequest,
    ) -> polardb_20170801_models.DeleteFirewallRulesResponse:
        """
        @summary 删除sql防火墙
        
        @param request: DeleteFirewallRulesRequest
        @return: DeleteFirewallRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_firewall_rules_with_options_async(request, runtime)

    def delete_global_data_network_with_options(
        self,
        request: polardb_20170801_models.DeleteGlobalDataNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteGlobalDataNetworkResponse:
        """
        @summary DeleteGlobalDataNetwork
        
        @param request: DeleteGlobalDataNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGlobalDataNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalDataNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteGlobalDataNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_global_data_network_with_options_async(
        self,
        request: polardb_20170801_models.DeleteGlobalDataNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteGlobalDataNetworkResponse:
        """
        @summary DeleteGlobalDataNetwork
        
        @param request: DeleteGlobalDataNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGlobalDataNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalDataNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteGlobalDataNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_global_data_network(
        self,
        request: polardb_20170801_models.DeleteGlobalDataNetworkRequest,
    ) -> polardb_20170801_models.DeleteGlobalDataNetworkResponse:
        """
        @summary DeleteGlobalDataNetwork
        
        @param request: DeleteGlobalDataNetworkRequest
        @return: DeleteGlobalDataNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_global_data_network_with_options(request, runtime)

    async def delete_global_data_network_async(
        self,
        request: polardb_20170801_models.DeleteGlobalDataNetworkRequest,
    ) -> polardb_20170801_models.DeleteGlobalDataNetworkResponse:
        """
        @summary DeleteGlobalDataNetwork
        
        @param request: DeleteGlobalDataNetworkRequest
        @return: DeleteGlobalDataNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_global_data_network_with_options_async(request, runtime)

    def delete_global_database_network_with_options(
        self,
        request: polardb_20170801_models.DeleteGlobalDatabaseNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteGlobalDatabaseNetworkResponse:
        """
        @summary Deletes a global database network (GDN).
        
        @description >  You can delete a GDN only when the GDN includes only a primary cluster.
        
        @param request: DeleteGlobalDatabaseNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGlobalDatabaseNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gdnid):
            query['GDNId'] = request.gdnid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalDatabaseNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteGlobalDatabaseNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_global_database_network_with_options_async(
        self,
        request: polardb_20170801_models.DeleteGlobalDatabaseNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteGlobalDatabaseNetworkResponse:
        """
        @summary Deletes a global database network (GDN).
        
        @description >  You can delete a GDN only when the GDN includes only a primary cluster.
        
        @param request: DeleteGlobalDatabaseNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGlobalDatabaseNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gdnid):
            query['GDNId'] = request.gdnid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalDatabaseNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteGlobalDatabaseNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_global_database_network(
        self,
        request: polardb_20170801_models.DeleteGlobalDatabaseNetworkRequest,
    ) -> polardb_20170801_models.DeleteGlobalDatabaseNetworkResponse:
        """
        @summary Deletes a global database network (GDN).
        
        @description >  You can delete a GDN only when the GDN includes only a primary cluster.
        
        @param request: DeleteGlobalDatabaseNetworkRequest
        @return: DeleteGlobalDatabaseNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_global_database_network_with_options(request, runtime)

    async def delete_global_database_network_async(
        self,
        request: polardb_20170801_models.DeleteGlobalDatabaseNetworkRequest,
    ) -> polardb_20170801_models.DeleteGlobalDatabaseNetworkResponse:
        """
        @summary Deletes a global database network (GDN).
        
        @description >  You can delete a GDN only when the GDN includes only a primary cluster.
        
        @param request: DeleteGlobalDatabaseNetworkRequest
        @return: DeleteGlobalDatabaseNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_global_database_network_with_options_async(request, runtime)

    def delete_global_security_ipgroup_with_options(
        self,
        request: polardb_20170801_models.DeleteGlobalSecurityIPGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteGlobalSecurityIPGroupResponse:
        """
        @summary Deletes a global IP whitelist template.
        
        @param request: DeleteGlobalSecurityIPGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGlobalSecurityIPGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_ig_name):
            query['GlobalIgName'] = request.global_ig_name
        if not UtilClient.is_unset(request.global_security_group_id):
            query['GlobalSecurityGroupId'] = request.global_security_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalSecurityIPGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteGlobalSecurityIPGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_global_security_ipgroup_with_options_async(
        self,
        request: polardb_20170801_models.DeleteGlobalSecurityIPGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteGlobalSecurityIPGroupResponse:
        """
        @summary Deletes a global IP whitelist template.
        
        @param request: DeleteGlobalSecurityIPGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGlobalSecurityIPGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_ig_name):
            query['GlobalIgName'] = request.global_ig_name
        if not UtilClient.is_unset(request.global_security_group_id):
            query['GlobalSecurityGroupId'] = request.global_security_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalSecurityIPGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteGlobalSecurityIPGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_global_security_ipgroup(
        self,
        request: polardb_20170801_models.DeleteGlobalSecurityIPGroupRequest,
    ) -> polardb_20170801_models.DeleteGlobalSecurityIPGroupResponse:
        """
        @summary Deletes a global IP whitelist template.
        
        @param request: DeleteGlobalSecurityIPGroupRequest
        @return: DeleteGlobalSecurityIPGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_global_security_ipgroup_with_options(request, runtime)

    async def delete_global_security_ipgroup_async(
        self,
        request: polardb_20170801_models.DeleteGlobalSecurityIPGroupRequest,
    ) -> polardb_20170801_models.DeleteGlobalSecurityIPGroupResponse:
        """
        @summary Deletes a global IP whitelist template.
        
        @param request: DeleteGlobalSecurityIPGroupRequest
        @return: DeleteGlobalSecurityIPGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_global_security_ipgroup_with_options_async(request, runtime)

    def delete_masking_rules_with_options(
        self,
        request: polardb_20170801_models.DeleteMaskingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteMaskingRulesResponse:
        """
        @summary Deletes a data masking rule.
        
        @param request: DeleteMaskingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMaskingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.interface_version):
            query['InterfaceVersion'] = request.interface_version
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMaskingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteMaskingRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_masking_rules_with_options_async(
        self,
        request: polardb_20170801_models.DeleteMaskingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteMaskingRulesResponse:
        """
        @summary Deletes a data masking rule.
        
        @param request: DeleteMaskingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMaskingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.interface_version):
            query['InterfaceVersion'] = request.interface_version
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMaskingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteMaskingRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_masking_rules(
        self,
        request: polardb_20170801_models.DeleteMaskingRulesRequest,
    ) -> polardb_20170801_models.DeleteMaskingRulesResponse:
        """
        @summary Deletes a data masking rule.
        
        @param request: DeleteMaskingRulesRequest
        @return: DeleteMaskingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_masking_rules_with_options(request, runtime)

    async def delete_masking_rules_async(
        self,
        request: polardb_20170801_models.DeleteMaskingRulesRequest,
    ) -> polardb_20170801_models.DeleteMaskingRulesResponse:
        """
        @summary Deletes a data masking rule.
        
        @param request: DeleteMaskingRulesRequest
        @return: DeleteMaskingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_masking_rules_with_options_async(request, runtime)

    def delete_network_channel_with_options(
        self,
        request: polardb_20170801_models.DeleteNetworkChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteNetworkChannelResponse:
        """
        @summary 删除网络通道
        
        @param request: DeleteNetworkChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkChannel',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteNetworkChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_channel_with_options_async(
        self,
        request: polardb_20170801_models.DeleteNetworkChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteNetworkChannelResponse:
        """
        @summary 删除网络通道
        
        @param request: DeleteNetworkChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkChannel',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteNetworkChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_channel(
        self,
        request: polardb_20170801_models.DeleteNetworkChannelRequest,
    ) -> polardb_20170801_models.DeleteNetworkChannelResponse:
        """
        @summary 删除网络通道
        
        @param request: DeleteNetworkChannelRequest
        @return: DeleteNetworkChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_channel_with_options(request, runtime)

    async def delete_network_channel_async(
        self,
        request: polardb_20170801_models.DeleteNetworkChannelRequest,
    ) -> polardb_20170801_models.DeleteNetworkChannelResponse:
        """
        @summary 删除网络通道
        
        @param request: DeleteNetworkChannelRequest
        @return: DeleteNetworkChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_channel_with_options_async(request, runtime)

    def delete_parameter_group_with_options(
        self,
        request: polardb_20170801_models.DeleteParameterGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteParameterGroupResponse:
        """
        @summary Deletes a parameter template of a PolarDB cluster.
        
        @description You can use parameter templates to manage multiple parameters at a time and quickly apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        >  When you delete a parameter template, the parameter settings that are applied to PolarDB clusters are not affected.
        
        @param request: DeleteParameterGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteParameterGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parameter_group_id):
            query['ParameterGroupId'] = request.parameter_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteParameterGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteParameterGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_parameter_group_with_options_async(
        self,
        request: polardb_20170801_models.DeleteParameterGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteParameterGroupResponse:
        """
        @summary Deletes a parameter template of a PolarDB cluster.
        
        @description You can use parameter templates to manage multiple parameters at a time and quickly apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        >  When you delete a parameter template, the parameter settings that are applied to PolarDB clusters are not affected.
        
        @param request: DeleteParameterGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteParameterGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parameter_group_id):
            query['ParameterGroupId'] = request.parameter_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteParameterGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteParameterGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_parameter_group(
        self,
        request: polardb_20170801_models.DeleteParameterGroupRequest,
    ) -> polardb_20170801_models.DeleteParameterGroupResponse:
        """
        @summary Deletes a parameter template of a PolarDB cluster.
        
        @description You can use parameter templates to manage multiple parameters at a time and quickly apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        >  When you delete a parameter template, the parameter settings that are applied to PolarDB clusters are not affected.
        
        @param request: DeleteParameterGroupRequest
        @return: DeleteParameterGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_parameter_group_with_options(request, runtime)

    async def delete_parameter_group_async(
        self,
        request: polardb_20170801_models.DeleteParameterGroupRequest,
    ) -> polardb_20170801_models.DeleteParameterGroupResponse:
        """
        @summary Deletes a parameter template of a PolarDB cluster.
        
        @description You can use parameter templates to manage multiple parameters at a time and quickly apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        >  When you delete a parameter template, the parameter settings that are applied to PolarDB clusters are not affected.
        
        @param request: DeleteParameterGroupRequest
        @return: DeleteParameterGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_parameter_group_with_options_async(request, runtime)

    def delete_polar_fs_quota_with_options(
        self,
        request: polardb_20170801_models.DeletePolarFsQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeletePolarFsQuotaResponse:
        """
        @summary 删除PolarFs Quota规则
        
        @param request: DeletePolarFsQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePolarFsQuotaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.quotas):
            query['Quotas'] = request.quotas
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePolarFsQuota',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeletePolarFsQuotaResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_polar_fs_quota_with_options_async(
        self,
        request: polardb_20170801_models.DeletePolarFsQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeletePolarFsQuotaResponse:
        """
        @summary 删除PolarFs Quota规则
        
        @param request: DeletePolarFsQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePolarFsQuotaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.quotas):
            query['Quotas'] = request.quotas
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePolarFsQuota',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeletePolarFsQuotaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_polar_fs_quota(
        self,
        request: polardb_20170801_models.DeletePolarFsQuotaRequest,
    ) -> polardb_20170801_models.DeletePolarFsQuotaResponse:
        """
        @summary 删除PolarFs Quota规则
        
        @param request: DeletePolarFsQuotaRequest
        @return: DeletePolarFsQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_polar_fs_quota_with_options(request, runtime)

    async def delete_polar_fs_quota_async(
        self,
        request: polardb_20170801_models.DeletePolarFsQuotaRequest,
    ) -> polardb_20170801_models.DeletePolarFsQuotaResponse:
        """
        @summary 删除PolarFs Quota规则
        
        @param request: DeletePolarFsQuotaRequest
        @return: DeletePolarFsQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_polar_fs_quota_with_options_async(request, runtime)

    def delete_sqlrate_limiting_rules_with_options(
        self,
        request: polardb_20170801_models.DeleteSQLRateLimitingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteSQLRateLimitingRulesResponse:
        """
        @summary 删除SQL限流规则
        
        @param request: DeleteSQLRateLimitingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSQLRateLimitingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSQLRateLimitingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteSQLRateLimitingRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_sqlrate_limiting_rules_with_options_async(
        self,
        request: polardb_20170801_models.DeleteSQLRateLimitingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DeleteSQLRateLimitingRulesResponse:
        """
        @summary 删除SQL限流规则
        
        @param request: DeleteSQLRateLimitingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSQLRateLimitingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSQLRateLimitingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DeleteSQLRateLimitingRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_sqlrate_limiting_rules(
        self,
        request: polardb_20170801_models.DeleteSQLRateLimitingRulesRequest,
    ) -> polardb_20170801_models.DeleteSQLRateLimitingRulesResponse:
        """
        @summary 删除SQL限流规则
        
        @param request: DeleteSQLRateLimitingRulesRequest
        @return: DeleteSQLRateLimitingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_sqlrate_limiting_rules_with_options(request, runtime)

    async def delete_sqlrate_limiting_rules_async(
        self,
        request: polardb_20170801_models.DeleteSQLRateLimitingRulesRequest,
    ) -> polardb_20170801_models.DeleteSQLRateLimitingRulesResponse:
        """
        @summary 删除SQL限流规则
        
        @param request: DeleteSQLRateLimitingRulesRequest
        @return: DeleteSQLRateLimitingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_sqlrate_limiting_rules_with_options_async(request, runtime)

    def describe_aidbcluster_attribute_with_options(
        self,
        request: polardb_20170801_models.DescribeAIDBClusterAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAIDBClusterAttributeResponse:
        """
        @summary 查看custom实例详情
        
        @param request: DescribeAIDBClusterAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIDBClusterAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAIDBClusterAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAIDBClusterAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aidbcluster_attribute_with_options_async(
        self,
        request: polardb_20170801_models.DescribeAIDBClusterAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAIDBClusterAttributeResponse:
        """
        @summary 查看custom实例详情
        
        @param request: DescribeAIDBClusterAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIDBClusterAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAIDBClusterAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAIDBClusterAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aidbcluster_attribute(
        self,
        request: polardb_20170801_models.DescribeAIDBClusterAttributeRequest,
    ) -> polardb_20170801_models.DescribeAIDBClusterAttributeResponse:
        """
        @summary 查看custom实例详情
        
        @param request: DescribeAIDBClusterAttributeRequest
        @return: DescribeAIDBClusterAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aidbcluster_attribute_with_options(request, runtime)

    async def describe_aidbcluster_attribute_async(
        self,
        request: polardb_20170801_models.DescribeAIDBClusterAttributeRequest,
    ) -> polardb_20170801_models.DescribeAIDBClusterAttributeResponse:
        """
        @summary 查看custom实例详情
        
        @param request: DescribeAIDBClusterAttributeRequest
        @return: DescribeAIDBClusterAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aidbcluster_attribute_with_options_async(request, runtime)

    def describe_aidbcluster_performance_with_options(
        self,
        request: polardb_20170801_models.DescribeAIDBClusterPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAIDBClusterPerformanceResponse:
        """
        @summary 获取ai容器性能指标
        
        @param request: DescribeAIDBClusterPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIDBClusterPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAIDBClusterPerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAIDBClusterPerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aidbcluster_performance_with_options_async(
        self,
        request: polardb_20170801_models.DescribeAIDBClusterPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAIDBClusterPerformanceResponse:
        """
        @summary 获取ai容器性能指标
        
        @param request: DescribeAIDBClusterPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIDBClusterPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAIDBClusterPerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAIDBClusterPerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aidbcluster_performance(
        self,
        request: polardb_20170801_models.DescribeAIDBClusterPerformanceRequest,
    ) -> polardb_20170801_models.DescribeAIDBClusterPerformanceResponse:
        """
        @summary 获取ai容器性能指标
        
        @param request: DescribeAIDBClusterPerformanceRequest
        @return: DescribeAIDBClusterPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aidbcluster_performance_with_options(request, runtime)

    async def describe_aidbcluster_performance_async(
        self,
        request: polardb_20170801_models.DescribeAIDBClusterPerformanceRequest,
    ) -> polardb_20170801_models.DescribeAIDBClusterPerformanceResponse:
        """
        @summary 获取ai容器性能指标
        
        @param request: DescribeAIDBClusterPerformanceRequest
        @return: DescribeAIDBClusterPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aidbcluster_performance_with_options_async(request, runtime)

    def describe_aidbclusters_with_options(
        self,
        request: polardb_20170801_models.DescribeAIDBClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAIDBClustersResponse:
        """
        @summary 查看custom集群列表
        
        @param request: DescribeAIDBClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIDBClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ai_node_type):
            query['AiNodeType'] = request.ai_node_type
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.dbcluster_status):
            query['DBClusterStatus'] = request.dbcluster_status
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAIDBClusters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAIDBClustersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aidbclusters_with_options_async(
        self,
        request: polardb_20170801_models.DescribeAIDBClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAIDBClustersResponse:
        """
        @summary 查看custom集群列表
        
        @param request: DescribeAIDBClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIDBClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ai_node_type):
            query['AiNodeType'] = request.ai_node_type
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.dbcluster_status):
            query['DBClusterStatus'] = request.dbcluster_status
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAIDBClusters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAIDBClustersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aidbclusters(
        self,
        request: polardb_20170801_models.DescribeAIDBClustersRequest,
    ) -> polardb_20170801_models.DescribeAIDBClustersResponse:
        """
        @summary 查看custom集群列表
        
        @param request: DescribeAIDBClustersRequest
        @return: DescribeAIDBClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aidbclusters_with_options(request, runtime)

    async def describe_aidbclusters_async(
        self,
        request: polardb_20170801_models.DescribeAIDBClustersRequest,
    ) -> polardb_20170801_models.DescribeAIDBClustersResponse:
        """
        @summary 查看custom集群列表
        
        @param request: DescribeAIDBClustersRequest
        @return: DescribeAIDBClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aidbclusters_with_options_async(request, runtime)

    def describe_aitask_status_with_options(
        self,
        request: polardb_20170801_models.DescribeAITaskStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAITaskStatusResponse:
        """
        @summary Queries the status of the PolarDB for AI feature.
        
        @param request: DescribeAITaskStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAITaskStatusResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAITaskStatus',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAITaskStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aitask_status_with_options_async(
        self,
        request: polardb_20170801_models.DescribeAITaskStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAITaskStatusResponse:
        """
        @summary Queries the status of the PolarDB for AI feature.
        
        @param request: DescribeAITaskStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAITaskStatusResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAITaskStatus',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAITaskStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aitask_status(
        self,
        request: polardb_20170801_models.DescribeAITaskStatusRequest,
    ) -> polardb_20170801_models.DescribeAITaskStatusResponse:
        """
        @summary Queries the status of the PolarDB for AI feature.
        
        @param request: DescribeAITaskStatusRequest
        @return: DescribeAITaskStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aitask_status_with_options(request, runtime)

    async def describe_aitask_status_async(
        self,
        request: polardb_20170801_models.DescribeAITaskStatusRequest,
    ) -> polardb_20170801_models.DescribeAITaskStatusResponse:
        """
        @summary Queries the status of the PolarDB for AI feature.
        
        @param request: DescribeAITaskStatusRequest
        @return: DescribeAITaskStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aitask_status_with_options_async(request, runtime)

    def describe_accounts_with_options(
        self,
        request: polardb_20170801_models.DescribeAccountsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAccountsResponse:
        """
        @summary Queries information about a database account of a PolarDB cluster.
        
        @param request: DescribeAccountsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccounts',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAccountsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_accounts_with_options_async(
        self,
        request: polardb_20170801_models.DescribeAccountsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAccountsResponse:
        """
        @summary Queries information about a database account of a PolarDB cluster.
        
        @param request: DescribeAccountsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccounts',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAccountsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_accounts(
        self,
        request: polardb_20170801_models.DescribeAccountsRequest,
    ) -> polardb_20170801_models.DescribeAccountsResponse:
        """
        @summary Queries information about a database account of a PolarDB cluster.
        
        @param request: DescribeAccountsRequest
        @return: DescribeAccountsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_accounts_with_options(request, runtime)

    async def describe_accounts_async(
        self,
        request: polardb_20170801_models.DescribeAccountsRequest,
    ) -> polardb_20170801_models.DescribeAccountsResponse:
        """
        @summary Queries information about a database account of a PolarDB cluster.
        
        @param request: DescribeAccountsRequest
        @return: DescribeAccountsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_accounts_with_options_async(request, runtime)

    def describe_accounts_zonal_with_options(
        self,
        request: polardb_20170801_models.DescribeAccountsZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAccountsZonalResponse:
        """
        @summary 查询PolarDB边缘云集群列表
        
        @param request: DescribeAccountsZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountsZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccountsZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAccountsZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_accounts_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DescribeAccountsZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAccountsZonalResponse:
        """
        @summary 查询PolarDB边缘云集群列表
        
        @param request: DescribeAccountsZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountsZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccountsZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAccountsZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_accounts_zonal(
        self,
        request: polardb_20170801_models.DescribeAccountsZonalRequest,
    ) -> polardb_20170801_models.DescribeAccountsZonalResponse:
        """
        @summary 查询PolarDB边缘云集群列表
        
        @param request: DescribeAccountsZonalRequest
        @return: DescribeAccountsZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_accounts_zonal_with_options(request, runtime)

    async def describe_accounts_zonal_async(
        self,
        request: polardb_20170801_models.DescribeAccountsZonalRequest,
    ) -> polardb_20170801_models.DescribeAccountsZonalResponse:
        """
        @summary 查询PolarDB边缘云集群列表
        
        @param request: DescribeAccountsZonalRequest
        @return: DescribeAccountsZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_accounts_zonal_with_options_async(request, runtime)

    def describe_activation_code_details_with_options(
        self,
        request: polardb_20170801_models.DescribeActivationCodeDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeActivationCodeDetailsResponse:
        """
        @summary Queries the details of an activation code.
        
        @param request: DescribeActivationCodeDetailsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActivationCodeDetailsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_code_id):
            query['ActivationCodeId'] = request.activation_code_id
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActivationCodeDetails',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeActivationCodeDetailsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_activation_code_details_with_options_async(
        self,
        request: polardb_20170801_models.DescribeActivationCodeDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeActivationCodeDetailsResponse:
        """
        @summary Queries the details of an activation code.
        
        @param request: DescribeActivationCodeDetailsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActivationCodeDetailsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_code_id):
            query['ActivationCodeId'] = request.activation_code_id
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActivationCodeDetails',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeActivationCodeDetailsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_activation_code_details(
        self,
        request: polardb_20170801_models.DescribeActivationCodeDetailsRequest,
    ) -> polardb_20170801_models.DescribeActivationCodeDetailsResponse:
        """
        @summary Queries the details of an activation code.
        
        @param request: DescribeActivationCodeDetailsRequest
        @return: DescribeActivationCodeDetailsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_activation_code_details_with_options(request, runtime)

    async def describe_activation_code_details_async(
        self,
        request: polardb_20170801_models.DescribeActivationCodeDetailsRequest,
    ) -> polardb_20170801_models.DescribeActivationCodeDetailsResponse:
        """
        @summary Queries the details of an activation code.
        
        @param request: DescribeActivationCodeDetailsRequest
        @return: DescribeActivationCodeDetailsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_activation_code_details_with_options_async(request, runtime)

    def describe_activation_codes_with_options(
        self,
        request: polardb_20170801_models.DescribeActivationCodesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeActivationCodesResponse:
        """
        @summary Queries a list of activation codes.
        
        @param request: DescribeActivationCodesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActivationCodesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.mac_address):
            query['MacAddress'] = request.mac_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_identifier):
            query['SystemIdentifier'] = request.system_identifier
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActivationCodes',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeActivationCodesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_activation_codes_with_options_async(
        self,
        request: polardb_20170801_models.DescribeActivationCodesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeActivationCodesResponse:
        """
        @summary Queries a list of activation codes.
        
        @param request: DescribeActivationCodesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActivationCodesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.mac_address):
            query['MacAddress'] = request.mac_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_identifier):
            query['SystemIdentifier'] = request.system_identifier
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActivationCodes',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeActivationCodesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_activation_codes(
        self,
        request: polardb_20170801_models.DescribeActivationCodesRequest,
    ) -> polardb_20170801_models.DescribeActivationCodesResponse:
        """
        @summary Queries a list of activation codes.
        
        @param request: DescribeActivationCodesRequest
        @return: DescribeActivationCodesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_activation_codes_with_options(request, runtime)

    async def describe_activation_codes_async(
        self,
        request: polardb_20170801_models.DescribeActivationCodesRequest,
    ) -> polardb_20170801_models.DescribeActivationCodesResponse:
        """
        @summary Queries a list of activation codes.
        
        @param request: DescribeActivationCodesRequest
        @return: DescribeActivationCodesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_activation_codes_with_options_async(request, runtime)

    def describe_active_operation_maintain_conf_with_options(
        self,
        request: polardb_20170801_models.DescribeActiveOperationMaintainConfRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeActiveOperationMaintainConfResponse:
        """
        @summary 获取用户的运维配置信息，目前包括主动运维窗口信息
        
        @param request: DescribeActiveOperationMaintainConfRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActiveOperationMaintainConfResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActiveOperationMaintainConf',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeActiveOperationMaintainConfResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_active_operation_maintain_conf_with_options_async(
        self,
        request: polardb_20170801_models.DescribeActiveOperationMaintainConfRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeActiveOperationMaintainConfResponse:
        """
        @summary 获取用户的运维配置信息，目前包括主动运维窗口信息
        
        @param request: DescribeActiveOperationMaintainConfRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActiveOperationMaintainConfResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActiveOperationMaintainConf',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeActiveOperationMaintainConfResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_active_operation_maintain_conf(
        self,
        request: polardb_20170801_models.DescribeActiveOperationMaintainConfRequest,
    ) -> polardb_20170801_models.DescribeActiveOperationMaintainConfResponse:
        """
        @summary 获取用户的运维配置信息，目前包括主动运维窗口信息
        
        @param request: DescribeActiveOperationMaintainConfRequest
        @return: DescribeActiveOperationMaintainConfResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_active_operation_maintain_conf_with_options(request, runtime)

    async def describe_active_operation_maintain_conf_async(
        self,
        request: polardb_20170801_models.DescribeActiveOperationMaintainConfRequest,
    ) -> polardb_20170801_models.DescribeActiveOperationMaintainConfResponse:
        """
        @summary 获取用户的运维配置信息，目前包括主动运维窗口信息
        
        @param request: DescribeActiveOperationMaintainConfRequest
        @return: DescribeActiveOperationMaintainConfResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_active_operation_maintain_conf_with_options_async(request, runtime)

    def describe_active_operation_tasks_with_options(
        self,
        request: polardb_20170801_models.DescribeActiveOperationTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeActiveOperationTasksResponse:
        """
        @summary 用户侧查询运维任务
        
        @param request: DescribeActiveOperationTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActiveOperationTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_cancel):
            query['AllowCancel'] = request.allow_cancel
        if not UtilClient.is_unset(request.allow_change):
            query['AllowChange'] = request.allow_change
        if not UtilClient.is_unset(request.change_level):
            query['ChangeLevel'] = request.change_level
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActiveOperationTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeActiveOperationTasksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_active_operation_tasks_with_options_async(
        self,
        request: polardb_20170801_models.DescribeActiveOperationTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeActiveOperationTasksResponse:
        """
        @summary 用户侧查询运维任务
        
        @param request: DescribeActiveOperationTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActiveOperationTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_cancel):
            query['AllowCancel'] = request.allow_cancel
        if not UtilClient.is_unset(request.allow_change):
            query['AllowChange'] = request.allow_change
        if not UtilClient.is_unset(request.change_level):
            query['ChangeLevel'] = request.change_level
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActiveOperationTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeActiveOperationTasksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_active_operation_tasks(
        self,
        request: polardb_20170801_models.DescribeActiveOperationTasksRequest,
    ) -> polardb_20170801_models.DescribeActiveOperationTasksResponse:
        """
        @summary 用户侧查询运维任务
        
        @param request: DescribeActiveOperationTasksRequest
        @return: DescribeActiveOperationTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_active_operation_tasks_with_options(request, runtime)

    async def describe_active_operation_tasks_async(
        self,
        request: polardb_20170801_models.DescribeActiveOperationTasksRequest,
    ) -> polardb_20170801_models.DescribeActiveOperationTasksResponse:
        """
        @summary 用户侧查询运维任务
        
        @param request: DescribeActiveOperationTasksRequest
        @return: DescribeActiveOperationTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_active_operation_tasks_with_options_async(request, runtime)

    def describe_application_attribute_with_options(
        self,
        request: polardb_20170801_models.DescribeApplicationAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeApplicationAttributeResponse:
        """
        @summary 获取应用详情
        
        @param request: DescribeApplicationAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplicationAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeApplicationAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_application_attribute_with_options_async(
        self,
        request: polardb_20170801_models.DescribeApplicationAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeApplicationAttributeResponse:
        """
        @summary 获取应用详情
        
        @param request: DescribeApplicationAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplicationAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeApplicationAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_application_attribute(
        self,
        request: polardb_20170801_models.DescribeApplicationAttributeRequest,
    ) -> polardb_20170801_models.DescribeApplicationAttributeResponse:
        """
        @summary 获取应用详情
        
        @param request: DescribeApplicationAttributeRequest
        @return: DescribeApplicationAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_application_attribute_with_options(request, runtime)

    async def describe_application_attribute_async(
        self,
        request: polardb_20170801_models.DescribeApplicationAttributeRequest,
    ) -> polardb_20170801_models.DescribeApplicationAttributeResponse:
        """
        @summary 获取应用详情
        
        @param request: DescribeApplicationAttributeRequest
        @return: DescribeApplicationAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_application_attribute_with_options_async(request, runtime)

    def describe_application_parameters_with_options(
        self,
        tmp_req: polardb_20170801_models.DescribeApplicationParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeApplicationParametersResponse:
        """
        @summary 获取应用组件参数
        
        @param tmp_req: DescribeApplicationParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationParametersResponse
        """
        UtilClient.validate_model(tmp_req)
        request = polardb_20170801_models.DescribeApplicationParametersShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.component_id_list):
            request.component_id_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.component_id_list, 'ComponentIdList', 'json')
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        if not UtilClient.is_unset(request.component_id_list_shrink):
            query['ComponentIdList'] = request.component_id_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplicationParameters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeApplicationParametersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_application_parameters_with_options_async(
        self,
        tmp_req: polardb_20170801_models.DescribeApplicationParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeApplicationParametersResponse:
        """
        @summary 获取应用组件参数
        
        @param tmp_req: DescribeApplicationParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationParametersResponse
        """
        UtilClient.validate_model(tmp_req)
        request = polardb_20170801_models.DescribeApplicationParametersShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.component_id_list):
            request.component_id_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.component_id_list, 'ComponentIdList', 'json')
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        if not UtilClient.is_unset(request.component_id_list_shrink):
            query['ComponentIdList'] = request.component_id_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplicationParameters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeApplicationParametersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_application_parameters(
        self,
        request: polardb_20170801_models.DescribeApplicationParametersRequest,
    ) -> polardb_20170801_models.DescribeApplicationParametersResponse:
        """
        @summary 获取应用组件参数
        
        @param request: DescribeApplicationParametersRequest
        @return: DescribeApplicationParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_application_parameters_with_options(request, runtime)

    async def describe_application_parameters_async(
        self,
        request: polardb_20170801_models.DescribeApplicationParametersRequest,
    ) -> polardb_20170801_models.DescribeApplicationParametersResponse:
        """
        @summary 获取应用组件参数
        
        @param request: DescribeApplicationParametersRequest
        @return: DescribeApplicationParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_application_parameters_with_options_async(request, runtime)

    def describe_application_serverless_conf_with_options(
        self,
        request: polardb_20170801_models.DescribeApplicationServerlessConfRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeApplicationServerlessConfResponse:
        """
        @summary 获取应用serverless配置
        
        @param request: DescribeApplicationServerlessConfRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationServerlessConfResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplicationServerlessConf',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeApplicationServerlessConfResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_application_serverless_conf_with_options_async(
        self,
        request: polardb_20170801_models.DescribeApplicationServerlessConfRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeApplicationServerlessConfResponse:
        """
        @summary 获取应用serverless配置
        
        @param request: DescribeApplicationServerlessConfRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationServerlessConfResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_id):
            query['ApplicationId'] = request.application_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplicationServerlessConf',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeApplicationServerlessConfResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_application_serverless_conf(
        self,
        request: polardb_20170801_models.DescribeApplicationServerlessConfRequest,
    ) -> polardb_20170801_models.DescribeApplicationServerlessConfResponse:
        """
        @summary 获取应用serverless配置
        
        @param request: DescribeApplicationServerlessConfRequest
        @return: DescribeApplicationServerlessConfResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_application_serverless_conf_with_options(request, runtime)

    async def describe_application_serverless_conf_async(
        self,
        request: polardb_20170801_models.DescribeApplicationServerlessConfRequest,
    ) -> polardb_20170801_models.DescribeApplicationServerlessConfResponse:
        """
        @summary 获取应用serverless配置
        
        @param request: DescribeApplicationServerlessConfRequest
        @return: DescribeApplicationServerlessConfResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_application_serverless_conf_with_options_async(request, runtime)

    def describe_applications_with_options(
        self,
        request: polardb_20170801_models.DescribeApplicationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeApplicationsResponse:
        """
        @summary 获取当前地域所有PolarDB实例的应用列表
        
        @param request: DescribeApplicationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_ids):
            query['ApplicationIds'] = request.application_ids
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplications',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeApplicationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_applications_with_options_async(
        self,
        request: polardb_20170801_models.DescribeApplicationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeApplicationsResponse:
        """
        @summary 获取当前地域所有PolarDB实例的应用列表
        
        @param request: DescribeApplicationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_ids):
            query['ApplicationIds'] = request.application_ids
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplications',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeApplicationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_applications(
        self,
        request: polardb_20170801_models.DescribeApplicationsRequest,
    ) -> polardb_20170801_models.DescribeApplicationsResponse:
        """
        @summary 获取当前地域所有PolarDB实例的应用列表
        
        @param request: DescribeApplicationsRequest
        @return: DescribeApplicationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_applications_with_options(request, runtime)

    async def describe_applications_async(
        self,
        request: polardb_20170801_models.DescribeApplicationsRequest,
    ) -> polardb_20170801_models.DescribeApplicationsResponse:
        """
        @summary 获取当前地域所有PolarDB实例的应用列表
        
        @param request: DescribeApplicationsRequest
        @return: DescribeApplicationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_applications_with_options_async(request, runtime)

    def describe_auto_renew_attribute_with_options(
        self,
        request: polardb_20170801_models.DescribeAutoRenewAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAutoRenewAttributeResponse:
        """
        @summary Queries the auto-renewal attributes of a subscription PolarDB cluster.
        
        @param request: DescribeAutoRenewAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAutoRenewAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoRenewAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAutoRenewAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_auto_renew_attribute_with_options_async(
        self,
        request: polardb_20170801_models.DescribeAutoRenewAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAutoRenewAttributeResponse:
        """
        @summary Queries the auto-renewal attributes of a subscription PolarDB cluster.
        
        @param request: DescribeAutoRenewAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAutoRenewAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoRenewAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAutoRenewAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_auto_renew_attribute(
        self,
        request: polardb_20170801_models.DescribeAutoRenewAttributeRequest,
    ) -> polardb_20170801_models.DescribeAutoRenewAttributeResponse:
        """
        @summary Queries the auto-renewal attributes of a subscription PolarDB cluster.
        
        @param request: DescribeAutoRenewAttributeRequest
        @return: DescribeAutoRenewAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_renew_attribute_with_options(request, runtime)

    async def describe_auto_renew_attribute_async(
        self,
        request: polardb_20170801_models.DescribeAutoRenewAttributeRequest,
    ) -> polardb_20170801_models.DescribeAutoRenewAttributeResponse:
        """
        @summary Queries the auto-renewal attributes of a subscription PolarDB cluster.
        
        @param request: DescribeAutoRenewAttributeRequest
        @return: DescribeAutoRenewAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_renew_attribute_with_options_async(request, runtime)

    def describe_available_cross_regions_with_options(
        self,
        request: polardb_20170801_models.DescribeAvailableCrossRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAvailableCrossRegionsResponse:
        """
        @summary 查询可用跨地域备份地域列表
        
        @param request: DescribeAvailableCrossRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableCrossRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAvailableCrossRegions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAvailableCrossRegionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_available_cross_regions_with_options_async(
        self,
        request: polardb_20170801_models.DescribeAvailableCrossRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeAvailableCrossRegionsResponse:
        """
        @summary 查询可用跨地域备份地域列表
        
        @param request: DescribeAvailableCrossRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableCrossRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAvailableCrossRegions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeAvailableCrossRegionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_available_cross_regions(
        self,
        request: polardb_20170801_models.DescribeAvailableCrossRegionsRequest,
    ) -> polardb_20170801_models.DescribeAvailableCrossRegionsResponse:
        """
        @summary 查询可用跨地域备份地域列表
        
        @param request: DescribeAvailableCrossRegionsRequest
        @return: DescribeAvailableCrossRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_available_cross_regions_with_options(request, runtime)

    async def describe_available_cross_regions_async(
        self,
        request: polardb_20170801_models.DescribeAvailableCrossRegionsRequest,
    ) -> polardb_20170801_models.DescribeAvailableCrossRegionsResponse:
        """
        @summary 查询可用跨地域备份地域列表
        
        @param request: DescribeAvailableCrossRegionsRequest
        @return: DescribeAvailableCrossRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_available_cross_regions_with_options_async(request, runtime)

    def describe_backup_logs_with_options(
        self,
        request: polardb_20170801_models.DescribeBackupLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupLogsResponse:
        """
        @summary Queries backup logs and the URLs to download the backup logs.
        
        @param request: DescribeBackupLogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupLogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_region):
            query['BackupRegion'] = request.backup_region
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupLogs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupLogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_logs_with_options_async(
        self,
        request: polardb_20170801_models.DescribeBackupLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupLogsResponse:
        """
        @summary Queries backup logs and the URLs to download the backup logs.
        
        @param request: DescribeBackupLogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupLogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_region):
            query['BackupRegion'] = request.backup_region
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupLogs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupLogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_logs(
        self,
        request: polardb_20170801_models.DescribeBackupLogsRequest,
    ) -> polardb_20170801_models.DescribeBackupLogsResponse:
        """
        @summary Queries backup logs and the URLs to download the backup logs.
        
        @param request: DescribeBackupLogsRequest
        @return: DescribeBackupLogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_logs_with_options(request, runtime)

    async def describe_backup_logs_async(
        self,
        request: polardb_20170801_models.DescribeBackupLogsRequest,
    ) -> polardb_20170801_models.DescribeBackupLogsResponse:
        """
        @summary Queries backup logs and the URLs to download the backup logs.
        
        @param request: DescribeBackupLogsRequest
        @return: DescribeBackupLogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_logs_with_options_async(request, runtime)

    def describe_backup_policy_with_options(
        self,
        request: polardb_20170801_models.DescribeBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the automatic backup policy of a PolarDB cluster.
        
        @param request: DescribeBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicy',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_policy_with_options_async(
        self,
        request: polardb_20170801_models.DescribeBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the automatic backup policy of a PolarDB cluster.
        
        @param request: DescribeBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicy',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_policy(
        self,
        request: polardb_20170801_models.DescribeBackupPolicyRequest,
    ) -> polardb_20170801_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the automatic backup policy of a PolarDB cluster.
        
        @param request: DescribeBackupPolicyRequest
        @return: DescribeBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_policy_with_options(request, runtime)

    async def describe_backup_policy_async(
        self,
        request: polardb_20170801_models.DescribeBackupPolicyRequest,
    ) -> polardb_20170801_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the automatic backup policy of a PolarDB cluster.
        
        @param request: DescribeBackupPolicyRequest
        @return: DescribeBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_policy_with_options_async(request, runtime)

    def describe_backup_regions_with_options(
        self,
        request: polardb_20170801_models.DescribeBackupRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupRegionsResponse:
        """
        @summary 查询备份集所在地域信息
        
        @param request: DescribeBackupRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupRegions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupRegionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_regions_with_options_async(
        self,
        request: polardb_20170801_models.DescribeBackupRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupRegionsResponse:
        """
        @summary 查询备份集所在地域信息
        
        @param request: DescribeBackupRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupRegions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupRegionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_regions(
        self,
        request: polardb_20170801_models.DescribeBackupRegionsRequest,
    ) -> polardb_20170801_models.DescribeBackupRegionsResponse:
        """
        @summary 查询备份集所在地域信息
        
        @param request: DescribeBackupRegionsRequest
        @return: DescribeBackupRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_regions_with_options(request, runtime)

    async def describe_backup_regions_async(
        self,
        request: polardb_20170801_models.DescribeBackupRegionsRequest,
    ) -> polardb_20170801_models.DescribeBackupRegionsResponse:
        """
        @summary 查询备份集所在地域信息
        
        @param request: DescribeBackupRegionsRequest
        @return: DescribeBackupRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_regions_with_options_async(request, runtime)

    def describe_backup_tasks_with_options(
        self,
        request: polardb_20170801_models.DescribeBackupTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupTasksResponse:
        """
        @summary Queries the backup tasks of a PolarDB cluster.
        
        @param request: DescribeBackupTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_job_id):
            query['BackupJobId'] = request.backup_job_id
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupTasksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_tasks_with_options_async(
        self,
        request: polardb_20170801_models.DescribeBackupTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupTasksResponse:
        """
        @summary Queries the backup tasks of a PolarDB cluster.
        
        @param request: DescribeBackupTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_job_id):
            query['BackupJobId'] = request.backup_job_id
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupTasksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_tasks(
        self,
        request: polardb_20170801_models.DescribeBackupTasksRequest,
    ) -> polardb_20170801_models.DescribeBackupTasksResponse:
        """
        @summary Queries the backup tasks of a PolarDB cluster.
        
        @param request: DescribeBackupTasksRequest
        @return: DescribeBackupTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_tasks_with_options(request, runtime)

    async def describe_backup_tasks_async(
        self,
        request: polardb_20170801_models.DescribeBackupTasksRequest,
    ) -> polardb_20170801_models.DescribeBackupTasksResponse:
        """
        @summary Queries the backup tasks of a PolarDB cluster.
        
        @param request: DescribeBackupTasksRequest
        @return: DescribeBackupTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_tasks_with_options_async(request, runtime)

    def describe_backups_with_options(
        self,
        request: polardb_20170801_models.DescribeBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupsResponse:
        """
        @summary Queries the backup details of a PolarDB cluster.
        
        @param request: DescribeBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.backup_region):
            query['BackupRegion'] = request.backup_region
        if not UtilClient.is_unset(request.backup_status):
            query['BackupStatus'] = request.backup_status
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackups',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backups_with_options_async(
        self,
        request: polardb_20170801_models.DescribeBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeBackupsResponse:
        """
        @summary Queries the backup details of a PolarDB cluster.
        
        @param request: DescribeBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.backup_region):
            query['BackupRegion'] = request.backup_region
        if not UtilClient.is_unset(request.backup_status):
            query['BackupStatus'] = request.backup_status
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackups',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeBackupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backups(
        self,
        request: polardb_20170801_models.DescribeBackupsRequest,
    ) -> polardb_20170801_models.DescribeBackupsResponse:
        """
        @summary Queries the backup details of a PolarDB cluster.
        
        @param request: DescribeBackupsRequest
        @return: DescribeBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backups_with_options(request, runtime)

    async def describe_backups_async(
        self,
        request: polardb_20170801_models.DescribeBackupsRequest,
    ) -> polardb_20170801_models.DescribeBackupsResponse:
        """
        @summary Queries the backup details of a PolarDB cluster.
        
        @param request: DescribeBackupsRequest
        @return: DescribeBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backups_with_options_async(request, runtime)

    def describe_character_set_name_with_options(
        self,
        request: polardb_20170801_models.DescribeCharacterSetNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCharacterSetNameResponse:
        """
        @summary Queries character sets that are supported by a PolarDB for MySQL cluster.
        
        @param request: DescribeCharacterSetNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCharacterSetNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCharacterSetName',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCharacterSetNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_character_set_name_with_options_async(
        self,
        request: polardb_20170801_models.DescribeCharacterSetNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCharacterSetNameResponse:
        """
        @summary Queries character sets that are supported by a PolarDB for MySQL cluster.
        
        @param request: DescribeCharacterSetNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCharacterSetNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCharacterSetName',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCharacterSetNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_character_set_name(
        self,
        request: polardb_20170801_models.DescribeCharacterSetNameRequest,
    ) -> polardb_20170801_models.DescribeCharacterSetNameResponse:
        """
        @summary Queries character sets that are supported by a PolarDB for MySQL cluster.
        
        @param request: DescribeCharacterSetNameRequest
        @return: DescribeCharacterSetNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_character_set_name_with_options(request, runtime)

    async def describe_character_set_name_async(
        self,
        request: polardb_20170801_models.DescribeCharacterSetNameRequest,
    ) -> polardb_20170801_models.DescribeCharacterSetNameResponse:
        """
        @summary Queries character sets that are supported by a PolarDB for MySQL cluster.
        
        @param request: DescribeCharacterSetNameRequest
        @return: DescribeCharacterSetNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_character_set_name_with_options_async(request, runtime)

    def describe_class_list_with_options(
        self,
        request: polardb_20170801_models.DescribeClassListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeClassListResponse:
        """
        @summary Queries the specifications of a cluster.
        
        @param request: DescribeClassListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClassListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.master_ha):
            query['MasterHa'] = request.master_ha
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClassList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeClassListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_class_list_with_options_async(
        self,
        request: polardb_20170801_models.DescribeClassListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeClassListResponse:
        """
        @summary Queries the specifications of a cluster.
        
        @param request: DescribeClassListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClassListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.master_ha):
            query['MasterHa'] = request.master_ha
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClassList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeClassListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_class_list(
        self,
        request: polardb_20170801_models.DescribeClassListRequest,
    ) -> polardb_20170801_models.DescribeClassListResponse:
        """
        @summary Queries the specifications of a cluster.
        
        @param request: DescribeClassListRequest
        @return: DescribeClassListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_class_list_with_options(request, runtime)

    async def describe_class_list_async(
        self,
        request: polardb_20170801_models.DescribeClassListRequest,
    ) -> polardb_20170801_models.DescribeClassListResponse:
        """
        @summary Queries the specifications of a cluster.
        
        @param request: DescribeClassListRequest
        @return: DescribeClassListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_class_list_with_options_async(request, runtime)

    def describe_cold_storage_instance_with_options(
        self,
        request: polardb_20170801_models.DescribeColdStorageInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeColdStorageInstanceResponse:
        """
        @summary 查询冷存储实例信息
        
        @param request: DescribeColdStorageInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeColdStorageInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.engine_type):
            query['EngineType'] = request.engine_type
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.object_type):
            query['ObjectType'] = request.object_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.table_name):
            query['TableName'] = request.table_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeColdStorageInstance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeColdStorageInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cold_storage_instance_with_options_async(
        self,
        request: polardb_20170801_models.DescribeColdStorageInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeColdStorageInstanceResponse:
        """
        @summary 查询冷存储实例信息
        
        @param request: DescribeColdStorageInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeColdStorageInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.engine_type):
            query['EngineType'] = request.engine_type
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.object_type):
            query['ObjectType'] = request.object_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.table_name):
            query['TableName'] = request.table_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeColdStorageInstance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeColdStorageInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cold_storage_instance(
        self,
        request: polardb_20170801_models.DescribeColdStorageInstanceRequest,
    ) -> polardb_20170801_models.DescribeColdStorageInstanceResponse:
        """
        @summary 查询冷存储实例信息
        
        @param request: DescribeColdStorageInstanceRequest
        @return: DescribeColdStorageInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cold_storage_instance_with_options(request, runtime)

    async def describe_cold_storage_instance_async(
        self,
        request: polardb_20170801_models.DescribeColdStorageInstanceRequest,
    ) -> polardb_20170801_models.DescribeColdStorageInstanceResponse:
        """
        @summary 查询冷存储实例信息
        
        @param request: DescribeColdStorageInstanceRequest
        @return: DescribeColdStorageInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cold_storage_instance_with_options_async(request, runtime)

    def describe_cron_job_policy_serverless_with_options(
        self,
        request: polardb_20170801_models.DescribeCronJobPolicyServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCronJobPolicyServerlessResponse:
        """
        @summary 查询周期任务策略
        
        @param request: DescribeCronJobPolicyServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCronJobPolicyServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCronJobPolicyServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCronJobPolicyServerlessResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cron_job_policy_serverless_with_options_async(
        self,
        request: polardb_20170801_models.DescribeCronJobPolicyServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCronJobPolicyServerlessResponse:
        """
        @summary 查询周期任务策略
        
        @param request: DescribeCronJobPolicyServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCronJobPolicyServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCronJobPolicyServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCronJobPolicyServerlessResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cron_job_policy_serverless(
        self,
        request: polardb_20170801_models.DescribeCronJobPolicyServerlessRequest,
    ) -> polardb_20170801_models.DescribeCronJobPolicyServerlessResponse:
        """
        @summary 查询周期任务策略
        
        @param request: DescribeCronJobPolicyServerlessRequest
        @return: DescribeCronJobPolicyServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cron_job_policy_serverless_with_options(request, runtime)

    async def describe_cron_job_policy_serverless_async(
        self,
        request: polardb_20170801_models.DescribeCronJobPolicyServerlessRequest,
    ) -> polardb_20170801_models.DescribeCronJobPolicyServerlessResponse:
        """
        @summary 查询周期任务策略
        
        @param request: DescribeCronJobPolicyServerlessRequest
        @return: DescribeCronJobPolicyServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cron_job_policy_serverless_with_options_async(request, runtime)

    def describe_cross_cloud_levels_with_options(
        self,
        request: polardb_20170801_models.DescribeCrossCloudLevelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCrossCloudLevelsResponse:
        """
        @summary 查询跨云支持的规格列表
        
        @param request: DescribeCrossCloudLevelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCrossCloudLevelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCrossCloudLevels',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCrossCloudLevelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cross_cloud_levels_with_options_async(
        self,
        request: polardb_20170801_models.DescribeCrossCloudLevelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCrossCloudLevelsResponse:
        """
        @summary 查询跨云支持的规格列表
        
        @param request: DescribeCrossCloudLevelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCrossCloudLevelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCrossCloudLevels',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCrossCloudLevelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cross_cloud_levels(
        self,
        request: polardb_20170801_models.DescribeCrossCloudLevelsRequest,
    ) -> polardb_20170801_models.DescribeCrossCloudLevelsResponse:
        """
        @summary 查询跨云支持的规格列表
        
        @param request: DescribeCrossCloudLevelsRequest
        @return: DescribeCrossCloudLevelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cross_cloud_levels_with_options(request, runtime)

    async def describe_cross_cloud_levels_async(
        self,
        request: polardb_20170801_models.DescribeCrossCloudLevelsRequest,
    ) -> polardb_20170801_models.DescribeCrossCloudLevelsResponse:
        """
        @summary 查询跨云支持的规格列表
        
        @param request: DescribeCrossCloudLevelsRequest
        @return: DescribeCrossCloudLevelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cross_cloud_levels_with_options_async(request, runtime)

    def describe_cross_cloud_region_with_options(
        self,
        request: polardb_20170801_models.DescribeCrossCloudRegionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCrossCloudRegionResponse:
        """
        @summary 查看跨云开区信息
        
        @param request: DescribeCrossCloudRegionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCrossCloudRegionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.cross_cloud_region_id):
            query['CrossCloudRegionId'] = request.cross_cloud_region_id
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCrossCloudRegion',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCrossCloudRegionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cross_cloud_region_with_options_async(
        self,
        request: polardb_20170801_models.DescribeCrossCloudRegionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCrossCloudRegionResponse:
        """
        @summary 查看跨云开区信息
        
        @param request: DescribeCrossCloudRegionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCrossCloudRegionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.cross_cloud_region_id):
            query['CrossCloudRegionId'] = request.cross_cloud_region_id
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCrossCloudRegion',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCrossCloudRegionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cross_cloud_region(
        self,
        request: polardb_20170801_models.DescribeCrossCloudRegionRequest,
    ) -> polardb_20170801_models.DescribeCrossCloudRegionResponse:
        """
        @summary 查看跨云开区信息
        
        @param request: DescribeCrossCloudRegionRequest
        @return: DescribeCrossCloudRegionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cross_cloud_region_with_options(request, runtime)

    async def describe_cross_cloud_region_async(
        self,
        request: polardb_20170801_models.DescribeCrossCloudRegionRequest,
    ) -> polardb_20170801_models.DescribeCrossCloudRegionResponse:
        """
        @summary 查看跨云开区信息
        
        @param request: DescribeCrossCloudRegionRequest
        @return: DescribeCrossCloudRegionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cross_cloud_region_with_options_async(request, runtime)

    def describe_cross_cloud_region_mapping_to_aliyun_with_options(
        self,
        request: polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunResponse:
        """
        @summary 查询跨云地域映射
        
        @param request: DescribeCrossCloudRegionMappingToAliyunRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCrossCloudRegionMappingToAliyunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_region_id):
            query['AliyunRegionId'] = request.aliyun_region_id
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.cross_cloud_region_id):
            query['CrossCloudRegionId'] = request.cross_cloud_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCrossCloudRegionMappingToAliyun',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cross_cloud_region_mapping_to_aliyun_with_options_async(
        self,
        request: polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunResponse:
        """
        @summary 查询跨云地域映射
        
        @param request: DescribeCrossCloudRegionMappingToAliyunRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCrossCloudRegionMappingToAliyunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_region_id):
            query['AliyunRegionId'] = request.aliyun_region_id
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.cross_cloud_region_id):
            query['CrossCloudRegionId'] = request.cross_cloud_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCrossCloudRegionMappingToAliyun',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cross_cloud_region_mapping_to_aliyun(
        self,
        request: polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunRequest,
    ) -> polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunResponse:
        """
        @summary 查询跨云地域映射
        
        @param request: DescribeCrossCloudRegionMappingToAliyunRequest
        @return: DescribeCrossCloudRegionMappingToAliyunResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cross_cloud_region_mapping_to_aliyun_with_options(request, runtime)

    async def describe_cross_cloud_region_mapping_to_aliyun_async(
        self,
        request: polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunRequest,
    ) -> polardb_20170801_models.DescribeCrossCloudRegionMappingToAliyunResponse:
        """
        @summary 查询跨云地域映射
        
        @param request: DescribeCrossCloudRegionMappingToAliyunRequest
        @return: DescribeCrossCloudRegionMappingToAliyunResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cross_cloud_region_mapping_to_aliyun_with_options_async(request, runtime)

    def describe_dbcluster_access_whitelist_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterAccessWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterAccessWhitelistResponse:
        """
        @summary Queries the IP address whitelists and security groups of a PolarDB cluster.
        
        @param request: DescribeDBClusterAccessWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterAccessWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterAccessWhitelist',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterAccessWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_access_whitelist_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterAccessWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterAccessWhitelistResponse:
        """
        @summary Queries the IP address whitelists and security groups of a PolarDB cluster.
        
        @param request: DescribeDBClusterAccessWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterAccessWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterAccessWhitelist',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterAccessWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_access_whitelist(
        self,
        request: polardb_20170801_models.DescribeDBClusterAccessWhitelistRequest,
    ) -> polardb_20170801_models.DescribeDBClusterAccessWhitelistResponse:
        """
        @summary Queries the IP address whitelists and security groups of a PolarDB cluster.
        
        @param request: DescribeDBClusterAccessWhitelistRequest
        @return: DescribeDBClusterAccessWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_access_whitelist_with_options(request, runtime)

    async def describe_dbcluster_access_whitelist_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterAccessWhitelistRequest,
    ) -> polardb_20170801_models.DescribeDBClusterAccessWhitelistResponse:
        """
        @summary Queries the IP address whitelists and security groups of a PolarDB cluster.
        
        @param request: DescribeDBClusterAccessWhitelistRequest
        @return: DescribeDBClusterAccessWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_access_whitelist_with_options_async(request, runtime)

    def describe_dbcluster_attribute_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterAttributeResponse:
        """
        @summary Queries information about a PolarDB cluster.
        
        @param request: DescribeDBClusterAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_attribute_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterAttributeResponse:
        """
        @summary Queries information about a PolarDB cluster.
        
        @param request: DescribeDBClusterAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_attribute(
        self,
        request: polardb_20170801_models.DescribeDBClusterAttributeRequest,
    ) -> polardb_20170801_models.DescribeDBClusterAttributeResponse:
        """
        @summary Queries information about a PolarDB cluster.
        
        @param request: DescribeDBClusterAttributeRequest
        @return: DescribeDBClusterAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_attribute_with_options(request, runtime)

    async def describe_dbcluster_attribute_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterAttributeRequest,
    ) -> polardb_20170801_models.DescribeDBClusterAttributeResponse:
        """
        @summary Queries information about a PolarDB cluster.
        
        @param request: DescribeDBClusterAttributeRequest
        @return: DescribeDBClusterAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_attribute_with_options_async(request, runtime)

    def describe_dbcluster_audit_log_collector_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterAuditLogCollectorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterAuditLogCollectorResponse:
        """
        @summary Describe SQL collector for a PolarDB cluster. Features related to SQL collector include audit log and SQL Explorer.
        
        @param request: DescribeDBClusterAuditLogCollectorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterAuditLogCollectorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterAuditLogCollector',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterAuditLogCollectorResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_audit_log_collector_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterAuditLogCollectorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterAuditLogCollectorResponse:
        """
        @summary Describe SQL collector for a PolarDB cluster. Features related to SQL collector include audit log and SQL Explorer.
        
        @param request: DescribeDBClusterAuditLogCollectorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterAuditLogCollectorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterAuditLogCollector',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterAuditLogCollectorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_audit_log_collector(
        self,
        request: polardb_20170801_models.DescribeDBClusterAuditLogCollectorRequest,
    ) -> polardb_20170801_models.DescribeDBClusterAuditLogCollectorResponse:
        """
        @summary Describe SQL collector for a PolarDB cluster. Features related to SQL collector include audit log and SQL Explorer.
        
        @param request: DescribeDBClusterAuditLogCollectorRequest
        @return: DescribeDBClusterAuditLogCollectorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_audit_log_collector_with_options(request, runtime)

    async def describe_dbcluster_audit_log_collector_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterAuditLogCollectorRequest,
    ) -> polardb_20170801_models.DescribeDBClusterAuditLogCollectorResponse:
        """
        @summary Describe SQL collector for a PolarDB cluster. Features related to SQL collector include audit log and SQL Explorer.
        
        @param request: DescribeDBClusterAuditLogCollectorRequest
        @return: DescribeDBClusterAuditLogCollectorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_audit_log_collector_with_options_async(request, runtime)

    def describe_dbcluster_available_resources_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterAvailableResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterAvailableResourcesResponse:
        """
        @summary Queries available resources in a PolarDB cluster.
        
        @param request: DescribeDBClusterAvailableResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterAvailableResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbnode_class):
            query['DBNodeClass'] = request.dbnode_class
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterAvailableResources',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterAvailableResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_available_resources_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterAvailableResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterAvailableResourcesResponse:
        """
        @summary Queries available resources in a PolarDB cluster.
        
        @param request: DescribeDBClusterAvailableResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterAvailableResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbnode_class):
            query['DBNodeClass'] = request.dbnode_class
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterAvailableResources',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterAvailableResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_available_resources(
        self,
        request: polardb_20170801_models.DescribeDBClusterAvailableResourcesRequest,
    ) -> polardb_20170801_models.DescribeDBClusterAvailableResourcesResponse:
        """
        @summary Queries available resources in a PolarDB cluster.
        
        @param request: DescribeDBClusterAvailableResourcesRequest
        @return: DescribeDBClusterAvailableResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_available_resources_with_options(request, runtime)

    async def describe_dbcluster_available_resources_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterAvailableResourcesRequest,
    ) -> polardb_20170801_models.DescribeDBClusterAvailableResourcesResponse:
        """
        @summary Queries available resources in a PolarDB cluster.
        
        @param request: DescribeDBClusterAvailableResourcesRequest
        @return: DescribeDBClusterAvailableResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_available_resources_with_options_async(request, runtime)

    def describe_dbcluster_connectivity_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterConnectivityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterConnectivityResponse:
        """
        @summary Queries whether the source IP address can access a cluster.
        
        @param request: DescribeDBClusterConnectivityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterConnectivityResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.source_ip_address):
            query['SourceIpAddress'] = request.source_ip_address
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterConnectivity',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterConnectivityResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_connectivity_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterConnectivityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterConnectivityResponse:
        """
        @summary Queries whether the source IP address can access a cluster.
        
        @param request: DescribeDBClusterConnectivityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterConnectivityResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.source_ip_address):
            query['SourceIpAddress'] = request.source_ip_address
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterConnectivity',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterConnectivityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_connectivity(
        self,
        request: polardb_20170801_models.DescribeDBClusterConnectivityRequest,
    ) -> polardb_20170801_models.DescribeDBClusterConnectivityResponse:
        """
        @summary Queries whether the source IP address can access a cluster.
        
        @param request: DescribeDBClusterConnectivityRequest
        @return: DescribeDBClusterConnectivityResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_connectivity_with_options(request, runtime)

    async def describe_dbcluster_connectivity_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterConnectivityRequest,
    ) -> polardb_20170801_models.DescribeDBClusterConnectivityResponse:
        """
        @summary Queries whether the source IP address can access a cluster.
        
        @param request: DescribeDBClusterConnectivityRequest
        @return: DescribeDBClusterConnectivityResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_connectivity_with_options_async(request, runtime)

    def describe_dbcluster_encryption_key_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterEncryptionKeyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterEncryptionKeyResponse:
        """
        @summary DescribeDBClusterEncryptionKey
        
        @param request: DescribeDBClusterEncryptionKeyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterEncryptionKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterEncryptionKey',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterEncryptionKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_encryption_key_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterEncryptionKeyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterEncryptionKeyResponse:
        """
        @summary DescribeDBClusterEncryptionKey
        
        @param request: DescribeDBClusterEncryptionKeyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterEncryptionKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterEncryptionKey',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterEncryptionKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_encryption_key(
        self,
        request: polardb_20170801_models.DescribeDBClusterEncryptionKeyRequest,
    ) -> polardb_20170801_models.DescribeDBClusterEncryptionKeyResponse:
        """
        @summary DescribeDBClusterEncryptionKey
        
        @param request: DescribeDBClusterEncryptionKeyRequest
        @return: DescribeDBClusterEncryptionKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_encryption_key_with_options(request, runtime)

    async def describe_dbcluster_encryption_key_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterEncryptionKeyRequest,
    ) -> polardb_20170801_models.DescribeDBClusterEncryptionKeyResponse:
        """
        @summary DescribeDBClusterEncryptionKey
        
        @param request: DescribeDBClusterEncryptionKeyRequest
        @return: DescribeDBClusterEncryptionKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_encryption_key_with_options_async(request, runtime)

    def describe_dbcluster_endpoints_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterEndpointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterEndpointsResponse:
        """
        @summary Queries the endpoints of a PolarDB cluster.
        
        @param request: DescribeDBClusterEndpointsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterEndpointsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterEndpoints',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterEndpointsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_endpoints_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterEndpointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterEndpointsResponse:
        """
        @summary Queries the endpoints of a PolarDB cluster.
        
        @param request: DescribeDBClusterEndpointsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterEndpointsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterEndpoints',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterEndpointsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_endpoints(
        self,
        request: polardb_20170801_models.DescribeDBClusterEndpointsRequest,
    ) -> polardb_20170801_models.DescribeDBClusterEndpointsResponse:
        """
        @summary Queries the endpoints of a PolarDB cluster.
        
        @param request: DescribeDBClusterEndpointsRequest
        @return: DescribeDBClusterEndpointsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_endpoints_with_options(request, runtime)

    async def describe_dbcluster_endpoints_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterEndpointsRequest,
    ) -> polardb_20170801_models.DescribeDBClusterEndpointsResponse:
        """
        @summary Queries the endpoints of a PolarDB cluster.
        
        @param request: DescribeDBClusterEndpointsRequest
        @return: DescribeDBClusterEndpointsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_endpoints_with_options_async(request, runtime)

    def describe_dbcluster_endpoints_zonal_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterEndpointsZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterEndpointsZonalResponse:
        """
        @summary 查询PolarDB边缘集群的链接地址
        
        @param request: DescribeDBClusterEndpointsZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterEndpointsZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterEndpointsZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterEndpointsZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_endpoints_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterEndpointsZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterEndpointsZonalResponse:
        """
        @summary 查询PolarDB边缘集群的链接地址
        
        @param request: DescribeDBClusterEndpointsZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterEndpointsZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterEndpointsZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterEndpointsZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_endpoints_zonal(
        self,
        request: polardb_20170801_models.DescribeDBClusterEndpointsZonalRequest,
    ) -> polardb_20170801_models.DescribeDBClusterEndpointsZonalResponse:
        """
        @summary 查询PolarDB边缘集群的链接地址
        
        @param request: DescribeDBClusterEndpointsZonalRequest
        @return: DescribeDBClusterEndpointsZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_endpoints_zonal_with_options(request, runtime)

    async def describe_dbcluster_endpoints_zonal_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterEndpointsZonalRequest,
    ) -> polardb_20170801_models.DescribeDBClusterEndpointsZonalResponse:
        """
        @summary 查询PolarDB边缘集群的链接地址
        
        @param request: DescribeDBClusterEndpointsZonalRequest
        @return: DescribeDBClusterEndpointsZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_endpoints_zonal_with_options_async(request, runtime)

    def describe_dbcluster_migration_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterMigrationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterMigrationResponse:
        """
        @summary The ID of the synchronous task.
        
        @description The ID of the request.
        
        @param request: DescribeDBClusterMigrationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterMigrationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterMigration',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterMigrationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_migration_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterMigrationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterMigrationResponse:
        """
        @summary The ID of the synchronous task.
        
        @description The ID of the request.
        
        @param request: DescribeDBClusterMigrationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterMigrationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterMigration',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterMigrationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_migration(
        self,
        request: polardb_20170801_models.DescribeDBClusterMigrationRequest,
    ) -> polardb_20170801_models.DescribeDBClusterMigrationResponse:
        """
        @summary The ID of the synchronous task.
        
        @description The ID of the request.
        
        @param request: DescribeDBClusterMigrationRequest
        @return: DescribeDBClusterMigrationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_migration_with_options(request, runtime)

    async def describe_dbcluster_migration_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterMigrationRequest,
    ) -> polardb_20170801_models.DescribeDBClusterMigrationResponse:
        """
        @summary The ID of the synchronous task.
        
        @description The ID of the request.
        
        @param request: DescribeDBClusterMigrationRequest
        @return: DescribeDBClusterMigrationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_migration_with_options_async(request, runtime)

    def describe_dbcluster_monitor_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterMonitorResponse:
        """
        @summary Queries the interval at which the monitoring data of a PolarDB cluster is collected.
        
        @param request: DescribeDBClusterMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterMonitorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterMonitor',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterMonitorResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_monitor_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterMonitorResponse:
        """
        @summary Queries the interval at which the monitoring data of a PolarDB cluster is collected.
        
        @param request: DescribeDBClusterMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterMonitorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterMonitor',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterMonitorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_monitor(
        self,
        request: polardb_20170801_models.DescribeDBClusterMonitorRequest,
    ) -> polardb_20170801_models.DescribeDBClusterMonitorResponse:
        """
        @summary Queries the interval at which the monitoring data of a PolarDB cluster is collected.
        
        @param request: DescribeDBClusterMonitorRequest
        @return: DescribeDBClusterMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_monitor_with_options(request, runtime)

    async def describe_dbcluster_monitor_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterMonitorRequest,
    ) -> polardb_20170801_models.DescribeDBClusterMonitorResponse:
        """
        @summary Queries the interval at which the monitoring data of a PolarDB cluster is collected.
        
        @param request: DescribeDBClusterMonitorRequest
        @return: DescribeDBClusterMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_monitor_with_options_async(request, runtime)

    def describe_dbcluster_net_info_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterNetInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterNetInfoResponse:
        """
        @param request: DescribeDBClusterNetInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterNetInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string_type):
            query['ConnectionStringType'] = request.connection_string_type
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterNetInfo',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterNetInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_net_info_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterNetInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterNetInfoResponse:
        """
        @param request: DescribeDBClusterNetInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterNetInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string_type):
            query['ConnectionStringType'] = request.connection_string_type
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterNetInfo',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterNetInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_net_info(
        self,
        request: polardb_20170801_models.DescribeDBClusterNetInfoRequest,
    ) -> polardb_20170801_models.DescribeDBClusterNetInfoResponse:
        """
        @param request: DescribeDBClusterNetInfoRequest
        @return: DescribeDBClusterNetInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_net_info_with_options(request, runtime)

    async def describe_dbcluster_net_info_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterNetInfoRequest,
    ) -> polardb_20170801_models.DescribeDBClusterNetInfoResponse:
        """
        @param request: DescribeDBClusterNetInfoRequest
        @return: DescribeDBClusterNetInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_net_info_with_options_async(request, runtime)

    def describe_dbcluster_parameters_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterParametersResponse:
        """
        @summary Queries the parameters of a PolarDB cluster.
        
        @param request: DescribeDBClusterParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterParametersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterParameters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterParametersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_parameters_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterParametersResponse:
        """
        @summary Queries the parameters of a PolarDB cluster.
        
        @param request: DescribeDBClusterParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterParametersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterParameters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterParametersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_parameters(
        self,
        request: polardb_20170801_models.DescribeDBClusterParametersRequest,
    ) -> polardb_20170801_models.DescribeDBClusterParametersResponse:
        """
        @summary Queries the parameters of a PolarDB cluster.
        
        @param request: DescribeDBClusterParametersRequest
        @return: DescribeDBClusterParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_parameters_with_options(request, runtime)

    async def describe_dbcluster_parameters_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterParametersRequest,
    ) -> polardb_20170801_models.DescribeDBClusterParametersResponse:
        """
        @summary Queries the parameters of a PolarDB cluster.
        
        @param request: DescribeDBClusterParametersRequest
        @return: DescribeDBClusterParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_parameters_with_options_async(request, runtime)

    def describe_dbcluster_performance_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterPerformanceResponse:
        """
        @summary Queries the performance data of a PolarDB cluster.
        
        @description    When the monitoring data is collected every 5 seconds:
        If the query time range is less than or equal to 1 hour, the data is displayed at intervals of 5 seconds.
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        When the monitoring data is collected every 60 seconds:
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        >  By default, the monitoring data is collected once every 60 seconds. You can call the [ModifyDBClusterMonitor](https://help.aliyun.com/document_detail/159557.html) operation to set the data collection interval to every 5 seconds.
        
        @param request: DescribeDBClusterPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.sub_group_name):
            query['SubGroupName'] = request.sub_group_name
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterPerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterPerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_performance_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterPerformanceResponse:
        """
        @summary Queries the performance data of a PolarDB cluster.
        
        @description    When the monitoring data is collected every 5 seconds:
        If the query time range is less than or equal to 1 hour, the data is displayed at intervals of 5 seconds.
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        When the monitoring data is collected every 60 seconds:
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        >  By default, the monitoring data is collected once every 60 seconds. You can call the [ModifyDBClusterMonitor](https://help.aliyun.com/document_detail/159557.html) operation to set the data collection interval to every 5 seconds.
        
        @param request: DescribeDBClusterPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.sub_group_name):
            query['SubGroupName'] = request.sub_group_name
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterPerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterPerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_performance(
        self,
        request: polardb_20170801_models.DescribeDBClusterPerformanceRequest,
    ) -> polardb_20170801_models.DescribeDBClusterPerformanceResponse:
        """
        @summary Queries the performance data of a PolarDB cluster.
        
        @description    When the monitoring data is collected every 5 seconds:
        If the query time range is less than or equal to 1 hour, the data is displayed at intervals of 5 seconds.
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        When the monitoring data is collected every 60 seconds:
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        >  By default, the monitoring data is collected once every 60 seconds. You can call the [ModifyDBClusterMonitor](https://help.aliyun.com/document_detail/159557.html) operation to set the data collection interval to every 5 seconds.
        
        @param request: DescribeDBClusterPerformanceRequest
        @return: DescribeDBClusterPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_performance_with_options(request, runtime)

    async def describe_dbcluster_performance_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterPerformanceRequest,
    ) -> polardb_20170801_models.DescribeDBClusterPerformanceResponse:
        """
        @summary Queries the performance data of a PolarDB cluster.
        
        @description    When the monitoring data is collected every 5 seconds:
        If the query time range is less than or equal to 1 hour, the data is displayed at intervals of 5 seconds.
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        When the monitoring data is collected every 60 seconds:
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        >  By default, the monitoring data is collected once every 60 seconds. You can call the [ModifyDBClusterMonitor](https://help.aliyun.com/document_detail/159557.html) operation to set the data collection interval to every 5 seconds.
        
        @param request: DescribeDBClusterPerformanceRequest
        @return: DescribeDBClusterPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_performance_with_options_async(request, runtime)

    def describe_dbcluster_proxy_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterProxyResponse:
        """
        @summary 查询代理详情
        
        @param request: DescribeDBClusterProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterProxy',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterProxyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_proxy_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterProxyResponse:
        """
        @summary 查询代理详情
        
        @param request: DescribeDBClusterProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterProxy',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterProxyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_proxy(
        self,
        request: polardb_20170801_models.DescribeDBClusterProxyRequest,
    ) -> polardb_20170801_models.DescribeDBClusterProxyResponse:
        """
        @summary 查询代理详情
        
        @param request: DescribeDBClusterProxyRequest
        @return: DescribeDBClusterProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_proxy_with_options(request, runtime)

    async def describe_dbcluster_proxy_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterProxyRequest,
    ) -> polardb_20170801_models.DescribeDBClusterProxyResponse:
        """
        @summary 查询代理详情
        
        @param request: DescribeDBClusterProxyRequest
        @return: DescribeDBClusterProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_proxy_with_options_async(request, runtime)

    def describe_dbcluster_sslwith_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterSSLRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterSSLResponse:
        """
        @summary Queries the Secure Sockets Layer (SSL) settings of a PolarDB cluster.
        
        @param request: DescribeDBClusterSSLRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterSSLResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterSSL',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterSSLResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_sslwith_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterSSLRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterSSLResponse:
        """
        @summary Queries the Secure Sockets Layer (SSL) settings of a PolarDB cluster.
        
        @param request: DescribeDBClusterSSLRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterSSLResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterSSL',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterSSLResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_ssl(
        self,
        request: polardb_20170801_models.DescribeDBClusterSSLRequest,
    ) -> polardb_20170801_models.DescribeDBClusterSSLResponse:
        """
        @summary Queries the Secure Sockets Layer (SSL) settings of a PolarDB cluster.
        
        @param request: DescribeDBClusterSSLRequest
        @return: DescribeDBClusterSSLResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_sslwith_options(request, runtime)

    async def describe_dbcluster_ssl_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterSSLRequest,
    ) -> polardb_20170801_models.DescribeDBClusterSSLResponse:
        """
        @summary Queries the Secure Sockets Layer (SSL) settings of a PolarDB cluster.
        
        @param request: DescribeDBClusterSSLRequest
        @return: DescribeDBClusterSSLResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_sslwith_options_async(request, runtime)

    def describe_dbcluster_serverless_conf_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterServerlessConfRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterServerlessConfResponse:
        """
        @summary Queries the serverless configurations of a serverless cluster.
        
        @param request: DescribeDBClusterServerlessConfRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterServerlessConfResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterServerlessConf',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterServerlessConfResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_serverless_conf_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterServerlessConfRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterServerlessConfResponse:
        """
        @summary Queries the serverless configurations of a serverless cluster.
        
        @param request: DescribeDBClusterServerlessConfRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterServerlessConfResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterServerlessConf',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterServerlessConfResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_serverless_conf(
        self,
        request: polardb_20170801_models.DescribeDBClusterServerlessConfRequest,
    ) -> polardb_20170801_models.DescribeDBClusterServerlessConfResponse:
        """
        @summary Queries the serverless configurations of a serverless cluster.
        
        @param request: DescribeDBClusterServerlessConfRequest
        @return: DescribeDBClusterServerlessConfResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_serverless_conf_with_options(request, runtime)

    async def describe_dbcluster_serverless_conf_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterServerlessConfRequest,
    ) -> polardb_20170801_models.DescribeDBClusterServerlessConfResponse:
        """
        @summary Queries the serverless configurations of a serverless cluster.
        
        @param request: DescribeDBClusterServerlessConfRequest
        @return: DescribeDBClusterServerlessConfResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_serverless_conf_with_options_async(request, runtime)

    def describe_dbcluster_tdewith_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterTDERequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterTDEResponse:
        """
        @summary Queries the transparent data encryption (TDE) settings of a PolarDB cluster.
        
        @param request: DescribeDBClusterTDERequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterTDEResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterTDE',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterTDEResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_tdewith_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterTDERequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterTDEResponse:
        """
        @summary Queries the transparent data encryption (TDE) settings of a PolarDB cluster.
        
        @param request: DescribeDBClusterTDERequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterTDEResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterTDE',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterTDEResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_tde(
        self,
        request: polardb_20170801_models.DescribeDBClusterTDERequest,
    ) -> polardb_20170801_models.DescribeDBClusterTDEResponse:
        """
        @summary Queries the transparent data encryption (TDE) settings of a PolarDB cluster.
        
        @param request: DescribeDBClusterTDERequest
        @return: DescribeDBClusterTDEResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_tdewith_options(request, runtime)

    async def describe_dbcluster_tde_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterTDERequest,
    ) -> polardb_20170801_models.DescribeDBClusterTDEResponse:
        """
        @summary Queries the transparent data encryption (TDE) settings of a PolarDB cluster.
        
        @param request: DescribeDBClusterTDERequest
        @return: DescribeDBClusterTDEResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_tdewith_options_async(request, runtime)

    def describe_dbcluster_version_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterVersionResponse:
        """
        @summary Queries the information about the database engine version of a PolarDB for MySQL cluster.
        
        @param request: DescribeDBClusterVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterVersion',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_version_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterVersionResponse:
        """
        @summary Queries the information about the database engine version of a PolarDB for MySQL cluster.
        
        @param request: DescribeDBClusterVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterVersion',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_version(
        self,
        request: polardb_20170801_models.DescribeDBClusterVersionRequest,
    ) -> polardb_20170801_models.DescribeDBClusterVersionResponse:
        """
        @summary Queries the information about the database engine version of a PolarDB for MySQL cluster.
        
        @param request: DescribeDBClusterVersionRequest
        @return: DescribeDBClusterVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_version_with_options(request, runtime)

    async def describe_dbcluster_version_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterVersionRequest,
    ) -> polardb_20170801_models.DescribeDBClusterVersionResponse:
        """
        @summary Queries the information about the database engine version of a PolarDB for MySQL cluster.
        
        @param request: DescribeDBClusterVersionRequest
        @return: DescribeDBClusterVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_version_with_options_async(request, runtime)

    def describe_dbcluster_version_zonal_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClusterVersionZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterVersionZonalResponse:
        """
        @summary PolarDB边缘集群查询版本
        
        @param request: DescribeDBClusterVersionZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterVersionZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterVersionZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterVersionZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_version_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterVersionZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClusterVersionZonalResponse:
        """
        @summary PolarDB边缘集群查询版本
        
        @param request: DescribeDBClusterVersionZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterVersionZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterVersionZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClusterVersionZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_version_zonal(
        self,
        request: polardb_20170801_models.DescribeDBClusterVersionZonalRequest,
    ) -> polardb_20170801_models.DescribeDBClusterVersionZonalResponse:
        """
        @summary PolarDB边缘集群查询版本
        
        @param request: DescribeDBClusterVersionZonalRequest
        @return: DescribeDBClusterVersionZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_version_zonal_with_options(request, runtime)

    async def describe_dbcluster_version_zonal_async(
        self,
        request: polardb_20170801_models.DescribeDBClusterVersionZonalRequest,
    ) -> polardb_20170801_models.DescribeDBClusterVersionZonalResponse:
        """
        @summary PolarDB边缘集群查询版本
        
        @param request: DescribeDBClusterVersionZonalRequest
        @return: DescribeDBClusterVersionZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_version_zonal_with_options_async(request, runtime)

    def describe_dbclusters_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClustersResponse:
        """
        @summary Queries PolarDB clusters or the clusters that can be accessed by an authorized RAM user.
        
        @param request: DescribeDBClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string):
            query['ConnectionString'] = request.connection_string
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.dbcluster_status):
            query['DBClusterStatus'] = request.dbcluster_status
        if not UtilClient.is_unset(request.dbnode_ids):
            query['DBNodeIds'] = request.dbnode_ids
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.expired):
            query['Expired'] = request.expired
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.recent_creation_interval):
            query['RecentCreationInterval'] = request.recent_creation_interval
        if not UtilClient.is_unset(request.recent_expiration_interval):
            query['RecentExpirationInterval'] = request.recent_expiration_interval
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClustersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbclusters_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClustersResponse:
        """
        @summary Queries PolarDB clusters or the clusters that can be accessed by an authorized RAM user.
        
        @param request: DescribeDBClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string):
            query['ConnectionString'] = request.connection_string
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.dbcluster_status):
            query['DBClusterStatus'] = request.dbcluster_status
        if not UtilClient.is_unset(request.dbnode_ids):
            query['DBNodeIds'] = request.dbnode_ids
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.expired):
            query['Expired'] = request.expired
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.recent_creation_interval):
            query['RecentCreationInterval'] = request.recent_creation_interval
        if not UtilClient.is_unset(request.recent_expiration_interval):
            query['RecentExpirationInterval'] = request.recent_expiration_interval
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClustersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbclusters(
        self,
        request: polardb_20170801_models.DescribeDBClustersRequest,
    ) -> polardb_20170801_models.DescribeDBClustersResponse:
        """
        @summary Queries PolarDB clusters or the clusters that can be accessed by an authorized RAM user.
        
        @param request: DescribeDBClustersRequest
        @return: DescribeDBClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbclusters_with_options(request, runtime)

    async def describe_dbclusters_async(
        self,
        request: polardb_20170801_models.DescribeDBClustersRequest,
    ) -> polardb_20170801_models.DescribeDBClustersResponse:
        """
        @summary Queries PolarDB clusters or the clusters that can be accessed by an authorized RAM user.
        
        @param request: DescribeDBClustersRequest
        @return: DescribeDBClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbclusters_with_options_async(request, runtime)

    def describe_dbclusters_with_backups_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClustersWithBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClustersWithBackupsResponse:
        """
        @summary Queries the information about PolarDB clusters that contain backup sets in a region.
        
        @param request: DescribeDBClustersWithBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClustersWithBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.is_deleted):
            query['IsDeleted'] = request.is_deleted
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClustersWithBackups',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClustersWithBackupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbclusters_with_backups_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClustersWithBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClustersWithBackupsResponse:
        """
        @summary Queries the information about PolarDB clusters that contain backup sets in a region.
        
        @param request: DescribeDBClustersWithBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClustersWithBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.is_deleted):
            query['IsDeleted'] = request.is_deleted
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClustersWithBackups',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClustersWithBackupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbclusters_with_backups(
        self,
        request: polardb_20170801_models.DescribeDBClustersWithBackupsRequest,
    ) -> polardb_20170801_models.DescribeDBClustersWithBackupsResponse:
        """
        @summary Queries the information about PolarDB clusters that contain backup sets in a region.
        
        @param request: DescribeDBClustersWithBackupsRequest
        @return: DescribeDBClustersWithBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbclusters_with_backups_with_options(request, runtime)

    async def describe_dbclusters_with_backups_async(
        self,
        request: polardb_20170801_models.DescribeDBClustersWithBackupsRequest,
    ) -> polardb_20170801_models.DescribeDBClustersWithBackupsResponse:
        """
        @summary Queries the information about PolarDB clusters that contain backup sets in a region.
        
        @param request: DescribeDBClustersWithBackupsRequest
        @return: DescribeDBClustersWithBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbclusters_with_backups_with_options_async(request, runtime)

    def describe_dbclusters_zonal_with_options(
        self,
        request: polardb_20170801_models.DescribeDBClustersZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClustersZonalResponse:
        """
        @summary MyBase中的PolarDB列表
        
        @param request: DescribeDBClustersZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClustersZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.connection_string):
            query['ConnectionString'] = request.connection_string
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.dbcluster_status):
            query['DBClusterStatus'] = request.dbcluster_status
        if not UtilClient.is_unset(request.dbnode_ids):
            query['DBNodeIds'] = request.dbnode_ids
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.expired):
            query['Expired'] = request.expired
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.recent_creation_interval):
            query['RecentCreationInterval'] = request.recent_creation_interval
        if not UtilClient.is_unset(request.recent_expiration_interval):
            query['RecentExpirationInterval'] = request.recent_expiration_interval
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClustersZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClustersZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbclusters_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBClustersZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBClustersZonalResponse:
        """
        @summary MyBase中的PolarDB列表
        
        @param request: DescribeDBClustersZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClustersZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cloud_provider):
            query['CloudProvider'] = request.cloud_provider
        if not UtilClient.is_unset(request.connection_string):
            query['ConnectionString'] = request.connection_string
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_ids):
            query['DBClusterIds'] = request.dbcluster_ids
        if not UtilClient.is_unset(request.dbcluster_status):
            query['DBClusterStatus'] = request.dbcluster_status
        if not UtilClient.is_unset(request.dbnode_ids):
            query['DBNodeIds'] = request.dbnode_ids
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.expired):
            query['Expired'] = request.expired
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.recent_creation_interval):
            query['RecentCreationInterval'] = request.recent_creation_interval
        if not UtilClient.is_unset(request.recent_expiration_interval):
            query['RecentExpirationInterval'] = request.recent_expiration_interval
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClustersZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBClustersZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbclusters_zonal(
        self,
        request: polardb_20170801_models.DescribeDBClustersZonalRequest,
    ) -> polardb_20170801_models.DescribeDBClustersZonalResponse:
        """
        @summary MyBase中的PolarDB列表
        
        @param request: DescribeDBClustersZonalRequest
        @return: DescribeDBClustersZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbclusters_zonal_with_options(request, runtime)

    async def describe_dbclusters_zonal_async(
        self,
        request: polardb_20170801_models.DescribeDBClustersZonalRequest,
    ) -> polardb_20170801_models.DescribeDBClustersZonalResponse:
        """
        @summary MyBase中的PolarDB列表
        
        @param request: DescribeDBClustersZonalRequest
        @return: DescribeDBClustersZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbclusters_zonal_with_options_async(request, runtime)

    def describe_dbinitialize_variable_with_options(
        self,
        request: polardb_20170801_models.DescribeDBInitializeVariableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBInitializeVariableResponse:
        """
        @summary Queries attributes such as character sets and collations supported by a database in a PolarDB cluster.
        
        @param request: DescribeDBInitializeVariableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInitializeVariableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInitializeVariable',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBInitializeVariableResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinitialize_variable_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBInitializeVariableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBInitializeVariableResponse:
        """
        @summary Queries attributes such as character sets and collations supported by a database in a PolarDB cluster.
        
        @param request: DescribeDBInitializeVariableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInitializeVariableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInitializeVariable',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBInitializeVariableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinitialize_variable(
        self,
        request: polardb_20170801_models.DescribeDBInitializeVariableRequest,
    ) -> polardb_20170801_models.DescribeDBInitializeVariableResponse:
        """
        @summary Queries attributes such as character sets and collations supported by a database in a PolarDB cluster.
        
        @param request: DescribeDBInitializeVariableRequest
        @return: DescribeDBInitializeVariableResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinitialize_variable_with_options(request, runtime)

    async def describe_dbinitialize_variable_async(
        self,
        request: polardb_20170801_models.DescribeDBInitializeVariableRequest,
    ) -> polardb_20170801_models.DescribeDBInitializeVariableResponse:
        """
        @summary Queries attributes such as character sets and collations supported by a database in a PolarDB cluster.
        
        @param request: DescribeDBInitializeVariableRequest
        @return: DescribeDBInitializeVariableResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinitialize_variable_with_options_async(request, runtime)

    def describe_dbinstance_performance_with_options(
        self,
        request: polardb_20170801_models.DescribeDBInstancePerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBInstancePerformanceResponse:
        """
        @param request: DescribeDBInstancePerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstancePerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstancePerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBInstancePerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_performance_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBInstancePerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBInstancePerformanceResponse:
        """
        @param request: DescribeDBInstancePerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstancePerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstancePerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBInstancePerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_performance(
        self,
        request: polardb_20170801_models.DescribeDBInstancePerformanceRequest,
    ) -> polardb_20170801_models.DescribeDBInstancePerformanceResponse:
        """
        @param request: DescribeDBInstancePerformanceRequest
        @return: DescribeDBInstancePerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_performance_with_options(request, runtime)

    async def describe_dbinstance_performance_async(
        self,
        request: polardb_20170801_models.DescribeDBInstancePerformanceRequest,
    ) -> polardb_20170801_models.DescribeDBInstancePerformanceResponse:
        """
        @param request: DescribeDBInstancePerformanceRequest
        @return: DescribeDBInstancePerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_performance_with_options_async(request, runtime)

    def describe_dblinks_with_options(
        self,
        request: polardb_20170801_models.DescribeDBLinksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBLinksResponse:
        """
        @summary Queries the database links of a PolarDB for PostgreSQL (Compatible with Oracle) cluster.
        
        @description > You can query only the database links that use a PolarDB for Oracle cluster as the source.
        
        @param request: DescribeDBLinksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBLinksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dblink_name):
            query['DBLinkName'] = request.dblink_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBLinks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBLinksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dblinks_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBLinksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBLinksResponse:
        """
        @summary Queries the database links of a PolarDB for PostgreSQL (Compatible with Oracle) cluster.
        
        @description > You can query only the database links that use a PolarDB for Oracle cluster as the source.
        
        @param request: DescribeDBLinksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBLinksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dblink_name):
            query['DBLinkName'] = request.dblink_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBLinks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBLinksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dblinks(
        self,
        request: polardb_20170801_models.DescribeDBLinksRequest,
    ) -> polardb_20170801_models.DescribeDBLinksResponse:
        """
        @summary Queries the database links of a PolarDB for PostgreSQL (Compatible with Oracle) cluster.
        
        @description > You can query only the database links that use a PolarDB for Oracle cluster as the source.
        
        @param request: DescribeDBLinksRequest
        @return: DescribeDBLinksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dblinks_with_options(request, runtime)

    async def describe_dblinks_async(
        self,
        request: polardb_20170801_models.DescribeDBLinksRequest,
    ) -> polardb_20170801_models.DescribeDBLinksResponse:
        """
        @summary Queries the database links of a PolarDB for PostgreSQL (Compatible with Oracle) cluster.
        
        @description > You can query only the database links that use a PolarDB for Oracle cluster as the source.
        
        @param request: DescribeDBLinksRequest
        @return: DescribeDBLinksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dblinks_with_options_async(request, runtime)

    def describe_dblog_files_with_options(
        self,
        request: polardb_20170801_models.DescribeDBLogFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBLogFilesResponse:
        """
        @summary 查询实例日志
        
        @param request: DescribeDBLogFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBLogFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.describe_simulate_switch_mode):
            query['DescribeSimulateSwitchMode'] = request.describe_simulate_switch_mode
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.log_type):
            query['LogType'] = request.log_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.simulate_list_id):
            query['SimulateListId'] = request.simulate_list_id
        if not UtilClient.is_unset(request.simulate_mode_list):
            query['SimulateModeList'] = request.simulate_mode_list
        if not UtilClient.is_unset(request.simulate_status_list):
            query['SimulateStatusList'] = request.simulate_status_list
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBLogFiles',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBLogFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dblog_files_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBLogFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBLogFilesResponse:
        """
        @summary 查询实例日志
        
        @param request: DescribeDBLogFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBLogFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.describe_simulate_switch_mode):
            query['DescribeSimulateSwitchMode'] = request.describe_simulate_switch_mode
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.log_type):
            query['LogType'] = request.log_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.simulate_list_id):
            query['SimulateListId'] = request.simulate_list_id
        if not UtilClient.is_unset(request.simulate_mode_list):
            query['SimulateModeList'] = request.simulate_mode_list
        if not UtilClient.is_unset(request.simulate_status_list):
            query['SimulateStatusList'] = request.simulate_status_list
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBLogFiles',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBLogFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dblog_files(
        self,
        request: polardb_20170801_models.DescribeDBLogFilesRequest,
    ) -> polardb_20170801_models.DescribeDBLogFilesResponse:
        """
        @summary 查询实例日志
        
        @param request: DescribeDBLogFilesRequest
        @return: DescribeDBLogFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dblog_files_with_options(request, runtime)

    async def describe_dblog_files_async(
        self,
        request: polardb_20170801_models.DescribeDBLogFilesRequest,
    ) -> polardb_20170801_models.DescribeDBLogFilesResponse:
        """
        @summary 查询实例日志
        
        @param request: DescribeDBLogFilesRequest
        @return: DescribeDBLogFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dblog_files_with_options_async(request, runtime)

    def describe_dbmini_engine_versions_with_options(
        self,
        request: polardb_20170801_models.DescribeDBMiniEngineVersionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBMiniEngineVersionsResponse:
        """
        @summary 查询可用内核小版本列表
        
        @param request: DescribeDBMiniEngineVersionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBMiniEngineVersionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.creation_category):
            query['CreationCategory'] = request.creation_category
        if not UtilClient.is_unset(request.dbminor_version):
            query['DBMinorVersion'] = request.dbminor_version
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBMiniEngineVersions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBMiniEngineVersionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbmini_engine_versions_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBMiniEngineVersionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBMiniEngineVersionsResponse:
        """
        @summary 查询可用内核小版本列表
        
        @param request: DescribeDBMiniEngineVersionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBMiniEngineVersionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.creation_category):
            query['CreationCategory'] = request.creation_category
        if not UtilClient.is_unset(request.dbminor_version):
            query['DBMinorVersion'] = request.dbminor_version
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBMiniEngineVersions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBMiniEngineVersionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbmini_engine_versions(
        self,
        request: polardb_20170801_models.DescribeDBMiniEngineVersionsRequest,
    ) -> polardb_20170801_models.DescribeDBMiniEngineVersionsResponse:
        """
        @summary 查询可用内核小版本列表
        
        @param request: DescribeDBMiniEngineVersionsRequest
        @return: DescribeDBMiniEngineVersionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbmini_engine_versions_with_options(request, runtime)

    async def describe_dbmini_engine_versions_async(
        self,
        request: polardb_20170801_models.DescribeDBMiniEngineVersionsRequest,
    ) -> polardb_20170801_models.DescribeDBMiniEngineVersionsResponse:
        """
        @summary 查询可用内核小版本列表
        
        @param request: DescribeDBMiniEngineVersionsRequest
        @return: DescribeDBMiniEngineVersionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbmini_engine_versions_with_options_async(request, runtime)

    def describe_dbnode_performance_with_options(
        self,
        request: polardb_20170801_models.DescribeDBNodePerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBNodePerformanceResponse:
        """
        @summary Queries the performance data of a node in a PolarDB cluster.
        
        @description    When the monitoring data is collected every 5 seconds:
        If the query time range is less than or equal to 1 hour, the data is displayed at intervals of 5 seconds.
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        When the monitoring data is collected every 60 seconds:
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        >  By default, the monitoring data is collected once every 60 seconds. You can call the [ModifyDBClusterMonitor](https://help.aliyun.com/document_detail/159557.html) operation to set the data collection interval to every 5 seconds.
        
        @param request: DescribeDBNodePerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBNodePerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBNodePerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBNodePerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbnode_performance_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBNodePerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBNodePerformanceResponse:
        """
        @summary Queries the performance data of a node in a PolarDB cluster.
        
        @description    When the monitoring data is collected every 5 seconds:
        If the query time range is less than or equal to 1 hour, the data is displayed at intervals of 5 seconds.
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        When the monitoring data is collected every 60 seconds:
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        >  By default, the monitoring data is collected once every 60 seconds. You can call the [ModifyDBClusterMonitor](https://help.aliyun.com/document_detail/159557.html) operation to set the data collection interval to every 5 seconds.
        
        @param request: DescribeDBNodePerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBNodePerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBNodePerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBNodePerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbnode_performance(
        self,
        request: polardb_20170801_models.DescribeDBNodePerformanceRequest,
    ) -> polardb_20170801_models.DescribeDBNodePerformanceResponse:
        """
        @summary Queries the performance data of a node in a PolarDB cluster.
        
        @description    When the monitoring data is collected every 5 seconds:
        If the query time range is less than or equal to 1 hour, the data is displayed at intervals of 5 seconds.
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        When the monitoring data is collected every 60 seconds:
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        >  By default, the monitoring data is collected once every 60 seconds. You can call the [ModifyDBClusterMonitor](https://help.aliyun.com/document_detail/159557.html) operation to set the data collection interval to every 5 seconds.
        
        @param request: DescribeDBNodePerformanceRequest
        @return: DescribeDBNodePerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbnode_performance_with_options(request, runtime)

    async def describe_dbnode_performance_async(
        self,
        request: polardb_20170801_models.DescribeDBNodePerformanceRequest,
    ) -> polardb_20170801_models.DescribeDBNodePerformanceResponse:
        """
        @summary Queries the performance data of a node in a PolarDB cluster.
        
        @description    When the monitoring data is collected every 5 seconds:
        If the query time range is less than or equal to 1 hour, the data is displayed at intervals of 5 seconds.
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        When the monitoring data is collected every 60 seconds:
        If the query time range is less than or equal to one day, the data is displayed at intervals of 1 minute.
        If the query time range is less than or equal to seven days, the data is displayed at intervals of 10 minutes.
        If the query time range is less than or equal to 30 days, the data is displayed at intervals of 1 hour.
        When the query time range is greater than 30 days, the data is displayed at intervals of 1 day.
        >  By default, the monitoring data is collected once every 60 seconds. You can call the [ModifyDBClusterMonitor](https://help.aliyun.com/document_detail/159557.html) operation to set the data collection interval to every 5 seconds.
        
        @param request: DescribeDBNodePerformanceRequest
        @return: DescribeDBNodePerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbnode_performance_with_options_async(request, runtime)

    def describe_dbnodes_parameters_with_options(
        self,
        request: polardb_20170801_models.DescribeDBNodesParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBNodesParametersResponse:
        """
        @summary Queries the parameters of a specified node in a cluster.
        
        @param request: DescribeDBNodesParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBNodesParametersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_ids):
            query['DBNodeIds'] = request.dbnode_ids
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBNodesParameters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBNodesParametersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbnodes_parameters_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBNodesParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBNodesParametersResponse:
        """
        @summary Queries the parameters of a specified node in a cluster.
        
        @param request: DescribeDBNodesParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBNodesParametersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_ids):
            query['DBNodeIds'] = request.dbnode_ids
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBNodesParameters',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBNodesParametersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbnodes_parameters(
        self,
        request: polardb_20170801_models.DescribeDBNodesParametersRequest,
    ) -> polardb_20170801_models.DescribeDBNodesParametersResponse:
        """
        @summary Queries the parameters of a specified node in a cluster.
        
        @param request: DescribeDBNodesParametersRequest
        @return: DescribeDBNodesParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbnodes_parameters_with_options(request, runtime)

    async def describe_dbnodes_parameters_async(
        self,
        request: polardb_20170801_models.DescribeDBNodesParametersRequest,
    ) -> polardb_20170801_models.DescribeDBNodesParametersResponse:
        """
        @summary Queries the parameters of a specified node in a cluster.
        
        @param request: DescribeDBNodesParametersRequest
        @return: DescribeDBNodesParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbnodes_parameters_with_options_async(request, runtime)

    def describe_dbproxy_performance_with_options(
        self,
        request: polardb_20170801_models.DescribeDBProxyPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBProxyPerformanceResponse:
        """
        @summary Queries the performance data of PolarProxy.
        
        @description > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeDBProxyPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBProxyPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBProxyPerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBProxyPerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbproxy_performance_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDBProxyPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDBProxyPerformanceResponse:
        """
        @summary Queries the performance data of PolarProxy.
        
        @description > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeDBProxyPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBProxyPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbendpoint_id):
            query['DBEndpointId'] = request.dbendpoint_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBProxyPerformance',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDBProxyPerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbproxy_performance(
        self,
        request: polardb_20170801_models.DescribeDBProxyPerformanceRequest,
    ) -> polardb_20170801_models.DescribeDBProxyPerformanceResponse:
        """
        @summary Queries the performance data of PolarProxy.
        
        @description > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeDBProxyPerformanceRequest
        @return: DescribeDBProxyPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbproxy_performance_with_options(request, runtime)

    async def describe_dbproxy_performance_async(
        self,
        request: polardb_20170801_models.DescribeDBProxyPerformanceRequest,
    ) -> polardb_20170801_models.DescribeDBProxyPerformanceResponse:
        """
        @summary Queries the performance data of PolarProxy.
        
        @description > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeDBProxyPerformanceRequest
        @return: DescribeDBProxyPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbproxy_performance_with_options_async(request, runtime)

    def describe_das_config_with_options(
        self,
        request: polardb_20170801_models.DescribeDasConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDasConfigResponse:
        """
        @summary Queries the configurations of a cluster in Database Autonomy Service (DAS).
        
        @param request: DescribeDasConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDasConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDasConfig',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDasConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_das_config_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDasConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDasConfigResponse:
        """
        @summary Queries the configurations of a cluster in Database Autonomy Service (DAS).
        
        @param request: DescribeDasConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDasConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDasConfig',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDasConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_das_config(
        self,
        request: polardb_20170801_models.DescribeDasConfigRequest,
    ) -> polardb_20170801_models.DescribeDasConfigResponse:
        """
        @summary Queries the configurations of a cluster in Database Autonomy Service (DAS).
        
        @param request: DescribeDasConfigRequest
        @return: DescribeDasConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_das_config_with_options(request, runtime)

    async def describe_das_config_async(
        self,
        request: polardb_20170801_models.DescribeDasConfigRequest,
    ) -> polardb_20170801_models.DescribeDasConfigResponse:
        """
        @summary Queries the configurations of a cluster in Database Autonomy Service (DAS).
        
        @param request: DescribeDasConfigRequest
        @return: DescribeDasConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_das_config_with_options_async(request, runtime)

    def describe_databases_with_options(
        self,
        request: polardb_20170801_models.DescribeDatabasesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDatabasesResponse:
        """
        @summary Queries the information about databases in a PolarDB cluster.
        
        @param request: DescribeDatabasesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDatabasesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDatabases',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDatabasesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_databases_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDatabasesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDatabasesResponse:
        """
        @summary Queries the information about databases in a PolarDB cluster.
        
        @param request: DescribeDatabasesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDatabasesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDatabases',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDatabasesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_databases(
        self,
        request: polardb_20170801_models.DescribeDatabasesRequest,
    ) -> polardb_20170801_models.DescribeDatabasesResponse:
        """
        @summary Queries the information about databases in a PolarDB cluster.
        
        @param request: DescribeDatabasesRequest
        @return: DescribeDatabasesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_databases_with_options(request, runtime)

    async def describe_databases_async(
        self,
        request: polardb_20170801_models.DescribeDatabasesRequest,
    ) -> polardb_20170801_models.DescribeDatabasesResponse:
        """
        @summary Queries the information about databases in a PolarDB cluster.
        
        @param request: DescribeDatabasesRequest
        @return: DescribeDatabasesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_databases_with_options_async(request, runtime)

    def describe_databases_zonal_with_options(
        self,
        request: polardb_20170801_models.DescribeDatabasesZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDatabasesZonalResponse:
        """
        @summary 查询PolarDB边缘云数据库
        
        @param request: DescribeDatabasesZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDatabasesZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDatabasesZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDatabasesZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_databases_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDatabasesZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDatabasesZonalResponse:
        """
        @summary 查询PolarDB边缘云数据库
        
        @param request: DescribeDatabasesZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDatabasesZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDatabasesZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDatabasesZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_databases_zonal(
        self,
        request: polardb_20170801_models.DescribeDatabasesZonalRequest,
    ) -> polardb_20170801_models.DescribeDatabasesZonalResponse:
        """
        @summary 查询PolarDB边缘云数据库
        
        @param request: DescribeDatabasesZonalRequest
        @return: DescribeDatabasesZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_databases_zonal_with_options(request, runtime)

    async def describe_databases_zonal_async(
        self,
        request: polardb_20170801_models.DescribeDatabasesZonalRequest,
    ) -> polardb_20170801_models.DescribeDatabasesZonalResponse:
        """
        @summary 查询PolarDB边缘云数据库
        
        @param request: DescribeDatabasesZonalRequest
        @return: DescribeDatabasesZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_databases_zonal_with_options_async(request, runtime)

    def describe_db_cluster_attribute_zonal_with_options(
        self,
        request: polardb_20170801_models.DescribeDbClusterAttributeZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDbClusterAttributeZonalResponse:
        """
        @summary PolarDB的MyBase集群
        
        @param request: DescribeDbClusterAttributeZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDbClusterAttributeZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDbClusterAttributeZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDbClusterAttributeZonalResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_db_cluster_attribute_zonal_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDbClusterAttributeZonalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDbClusterAttributeZonalResponse:
        """
        @summary PolarDB的MyBase集群
        
        @param request: DescribeDbClusterAttributeZonalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDbClusterAttributeZonalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.describe_type):
            query['DescribeType'] = request.describe_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDbClusterAttributeZonal',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDbClusterAttributeZonalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_db_cluster_attribute_zonal(
        self,
        request: polardb_20170801_models.DescribeDbClusterAttributeZonalRequest,
    ) -> polardb_20170801_models.DescribeDbClusterAttributeZonalResponse:
        """
        @summary PolarDB的MyBase集群
        
        @param request: DescribeDbClusterAttributeZonalRequest
        @return: DescribeDbClusterAttributeZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_db_cluster_attribute_zonal_with_options(request, runtime)

    async def describe_db_cluster_attribute_zonal_async(
        self,
        request: polardb_20170801_models.DescribeDbClusterAttributeZonalRequest,
    ) -> polardb_20170801_models.DescribeDbClusterAttributeZonalResponse:
        """
        @summary PolarDB的MyBase集群
        
        @param request: DescribeDbClusterAttributeZonalRequest
        @return: DescribeDbClusterAttributeZonalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_db_cluster_attribute_zonal_with_options_async(request, runtime)

    def describe_detached_backups_with_options(
        self,
        request: polardb_20170801_models.DescribeDetachedBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDetachedBackupsResponse:
        """
        @summary Queries the information about the backup sets in a released PolarDB cluster.
        
        @description Before you call this operation, make sure that the PolarDB cluster is in the *Released** state. You must also confirm that the **Retain All Backups Permanently** or **Retain Last Automatic Backup Permanently** backup retention policy takes effect after you release the cluster. If you delete all backup sets after the cluster is released, you cannot use this API operation to query the cluster.
        >  You can call the [DescribeDBClusterAttribute](https://help.aliyun.com/document_detail/98181.html) operation to query the cluster status.
        
        @param request: DescribeDetachedBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDetachedBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.backup_region):
            query['BackupRegion'] = request.backup_region
        if not UtilClient.is_unset(request.backup_status):
            query['BackupStatus'] = request.backup_status
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDetachedBackups',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDetachedBackupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_detached_backups_with_options_async(
        self,
        request: polardb_20170801_models.DescribeDetachedBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeDetachedBackupsResponse:
        """
        @summary Queries the information about the backup sets in a released PolarDB cluster.
        
        @description Before you call this operation, make sure that the PolarDB cluster is in the *Released** state. You must also confirm that the **Retain All Backups Permanently** or **Retain Last Automatic Backup Permanently** backup retention policy takes effect after you release the cluster. If you delete all backup sets after the cluster is released, you cannot use this API operation to query the cluster.
        >  You can call the [DescribeDBClusterAttribute](https://help.aliyun.com/document_detail/98181.html) operation to query the cluster status.
        
        @param request: DescribeDetachedBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDetachedBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.backup_region):
            query['BackupRegion'] = request.backup_region
        if not UtilClient.is_unset(request.backup_status):
            query['BackupStatus'] = request.backup_status
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDetachedBackups',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeDetachedBackupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_detached_backups(
        self,
        request: polardb_20170801_models.DescribeDetachedBackupsRequest,
    ) -> polardb_20170801_models.DescribeDetachedBackupsResponse:
        """
        @summary Queries the information about the backup sets in a released PolarDB cluster.
        
        @description Before you call this operation, make sure that the PolarDB cluster is in the *Released** state. You must also confirm that the **Retain All Backups Permanently** or **Retain Last Automatic Backup Permanently** backup retention policy takes effect after you release the cluster. If you delete all backup sets after the cluster is released, you cannot use this API operation to query the cluster.
        >  You can call the [DescribeDBClusterAttribute](https://help.aliyun.com/document_detail/98181.html) operation to query the cluster status.
        
        @param request: DescribeDetachedBackupsRequest
        @return: DescribeDetachedBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_detached_backups_with_options(request, runtime)

    async def describe_detached_backups_async(
        self,
        request: polardb_20170801_models.DescribeDetachedBackupsRequest,
    ) -> polardb_20170801_models.DescribeDetachedBackupsResponse:
        """
        @summary Queries the information about the backup sets in a released PolarDB cluster.
        
        @description Before you call this operation, make sure that the PolarDB cluster is in the *Released** state. You must also confirm that the **Retain All Backups Permanently** or **Retain Last Automatic Backup Permanently** backup retention policy takes effect after you release the cluster. If you delete all backup sets after the cluster is released, you cannot use this API operation to query the cluster.
        >  You can call the [DescribeDBClusterAttribute](https://help.aliyun.com/document_detail/98181.html) operation to query the cluster status.
        
        @param request: DescribeDetachedBackupsRequest
        @return: DescribeDetachedBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_detached_backups_with_options_async(request, runtime)

    def describe_encryption_dbrole_privilege_with_options(
        self,
        request: polardb_20170801_models.DescribeEncryptionDBRolePrivilegeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeEncryptionDBRolePrivilegeResponse:
        """
        @summary 获取角色权限列表
        
        @param request: DescribeEncryptionDBRolePrivilegeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEncryptionDBRolePrivilegeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role_privilege_name_list):
            query['RolePrivilegeNameList'] = request.role_privilege_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEncryptionDBRolePrivilege',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeEncryptionDBRolePrivilegeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_encryption_dbrole_privilege_with_options_async(
        self,
        request: polardb_20170801_models.DescribeEncryptionDBRolePrivilegeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeEncryptionDBRolePrivilegeResponse:
        """
        @summary 获取角色权限列表
        
        @param request: DescribeEncryptionDBRolePrivilegeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEncryptionDBRolePrivilegeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role_privilege_name_list):
            query['RolePrivilegeNameList'] = request.role_privilege_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEncryptionDBRolePrivilege',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeEncryptionDBRolePrivilegeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_encryption_dbrole_privilege(
        self,
        request: polardb_20170801_models.DescribeEncryptionDBRolePrivilegeRequest,
    ) -> polardb_20170801_models.DescribeEncryptionDBRolePrivilegeResponse:
        """
        @summary 获取角色权限列表
        
        @param request: DescribeEncryptionDBRolePrivilegeRequest
        @return: DescribeEncryptionDBRolePrivilegeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_encryption_dbrole_privilege_with_options(request, runtime)

    async def describe_encryption_dbrole_privilege_async(
        self,
        request: polardb_20170801_models.DescribeEncryptionDBRolePrivilegeRequest,
    ) -> polardb_20170801_models.DescribeEncryptionDBRolePrivilegeResponse:
        """
        @summary 获取角色权限列表
        
        @param request: DescribeEncryptionDBRolePrivilegeRequest
        @return: DescribeEncryptionDBRolePrivilegeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_encryption_dbrole_privilege_with_options_async(request, runtime)

    def describe_encryption_dbsecret_with_options(
        self,
        request: polardb_20170801_models.DescribeEncryptionDBSecretRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeEncryptionDBSecretResponse:
        """
        @summary 获取加密信息
        
        @param request: DescribeEncryptionDBSecretRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEncryptionDBSecretResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEncryptionDBSecret',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeEncryptionDBSecretResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_encryption_dbsecret_with_options_async(
        self,
        request: polardb_20170801_models.DescribeEncryptionDBSecretRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeEncryptionDBSecretResponse:
        """
        @summary 获取加密信息
        
        @param request: DescribeEncryptionDBSecretRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEncryptionDBSecretResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEncryptionDBSecret',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeEncryptionDBSecretResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_encryption_dbsecret(
        self,
        request: polardb_20170801_models.DescribeEncryptionDBSecretRequest,
    ) -> polardb_20170801_models.DescribeEncryptionDBSecretResponse:
        """
        @summary 获取加密信息
        
        @param request: DescribeEncryptionDBSecretRequest
        @return: DescribeEncryptionDBSecretResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_encryption_dbsecret_with_options(request, runtime)

    async def describe_encryption_dbsecret_async(
        self,
        request: polardb_20170801_models.DescribeEncryptionDBSecretRequest,
    ) -> polardb_20170801_models.DescribeEncryptionDBSecretResponse:
        """
        @summary 获取加密信息
        
        @param request: DescribeEncryptionDBSecretRequest
        @return: DescribeEncryptionDBSecretResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_encryption_dbsecret_with_options_async(request, runtime)

    def describe_extensions_with_options(
        self,
        request: polardb_20170801_models.DescribeExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeExtensionsResponse:
        """
        @summary 查询插件详情
        
        @param request: DescribeExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExtensions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeExtensionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_extensions_with_options_async(
        self,
        request: polardb_20170801_models.DescribeExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeExtensionsResponse:
        """
        @summary 查询插件详情
        
        @param request: DescribeExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExtensions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeExtensionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_extensions(
        self,
        request: polardb_20170801_models.DescribeExtensionsRequest,
    ) -> polardb_20170801_models.DescribeExtensionsResponse:
        """
        @summary 查询插件详情
        
        @param request: DescribeExtensionsRequest
        @return: DescribeExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_extensions_with_options(request, runtime)

    async def describe_extensions_async(
        self,
        request: polardb_20170801_models.DescribeExtensionsRequest,
    ) -> polardb_20170801_models.DescribeExtensionsResponse:
        """
        @summary 查询插件详情
        
        @param request: DescribeExtensionsRequest
        @return: DescribeExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_extensions_with_options_async(request, runtime)

    def describe_firewall_rules_with_options(
        self,
        request: polardb_20170801_models.DescribeFirewallRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeFirewallRulesResponse:
        """
        @summary 查询sql防火墙信息
        
        @param request: DescribeFirewallRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFirewallRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeFirewallRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_firewall_rules_with_options_async(
        self,
        request: polardb_20170801_models.DescribeFirewallRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeFirewallRulesResponse:
        """
        @summary 查询sql防火墙信息
        
        @param request: DescribeFirewallRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFirewallRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeFirewallRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_firewall_rules(
        self,
        request: polardb_20170801_models.DescribeFirewallRulesRequest,
    ) -> polardb_20170801_models.DescribeFirewallRulesResponse:
        """
        @summary 查询sql防火墙信息
        
        @param request: DescribeFirewallRulesRequest
        @return: DescribeFirewallRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_firewall_rules_with_options(request, runtime)

    async def describe_firewall_rules_async(
        self,
        request: polardb_20170801_models.DescribeFirewallRulesRequest,
    ) -> polardb_20170801_models.DescribeFirewallRulesResponse:
        """
        @summary 查询sql防火墙信息
        
        @param request: DescribeFirewallRulesRequest
        @return: DescribeFirewallRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_firewall_rules_with_options_async(request, runtime)

    def describe_global_data_network_list_with_options(
        self,
        request: polardb_20170801_models.DescribeGlobalDataNetworkListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalDataNetworkListResponse:
        """
        @summary DescribeGlobalDataNetworkList
        
        @param request: DescribeGlobalDataNetworkListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalDataNetworkListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalDataNetworkList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalDataNetworkListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_global_data_network_list_with_options_async(
        self,
        request: polardb_20170801_models.DescribeGlobalDataNetworkListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalDataNetworkListResponse:
        """
        @summary DescribeGlobalDataNetworkList
        
        @param request: DescribeGlobalDataNetworkListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalDataNetworkListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalDataNetworkList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalDataNetworkListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_global_data_network_list(
        self,
        request: polardb_20170801_models.DescribeGlobalDataNetworkListRequest,
    ) -> polardb_20170801_models.DescribeGlobalDataNetworkListResponse:
        """
        @summary DescribeGlobalDataNetworkList
        
        @param request: DescribeGlobalDataNetworkListRequest
        @return: DescribeGlobalDataNetworkListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_global_data_network_list_with_options(request, runtime)

    async def describe_global_data_network_list_async(
        self,
        request: polardb_20170801_models.DescribeGlobalDataNetworkListRequest,
    ) -> polardb_20170801_models.DescribeGlobalDataNetworkListResponse:
        """
        @summary DescribeGlobalDataNetworkList
        
        @param request: DescribeGlobalDataNetworkListRequest
        @return: DescribeGlobalDataNetworkListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_global_data_network_list_with_options_async(request, runtime)

    def describe_global_database_network_with_options(
        self,
        request: polardb_20170801_models.DescribeGlobalDatabaseNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalDatabaseNetworkResponse:
        """
        @summary Queries the information about a Global Database Network (GDN).
        
        @param request: DescribeGlobalDatabaseNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalDatabaseNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gdnid):
            query['GDNId'] = request.gdnid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalDatabaseNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalDatabaseNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_global_database_network_with_options_async(
        self,
        request: polardb_20170801_models.DescribeGlobalDatabaseNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalDatabaseNetworkResponse:
        """
        @summary Queries the information about a Global Database Network (GDN).
        
        @param request: DescribeGlobalDatabaseNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalDatabaseNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gdnid):
            query['GDNId'] = request.gdnid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalDatabaseNetwork',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalDatabaseNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_global_database_network(
        self,
        request: polardb_20170801_models.DescribeGlobalDatabaseNetworkRequest,
    ) -> polardb_20170801_models.DescribeGlobalDatabaseNetworkResponse:
        """
        @summary Queries the information about a Global Database Network (GDN).
        
        @param request: DescribeGlobalDatabaseNetworkRequest
        @return: DescribeGlobalDatabaseNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_global_database_network_with_options(request, runtime)

    async def describe_global_database_network_async(
        self,
        request: polardb_20170801_models.DescribeGlobalDatabaseNetworkRequest,
    ) -> polardb_20170801_models.DescribeGlobalDatabaseNetworkResponse:
        """
        @summary Queries the information about a Global Database Network (GDN).
        
        @param request: DescribeGlobalDatabaseNetworkRequest
        @return: DescribeGlobalDatabaseNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_global_database_network_with_options_async(request, runtime)

    def describe_global_database_networks_with_options(
        self,
        request: polardb_20170801_models.DescribeGlobalDatabaseNetworksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalDatabaseNetworksResponse:
        """
        @summary Queries the information about all Global Database Networks (GDNs) that belong to an account.
        
        @param request: DescribeGlobalDatabaseNetworksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalDatabaseNetworksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.filter_region):
            query['FilterRegion'] = request.filter_region
        if not UtilClient.is_unset(request.gdndescription):
            query['GDNDescription'] = request.gdndescription
        if not UtilClient.is_unset(request.gdnid):
            query['GDNId'] = request.gdnid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalDatabaseNetworks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalDatabaseNetworksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_global_database_networks_with_options_async(
        self,
        request: polardb_20170801_models.DescribeGlobalDatabaseNetworksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalDatabaseNetworksResponse:
        """
        @summary Queries the information about all Global Database Networks (GDNs) that belong to an account.
        
        @param request: DescribeGlobalDatabaseNetworksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalDatabaseNetworksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.filter_region):
            query['FilterRegion'] = request.filter_region
        if not UtilClient.is_unset(request.gdndescription):
            query['GDNDescription'] = request.gdndescription
        if not UtilClient.is_unset(request.gdnid):
            query['GDNId'] = request.gdnid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalDatabaseNetworks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalDatabaseNetworksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_global_database_networks(
        self,
        request: polardb_20170801_models.DescribeGlobalDatabaseNetworksRequest,
    ) -> polardb_20170801_models.DescribeGlobalDatabaseNetworksResponse:
        """
        @summary Queries the information about all Global Database Networks (GDNs) that belong to an account.
        
        @param request: DescribeGlobalDatabaseNetworksRequest
        @return: DescribeGlobalDatabaseNetworksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_global_database_networks_with_options(request, runtime)

    async def describe_global_database_networks_async(
        self,
        request: polardb_20170801_models.DescribeGlobalDatabaseNetworksRequest,
    ) -> polardb_20170801_models.DescribeGlobalDatabaseNetworksResponse:
        """
        @summary Queries the information about all Global Database Networks (GDNs) that belong to an account.
        
        @param request: DescribeGlobalDatabaseNetworksRequest
        @return: DescribeGlobalDatabaseNetworksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_global_database_networks_with_options_async(request, runtime)

    def describe_global_security_ipgroup_with_options(
        self,
        request: polardb_20170801_models.DescribeGlobalSecurityIPGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalSecurityIPGroupResponse:
        """
        @summary Queries global IP whitelist templates.
        
        @param request: DescribeGlobalSecurityIPGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalSecurityIPGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_security_group_id):
            query['GlobalSecurityGroupId'] = request.global_security_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalSecurityIPGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalSecurityIPGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_global_security_ipgroup_with_options_async(
        self,
        request: polardb_20170801_models.DescribeGlobalSecurityIPGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalSecurityIPGroupResponse:
        """
        @summary Queries global IP whitelist templates.
        
        @param request: DescribeGlobalSecurityIPGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalSecurityIPGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_security_group_id):
            query['GlobalSecurityGroupId'] = request.global_security_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalSecurityIPGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalSecurityIPGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_global_security_ipgroup(
        self,
        request: polardb_20170801_models.DescribeGlobalSecurityIPGroupRequest,
    ) -> polardb_20170801_models.DescribeGlobalSecurityIPGroupResponse:
        """
        @summary Queries global IP whitelist templates.
        
        @param request: DescribeGlobalSecurityIPGroupRequest
        @return: DescribeGlobalSecurityIPGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_global_security_ipgroup_with_options(request, runtime)

    async def describe_global_security_ipgroup_async(
        self,
        request: polardb_20170801_models.DescribeGlobalSecurityIPGroupRequest,
    ) -> polardb_20170801_models.DescribeGlobalSecurityIPGroupResponse:
        """
        @summary Queries global IP whitelist templates.
        
        @param request: DescribeGlobalSecurityIPGroupRequest
        @return: DescribeGlobalSecurityIPGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_global_security_ipgroup_with_options_async(request, runtime)

    def describe_global_security_ipgroup_relation_with_options(
        self,
        request: polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationResponse:
        """
        @summary Queries the relationship between a cluster and a global IP whitelist template.
        
        @param request: DescribeGlobalSecurityIPGroupRelationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalSecurityIPGroupRelationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalSecurityIPGroupRelation',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_global_security_ipgroup_relation_with_options_async(
        self,
        request: polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationResponse:
        """
        @summary Queries the relationship between a cluster and a global IP whitelist template.
        
        @param request: DescribeGlobalSecurityIPGroupRelationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeGlobalSecurityIPGroupRelationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalSecurityIPGroupRelation',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_global_security_ipgroup_relation(
        self,
        request: polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationRequest,
    ) -> polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationResponse:
        """
        @summary Queries the relationship between a cluster and a global IP whitelist template.
        
        @param request: DescribeGlobalSecurityIPGroupRelationRequest
        @return: DescribeGlobalSecurityIPGroupRelationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_global_security_ipgroup_relation_with_options(request, runtime)

    async def describe_global_security_ipgroup_relation_async(
        self,
        request: polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationRequest,
    ) -> polardb_20170801_models.DescribeGlobalSecurityIPGroupRelationResponse:
        """
        @summary Queries the relationship between a cluster and a global IP whitelist template.
        
        @param request: DescribeGlobalSecurityIPGroupRelationRequest
        @return: DescribeGlobalSecurityIPGroupRelationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_global_security_ipgroup_relation_with_options_async(request, runtime)

    def describe_halogs_with_options(
        self,
        request: polardb_20170801_models.DescribeHALogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeHALogsResponse:
        """
        @summary 查询实例高可用相关日志
        
        @param request: DescribeHALogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHALogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.log_type):
            query['LogType'] = request.log_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHALogs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeHALogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_halogs_with_options_async(
        self,
        request: polardb_20170801_models.DescribeHALogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeHALogsResponse:
        """
        @summary 查询实例高可用相关日志
        
        @param request: DescribeHALogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHALogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.log_type):
            query['LogType'] = request.log_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHALogs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeHALogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_halogs(
        self,
        request: polardb_20170801_models.DescribeHALogsRequest,
    ) -> polardb_20170801_models.DescribeHALogsResponse:
        """
        @summary 查询实例高可用相关日志
        
        @param request: DescribeHALogsRequest
        @return: DescribeHALogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_halogs_with_options(request, runtime)

    async def describe_halogs_async(
        self,
        request: polardb_20170801_models.DescribeHALogsRequest,
    ) -> polardb_20170801_models.DescribeHALogsResponse:
        """
        @summary 查询实例高可用相关日志
        
        @param request: DescribeHALogsRequest
        @return: DescribeHALogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_halogs_with_options_async(request, runtime)

    def describe_history_tasks_with_options(
        self,
        request: polardb_20170801_models.DescribeHistoryTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeHistoryTasksResponse:
        """
        @summary 任务中心任务列表
        
        @param request: DescribeHistoryTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHistoryTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_exec_time):
            query['FromExecTime'] = request.from_exec_time
        if not UtilClient.is_unset(request.from_start_time):
            query['FromStartTime'] = request.from_start_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        if not UtilClient.is_unset(request.to_exec_time):
            query['ToExecTime'] = request.to_exec_time
        if not UtilClient.is_unset(request.to_start_time):
            query['ToStartTime'] = request.to_start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHistoryTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeHistoryTasksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_history_tasks_with_options_async(
        self,
        request: polardb_20170801_models.DescribeHistoryTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeHistoryTasksResponse:
        """
        @summary 任务中心任务列表
        
        @param request: DescribeHistoryTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHistoryTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_exec_time):
            query['FromExecTime'] = request.from_exec_time
        if not UtilClient.is_unset(request.from_start_time):
            query['FromStartTime'] = request.from_start_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        if not UtilClient.is_unset(request.to_exec_time):
            query['ToExecTime'] = request.to_exec_time
        if not UtilClient.is_unset(request.to_start_time):
            query['ToStartTime'] = request.to_start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHistoryTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeHistoryTasksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_history_tasks(
        self,
        request: polardb_20170801_models.DescribeHistoryTasksRequest,
    ) -> polardb_20170801_models.DescribeHistoryTasksResponse:
        """
        @summary 任务中心任务列表
        
        @param request: DescribeHistoryTasksRequest
        @return: DescribeHistoryTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_history_tasks_with_options(request, runtime)

    async def describe_history_tasks_async(
        self,
        request: polardb_20170801_models.DescribeHistoryTasksRequest,
    ) -> polardb_20170801_models.DescribeHistoryTasksResponse:
        """
        @summary 任务中心任务列表
        
        @param request: DescribeHistoryTasksRequest
        @return: DescribeHistoryTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_history_tasks_with_options_async(request, runtime)

    def describe_history_tasks_stat_with_options(
        self,
        request: polardb_20170801_models.DescribeHistoryTasksStatRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeHistoryTasksStatResponse:
        """
        @summary 任务中心任务统计
        
        @param request: DescribeHistoryTasksStatRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHistoryTasksStatResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_exec_time):
            query['FromExecTime'] = request.from_exec_time
        if not UtilClient.is_unset(request.from_start_time):
            query['FromStartTime'] = request.from_start_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        if not UtilClient.is_unset(request.to_exec_time):
            query['ToExecTime'] = request.to_exec_time
        if not UtilClient.is_unset(request.to_start_time):
            query['ToStartTime'] = request.to_start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHistoryTasksStat',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeHistoryTasksStatResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_history_tasks_stat_with_options_async(
        self,
        request: polardb_20170801_models.DescribeHistoryTasksStatRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeHistoryTasksStatResponse:
        """
        @summary 任务中心任务统计
        
        @param request: DescribeHistoryTasksStatRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHistoryTasksStatResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_exec_time):
            query['FromExecTime'] = request.from_exec_time
        if not UtilClient.is_unset(request.from_start_time):
            query['FromStartTime'] = request.from_start_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        if not UtilClient.is_unset(request.to_exec_time):
            query['ToExecTime'] = request.to_exec_time
        if not UtilClient.is_unset(request.to_start_time):
            query['ToStartTime'] = request.to_start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHistoryTasksStat',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeHistoryTasksStatResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_history_tasks_stat(
        self,
        request: polardb_20170801_models.DescribeHistoryTasksStatRequest,
    ) -> polardb_20170801_models.DescribeHistoryTasksStatResponse:
        """
        @summary 任务中心任务统计
        
        @param request: DescribeHistoryTasksStatRequest
        @return: DescribeHistoryTasksStatResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_history_tasks_stat_with_options(request, runtime)

    async def describe_history_tasks_stat_async(
        self,
        request: polardb_20170801_models.DescribeHistoryTasksStatRequest,
    ) -> polardb_20170801_models.DescribeHistoryTasksStatResponse:
        """
        @summary 任务中心任务统计
        
        @param request: DescribeHistoryTasksStatRequest
        @return: DescribeHistoryTasksStatResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_history_tasks_stat_with_options_async(request, runtime)

    def describe_license_order_details_with_options(
        self,
        request: polardb_20170801_models.DescribeLicenseOrderDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeLicenseOrderDetailsResponse:
        """
        @summary Queries the information of a license order.
        
        @param request: DescribeLicenseOrderDetailsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLicenseOrderDetailsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLicenseOrderDetails',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeLicenseOrderDetailsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_license_order_details_with_options_async(
        self,
        request: polardb_20170801_models.DescribeLicenseOrderDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeLicenseOrderDetailsResponse:
        """
        @summary Queries the information of a license order.
        
        @param request: DescribeLicenseOrderDetailsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLicenseOrderDetailsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLicenseOrderDetails',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeLicenseOrderDetailsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_license_order_details(
        self,
        request: polardb_20170801_models.DescribeLicenseOrderDetailsRequest,
    ) -> polardb_20170801_models.DescribeLicenseOrderDetailsResponse:
        """
        @summary Queries the information of a license order.
        
        @param request: DescribeLicenseOrderDetailsRequest
        @return: DescribeLicenseOrderDetailsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_license_order_details_with_options(request, runtime)

    async def describe_license_order_details_async(
        self,
        request: polardb_20170801_models.DescribeLicenseOrderDetailsRequest,
    ) -> polardb_20170801_models.DescribeLicenseOrderDetailsResponse:
        """
        @summary Queries the information of a license order.
        
        @param request: DescribeLicenseOrderDetailsRequest
        @return: DescribeLicenseOrderDetailsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_license_order_details_with_options_async(request, runtime)

    def describe_license_orders_with_options(
        self,
        request: polardb_20170801_models.DescribeLicenseOrdersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeLicenseOrdersResponse:
        """
        @summary Queries a list of license orders.
        
        @param request: DescribeLicenseOrdersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLicenseOrdersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.package_type):
            query['PackageType'] = request.package_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.purchase_channel):
            query['PurchaseChannel'] = request.purchase_channel
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.virtual_order):
            query['VirtualOrder'] = request.virtual_order
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLicenseOrders',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeLicenseOrdersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_license_orders_with_options_async(
        self,
        request: polardb_20170801_models.DescribeLicenseOrdersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeLicenseOrdersResponse:
        """
        @summary Queries a list of license orders.
        
        @param request: DescribeLicenseOrdersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLicenseOrdersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_order_id):
            query['AliyunOrderId'] = request.aliyun_order_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.package_type):
            query['PackageType'] = request.package_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.purchase_channel):
            query['PurchaseChannel'] = request.purchase_channel
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.virtual_order):
            query['VirtualOrder'] = request.virtual_order
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLicenseOrders',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeLicenseOrdersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_license_orders(
        self,
        request: polardb_20170801_models.DescribeLicenseOrdersRequest,
    ) -> polardb_20170801_models.DescribeLicenseOrdersResponse:
        """
        @summary Queries a list of license orders.
        
        @param request: DescribeLicenseOrdersRequest
        @return: DescribeLicenseOrdersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_license_orders_with_options(request, runtime)

    async def describe_license_orders_async(
        self,
        request: polardb_20170801_models.DescribeLicenseOrdersRequest,
    ) -> polardb_20170801_models.DescribeLicenseOrdersResponse:
        """
        @summary Queries a list of license orders.
        
        @param request: DescribeLicenseOrdersRequest
        @return: DescribeLicenseOrdersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_license_orders_with_options_async(request, runtime)

    def describe_local_available_recovery_time_with_options(
        self,
        request: polardb_20170801_models.DescribeLocalAvailableRecoveryTimeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeLocalAvailableRecoveryTimeResponse:
        """
        @summary 查询库表恢复可恢复时间范围
        
        @param request: DescribeLocalAvailableRecoveryTimeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLocalAvailableRecoveryTimeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLocalAvailableRecoveryTime',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeLocalAvailableRecoveryTimeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_local_available_recovery_time_with_options_async(
        self,
        request: polardb_20170801_models.DescribeLocalAvailableRecoveryTimeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeLocalAvailableRecoveryTimeResponse:
        """
        @summary 查询库表恢复可恢复时间范围
        
        @param request: DescribeLocalAvailableRecoveryTimeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLocalAvailableRecoveryTimeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLocalAvailableRecoveryTime',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeLocalAvailableRecoveryTimeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_local_available_recovery_time(
        self,
        request: polardb_20170801_models.DescribeLocalAvailableRecoveryTimeRequest,
    ) -> polardb_20170801_models.DescribeLocalAvailableRecoveryTimeResponse:
        """
        @summary 查询库表恢复可恢复时间范围
        
        @param request: DescribeLocalAvailableRecoveryTimeRequest
        @return: DescribeLocalAvailableRecoveryTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_local_available_recovery_time_with_options(request, runtime)

    async def describe_local_available_recovery_time_async(
        self,
        request: polardb_20170801_models.DescribeLocalAvailableRecoveryTimeRequest,
    ) -> polardb_20170801_models.DescribeLocalAvailableRecoveryTimeResponse:
        """
        @summary 查询库表恢复可恢复时间范围
        
        @param request: DescribeLocalAvailableRecoveryTimeRequest
        @return: DescribeLocalAvailableRecoveryTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_local_available_recovery_time_with_options_async(request, runtime)

    def describe_log_backup_policy_with_options(
        self,
        request: polardb_20170801_models.DescribeLogBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeLogBackupPolicyResponse:
        """
        @summary Queries the retention policy of log backups in a PolarDB cluster.
        
        @param request: DescribeLogBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLogBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogBackupPolicy',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeLogBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_log_backup_policy_with_options_async(
        self,
        request: polardb_20170801_models.DescribeLogBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeLogBackupPolicyResponse:
        """
        @summary Queries the retention policy of log backups in a PolarDB cluster.
        
        @param request: DescribeLogBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLogBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogBackupPolicy',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeLogBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_log_backup_policy(
        self,
        request: polardb_20170801_models.DescribeLogBackupPolicyRequest,
    ) -> polardb_20170801_models.DescribeLogBackupPolicyResponse:
        """
        @summary Queries the retention policy of log backups in a PolarDB cluster.
        
        @param request: DescribeLogBackupPolicyRequest
        @return: DescribeLogBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_log_backup_policy_with_options(request, runtime)

    async def describe_log_backup_policy_async(
        self,
        request: polardb_20170801_models.DescribeLogBackupPolicyRequest,
    ) -> polardb_20170801_models.DescribeLogBackupPolicyResponse:
        """
        @summary Queries the retention policy of log backups in a PolarDB cluster.
        
        @param request: DescribeLogBackupPolicyRequest
        @return: DescribeLogBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_log_backup_policy_with_options_async(request, runtime)

    def describe_masking_rules_with_options(
        self,
        request: polardb_20170801_models.DescribeMaskingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeMaskingRulesResponse:
        """
        @summary Queries the data masking rules of a PolarDB cluster or the information about a specified masking rule.
        
        @param request: DescribeMaskingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMaskingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.interface_version):
            query['InterfaceVersion'] = request.interface_version
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMaskingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeMaskingRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_masking_rules_with_options_async(
        self,
        request: polardb_20170801_models.DescribeMaskingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeMaskingRulesResponse:
        """
        @summary Queries the data masking rules of a PolarDB cluster or the information about a specified masking rule.
        
        @param request: DescribeMaskingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMaskingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.interface_version):
            query['InterfaceVersion'] = request.interface_version
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMaskingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeMaskingRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_masking_rules(
        self,
        request: polardb_20170801_models.DescribeMaskingRulesRequest,
    ) -> polardb_20170801_models.DescribeMaskingRulesResponse:
        """
        @summary Queries the data masking rules of a PolarDB cluster or the information about a specified masking rule.
        
        @param request: DescribeMaskingRulesRequest
        @return: DescribeMaskingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_masking_rules_with_options(request, runtime)

    async def describe_masking_rules_async(
        self,
        request: polardb_20170801_models.DescribeMaskingRulesRequest,
    ) -> polardb_20170801_models.DescribeMaskingRulesResponse:
        """
        @summary Queries the data masking rules of a PolarDB cluster or the information about a specified masking rule.
        
        @param request: DescribeMaskingRulesRequest
        @return: DescribeMaskingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_masking_rules_with_options_async(request, runtime)

    def describe_meta_list_with_options(
        self,
        request: polardb_20170801_models.DescribeMetaListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeMetaListResponse:
        """
        @summary Queries the details of the databases or tables that can be restored.
        
        @param request: DescribeMetaListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMetaListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.get_db_name):
            query['GetDbName'] = request.get_db_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_code):
            query['RegionCode'] = request.region_code
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.restore_time):
            query['RestoreTime'] = request.restore_time
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMetaList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeMetaListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_meta_list_with_options_async(
        self,
        request: polardb_20170801_models.DescribeMetaListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeMetaListResponse:
        """
        @summary Queries the details of the databases or tables that can be restored.
        
        @param request: DescribeMetaListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMetaListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.get_db_name):
            query['GetDbName'] = request.get_db_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_code):
            query['RegionCode'] = request.region_code
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.restore_time):
            query['RestoreTime'] = request.restore_time
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMetaList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeMetaListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_meta_list(
        self,
        request: polardb_20170801_models.DescribeMetaListRequest,
    ) -> polardb_20170801_models.DescribeMetaListResponse:
        """
        @summary Queries the details of the databases or tables that can be restored.
        
        @param request: DescribeMetaListRequest
        @return: DescribeMetaListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_meta_list_with_options(request, runtime)

    async def describe_meta_list_async(
        self,
        request: polardb_20170801_models.DescribeMetaListRequest,
    ) -> polardb_20170801_models.DescribeMetaListResponse:
        """
        @summary Queries the details of the databases or tables that can be restored.
        
        @param request: DescribeMetaListRequest
        @return: DescribeMetaListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_meta_list_with_options_async(request, runtime)

    def describe_modify_parameter_log_with_options(
        self,
        request: polardb_20170801_models.DescribeModifyParameterLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeModifyParameterLogResponse:
        """
        @summary 查询参数修改历史
        
        @param request: DescribeModifyParameterLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeModifyParameterLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeModifyParameterLog',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeModifyParameterLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_modify_parameter_log_with_options_async(
        self,
        request: polardb_20170801_models.DescribeModifyParameterLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeModifyParameterLogResponse:
        """
        @summary 查询参数修改历史
        
        @param request: DescribeModifyParameterLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeModifyParameterLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeModifyParameterLog',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeModifyParameterLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_modify_parameter_log(
        self,
        request: polardb_20170801_models.DescribeModifyParameterLogRequest,
    ) -> polardb_20170801_models.DescribeModifyParameterLogResponse:
        """
        @summary 查询参数修改历史
        
        @param request: DescribeModifyParameterLogRequest
        @return: DescribeModifyParameterLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_modify_parameter_log_with_options(request, runtime)

    async def describe_modify_parameter_log_async(
        self,
        request: polardb_20170801_models.DescribeModifyParameterLogRequest,
    ) -> polardb_20170801_models.DescribeModifyParameterLogResponse:
        """
        @summary 查询参数修改历史
        
        @param request: DescribeModifyParameterLogRequest
        @return: DescribeModifyParameterLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_modify_parameter_log_with_options_async(request, runtime)

    def describe_network_channel_with_options(
        self,
        request: polardb_20170801_models.DescribeNetworkChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeNetworkChannelResponse:
        """
        @summary 查询网络通道
        
        @param request: DescribeNetworkChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkChannel',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeNetworkChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_channel_with_options_async(
        self,
        request: polardb_20170801_models.DescribeNetworkChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeNetworkChannelResponse:
        """
        @summary 查询网络通道
        
        @param request: DescribeNetworkChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkChannel',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeNetworkChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_channel(
        self,
        request: polardb_20170801_models.DescribeNetworkChannelRequest,
    ) -> polardb_20170801_models.DescribeNetworkChannelResponse:
        """
        @summary 查询网络通道
        
        @param request: DescribeNetworkChannelRequest
        @return: DescribeNetworkChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_network_channel_with_options(request, runtime)

    async def describe_network_channel_async(
        self,
        request: polardb_20170801_models.DescribeNetworkChannelRequest,
    ) -> polardb_20170801_models.DescribeNetworkChannelResponse:
        """
        @summary 查询网络通道
        
        @param request: DescribeNetworkChannelRequest
        @return: DescribeNetworkChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_channel_with_options_async(request, runtime)

    def describe_parameter_group_with_options(
        self,
        request: polardb_20170801_models.DescribeParameterGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeParameterGroupResponse:
        """
        @summary Queries the information about a parameter template.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > This parameter is valid only for a PolarDB for MySQL cluster.
        
        @param request: DescribeParameterGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeParameterGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parameter_group_id):
            query['ParameterGroupId'] = request.parameter_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeParameterGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeParameterGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_parameter_group_with_options_async(
        self,
        request: polardb_20170801_models.DescribeParameterGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeParameterGroupResponse:
        """
        @summary Queries the information about a parameter template.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > This parameter is valid only for a PolarDB for MySQL cluster.
        
        @param request: DescribeParameterGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeParameterGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parameter_group_id):
            query['ParameterGroupId'] = request.parameter_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeParameterGroup',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeParameterGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_parameter_group(
        self,
        request: polardb_20170801_models.DescribeParameterGroupRequest,
    ) -> polardb_20170801_models.DescribeParameterGroupResponse:
        """
        @summary Queries the information about a parameter template.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > This parameter is valid only for a PolarDB for MySQL cluster.
        
        @param request: DescribeParameterGroupRequest
        @return: DescribeParameterGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_parameter_group_with_options(request, runtime)

    async def describe_parameter_group_async(
        self,
        request: polardb_20170801_models.DescribeParameterGroupRequest,
    ) -> polardb_20170801_models.DescribeParameterGroupResponse:
        """
        @summary Queries the information about a parameter template.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > This parameter is valid only for a PolarDB for MySQL cluster.
        
        @param request: DescribeParameterGroupRequest
        @return: DescribeParameterGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_parameter_group_with_options_async(request, runtime)

    def describe_parameter_groups_with_options(
        self,
        request: polardb_20170801_models.DescribeParameterGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeParameterGroupsResponse:
        """
        @summary Queries parameter templates that are available in a specified region.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeParameterGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeParameterGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeParameterGroups',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeParameterGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_parameter_groups_with_options_async(
        self,
        request: polardb_20170801_models.DescribeParameterGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeParameterGroupsResponse:
        """
        @summary Queries parameter templates that are available in a specified region.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeParameterGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeParameterGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeParameterGroups',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeParameterGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_parameter_groups(
        self,
        request: polardb_20170801_models.DescribeParameterGroupsRequest,
    ) -> polardb_20170801_models.DescribeParameterGroupsResponse:
        """
        @summary Queries parameter templates that are available in a specified region.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeParameterGroupsRequest
        @return: DescribeParameterGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_parameter_groups_with_options(request, runtime)

    async def describe_parameter_groups_async(
        self,
        request: polardb_20170801_models.DescribeParameterGroupsRequest,
    ) -> polardb_20170801_models.DescribeParameterGroupsResponse:
        """
        @summary Queries parameter templates that are available in a specified region.
        
        @description You can use parameter templates to manage multiple parameters at a time and apply existing parameters to a PolarDB cluster. For more information, see [Use a parameter template](https://help.aliyun.com/document_detail/207009.html).
        > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeParameterGroupsRequest
        @return: DescribeParameterGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_parameter_groups_with_options_async(request, runtime)

    def describe_parameter_templates_with_options(
        self,
        request: polardb_20170801_models.DescribeParameterTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeParameterTemplatesResponse:
        """
        @summary Queries the default parameters in a cluster.
        
        @param request: DescribeParameterTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeParameterTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeParameterTemplates',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeParameterTemplatesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_parameter_templates_with_options_async(
        self,
        request: polardb_20170801_models.DescribeParameterTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeParameterTemplatesResponse:
        """
        @summary Queries the default parameters in a cluster.
        
        @param request: DescribeParameterTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeParameterTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeParameterTemplates',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeParameterTemplatesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_parameter_templates(
        self,
        request: polardb_20170801_models.DescribeParameterTemplatesRequest,
    ) -> polardb_20170801_models.DescribeParameterTemplatesResponse:
        """
        @summary Queries the default parameters in a cluster.
        
        @param request: DescribeParameterTemplatesRequest
        @return: DescribeParameterTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_parameter_templates_with_options(request, runtime)

    async def describe_parameter_templates_async(
        self,
        request: polardb_20170801_models.DescribeParameterTemplatesRequest,
    ) -> polardb_20170801_models.DescribeParameterTemplatesResponse:
        """
        @summary Queries the default parameters in a cluster.
        
        @param request: DescribeParameterTemplatesRequest
        @return: DescribeParameterTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_parameter_templates_with_options_async(request, runtime)

    def describe_pending_maintenance_action_with_options(
        self,
        request: polardb_20170801_models.DescribePendingMaintenanceActionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePendingMaintenanceActionResponse:
        """
        @summary Queries the information about a pending event.
        
        @param request: DescribePendingMaintenanceActionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePendingMaintenanceActionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.is_history):
            query['IsHistory'] = request.is_history
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePendingMaintenanceAction',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePendingMaintenanceActionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_pending_maintenance_action_with_options_async(
        self,
        request: polardb_20170801_models.DescribePendingMaintenanceActionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePendingMaintenanceActionResponse:
        """
        @summary Queries the information about a pending event.
        
        @param request: DescribePendingMaintenanceActionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePendingMaintenanceActionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.is_history):
            query['IsHistory'] = request.is_history
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePendingMaintenanceAction',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePendingMaintenanceActionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_pending_maintenance_action(
        self,
        request: polardb_20170801_models.DescribePendingMaintenanceActionRequest,
    ) -> polardb_20170801_models.DescribePendingMaintenanceActionResponse:
        """
        @summary Queries the information about a pending event.
        
        @param request: DescribePendingMaintenanceActionRequest
        @return: DescribePendingMaintenanceActionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_pending_maintenance_action_with_options(request, runtime)

    async def describe_pending_maintenance_action_async(
        self,
        request: polardb_20170801_models.DescribePendingMaintenanceActionRequest,
    ) -> polardb_20170801_models.DescribePendingMaintenanceActionResponse:
        """
        @summary Queries the information about a pending event.
        
        @param request: DescribePendingMaintenanceActionRequest
        @return: DescribePendingMaintenanceActionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_pending_maintenance_action_with_options_async(request, runtime)

    def describe_pending_maintenance_actions_with_options(
        self,
        request: polardb_20170801_models.DescribePendingMaintenanceActionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePendingMaintenanceActionsResponse:
        """
        @summary Queries the numbers of scheduled events for different types of tasks.
        
        @param request: DescribePendingMaintenanceActionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePendingMaintenanceActionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.is_history):
            query['IsHistory'] = request.is_history
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePendingMaintenanceActions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePendingMaintenanceActionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_pending_maintenance_actions_with_options_async(
        self,
        request: polardb_20170801_models.DescribePendingMaintenanceActionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePendingMaintenanceActionsResponse:
        """
        @summary Queries the numbers of scheduled events for different types of tasks.
        
        @param request: DescribePendingMaintenanceActionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePendingMaintenanceActionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.is_history):
            query['IsHistory'] = request.is_history
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePendingMaintenanceActions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePendingMaintenanceActionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_pending_maintenance_actions(
        self,
        request: polardb_20170801_models.DescribePendingMaintenanceActionsRequest,
    ) -> polardb_20170801_models.DescribePendingMaintenanceActionsResponse:
        """
        @summary Queries the numbers of scheduled events for different types of tasks.
        
        @param request: DescribePendingMaintenanceActionsRequest
        @return: DescribePendingMaintenanceActionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_pending_maintenance_actions_with_options(request, runtime)

    async def describe_pending_maintenance_actions_async(
        self,
        request: polardb_20170801_models.DescribePendingMaintenanceActionsRequest,
    ) -> polardb_20170801_models.DescribePendingMaintenanceActionsResponse:
        """
        @summary Queries the numbers of scheduled events for different types of tasks.
        
        @param request: DescribePendingMaintenanceActionsRequest
        @return: DescribePendingMaintenanceActionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_pending_maintenance_actions_with_options_async(request, runtime)

    def describe_polar_fs_attribute_with_options(
        self,
        request: polardb_20170801_models.DescribePolarFsAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePolarFsAttributeResponse:
        """
        @summary 获取PolarFS实例详情
        
        @param request: DescribePolarFsAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolarFsAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.query_fuse_mount_info):
            query['QueryFuseMountInfo'] = request.query_fuse_mount_info
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolarFsAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePolarFsAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_polar_fs_attribute_with_options_async(
        self,
        request: polardb_20170801_models.DescribePolarFsAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePolarFsAttributeResponse:
        """
        @summary 获取PolarFS实例详情
        
        @param request: DescribePolarFsAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolarFsAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.query_fuse_mount_info):
            query['QueryFuseMountInfo'] = request.query_fuse_mount_info
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolarFsAttribute',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePolarFsAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_polar_fs_attribute(
        self,
        request: polardb_20170801_models.DescribePolarFsAttributeRequest,
    ) -> polardb_20170801_models.DescribePolarFsAttributeResponse:
        """
        @summary 获取PolarFS实例详情
        
        @param request: DescribePolarFsAttributeRequest
        @return: DescribePolarFsAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_polar_fs_attribute_with_options(request, runtime)

    async def describe_polar_fs_attribute_async(
        self,
        request: polardb_20170801_models.DescribePolarFsAttributeRequest,
    ) -> polardb_20170801_models.DescribePolarFsAttributeResponse:
        """
        @summary 获取PolarFS实例详情
        
        @param request: DescribePolarFsAttributeRequest
        @return: DescribePolarFsAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_polar_fs_attribute_with_options_async(request, runtime)

    def describe_polar_fs_quota_with_options(
        self,
        request: polardb_20170801_models.DescribePolarFsQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePolarFsQuotaResponse:
        """
        @summary 查询配额规则
        
        @param request: DescribePolarFsQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolarFsQuotaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolarFsQuota',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePolarFsQuotaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_polar_fs_quota_with_options_async(
        self,
        request: polardb_20170801_models.DescribePolarFsQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePolarFsQuotaResponse:
        """
        @summary 查询配额规则
        
        @param request: DescribePolarFsQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolarFsQuotaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.polar_fs_instance_id):
            query['PolarFsInstanceId'] = request.polar_fs_instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolarFsQuota',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePolarFsQuotaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_polar_fs_quota(
        self,
        request: polardb_20170801_models.DescribePolarFsQuotaRequest,
    ) -> polardb_20170801_models.DescribePolarFsQuotaResponse:
        """
        @summary 查询配额规则
        
        @param request: DescribePolarFsQuotaRequest
        @return: DescribePolarFsQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_polar_fs_quota_with_options(request, runtime)

    async def describe_polar_fs_quota_async(
        self,
        request: polardb_20170801_models.DescribePolarFsQuotaRequest,
    ) -> polardb_20170801_models.DescribePolarFsQuotaResponse:
        """
        @summary 查询配额规则
        
        @param request: DescribePolarFsQuotaRequest
        @return: DescribePolarFsQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_polar_fs_quota_with_options_async(request, runtime)

    def describe_polar_sqlcollector_policy_with_options(
        self,
        request: polardb_20170801_models.DescribePolarSQLCollectorPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePolarSQLCollectorPolicyResponse:
        """
        @summary Queries whether the SQL Explorer feature is enabled for the cluster.
        
        @param request: DescribePolarSQLCollectorPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolarSQLCollectorPolicyResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolarSQLCollectorPolicy',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePolarSQLCollectorPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_polar_sqlcollector_policy_with_options_async(
        self,
        request: polardb_20170801_models.DescribePolarSQLCollectorPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribePolarSQLCollectorPolicyResponse:
        """
        @summary Queries whether the SQL Explorer feature is enabled for the cluster.
        
        @param request: DescribePolarSQLCollectorPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolarSQLCollectorPolicyResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolarSQLCollectorPolicy',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribePolarSQLCollectorPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_polar_sqlcollector_policy(
        self,
        request: polardb_20170801_models.DescribePolarSQLCollectorPolicyRequest,
    ) -> polardb_20170801_models.DescribePolarSQLCollectorPolicyResponse:
        """
        @summary Queries whether the SQL Explorer feature is enabled for the cluster.
        
        @param request: DescribePolarSQLCollectorPolicyRequest
        @return: DescribePolarSQLCollectorPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_polar_sqlcollector_policy_with_options(request, runtime)

    async def describe_polar_sqlcollector_policy_async(
        self,
        request: polardb_20170801_models.DescribePolarSQLCollectorPolicyRequest,
    ) -> polardb_20170801_models.DescribePolarSQLCollectorPolicyResponse:
        """
        @summary Queries whether the SQL Explorer feature is enabled for the cluster.
        
        @param request: DescribePolarSQLCollectorPolicyRequest
        @return: DescribePolarSQLCollectorPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_polar_sqlcollector_policy_with_options_async(request, runtime)

    def describe_rds_vswitchs_with_options(
        self,
        request: polardb_20170801_models.DescribeRdsVSwitchsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeRdsVSwitchsResponse:
        """
        @param request: DescribeRdsVSwitchsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRdsVSwitchsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRdsVSwitchs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeRdsVSwitchsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_rds_vswitchs_with_options_async(
        self,
        request: polardb_20170801_models.DescribeRdsVSwitchsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeRdsVSwitchsResponse:
        """
        @param request: DescribeRdsVSwitchsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRdsVSwitchsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRdsVSwitchs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeRdsVSwitchsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_rds_vswitchs(
        self,
        request: polardb_20170801_models.DescribeRdsVSwitchsRequest,
    ) -> polardb_20170801_models.DescribeRdsVSwitchsResponse:
        """
        @param request: DescribeRdsVSwitchsRequest
        @return: DescribeRdsVSwitchsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_rds_vswitchs_with_options(request, runtime)

    async def describe_rds_vswitchs_async(
        self,
        request: polardb_20170801_models.DescribeRdsVSwitchsRequest,
    ) -> polardb_20170801_models.DescribeRdsVSwitchsResponse:
        """
        @param request: DescribeRdsVSwitchsRequest
        @return: DescribeRdsVSwitchsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_rds_vswitchs_with_options_async(request, runtime)

    def describe_rds_vpcs_with_options(
        self,
        request: polardb_20170801_models.DescribeRdsVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeRdsVpcsResponse:
        """
        @param request: DescribeRdsVpcsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRdsVpcsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRdsVpcs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeRdsVpcsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_rds_vpcs_with_options_async(
        self,
        request: polardb_20170801_models.DescribeRdsVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeRdsVpcsResponse:
        """
        @param request: DescribeRdsVpcsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRdsVpcsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRdsVpcs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeRdsVpcsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_rds_vpcs(
        self,
        request: polardb_20170801_models.DescribeRdsVpcsRequest,
    ) -> polardb_20170801_models.DescribeRdsVpcsResponse:
        """
        @param request: DescribeRdsVpcsRequest
        @return: DescribeRdsVpcsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_rds_vpcs_with_options(request, runtime)

    async def describe_rds_vpcs_async(
        self,
        request: polardb_20170801_models.DescribeRdsVpcsRequest,
    ) -> polardb_20170801_models.DescribeRdsVpcsResponse:
        """
        @param request: DescribeRdsVpcsRequest
        @return: DescribeRdsVpcsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_rds_vpcs_with_options_async(request, runtime)

    def describe_regions_with_options(
        self,
        request: polardb_20170801_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeRegionsResponse:
        """
        @summary Queries the regions and zones available for PolarDB.
        
        @param request: DescribeRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeRegionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_regions_with_options_async(
        self,
        request: polardb_20170801_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeRegionsResponse:
        """
        @summary Queries the regions and zones available for PolarDB.
        
        @param request: DescribeRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeRegionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_regions(
        self,
        request: polardb_20170801_models.DescribeRegionsRequest,
    ) -> polardb_20170801_models.DescribeRegionsResponse:
        """
        @summary Queries the regions and zones available for PolarDB.
        
        @param request: DescribeRegionsRequest
        @return: DescribeRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_regions_with_options(request, runtime)

    async def describe_regions_async(
        self,
        request: polardb_20170801_models.DescribeRegionsRequest,
    ) -> polardb_20170801_models.DescribeRegionsResponse:
        """
        @summary Queries the regions and zones available for PolarDB.
        
        @param request: DescribeRegionsRequest
        @return: DescribeRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_regions_with_options_async(request, runtime)

    def describe_resource_packages_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeResourcePackagesResponse:
        """
        @summary 查询资源包列表
        
        @param request: DescribeResourcePackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeResourcePackagesResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeResourcePackages',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeResourcePackagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_resource_packages_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeResourcePackagesResponse:
        """
        @summary 查询资源包列表
        
        @param request: DescribeResourcePackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeResourcePackagesResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeResourcePackages',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeResourcePackagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_resource_packages(self) -> polardb_20170801_models.DescribeResourcePackagesResponse:
        """
        @summary 查询资源包列表
        
        @return: DescribeResourcePackagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_resource_packages_with_options(runtime)

    async def describe_resource_packages_async(self) -> polardb_20170801_models.DescribeResourcePackagesResponse:
        """
        @summary 查询资源包列表
        
        @return: DescribeResourcePackagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_resource_packages_with_options_async(runtime)

    def describe_sqlrate_limiting_rules_with_options(
        self,
        request: polardb_20170801_models.DescribeSQLRateLimitingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeSQLRateLimitingRulesResponse:
        """
        @summary 查询SQL限流规则信息
        
        @param request: DescribeSQLRateLimitingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSQLRateLimitingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSQLRateLimitingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeSQLRateLimitingRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sqlrate_limiting_rules_with_options_async(
        self,
        request: polardb_20170801_models.DescribeSQLRateLimitingRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeSQLRateLimitingRulesResponse:
        """
        @summary 查询SQL限流规则信息
        
        @param request: DescribeSQLRateLimitingRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSQLRateLimitingRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSQLRateLimitingRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeSQLRateLimitingRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sqlrate_limiting_rules(
        self,
        request: polardb_20170801_models.DescribeSQLRateLimitingRulesRequest,
    ) -> polardb_20170801_models.DescribeSQLRateLimitingRulesResponse:
        """
        @summary 查询SQL限流规则信息
        
        @param request: DescribeSQLRateLimitingRulesRequest
        @return: DescribeSQLRateLimitingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sqlrate_limiting_rules_with_options(request, runtime)

    async def describe_sqlrate_limiting_rules_async(
        self,
        request: polardb_20170801_models.DescribeSQLRateLimitingRulesRequest,
    ) -> polardb_20170801_models.DescribeSQLRateLimitingRulesResponse:
        """
        @summary 查询SQL限流规则信息
        
        @param request: DescribeSQLRateLimitingRulesRequest
        @return: DescribeSQLRateLimitingRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sqlrate_limiting_rules_with_options_async(request, runtime)

    def describe_schedule_tasks_with_options(
        self,
        request: polardb_20170801_models.DescribeScheduleTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeScheduleTasksResponse:
        """
        @summary Queries the details of all scheduled tasks.
        
        @param request: DescribeScheduleTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeScheduleTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.order_id):
            query['OrderId'] = request.order_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.planned_end_time):
            query['PlannedEndTime'] = request.planned_end_time
        if not UtilClient.is_unset(request.planned_start_time):
            query['PlannedStartTime'] = request.planned_start_time
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_action):
            query['TaskAction'] = request.task_action
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeScheduleTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeScheduleTasksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_schedule_tasks_with_options_async(
        self,
        request: polardb_20170801_models.DescribeScheduleTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeScheduleTasksResponse:
        """
        @summary Queries the details of all scheduled tasks.
        
        @param request: DescribeScheduleTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeScheduleTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_description):
            query['DBClusterDescription'] = request.dbcluster_description
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.order_id):
            query['OrderId'] = request.order_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.planned_end_time):
            query['PlannedEndTime'] = request.planned_end_time
        if not UtilClient.is_unset(request.planned_start_time):
            query['PlannedStartTime'] = request.planned_start_time
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_action):
            query['TaskAction'] = request.task_action
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeScheduleTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeScheduleTasksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_schedule_tasks(
        self,
        request: polardb_20170801_models.DescribeScheduleTasksRequest,
    ) -> polardb_20170801_models.DescribeScheduleTasksResponse:
        """
        @summary Queries the details of all scheduled tasks.
        
        @param request: DescribeScheduleTasksRequest
        @return: DescribeScheduleTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_schedule_tasks_with_options(request, runtime)

    async def describe_schedule_tasks_async(
        self,
        request: polardb_20170801_models.DescribeScheduleTasksRequest,
    ) -> polardb_20170801_models.DescribeScheduleTasksResponse:
        """
        @summary Queries the details of all scheduled tasks.
        
        @param request: DescribeScheduleTasksRequest
        @return: DescribeScheduleTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_schedule_tasks_with_options_async(request, runtime)

    def describe_slow_log_records_with_options(
        self,
        request: polardb_20170801_models.DescribeSlowLogRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeSlowLogRecordsResponse:
        """
        @summary Slow Log Details
        
        @description >- Only PolarDB MySQL Edition clusters support calling this interface.
        >- Starting from September 1, 2024, due to the optimization of the SQL template algorithm, when calling this interface, the value of the SQLHash field will change. For more details, please refer to [Notice] Optimization of Slow SQL Template Algorithm (~~2845725~~).
        
        @param request: DescribeSlowLogRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSlowLogRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.sqlhash):
            query['SQLHASH'] = request.sqlhash
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSlowLogRecords',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeSlowLogRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_slow_log_records_with_options_async(
        self,
        request: polardb_20170801_models.DescribeSlowLogRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeSlowLogRecordsResponse:
        """
        @summary Slow Log Details
        
        @description >- Only PolarDB MySQL Edition clusters support calling this interface.
        >- Starting from September 1, 2024, due to the optimization of the SQL template algorithm, when calling this interface, the value of the SQLHash field will change. For more details, please refer to [Notice] Optimization of Slow SQL Template Algorithm (~~2845725~~).
        
        @param request: DescribeSlowLogRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSlowLogRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.sqlhash):
            query['SQLHASH'] = request.sqlhash
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSlowLogRecords',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeSlowLogRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_slow_log_records(
        self,
        request: polardb_20170801_models.DescribeSlowLogRecordsRequest,
    ) -> polardb_20170801_models.DescribeSlowLogRecordsResponse:
        """
        @summary Slow Log Details
        
        @description >- Only PolarDB MySQL Edition clusters support calling this interface.
        >- Starting from September 1, 2024, due to the optimization of the SQL template algorithm, when calling this interface, the value of the SQLHash field will change. For more details, please refer to [Notice] Optimization of Slow SQL Template Algorithm (~~2845725~~).
        
        @param request: DescribeSlowLogRecordsRequest
        @return: DescribeSlowLogRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_slow_log_records_with_options(request, runtime)

    async def describe_slow_log_records_async(
        self,
        request: polardb_20170801_models.DescribeSlowLogRecordsRequest,
    ) -> polardb_20170801_models.DescribeSlowLogRecordsResponse:
        """
        @summary Slow Log Details
        
        @description >- Only PolarDB MySQL Edition clusters support calling this interface.
        >- Starting from September 1, 2024, due to the optimization of the SQL template algorithm, when calling this interface, the value of the SQLHash field will change. For more details, please refer to [Notice] Optimization of Slow SQL Template Algorithm (~~2845725~~).
        
        @param request: DescribeSlowLogRecordsRequest
        @return: DescribeSlowLogRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_slow_log_records_with_options_async(request, runtime)

    def describe_slow_logs_with_options(
        self,
        request: polardb_20170801_models.DescribeSlowLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeSlowLogsResponse:
        """
        @summary Queries the statistics about the slow query logs of a PolarDB cluster.
        
        @description > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeSlowLogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSlowLogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSlowLogs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeSlowLogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_slow_logs_with_options_async(
        self,
        request: polardb_20170801_models.DescribeSlowLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeSlowLogsResponse:
        """
        @summary Queries the statistics about the slow query logs of a PolarDB cluster.
        
        @description > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeSlowLogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSlowLogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbname):
            query['DBName'] = request.dbname
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSlowLogs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeSlowLogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_slow_logs(
        self,
        request: polardb_20170801_models.DescribeSlowLogsRequest,
    ) -> polardb_20170801_models.DescribeSlowLogsResponse:
        """
        @summary Queries the statistics about the slow query logs of a PolarDB cluster.
        
        @description > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeSlowLogsRequest
        @return: DescribeSlowLogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_slow_logs_with_options(request, runtime)

    async def describe_slow_logs_async(
        self,
        request: polardb_20170801_models.DescribeSlowLogsRequest,
    ) -> polardb_20170801_models.DescribeSlowLogsResponse:
        """
        @summary Queries the statistics about the slow query logs of a PolarDB cluster.
        
        @description > This operation is applicable only to PolarDB for MySQL clusters.
        
        @param request: DescribeSlowLogsRequest
        @return: DescribeSlowLogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_slow_logs_with_options_async(request, runtime)

    def describe_tasks_with_options(
        self,
        request: polardb_20170801_models.DescribeTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeTasksResponse:
        """
        @summary Queries the status of the tasks that are generated based on API operations, such as the status of instance creation tasks.
        
        @description    You can call this operation to view the details of a task that is generated by a specific API operation or in the PolarDB console. The system calls the specific API operation when you perform an operation in the PolarDB console. For example, you can view the details of the task when you call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation or [create a cluster](https://help.aliyun.com/document_detail/58769.html) in the PolarDB console.
        You can view the details of tasks that are generated only when you call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation to create a cluster and `CreationOption` is not set to `CreateGdnStandby`.
        
        @param request: DescribeTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeTasksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_tasks_with_options_async(
        self,
        request: polardb_20170801_models.DescribeTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeTasksResponse:
        """
        @summary Queries the status of the tasks that are generated based on API operations, such as the status of instance creation tasks.
        
        @description    You can call this operation to view the details of a task that is generated by a specific API operation or in the PolarDB console. The system calls the specific API operation when you perform an operation in the PolarDB console. For example, you can view the details of the task when you call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation or [create a cluster](https://help.aliyun.com/document_detail/58769.html) in the PolarDB console.
        You can view the details of tasks that are generated only when you call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation to create a cluster and `CreationOption` is not set to `CreateGdnStandby`.
        
        @param request: DescribeTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.dbnode_id):
            query['DBNodeId'] = request.dbnode_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTasks',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeTasksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_tasks(
        self,
        request: polardb_20170801_models.DescribeTasksRequest,
    ) -> polardb_20170801_models.DescribeTasksResponse:
        """
        @summary Queries the status of the tasks that are generated based on API operations, such as the status of instance creation tasks.
        
        @description    You can call this operation to view the details of a task that is generated by a specific API operation or in the PolarDB console. The system calls the specific API operation when you perform an operation in the PolarDB console. For example, you can view the details of the task when you call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation or [create a cluster](https://help.aliyun.com/document_detail/58769.html) in the PolarDB console.
        You can view the details of tasks that are generated only when you call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation to create a cluster and `CreationOption` is not set to `CreateGdnStandby`.
        
        @param request: DescribeTasksRequest
        @return: DescribeTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_tasks_with_options(request, runtime)

    async def describe_tasks_async(
        self,
        request: polardb_20170801_models.DescribeTasksRequest,
    ) -> polardb_20170801_models.DescribeTasksResponse:
        """
        @summary Queries the status of the tasks that are generated based on API operations, such as the status of instance creation tasks.
        
        @description    You can call this operation to view the details of a task that is generated by a specific API operation or in the PolarDB console. The system calls the specific API operation when you perform an operation in the PolarDB console. For example, you can view the details of the task when you call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation or [create a cluster](https://help.aliyun.com/document_detail/58769.html) in the PolarDB console.
        You can view the details of tasks that are generated only when you call the [CreateDBCluster](https://help.aliyun.com/document_detail/98169.html) operation to create a cluster and `CreationOption` is not set to `CreateGdnStandby`.
        
        @param request: DescribeTasksRequest
        @return: DescribeTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_tasks_with_options_async(request, runtime)

    def describe_upgrade_report_with_options(
        self,
        request: polardb_20170801_models.DescribeUpgradeReportRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeUpgradeReportResponse:
        """
        @summary 查询校验报告
        
        @param request: DescribeUpgradeReportRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUpgradeReportResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.creation_category):
            query['CreationCategory'] = request.creation_category
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_dbcluster_id):
            query['SourceDBClusterId'] = request.source_dbcluster_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUpgradeReport',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeUpgradeReportResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_upgrade_report_with_options_async(
        self,
        request: polardb_20170801_models.DescribeUpgradeReportRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeUpgradeReportResponse:
        """
        @summary 查询校验报告
        
        @param request: DescribeUpgradeReportRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUpgradeReportResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.creation_category):
            query['CreationCategory'] = request.creation_category
        if not UtilClient.is_unset(request.dbtype):
            query['DBType'] = request.dbtype
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_dbcluster_id):
            query['SourceDBClusterId'] = request.source_dbcluster_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUpgradeReport',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeUpgradeReportResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_upgrade_report(
        self,
        request: polardb_20170801_models.DescribeUpgradeReportRequest,
    ) -> polardb_20170801_models.DescribeUpgradeReportResponse:
        """
        @summary 查询校验报告
        
        @param request: DescribeUpgradeReportRequest
        @return: DescribeUpgradeReportResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_upgrade_report_with_options(request, runtime)

    async def describe_upgrade_report_async(
        self,
        request: polardb_20170801_models.DescribeUpgradeReportRequest,
    ) -> polardb_20170801_models.DescribeUpgradeReportResponse:
        """
        @summary 查询校验报告
        
        @param request: DescribeUpgradeReportRequest
        @return: DescribeUpgradeReportResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_upgrade_report_with_options_async(request, runtime)

    def describe_user_encryption_key_list_with_options(
        self,
        request: polardb_20170801_models.DescribeUserEncryptionKeyListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeUserEncryptionKeyListResponse:
        """
        @summary Queries the Key Management Service (KMS)-managed customer master keys (CMKs) that are used to encrypt data in a PolarDB cluster.
        
        @param request: DescribeUserEncryptionKeyListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserEncryptionKeyListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tderegion):
            query['TDERegion'] = request.tderegion
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserEncryptionKeyList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeUserEncryptionKeyListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_encryption_key_list_with_options_async(
        self,
        request: polardb_20170801_models.DescribeUserEncryptionKeyListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeUserEncryptionKeyListResponse:
        """
        @summary Queries the Key Management Service (KMS)-managed customer master keys (CMKs) that are used to encrypt data in a PolarDB cluster.
        
        @param request: DescribeUserEncryptionKeyListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserEncryptionKeyListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tderegion):
            query['TDERegion'] = request.tderegion
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserEncryptionKeyList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeUserEncryptionKeyListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_encryption_key_list(
        self,
        request: polardb_20170801_models.DescribeUserEncryptionKeyListRequest,
    ) -> polardb_20170801_models.DescribeUserEncryptionKeyListResponse:
        """
        @summary Queries the Key Management Service (KMS)-managed customer master keys (CMKs) that are used to encrypt data in a PolarDB cluster.
        
        @param request: DescribeUserEncryptionKeyListRequest
        @return: DescribeUserEncryptionKeyListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_encryption_key_list_with_options(request, runtime)

    async def describe_user_encryption_key_list_async(
        self,
        request: polardb_20170801_models.DescribeUserEncryptionKeyListRequest,
    ) -> polardb_20170801_models.DescribeUserEncryptionKeyListResponse:
        """
        @summary Queries the Key Management Service (KMS)-managed customer master keys (CMKs) that are used to encrypt data in a PolarDB cluster.
        
        @param request: DescribeUserEncryptionKeyListRequest
        @return: DescribeUserEncryptionKeyListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_encryption_key_list_with_options_async(request, runtime)

    def describe_vswitch_list_with_options(
        self,
        request: polardb_20170801_models.DescribeVSwitchListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeVSwitchListResponse:
        """
        @summary 查询交换机信息
        
        @param request: DescribeVSwitchListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVSwitchListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.v_switch_ids):
            query['VSwitchIds'] = request.v_switch_ids
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitchList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeVSwitchListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vswitch_list_with_options_async(
        self,
        request: polardb_20170801_models.DescribeVSwitchListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeVSwitchListResponse:
        """
        @summary 查询交换机信息
        
        @param request: DescribeVSwitchListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVSwitchListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.v_switch_ids):
            query['VSwitchIds'] = request.v_switch_ids
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitchList',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeVSwitchListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vswitch_list(
        self,
        request: polardb_20170801_models.DescribeVSwitchListRequest,
    ) -> polardb_20170801_models.DescribeVSwitchListResponse:
        """
        @summary 查询交换机信息
        
        @param request: DescribeVSwitchListRequest
        @return: DescribeVSwitchListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vswitch_list_with_options(request, runtime)

    async def describe_vswitch_list_async(
        self,
        request: polardb_20170801_models.DescribeVSwitchListRequest,
    ) -> polardb_20170801_models.DescribeVSwitchListResponse:
        """
        @summary 查询交换机信息
        
        @param request: DescribeVSwitchListRequest
        @return: DescribeVSwitchListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vswitch_list_with_options_async(request, runtime)

    def describe_vswitches_with_options(
        self,
        request: polardb_20170801_models.DescribeVSwitchesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeVSwitchesResponse:
        """
        @summary Queries a vSwitch.
        
        @param request: DescribeVSwitchesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVSwitchesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_group_id):
            query['DedicatedHostGroupId'] = request.dedicated_host_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitches',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeVSwitchesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vswitches_with_options_async(
        self,
        request: polardb_20170801_models.DescribeVSwitchesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeVSwitchesResponse:
        """
        @summary Queries a vSwitch.
        
        @param request: DescribeVSwitchesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVSwitchesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_group_id):
            query['DedicatedHostGroupId'] = request.dedicated_host_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitches',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeVSwitchesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vswitches(
        self,
        request: polardb_20170801_models.DescribeVSwitchesRequest,
    ) -> polardb_20170801_models.DescribeVSwitchesResponse:
        """
        @summary Queries a vSwitch.
        
        @param request: DescribeVSwitchesRequest
        @return: DescribeVSwitchesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vswitches_with_options(request, runtime)

    async def describe_vswitches_async(
        self,
        request: polardb_20170801_models.DescribeVSwitchesRequest,
    ) -> polardb_20170801_models.DescribeVSwitchesResponse:
        """
        @summary Queries a vSwitch.
        
        @param request: DescribeVSwitchesRequest
        @return: DescribeVSwitchesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vswitches_with_options_async(request, runtime)

    def describe_vpcs_with_options(
        self,
        request: polardb_20170801_models.DescribeVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeVpcsResponse:
        """
        @summary 查询vpc
        
        @param request: DescribeVpcsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.product):
            query['Product'] = request.product
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeVpcsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpcs_with_options_async(
        self,
        request: polardb_20170801_models.DescribeVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeVpcsResponse:
        """
        @summary 查询vpc
        
        @param request: DescribeVpcsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.product):
            query['Product'] = request.product
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcs',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeVpcsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpcs(
        self,
        request: polardb_20170801_models.DescribeVpcsRequest,
    ) -> polardb_20170801_models.DescribeVpcsResponse:
        """
        @summary 查询vpc
        
        @param request: DescribeVpcsRequest
        @return: DescribeVpcsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpcs_with_options(request, runtime)

    async def describe_vpcs_async(
        self,
        request: polardb_20170801_models.DescribeVpcsRequest,
    ) -> polardb_20170801_models.DescribeVpcsResponse:
        """
        @summary 查询vpc
        
        @param request: DescribeVpcsRequest
        @return: DescribeVpcsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpcs_with_options_async(request, runtime)

    def describe_zones_with_options(
        self,
        request: polardb_20170801_models.DescribeZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeZonesResponse:
        """
        @summary 获取可用区
        
        @param request: DescribeZonesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeZonesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.engine):
            query['Engine'] = request.engine
        if not UtilClient.is_unset(request.extra):
            query['Extra'] = request.extra
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeZones',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeZonesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_zones_with_options_async(
        self,
        request: polardb_20170801_models.DescribeZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DescribeZonesResponse:
        """
        @summary 获取可用区
        
        @param request: DescribeZonesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeZonesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.engine):
            query['Engine'] = request.engine
        if not UtilClient.is_unset(request.extra):
            query['Extra'] = request.extra
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeZones',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DescribeZonesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_zones(
        self,
        request: polardb_20170801_models.DescribeZonesRequest,
    ) -> polardb_20170801_models.DescribeZonesResponse:
        """
        @summary 获取可用区
        
        @param request: DescribeZonesRequest
        @return: DescribeZonesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_zones_with_options(request, runtime)

    async def describe_zones_async(
        self,
        request: polardb_20170801_models.DescribeZonesRequest,
    ) -> polardb_20170801_models.DescribeZonesResponse:
        """
        @summary 获取可用区
        
        @param request: DescribeZonesRequest
        @return: DescribeZonesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_zones_with_options_async(request, runtime)

    def disable_dbcluster_orca_with_options(
        self,
        request: polardb_20170801_models.DisableDBClusterOrcaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DisableDBClusterOrcaResponse:
        """
        @summary 关闭集群的关系性
        
        @param request: DisableDBClusterOrcaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisableDBClusterOrcaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.clean_data):
            query['CleanData'] = request.clean_data
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableDBClusterOrca',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DisableDBClusterOrcaResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_dbcluster_orca_with_options_async(
        self,
        request: polardb_20170801_models.DisableDBClusterOrcaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DisableDBClusterOrcaResponse:
        """
        @summary 关闭集群的关系性
        
        @param request: DisableDBClusterOrcaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisableDBClusterOrcaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.clean_data):
            query['CleanData'] = request.clean_data
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableDBClusterOrca',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DisableDBClusterOrcaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_dbcluster_orca(
        self,
        request: polardb_20170801_models.DisableDBClusterOrcaRequest,
    ) -> polardb_20170801_models.DisableDBClusterOrcaResponse:
        """
        @summary 关闭集群的关系性
        
        @param request: DisableDBClusterOrcaRequest
        @return: DisableDBClusterOrcaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.disable_dbcluster_orca_with_options(request, runtime)

    async def disable_dbcluster_orca_async(
        self,
        request: polardb_20170801_models.DisableDBClusterOrcaRequest,
    ) -> polardb_20170801_models.DisableDBClusterOrcaResponse:
        """
        @summary 关闭集群的关系性
        
        @param request: DisableDBClusterOrcaRequest
        @return: DisableDBClusterOrcaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.disable_dbcluster_orca_with_options_async(request, runtime)

    def disable_dbcluster_serverless_with_options(
        self,
        request: polardb_20170801_models.DisableDBClusterServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DisableDBClusterServerlessResponse:
        """
        @summary Disables a stable serverless cluster.
        
        @param request: DisableDBClusterServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisableDBClusterServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableDBClusterServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DisableDBClusterServerlessResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_dbcluster_serverless_with_options_async(
        self,
        request: polardb_20170801_models.DisableDBClusterServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.DisableDBClusterServerlessResponse:
        """
        @summary Disables a stable serverless cluster.
        
        @param request: DisableDBClusterServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisableDBClusterServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableDBClusterServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.DisableDBClusterServerlessResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_dbcluster_serverless(
        self,
        request: polardb_20170801_models.DisableDBClusterServerlessRequest,
    ) -> polardb_20170801_models.DisableDBClusterServerlessResponse:
        """
        @summary Disables a stable serverless cluster.
        
        @param request: DisableDBClusterServerlessRequest
        @return: DisableDBClusterServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.disable_dbcluster_serverless_with_options(request, runtime)

    async def disable_dbcluster_serverless_async(
        self,
        request: polardb_20170801_models.DisableDBClusterServerlessRequest,
    ) -> polardb_20170801_models.DisableDBClusterServerlessResponse:
        """
        @summary Disables a stable serverless cluster.
        
        @param request: DisableDBClusterServerlessRequest
        @return: DisableDBClusterServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.disable_dbcluster_serverless_with_options_async(request, runtime)

    def enable_dbcluster_orca_with_options(
        self,
        request: polardb_20170801_models.EnableDBClusterOrcaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.EnableDBClusterOrcaResponse:
        """
        @summary 开启集群的关系性
        
        @param request: EnableDBClusterOrcaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableDBClusterOrcaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableDBClusterOrca',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.EnableDBClusterOrcaResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_dbcluster_orca_with_options_async(
        self,
        request: polardb_20170801_models.EnableDBClusterOrcaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.EnableDBClusterOrcaResponse:
        """
        @summary 开启集群的关系性
        
        @param request: EnableDBClusterOrcaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableDBClusterOrcaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableDBClusterOrca',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.EnableDBClusterOrcaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_dbcluster_orca(
        self,
        request: polardb_20170801_models.EnableDBClusterOrcaRequest,
    ) -> polardb_20170801_models.EnableDBClusterOrcaResponse:
        """
        @summary 开启集群的关系性
        
        @param request: EnableDBClusterOrcaRequest
        @return: EnableDBClusterOrcaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.enable_dbcluster_orca_with_options(request, runtime)

    async def enable_dbcluster_orca_async(
        self,
        request: polardb_20170801_models.EnableDBClusterOrcaRequest,
    ) -> polardb_20170801_models.EnableDBClusterOrcaResponse:
        """
        @summary 开启集群的关系性
        
        @param request: EnableDBClusterOrcaRequest
        @return: EnableDBClusterOrcaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.enable_dbcluster_orca_with_options_async(request, runtime)

    def enable_dbcluster_serverless_with_options(
        self,
        request: polardb_20170801_models.EnableDBClusterServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.EnableDBClusterServerlessResponse:
        """
        @summary Enables a stable serverless cluster.
        
        @param request: EnableDBClusterServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableDBClusterServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scale_ap_ro_num_max):
            query['ScaleApRoNumMax'] = request.scale_ap_ro_num_max
        if not UtilClient.is_unset(request.scale_ap_ro_num_min):
            query['ScaleApRoNumMin'] = request.scale_ap_ro_num_min
        if not UtilClient.is_unset(request.scale_max):
            query['ScaleMax'] = request.scale_max
        if not UtilClient.is_unset(request.scale_min):
            query['ScaleMin'] = request.scale_min
        if not UtilClient.is_unset(request.scale_ro_num_max):
            query['ScaleRoNumMax'] = request.scale_ro_num_max
        if not UtilClient.is_unset(request.scale_ro_num_min):
            query['ScaleRoNumMin'] = request.scale_ro_num_min
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableDBClusterServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.EnableDBClusterServerlessResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_dbcluster_serverless_with_options_async(
        self,
        request: polardb_20170801_models.EnableDBClusterServerlessRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.EnableDBClusterServerlessResponse:
        """
        @summary Enables a stable serverless cluster.
        
        @param request: EnableDBClusterServerlessRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableDBClusterServerlessResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.scale_ap_ro_num_max):
            query['ScaleApRoNumMax'] = request.scale_ap_ro_num_max
        if not UtilClient.is_unset(request.scale_ap_ro_num_min):
            query['ScaleApRoNumMin'] = request.scale_ap_ro_num_min
        if not UtilClient.is_unset(request.scale_max):
            query['ScaleMax'] = request.scale_max
        if not UtilClient.is_unset(request.scale_min):
            query['ScaleMin'] = request.scale_min
        if not UtilClient.is_unset(request.scale_ro_num_max):
            query['ScaleRoNumMax'] = request.scale_ro_num_max
        if not UtilClient.is_unset(request.scale_ro_num_min):
            query['ScaleRoNumMin'] = request.scale_ro_num_min
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableDBClusterServerless',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.EnableDBClusterServerlessResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_dbcluster_serverless(
        self,
        request: polardb_20170801_models.EnableDBClusterServerlessRequest,
    ) -> polardb_20170801_models.EnableDBClusterServerlessResponse:
        """
        @summary Enables a stable serverless cluster.
        
        @param request: EnableDBClusterServerlessRequest
        @return: EnableDBClusterServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.enable_dbcluster_serverless_with_options(request, runtime)

    async def enable_dbcluster_serverless_async(
        self,
        request: polardb_20170801_models.EnableDBClusterServerlessRequest,
    ) -> polardb_20170801_models.EnableDBClusterServerlessResponse:
        """
        @summary Enables a stable serverless cluster.
        
        @param request: EnableDBClusterServerlessRequest
        @return: EnableDBClusterServerlessResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.enable_dbcluster_serverless_with_options_async(request, runtime)

    def enable_firewall_rules_with_options(
        self,
        request: polardb_20170801_models.EnableFirewallRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.EnableFirewallRulesResponse:
        """
        @summary Modifies the status of SQL firewall rules for a cluster.
        
        @param request: EnableFirewallRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableFirewallRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableFirewallRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.EnableFirewallRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_firewall_rules_with_options_async(
        self,
        request: polardb_20170801_models.EnableFirewallRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> polardb_20170801_models.EnableFirewallRulesResponse:
        """
        @summary Modifies the status of SQL firewall rules for a cluster.
        
        @param request: EnableFirewallRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableFirewallRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbcluster_id):
            query['DBClusterId'] = request.dbcluster_id
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_name_list):
            query['RuleNameList'] = request.rule_name_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableFirewallRules',
            version='2017-08-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            polardb_20170801_models.EnableFirewallRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_firewall_rules(
        self,
        request: polardb_20170801_models.EnableFirewallRulesRequest,
    ) -> polardb_20170801_models.EnableFirewallRulesResponse:
        """
        @summary Modifies the status of SQL firewall rules for a cluster.
        
        @param request: EnableFirewallRulesRequest
        @return: EnableFirewallRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.enable_firewall_rules_with_options(request, runtime)

    async def enable_firewall_rules_async(
        self,
        request: polardb_20170801_models.EnableFirewallRulesRequest,
    ) -> polardb_20170801_models.EnableFirewallRulesResponse:
        """
       