# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .billing_period_status import BillingPeriodStatus
from .billing_plan import BillingPlan
from .billing_transition import BillingTransition


class BillingPeriod(UniversalBaseModel):
    """
    Complete billing period representation.
    """

    organization_id: str = pydantic.Field()
    """
    Organization this period belongs to
    """

    period_start: dt.datetime = pydantic.Field()
    """
    Period start (inclusive)
    """

    period_end: dt.datetime = pydantic.Field()
    """
    Period end (exclusive)
    """

    plan: BillingPlan = pydantic.Field()
    """
    Plan for this period
    """

    status: BillingPeriodStatus = pydantic.Field()
    """
    Period status
    """

    created_from: BillingTransition = pydantic.Field()
    """
    How this period was created
    """

    id: str
    stripe_subscription_id: typing.Optional[str] = None
    stripe_invoice_id: typing.Optional[str] = None
    amount_cents: typing.Optional[int] = None
    currency: typing.Optional[str] = None
    paid_at: typing.Optional[dt.datetime] = None
    previous_period_id: typing.Optional[str] = None
    created_at: dt.datetime
    modified_at: dt.datetime

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
