# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class OAuthTokenAuthentication(UniversalBaseModel):
    """
    OAuth authentication with pre-obtained token.
    """

    access_token: str = pydantic.Field()
    """
    OAuth access token
    """

    refresh_token: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth refresh token
    """

    expires_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Token expiry time
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
