# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .authentication_details import AuthenticationDetails
from .entity_summary import EntitySummary
from .schedule_details import ScheduleDetails
from .source_connection_status import SourceConnectionStatus
from .sync_details import SyncDetails


class SourceConnection(UniversalBaseModel):
    """
    Complete source connection details.
    """

    id: str
    name: str
    description: typing.Optional[str] = None
    short_name: str
    readable_collection_id: str
    status: SourceConnectionStatus
    created_at: dt.datetime
    modified_at: dt.datetime
    auth: AuthenticationDetails
    config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    schedule: typing.Optional[ScheduleDetails] = None
    sync: typing.Optional[SyncDetails] = None
    sync_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the associated sync
    """

    entities: typing.Optional[EntitySummary] = None
    federated_search: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this source uses federated search
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
