# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .dag_edge_create import DagEdgeCreate
from .dag_node_create import DagNodeCreate


class SyncDagUpdate(UniversalBaseModel):
    """
    Schema for updating a sync DAG definition.
    """

    name: str
    description: typing.Optional[str] = None
    sync_id: str
    nodes: typing.Optional[typing.List[DagNodeCreate]] = None
    edges: typing.Optional[typing.List[DagEdgeCreate]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
