import importlib.resources
import os

import click
from agenteval.cli import cli as ae_cli
from agenteval.cli import eval_command, score_command

DEFAULT_CONFIG = "v1.0.0"
SPLIT_NAMES = ["validation", "test"]


def get_config_path(config_name):
    """Get the path to a config file in the package's config directory."""
    with importlib.resources.path("astabench.config", f"{config_name}.yml") as path:
        return os.path.abspath(path)


for cmd in (eval_command, score_command):
    for param in cmd.params:
        if isinstance(param, click.Option) and param.name == "config_path":
            param.default = get_config_path(DEFAULT_CONFIG)
            param.show_default = True
            param.hidden = True
        elif isinstance(param, click.Option) and param.name == "split":
            param.type = click.Choice(SPLIT_NAMES, case_sensitive=False)

# Export the CLI
cli = ae_cli
