# **Environmental Progress Report**

# Introduction

# <span id="page-1-0"></span>**Contents**

# **Introduction**

- [Reflections from Lisa Jackson](#page-2-0)
- [Report highlights](#page-3-0)
- [Goals and progress](#page-4-0)
- [Journey to Apple 2030](#page-10-0) [Approach](#page-11-0)
  - [Design and materials](#page-14-0)

**[Apple 2030](#page-7-0)**

**[Environmental](#page-5-0)** 

**[Initiatives](#page-5-0)**

- [Electricity](#page-23-0)
- [Direct emissions](#page-31-0)
- [Carbon removal](#page-34-0)

#### **[Resources](#page-37-0)**

- [Approach](#page-38-0)
- [Product longevity](#page-39-0)
- [Material recovery](#page-44-0)
- [Water](#page-47-0)
- [Zero waste](#page-51-0)

#### **[Smarter Chemistry](#page-56-0)**

- [Assessment](#page-60-0)

# **[Engagement and](#page-65-0) [Advocacy](#page-65-0)**

## [Approach](#page-66-0)

- [Listening to a range of voices](#page-67-0) [Achieving change together](#page-68-0)
- [Supporting communities](#page-72-0) 
  - [worldwide](#page-72-0)

# **[Data](#page-75-0)**

- [Greenhouse gas emissions](#page-76-0)
- [High quality carbon certificates](#page-77-0)
- [Carbon footprint by product](#page-78-0)
- [Energy](#page-80-0)
- [Resources](#page-81-0)
- [Normalizing factors](#page-82-0)

- [Approach](#page-57-0)
- [Mapping](#page-58-0)
- [Innovation](#page-62-0)

# **[Appendix](#page-83-0)**

- [A: Corporate facilities energy supplement](#page-84-0)
- [B: Apple's life cycle assessment methodology](#page-93-0)
- [C: Assurance and review statements](#page-95-0)
- [D: Environment, Health and Safety Policy](#page-106-0)
- [E: ISO 14001 certification](#page-108-0)
- [Report notes](#page-110-0)

Image /page/1/Picture/48 description: {
 "image\_description": "An image containing text that reads \"112 End notes\"."
}

Image /page/1/Picture/49 description: {
 "image\_description": "A close-up view of the back side of an electronic device, likely a smartphone, featuring a sleek and smooth matte finish in a light beige color and part of a camera module visible."
}

# <span id="page-2-0"></span>**Reflections**

# **Apple's commitment to climate action has never been more clear.**

Thanks to the hard work of teams across our company, we've reduced our emissions by over 55 percent since 2015. We've crossed key milestones on our environmental journey. And we're rising to the generational challenge of climate change by working with companies and communities that span the globe.

Apple 2030 is our commitment to be carbon neutral for our entire footprint by the end of the decade. We'll get there by innovating at every stage of the product lifecycle — from how they're made, to what they're made from.

That starts with bringing new clean energy online across our supply chain. Today, more than 320 suppliers have committed to using renewable electricity for Apple production. With over 16 gigawatts already online, they're avoiding more than 18 million metric tons of greenhouse gas emissions.

Our teams and suppliers are a part of so many communities, so Apple's work to protect the planet takes us around the world. That's why we're partnering directly with communities and local organizations to support environmental solutions where they're needed most. In 2023, that meant expanding our Power for Impact program to bring clean energy to underserved communities in Nepal and Colombia, and supporting programs that increase access to safe water and sanitation in India.

We're also building our products with more recycled and renewable material than ever — work that helps to drive down our carbon footprint. Our customers play an important role in this effort. When you participate in the Apple Trade-In program, you're helping to bring us closer to the day our products will be made without taking anything from the Earth.

The proof is in our products. Last year, more than 20 percent of the materials we shipped in Apple products came from recycled sources. MacBook Air is our first product made with more than 50 percent recycled material, and we're making important strides across all of our products. The iPhone 15 lineup, Apple Watch Series 9, and Apple Watch Ultra 2 use 100 percent recycled cobalt in their batteries. More than 99 percent of the tungsten in our products comes from recycled sources. And we're driving innovation around the world to improve the way our industry recycles and recovers materials.

We're also finding new and better ways to get Apple products into people's hands. It's not just trains, planes, and automobiles increasingly, we're shipping Apple products on the open seas, because ocean freight can reduce emissions by as much as 95 percent compared to air transport. And we continue to restore our planet's ecosystems — like the Atlantic Forest, which stretches from Brazil to Paraguay — that play a key role in removing carbon from the atmosphere.

What does all this work add up to? Progress. And that progress is sorely needed, because the impacts of climate change are all around us. Its frontlines are not in boardrooms or government buildings they're in communities. And we owe it to our global community to rise to the challenge of climate change with all the innovation, empathy, and commitment we can muster.

#### **Lisa Jackson**

VP, Environment, Policy and Social Initiatives

Image /page/2/Picture/15 description: {
 "image\_description": "This image depicts a person wearing a formal outfit with a black and white patterned shirt, pearl earrings, and short wavy brown hair against a modern architectural background."
}

# <span id="page-3-0"></span>**Report highlights**

# **Reduced our overall emissions by more than 55 percent**

We reduced our overall greenhouse gas emissions across scopes 1, 2, and 3 by more than 55 percent compared with our 2015 baseline year — not including offsets.[1](#page-111-0) In that same time period, revenue grew by 64 percent. We estimate that we've avoided 31 million metric tons of emissions through reduction efforts like transitioning our supply chain to renewable electricity and sourcing recycled content.

## **Read more on [page 14](#page-13-0).**

Image /page/3/Picture/6 description: {
 "image\_description": "The image consists of a textual statement highlighting a significant advancement in product emissions reductions."
}

Innovations in design and clean energy drove dramatic reductions in greenhouse gas emissions for the fall Apple Watch lineup — the most significant from our business-as-usual scenario[.2](#page-111-0) This included 100 percent clean energy for manufacturing and product use, 30 percent recycled and renewable material by weight, and 50 percent shipping without the use of air transportation[.3](#page-111-0)

**Read more on [page 9](#page-8-0).**

Image /page/3/Picture/9 description: {
 "image\_description": "A side view of a modern smartwatch with a dark braided strap, showcasing its sleek metallic finish and digital crown."
}

# **Advocated for reporting transparency**

As part of our commitment to greenhouse gas emissions disclosures, we endorsed the landmark California Climate Corporate Data Accountability Act (CA SB 253) to improve transparency and drive progress in the fight against climate change.

**Read more on [page 71.](#page-70-0)**

# **Increased our use of recycled materials**

We're making steady progress on our journey toward using only recycled and renewable materials in our products. In 2023, 22 percent of the materials we shipped in Apple products came from recycled sources[.4](#page-111-0) This includes, 99 percent of tungsten, 71 percent of aluminum, 52 percent of cobalt, 25 percent of gold, and 24 percent of lithium in our products.[5](#page-111-0)

**Read more on [page 17](#page-16-0).**

# **MacBook Air is the first Apple product made with 50 percent recycled content**

This includes 100 percent recycled aluminum in the enclosure, 100 percent recycled rare earth elements in all magnets and, in another first for Apple, 100 percent recycled copper in the main logic board.

**Read more on [page 16](#page-15-0).**

# **More than 320 suppliers committed to renewable electricity**

As of March 2024, more than 320 suppliers have committed to sourcing renewable electricity for Apple production, representing 95 percent of our direct supplier spend. We've accelerated progress with a mandate in our Supplier Code of Conduct for all direct suppliers to transition to renewable energy in the manufacturing of Apple products.

**Read more on [page 27.](#page-26-0)**

Image /page/3/Picture/22 description: {
 "image\_description": "The image shows a smartphone interface titled 'Energy,' displaying icons for Speakers & TVs, Water, and Energy, alongside data visualizations including a grid forecast with cleaner energy hours and a textual tip about using electricity during cleaner energy times to reduce carbon emissions."
}

# **Launched Grid Forecast**

In the contiguous United States, we introduced Grid Forecast, a new tool in the Home app on Apple devices. This tool shows customers when cleaner electricity is available from the grid, empowering them with information to help reduce greenhouse gas emissions.

## **Read more on [page 30.](#page-29-0)**

# <span id="page-4-0"></span>**Goals and progress**

| Goals                                                                                                                                                                                                                   | Progress                            | Highlights                                                                                                                                                                                                                                                                               |
|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Become carbon neutral for<br>our corporate operations.                                                                                                                                                                  | Achieved                            | We achieved carbon neutrality<br>in 2020 by expanding energy<br>efficiency initiatives, sourcing<br>100 percent renewable<br>electricity for Apple facilities,<br>and investing in high-quality<br>carbon credits to offset the<br>remaining hard-to-decarbonize<br>corporate emissions. |
| Achieve carbon neutrality for<br>our entire carbon footprint<br>by 2030 — reducing related<br>emissions by 75 percent<br>compared with 2015.6                                                                           | Ongoing                             | Since 2015, we've reduced<br>emissions by over 55 percent<br>across our value chain.                                                                                                                                                                                                     |
| Transition our entire<br>value chain, including<br>manufacturing and product<br>use, to 100 percent clean<br>electricity by 2030.7                                                                                      | Ongoing                             | As of March 2024, more than<br>320 suppliers have committed<br>to use 100 renewable energy<br>for their Apple production.<br>These suppliers account<br>for 95 percent of Apple's<br>direct spend for materials,<br>manufacturing, and assembly<br>of our products worldwide.8           |
| Goals                                                                                                                                                                                                                   | Progress                            | Highlight                                                                                                                                                                                                                                                                                |
| Use only recycled and<br>renewable materials in our<br>products and packaging, and<br>enhance material recovery.                                                                                                        | Ongoing                             | In 2023, 22 percent of the<br>material we shipped in our<br>products came from recycled<br>or renewable sources, and<br>we also added titanium to our<br>priority materials list in 2023.10                                                                                              |
| Transition to 100 percent<br>recycled cobalt, tin, gold,<br>and rare earth elements<br>in select components and<br>applications by 2025.11                                                                              | Ongoing                             | In 2023, 56 percent of the<br>cobalt shipped in Apple<br>designed batteries came<br>from recycled sources.12                                                                                                                                                                             |
| Remove plastics from our<br>packaging by 2025.13                                                                                                                                                                        | Ongoing                             | Our product packaging<br>shipped in 2023 contains only<br>3 percent plastic — down from<br>21 percent in 2015.14                                                                                                                                                                         |
| Goals                                                                                                                                                                                                                   | Progress                            | Highlight                                                                                                                                                                                                                                                                                |
| Replenish all our corporate<br>freshwater withdrawals<br>in high-stress locations<br>by 2030.14                                                                                                                         | Image: Green icon labeled "Ongoing" | We’ve partnered on freshwater<br>replenishment projects resulting<br>in 31.2 million gallons of<br>volumetric water benefits.                                                                                                                                                            |
| Certify all Apple-owned data<br>centers to the Alliance for<br>Water Stewardship (AWS)<br>Standard by 2025.15                                                                                                           | Image: Green icon labeled "Ongoing" | We’ve certified five data<br>centers since 2021, and 20<br>suppliers since 2017 to the<br>AWS Standard.                                                                                                                                                                                  |
| Expand and grow supplier<br>participation in the Supplier<br>Clean Water Program,<br>prioritizing high water<br>stress locations and driving<br>participants to an average<br>50 percent water reuse rate<br>by 2030.16 | Image: Green icon labeled "New"     | Through our program,<br>we’ve supported an average<br>42 percent reuse rate<br>across our 242 participating<br>supplier facilities.                                                                                                                                                      |
| Eliminate waste sent to<br>landfill from our corporate<br>facilities and our suppliers.                                                                                                                                 | Image: Green icon labeled "Ongoing" | Our corporate facilities waste<br>diversion rate increased to<br>74 percent, driven by progress<br>at our data centers.<br>Throughout 2023, 100 percent<br>of established final<br>assembly sites maintained<br>zero-waste-to-landfill operations.                                       |

# **Emissions Materials Resources**

[Approach](#page-11-0) [Design and materials](#page-14-0) [Electricity](#page-23-0) [Direct emissions](#page-31-0) [Carbon removal](#page-34-0)

#### **[Resources](#page-37-0)**

[Approach](#page-38-0)

[Product longevity](#page-39-0) [Material recovery](#page-44-0)

[Water](#page-47-0)

#### [Zero waste](#page-51-0)

#### **[Smarter Chemistry](#page-56-0)**

[Approach](#page-57-0)

[Mapping](#page-58-0) [Assessment](#page-60-0)

[Innovation](#page-62-0)

# <span id="page-5-0"></span>[Overview](#page-6-0)

#### **[Apple 2030](#page-7-0)**

[Journey to Apple 2030](#page-10-0)

# Silver Chemistry

# **Focus on the future**

**More than 38 percent of manufacturing electricity for iPhone 15 Pro and iPhone 15 Pro Max is sourced from our supplier clean energy projects.** 

# **Environmental Initiatives**

# <span id="page-6-0"></span>**Environmental Initiatives**

# **[Apple 2030](#page-7-0)**

**Apple 2030 is our commitment to be carbon neutral for our entire carbon footprint. Our journey to 2030 is focused on first reducing our scope 1, 2, and 3 greenhouse gas emissions by 75 percent compared with 2015, and investing in high-quality carbon removal solutions for the remaining emissions.**

# **[Design and materials](#page-14-0) [Electricity](#page-23-0)[17](#page-111-0) [Direct emissions](#page-31-0) [Carbon removal](#page-34-0)**

Image /page/6/Picture/6 description: {
 "image\_description": "Side view of a modern smartwatch highlighting its buttons and a woven band attached."
}

# **[Resources](#page-37-0)**

**We aim to make durable, long-lasting products and enhance material recovery. And we're committed to stewarding water resources and eliminating waste sent to landfills.**

| Product longevity |  |
|-------------------|--|
| Material recovery |  |

**[Water](#page-47-0) [Zero waste](#page-51-0)**

Upon analyzing the provided image, it appears to depict a metallic structure resembling a keyboard or grid layout, with a green arrow pointing towards a specific segment. However, no textual or symbolic content requiring transcription to Markdown is present. Please provide further clarification or additional images if textual content exists.

# **[Smarter Chemistry](#page-56-0)**

**Through chemistry innovation and material selection, we design our products to be safer for anyone who assembles, uses, or recycles them — and to be better for the environment.**

## **[Mapping](#page-58-0) [Assessment](#page-60-0) [Innovation](#page-62-0)**

Image /page/6/Picture/15 description: {
 "image\_description": "Close-up view of a modern smartphone screen with a stylized design featuring soft gray and green elements, along with a camera cutout and buttons on the side."
}

#### <span id="page-7-0"></span>[Contents](#page-1-0) [Introduction](#page-2-0) **[Environmental Initiatives](#page-5-0)** [Engagement and Advocacy](#page-65-0) [Data](#page-75-0) [Appendix](#page-83-0) 2024 Environmental Progress Report 8

**Apple 2030**

[Journey to Apple 2030](#page-10-0) [Approach](#page-11-0) [Design and materials](#page-14-0) [Electricity](#page-23-0) [Direct emissions](#page-31-0) [Carbon removal](#page-34-0)

**[Resources](#page-37-0) [Smarter Chemistry](#page-56-0)**

# **The time for change**

**The significant emissions reductions associated with the Apple Watch lineup mark a milestone toward our 2030 goal.**

# **Apple 2030**

Image /page/8/Picture/2 description: {
 "image\_description": "The image displays text that states 'Apple 2030 Resources Smarter Chemistry.' This text appears in a standard font with a green underline under 'Apple 2030'."
}

# <span id="page-8-0"></span>**An ambitious goal for 2030: We committed to be carbon neutral for our entire carbon footprint by the end of the decade.**

# **Our journey to 2030 centers on reducing our scope 1, 2, and 3 emissions first — upstream and downstream — by 75 percent before balancing remaining emissions with high-quality carbon removals.**

We've already reduced emissions by more than 55 percent since 2015, even as revenue grew by 64 percent during that same eight-year period.

We're focused on decarbonizing the three largest sources of emissions — materials, electricity, and transportation — across our value chain. We're prioritizing efforts to drastically reduce these emissions with initiatives focused on achieving the broadest impact before applying offsets. For

emissions that can't be further reduced, we primarily look for high-quality, nature-based credits. We invest in carbon sequestration and removal projects to help us achieve carbon neutrality.

Decarbonizing our supply chain is essential to achieving Apple 2030. We've focused on innovative approaches to significantly expand renewable energy across our supply chain and manufacture our products with recycled and renewable materials.

Image /page/8/Picture/9 description: {
 "image\_description": "A collection of Apple products including a laptop, smartwatch, smartphone, and tablet, all in various colors, displayed on a white background."
}

# <span id="page-9-0"></span>**[Apple 2030](#page-7-0) [Resources](#page-37-0)**

**[Smarter Chemistry](#page-56-0)** 

# **Decarbonizing our value chain**

#### **Electricity**

Electricity for manufacturing and charging devices represents the largest source of Apple's emissions across all product lines. Achieving carbon neutrality for our entire carbon footprint requires a transition to 100 percent clean energy and significant energy reductions throughout our supplier facilities.

We launched the Supplier Clean Energy Program in 2015 to advance renewable energy throughout our manufacturing supply chain. As of March 2024, more than 320 global suppliers — representing 95 percent of Apple's direct manufacturing spend — have joined the program. These suppliers have committed to using 100 percent renewable electricity for all their Apple production by the end of this decade. The success of this initiative has led to the next phase of our efforts toward achieving a carbon neutral supply chain by 2030.

To rapidly scale and accelerate the progress of the Supplier Clean Energy Program, Apple updated the Supplier Code of Conduct to require all direct suppliers to transition to renewable energy in the manufacturing of Apple products. The codification of this requirement is the next step in our decarbonization journey and a sign of our commitment to integrate supply chain decarbonization into our core business decisionmaking. We hope that our approach can serve as a model that other companies can follow.

We're also working to address emissions from product use through investments in renewable energy so that every watt of electricity associated with our customers' product use is matched by clean electricity. We're prioritizing product efficiency to reduce the electricity use of our products.

We've also introduced Grid Forecast, a tool in the Home app that informs U.S.-based users when their power grid has cleaner energy available for use. And with iOS 16, we launched the Clean Energy Charging feature in the United States, which looks at the sources of the electricity during expected charge times and optimizes for when the grid is using cleaner energy sources like solar or wind.

### **Materials**

We've advanced toward our 2030 goal by using recycled and renewable materials, which often have a lower carbon footprint than primary materials. And we announced that, by 2025, we plan to use 100 percent recycled cobalt in all Apple-designed batteries, 100 percent recycled tin soldering, 100 percent recycled gold plating in all Appledesigned rigid and flexible printed circuit boards, and 100 percent recycled rare earth elements in all magnets across new products[.18](#page-111-0)

We've pioneered the use of many recycled materials in our products through world-class product engineering, extensive design qualifications, and supply chain engagement. Our focus is on materials that will yield significant environmental and social

impacts, even when those materials come with notable challenges to building circular supply chains. To read more about our efforts to create circular supply chains, see the [Prioritizing our efforts](#page-16-0) section. We intentionally design products to minimize the use of primary (non-recycled) materials and maximize recycled content as feasible. And year over year, we innovate and improve manufacturing processes to use materials more efficiently and decrease manufacturing scrap.

In 2023, manufacturing our products accounted for 59 percent of our gross carbon footprint. This includes emissions from fuel combustion; heating, ventilation, and air conditioning (HVAC); refrigeration; use of fluorinated gases; and other physical or chemical processes (excluding transportation). These emissions sources vary widely and require use of diverse technologies and solutions to abate.

Our approach is to identify process emissions across our supply chain, like the use of fluorinated gases in display and semiconductor manufacturing, and launch targeted programs to address these emissions in partnership with our suppliers, governments, and industry stakeholders. We continue to launch supplier programs targeting emissions from manufacturing operations and facilities used to produce Apple products, like the Supplier Energy Efficiency Program launched in 2015 to help our suppliers optimize their energy use.

## **Transportation**

In 2023, transporting our products to customers accounted for 9 percent of our gross carbon footprint. To address the emissions from transportation, we're shifting more product volume to shipping modes that are less carbon intensive than air transport, such as ocean or rail. Shipping the same Apple product by ocean generates 95 percent fewer emissions than shipping it by air, based on our carbon footprint methodology. We're investigating a transition to low-carbon sustainable aviation fuels (SAF) to reduce the carbon footprint of air shipment. We're also addressing transportation-related emissions through product and packaging design that drives reduced packaging mass and volume, creating boxes that use space more efficiently.

#### **Carbon removals**

Prioritizing emissions reductions across our entire value chain is critical to limiting climate change to 1.5°C. Still, not all emissions can be avoided or reduced with existing solutions. And some existing solutions will require greater industry and government efforts to scale before broader commercial adoption becomes feasible. As we focus on eliminating the majority of emissions across the value chain, we're also addressing emissions we can't reduce by looking for high-quality carbon credits from nature-based projects. The nature-based projects we select focus

on carbon sequestration, like planting forests and restoring mangroves, and have additional benefits that improve climate adaptation and resilience.

 Transparency and integrity are critical to the carbon projects that we fund. The credits from these investments must be additional, permanent, measurable, and quantified — with systems in place to avoid double-counting — and must avoid leakage. To read more about our work in carbon removals, see [Carbon removal](#page-34-0) and read our white paper, Apple's [Carbon Removal](https://www.apple.com/environment/pdf/Apples_Carbon_Removal_Strategy_White_Paper.pdf) Strategy.

**[Smarter Chemistry](#page-56-0)** 

# <span id="page-10-0"></span>**Journey to Apple 2030**

Image /page/10/Figure/3 description: {
 "image\_description": "This is a timeline chart titled 'Where We've Been, Where We're Going,' showcasing Apple's sustainability achievements and goals from 2015 to 2030, including initiatives like renewable energy, carbon neutrality, recycling efforts, and environmental impact reduction."
}

# <span id="page-11-0"></span>**Approach Apple 2030**

**We have an ambitious commitment and a science-based plan to reach our Apple 2030 goal. We're focused on achieving reductions wherever possible, using approaches that offer clear evidence for a way forward while seeking to catalyze industry-wide change.**

This begins with working to achieve carbon neutrality across our entire carbon footprint by 2030, setting ambitious targets to reduce our emissions by 75 percent. We prioritize carbon reductions, but for emissions that can't be mitigated using existing solutions we invest in high-quality carbon removal projects.

Our goal to be carbon neutral extends to our entire carbon footprint and is consistent with the Intergovernmental Panel on Climate Change's (IPCC) recommendation for global carbon neutrality[.24](#page-111-0)

We're also committed to working toward reaching a 90 percent reduction in emissions from our 2015 baseline by 2050. Attaining deep decarbonization will require a collective, worldwide effort. Entire industries and economies must decarbonize. And while reaching a 90 percent reduction in emissions is outside Apple's or any one company's control, we're

#### **APPLE 2030 ROADMAP**

# **Addressing Apple's carbon footprint through four pillars**

| Apple's Commitment to Emissions Reduction                                                                                                                                                                                                                                                                                                            |                                                                                                                                                                                                                                                                                               |             |                                                                                                                                                                                                                                |
|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| We've made significant progress by cutting emissions across our value chain by more than 55 percent since 2015. This started with our transition to sourcing 100 percent renewable electricity at our offices, retail stores, and data centers, which we achieved in 2018. And in 2020, we achieved carbon neutrality for our corporate emissions.25 |                                                                                                                                                                                                                                                                                               |             |                                                                                                                                                                                                                                |
| Design and Materials                                                                                                                                                                                                                                                                                                                                 | Designing products and manufacturing processes to be less carbon intensive through thoughtful material selection, increased material efficiency, greater product energy efficiency, the use of recycled and renewable materials in our products and packaging, and enhanced material recovery | Electricity | Increasing energy efficiency at our facilities, in our supply chain, and transitioning the electricity in our product value chain — including manufacturing and our customers' product use — to 100% clean electricity by 2030 |

Environmental progress can and should be good for business. We underpin our climate strategy with strong business principles and innovation while harnessing the power of markets to replicate our solutions at scale — aiming to create the impact necessary to meet global reduction targets. We're also working to accelerate the global transition toward decarbonization while exploring the next generation of solutions and advocating for stronger policies. These efforts include fostering new and strengthened collaborations in public and private partnerships and investing in technological advancements. We've issued \$4.7 billion in green bonds to model how businesses can drive investments to reduce global emissions.

Clear principles guide this work. Our emissions reduction targets are aligned with what current climate science shows is necessary to help limit warming to 1.5° C. We calculate our footprint across our value chain to include both direct and productrelated emissions — from sourcing materials through end of life. We use the results of our detailed carbon accounting to adjust our Apple 2030 roadmap, which lays out our plan to become carbon neutral. And we're committed to disclosing our carbon footprint as well as our climate strategy and progress. This means sharing both challenges and successes. Our annual Environmental Progress Report, as well as our response to the global disclosure nonprofit CDP, provide details on our progress.

Transparency and disclosure are essential not only for sharing our climate strategy and progress but also for sending clear signals and inviting others to work with us. And progress needs to include low-income and historically marginalized communities that too often bear the brunt of climate change. We're pursuing ways to directly support these communities in our climate programs. To learn more about our work, read our [feature](#page-30-0) on our Power for Impact program and our [feature](#page-74-0) on our Impact Accelerator program.

#### **APPLE'S PROGRESS TOWARD CARBON NEUTRALITY**

Image /page/12/Figure/6 description: {
 "image\_description": "The image illustrates Apple's progress towards carbon neutrality with a bar chart showing historical and projected emissions, along with specific goals for 2030."
}

To see our progress toward our 2030 goal, see our [Journey to Apple](#page-10-0) 

In our latest [Annual Green](https://s2.q4cdn.com/470004039/files/doc_downloads/additional_reports/2023/apple_greenbond_report_fy2022.pdf)  [Bond Impact Report \(PDF\)](https://s2.q4cdn.com/470004039/files/doc_downloads/additional_reports/2023/apple_greenbond_report_fy2022.pdf), we share progress on the projects funded in 2023.

[2030](#page-10-0) timeline.

Read our latest response to the [CDP](https://www.apple.com/environment/pdf/Apple_CDP-Climate-Change-Questionnaire_2023.pdf)  [Climate Change 2023](https://www.apple.com/environment/pdf/Apple_CDP-Climate-Change-Questionnaire_2023.pdf)  [questionnaire](https://www.apple.com/environment/pdf/Apple_CDP-Climate-Change-Questionnaire_2023.pdf) (PDF).

\* Error bars: We're continuously refining our methodology to improve our carbon footprint estimate. But there's inherent uncertainty in modeling product-related greenhouse gas emissions, as illustrated by the error bars in this graphic.

# <span id="page-13-0"></span>**Apple's comprehensive carbon footprint**

**In 2023, we estimate that our environmental programs avoided 31 million metric tons of emissions across all scopes. Initiatives that we've been growing for years continue to yield clear results, including sourcing 100 percent renewable energy for our facilities, transitioning suppliers to renewable energy, and using low-carbon materials in products[.26](#page-111-0) While our revenue has grown by more than 64 percent since 2015, our gross emissions have decreased by more than 55 percent.**

### **TOTAL EMISSIONS**

# **15.6 Million Metric Tons Net Greenhouse Gas Emissions\*** Emissions offset

Image /page/13/Figure/7 description: {
 "image\_description": "The image depicts a chart categorizing emission sources and reductions in a product and corporate footprint."
}

# Avoided emissions Gross emissions

- \* **Net greenhouse gas emissions** represents our total gross footprint minus carbon offsets. Percentages shown for each emissions category represent the share of Apple's gross footprint. Totals add up to more than 100 percent due to rounding.
- \*\* **Low-carbon materials** represents emissions savings from transitioning to recycled materials in our products and using low-carbon aluminum, as described on [page 33](#page-32-0).
- † **Clean energy** represents savings from clean energy procured by Apple or its suppliers.
- ‡ **Business operations** includes business travel, commute, work from home, upstream impacts from scope 1 fuels, and thirdparty cloud services.

# <span id="page-14-0"></span>**Design and materials**

**We're designing our products to be less carbon intensive by prioritizing the use of recycled content and low-carbon materials and focusing on the energy efficiency of our software and hardware. We're working toward a future where every Apple product will be created from and contribute to circular supply chains. The design and material choices we make across our products will support reducing our carbon footprint.**

# **Approach**

Innovation drives our efforts around circularity — from the materials we source and the product design choices we make to the recycling and recovery innovations we pursue. We prioritize the materials and components that account for significant portions of our greenhouse gas emissions. This means that the choices we make product by product can scale toward reducing our overall footprint. These priorities inform our work to design for material efficiency and increase our use of recycled and renewable materials.

We aim to create products that use circular supply chains to one day end reliance on mined resources while meeting our rigorous standards for quality, durability, performance, and environmental and social protections. We strive for efficiency in sourcing and utilizing materials, relying on recycled and renewable materials for our products and packaging, and reducing scrap. And we also maintain strict standards for responsibly sourcing materials from primary, recycled, and renewable sources. Another part of what makes our goals possible is the recycling innovations we're developing to enhance material recovery. We hope our actions inspire others to support building circular supply chains.

Working to positively influence the markets where we work, advocating for policy that enables circular supply chains, impacting communities worldwide, and inspiring others to follow suit — these are the opportunities that drive us through the challenging work of creating circular supply chains.

## **Prioritizing less carbon-intensive materials and components**

Focusing on those that account for significant portions of our greenhouse gas emissions

**Designing products for material efficiency** Incorporating carbon emission profiles of the materials that go into our products

**Increasing the use of recycled and renewable materials**  Ensuring their use across our products

# **Driving product energy efficiency**

Reducing energy use across our products

**Design and materials addresses emissions from:**

**Product manufacturing (Scope 3)**

**Product use (Scope 3)**

> **Product transport (Scope 3)**

# **2023 progress**

**22% recycled or renewable**

Of the materials contained in products that were shipped to stores and customers, 22 percent came from recycled or renewable sources.

**95% recycled titanium**

We introduced titanium to our priority materials list, and in our fall models of Apple Watch Ultra 2, when paired with Alpine Loop or Trail loop, we used 95 percent recycled titanium in the case.

# **58% less energy**

iMac uses 58 percent less energy than the ENERGY STAR requirement.\*

\* Energy consumption and energy efficiency values are based on the ENERGY STAR Program Requirements for Computers, including the max energy allowance for iMac. For more information, visit [www.energystar.gov](http://www.energystar.gov/). ENERGY STAR and the ENERGY STAR mark are registered trademarks owned by the U.S. Environmental Protection Agency. For more information on the power consumption of iMac, read the [Product Environmental Report](https://www.apple.com/environment/pdf/products/desktops/iMac_PER_Oct2023.pdf).

# <span id="page-15-0"></span>**Using recycled materials to lower our product carbon footprint**

We're reducing the carbon footprint of our products through the materials we select. Our strategy is to transition to materials that are manufactured using low-carbon energy and recycled content. We've prioritized the materials and components that make up a large part of our product carbon footprint to move us closer to our goal of carbon neutrality. And to accelerate collective efforts, we signed on as a founding member of First Movers Coalition's near-zero emissions primary aluminum commitment for 2030 (see more on [page](#page-69-0) 70).

Our use of aluminum exemplifies Apple's comprehensive approach: We're transitioning to recycled content, and where we haven't yet, we're moving to low-carbon suppliers and exploring technological innovations to decarbonize — like ELYSIS aluminum, which was smelted without generating greenhouse gas emissions (see [page 33\)](#page-32-0). We've continued to introduce 100 percent recycled aluminum in the enclosures of Apple products: Mac Studio now uses 100 percent recycled aluminum in its enclosure — joining Apple Watch Series 9, Apple Watch SE, iPad, MacBook Air, Mac mini, the Siri Remote, and MacBook Pro. In addition, the new iMac contains 100 percent recycled aluminum in the stand. And with iPhone 15, we've increased recycled content by using 75 percent recycled aluminum in the enclosure.

We're addressing carbon impact by how we source recycled aluminum, too. Our first priority is to recover any of our own scrap at high quality. Then, we look to other postindustrial and postconsumer sources for high-quality recycled aluminum because recycled aluminum manufacturing emits less carbon than newly mined materials. These emissions reduction efforts have reduced our aluminum-related emissions by 68 percent since 2015 and now represent less than 9 percent of our product manufacturing footprint, compared with 27 percent in 2015.

In 2023, we expanded our use of certified recycled cobalt, steel, gold, and aluminum — materials that typically have significant carbon footprints. We introduced 100 percent certified recycled cobalt for the first time in the battery of Apple Watch and iPhone[.27](#page-111-0) And we increased the content of certified recycled gold across all product lines from 4 percent in 2022 to approximately 25 percent in 2023. This includes everything from the gold plating on multiple printed circuit boards to new applications such as the USB-C connector on iPhone 15.

**TRANSITIONING TO RECYCLED CONTENT**

# **Mac Studio now uses 100 percent recycled aluminum in its enclosure**

Image /page/15/Picture/10 description: {
 "image\_description": "A photo of the Apple Mac Studio desktop computer; it features a sleek aluminum design with front-facing ports and ventilation at the bottom edge."
}

Image /page/15/Picture/11 description: {
 "image\_description": "The image displays the rear view of a computing device, showcasing various connectivity ports. It features four Thunderbolt ports, an Ethernet port, two USB-A ports, an HDMI port, and a power button. The body has a mesh-like design for ventilation."
}

# **68%**

Switching to recycled and low-carbon aluminum has decreased our greenhouse gas emissions associated with aluminum by 68 percent since 2015.

# <span id="page-16-0"></span>**Prioritizing our efforts**

We're making progress toward our goal of sourcing only recycled or renewable materials in our products: In 2023, 22 percent of the materials contained in products that were shipped to stores and customers came from recycled or renewable sources[.28](#page-111-0)

And we're on track to meet our key material goals. By 2025, we plan to:

- Use 100 percent recycled cobalt in all Apple-designed batteries.[29](#page-111-0)
- Use 100 percent recycled tin soldering and 100 percent recycled gold plating in all Appledesigned rigid and flexible printed circuit boards[.30](#page-111-0)
- Use 100 percent recycled rare earth elements in all magnets across all products[.31](#page-111-0)

Our efforts focus on 15 materials that we've prioritized based on a broad range of environmental, social, and supply chain impacts. (These are outlined in detail in our [Material Impact Profiles](https://www.apple.com/environment/pdf/Apple_Material_Impact_Profiles_April2019.pdf) white paper[.32](#page-111-0)) Some of the materials prioritized through this process include lower-mass but higher-impact materials like gold. Our priority materials include aluminum, cobalt, copper, glass, gold, lithium, paper, plastics, rare earth elements, steel, tantalum, tin, titanium, tungsten, and zinc, and they account for 87 percent of the total product mass shipped to our customers in 2023.

Maintaining our standards for recycled and renewable materials is essential to our journey to create a circular supply chain. Our Recycled and Renewable Material Specification sets requirements based on international standards for recycled content and responsible resource management. By requiring certification to these standards, we're able to confirm that a material has been recycled or comes from a renewable source — one that can continually produce without depleting the earth's natural resources. We approach materials from new sources with the same rigor, evaluating each one for the safety of the materials' chemistry. This process allows us to scale our use of materials that are better for the environment and safer for use in our products. Recycled material is certified by third parties to a recycled content standard that conforms with ISO 14021. Total recycled content numbers also include supplier reported recycled content checked by Apple but not third-party certified.

Our teams are overcoming obstacles to creating closed loop supply chains, including material performance and traceability. This is possible through our work with a diverse group of partners. For example, we were able to design an alloy containing 100 percent recycled aluminum that meets our rigorous design performance standards. And we've improved our ability to track key materials within our supply chain.

Barriers to our progress remain — including challenges within our control and those outside our direct influence. Addressing these requires a collective response. Through collaboration within the material space, we can achieve impact felt beyond our business. The supply chains we're helping create serve more than just our product needs — they help promote the availability of competitively priced, quality recycled and renewable materials across geographies.

# **Key challenges to developing circular supply chains**

#### **Technical properties**

The properties of a certain recycled or renewable materials may differ from the primary material. This needs to be accounted for during product design and manufacturing. For example, select recycled plastics differ in properties from other plastics. The composition of other recycled materials can also be impacted by some level of contamination during the recycling process.

#### **Availability and access**

The supply of recycled and renewable materials can be constrained by the limited availability of recoverable material or production of renewable content. When supply exists in some locations around the world, new suppliers need to be incorporated into supply chains for the material to be accessed.

# **Traceability**

Information about the source of materials — whether mined, recycled, or renewable — might not be readily available.

# **Scale**

Materials for a single component can come from hundreds of different suppliers, requiring exponentially more effort as we scale the use of high-quality recycled or renewable materials across components and products.

# **Regulatory barriers**

Transboundary movement regulations — created to establish critically important community and environmental protections — can have the unintended consequence of inhibiting material recovery and movement to recyclers or refiners for use in new products. To learn about our support of policies that enable circular supply chains while improving social and environmental protections, read the [Policy advocacy](#page-70-0) feature.

## <span id="page-17-0"></span>**[Apple 2030](#page-7-0)**

- **[Resources](#page-37-0)**
- **[Smarter Chemistry](#page-56-0)**

#### **PROGRESS ACROSS OUR 15 PRIORITY MATERIALS**

| Material and key challenges                                                             | Progress                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
|-----------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Aluminum<br>Regulatory barriers<br>Technical properties<br>Scale                        | • In 2023, 71 percent of the aluminum in products we shipped to customers came from recycled sources — up from 67 percent in 2022.<br>• Because recycled aluminum can have 1/40 the carbon footprint of aluminum from primary sources, this supports our pursuit of low-carbon design. Learn more about ELYSIS aluminum, which was smelted without generating greenhouse gas emissions.                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| Cobalt<br>Regulatory barriers<br>Availability and access<br>Scale                       | • In 2023, 52 percent of the cobalt shipped in our products — more than double the amount shipped in 2022 — came from certified recycled sources on a mass balance basis, including post-industrial scrap and post-consumer scrap from end-of-life batteries.<br>• In 2023, we used 100 percent recycled cobalt in the magnets within the magnetic power module of the 15-inch MacBook Air with M2 chip.<br>• In 2023, Apple committed to using 100 percent recycled cobalt in all Apple-designed batteries by 2025.                                                                                                                                                                                                                                                                                                                                |
| Copper<br>Technical properties<br>Supply chains<br>Scale                                | • In 2023, we introduced 100 percent recycled copper in the fin stack of the heat sink for 16-inch MacBook Pro, which helps regulate thermal performance.<br>• For iPhone, we introduced 100 percent recycled copper foil in the MagSafe inductive charger, and we're exploring how to use recycled copper in other thermal applications.<br>• In 2023, we introduced 100 percent recycled copper wire in the Taptic Engine in our iPhone 15 lineup, Apple Watch Series 9, and Apple Watch Ultra 2.<br>• Copper is a key material in printed circuit boards. Since first introducing 100 percent recycled copper foil in iPad (10th generation) in October 2022, we've used 100 percent recycled copper foil in the main logic boards in the iPhone 15 lineup, Apple Watch Series 9, Apple Watch Ultra 2, and in October 2023, 16-inch MacBook Pro. |
| Glass<br>Technical properties<br>Availability and access<br>Scale                       | • The display panel and trackpad glass of MacBook Air with M3 contains 15 percent recycled glass.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| Gold<br>Regulatory barriers<br>Traceability<br>Scale                                    | • In 2023, our use of recycled gold increased to about 25 percent across all product lines — up from 4 percent in 2022.<br>• We also expanded our use of 100 percent certified recycled gold to the plating of multiple printed circuit boards and the USB-C connector in iPhone 15 — a first for Apple.<br>• We're committed to using 100 percent recycled gold plating in all Apple-designed rigid and flexible printed circuit boards by 2025. All gold in Apple products is responsibly sourced, whether it's primary or recycled. For more information, see our Conflict Minerals Report.                                                                                                                                                                                                                                                      |
| Lithium<br>Regulatory barriers<br>Availability and access<br>Scale                      | • In 2023, 24 percent of the lithium, allocated using mass balance, shipped in our batteries came from certified recycled sources, including post-industrial scrap and post-consumer scrap from end-of-life batteries — a first for Apple.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Material and key challenges                                                             | Progress                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| Plastics<br><i>Technical properties<br/>Availability and access<br/>Scale</i>           | • We're transitioning from fossil fuel–based plastics to renewable or recycled alternatives. In 2023, we included renewable plastic in the Apple Watch Series 9 speaker — a first for Apple — and we use 25 percent recycled plastic in multiple components.<br>• For Mac Pro, over 20 components are made with 35 percent or more recycled plastic.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| Rare earth elements<br><i>Regulatory barriers<br/>Availability and access<br/>Scale</i> | • More than 75 percent of the total rare earth elements that Apple shipped in products in 2023 came from certified recycled sources.<br>• Compared with earlier products, our latest devices contain greater percentages of recycled rare earth elements: 100 percent in iPhone 15,37 99 percent in our Apple Watch lineup, and 98 percent in our MacBook lineup. We're committed to using 100 percent recycled rare earth elements in all magnets across all products by 2025.38                                                                                                                                                                                                                                                                                                                                                                   |
| Steel<br><i>Regulatory barriers<br/>Technical properties<br/>Scale</i>                  | • We work with our supply chain partners to recover high-purity steel from our manufacturing scrap and our products at end of life.<br>• In 2023, we continued the use of 90 percent recycled steel in the battery tray of the 15-inch MacBook Air with M2 and expanded the use of this material in the 13-inch MacBook Air with M3 in the battery tray, keyboard feature plate, and trackpad beam plate.                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Tantalum<br><i>Regulatory barriers<br/>Availability and access<br/>Supply chains</i>    | • We're actively investigating recovery approaches from end-of-life electronics to develop further use of recycled material for capacitors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| Tin<br><i>Scale</i>                                                                     | • In 2023, we used 40 percent recycled tin on average across all product lines — up from 38 percent in 2022.<br>• In previous years, we expanded the use of recycled tin to many flexible printed circuit boards across many products. As we continue to scale use across even more components, we seek to engage an exponentially increasing number of suppliers in this effort.<br>• We've also committed to using 100 percent recycled tin soldering in all Apple-designed rigid and flexible printed circuit boards by 2025.39                                                                                                                                                                                                                                                                                                                  |
| Titanium<br><i>Availability and access<br/>Scale</i>                                    | • In 2023, Apple Watch Ultra 2, when paired with Alpine Loop or Trail loop, contained 95 percent recycled titanium in the enclosure.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| Tungsten<br><i>Regulatory barriers</i>                                                  | • More than 99 percent of the tungsten used in 2023 came from recycled sources, up from 95 percent in 2022.<br>• In 2023, all released iPhone 15 models featured 99 percent recycled tungsten across the entire device, and all released Apple Watch models featured 100 percent recycled tungsten across the entire device.40<br>• Our disassembly robots, Daisy and Dave, and our recycling machine, Taz, helped recover and recycle the tungsten from the Taptic Engine.                                                                                                                                                                                                                                                                                                                                                                         |
| Zinc                                                                                    | • Mac Studio contains 100 percent recycled copper and zinc in the brass prongs of the power cord plug and AC inlet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |

Technical properties Supply chains

**Text:** "Paper"

# <span id="page-18-0"></span>**Increasing recycled content in our products**

We're progressing toward our goal of relying solely on responsibly sourced recycled or renewable materials for our products and packaging. The source of the materials we rely on matters to us — we value materials that don't deplete the earth's resources.

In 2023 we accomplished the following first-time material achievements:

- In Apple Watch Ultra 2, when paired with Alpine Loop or Trail loop, we used 95 percent recycled titanium in the enclosure.
- Across our iPhone 15 lineup, we used 100 percent recycled gold in the USB-C connector and in the wire of all cameras.
- Across our iPhone 15 lineup, we used 100 percent recycled copper wire in the Taptic Engine and 100 percent recycled copper foil in the main logic board and MagSafe inductive charger.
- In the iPhone 15 lineup, Apple Watch Series 9, and Apple Watch Ultra 2, we used 100 percent recycled cobalt in the battery.[41](#page-111-0)

**These and other innovations helped us increase our use of recycled and renewable content to 22 percent of all the material shipped in products in 2023[.42](#page-111-0)**

## **RECYCLED MATERIALS**

# **Our transition to certified recycled materials by product line**

|                                       | 2017                                               | 2019                                               | 2021                                               | 2023†                                              |
|---------------------------------------|----------------------------------------------------|----------------------------------------------------|----------------------------------------------------|----------------------------------------------------|
| Titanium                              | ○                                                  | ○                                                  | ●                                                  | ●                                                  |
| Cobalt                                | ○                                                  | ○                                                  | ●                                                  | ●                                                  |
| Copper                                | ○                                                  | ○                                                  | ●                                                  | ●                                                  |
| Zinc                                  | ○                                                  | ○                                                  | ●                                                  | ●                                                  |
| Steel                                 | ○                                                  | ○                                                  | ●                                                  | ●                                                  |
| Gold                                  | ○                                                  | ●                                                  | ●                                                  | ●                                                  |
| Tungsten*                             | /                                                  | /                                                  | /                                                  | /                                                  |
| Rare earth elements                   | ○                                                  | ●                                                  | ●                                                  | ●                                                  |
| Aluminum                              | ○                                                  | ●                                                  | ●                                                  | ●                                                  |
| Tin                                   | ○                                                  | ●                                                  | ●                                                  | ●                                                  |
| Plastic                               | ●                                                  | ●                                                  | ●                                                  | ●                                                  |
| Products launched<br>by calendar year | Apple Watch<br>Desktop<br>Laptop<br>iPad<br>iPhone | Apple Watch<br>Desktop<br>Laptop<br>iPad<br>iPhone | Apple Watch<br>Desktop<br>Laptop<br>iPad<br>iPhone | Apple Watch<br>Desktop<br>Laptop<br>iPad<br>iPhone |

- All products launched in the calendar year include certified recycled content.
- Some products launched in the calendar year include certified recycled content.
- No products launched in the calendar year include certified recycled content.
- In calendar year 2023, we did not launch new models of iPad.
- Recycled content is not
- \* Material is considered "not applicable" if it's found only in trace amounts dispersed across modules.

#### **Responsible sourcing of materials**

We require our suppliers to source our materials responsibly,for both primary and recycled materials. Our [Standards for Responsible Sourcing of Materials](https://www.apple.com/supplier-responsibility/pdf/FY23-Supplier-Code-of-Conduct-and-Supplier-Responsibility-Standards.pdf#page=192) are based on leading international guidance, including the United Nations Guiding Principles on Business and Human Rights and the Organisation for Economic Co-operation and Development (OECD) Due Diligence Guidance for Responsible Supply Chains of Minerals from Conflict-Affected and High-Risk Areas. In 2023, 100 percent of the identified tin, tantalum, tungsten, gold (3TG), cobalt, and lithium smelters and refiners in Apple's supply chain completed assessments to verify compliance with our standards.

We work with third-party audit programs at an industry-wide level to identify environmental and social, and governance risks at the smelter, refiner, and mining levels. We map other materials in our products — such as mica, copper, graphite, and nickel — and, before production, evaluate suppliers of new materials for compliance with our requirements. We also map, conduct additional due diligence, and facilitate third-party audits on other materials used in our products, such as graphite, nickel, and copper. As we build supply chains for recycled materials, we partner with the smelters and refiners that are able to meet and maintain our standards.

#### **Industry collaboration**

As we focus on responsible sourcing and the use of recycled content, we continue to drive progress in our broader industry through multiple initiatives. These include our role on the steering committee of the Responsible Minerals Initiative (RMI). This coalition is one of the most commonly used resources for companies working to address mineral sourcing issues in their supply chains. We are a supporter of the First Movers Coalition for Aluminum, whose focus is to aggregate demand signals for low-carbon technologies and materials.

Using recycled and renewable materials helps lower our carbon footprint, moving us closer to our climate goals. To fulfill the transition to these materials, we're working with policymakers to support international standards that enable the use of these materials globally.

# **Improving material and manufacturing efficiency**

Making our manufacturing processes more efficient creates less waste and helps us make the most of the materials that we source. We're also designing our products and packaging so that they require less material in the first place, helping reduce emissions from transporting and processing materials.

For example, in 2023, we redesigned all packaging for Apple Watch Series 9 and Apple Watch SE models to introduce a new compact design that allows for 25 percent or more devices per shipment. And as we progress toward our 2030 carbon neutrality goal, we're investigating new materials and new ways to manufacture efficiently.

We've prioritized improving the carbon footprint of the integrated circuits that we use in our products as they're carbon intensive. We've also continued our work with the sustainable semiconductor technologies and systems research program of imec, a world-leading research and innovation hub in nanoelectronics and digital technologies. We have two goals in this collaboration: to improve the carbon footprint models associated with leading nodes of integrated circuit production, and to use these models to identify carbon reduction opportunities for the entire integrated circuits industry.

We're also exploring opportunities for improved efficiency across our product manufacturing processes. In 2023, we continued to invest in research and development projects aimed at creating less waste in processing materials, reducing machining time and associated energy use, more efficiently transforming material into near-net shapes, and maximizing the recovery and reprocessing of manufacturing scrap. Once these improved processes are successfully developed, we plan to work with our suppliers as they deploy them at scale at their facilities.

Apple is committed to setting strict standards for responsible sourcing of the materials used in our products. For more information, read our [People and](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [Environment in Our Supply](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [Chain 2024 Annual](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [Progress Report](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report) and our [Conflict Minerals Report.](http://www.supplychainreports.apple/Apple-Conflict-Minerals-Report)

<span id="page-20-0"></span>Product energy use accounts for 29 percent of our gross carbon footprint — and for this reason, we work to reduce our products' energy usage. We approach this challenge in the earliest phases of design, taking a holistic view of each product from how efficiently the software operates to the power requirements of individual components.

With each generation of products, we strive to improve energy efficiency. For example, the transition to Apple silicon on Mac devices continues to drive these improvements, including:

- Our pro chips released in 2023 enabled more Mac devices to run with improved energy efficiency. Mac mini with M2 made progress in reducing energy use in 2023.
- And Apple TV 4K is designed to minimize its impact on the environment, using nearly 30 percent less power than the previous generation while achieving more powerful performance.[43](#page-111-0)
- The efficiency gains of the A15 Bionic chip eliminate the need for an internal fan, resulting in a more compact design and contributing to a 25 percent reduction in carbon footprint over the previous generation.

We've cut overall product energy use across all major product lines by more than 70 percent since 2008.[44](#page-111-0) And Apple products are consistently rated by ENERGY STAR, which sets specifications that reflect the 25 percent most energy-efficient devices on the market. In 2023, all eligible Apple products continued to receive an ENERGY STAR rating for superior energy efficiency[.45](#page-111-0) And in 2023, all eligible Apple products met requirements for EPEAT registration, another environmental rating system for electronic products that considers energy efficiency and a number of other environmental topics[.46](#page-111-0)

#### **PRODUCT ENERGY EFFICIENCY**

**We've cut overall product energy use across all major product lines by more than 70 percent since 2008[47](#page-111-0)**

Image /page/20/Picture/11 description: {
 "image\_description": "A minimalist aluminum computer case featuring the Apple logo prominently displayed on the top surface."
}

**Mac mini** Uses 72 percent less energy than the ENERGY STAR requirement[48](#page-112-0)

It seems the image provided depicts the rear view of an iPhone with its Apple logo centered on the back. The phone appears to be light green in color and features two camera lenses as part of its design. However, no text is visible in the image to convert or reproduce in markdown format.

**iPhone 15**  Uses 47 percent less energy than the U.S. Department of Energy's requirements for battery charger system[s49](#page-112-0)

**Apple TV 4K** 

Designed to use nearly 30 percent less power than the previous generation while achieving more powerful performanc[e50](#page-112-0)

Image /page/20/Picture/17 description: {
 "image\_description": "The image depicts a square device in black color with rounded edges. It features a centralized Apple logo on its surface and represents Apple's design style for hardware products."
}

# <span id="page-21-0"></span>**FEATURE Reducing plastic and waste through packaging innovation**

# **We're closing in on our goal to remove plastics from our packaging by transitioning to 100 percent fiber-based packaging by 2025[.51](#page-112-0)**

Along our journey, we've addressed many packaging components that typically rely on plastic, including large product trays, screen films, wraps, and foam cushioning. We've replaced each with fiber-based alternatives and implemented innovative alternatives to the small uses of plastics across our packaging — like labels and lamination. At the same time, we're taking steps to ensure that our packaging is recyclable and that the fiber we source comes from recycled sources or responsibly managed forests.

In 2023, we accomplished the following:

- Released multiple product lineups with over 95 percent fiber-based packaging, including iPhone 15, Mac, iPad Pro, Watch, and Beats.[52](#page-112-0)
- Released our first 100 percent fiber-based packaging in our fall Apple Watch lineup.
- Shipped Apple Vision Pro with 100 percent fiber-based packaging in 2024.

We've also continued our work to address the remaining plastic in the smaller parts of our packaging, like labels and lamination, with the packaging innovations focused on printing directly on boxes and using overprint varnish. This year, we've expanded our efforts to include MacBook Pro, MacBook Air, Mac Studio, Mac Pro, and Mac mini.

In 2022, we introduced these innovations for iPhone, iMac, iPad, and Apple Watch. That same year, we also introduced digital printing directly on the back of boxes for iPhone 14 and iPhone 14 Pro to eliminate the need for labels[.53](#page-112-0) We did this by developing a custom high-resolution printer that can print on demand at manufacturing facilities where our products are packaged. And in 2023, we broadened our approach to include all newly released iPhone, iPad, Apple Watch, and MacBook models.

**PACKAGING FIBER AND PLASTIC FOOTPRINT\* (METRIC TONS)**

# **Our goal is to transition to 100 percent fiber-based packaging by 2025\*\***

Image /page/21/Figure/14 description: {
 "image\_description": "This figure compares the material composition between 2015 and 2023 to illustrate an 18% decrease in plastic usage, highlighting increased use of recycled and responsibly sourced virgin fibers."
}

62% Recycled fiber 35% Responsibly sourced virgin fiber†

3% Plastic

- \* In 2022, we expanded our packaging goal boundary to better reflect our impact, resulting in an increase of about 36 percent of our total packaging mass, relative to fiscal year 2021. We include retail bags, all finished goods boxes (including plastic content in labels and in-box documentation), packaging sent to our customers as part of Apple Trade In, AppleCare packaging for whole units and service modules (with the exception of plastics needed to protect items from electrostatic discharge), and secondary packaging of Apple products and accessories sold by Apple. Our goal boundary does not include the inks, coatings, or adhesives used in our packaging. In addition to our packaging footprint, we also calculate the fiber used at our corporate facilities. In fiscal year 2023, this number was 1100 metric tons.
- \*\* By 2025, we plan to remove plastic from our packaging by transitioning to 100 percent fiber-based packaging. Our goal to remove plastic from packaging includes retail bags, all finished goods boxes (including plastic content in labels and in-box documentation), packaging sent to our customers as part of Apple Trade In, AppleCare packaging for whole units and service modules (with the exception of plastics needed to protect items from electrostatic discharge), and secondary packaging of Apple products and accessories sold by Apple. Our goal does not include the inks, coatings, or adhesives used in our packaging. We plan to remove plastic from the packaging of refurbished Apple products to 100-percent fiber based by 2027, once old product packaging designs are phased out. We will continue selling existing inventory of AppleCare packaging for whole units and service modules that contain plastics for vintage and products at end of life until it is consumed. This change will enable us to avoid waste generated by re-packaging goods in new 100 percent fiberbased packaging.
- † Responsible sourcing of fiber is defined in [Apple's Responsible Fiber Specification \(PDF\)](https://www.apple.com/environment/pdf/Apple_Sustainable_Fiber_Specification_April2016.pdf).

<span id="page-22-0"></span>Apple's packaging design guidelines factor in packaging recyclability, requiring the use of fiberbased materials that can break down to pulp as part of mixed-paper recycling streams, alongside materials like cereal boxes[.54](#page-112-0) We test our packaging to standards developed by independent industry and research organizations — including Western Michigan University, the U.S. Forest Service's Forest Products Laboratory, and the Confederation of European Paper Industries — and we continue to monitor evolving international packaging standards.

As we continue to reduce plastic in our packaging, we make sure that our wood, bamboo, and bagasse fibers are certified by standards such as FSC, PEFC, and Bonsucro. And since 2017, all the wood fiber used in our packaging comes from either certified recycled sources or responsibly managed forests. Through partnerships with The Conservation Fund and World Wildlife Fund, we've protected, and improved forest management practices on, more than one million acres of working forests in the U.S. and China. In 2023, these forests generated enough responsibly sourced fiber to balance all the virgin fiber in our packaging while contributing to the global supply of responsibly sourced fiber.[55](#page-112-0)

Image /page/22/Figure/4 description: {
 "image\_description": "The image illustrates an Apple Watch packaging designed for sustainability, utilizing 100% fiber-based materials with a commitment to achieving a plastic-free packaging by 2025. The packaging features innovative design elements that align with this eco-friendly initiative."
}

**100%** Our fall Apple Watch lineup packaging is 100 percent fiber based, a milestone toward our commitment to remove plastic from

packaging by 2025.

# <span id="page-23-0"></span>**Electricity**

**Our energy efficiency efforts extend across our work, from initial design through manufacturing and beyond. Achieving efficiency across our footprint is essential to meeting our 2030 carbon neutrality goal. We've achieved 100 percent clean electricity across our operations, and we're working toward the same for our manufacturing supply chain and use of Apple products. By using clean electricity in place of fossil fuels, we're contributing to cleaner air and lowering greenhouse gas emissions.**

# **Approach**

We continue to focus on energy efficiency in our operations and bringing new renewable electricity projects online worldwide. In the long term, we believe that these projects provide more cost-effective energy.

## **Managing energy use and efficiency potential**

Designing, operating, and maintaining our facilities to reduce our operational impact, and auditing across our operations and supply chain to drive efficiency by conserving and reducing energy use

## **Using 100 percent renewable electricity for our corporate operations**

Continuing to generate and source the electricity for our data centers, retail stores, and offices, as we have since January 2018

## **Transitioning our supply chain to renewable energy**

Making progress toward transitioning our entire manufacturing supply chain, as well as supporting suppliers in adopting renewable energy technologies and helping drive environmental action in our suppliers' regions

## **Focusing on product use**

Increasing our products' energy efficiency to drive down emissions from product use, and taking steps to address the emissions that remain

**Seeking renewable sources with positive impact** Prioritizing energy supply options that achieve positive environmental and social benefits

**Energy efficiency and renewable electricity addresses emissions from:**

**Indirect emissions (Scope 2)**

**Product manufacturing (Scope 3)**

**Product use (Scope 3)**

# **2023 progress**

**36M kWh**

In 2021, Apple deployed a proprietary server design focused on energy and computing efficiency that added an additional 36 million kilowatt-hours.

# **1.7M MTCO2e**

More than 100 supplier facilities participated in our energy efficiency program, achieving more than 2 billion kilowatt-hours of electricity savings and over 2,200,000 MMBtu in additional energy savings, which together avoided nearly 1.7 million metric tons of CO2e.

Image /page/23/Picture/24 description: {
 "image\_description": "Text in black font `100% clean energy` rendered on a white background"
}

Codified our 100 percent clean energy mandate in the Supplier Code of Conduct, requiring all direct suppliers to transition to renewable energy for the manufacturing of Apple products.

# <span id="page-24-0"></span>**Operating Apple facilities efficiently**

Our data centers, retail stores, and offices all source 100 percent renewable electricity, and we remain focused on implementing energy reduction measures across our facilities. We assess natural gas and electricity usage at each of these site types — as well as research and development facilities — auditing how we perform and using best practices for energy management to reduce our loads. And we design our new buildings around occupants' and lab users' specific needs, enabling us to use our facilities efficiently and productively.

**Existing buildings:** We have significant opportunities to save energy in retrocommissioning buildings that Apple already occupies or operates, including energy-intensive facilities like data centers. We audit the performance of buildings around the world, then deploy energy efficiency measures. Retrocommissioning focuses on building controls to optimize energy use and operational efficiency. We're prioritizing reducing natural gas usage and replacing natural gas equipment with electrical. We're focused on reviewing and benchmarking our most natural gas–intensive buildings to look for reduction and fuel switching opportunities.

**Data centers:** Data centers are traditionally energy intensive, requiring significant resources to cool heat-generating servers and IT equipment. That's why we're continuously monitoring and improving the controls for our cooling systems. This retrospective view often enables us to increase the cooling capacity of our existing facilities, thereby maximizing the number of servers within our data center footprint.

In 2023, we continued to see energy savings at data centers. A proprietary server design we deployed in 2021 that focused on energy and computing efficiency resulted in an additional 36 million kilowatt-hours per year in energy savings.

**New facilities:** When designing new facilities, or renovating existing facilities, we evaluate each major system to ensure we're managing our energy footprint. We select LED fixtures and install sensors and photocells to reduce light levels based on occupancy and the level of natural daylight. We install high efficiency heating and cooling systems and transformers to reduce energy consumption from our plug loads. We take special attention to ensure we're designing safe, productive spaces, while still prioritizing energy savings. We also prioritize efficient compressed dry air systems and variable air volume fume hoods for our R&D spaces.

**Retail stores:** We continue to prioritize energy efficiency and develop comprehensive energy models for stores so that we can ensure our design is aligned with our energy efficiency targets. We've also decarbonized even further by phasing out natural gas so that we're not reliant on fossil fuels.

**Measurement and accountability:** Measurement is critical to maintaining building energy performance. We have a well-developed system of energy tracking and benchmarking, which includes data from utility meters that continuously monitor 15-minute electricity and daily natural gas energy consumption. This method helps us identify opportunities for performance improvement. This early knowledge enables us to restore building system efficiencies and actively manage our energy footprint.

In 2023, our energy efficiency program avoided 41 million kilowatt-hours of electricity, which includes savings from the efficient servers, and 100,500 therms of natural gas through adjustments made to 6.7 million square feet of new and existing buildings[.56](#page-112-0) Together, these recent initiatives will avoid an additional 27,000 metric tons of CO2e per year. Combined with ongoing energy savings from past years, and accounting for effective useful lifetime of legacy savings, we saved over 75,000 metric tons of CO2e in 2023.[57](#page-112-0)

Image /page/24/Picture/12 description: {
 "image\_description": "A photograph of a server room in Apple's Reno data center, depicting rows of server racks organized neatly and a person walking in the background carrying equipment, highlighting the facility's management and layout."
}

Apple's Reno data center, opened in 2012, takes advantage of the mild climate by cooling its servers with outside air whenever possible.

<span id="page-25-0"></span>The manufacturing of Apple products accounts for 59 percent of our gross carbon footprint. To address this impact, we collaborate closely with our suppliers to prioritize energy reductions. Together, we work to use clean energy as efficiently as possible at every point in our supply chain, supporting the creation of more efficient factories all over the world. The Supplier Energy Efficiency Program, launched in 2015, helps our suppliers optimize their energy use. Implementing energy efficiencies reduces the energy intensity of manufacturing, which translates to reduced greenhouse gas emissions.

We provide technical and planning support to suppliers as they build more energy-efficient systems. We support our suppliers by helping them recognize optimization opportunities and identify solutions through energy assessments. To assist with implementation, we connect suppliers to extensive education and training opportunities including technical assistance resources — and help them access external funding for energy efficiency projects.

Our suppliers have successfully implemented a range of energy efficiency projects, from installing light sensors and implementing free cooling systems to making boiler and HVAC system energy improvements.

We launched the Asia Green Fund in 2019 to help provide technical expertise and finance capitalintensive energy efficiency projects. As green financing mechanisms remain integral to the Supplier Energy Efficiency Program, we're exploring new approaches that connect suppliers to external funding for energy efficiency projects while scaling the program and accelerating reductions.

In 2023, more than 100 supplier facilities participated in our energy efficiency program, achieving more than 2 billion kilowatt-hours of electricity savings and more than 2,200,000 MMBtu in additional energy savings. Together, we estimate that this avoided nearly 1.7 million metric tons of CO2e, representing a 25 percent increase since 2022.

# **Clean electricity**

## **Maintaining 100 percent renewable electricity for Apple facilities**

Our retail stores, data centers, R&D facilities, and offices around the world currently source 100 percent renewable electricity. We've focused our efforts to source renewables around several key pillars:

- Creating new renewable energy projects
- Undertaking projects that deliver clear benefits to local communities
- Supporting renewable energy innovations

#### Creating new projects

Apple-created renewable sources account for about 91 percent of the renewable electricity that our facilities use — currently around 1.6 gigawatts.

New renewable electricity projects require investment. Apple projects include the following funding approaches:

#### • **Direct ownership**

(~8 percent of Apple-created projects) We build our own projects — including solar, biogas fuel cells, and low-impact hydro projects — to provide renewable electricity, where feasible.

• **Equity investment**

(~4 percent of Apple-created projects) We invest capital in new solar PV or wind projects in some markets, matching the renewable energy generated with our energy use.

#### **• Long-term renewable energy contracts**

(~88 percent of Apple-created projects) Through long-term power purchase agreements, virtual power purchase agreements, and other forms of long-term commitments, we help support new, local, and primarily solar PV and wind projects in line with our renewable energy–sourcing standards.

To address gaps in our renewable energy needs beyond what's provided by Apple-created projects, we directly purchase renewable electricity through available utility green energy programs — about 5 percent of our total corporate load in 2023. Colocation and distribution facility vendors supply about 3 percent of our total load of renewable energy. And in certain situations, we purchase renewable energy certificates (RECs)[.58](#page-112-0) These RECs, which account for about 2 percent of our total load, share the same power grid as the Apple facility they support, where available. These purchases are subject to the same standards as our Apple-created renewable energy projects. [Appendix A](#page-84-0) provides additional details on Apple's renewable energy solutions.

#### **Supporting social impact** our facilities use.

Our Power for Impact program, which launched in 2019, continues to help provide local communities with needed energy resources. With funding from Apple, local communities and organizations benefit from access to cost-effective renewable energy. Apple is currently supporting more than 20 renewable electricity projects around the world, including in the Philippines, Thailand, and South Africa. Read more about Power for Impact on [page](#page-30-0) 31.

# **1.7M**

We estimate that suppliers in our Supplier Energy Efficiency Program avoided nearly 1.7 million annualized metric tons of supply chain greenhouse gas emissions in 2023.

# **91%**

Apple-created renewable sources account for about 91 percent of the renewable electricity that

# <span id="page-26-0"></span>**Transitioning our suppliers to renewable electricity**

The electricity that our manufacturing suppliers use represents the largest single source of greenhouse gas emissions throughout our manufacturing supply chain. That's why our efforts to facilitate our entire supply chain's transition to 100 percent renewable electricity are essential to reaching our 2030 carbon neutrality goal.

Our Supplier Clean Energy Program (CEP) helps enable suppliers' transition to renewable electricity by advocating for policy changes, providing information and access to renewable energy procurement options, and creating engagement opportunities with renewable energy experts. By engaging in this program, our suppliers can implement best practices in advocating for and procuring renewable energy across their corporate operations, including those associated with Apple production. The program also equips them to share lessons learned with other partners throughout their value chains, extending benefits beyond the scope of Apple.

#### **PROCUREMENT MECHANISMS**

# **Supplier renewable energy procurement mechanisms**

Our suppliers are implementing clean energy solutions using a variety of contracting mechanisms. In 2023, suppliers relied mostly on renewable energy certificates (RECs) to meet their CEP commitments, largely due to the expansion of China's Green Energy Certificate (GEC) and the recognition of GECs as a primary instrument for tracking renewable energy consumption. Apple views the strategic use of well-designed REC programs as an important interim solution to longer-term procurement options like power purchase agreements (PPAs), which are becoming increasingly available across the globe, and is working closely with its supply chain on their longer-term transitions.

#### **TECHNOLOGIES**

# **Supplier renewable energy technologies**

We work with our suppliers to select projects with the greatest potential for impact and with a clear carbon, ecological, and social benefit. "Other technology" includes clean energy sources such as some forms of biomass, geothermal, and small-scale, low-impact hydro[.59](#page-112-0)

Image /page/26/Figure/12 description: {
 "image\_description": "The provided image contains two donut-style pie charts compared side by side. The left chart breaks down renewable electricity acquisition with sections labeled: 1% onsite renewable electricity, 25% renewable power purchases, 8% direct investments, and 66% renewable energy certificates. The right chart details renewable energy production technology shares, showing 37% solar, 44% wind, and 19% other technologies."
}

As of March 2024, more than 320 suppliers have committed to use renewable electricity for their Apple production. These suppliers make up 95 percent of Apple's direct spend for materials, manufacturing, and assembly of our products worldwide. And this represents more than 21 gigawatts of clean energy commitments, of which 16.5 are already operational. To rapidly scale the Supplier Clean Energy Program and accelerate progress to Apple 2030, we've since formalized the Clean Energy Program in the Apple Supplier Code of Conduct, requiring our entire direct manufacturing supply chain to use 100 percent renewable electricity for all Apple production before 2030.

In 2023, the 16.5 gigawatts of renewable energy procured by suppliers and online in Apple's supply chain generated 25.5 million megawatt-hours of clean energy, avoiding 18.5 million metric tons of greenhouse gas emissions — a 6.5 percent increase over 2022.

#### **How suppliers are responding**

Despite growing momentum and advocacy for renewables, transitioning to 100 percent renewable electricity presents challenges: technical and regulatory barriers, the need for capital investment, and a lack of access to high-quality and costeffective solutions. Long-standing energy policies and infrastructure that incentivize the use of fossil fuels like coal can make it difficult to bring new renewable energy online in certain regions. In some cases, our suppliers are prompted to rely

on less impactful interim solutions, like one-time purchases of energy attribute certificates from existing renewable energy projects. These options represent an annual cost for buyers and often offer little opportunity for cost savings or a return on investment. To overcome these challenges, suppliers are using new purchasing methods, creating renewable energy businesses, and even participating in some of the world's largest and most innovative renewable energy deals. Suppliers are also adapting to changing renewable energy markets by finding new solutions, including first-of-their-kind procurement structures in geographies that are introducing more corporate procurement options.

In China, this includes the Green Power Trading program, which allows cross-provincial agreements that provide suppliers with more options. South Korea has expanded its options for green power, including power purchase agreements and the ability to purchase renewable energy certificates. Japan has also introduced new renewable energy options, including virtual and physical power purchase agreements and price-competitive nonfossil certificates that have the potential to scale access to renewable energy across the market. While we've seen progress in key markets, we continue to advocate for policies that enable renewable energy to compete fairly with fossil fuels and subsidized power rates, opening more avenues for our suppliers to transition to sourcing 100 percent renewable electricity (see [page](#page-70-0) 71).

## **How we support our suppliers**

#### **Galvanizing internal champions**

We've been able to quickly scale the Supplier Clean Energy Program by involving teams across Apple in supplier engagement, including supplier-facing Apple employees. We empower these employees with the tools to help speed a supplier's transition to 100 percent renewable electricity. Data and transparency drive this process. We track the electricity use and renewable procurement of all our direct suppliers, including those who are just beginning to learn about renewable electricity and those well on their way to using 100 percent renewable electricity. We help our suppliers measure progress and gain access to solutions. We've also continued to develop internal trainings and an engagement process for Apple employees and suppliers. By connecting our suppliers with resources and providing transparency on supplier progress, our teams are scaling impact across our supply chain.

**SUPPLY CHAIN CLEAN ENERGY PROGRESS**

# **Renewable electricity operational and committed in gigawatts (GW)**

Image /page/27/Figure/13 description: {
 "image\_description": "A horizontal bar chart displays energy capacity data categorized as operational versus committed across fiscal years 2016 to 2023, measured in Gigawatts (GW)."
}

#### **Supporting supplier capacity**

We share the knowledge we've gained through our own transition to 100 percent renewable energy with our suppliers, supplementing their efforts to identify and pursue opportunities to decarbonize as their businesses evolve. For this reason, we invest heavily in providing education and training across our supply chain through platforms such as our Clean Energy Academy, which includes advanced and customized trainings and workshops with leading experts.

In 2023, nearly 300 supplier facilities in China mainland and Taiwan participated in our Clean Energy Academies, which were attended by renewable energy developers and other industry guest speakers. The academies offer updates on available energy procurement options in suppliers' markets, help suppliers prepare to participate in upcoming renewable energy pilots, and provide implementation guidance from local experts. This program supplements our Clean Energy Portal, available to all supplier facilities, which provides training materials, resources, and country-specific information to guide suppliers in their transition to 100 percent renewable electricity.

Also in 2023, we announced plans to support the creation of a first-of-its-kind public training platform that will be available to businesses across many different industries, giving companies of all sizes in Apple's supply chain and beyond — access to the resources and advocacy networks we've cultivated for nearly a decade. We've partnered with the Clean

Energy Buyers Institute (CEBI) and other corporations to launch the inaugural Clean Energy Procurement Academy — a shared training curriculum and delivery process — which will equip companies with the technical readiness to advance clean energy procurement, address scope 3 emissions, and decarbonize global supply chains.

Additionally, we support the creation and growth of renewable energy industry associations that our suppliers can join to learn about local opportunities, such as the Japan Climate Leaders Partnership and Clean Energy Buyers Association.

#### **Expanding access to renewable electricity**

To support our suppliers' transition to renewable electricity, we help them find high-quality solutions so they can decide how best to address their specific needs.

- **The China Clean Energy Fund:** This fund enables Apple and our suppliers to invest in renewable energy. As of March 2024, the fund has invested in more than 1 gigawatt of renewable electricity projects.
- **Power purchase agreements (PPAs):** Apple will continue to support the global development of high-quality programs for generating and trading renewable energy certificates. We also connect suppliers with opportunities to buy renewable energy directly from project developers and utilities as those models emerge around the globe.

• **Direct Investments:** To cover emissions from suppliers we don't contract with directly, we invest in additional renewable electricity projects. To date, we've directly invested in nearly 500 megawatts of solar and wind projects in China and Japan to address our upstream electricity emissions.

#### **Advocating for policy change**

Effective government policies and rules can remove significant barriers to low-carbon solutions and enable solutions to rapidly scale. Suppliers need clean energy investments that make financial sense to effectively transition to renewable energy. But carbon-intensive energy sources, like coal and gas, often have a price advantage because of subsidies and the ignored costs of externalities, such as greenhouse gas emissions.

Across the regions where our suppliers operate, we engage with policymakers to support renewable energy that's cost-effective, accessible to companies, and sourced from high-quality projects with a material impact on local markets.

For example, we're encouraging governments not to subsidize or expand carbon-intensive infrastructure. We also encourage them to keep pace with the speed of technological innovation, consider the life cycle emissions of energy solutions, and support new energy solutions that effectively reduce global emissions. Additionally, Apple supports government

efforts in beneficial electrification and the build-out of necessary transmission infrastructure, all while considering cost-effectiveness. Public investments in decarbonization should be properly supported by funds generated from establishing a price on carbon pollution.

Collaborating with groups like the Asia Clean Energy Coalition (ACEC), Clean Energy Demand Initiative (CEDI), and RE100 — which bring together the world's most influential businesses through commitments to use renewable electricity — we've identified country-level policy barriers to procuring renewable electricity. By engaging in these initiatives and others, such as local working groups, we use local and international expertise and capacity to collate the challenges faced by member companies and advocate for critical policy shifts that support grid decarbonization. In Japan, for example, Apple collaborated with other renewable energy users and called for enhancing the Non-Fossil certificate (NFC) scheme to enable transparency in tracking. In China, Apple and suppliers have participated in meetings and events to share their experiences with renewable energy procurement, and discussed ways to improve policies and increase the availability of cost-effective solutions.

# **1 GW**

As of March 2024, the China Clean Energy Fund has invested in more than 1 gigawatt of renewable electricity projects, with nearly 100 percent of those investments online.

<span id="page-29-0"></span>**[Apple 2030](#page-7-0) [Resources](#page-37-0)**

**[Smarter Chemistry](#page-56-0)** 

Image /page/29/Picture/3 description: {
 "image\_description": "This image shows a vast, orderly array of solar panels stretching across a field at sunset. The sun is glowing near the horizon, casting warm hues over the landscape. The scene emphasizes sustainable energy through solar power."
}

# **Product use**

The electricity that our customers use to charge and power their Apple devices represents 29 percent of Apple's gross carbon footprint. Increasing the energy efficiency of our products is the most direct action we can take to drive down emissions from product use, and we're taking steps to address the emissions that remain.

As we address emissions tied to the electricity that our products use globally, our guiding principles focus on three areas: exploring innovative solutions to minimize greenhouse gas emissions from product use, including energy efficiency (see [page 25\)](#page-24-0); building renewable electricity projects aimed at maximizing carbon reductions and social impact; and engaging with our customers to educate and provide opportunities to support decarbonizing the grid. We also account for the portion of the grid that is already clean, where residual grid mix data is available.

#### **Clean energy projects**

As we expand our strategy to include product use, we're considering a number of factors when selecting projects. We are working to match the expected electricity consumption of our products with 100 percent clean electricity, starting with our fall Apple Watch lineup. Although we'll source the majority of our clean electricity from the region in which it's used, we're maintaining geographic

flexibility for a portion of the emissions so that we can target grids with higher carbon intensity. This approach allows us to balance focusing on areas where our customers use our products and maximizing the social and environmental benefits of additional renewable energy. For example, while California is a large market for Apple, we might build new renewable energy projects in other locations with lower clean energy percentages on their grids, where the same renewable energy capacity can have a more significant impact.

We're developing large-scale solar and wind projects around the world as part of this work. Radian Solar, and plans for additional projects in the US, Europe and India are underway. In Europe, we plan to engage in projects that range between 30 and 300 megawatts, with an initial request for proposals issued in 2022.

### **Engaging with our customers**

We're building features to make it easier for customers to decide when to draw cleaner electricity from the grid. In 2023, we launched Grid Forecast, a new tool in the Home app on iPhone, iPad, Mac, and Apple Watch that shows when cleaner electricity is available from the grid. Apple uses data that combines grid, emissions, and weather information into one easy-to-follow signal. This can help people make more informed decisions about when to run large appliances and charge electric vehicles or

devices throughout the day. In the contiguous United States, Grid Forecast is available for Apple Watch, and it can be added as a widget or a watch face complication. As additional data becomes available through ongoing industry collaboration, Apple will continue refining Grid Forecast to maximize impact. To learn more about Grid Forecast, visit our Grid Forecast support page.

Clean Energy Charging, which became available in the U.S. in fall 2022 with iOS 16, enables customers to help decrease the carbon footprint of iPhone. The feature looks at electricity sources to select the charge times when the grid is using cleaner energy sources, optimizing charging and reducing greenhouse gas emissions. Learn more about Clean Energy Charging [here.](https://support.apple.com/en-us/HT213323)

Beyond the work that we do on our products, we collaborate with others to continue advancing climate-smart decision-making for customers across their household energy usage, as well as for our employees and partners. As an example, Apple has joined the CoolClimate Network, a research partnership of the University of California, Berkeley, that motivates and empowers individuals and organizations to make low-carbon choices.

Apple is investing in renewable energy worldwide — including this large-scale solar project in Brown County, Texas — to help address the electricity customers use to charge their Apple devices.

# <span id="page-30-0"></span>**FEATURE Increasing access to clean energy around the world**

**Power for Impact is driven by the idea that access to renewable energy creates opportunities within communities while benefiting our climate.** 

Apple launched the initiative in 2019 to provide underresourced communities with renewable electricity while supporting economic growth and social impact.

The program funds renewable energy projects that are mutually beneficial — local communities and organizations get access to cost-effective energy, and Apple retains the environmental attributes of each project. We currently support 20 renewable projects in countries around the world, including:

**Colombia:** Apple helped bring a rooftop solar power system online at the Hospital Infantil Santa Ana. The money saved on energy bills allows the hospital to purchase more equipment and medications. In addition, Apple helps to fund a rooftop solar installation at Ciudad Don Bosco, a nonprofit that provides educational and social services for under-resourced youth. We recently expanded our support by providing funding for phase II of the project.

**Democratic Republic of the Congo:** Apple provides access to renewable energy for the Malaika School, which empowers Congolese girls and their communities through education, agriculture, water projects, health outreach, sports, and vocational training. To support Malaika students and teachers, this solar initiative builds on other Apple collaborations, including virtual Today at Apple sessions on coding with Swift, photography, filmmaking, and design, as well as other events with Apple Retail teams and Diversity Network Associations.

**Israel:** Apple supports the Nitzana Educational Eco-Village — a community for underserved youth — with a 260 kilowatt solar system to help lower electricity costs. The savings help enhance educational experiences for youth from various backgrounds. Apple also supported the expansion with another 64 kilowatt solar system installed in February 2023.

**Nepal:** Apple funded a solar and battery storage system at a nonprofit hospital that serves children throughout Nepal. This system will offer limited backup power during grid outages.

**Nigeria:** Apple helped fund a remote minigrid project that provides energy access to community members and replaces fossil fuels for some businesses. In addition, Apple also funds a solar power system to provide power to public healthcare centers in the state of Ondo, with excess energy serving households in the surrounding region.

**Philippines:** Apple helped fund a new rooftop solar installation at an educational institution in Bataan. This helps reduce electricity cost for the institution and free up funds for scholarships to highachieving, under-resourced students.

**South Africa:** Apple's first PFI project in South Africa helped bring electricity to over 3,500 households that previously lacked access to local street lighting. In addition, Apple will help fund two more projects in South Africa at schools for children with disabilities. Along with five other operational projects across South Africa, these installations will reduce electricity costs, and the savings help fund operating costs and expand programs to support underserved groups.

**Thailand:** Apple helped establish a solar energy system to replace polluting diesel fuel for a remote fishing village that relies on refrigerators to maintain the quality of its fish products. We increased local renewable energy production and battery storage to improve reliable access to electricity.

**Vietnam:** Apple's work to support a program in Vietnam will provide solar electricity for 20 schools around the country, with aspirations to help showcase renewables and sustainable development. At five schools, solar energy systems have been installed and are operational. **Zambia:** Apple will help fund a microgrid and battery storage system to provide power for hundreds of households that are currently without electricity. The project will reduce reliance and costs associated with imported diesel and gasoline for generators, and it will increase the amount of power available to community organizations and businesses.

Image /page/30/Picture/17 description: {
 "image\_description": "A worker is on a ladder installing electrical connections on a solar power installation, with a background view of rooftops in a community below and a clear blue sky."
}

Power for Impact is expanding access to clean, affordable power in different parts of the world. Apple will continue to focus on uplifting communities as it pursues its environmental goals.

# <span id="page-31-0"></span>**Direct emissions**

**Some materials that are integral to our products result in significant emissions. The same is true for certain manufacturing processes and the transportation of our products. We seek technological solutions and supplier engagement to abate emissions from these sources.** 

# **Approach**

We're committed to reducing direct greenhouse emissions in our facilities and across our supply chain. We engage multiple approaches to achieve this, from looking to technical advancements that can help address emissions to changing how we make and transport our products.

## **Seeking technological solutions**

Pursuing low carbon technologies to address carbon-intensive processes

## **Addressing fluorinated greenhouse gas emissions**

Partnering closely with key manufacturers as they work to prevent these gases from being released into the atmosphere

### **Shifting transport modes for product shipment**

Moving to shipping modes that are less carbon intensive than air transport — such as by ocean — whenever possible

**Reducing employee commute emissions** Exploring ways to reduce our carbon footprint from employees commuting to work

**Direct emissions abatement addresses emissions from:**

**Direct emissions (Scope 1)**

**Product manufacturing (Scope 3)**

**Product transport (Scope 3)**

**Business travel (Scope 3)**

**Employee commute (Scope 3)**

# **2023 progress**

**2.7M MTCO2e**

Our display suppliers' abatement efforts reduced more than 2.7 million annualized metric tons of CO2e.\*

**100+ attendees**

Apple hosted an inaugural virtual training focused on reporting and abating scope 1 emissions, with more than 100 attendees.

**20% less emissions**

In 2023, we reduced emissions from transporting products by 20 percent compared with 2022.

\* Based on data reported to Apple by its suppliers. Data has not been independently

Image /page/31/Picture/28 description: {
 "image\_description": "The image contains the text '23 progress' in a simple sans-serif font style."
}

Image /page/31/Picture/29 description: {
 "image\_description": "An image containing text focused on environmental impact and abatement measures associated with suppliers."
}

Image /page/31/Picture/30 description: {
 "image\_description": "A stream of liquid metal being poured from a spout into a container, illustrating a metal processing operation, possibly aluminum casting."
}

assured by Apple or a third-party. The low-carbon aluminum breakthrough builds on the significant progress Apple has made in reducing the carbon impact of aluminum and other metals found in its products.

<span id="page-32-0"></span>Image /page/32/Picture/3 description: {
 "image\_description": "This is an image of industrial equipment used in a carbon-free smelting process, with steam or vapor emanating from the equipment. A worker in protective gear is standing nearby, attending to the machinery or observing the process. The equipment seems to belong to a facility aiming to reduce climate impact through innovative methods."
}

# **Rethinking how aluminum is made**

As part of Apple's commitment to reduce our products' environmental impact through innovation, we partnered with aluminum companies and the governments of Canada and Quebec to invest in ELYSIS. This joint venture to commercialize patented technology that eliminates direct greenhouse gas emissions from the traditional smelting process. Since our collaboration began in 2018, we've helped accelerate the development of this technology by facilitating the joint partnership and providing initial funding and ongoing technical support.

In 2022, Apple shipped iPhone SE devices that used ELYSIS aluminum, building on our 2019 purchase from the first-ever commercial batch of aluminum resulting from the joint venture. The commercialpurity aluminum in these products is the first to be manufactured without creating any direct greenhouse gas emissions during the smelting process. ELYSIS has continued to make progress within its Industrial Research and Development Center in Quebec to produce commercial-purity primary aluminum at industrial scale.

# **Addressing fluorinated greenhouse gas emissions**

One of the largest contributors of direct emissions in our supply chain is the use of fluorinated greenhouse gases (F-GHGs). F-GHGs are notably used in the electronics manufacturing of semiconductors and flat-panel displays, and their global warming potentials (GWPs) are thousands of times more than those of CO2. While the use of F-GHGs in certain manufacturing processes today is difficult to avoid, emissions can be reduced by switching to alternative low GWP gases, optimizing production processes to use and emit fewer F-GHGs, and installing gas abatement tools. We're collaborating closely with our supply chain partners as they work to prevent these gases from being released into the atmosphere.

Since the launch of our engagement efforts in 2019, we have been working with our largest manufacturers of displays and semiconductors to achieve a high standard of F-GHG abatement. In 2023, our display suppliers' efforts resulted in avoided emissions of more than 2.7 million metric tons CO2e, annualized.[60](#page-112-0) Further, through engagement in sector-specific industry coalitions, we're working to accelerate climate action across the whole semiconductor value chain.

# **2.7M**

In 2023, our display suppliers' efforts resulted in avoided emissions of more than 2.7 million metric tons CO2e, annualized.

The innovative direct carbon-free smelting process of ELYSIS has the potential to reduce the climate impact of the production process of aluminum — one of the world's most widely used metals.

# <span id="page-33-0"></span>**Supporting supplier capacity**

As we tackle direct emissions across our supply chain, we're building out new educational materials and resources support to help our suppliers decarbonize their direct emissions. In 2023, we hosted our first virtual training series focused on reporting and abating scope 1 emissions, with over 100 supplier attendees.

We continue to launch supplier programs targeted at addressing direct emissions from energy and processes that produce Apple products. The manufacturing of Apple products accounts for 59 percent of our gross carbon footprint. This includes emissions from fuel combustion; heating, ventilation, and air conditioning (HVAC); refrigeration; fluorinated gases; and other physical or chemical processes (excluding transportation). These sources vary widely and require use of diverse technologies and solutions to abate. Apple's approach is to identify process carbon emission hot spots across our supply chain like the use of fluorinated gases in display and semiconductor manufacturing — and launch targeted programs to address these carbon hotspots in partnership with our suppliers, governments, and industry stakeholders.

# **Transporting products**

In 2023, we reduced emissions from transporting products by 20 percent compared with the previous year. We also more than doubled product tonnage transported by ocean. On average, ocean shipping emissions are approximately 95 percent lower than air transport emissions[.61](#page-112-0) We aim to continue to increase the use of ocean shipping for our products. For example, for select Apple Watch models, including watches and bands, we'll ship at least 50 percent of the combined weight using non-air modes — like ocean shipping — over the lifetime of the product, cutting total transportation emissions nearly in half[.62](#page-112-0) And in 2023, we shifted select models of MacBook Pro and MacBook Air to use ocean shipping from our manufacturers, creating more opportunities for a lower-carbon mode of shipping for our product launch.

Through forward-thinking logistics, we're consolidating our products in the shipments from our factories to facilitate more ocean shipping at sea ports in our Asia Pacific markets. And since 2022, these efforts have helped us increase ocean shipments by more than 10 percent in this region diverting shipments from air transport. We've also reduced unnecessary space aboard aircrafts and trucks by using smaller, custom pallets, creating more efficient shipments. Additionally, we're redesigning

our packaging to be more compact — all packaging for Apple Watch Series 9 and Apple Watch SE models introduced a new smaller shape that allows for 25 percent or more devices per shipment.

We're collaborating with our suppliers to explore technical innovations for transport, including alternative fuels and electric vehicles. For example, in 2022, we supported the development of an analysis with Carbon Direct, a carbon management firm, that identified pathways for developing sustainable aviation fuel (SAF). And in 2023, we socialized our learnings with our partners, including suppliers and industry groups. Read the summary of our findings in the ["Promising production pathways](https://www.carbon-direct.com/insights-sustainable-aviation-fuel-primer-2023)  [and opportunities to scale" section of the Sustainable](https://www.carbon-direct.com/insights-sustainable-aviation-fuel-primer-2023)  [Aviation Fuel Primer report.](https://www.carbon-direct.com/insights-sustainable-aviation-fuel-primer-2023) We also trialed the limited use of SAF on two flights that shipped select iPad models in 2023.

In 2023, we continued to partner with carriers that offer low-carbon deliveries using electric vehicles (EVs), such as e-bikes and cars, reducing our impact in customer communities. By prioritizing vendors that offer low-carbon options, we're signaling the value of these options and incentivizing further decarbonization.

# **Improving employee travel and commute**

We're focused on finding new ways to reduce the carbon footprint from our employees commuting to work. For example, we're helping our employees transition from single-occupancy vehicles to mass transit, coach services, and campus bicycles. To incentivize the use of electric vehicles, we provide more than 3,330 EV charging stations and more than 1,730 ports across our U.S. campuses. For the commute-related emissions that remain, we're applying high-quality offsets carbon credits.

# **25%**

All packaging for Apple Watch Series 9 and Apple Watch SE models introduced a new smaller shape that allows for at least 25 percent more devices per shipment.

# <span id="page-34-0"></span>**Carbon removal**

**Science shows that limiting the planet's warming to 1.5° C will require both deeply decarbonizing industrial emissions over the next 30 years and significantly ramping up carbon removal to address the surplus carbon dioxide (CO2) already in the atmosphere. To catalyze efforts to reach a 1.5° C pathway, Apple is scaling up carbon removal solutions, beginning with those that are available today, while exploring the solutions of the future.**

# **Approach**

Apple is unequivocal in our priority: Emissions reductions take precedence over carbon removal. We're striving to reduce direct greenhouse gas emissions in our facilities, and we're supporting emissions reductions in our supply chain through process innovation, direct emissions abatement, and transitioning to clean energy. But even with these comprehensive measures, some emissions in our value chain can't yet be avoided.

We aim to reduce emissions by 75 percent compared with our 2015 footprint by 2030. To achieve carbon neutrality across our value chain, we'll voluntarily balance the remaining unavoidable emissions with high-quality carbon removal credits. We're pursuing opportunities for carbon removal through the following efforts:

## **Exploring and addressing carbon removal solutions**

Recognizing that achieving global climate targets will require pursuing all carbon removal strategies and considering options consistent with the Intergovernmental Panel on Climate Change's (IPCC) position that all pathways limiting warming to 1.5° C require carbon removal for unavoidable emissions[.63](#page-112-0) Then, evaluating each option against five key criteria: stage of development, scalability, durability, carbon methodology, and co-benefits.

#### **Addressing unavoidable emissions**

Working toward our goal to scale up highquality nature-based projects while putting robust standards in place to ensure the integrity of carbon removals. And building capacity for partners that support nature-based carbon removal implementation to help enable these efforts to grow beyond Apple's demand.

Image /page/34/Picture/13 description: {
 "image\_description": "A graphic depicting investment trends with a dollar sign, data points, and an arrow suggesting growth."
}

## **Investing in nature-based carbon removal projects**

Engaging with projects that offer important ecological and social benefits while providing economic development opportunities for local communities. Seeking to align carbon market impact with investment capital by addressing three main barriers facing nature-based solutions: scale, quality, and capacity in order to grow nature-based carbon removals well beyond the current scale of voluntary carbon markets.

# **2023 Progress**

# **\$280M**

In March 2024, Apple welcomed key manufacturing partners as new investors in the Restore Fund, committing additional funds — Taiwan Semiconductor Manufacturing Company (TSMC) will invest up to \$50 million and Murata will invest up to \$30 million — in the same fund that will be managed by Climate Asset Management, a joint venture between HSBC Asset Management and Pollination. These new investments build on Apple's previous commitment of up to \$200 million for the Restore Fund's second phase, bringing the total to \$280 million in committed capital.

Read more about our work in the [Apple's Carbon Removal](https://www.apple.com/environment/pdf/Apples_Carbon_Removal_Strategy_White_Paper.pdf)  [Strategy](https://www.apple.com/environment/pdf/Apples_Carbon_Removal_Strategy_White_Paper.pdf) white paper.

# **The need for carbon removal**

Any successful strategy for addressing climate change includes the development of carbon removal technologies — pursued urgently and in parallel with efforts to decarbonize energy production and protect and restore Earth's ecosystems. As part of our efforts to achieve carbon neutrality across our value chain, Apple prioritizes emissions reductions. We then balance the remaining unavoidable emissions with high-quality carbon removal credits. To ensure that removals are high integrity, we follow guidance set out by international standards and apply our own rigorous standards and criteria.

# **Nature-based carbon removal**

Science indicates that nature-based solutions are the most scalable and economically viable opportunities to mitigate climate change in the short term. In addition to their climate benefits, naturebased solutions offer multiple co-benefits, including enhanced employment and local livelihoods, improved biodiversity, soil carbon and nutrient cycling, and increased timber supply that can reduce the pressure on primary forests.

The IPCC lays out a range of options to remove carbon from the atmosphere using a combination of photosynthesis and chemistry. These approaches include existing climate solutions, such as afforestation and reforestation, and relatively new

technologies, such as direct air capture (DAC) and ocean alkalinization. Apple looked at how these approaches could help balance our residual emissions as we focus on the global urgency to align with a 1.5° C pathway to scale up carbon removal.

Five key criteria drive our exploration:

- **• Stage of development:** A solution's stage of development is important both to meet our Apple 2030 target and to reach scale within the time frame needed to stay within a 1.5° C trajectory.
- **• Scalability:** We consider scalability because the climate crisis is a collective responsibility, and the impact of Apple's solutions should scale beyond our own environmental footprint.
- **• Durability:** Removals must be permanent, or if there's a risk of reversal, measures must be in place to address those risks and compensate for any reversals for a defined period of time.
- **• Carbon methodology:** The impacts achieved need to be accounted for through using a rigorous carbon accounting methodology that aligns with quality and consistency of our own carbon accounting systems, including evaluating any uncertainty in the underlying science.
- **• Co-benefits:** We evaluated the co-benefits across different carbon removal technologies. Most carbon removal approaches have the potential to generate additional benefits for biodiversity and communities but can also pose risks.

Our review of different available technologies helped us determine that nature-based solutions — including afforestation, reforestation, and revegetation (ARR) and soil carbon sequestration — currently offer the most comprehensive carbon removal approach.

# **Restore Fund**

We launched the Restore Fund in 2019 in partnership with Conservation International and Goldman Sachs. Since its creation, the fund has invested in three initiatives that are projected to remove over a million metric tons of carbon starting in 2025. This fund is unique because it aims to change carbon removal from a cost to a potentially profitable investment. By creating a fund that generates both a financial return as well as real and measurable carbon impact, we strive to drive broader change — encouraging capital investment in carbon removal around the globe. We developed the Restore Fund as a pilot, and we're now seeking to expand and improve it so that others can build on our work and scale the market for nature-based removals.

The first phase of the fund focused on blending responsible forestry practices with carbon removal and sought to maximize environmental impact, including carbon, hydrology, and habitat restoration.

Image /page/35/Picture/19 description: {
 "image\_description": "A lush green landscape of forests extending as far as the horizon under a bright sky with sparse clouds, showcasing nature's vitality and beauty."
}

As we focus on eliminating the majority of emissions across the value chain, we're also addressing emissions we can't reduce by looking for high-quality carbon credits from nature-based projects.

Based on our learnings with these projects and the growing global need for more nature-based solutions, Apple announced an expansion of the Restore Fund in 2023. The commitment aims to develop an investment vehicle to scale nature-based solutions using a different kind of financial innovation. This unique blended-fund structure is intended to achieve financial and climate benefits for investors while advancing a new model for carbon removal that addresses a broader spectrum of global potential for nature-based solutions.

The expanded fund targets two types of investments: regenerative agriculture and other ecosystem assets, and a pipeline of landscape restoration projects that aim to remove carbon from the atmosphere.

In October 2022, Apple announced three new projects through the Restore Fund and we've invested with three high-quality forestry managers in Brazil and Paraguay. Our most recent project, announced in March 2024, supports the restoration of South America's Atlantic Forest.

Also in March 2024, Apple welcomed key manufacturing partners Taiwan Semiconductor Manufacturing Company (TSMC) and Murata Manufacturing as new investors in the Restore Fund. Global semiconductor foundry TSMC will invest up to \$50 million in a fund managed by

Climate Asset Management, a joint venture of HSBC Asset Management and Pollination. Murata — an electronic components supplier for Apple based in Japan — will invest up to \$30 million in the same fund. These new investments build on Apple's previous commitment of up to \$200 million for the Restore Fund's second phase, bringing the total to \$280 million in committed capital.

TSMC and Murata are among the more than 320 suppliers in Apple's Supplier Clean Energy Program. The fund TSMC and Murata are investing in alongside Apple will pool sustainably managed agriculture projects with ecosystem conservation and restoration projects to generate both carbon and financial benefits.

To improve the accuracy of monitoring and reporting, and verifying the projects' carbon removal impact, Apple is deploying innovative remote sensing technologies using Space Intelligence's CarbonMapper and HabitatMapper and Upstream Tech's Lens. Using high-resolution satellite imagery from Maxar and other providers, this initiative enables us to view detailed habitat and forest carbon maps for our Restore Fund projects. Through our engagement with the MIT Climate & Sustainability Consortium, Apple is jointly funding research with PepsiCo and Cargill to improve the measurement of soil carbon in nature-based carbon removal projects. Apple and

partners have used innovative tools including LiDAR on iPhone, satellite data, bio-acoustic monitoring, and machine learning to evaluate the well-being of the land and project progress.

Integrity and a rigorous approach are central to how we designed the Restore Fund with our partners. The projects aim to become certified to international standards developed by organizations such as Verra; Gold Standard; the Climate, Community & Biodiversity Alliance (CCBA); and the Forest Stewardship Council (FSC). Using these international standards helps confirm that the carbon stored in forests is measured and reported to high standards and that projects have the most up-to-date safeguards in place. The projects we choose also seek to have a positive impact on the livelihoods of local communities by bringing economic opportunities to often underserved rural economies. And we'll continue to focus on projects that protect lands with high conservation values.

# **High-quality avoided emissions projects as an interim solution**

We plan to reach our goal of becoming carbon neutral across our entire value chain by 2030, using a wide range of solutions at our disposal, prioritizing significant emissions reductions, followed by longterm carbon removal initiatives like the Restore Fund.

We've been carbon neutral for our corporate emissions since April 2020. We started by reducing our corporate emissions through the use of 100 percent renewable electricity and energy efficiency efforts at our facilities. But emissions remain difficult to avoid in some activities including the natural gas used in some of our buildings and emissions from business air travel and employee commute.

For the emissions we can't avoid, we use high-quality offsets as an interim solution. We're intentional about identifying avoided deforestation and removal projects that are of a high standard and that achieve meaningful impact. We often originate our own projects working with a reputable partner, like Conservation International, or we carefully select projects from third-party-certified registries. For more details about our purchases of high-quality carbon credits, see [Data](#page-77-0).

Read more about our work in the [Apple's](https://www.apple.com/environment/pdf/Apples_Carbon_Removal_Strategy_White_Paper.pdf)  [Carbon Removal Strategy](https://www.apple.com/environment/pdf/Apples_Carbon_Removal_Strategy_White_Paper.pdf) white paper.

<span id="page-37-0"></span>[Contents](#page-1-0) [Introduction](#page-2-0) **[Environmental Initiatives](#page-5-0)** [Engagement and Advocacy](#page-65-0) [Data](#page-75-0) [Appendix](#page-83-0) 2024 Environmental Progress Report 38

## **[Apple 2030](#page-7-0)**

**Resources** [Approach](#page-38-0) [Product longevity](#page-39-0) [Material recovery](#page-44-0) [Water](#page-47-0) [Zero waste](#page-51-0)

**[Smarter Chemistry](#page-56-0)**

**A strong case for recycled materials**

**All MacBook Air models contain 100 percent recycled aluminum in the enclosure. Our custom aerospace-grade aluminum alloy is lightweight, durable, and scratch resistant.**

# **Resources**

Image /page/37/Figure/8 description: {
 "image\_description": "A silver keyboard frame with empty key slots for customization."
}

Image /page/37/Figure/9 description: {
 "image\_description": "The image appears to be a metallic component or part, potentially used in mechanical or industrial applications. It features cutouts and holes that may serve specific purposes in assembly or functionality."
}

# <span id="page-38-0"></span>**Approach Resources**

# **We're committed to sourcing, using, and recycling the materials that we rely on in a way that meets our high standards for labor, human rights, and environmental stewardship.**

Our commitment to responsibly use resources extends across our corporate operations and supply chain. This means sourcing responsibly, minimizing our freshwater use, and eliminating waste across Apple-owned and supplier sites. We work to reduce the overall resource footprint supporting our products by collaborating with suppliers, NGOs, recyclers, community stakeholders, and innovation leaders. We know that we can't do this work alone — it requires broader engagement through collaborations enabling the stewardship of shared resources.

Building durable, long-lasting products is central to our approach, making the best use of the resources required to create them. We aim to one day make our products solely from responsibly sourced recycled and renewable materials — while maintaining our same rigorous standards of quality and durability. Innovations and new approaches to recycling will make this possible. We're able to recover and use the materials that we rely on in our products in even greater quantity, helping us begin to realize the full potential of each resource.

Water is one of our most critical resources. Because it's also a community resource, we prioritize our stewardship efforts: working toward the most efficient use of freshwater, using alternatives where possible, and managing our discharge responsibly. We also look beyond our facilities to the water basins where we operate. We're working to improve the quality of the water that our communities rely on through collaborations with local partners — including companies, NGOs, and government agencies.

We also conserve resources by working to eliminate waste. We work to reuse and recycle across our operations and throughout our supply chain. We aim to eliminate waste where we and our suppliers operate. These efforts include reducing the overall amount of waste that we generate, innovating reuse approaches, and creating new recycling opportunities with local businesses.

# **Areas of impact**

#### **Product longevity**

Designing durable hardware, using software updates to extend functionality, providing convenient access to safe and high-quality repair services, and directing devices and parts for refurbishments and reuse.

#### **Material recovery**

Improving how we collect end-of-life products and developing recycling innovations so that we and others can use old devices as raw material sources for the future.

# **Water**

Reducing water impacts in the manufacturing of our products, the use of our services, and our facility operations. At the same time transitioning to alternative solutions, improving the quality of water that we discharge, and protecting shared water resources.

### **Zero waste**

Minimizing overall waste generated and eliminating waste sent to landfill from our manufacturing supply chain as well as our corporate offices, data centers, and retail stores.

Image /page/38/Picture/20 description: {
 "image\_description": "The image depicts a close-up view of metal objects submerged in a chemical bath, likely for a finishing or treatment process, such as electroplating or anodizing, within an industrial setting."
}

We continued our initiative focusing on enhancing and supporting our electrochemical metal-finishing processes, like anodizing, which has the potential to save hundreds of millions of gallons of water annually when applied at scale.

# <span id="page-39-0"></span>**Product longevity**

**In our design approach, we combine hardware built to endure the rigors of everyday use, tailored software updates that unlock new features and functionality, and access to repair services when needed. This also helps keep products in use for as long as possible so that new customers can experience Apple products and services with secondhand devices.**

# **Approach**

We're committed to building long-lasting devices, and part of achieving that is designing durable hardware. To minimize products' need for repair, we refine features that improve durability, like water resistance and Ceramic Shield, which protects the iPhone display. And we provide regular software support, so customers can update their devices to the most recent operating systems and unlock the latest features and functionality for as long as possible.

We've also expanded access to safe, reliable, and secure repair services to meet our customers' needs. When products require repair, customers can more easily find repair options that work for them.

**To achieve product longevity, we prioritize the following actions:**

## **Durability**

Designing our devices with consideration to the potentially rugged use by our customers while aiming to minimize maintenance and repair interruptions. And utilizing a rigorous reliability testing process that simulates real-world use to maximize the lifespan of our products.

## **Repair access**

Offering access to safe, reliable, and secure repairs by expanding the number of Apple Authorized Service Providers (AASPs) and Independent Repair Providers (IRPs), as well as Self Service Repair (SSR) for customers who want to complete their own repairs.

**Software updates**

Providing free software updates to enhance our customers' experience by allowing them to access the latest features available to their device for as long as possible — including important security and privacy updates.

#### **Refurbishment and reuse**

Collecting devices for refurbishing and reuse through several programs, including Apple Trade In, the iPhone Upgrade Program, AppleCare service, and our corporate Hardware Reuse Program to extend product life.

# **2023 progress**

**70% less emissions**

Back glass repair on all iPhone 15 models has 70 percent less greenhouse gas emissions per repair compared with iPhone 14 Pro.\*

# **40 products**

Self Service Repair now supports 40 Apple products in 33 countries and 24 languages since our expansion in December 2023.

**12.8M devices**

We've sent nearly 12.8 million devices and accessories to new users for reuse from programs like Apple Trade In and AppleCare.

# <span id="page-40-0"></span>**Durability**

Durable products hold their value longer. iPhone, for example, holds its value longer compared to other smartphones.[64](#page-112-0) As of April 2024, iPhone 7, which was introduced in 2016, still had monetary value for Apple Trade In in the United States[.65](#page-112-0)

We design our devices with the rigors of daily use in mind. Engineers in our Reliability Testing Lab assess our designs against our strict durability standards that measure the performance of materials, components, and fully assembled products. They use testing methods that mimic realistic conditions in which our customers use their products, assessing many aspects of each device. To understand how our customers push their products, in-depth user studies are constantly being performed. The results are then used to further define durability standards of our products.

During product development, we test numerous units of a product, relying on the results to inform each successive round of design. In 2023 Apple launched Apple Watch Ultra 2, with a design developed for a high level of durability to support the needs of our most adventurous and explorative customers. Apple Watch Ultra 2 was designed for demanding conditions that required a series of new environmental and impact tests to maintain the device's high level of reliability. Tests that our engineering team developed supported compliance with MIL-STD-810H — a standard used for military equipment that's also popular among rugged device manufacturers[.66](#page-112-0) This also included low-pressure testing to simulate a range of environmental conditions, such as high altitude, extreme temperatures, temperature shock, chemical exposure, freezing and thawing, shock, vibration, submersion, and other assessments to emulate operations in rugged settings. Our engineers performed these tests in addition to other trusted reliability procedures developed through iteration across several generations of the Apple Watch product line.

**DESIGNING PRODUCTS FOR DURABILITY**

**iPhone 7, which was introduced in 2016, still had monetary value for Apple Trade In in the United States as of April 2024.**

Image /page/40/Picture/8 description: {
 "image\_description": "The image displays the rear view of a gold-colored Apple iPhone, showcasing the Apple logo and the camera setup."
}

Image /page/40/Picture/9 description: {
 "image\_description": "The image depicts the rear side of an Apple iPhone with a rose gold finish. Visible are the Apple logo and back camera with adjoining flash."
}

Image /page/40/Picture/10 description: {
 "image\_description": "A back view of an iPhone showing its silver body, Apple logo, camera, and text details including the brand name at the bottom."
}

**IPHONE LONGEVITY JOURNEY**

# **Increased durability and repairability enhance iPhone longevity**

Image /page/41/Figure/4 description: {
 "image\_description": "The figure is a timeline depicting key repairable components of various iPhone models from 2007 to 2023, alongside information about repairability at authorized locations and features to enhance durability."
}

# **70%**

Back glass repair on all iPhone 15 models has 70 percent less greenhouse gas emissions per repair compared with iPhone 14 Pro.†

\* [iPhone 7, iPhone X, iPhone](https://support.apple.com/en-us/HT207043)  [13 and iPhone 15 models](https://support.apple.com/en-us/HT207043)  [are splash, water, and dust](https://support.apple.com/en-us/HT207043)  [resistant and were tested under](https://support.apple.com/en-us/HT207043)  [controlled laboratory conditions.](https://support.apple.com/en-us/HT207043)  [iPhone 7 and iPhone X have](https://support.apple.com/en-us/HT207043)  [a rating of IP67 under IEC](https://support.apple.com/en-us/HT207043)  [standard 60529 \(maximum](https://support.apple.com/en-us/HT207043)  [depth of 1 meter up to 30](https://support.apple.com/en-us/HT207043)  [minutes\). iPhone 15 has a rating](https://support.apple.com/en-us/HT207043)  [of IP68 under IEC standard](https://support.apple.com/en-us/HT207043)  [60529 \(maximum depth of](https://support.apple.com/en-us/HT207043)  [6 meters up to 30 minutes\).](https://support.apple.com/en-us/HT207043)  [Splash, water, and dust](https://support.apple.com/en-us/HT207043)  [resistance are not permanent](https://support.apple.com/en-us/HT207043)  [conditions and resistance might](https://support.apple.com/en-us/HT207043)  [decrease as a result of normal](https://support.apple.com/en-us/HT207043)  [wear. Do not attempt to charge](https://support.apple.com/en-us/HT207043)  [a wet iPhone; refer to the user](https://support.apple.com/en-us/HT207043)  [guide for cleaning and drying](https://support.apple.com/en-us/HT207043)  [instructions. Liquid damage not](https://support.apple.com/en-us/HT207043)  [covered under warranty.](https://support.apple.com/en-us/HT207043)

- \*\* Back glass repair is available for all iPhone 15 models.
- ‡ Main microphone repair only available for iPhone 15 and iPhone 15 Plus.
- † Based on our life cycle assessment (LCA).

# **Repair access**

We design our products to be durable and with minimal need for repair. But if a repair is needed, customers should have easy access to convenient, quality repair services to get their device back up and running as quickly as possible.

We've expanded our repair footprint over the past three years — nearly doubling the number of professional service locations that have access to genuine Apple parts, tools, and training. Repair options include Apple Store locations, Apple Authorized Service Providers, participating Independent Repair Providers, mail-in repair centers, onsite service, and Self Service Repair. This also includes a global network of more than 10,000 Independent Repair Providers and Apple Authorized Service Providers.

Since 2019, our Independent Repair Provider program has enabled repair businesses of all sizes to access genuine Apple parts, tools, diagnostics, and training. This program expanded from the U.S., Europe, and Canada to more than 200 countries and territories worldwide. We also continue to expand coverage by offering repair service at our customers' homes and offices in select cities across the United States. We train and certify service personnel to repair Apple products. This helps them correctly diagnose issues, leading to successful service and repair and preventing damage to devices so that they work as they should.

Launched in April 2022, Self Service Repair gives individuals access to repair manuals and genuine Apple parts and tools through the Apple Self Service Repair Store. In February 2024, Apple Diagnostics for Self Service Repair was made available in Europe, following its introduction to the U.S. in 2023. Apple Diagnostics troubleshooting sessions give customers the same ability as Apple Authorized Service Providers and Independent Repair Providers to test devices for optimal part functionality and performance, as well as to identify which parts may need repair.

Self Service Repair is available in the U.S. and is now available for Apple users in 24 European countries — including Croatia, Denmark, Greece, Netherlands, Portugal, and Switzerland. With our expansion announced in December 2023, Self Service Repair now supports 40 Apple products in 33 countries and 24 languages.

#### **GLOBAL REPAIR LOCATIONS**

# **Expanding access to repair worldwide to support product longevity**

Image /page/42/Figure/10 description: {
 "image\_description": "This image shows a global map with points marking locations, with green outlines around the USA and Europe, likely representing areas of focus or data aggregation."
}

**10,000+**

Independent Repair Providers and Apple Authorized Service Providers

# **33**

countries, 24 languages, and 40 Apple products now supported by Self Service Repair

# **35+**

types of device repairs offered by Self Service Repair

Apple Authorized Service Providers, retail stores, and Independent Repair Providers

Self Service Repair

# <span id="page-43-0"></span>**Designing products with repairability in mind**

We continue to make progress in designing more durable products and offering customers more repair options. At the same time, we're working to make repairs more accessible and affordable through the following efforts:

- iPhone 15 Pro and iPhone 15 Pro Max have a new internal structural frame that makes it easier to repair and significantly reduces repair costs. For example, the cost of back glass repair for iPhone 15 Pro is reduced by more than 60 percent compared to iPhone 14 Pro.[67](#page-112-0) The aluminum housing and back glass are no longer one enclosure, so repairs to the back glass don't require replacing the housing.
- The 13-inch MacBook Air with Retina display (2018) and later models allow for battery replacement with a stretch-release adhesive, improving repairability.
- iPad mini (6th generation) and iPad Air (5th generation) support same-unit battery replacement in select locations.

• We've expanded the availability of repair parts to support older products for up to seven years in countries around the world. For example, a program for Mac laptops makes battery repair available for up to 10 years after a product was last distributed, subject to parts availability.

For more information, refer to the [Apple Support page](https://support.apple.com/en-us/HT201624) about the availability of service parts and repairs.

# **Software updates**

Free software updates also support our product longevity goals. We provide these to enhance our customers' experience by allowing them to access the latest features available to their device for as long as possible. This includes important security and privacy updates. As we continually improve the operating systems that power our products, we also make sure that each software release runs seamlessly on all supported devices. Customers can benefit from the latest software updates whether they're using a brand-new device or one that's several generations older.

iOS 17, our most recent release, extends support back to iPhone XS (2018). iPadOS 17 compatibility goes back to the sixth-generation iPad (2018), and macOS 14 Sonoma supports MacBook models from 2018 and later. The updates in each operating system make the latest capabilities — from Messages and the Lock Screen to Continuity features — available to a broad user base. These updates also provide more customers with access to the newest security and privacy features.

High adoption rates are a clear signal customers find value in software updates. By February 2024, more than 75 percent of all iPhone devices introduced in the last four years had updated to iOS 17, and iPadOS 17 was being used on more than 60 percent of iPad devices introduced in the last four years.

# **Refurbishment and reuse**

Refurbishing and reusing products helps lower the impact that each device has on the environment including carbon intensity per year of life. We extend the life of our products by building them to serve more than one owner — enabling customers to exchange devices for an upgrade.

We collect devices for refurbishment and reuse through several programs, including Apple Trade In, the iPhone Upgrade Program, AppleCare service, and our corporate Hardware Reuse Program. In 2023, we sent nearly 12.8 million devices and accessories to new owners for reuse. The Apple Trade In program, available in 27 countries, provides customers with product end-of-life options — they can access the value of their current device if they upgrade to a newer model, or they can trade in their device for free.

Our customers drive the success of our trade-in programs and those of third parties and each product that's refurbished and reused contributes to reducing our overall environmental footprint.

Some device parts can also be reused. We continue to expand the number of parts that can be recovered or refurbished to our high quality and performance standards so they can be reused as replacements. This enables us to reduce the need to create spare parts as we repair devices. We also remain focused on opportunities to reuse accessories sent for recycling. For example, we send collected power cables and adapters that still function to our final assembly sites, where they power products used on production lines.

# **12.8M**

We've sent nearly 12.8 million devices and accessories to new owners for reuse in 2023.

# <span id="page-44-0"></span>**Material recovery**

**Even after a product reaches the end of its life, the materials within it can serve the next generation of products. Each time that we effectively recover materials from end-of-life products, we enable circular supply chains. This helps reduce the need to mine new materials and can save the energy expended in extracting and refining materials, driving down emissions and conserving resources.**

# **Approach**

We aim to design our products for optimal material recovery, innovate recycling technology, and work with others to help build circular supply chains.

## **Recycler partnerships and innovation** Positioning recycling strategy as a key part of our efforts to create circular supply chains and working to make it easier for customers to recycle our products.

# **Disassembly and recovery advancement**

Continuing to develop better, more efficient means of disassembling products that maximize material recovery while minimizing waste.

## **Fostering next generations of recycling**

Committing to a long-term approach to recycling innovation, relying on and continually improving current approaches while nurturing new and emerging technologies. And supporting initiatives that set out to redefine disassembly and material recovery for Apple products — and throughout our industry.

# **2023 progress**

**40K MT of scrap**

Directed nearly 40,000 metric tons of electronic scrap to recycling facilities globally with the help of customer and employee programs

# **17 categories**

Deployed autonomous mobile robots (AMRs) to transport materials across our operations, as well as an automated product sorter that uses machine learning to identify and sort our products into 17 categories

# **29 models**

Expanded the capabilities of Daisy, our disassembly robot, enabling it to quickly and skillfully take apart 29 iPhone models — including various models between iPhone 5 and iPhone 14 Pro Max — into discrete components

Image /page/44/Picture/20 description: {
 "image\_description": "A mechanical apparatus on an assembly line disassembles electronic devices, demonstrating technological innovation in recycling and efficiency."
}

In 2023, we expanded the capabilities of Daisy, which can now disassemble 29 iPhone models into discrete components.

Image /page/45/Picture/2 description: {
 "image\_description": "A person working on disassembling a laptop, guided by projected instructions, as part of a recycling process for sustainable product materials."
}

# **Optimizing recycling through partnerships and innovation**

Our recycling strategy is a key part of our efforts to create circular supply chains. We provide or participate in product take-back and recycling collection programs in 99 percent of the countries where we sell products. Our customers can trade in devices for reuse or recycling at retail locations and through recycling programs offered by local operators around the world. They also have the option to do so online through programs like Apple Trade In.

In 2023, we directed nearly 40,000 metric tons of electronic scrap globally to recycling facilities with the help of customer and employee programs.

We work with best-in-class recyclers to maximize the potential of the recycling materials stream and drive our efforts to close the loop on key materials. We define best-in-class recyclers as those capable of recovering materials at high rates and doing so with better environmental and safety performance. We verify recyclers' compliance with our Supplier Code of Conduct and Supplier Responsibility Standards through third-party assessments. In addition, we look for our recyclers to maintain regional leading certifications, such as WEEELABEX, e-Stewards®, or R2. We assess our recyclers regularly for compliance with standards, regulations, and best practices in the areas of labor and human rights; security; and environment, health, and safety (EHS). In 2023, we conducted 91 recycler assessments. We've increasingly sought out specialty providers capable of handling specific material streams to enhance the quantity and quality of materials. This global footprint of recyclers also helps us build a more resilient recycling supply chain and innovate with more suppliers around the world.

Education and training can help us improve recovery rates for our products. We've invested deeply in this because it provides recyclers with the information they need to improve efficiency, quality, and capacity. We work with recyclers to continue devising new recycling solutions that can be shared through training and ongoing support. We help these partners develop the ability to disassemble our products and recover as much material as possible while minimizing waste.

We continue to expand our [Apple Recycler Guides](https://www.apple.com/recycling/recycler-guides/) to provide up-to-date recycling guidance across our products. Our engineering teams develop these guides to help professional recyclers optimize recovery and complete the processes using the tools and procedures available to them. The guides provide valuable insight into the recycling process, including recommendations for directing disassembled parts to downstream facilities for resource recovery. We're increasing the market availability of highquality recycled content by improving material recovery rates.

Through the Apple Education Hub, part of our Supplier Employee Development Fund, we've also supported our U.S. recyclers in their efforts to improve recycling capacity, quality, and efficiency with a lean manufacturing educational program. Embracing lean methodologies and management systems can bolster employee engagement, mitigate safety issues, and improve recycling economics. Read more about these programs in our [People](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [and Environment in Our Supply Chain 2024 Annual](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [Progress](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report) Report.

We're also continuing our partnership with Atea a leading provider of IT infrastructure solutions in the Nordic and Baltic regions — to collect end-of-life iPhone devices for recycling with our Daisy robot in the Netherlands. We encourage our customers around the world to return end-of-life devices to Apple so that materials can be reintroduced to the circular economy. To learn more about our recycling programs, visit the [Apple Reuse and Recycling](https://www.apple.com/recycling/nationalservices/)  [Program web](https://www.apple.com/recycling/nationalservices/) page.

# <span id="page-46-0"></span>**Developing new approaches to disassembly and recovery**

Innovation plays a key role in realizing the potential of recycling Apple products. We continue to develop better, more efficient means of disassembling products that maximize material recovery while minimizing waste. Our Material Recovery Lab (MRL), an R2-certified facility in Austin, Texas, focuses on assessing the recyclability of our products, helping inform design decisions that support disassembly and recovery. The MRL's work has led the way in automated approaches to material recovery with our robots Daisy, Dave, and Taz.

We're also developing new technologies at our R2-certified asset recovery center in Santa Clara Valley, California, that uses automation and machine learning to facilitate recycling processes that typically require manual sorting, which can be time intensive and error prone. In 2023, we deployed autonomous mobile robots (AMRs) to transport materials across our operations, as well as an automated product sorter that uses machine learning to identify and sort our products into 17 categories. These technologies improve material handling and sorting efficiency, which has a direct impact on the material capacity of our operations. This work aims to create low-cost solutions that our suppliers can deploy to recover more materials, freeing up their employees for more complex tasks that can't be easily automated.

We're also working to improve the material handling efforts of demanufacturing. Last year, we began deploying overhead projector–based augmented reality systems to recyclers, which project instructions for demanufacturing processes onto the work surface. These systems are designed to further improve safety, productivity, and efficiency.

# **Designing for the next generation of recycling**

We're committed to a long-term approach to recycling innovation, relying on and continually improving current approaches while nurturing new and emerging technologies. And we continue to support initiatives that set out to redefine disassembly and material recovery.

We're investing in recycling innovations that can have industry-wide impacts. For several years, we've worked with Carnegie Mellon University's Biorobotics Lab in the School of Computer Science's Robotics Institute to identify and disassemble e-scrap. This project has the potential to enable recyclers to recover the materials at a higher quality. The software we develop will be open source and available to others in the industry who are working to maximize the recovery of recyclable materials. We've also collaborated with the lab to improve the accuracy of disassembly and the recovery of

materials through X-ray imaging combined with RGB imaging. And we're optimizing our robots' abilities to handle objects and adjust to contact, enabling them to "feel" by using high-frequency force feedback and machine learning. Through this work, we're driving toward developing truly intelligent disassembly technology. Learn more about Apple's research with Carnegie Mellon University in our white [paper](https://machinelearning.apple.com/research/rgb-x-classification).

# **Advanced disassembly**

**Daisy:** In 2023, we expanded the capabilities of Daisy, which can now disassemble 29 iPhone models into discrete components. Daisy can disassemble up to 1.2 million phones each year, helping us recover more valuable materials for recycling. From just one metric ton of iPhone main logic boards, flexes, and camera modules recovered by Daisy, our recycling partner can recover the same amount of gold and copper as can be obtained from more than 2,000 metric tons of mined rock[.68](#page-112-0) The U.S. Patent and Trademark Office issued Apple five patents related to Daisy, and we're willing to license these to researchers and other electronics manufacturers who are developing their own disassembly processes in hopes that they will follow suit and work to increase the share of recycled materials in the supply chain.[69](#page-112-0)

Image /page/46/Picture/12 description: {
 "image\_description": "A factory processing shredded materials, featuring machinery and conveyance systems in a production facility."
}

As of 2024, Taz is operating at our recycling partner in China.

**Dave:** A robot that enables the recovery of rare earth magnets as well as tungsten and steel by specializing in the disassembly of the Taptic Engine. As of 2023 Dave is operating at our recycling partner in China.

**Taz:** Helps recycle modules by separating magnets containing rare earth elements from audio modules. While rare earth elements are typically lost in conventional shredders, Taz is designed to access these valuable materials, improving our overall recovery rate. As of 2024, Taz and Daisy are operating at our recycling partner in China.

<span id="page-47-0"></span>**We aim to advance water security and protect communities in the places where we and our suppliers operate through actions that improve freshwater availability, quality, and equity.**

# **Strategy**

Water is a local resource, so our strategy is context based and respectful of local conditions where we and our suppliers operate. We collect and analyze data and site-level feedback to make sure we understand our water impacts. We use tools like the World Resources Institute (WRI) Aqueduct Water Risk Atlas to gain insights on local watershed health, such as baseline water stress.

We've developed a water footprint to understand how we use water across our value chain in our own operations, our services, and our manufacturing supply chain. Through our water footprint efforts, we've identified that 70 percent of our corporate water use occurs in areas with high or extreme basin stress, and that the majority of our water-related impact is in the manufacturing supply chain[.70](#page-112-0)

We use these insights to inform our water program priorities. And we work directly with our suppliers to ensure that they have robust policies, are managing their wastewater systems efficiently, and are reducing their overall consumption by reusing wastewater. We partner with over 240 supplier facilities to guide them toward world-class water conservation and management.

We know that we can't address water stewardship challenges alone. Making a meaningful impact on water requires collective action. To do that, we must go beyond our own operations to collaborate with communities and work in basins on stewardship, replenishment, and WASH (water access, sanitation, and health) projects throughout our value chain.

**We focus our work on five strategic pillars:** 

**Low-water design** Minimizing water impacts in the design of products, services, and sites

**Site efficiency and conservation** Improving the performance of existing

sites and processes

**Site-level water stewardship** Demonstrating responsibility beyond our facilities through watershed-level management

**Replenishment and nature-based solutions**

Improving water availability, quality, and access through regenerative approaches

## **Leadership and advocacy**

Advancing water management through policy, advocacy, and technology innovation

# **2023 progress**

**31.2M gallons**

We've collaborated with partners on freshwater replenishment projects resulting in 31.2 million gallons of volumetric water benefits.

# **20 suppliers**

We've certified 20 suppliers and five data centers to the AWS Standard.

**42% reuse rate**

Through our Supplier Clean Water Program, we've supported an average 42 percent reuse rate across our 242 participating supplier facilities.

# <span id="page-48-0"></span>**Low-water design**

We approach low-water design by first focusing on site selection, conducting a water risk evaluation to determine whether a potential site is in a waterstressed area. The results inform our site selection and help mitigate the impact of our expected water use. We then design solutions to manage the quality of the wastewater that we return to the watershed.

In our corporate operations, we discharge the majority of our wastewater to the sanitary sewer. Up to 54 percent of the water that we use at our corporate locations is discharged back into the local water system rather than consumed[.71](#page-112-0) We monitor the water quality from sites where we have an industrial wastewater discharge so that each location meets or exceeds local discharge requirements.

At our Capstone campus in Austin, Texas, we aim to achieve net-zero water use by relying on an onsite wastewater reuse system, as well as condensate recovery and stormwater capture, limiting potable water use to potable purposes only. This effort

will save up to 60 million gallons of freshwater use annually[.72](#page-112-0) Using wastewater for cooling will also allow us to achieve 28 million kilowatt-hour in energy savings annually at the location. In total, our low-water design efforts avoided 150 million gallons of freshwater use in 2023[.73](#page-112-0)

In our supply chain, a majority of water is used during manufacturing. For example, in 2023 we continued an initiative that focuses on eradicating potential hazards associated with liquid discharge throughout our manufacturing supply chain. The purpose of the initiative is to enhance and support our electrochemical metal-finishing processes, like anodizing. This effort incorporates cuttingedge technologies, including optimal water management, modular filtration and recovery units, acid recovery systems, and evaporators. Pilot lines have demonstrated success during the enclosures anodizing process with recovery and reuse rates reaching 75 to 80 percent for water and more than 95 percent for acid. This process improvement has the potential to save hundreds of millions of gallons of water annually when applied at scale.

# **Site efficiency and conservation**

Next, we identify steps to use less freshwater in our existing operations, prioritizing regions where our efforts can immediately reduce stress on local watersheds.

In 2023, our facilities used about 1.6 billion gallons of water in our direct operations, a 5 percent increase from 2022 — driven mostly by increases in our corporate campus portfolio. However, through our site efficiency and conservation efforts, we saved 79 million gallons of freshwater in 2023[.74](#page-112-0) Last year, alternative water sources accounted for about 12 percent of our total corporate water usage — primarily from municipal recycled water sources. Additional efficiency and conservation accomplishments include:

- We used rainwater capture systems to source 9 million gallons of water at Apple locations in Texas, North Carolina, Ireland, Taiwan, and Japan.
- In 2023, we captured 2.6 million gallons of condensate from our condensate recovery systems in Santa Clara Valley and Austin.
- At Apple Park, we completed a new blending tank project that will enable us to replace up to 18 million gallons of potable water with recycled water per year.

#### **WATER USE AT CORPORATE FACILITIES**

**We track our corporate water use for our data centers, retail stores, distribution centers, and corporate offices** 

Image /page/48/Figure/16 description: {
 "image\_description": "The image is a circular diagram showing water usage data, segmented into two portions: 9% for recycled water usage and 3% for alternative water sources such as rainwater. Text nearby provides detailed explanations of these categories."
}

# **88%**

## **Freshwater**

We define freshwater as drinking-water quality, the majority of which comes from municipal sources, with less than 5 percent sourced from groundwater.

<span id="page-49-0"></span>At our data centers, server upgrades in 2023 resulted in 12 million gallons of water saved. We've also piloted a resin water treatment system that reduced makeup water use by 30 percent and discharge by up to 60 percent. [75](#page-112-0) Based on this success, we're implementing this technology at our data centers in Prineville, Oregon, and Mesa, Arizona.

We also continued to pilot a plant-based water treatment using sustainably harvested sphagnum moss at several data centers, helping eliminate the need for biocides and corrosion inhibitors. This system, which uses compostable, natural sphagnum moss to improve water quality, can further support water savings. We implemented this at our Reno, Nevada, and Maiden, North Carolina, data centers and have begun a permanent installation in Mesa, Arizona.

Our supply chain accounts for 99 percent of our total water footprint, based on our detailed water inventory. We require our suppliers to maintain the high standards for water discharge outlined in the [Apple Supplier Code of Conduct](https://www.apple.com/supplier-responsibility/pdf/FY23-Supplier-Code-of-Conduct-and-Supplier-Responsibility-Standards.pdf). Through our Clean Water Program, we help suppliers minimize process water impacts and adopt best practices in water management and wastewater treatment.

Since the program's launch in 2013, the average reuse rate of the 246 participating suppliers has increased to 42 percent, saving our suppliers 12.7 billion gallons of freshwater in 2023 and a total of over 76 billion gallons of water savings[.76](#page-112-0) These savings come from a range of initiatives, such as the reuse of reclaimed water, upgrades to water-efficient equipment, and countercurrent rinse methods.

# **Site-level water stewardship**

We engage with the communities around our facilities for the protection of local watersheds. Since 2018, we've partnered with the Alliance for Water Stewardship (AWS) to advance the AWS Standard, the first global framework to measure responsible water stewardship across social, cultural, environmental, and economic criteria. In 2020, we joined the AWS board of trustees to highlight water stewardship opportunities to our suppliers and promote collective action on shared water challenges impacting the sector.

Through AWS, we've certified five of the seven data centers that we own and operate in Prineville, Oregon; Reno, Nevada; Maiden, North Carolina; Mesa, Arizona; and Viborg, Denmark. We're on track to certify the remaining two Apple-owned-andoperated data centers by 2025[.77](#page-112-0)

Since 2018, 20 of our supplier sites have been certified to the AWS Standard, 16 of which achieved a Platinum rating — the highest score within the AWS framework. In May 2023, we partnered with AWS and the Suzhou Industrial Park Administration Committee to conduct a training session for Suzhou Industrial Park (SIP) tenants. This training promoted water stewardship and helped establish a more comprehensive water management system for their factories, including Apple suppliers.

#### **CERTIFIED DATA CENTERS**

# **Number of Apple-owned data centers certified by Alliance for Water Stewardship**

Image /page/49/Figure/12 description: {
 "image\_description": "This image depicts a timeline chart showing the progression of data center certifications with key years and locations highlighted, aiming towards a goal of certifying all owned and operated data centers by the year 2025."
}

# <span id="page-50-0"></span>**Replenishment and nature-based solutions**

Replenishment and nature-based solutions are essential tools for addressing water availability, quality, and access. Our goal is to replenish 100 percent of our corporate freshwater withdrawals in high-stress locations by 2030.[78](#page-112-0) This work began in 2022 with projects in Southern California and India, and grew in 2023 with contracted projects in two key locations — Northern California, home to our corporate headquarters, and the Colorado River Basin, home to our Mesa data center.

Our 2023 projects included:

### **Invasive Species Removal in Southern California:**

Funded the removal of the invasive *Arundo donax* cane species in the San Fernando Valley area of the Los Angeles River watershed. This plant monopolizes resources, displacing wildlife and stressing local watersheds. This removal effort by the Council for Watershed Health (CWH) addresses water availability in the watershed, which feeds the greater Los Angeles area.

This project will save an estimated 21 million gallons of water annually.

**Drinking Water Supply in India:** Provided drinking water in partnership with the Uptime Catalyst Facility in India. This total exceeded our corporate freshwater withdrawals for the year. Uptime operates an innovative, performance-based program that enables Safe Water Network and their community partners to maintain and distribute clean, affordable water in Telangana and Maharashtra through more than 300 kiosks.

This program provided approximately 23 million gallons of drinking water in 2023.

**Forest Restoration in Arizona:** Started an initiative with Salt River Project to restore approximately 30,000 acres of degraded and at-risk forest in a source watershed for the Phoenix metro area, which includes our Mesa data center. Our agreement will increase the pace and scale of efforts by the U.S. Forest Service and the Arizona Department of Forestry and Fire Management to strategically thin forests in Northern Arizona at high risk for severe wildfire, which can severely degrade water supplies.

In 2023, the project provided estimated water benefits of 8.2 million gallons. Apple's support of the project is expected to result in 1.8 billion gallons of volumetric water benefits over the next 20 years.

#### **Floodplain Restoration in Northern California:**

Collaborated with River Partners, a leader in largescale, multi-benefit river restoration, on a project that helps restore native vegetation and wetlands on 750 acres of farmland at the confluence of the Sacramento River, Feather River, and Butte Creek. The work also supports the migration and rearing of all four runs of Chinook salmon in the Sacramento River Basin. Our first project in Northern California addresses the critical need to increase floodplain habitat, connectivity, and function for both the environment and communities in California's resource-rich Central Valley. This project will restore the river ecosystem and improve the safety and reliability of the state's flood control system.

Our support is expected to result in nearly 5 billion gallons of volumetric water benefits over 20 years.

# **Advocacy efforts and local partnerships**

Our work in water afforded us another opportunity: to lead with others and push for change across industries. We collaborate with groups, including AWS and the Responsible Business Alliance (RBA), and we speak at conferences and engage with audiences driving impact within their communities and industries

Our 2023 outreach efforts included:

• **Volumetric Water Benefit Accounting methodology:** Engaged in the development of the next phase of this methodology with the World Resources Institute (WRI) to further technical standards in the sector.

• **University of Oxford and Uptime:** Contributed to the briefing paper "Reducing uncertainty in corporate water impact: The role of Results-Based Contracting for drinking water supply," which explains the efficiency and effectiveness of these contracts in delivering corporate funding to augment drinking water supply in developing regions.[79](#page-112-0)

• **Ceres Global annual conference:** Addressed the investor community to highlight the business case for focusing on water impacts.

• **UN 2023 Water Conference:** Presented on the importance of expanding the adoption of water stewardship approaches.

• **AWS Global Water Stewardship Forum:** Participated to share our expanded strategic initiatives in our corporate sites and indirect supplier efforts.

#### • **Catawba-Wateree Water Management Group:**

Joined the Advisory Board to partner locally on sustainable water management in high-water withdrawal basins in which we operate. This organization oversees water management in the Catawba-Wateree Basin, home to our Maiden, North Carolina data center.

• **Water Champion Field Trip:** Hosted 28 brand leaders, suppliers, and local partners to tour nature-based solutions and wetlands restoration projects aimed at reducing water pollution to raise awareness of water issues and water stewardship.

• **Frank Water:** Continued our partnership with the India-based organization that works alongside local partners to support access to safe water, sanitation, and hygiene. In 2023, the grant supported the expansion of the organization's programming from focusing on Bangalore to also include Chennai. This involved implementing the Decision Support System and stakeholder engagement mapping tools, designed with our support, in a new critical region of India.

# <span id="page-51-0"></span>**Zero waste**

**We're committed to eliminating waste sent to landfill — and the environmental costs that come with it. At our offices, retail locations, data centers, and construction sites, we're implementing systems and adopting approaches to avoid sending waste to landfill, and we ask the manufacturers in our supply chain to do the same. Our focus is on innovative approaches to eliminating waste generated during manufacturing and engaging with local specialty recyclers and composters to redirect materials from landfills.** 

**Measuring our progress**  Understanding the amount of waste that we divert at the source and our ability to protect the communities where we and our suppliers operate.

**Prioritizing waste-free operations**  Reducing waste at our own facilities and those of our manufacturing suppliers.

## **Driving waste diversion and elimination** Using zero-waste approaches at our offices, retail locations, and data centers.

**Partnering for waste reduction** 

Promoting and supporting programs and practices for our manufacturing suppliers. And working with specialty recyclers and composters to redirect materials from landfills.

# **Approach 2023 progress**

**74% diversion rate**

In 2023 we achieved a waste diversion rate of 74% for the waste generated in our corporate operations.

**3M metric tons**

As a result of Apple's Zero Waste Program, 3 million metric tons of waste were redirected from landfill by supplier facilities.

**185+ facilities**

More than 185 Apple supplier facilities across 11 countries and regions are zero-waste assured by UL Solutions.

Image /page/51/Picture/19 description: {
 "image\_description": "A picturesque outdoor scene featuring an expansive industrial facility. This facility has modern architecture design, surrounded by green fields under a vibrant blue sky with scattered white clouds."
}

In 2023, our Viborg, Denmark, facility became the third to receive TRUE Platinum certification, which requires more than 90 percent of waste from a facility to be recycled, composted, or redirected for reuse.

# <span id="page-52-0"></span>**Reducing waste at our corporate facilities**

We're reducing the amount of waste generated in our corporate operations and directing more to recycling programs. In 2023, recycling and composting efforts allowed us to achieve a waste diversion rate of 74 percent — up from 71 percent in 2022. We also limited landfill waste from our global operations to about 17,400 metric tons[.80](#page-112-0)

We've continued our efforts to make progress on waste diversion since achieving our first zero-waste certification, UL Solution's Zero Waste to Landfill Validation, in 2015 for our campus in Cork, Ireland. In 2023, our Taiwan Technology Center became the second Apple facility to receive the UL Solutions Zero Waste to Landfill Validation[.81](#page-112-0) Our corporate offices in Sacramento, California, as well as our data center in Viborg, Denmark, received TRUE certification in 2023, joining our data centers in Mesa, Arizona, and Prineville, Oregon.[82](#page-112-0) These facilities achieved TRUE Platinum, the highest certification level. TRUE recognizes facilities that divert more than 90 percent of waste for recycling, compost, or reuse.

## **Promoting material reuse, composting, and waste diversion across our corporate and retail locations**

We prioritize finding opportunities to recycle construction and demolition waste and recently accomplished the following:

- In 2023, our recycling and source separation from corporate office and data center construction and demolition efforts resulted in a waste diversion rate of 88 percent — approximately 23,600 metric tons.
- New initiatives at our San Diego and Culver City campuses, alongside more than 30 participating locations, achieved an average diversion rate of 91 percent.
- We also developed several specialty recycling initiatives to return materials back to their original supplier. The program salvaged more than 100 metric tons of material, yielding over 50 metric tons of both ceiling tile and sheetrock, over 40 metric tons of carpet tile, and over 6 metric tons of glass to reuse the materials in new products.

**Reusable Air Filters:** In 2023, we fully switched to reusable air filters to reduce waste sources — like packaging materials and commonly used equipment. Previously, no off-the-shelf reusable air filters were available for our application. In 2019, we partnered with an industry-leading automotive filtration and technology company to design a sustainable solution that met very specific design criteria for our design centers. And to date more than 58,000 reusable high-performance air filters — which are also available for other companies to use — have been placed in Apple-managed facilities worldwide. By replacing disposable air filters with reusable ones, we avoid landfilling 25 tons of dirty filters each year. Further, the reusable air filters are more energy efficient, leading to 35 percent savings in fan energy use.

**Managing hazardous waste:**We remain committed to safely and responsibly managing hazardous waste. To make sure that wastes are treated, recycled, or incinerated according to safety and environmental standards in the U.S., Apple performs audits of treatment, storage, and disposal facilities (TSDFs), with seven performed in 2023. We continually reevaluate the facilities that dispose of and manage hazardous and regulated wastes, working to assess disposal methods, availability, economics, and sustainability.

## **Driving solutions internally through communication, reporting, and education**

Our employees play a critical role in reporting on waste and facilitating waste audits at our locations. We support these efforts with training, education, and access to resources. In 2022, we standardized waste reporting requirements and implemented a centralized dashboard system across all our data centers and corporate offices. Our retail auditing program examined five locations in North America, documenting the material characteristics of our waste. This data is allowing for better assessment of our waste practices and opportunities to improve our approaches. We also provide site-specific zerowaste training for all Apple data centers. All new data center employees are required to complete the site-specific zero-waste training and receive manager approval of completion.

# **25tn**

We partnered with an industry-leading automotive filtration and technology company to design a sustainable air filtration solution that helps avoid landfilling 25 tons of dirty filters per year.

# <span id="page-53-0"></span>**Taking a zero-waste approach with our suppliers**

We're committed to zero waste. Apple employees, suppliers, recyclers, and waste solution providers are central to achieving this goal. Since we launched the Zero Waste Program for our manufacturing partners in 2015, we've continued to make considerable progress. And we've expanded this program to include more than 350 supplier facilities across 13 countries and regions.

We require our suppliers to take part in our Zero Waste Program as part of our Supplier Code of Conduct. Suppliers must implement a systematic approach for identifying all waste sources and characterizing each stream in the waste inventory, developing a program or solution to quantify and monitor their waste-to-landfill diversion rate, setting waste minimization goals, and maintaining progress toward achieving zero waste to landfill. Our Zero Waste Program provides training and tools to help suppliers track their waste, set waste minimization goals, and create improvement plans for achieving zero waste in their operations.

In 2023, the Supplier Zero Waste Implementation Plan became part of our assessment requirement, following a year of training and piloting. Now all our key manufacturing suppliers must implement the Zero Waste Program, which includes evaluating their performance against the program's criteria.

As part of the Supplier Code of Conduct requirement, we also require more than 1,000 supplier production facilities to report waste inventory to Apple annually. Facilities have received trainings and templates to record and correctly classify waste data and document the visible diversion rate. To verify the waste data quality, we partnered with third-party auditors to conduct sample evaluations, which focused on waste classifications, waste data recordkeeping and reporting, and reasonable waste treatment methods.

We provide all facilities participating in the program with resources and guidance on how to reduce waste and reuse, recycle, or compost waste. Suppliers at these locations can also access tools to improve waste management and, in some cases, onsite support. The program is making an impact: In 2023, suppliers redirected more than 497,000 metric tons of waste from landfills, bringing the total to 3 million metric tons since the program's inception — equivalent to eliminating 3.7 million square meters of landfill space. Throughout 2023, 100 percent of established final assembly sites maintained zero-waste-to-landfill operations.[83](#page-112-0)

And we're working on the next challenge in achieving zero waste, which is a level deeper into the subassembly module suppliers who assemble the individual components of Apple products. The waste stream at this level is often more complex than at final assembly sites, but we're making progress. As of 2023, more than 300 module suppliers

have participated in Zero Waste Program since its inception — including those who provide core technology components, displays, PCB and flex, packaging and enclosures. They've diverted more than 352,000 metric tons of waste from landfills.

#### **Pushing toward zero-waste innovation**

We use novel recycling strategies and approaches to divert greater quantities of waste from landfill in our supplier facilities at greater rates. We also pursue material solutions to impact the waste streams coming into these facilities to simplify and maximize the recyclable content that our suppliers work with.

Plastics comprise one of the major waste streams in our supply chain. For this reason, we've focused our efforts on reducing the amount of plastic waste generated during manufacturing. In 2018, we partnered with a key material vendor to develop components that have helped our suppliers reduce waste. These include recyclable protective films (RPFs) that safeguard products during manufacturing and reusable trays used to securely deliver modules through assembly sites.

We're also working to reduce more complex waste streams, including processing chemical waste found further upstream in our supply chain. One typical process waste is coolant, a chemical material used to cool the surface of machinery involved in manufacturing components like enclosures. To avoid sending coolant waste to landfill or an incinerator, we launched a series of coolant reduction initiatives

Image /page/53/Picture/14 description: {
 "image\_description": "A storage area featuring vertically stacked black and red racks extending along a concrete walkway."
}

In 2023, we fully switched to reusable air filters to reduce waste sources — like packaging materials and commonly used equipment.

<span id="page-54-0"></span>in our enclosure supply chain. We focused on reducing coolant usage by implementing minimum quantity lubricant (MQL) technology, an ultraviolet or ozone approach to recycling coolant, and end-of-life recycling. These initiatives have reduced more than 20,000 metric tons of coolant-containing waste in the past year.

#### **Engaging with suppliers to reduce waste**

We work closely with our suppliers to realize our zero-waste goals. This work faces a range of challenges, including a lack of access to recycling technologies, the absence of local infrastructure, and the lower value of recyclable material that impacts the economics of recycling.

In 2023, we focused on reducing a significant portion of plastics in manufacturing and transportation of our products. With packaging, we've already made significant progress in transitioning to fiber-based materials. We're now working to extend that success to the packaging module components used by our suppliers during transportation and at assembly sites. Our suppliers have developed fiber alternatives to replace plastic films, foams, and bags. The initial pilot, launched in 2022, focused on reducing waste associated with iPad; the program now includes iPhone, Mac, Apple Watch, and AirPods. Since this effort began, our suppliers have saved 3,600 metric tons in plastic used while manufacturing and transporting our products.

The Waste to Resource database we designed provides access to available technologies and local recyclers that we've recommended by the suppliers we work with. The database includes information on more than 1,500 resources across more than 250 cities in China, Thailand, India, and Vietnam — a number that grows as we and our suppliers share valuable resources through the database. As more of our suppliers achieve their zero-waste goals, we're able to learn and share more information. We plan to make this resource public for the benefit of the entire electronics industry.

One example of a resource benefiting the industry is a tool developed by Apple and UL Solutions, our partner that validates zero-waste efforts. The tool provides the first-ever supply chain zero-waste management system assurance program, enabling third-party zero-waste verification at a systems level rather than at a site level. The assurance procedure has allowed us to accelerate the verification process significantly and establishes a new model that companies across industries can employ to verify zero-waste programs at scale. This streamlined approach has brought even more suppliers into our program, with more than 185 facilities assured in 2023 by UL Solutions — 35 more than the previous year[.84](#page-112-0)

We also provide support for our suppliers in verifying their zero-waste efforts. Since launch, the foundation of our Zero Waste Program has followed the UL 2799 Zero Waste to Landfill Environmental Claim Validation Procedure (ECVP), which requires at least 90 percent

diversion through methods other than waste-toenergy. Through this standard, our supplier facilities can certify against clear benchmarks for waste diversion, including Platinum, Gold, and Silver levels of verification. We've spent the last seven years expanding this program throughout our supply chain, with suppliers in China, India, and Vietnam becoming UL validated. Since we switched from individual site verification to system-level verification, suppliers participating in the assurance program can easily apply their verification statements from UL.

#### **Supplier capability development**

To address the challenge of waste classification for suppliers across different countries and regions, we've created the Apple Recommended Waste Category List that provides standardized guidance on how to classify different types of waste. This has been implemented widely and used by suppliers in the Zero Waste Program. Suppliers have also received access to training and coaching on waste classification to support their efforts in separating waste while promoting waste reduction, reuse, and recycling.

The data we've aggregated summarizes the top 10 waste streams — including plastics, papers, and metals — and their corresponding diversion solutions. This provides a valuable perspective on the waste footprint across our supply chain; it also shows us where we can expend our efforts on material utilization to reduce the amount of waste sent to incineration or landfill.

Starting in 2022, Apple organized a series of webinars with suppliers, policymakers, and industrial leaders to share their experiences in the Zero Waste Program with participating suppliers and those who plan to join. These sessions provide an opportunity to discuss lessons learned implementing the Zero Waste Program, best practices around the compliance requirements of waste management, and emerging recycling and reduction technologies.

We're focused on expanding the impact of the Zero Waste Program in our supply chain and beyond. In 2023, we launched a zero-waste education initiative in India. Supported by our Supplier Employee Development Fund, we've been able to design a series of zero-waste-related trainings specific to India for supplier leadership, employees, and members of local communities.

We've offered several learning programs in India that cover sustainability basics, the roadmap for achieving zero waste, and best practices in waste management. These include supplier classroom sessions in Bangalore and Chennai focused on leadership capabilities and training to help scale the Zero Waste Program, as well as community e-learning resources to introduce sustainable living, domestic composting, and basic waste management beyond the workplace that can benefit everyone.

# **FEATURE Green buildings**

**Whether we're constructing a data center or corporate office or restoring a historic site to house a retail store, we have an opportunity to advance our vision of the world we'd like to live in — one that's inclusive and accessible, reflects the value we place on creativity and innovation, and furthers our environmental goals.**

Our environmental approach to design and construction adheres to industry-recognized best practices for green buildings that promote renewable energy, water conservation, energy efficiency, and responsible material sourcing. As of 2023, 108 of our corporate offices, data centers, retail stores across the world, totaling more than 18 million square feet of green building space, are Leadership in Energy and Environmental Design (LEED) or Building Research Establishment Environmental Assessment Method (BREEAM) certified.

Our global footprint requires that we adapt to the needs of different locations and climates while pursuing our overall objectives. In 2023, two Apple sites in Israel and Spain earned LEED Gold certification and one location achieved Platinum certification — our first in Southern California to do so. A building on our Culver City campus demonstrated reductions of more than 45 percent reduction in indoor water use and more than 15 percent in energy use. For construction and demolition waste, the site diverted more than 75 percent of materials. The location was also recognized for its ease of commuting, including its proximity to seven public transit lines, the availability of bike racks and showers for employees who cycle to work.

We bring a similar environmental approach to our retail store development. In Mumbai, India, we opened Apple BKC — our first retail location in the nation — which earned LEED Platinum certification. The store's energy-efficient design, use of natural light, and onsite photovoltaic panels helped achieve energy savings of more than 40 percent, and its low-flow fixtures and onsite

gray water recycling reduced water consumption by more than 84 percent. The site also diverted 95 percent of the construction waste from landfill while using sustainably harvested wood for the ceiling, furniture, and fixtures. The success of these efforts resulted from a strong partnership with our local landlord partner who shared our values and priorities, ensuring that our collective environmental objectives were achieved.

Our new Apple Battersea retail location in the historic Battersea Power Station in London is trending to achieve a BREEAM Very Good rating. The build-out of the store and offices resulted in a 99 percent rate of diversion for construction waste. The retail store project uses our newest and most sustainable design language and materials, which heavily focuses on low-carbon design elements including a biopolymer terrazzo floor, sustainably harvested wood, reduced steel tonnage, and an acoustic baffle ceiling.

Each Apple building needs to coexist with its environment while meeting our standards for human-centric design. We work hard to strike this balance and harness the creativity and innovation that these challenges demand.

Image /page/55/Picture/10 description: {
 "image\_description": "This image depicts the opening event of an Apple Store, named Apple BKC, with the surrounding showing a lively crowd and excited staff wearing green shirts. It features prominent Apple branding on the glass exterior of the store and heavy media presence. There is visible excitement and interaction occurring during the event."
}

Our environmental approach is mindful of energy and resource use. Apple BKC earned LEED Platinum certification.

# **108**

As of 2023, 108 Apple buildings worldwide are LEED or BREEAM certified for environmental performance.

<span id="page-56-0"></span>**[Apple 2030](#page-7-0) [Resources](#page-37-0)**

### **Smarter Chemistry**

[Approach](#page-57-0) [Mapping](#page-58-0) [Assessment](#page-60-0)

[Innovation](#page-62-0)

# **Displaying smarter thinking**

**iPhone 15 models use arsenic-free glass and are also free from mercury, brominated flame retardants, and PVC.**

# **Smarter Chemistry**

Image /page/56/Picture/9 description: {
 "image\_description": "The image depicts a close-up view of a smartphone screen's upper region, displaying a cutout for front-facing cameras and sensors, surrounded by a sleek metallic bezel and a light-colored textured background design."
}

# <span id="page-57-0"></span>**Approach**

# **Smarter Chemistry**

**We identify and use the chemicals and materials that best serve our priorities of safety, performance, and the environment. This approach is the foundation of smarter chemistry — and it underpins our efforts across our supply chain.**

Smarter chemistry is our approach to proactively promoting the use of safer materials and chemicals. We identify chemicals that balance our priorities including safety and performance — minimizing our environmental impact. The program supports the steps we're taking toward a circular supply chain by reducing the recirculation of potentially harmful substances, and it contributes to a healthier workplace for our manufacturers and suppliers.

We focus on limiting chemical exposure through the commonly used hierarchy of controls. The concept consists of five actions that organizations can take with materials:

- Elimination
- Substitution
- Engineering controls
- Administrative controls
- Personal protective equipment (PPE).

We prioritize elimination and substitution, and when no alternative is available to eliminate or substitute potential exposure, we rely on engineering and administrative controls to safeguard against hazard exposure.

Our program involves establishing safety requirements that often exceed local industry standards and supporting our suppliers. We've created standards and programs to support these efforts, including the rigorous requirements defined in our [Regulated](https://www.apple.com/environment/pdf/Apple_Regulated_Substances_Specification.pdf)  [Substances Specification \(RSS](https://www.apple.com/environment/pdf/Apple_Regulated_Substances_Specification.pdf)) and the deep supply chain engagement through our Full Material Disclosure (FMD) and Chemical Safety Disclosure (CSD) programs.

Maintaining comprehensive information on the chemicals and materials we use is essential. It helps us better protect the people who design, make, use, and recycle our devices. This information also informs our efforts to protect the environment and work alongside leading members of the scientific community, NGOs, and industry organizations to push for the development and broad adoption of safer alternatives. We also share what we've learned in creating these systems with others in the industry — and we push for change that can transform product manufacturing.

Advocacy and leadership are needed to make this happen. We're committed to this role — pushing to broaden the use of safer and more sustainable materials based on smarter chemistry — and working with our suppliers and material manufacturers to create alternatives that can help move our industry forward.

# **Strategic pillars**

**[Mapping](#page-58-0)** Engaging our supply chain partners to comprehensively identify the processes and chemicals in the materials used to make our products. This allows us to drive change that goes beyond what's required for regulatory compliance.

### **[Assessment](#page-60-0)**

Assessing the potential human health and environmental risks of material chemistries to evaluate compliance with our requirements and inform product design.

industrywide change.

**[Innovation](#page-62-0)** Driving the development and use of innovative materials that enables the creation of groundbreaking products and support

Image /page/57/Picture/24 description: {
 "image\_description": "This image depicts a gloved hand handling transparent containers filled with liquids and test samples. It is indicative of a laboratory or material testing scenario."
}

We test all our products, and place special attention on materials that come into prolonged skin contact.

# <span id="page-58-0"></span>**Mapping**

**We're committed to creating products of the highest quality — and that commitment extends to the health and environmental impacts of everything we make.** 

Through collaboration, we can build a comprehensive view of the chemicals in the materials that we use and drive improvements in how we make our products.

Our Full Material Disclosure (FMD) program maps the materials in our products and their chemistries, while our Chemical Safety Disclosure (CSD) program tracks the materials used to manufacture our products. We drive our supply chain partners to collect in-depth information on the material chemistries they use, including their purpose, the amount consumed, and how the chemicals are applied, stored, and handled. We also work closely with our partners to review the steps they're taking to protect their employees.

And we examine the effects of material chemistries across a product's life — from design and manufacturing to the customer experience and, ultimately, recycling and recovery. This information guides our decisions when it comes to health and environmental risks. The changes we're making have an impact beyond our footprint and across our industry, supporting our efforts to build responsible circular economies at scale.

# **Building a comprehensive view of the materials in our products**

We rely on detailed and comprehensive information to guide our decision-making on material chemistries. The FMD program, launched seven years ago, aims to catalog and map each chemical in the materials used in our products. Material manufacturers provide thorough reporting on material compositions from deep within our supply chain — proprietary data that's shared through our secure data collection system. This system enables us to make informed choices about the materials that are used. For iPhone, iPad, and Mac products released in 2023, we collected detailed chemical information on 93 percent of each product on average, by mass. For Studio Display, we collected information on more than 95 percent of the product by mass.

Our suppliers are required to participate in the program. Collectively, they share information on thousands of materials used to manufacture our products. To make this process easier, we've implemented an advanced collection system for suppliers with access to a library of more than 60,000 materials, which have been researched and validated by Apple. Our suppliers use this library to select the materials they use in our products. When a material that a supplier uses isn't yet listed in our library, we authenticate the new material with documentation from the manufacturer that provides it.

The FMD program includes tens of thousands of parts and assemblies across our product lines. We prioritize high-volume materials and those that come under prolonged skin contact, which we look closely at for biocompatibility. The program helps address a challenge that's faced across our industry: the lack of visibility into the chemical composition of materials. To reduce potential toxicological risk and pursue opportunities to develop better chemistries, we rely on deep knowledge of the materials used. Through the program, we're able to identify these opportunities to improve and contribute to our safety and environmental goals.

#### **PRODUCT LIFE CYCLE**

**Recycling** Recyclers can recover materials that are safer for use in new products.

# **Smarter chemistry matters at every stage in the product life cycle**

Image /page/58/Figure/13 description: {
 "image\_description": "The image depicts a section of Apple Inc.'s material and process workflow highlighting its commitment to environmental standards in product design through the Regulated Substances Specification (RSS)."
}

**Manufacturing** Apple requires suppliers to manage materials and chemicals and helps them switch to safer alternatives.

**Product use** Customers use products made with smarter materials. The comprehensive materials library helps inform decisions across our product life cycles. It drives better material selections by our supply chain partners through the RSS, and it provides a foundation for assessing the materials that we specify, how our products are manufactured, and, eventually, how they'll be recycled. We use innovative approaches to this process, including machine learning to digitize data from chemical tests so this information can be more easily assessed. And we're finding ways to share this information by supporting the development of industry standards that will help encourage the exchange of data on materials. These efforts support our goals of improving the safety of our products, as well as the broader electronics industry and beyond.

# **Creating an inventory of chemicals used in manufacturing**

The Apple Supplier Code of Conduct and Supplier Responsibility Standards outline our requirements for our suppliers in the areas of health and safety, labor and human rights, the environment, ethics, and management systems. We also account for how chemicals are selected and managed within our

supply chain — and the impact this can have on the health and safety of people working in our supply chain. Read more about our work across our global supply chain in our [People and Environment in Our](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [Supply Chain 2024 Annual Progress](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report) Report.

Detailed and accurate information drives this process, including which chemicals our suppliers use as they make our products and how they store, handle, and consume each one. Through the CSD program, suppliers are required to provide this data as part of a rigorous disclosure process. With a detailed chemical inventory from our suppliers, we can support our supply chain partners in identifying risks and opportunities to implement safer alternatives.

In 2023, more than 1000 supplier facilities shared their chemical inventories as well as their storage and control information through the CSD program, including suppliers representing the majority of Apple's direct spend. And through this program, we've identified more than 17,000 unique materials and chemicals used in the manufacturing process. All these efforts contribute to a safer work environment for people across our supply chain.

**COMPREHENSIVE CHEMICAL MAPPING FOR SAFER PRODUCTS**

# **We account for how chemicals are selected and managed within our supply chain**

## **An understanding of chemical ingredients leads to better materials for Apple products**

Through the FMD program, Apple manufacturing partners share the materials they use to manufacture Apple products.

Apple works with material manufacturers to understand the chemistries of the materials to enable evaluation.

**Data helps Apple suppliers manage chemicals and materials when making Apple products**

Through our CSD program, suppliers share information with Apple about how they use chemicals, store the chemicals, and protect their employees.

CSD data informs and prioritizes supplier engagement, encouraging rigorous chemical management practices and adoption of safer alternatives.

**Apple customers benefit from using products made with safer materials and chemicals**

The FMD and CSD programs support the creation of quality products in a responsible manner for our customers.

# <span id="page-60-0"></span>**Assessment**

**We base key decisions about our product designs, manufacturing processes, and approaches to recycling and reusing on the data that we collect on chemicals and materials. This information enables us to establish requirements for our suppliers, including the requirements set in our Regulated Substances Specification and our Restricted Chemicals for Prolonged Skin Contact Materials specification.** 

Our requirements provide clear restrictions on potentially harmful chemicals in materials, including those that are restricted. Our assessment system supports our efforts to ensure that only materials that meet our stringent requirements are used in Apple products. The data that we gather on chemicals and our assessments allow us to make informed decisions about chemical management for the safety of those who use, make, and recycle our products. These decisions also help make the materials recovered from our products at end of life safer for reuse in new products, enabling circular supply chains.

# **Setting and maintaining rigorous chemical safety requirements**

We first published the [Regulated Substances](https://www.apple.com/environment/pdf/Apple_Regulated_Substances_Specification.pdf)  [Specification](https://www.apple.com/environment/pdf/Apple_Regulated_Substances_Specification.pdf) over 20 years ago, establishing requirements for the use of chemicals or materials in our products, accessories, manufacturing processes, and packaging. The specification builds on our history of advancements in material safety — and it reflects our dedication to the collection of necessary data to uphold these requirements.

We continue to evolve the RSS with new chemicals and restrictions based on the latest scientific research and standards, drawing from regulations, international standards, and voluntary requirements. Many of the specification's restrictions exceed the most stringent local regulatory requirements in order to protect workers health and the environment. The specification designates restricted substances and requires reporting on additional substances. We've updated and expanded chemical restrictions that, in many instances, surpass current regulatory restrictions. Most recently, we've added perfluorohexanesulfonic acid (PFHxA) — a subset of the larger group of PFAS — phenol, isopropylated, phosphate (3:1) (PIP 3:1), and several skin-sensitizing substances well ahead of regulatory restrictions.

Our Green Chemistry Advisory Board provides feedback on key initiatives, including potential updates to the RSS. The advisory board is an independent group of leading researchers and academics. Their diverse experience and perspectives help us lead the way in protecting our customers and those who make or recycle our products.

We apply controls to materials that come into prolonged skin contact (as defined in our [Restricted](https://www.apple.com/support/assets/docs/products/watch/Restricted_Chemicals_for_Wearables.pdf)  [Chemicals for Prolonged Skin Contact Materials](https://www.apple.com/support/assets/docs/products/watch/Restricted_Chemicals_for_Wearables.pdf) list). The restrictions focus on substances that are potential skin sensitizers to minimize the potential for reactions commonly reported across wearable products, like jewelry. We derive these restrictions from leading standards, recommendations from toxicologists and dermatologists, international laws and directives, and Apple policies. We mandate that our suppliers analyze each material that comes into prolonged contact with skin according to Apple's requirements, and we review compliance with these requirements. Our specifications are incorporated into contractual obligations for our suppliers, and each one helps us maintain our stringent requirements.

# **Verifying and developing in the environmental testing lab**

We evaluate the safety of our products and materials through chemical analyses at our Environmental Testing Lab. Our chemists test materials to monitor compliance with our specifications. The lab continues to grow in its mission and capacity; we're expanding our testing facilities with new technologies to conduct chemical analysis while broadening our FMD and CSD programs. Our teams also review test reports from suppliers to evaluate substances against the Regulated Substances Specification and Restricted Chemicals for Prolonged Skin Contact Materials specification. In 2023, we performed toxicological assessments on more than 1600 new materials to proactively evaluate and eliminate potentially harmful substances from our products.

The data that we collect from our disclosure programs drives our assessments. We're able to generate comprehensive assessments like GreenScreen®, a methodology that we use to gauge the potential impact of chemicals on individuals' health and the environment based on 18 criteria. We develop toxicological profiles on new chemicals using both scientific literature and internal assessments. These profiles detail the impacts of each chemical, providing data that allows us to evaluate the safety of using a substance in a particular product. In 2023, we continued to expand the scope of biocompatibility testing beyond individual materials to include modules and whole

# **1,600+** Performed toxicological assessment on more than 1,600 new materials in 2023.

Image /page/61/Picture/2 description: {
 "image\_description": "This image showcases a person wearing blue gloves and using a white cloth to clean the screen of a tablet or electronic device, focusing on maintaining cleanliness and hygiene standards in handling electronics."
}

products. Through this work, we have an even more comprehensive view of each material and the potential impact that assembly has on safety. We perform toxicological analysis of the materials in our products to help guide our material safety guidelines. The information that we share through material specifications benefits our suppliers and those who we collaborate with in the industry.

# **Working with suppliers to meet global requirements**

We've created systems for our suppliers to learn about our material specifications, track and assess the materials they use, and regularly communicate material usage. This also helps our suppliers meet global standards and regulations governing their operations. The FMD and CSD programs require suppliers to gather, understand, and share information on materials they're using — beyond regulatory requirements.

We support suppliers' engagement with these programs — and the RSS — through ongoing training. This continued engagement is central to our partnership and to our shared efforts to promote smarter chemistry in our products and processes. Since 2020, our suppliers in China have worked under new regulations governing the use of materials containing volatile organic compounds (VOCs). In 2023, we continued to provide additional support for suppliers through trainings on the

new regulations, which were attended by more than 490 participants who helped validate over 3,300 materials for low-VOC compliance. By deploying a VOC specification worldwide, we're also helping drive adoption of low-VOC alternatives around the world. And we're working with our suppliers to identify and develop alternate non-PFAS materials materials without regrettable substitutions that meet the current and upcoming complex per- and polyfluoroalkyl substances (PFAS) regulatory requirements.

# **Creating a list of safer cleaners**

We're making an immediate impact in our efforts to protect workers and the environment through our approach to the application of cleaners and degreasers, which are some of the highest-use materials at final assembly sites. Regulators and environmental health and safety organizations have focused considerable attention on the chemistries of cleaners and degreasers. We're investing in the due diligence required to identify preferred alternatives for suppliers and others in the industry to use.

We've eliminated the use of cleaners with known carcinogens, mutagens, reproductive toxicants, strong sensitizers and persistent bio-accumulative toxins (including PFAS) from cleaners and degreasers used at our supplier final assembly sites. We did this by using globally recognized standards (such as EPA Safer Choice, GreenScreen Certified® and ToxFMD®)

based on chemical hazard assessments, because this is a more comprehensive and robust hazard approach than simply eliminating individual substances of concern. In 2023, we approved additional safer cleaners for use in our supply chain, bringing the total number of safer cleaners we've approved over the past three years to 175.

Our efforts have had a direct impact on health and safety — and they have the potential to change how our industry operates. By making it easier for suppliers to select safer alternatives for process chemicals at the outset, we're promoting their use across our supply chain. All our final assembly sites have used only safer alternative cleaners and degreasers, as defined by Apple, since 2018. We've since expanded this work deeper into our supply chain to suppliers and processes beyond final assembly, helping them identify and implement opportunities to use safer alternatives in their operations. In 2023, we received, for the third time in four years, the EPA Safer Choice Partner of the Year Award for our work to scale the use of safer process chemicals and to protect those who work in our supply chain.

We're also looking outside our own supply chain to promote a broader transition to safer chemicals. See [page 65](#page-64-0) for more information on how we're advocating for safer cleaners and degreasers across our industry.

We've deployed our VOC specification worldwide, we're also helping drive adoption of low-VOC alternatives around the world.

# <span id="page-62-0"></span>**Innovation**

**We're continually improving on the chemical safety, performance, and environmental impact of materials by expanding our knowledge of material properties. Our assessments of substances focus on those three areas of improvement and help us pursue innovations that align with our values.** 

The work we do in mapping, assessing, and managing the chemicals used in our products and supply chain lays the foundation for material innovations. We also look at how these materials are used in a product life cycle, from design and manufacturing to end of life. With this knowledge, we can seek out and support the development of safer chemistries, and we can continually improve the overall safety of our products and processes.

# **Creating new, safer chemistries to move the industry forward**

Our strict requirements that govern potentially harmful substances in our products and processes encourage our manufacturing partners to also prioritize safer materials, helping create a market for better alternatives. We're lending our expertise on safer chemistries to support our suppliers as they meet the growing demand for safer materials. Prioritizing these materials also means phasing out chemistries that don't meet our specifications. We've approached this across our company and products while investing in safer alternatives to drive change across our industry. The use of safer cleaners today supports the circular supply chains of the future.

Using our research and analysis of materials, we've collaborated with suppliers to create safer alternatives — including for substances where none currently exist. In those cases, we lend our technical capabilities in material science to work with suppliers to develop entirely new chemistries. We maintain the same high safety, performance, and environmental standards for new alternative materials, submitting them through rigorous testing and evaluation to avoid regrettable substitutions.

We've led in the identification and successful removal of potentially harmful substances since the late 1990s. This process has involved rigorously assessing chemicals and removing those that don't align with our goals — in some cases, before removal becomes a requirement and industry standard. We're committed to phasing out our use of PFAS and engaging with all our supply chain partners to restrict PFAS from our products and manufacturing processes.

While our analysis indicates that PFAS used in our products are safe during product use, we felt it was important to broaden our scope to consider manufacturing along the supply chain. We're prioritizing our phaseout activities in applications that result in the highest volumes of PFAS reductions and the most meaningful environmental impact. We're pursuing our phaseout in three steps: compiling a comprehensive catalog of PFAS uses in our products, identifying and developing non-PFAS alternatives that can meet our performance needs, and confirming that non-PFAS alternatives align with our safety and environmental goals. We have created new formulations of plastics, adhesives and lubricants with PFAS replaced by other existing technologies in order to achieve similar performance in flame resistance and friction reduction.

# **Driving the creation of better dyes**

In partnership with our suppliers, we're creating dye formulations in our anodizing processes that better safeguard worker health and the environment. The innovation challenge was to achieve the quality and selection of colors that meet our rigorous design standards while improving environmental performance. We narrowed our options to the most color-versatile and UV-stable dyes, and we engaged with our manufacturers to develop a wide range of colorants. These alternatives mitigate the risks associated with conventional dyes used in anodizing processes, including potential workplace exposure and impact on the local environment through discharge.

## Read our [white paper](https://www.apple.com/environment/pdf/Apple_PFAS_Commitment_November-2022.pdf) about our commitment to phasing out perand polyfluoroalkyl substances.

#### **APPLE'S REGULATED SUBSTANCES**

**We go beyond regulatory requirements by using safer materials to protect those who make, use, and recycle our products**

#### **Materials selection**

#### **Per- and polyfluoroalkyl substances (PFAS)**

We proactively removed PFOA and PFOS from our products in 2010 and 2013, respectively, far ahead of global requirements. We've also committed to eliminating PFAS entirely from our products ahead of our industry peers. We plan to do this by developing or selecting non-PFAS alternatives that do not result in regrettable substitutions.

## **Manufacturing**

## **Safer cleaners and degreasers**

We've eliminated the use of cleaners and degreasers that contain known carcinogens, mutagens, reproductive toxicants, strong sensitizers and persistent bio-accumulative toxins (including PFAS) from cleaners and degreasers used at our supplier final assembly sites. We did this by using globally recognized standards (such as EPA Safer Choice, GreenScreen Certified® and ToxFMD®) based on full formulation-level (or material-level) chemical hazard assessments, because this is a more comprehensive and robust approach than simply eliminating individual substances of concern.

# **Product use**

### **PVC and phthalates**

We've replaced PVC and phthalates with safer thermoplastic elastomers.\* Phthalates are known endocrine disruptors which are not bound in PVC and can leak. Both are still used by other companies in power cords and headphone cables.

**Recycling**

#### **Brominated and chlorinated flame retardants**

We've replaced brominated and chlorinated flame retardants with safer metal hydroxides and phosphorous compounds because brominated and chlorinated flame retardants reduce the recyclability of plastics and limit material circularity. Incineration of waste plastics containing brominated and chlorinated flame retardants can release toxic chemicals such as dioxins and furans.

\* Every Apple product is free of PVC and phthalates except for AC power cords in India, Thailand (for 2-prong AC power cords), and South Korea, where we continue to seek government approval for our PVC and phthalates replacement.

# <span id="page-64-0"></span>**Advocating for safer alternatives across our industry**

Our work around smarter chemistry helps facilitate the transition to safer alternatives that are accessible to others in our industry. Identifying and promoting the use of safer cleaners beyond Apple is a way to increase the impact of safer alternatives. The criteria we set for chemicals in materials — and how our suppliers use them — help establish even more stringent standards around health and safety across the electronics industry. We collaborate with standards-setting bodies, trade associations, and NGOs to achieve this — developing tools, standards, and mechanisms to drive the identification and adoption of smarter chemistries throughout our supply chain.

We've focused on cleaners and degreasers, building out multiple pathways to advance industry innovation in safer cleaners. For the past five years, our final assembly sites have exclusively used safer cleaners and degreasers, as identified by Apple or as certified by third-party programs. This work has expanded to component manufacturers who create modules used in the final assembly of our products. Our

efforts to use safer cleaners in our supply chain have been central to our advocacy for greater industry collaboration and instrumental to our participation as a founding signatory of the Toward Zero Exposure program led by the Clean Electronics Production Network (CEPN). For more information about Apple's participation in CEPN, read our [People and](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [Environment in Our Supply Chain 2024 Annual](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [Progress](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report) Report.

We collaborated with IPC, a globally recognized electronics standards-setting body, to draft and help launch IPC-1402, Standard for Green Cleaners Used in Electronics Manufacturing. This standard resulted from work over the past three years with the Green Cleaners for Electronics Manufacturing task group, where Apple has served as a chair working with more than 20 industry partners. This new standard will help suppliers across the electronics industry select cleaners that are safer for workers and the environment. In 2022, Apple received the IPC Stan Plzak Corporate Recognition Award for our work on this effort and our contributions to the industry.We continued to partner with ChemFORWARD, a nonprofit organization committed to creating broad

access to chemical hazard data to make it easier for suppliers to choose safer alternatives. In 2023, we worked with ChemFORWARD to announce a new open resource called ChemWorks that aims to help others identify certified safer formulations to accelerate the adoption of safer cleaners and degreasers as we have in our own supply chain.

We also supported the Responsible Business Alliance (RBA) in producing a comprehensive technical guide on responsible chemical management, as well as more than 20 hours of related training content to educate workers across many companies about controlling occupational exposures to hazardous chemicals.

#### **SAFER CLEANER JOURNEY**

# **Our efforts to use safer cleaners in our supply chain have been central to our advocacy for greater industry collaboration**

# **2018**

**Achieved** 100% participation of final assembly supplier sites into the Safer Cleaners Program

## **2020**

**Achieved** EPA Partner of the Year Award for the first time

## **Established**

internal Safer Cleaners list containing 54 cleaners

## **2021**

**Transitioned** internal criteria to industry GreenScreen® certificates

## **96**

added 42 additional cleaners added to the Safer Cleaners list, totaling 96 cleaners

#### **2022**

**Published** certified Safer Cleaners List for industry use with ChemWorks Product Registry

### **133**

added 37 additional cleaners added to the Safer Cleaners list, totaling 133 cleaners

#### **Partnered**

with Clean Production Action (CPA) to utilize Safer Cleaner criteria for GreenScreen certificates

## **2023 175**

added 42 additional cleaners added to the Safer Cleaners list, totaling 175 cleaners

#### **Expanded**

the Safer Cleaners Program deeper into the supply chain to processes beyond final assembly

#### <span id="page-65-0"></span>[Contents](#page-1-0) [Introduction](#page-2-0) [Environmental Initiatives](#page-5-0) **Engagement and Advocacy** [Data](#page-75-0) [Appendix](#page-83-0) 2024 Environmental Progress Report 66

[Approach](#page-66-0) [Listening to a range of voices](#page-67-0) [Achieving change together](#page-68-0) [Supporting communities worldwide](#page-72-0)

**Amplifying through advocacy Collaborating with others to achieve clear impact across our environmental initiatives and beyond.**

# **Engagement and Advocacy**

# <span id="page-66-0"></span>**Approach**

# **Engagement and Advocacy**

**We develop and maintain collaborative relationships with groups working to address environmental challenges — from policymakers to the stakeholders involved in driving change day-to-day. We believe deeply in our responsibility to use our global platform and influence to collaborate with others in support of addressing the urgent needs of our environment. We recognize that we can't solve complex, global environmental challenges alone. Collaboration with stakeholders is required to help catalyze the broader systems changes needed to limit the impacts of climate change and other environmental challenges.**

Image /page/66/Picture/5 description: {
 "image\_description": "A green circular loop composed of connected green dots, possibly representing connection or a network graph."
}

**Nongovernmental organizations (NGOs)** We interact with NGOs to share resources and gain insights on leading practices related to environmental stewardship.

**Industry associations**

We participate in industry associations to better understand global and regional issues and regulations, and also to align with environmental and climate policy.

**Policymakers**

We engage with public sector leaders to help set environmental policy and craft regulations consistent with our environmental objectives.

**Communities** We work with communities to address the disproportionate impacts of climate change and environmental injustices.

# **Focus areas**

## **Research**

We collaborate with leading institutions to inform research and best practices for environmental initiatives.

## **Partnerships**

We collaborate with global NGOs on strategy and program delivery.

## **Coalitions**

We amplify our positions on environmental topics by sharing them with suppliers and other corporations.

#### **Events & bilateral meetings**

We share our perspective with multi-sectoral leaders through participation in targeted forums and direct outreach.

### **Direct advocacy**

We issue direct comments or letters of support, or join proceedings, on matters where Apple's operational objectives and expertise can help inform environmental policy.

# **Stakeholders 2023 highlights**

**CA SB 253 CA Climate Corporate Data Accountability Act**

As part of our commitment to greenhouse gas emissions disclosures, we endorsed the landmark California Climate Corporate Data Accountability Act (CA SB 253) to improve transparency and drive progress in the fight against climate change.

# **34 countries**

As of 2023, we've funded 33 grants across 34 countries on initiatives supporting community-level environmental efforts.

# **42 businesses**

Since 2021, a total of 42 Black-, Hispanic/Latinx-, and Indigenous-owned businesses have participated in the Impact Accelerator.

# <span id="page-67-0"></span>**Listening to a range of voices**

**We learn from diverse communities that are devoted to environmental stewardship. We approach these conversations to gather learnings and thoughtfully engage with those who bring a range of perspectives and understanding of the issues that matter.** 

Our conversations with stakeholders are fundamental to our environmental efforts. The communities that we engage with help shape how we evaluate global and regional regulations, approaches, and the promise of emerging technologies. As we implement what we've learned, we incorporate feedback on our progress — including aligning with new standards and best practices or exploring the potential impact that cutting-edge research can have on our operations.

We consult with the scientific community to better understand emerging approaches, technologies, and tools that can support our environmental goals. To enhance material recovery for Apple and others, we worked with Carnegie Mellon University researchers to create robotic recycling systems that have advanced product disassembly and material

sorting mechanisms. We also continue our Green Chemistry Advisory Board, an independent group of experts in green chemistry, green engineering, and toxicology who advise on our Smarter Chemistry initiatives, including updates to the RSS.

We draw from cross-sector engagement platforms like the Alliance for Water Stewardship (AWS) to help guide our programs and set standards for environmental efforts. The expertise of AWS defines the world-class water stewardship practices that we've implemented at key Apple and supplier facilities, earning AWS Standard certification.

The business community — including our customers, suppliers, industry partners, and investors — is also a source of valuable collaboration. As co-chair of the United States Information Technology Office (USITO) — a trade association representing the U.S. information and communications technology industry in China — we lead the environmental protection and energy efficiency working groups. In this role, we engage with other companies in China as we work to comply with new environmental regulations and with policymakers on future standards.

Image /page/67/Picture/9 description: {
 "image\_description": "A situation in a factory setting where people are observing a demonstration or process involving machinery and materials, with focus on industrial and environmental considerations."
}

We listen to a diverse set of stakeholders to learn how to improve our approaches to environmental stewardship.

# <span id="page-68-0"></span>**Achieving change together**

**As industry leaders, we have a responsibility to influence change — through advocating for policy and directly engaging with our stakeholders. We participate in collective action as the best means to address urgent environmental issues. Proactively sharing our experiences and contributing to collaborative efforts in our areas of focus and expertise help us better realize environmental goals that we share with our stakeholders.**

## **Supply chain**

Engaging with our suppliers on our climate and environmental goals is critical to achieving impact across our footprint. We establish requirements and methods of communication and data exchange through specific supplier platforms, surveys, and programs. Each program that engages suppliers articulates our expectations and serves as the foundation for our working relationships. Within those programs, we build the networks and systems required to maintain a continued engagement process with our suppliers.

Some of our programs — such as the Supplier Code of Conduct, the Supplier Clean Energy Program, and the Supplier Clean Water Program — are models for how we communicate supplier performance expectations and track progress. Through these programs, we're setting a high standard for factories, helping facilitate efforts to decarbonize operations across our supply chain, driving water reuse across sites, establishing protocols to responsibly use resources in manufacturing operations, and more.

We also encourage our suppliers to participate in market and policy developments that help advance responsible and sustainable supply chains. Additionally, providing resources to our suppliers makes up a critical component of our engagement work. We've offered trainings, workshops, educational materials, webinars, and connections to external funding and support throughout the breadth of our supplier responsibility programs.

To learn more about our work with our suppliers, see our [People and Environment in Our Supply Chain](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [2024 Annual Progress](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report) Report.

## **Industry engagement**

Through partnerships and coalitions, we contribute to various industries by sharing proprietary tools and standards and pursuing policy objectives that drive toward our shared goals. We regularly evaluate our engagement with U.S. federal trade associations. As part of this process, we're assessing relevant trade association positions on climate and identifying specific areas of misalignment with our values and principles on climate change. We then work with our trade associations to identify opportunities to align our positions.

Image /page/68/Picture/11 description: {
 "image\_description": "Two technicians working on a solar panel installation. They are wearing safety gear including helmets and harnesses, and are using tools to perform maintenance on the panels."
}

Technicians from Simmitri perform maintenance on solar panels installed at Bench-Tek Solutions in Santa Clara, California. Both companies are alumni of the Apple Impact Accelerator.

# <span id="page-69-0"></span>**Collaborative impact**

We make public commitments alongside our partners to clarify our support and signal the change we're working to create. We're transparent about the progress we make against these commitments so that we and our partners can be accountable for results. The work we do with others yields tangible outcomes across our environmental goals — and it encourages broader action.

An example of these collaborative efforts is our participation in RE100 — an energy initiative aimed at scaling zero-carbon grids. RE100 unites the world's most influential businesses committed to transitioning their entire electricity use to renewables.

We're also a founding member of the First Movers Coalition (FMC). This global initiative harnesses companies' purchasing power to decarbonize seven hard-to-abate industrial sectors — which currently account for 30 percent of global emissions according to the World Economic Forum (WEF). Through this initiative, we've committed to moving to sustainable aviation fuel for 5 percent of our passenger air travel footprint; to procuring at least

10 percent of annual primary aluminum at or above the FMC's definition of "near-zero emissions primary aluminum"; and to ensuring that at least 50 percent of all aluminum procured annually is sourced from secondary aluminum by 2030. We're also supporting investments in forestry and carbon removal through external initiatives like the Forest Investor Club and our own Restore Fund (see [page](#page-34-0) 35).

Through the Exponential Roadmap Initiative, we're strengthening our work to transitioning our supply chain to 100 percent renewables, on moving towards full circularity by improving materials and low-carbon design, and on transforming our portfolio towards climate solutions.

As part of the Toward Zero Exposure program with the Clean Electronics Production Network (CEPN), we're working to address health and safety challenges in the electronics supply chain with other stakeholders. We made our pledge to shift to 100 percent fiber-based packaging by 2025 with the Ellen MacArthur Foundation. And Lisa Jackson, VP, Environment, Policy, and Social Initiatives, was appointed co-chair of America is All In, a coalition in support of climate action in the U.S.

# **Key partnerships and memberships**

| Stakeholder                                                | Description (Apple engagement)                                                                                                                                                                                                                             |
|------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Advanced Energy United                                     | Business coalition dedicated to getting 100 percent clean energy in the U.S. (Member)                                                                                                                                                                      |
| Aluminum Stewardship Initiative (ASI)                      | Multistakeholder Standards and Certification organization supporting responsible sourcing within<br>the aluminum value chain; recently completed an audit against their Performance Standard of<br>environmental, social, and governance criteria (Member) |
| Asia Clean Energy Coalition (ACEC)                         | Renewable energy buyers, sellers, and financiers dedicated to improving policies for procurement of<br>renewable energy in Asia to rapidly scale up renewable energy projects (Steering group member)                                                      |
| Ceres                                                      | Nonprofit dedicated to taking action to stabilize the climate, protect water and natural resources, and<br>build a just and inclusive economy (Member of the Ceres Company Network)                                                                        |
| ChemFORWARD                                                | Science-based nonprofit working to advance safer chemistry in product design and manufacturing<br>(Co-design partner and chair of Technical Advisory Group)                                                                                                |
| ChemSec Business Group                                     | Multinational company forum supporting leadership in progressive chemical policy advocacy and<br>effective corporate practice of sustainable chemical management (Member)                                                                                  |
| China Association of Circular Economy (CACE)               | Organization operating across industries and regions in China sharing our best practices in their<br>conferences and workshops, and partnering with the organization on advocacy efforts focused on<br>recycling and waste (Senior member)                 |
| Clean Electronics Production Network (CEPN)                | Twenty-member organizations working to improve chemical safety in the electronics supply chain as<br>part of this multistakeholder initiative (Design team member)                                                                                         |
| Clean Energy Buyers Association (CEBA)                     | Community of energy buyers promoting customer-driven clean energy use (Board member, serving<br>on the Transmission Advisory Board and the Federal Working Group)                                                                                          |
| Exponential Roadmap Initiative (ERI)                       | Accredited initiative of the UN Climate Change High-Level Champions' Race to Zero with the purpose<br>to accelerate exponential climate action and solutions through groundbreaking projects, with the<br>mission to halve emissions before 2030 (Member)  |
| Japan Climate Leaders' Partnership (JCLP)                  | Coalition of Japanese companies aligning business objectives with climate goals (Executive member)                                                                                                                                                         |
| MIT Climate & Sustainability Consortium (MCSC)             | Academia and industry collaboration galvanizing the business community to have an impact on<br>broad and intersecting environmental challenges (Industry Advisory Board member)                                                                            |
| Platform for Accelerating the Circular Economy (PACE)      | Public-private collaboration joining global leaders in the transition to a circular economy (Board<br>member)                                                                                                                                              |
| RE100                                                      | Global corporate renewable energy initiative committing to using 100 percent renewable energy<br>(RE100 Advisory Committee member)                                                                                                                         |
| Responsible Business Alliance (RBA)                        | Industry coalition dedicated to responsible business conduct in global supply chains (Full member,<br>serving on the Board of Directors and steering committee of the Responsible Minerals Initiative)                                                     |
| World Business Council for Sustainable Development (WBCSD) | A global community of leading businesses driving systems transformation for a better world in which<br>more than 9 billion people can live well, within planetary boundaries, by mid-century (Member)                                                      |

# <span id="page-70-0"></span>**FEATURE Apple 2030 policy platform**

# **We support climate and environmental policy through our actions and stakeholder engagement.**

In 2023 we publicly supported California's Climate Corporate Data Accountability Act (CA SB 253), which requires large businesses to publicly disclose their greenhouse gas emissions. We also filed comments supporting the U.S. Environmental Protection Agency's proposed rule to reduce emissions from existing and new fossil power plants.

We're a founding member of the Asia Clean Energy Coalition (ACEC) — a new coalition of key stakeholders in the energy transition — advocating for policies that will support more corporate procurement of renewable energy across Asian markets. And we serve as an executive member of the Japan Climate Leaders' Partnership (JCLP). This business coalition has called for an increased focus on the transition to renewable energy in alignment with the Paris Agreement's 1.5° C target, decarbonizing the power sector by 2035 (to align with other G7 nations), setting an aggressive implementation plan for floating offshore wind, and implementing higher carbon pricing.

# **Policy positions**

Our Apple 2030 roadmap is intended to not only address the impacts of our business, but also catalyze ambitious environmental leadership globally. Strong, worldwide government actions are essential to enable the systemic policy changes the world needs. We're guided by the following principles:

#### **Climate and energy**

- Encourage policymakers and businesses to set science-based targets to reduce emissions in line with the Paris Agreement and limit warming to 1.5°C. This should include interim and long-term targets and accountability mechanisms across national and sectoral decarbonization efforts.
- Enable rapid decarbonization through governmentled policies, including comprehensive carbon pricing and emissions mitigation programs.
- Encourage the transition to renewable electricity globally, including tripling global renewables capacity to 11,000 gigawatts by 2030, and transitioning away from electricity sources emitting more pollution, like fossil fuels (including fossil fuels with carbon capture).
- Remove barriers to renewable energy development, and increase investment in highcapacity transmission, energy storage, and load shaping technologies.
- Ensure that energy consumers can access costcompetitive renewable energy purchase options.

- Consider the life cycle emissions of energy resources and mitigation technologies, and set high-integrity mitigation standards accordingly.
- Encourage research into and incentives for pre-commercial technologies, particularly in hard-to-decarbonize sectors.
- Support policies accelerating the decarbonization of the transportation sector, including the development and adoption of non-fossil, low-carbon, and zero-carbon alternatives for aviation, ground transport, and maritime shipping.
- Encourage policies promoting the adoption of scalable technological solutions within hard-to-abate sectors.
- Encourage rules for high-integrity corporate measurement and disclosure of emissions along the entire value chain, using globally recognized standards and harmonized approaches.
- Support carbon removal credit schemes that set strict environmental, social, and governance standards, and that support scalable, durable natural carbon removal solutions that benefit local communities.
- Support strong national and international policies that support the scale up of carbon removal, including the role that corporate investment in carbon projects play in supporting national carbon targets.

• Encourage policy makers, peers, and partners to center equity and justice in climate solutions in the development of the new green economy, so that communities most impacted by climate change benefit from the economic opportunities in climate solutions.

### **Circular economy**

- Drive policies that include circularity as part of the solution, where feasible, to responsibly meet the growing demand for critical materials used in electronics of all kinds.
- Further improve labor, human rights, and environmental standards throughout recycled and primary materials supply chains.
- Promote policies that maximize product longevity and minimize environmental impact by balancing design for reliability and ease of repair, while ensuring user privacy and device security are protected.
- Support globally-aligned, evidence-based and product-specific eco-design standards.
- Develop collection programs that engage customers, protect environmental and human health, and capture high volumes of electronics for reuse, repair, refurbishment, and recycling.

- Promote consistent waste regulations, that are harmonized across geographies, to enable efficient, commercially viable movement of materials for recovery and recycling. This includes support for U.S. ratification of the Basel Convention.
- Encourage recycled content use through the development of high-quality secondary material supply, by incentives for the development and expansion of recycling infrastructure.
- Support the development of advanced electronics recycling facilities that can recover more types of resources at higher qualities, including materials that are difficult to recover or of lower value.

#### **KEY MILESTONES**

## **Apple's climate policy advocacy**

- **2015 (U.S.):** Apple joined the White House's American Business Act on Climate Pledge
- **2016 (U.S.):** Apple joined Google, Microsoft, and Amazon to sign an amicus brief in support of the U.S. EPA's Clean Power Plan (CPP).
- **2016 (World):** Apple addressed 700 senior government, business, and community leaders at the seventh Clean Energy Ministerial (CEM), where we called for governments to put a price on carbon across the world to address climate change.
- **2017 (U.S.):** Apple urged the White House to remain in the Paris Agreement and take meaningful action on climate change.
- **2017 (China):** Apple hosted a roundtable with the Green Electricity Consumption Cooperative Organization (GECCO).
- **2017 (Vietnam):** Apple joined other companies urging the government of Vietnam to make regulatory changes allowing businesses to procure renewable energy through direct power purchase agreements.
- **2018 (U.S.):** Apple filed comments to the Federal Energy Regulatory Commission (FERC) urging it not to finalize a rule that would subsidize fossil fuels, which would limit the ability of renewables to compete in the electricity market. FERC chose not to finalize that rule.

- **2019 (World):** Apple participated in the UN Environment Assembly (UNEA) and conducted bilateral discussions with a number of countries to advocate for policies that enable a circular economy and bold action on climate.
- **2019 (Vietnam):** Apple urged the government to reform the electricity market, allowing businesses to purchase power directly from renewable power plants.
- **2018 (Japan):** Apple was among the first multinational companies to join the Japan Climate Leaders' Partnership (JCLP)
- **2018 (South Korea):** Apple met with government officials in Korea to discuss the need for increased renewable generation and retail choice, whereby consumers can select their power source.
- **2018 (China):** Apple submitted formal comments to China's National Development and Reform Commission (NRDC) about the implications of draft policy on corporate clean energy procurement.
- **2018 (U.S.):** Apple filed comments to the U.S. EPA urging it not to repeal the CPP because of its importance in reducing emissions.
- **2018 (Japan):** Apple filed comments with the Japanese government calling for the development of a robust and verifiable renewable energy trading system.

- **2020 (EU):** Apple called on European leaders to increase their climate ambition to achieve targets of at least 55 percent greenhouse gas emissions reductions by 2030 and carbon neutrality by 2050. The EU adopted these targets.
- **2021 (U.S.):** Apple was one of the first large, public U.S. companies to call on the U.S. Securities and Exchange Commission to require disclosures of global greenhouse gases across all emissions scopes.
- **2021 (Vietnam):** Apple and other companies vocalized support to the government of Vietnam for an ambitious Power Development Plan (PDP) prioritizing clean energy.
- **2021 (U.S.):** Apple was the first company to voice support for enacting the Clean Energy Standard (CES), which would decarbonize the power grid by 2035.
- **2022 (South Korea):** Apple called for Korea's 2030 energy plan to set a higher target for renewable energy, to establish a more fair competitive market for renewables, and to improve transparency for renewable energy solutions.
- **2022 (Japan):** Apple joined a letter calling for a level of carbon pricing that provides an incentive for emissions reduction.

- **2023 (Global):** Apple joined the global 3xRenewables campaign calling for a tripling of global renewable energy capacity by 2030.
- **2023 (U.S.):** Apple submitted comments to support the EPA's proposed rule to regulate greenhouse gas emissions from existing coal power plants and new and existing natural gas plants.
- **2023 (U.S.):** Apple supported California's Climate Corporate Data Accountability Act (SB 253), writing a letter affirming the policy in the final stages of negotiations.
- **2022 (U.S.):** Apple, along with Meta and Google, advocated for greatly expanded renewable generation to achieve a 70 percent emissions reduction in North Carolina by intervening in the state's Carbon Plan proceeding.
- **2022 (U.S.):** Apple led an amicus brief supporting the U.S. EPA's authority to regulate greenhouse gases from power plants.
- **2022 (U.S.):** Apple filed comments to encourage more rapid integration of renewable energy to the transmission grid, a key bottleneck to renewable energy deployment.

- **2023 (Asia):** Apple, through engagement in the ACEC, CEDI, RE100, and other initiatives, supported the creation or improvement of cost-effective renewable energy procurement mechanisms across several countries, including Korea and Vietnam.
- **2023 (Japan):** Apple, as part of JCLP, supported policy statements calling for power sector decarbonization by 2035 to align with other G7 nations, rapidly expanding renewables, setting an aggressive implementation plan for floating offshore wind, diminishing reliance on fossil fuels, and implementing higher carbon pricing. Apple also collaborated with other renewable energy users and called for enhancing the Non-Fossil Certificate (NFC) scheme to enable transparency in tracking.

**Policymakers need to set strong science-based targets to reduce emissions in line with the Paris Agreement and limit warming to 1.5° C.**

**VIEW**

# <span id="page-72-0"></span>**Supporting communities worldwide**

**Through our engagement efforts, we work directly with groups and individuals who are addressing environmental injustice in their communities. We evaluate each opportunity based on the potential to scale a proven environmental approach, test or pilot an innovation, or take steps to improve equity in communities that are disproportionately impacted by climate change and environmental dangers. When we partner with another organization, our success hinges on close collaboration while focusing on our mutual objectives.**

Our work combines collaboration and philanthropic contributions, which we determine based on each organization's focus and their potential to effect change. And we recognize the importance of community-driven leadership and thus work closely with leadership teams.

In 2023, we supported community-focused environmental partnership around the world, including the following organizations:

- **Acumen:** Launching the Energy for Livelihoods Accelerator, delivered by Acumen Academy, that supported 15 early-stage companies in India committed to improving the livelihoods of smallholder farmers and micro-entrepreneurs. The aim was to help build an ecosystem of clean energy enterprises serving the needs of low-income communities.
- **Beyond Benign:** Continuing our partnership to bring green chemistry and sustainable science programming to Minority-Serving Institutions across the country and to expand the talent pool of Black, Hispanic/Latinx, and Indigenous scientists trained in sustainability for global high-value companies.

- **Safer Chemistry Impact Fund:** Collaborating to design science-based, data-driven solutions that will systematically eliminate hazardous chemicals and replace them with verified safer alternatives across sectors to improve human and environmental impacts in support of corporate ESG, national and international development goals.
- **Conservation International:** Conservation International: Supporting leadership in Afrodescendant communities in Latin America with economic opportunities that deliver outcomes for addressing the climate and biodiversity crises.
- **Gravity Water:** Converting rain into safe water for schools which benefits 42,000+ community members, conserves 8M+ gallons of groundwater yearly and enhances climate resilience.
- **Society of Entrepreneurs and Ecology Foundation:** Supporting the development of a certified methodology for the first blue carbon project under the resumed CCER market.
- **World Wildlife Fund:** Partnering on the Nature-Based Solutions Origination Platform (NbS-OP) — a new model of scaling up, aligning, and mobilizing public and private investments for high-quality nature-based solutions under an integrated landscape approach.

Image /page/72/Picture/13 description: {
 "image\_description": "An individual is working in a laboratory handling a beaker of dark liquid with a dropper, showcasing a scene of scientific experimentation or chemistry research. The background includes other individuals, laboratory equipment, and a clear sense of focus on educational or scientific activities."
}

We support community organizations focused on addressing environmental justice challenges and smarter chemistry, such as Beyond Benign. Photo credit: Beyond Benign, Inc.

Image /page/73/Picture/1 description: {
 "image\_description": "A person sitting outdoors with gardening supplies and planting seedlings in soil, wearing gloves and a shirt that supports volunteering programs. A text overlay mentions support for organizations addressing environmental issues and helping underserved communities."
}

# **Environment and communities**

We know that underresourced communities bear the disproportionate impacts of environmental challenges, so we support organizations by providing grants that focus on environmental issues. Our grants have helped these organizations reduce pollution, improve health, and increase climate resilience in underserved and low-income communities around the world. And we work with these groups to address the global effects of climate change and environmental hazards that traditionally impact overburdened communities.

We've expanded our Strengthen Local Communities (SLC) grant program, which provides funding to local organizations in regions that are under-resourced in communities worldwide.

In 2023, we provided grants to organizations around the world engaged in a range of environmental work, including:

**• Environmental Youth Alliance (EYA):** Offering land-based education and employment training programs for underrepresented youth that center on native plant horticulture, ecological restoration, land stewardship, and community leadership while working to help build a more inclusive environmental movement.

- **• Institute for Socio-Ecological Research (ISER Caribe):** Supporting the Puerto Rico–based Climate Justice Hub, which integrates environmental justice, climate change, and sustainability and resilience while engaging and connecting with various communities and spaces across the Caribbean.
- **• Justice Outside:** Providing support for the Network for Network Leaders Program that impacts the outdoors, environmental education, and environmental justice while working toward a more equitable, just, and influential network model that centers the experiences and knowledge of Black people, Indigenous people, and other people of color.

- **• Karrkad Kanjdji Trust Public Fund:** Supporting Traditional Owners of Warddeken and Djelk Indigenous Protected Areas in Australia through their Indigenous Women Rangers program while funding incremental conservation activities.
- **• Lewa:** Integrating sustainable water management, climate-smart agriculture, clean energy, and knowledge sharing to achieve vital conservation outcomes for community members, small-scale farmers and students in Northern Kenya.
- **• Little Village Environmental Justice Organization (LVEJO):** Delivering environmental justice to BIPOC who are most impacted by industrialization and climate change by building a sustainable resilient community through the healthy development of youth and families, economic justice, participatory democracy and self-determination.
- **• Taproot Earth:** Supporting efforts to build power and cultivate solutions among frontline communities by advancing climate justice and democracy to build a world where we can all live, rest, and thrive.

Image /page/73/Picture/13 description: {
 "image\_description": "The image contains text '2024 Environmental Progress Report 74' displaying a title and page number."
}

We support organizations like City Blossoms, which addresses environmental issues in underserved communities and helps children and youth build lifelong connections to the natural world. Photo credit: Rafael Woldeab, City Blossoms

# <span id="page-74-0"></span>**FEATURE Continuing our commitment to equity with the Impact Accelerator**

**Through the Impact Accelerator, we provide access to opportunities for communities of color as we continue our strategic work and investments in environmental sectors — such as renewable energy, carbon removal, recycling innovation, and smarter chemistry.**

Part of our Racial Equity and Justice Initiative (REJI), the Apple Impact Accelerator program boosts the progress of participating Black-, Hispanic/Latinx-, and Indigenous-owned businesses that share our commitment to the environment. Offering customized training and access to Apple experts, the Impact Accelerator supports businesses that have the potential to drive innovation and positive outcomes in our supply chain — so that together, we can work to support communities disproportionately impacted by environmental issues.

The program supports companies as they better position themselves for growth, improve their abilities to engage larger contracts, and expand their customer base — while supporting their commitment to the environment. The program has also connected like-minded business leaders to create new opportunities for innovation and to realize our shared goals.

The Apple Impact Accelerator program includes:

- Targeted training on topics including supply chain management, supplier diversity, and financial and legal subjects.
- Customized skills development opportunities, including communications coaching, for executives and their teams to provide the knowledge and tools that organizations need to succeed as Apple suppliers.
- Access to company-wide mentors and subject matter experts across the business to help companies align their business priorities with Apple's environmental goals.
- Opportunity for participants to pitch their services and solutions to decision-makers and business leaders within Apple.

- Post-program support including access to Apple experts and networking events — through Apple's Supplier Success community, fostering connections made during the program and forging new connections across all its generations.
- Opportunity to attend a leading university's business executive leadership program focused on supply chain and growth.

In 2023, our third cohort of the Impact Accelerator included 12 businesses at the leading edge of environmental services and solutions. Each company selected was at least 51 percent owned, operated, and controlled by a Black, Hispanic/Latinx, or Indigenous individual and aligned closely with our environmental strategy, including our commitment to reach carbon neutrality by 2030.

Image /page/74/Picture/14 description: {
 "image\_description": "An individual is working on an electronic component at a workstation, surrounded by other equipment and parts in a technical environment."
}

The Impact Accelerator's goal is to ensure that our work to protect the environment also helps advance equity and expand access to opportunity for communities of color.

**Data**

<span id="page-75-0"></span>[Greenhouse gas emissions](#page-76-0) [High quality carbon credits](#page-77-0) [Carbon footprint by product](#page-78-0) [Energy](#page-80-0) [Resources](#page-81-0) [Normalizing factors](#page-82-0)

Image /page/75/Picture/2 description: {
 "image\_description": "A close-up of a smartwatch displaying various data, including time, compass direction, and activity metrics."
}

# <span id="page-76-0"></span>**Data**

# **Greenhouse gas emissions**

We account for our carbon footprint by following internationally recognized standards, like the World Resources Institute (WRI) Greenhouse Gas (GHG) Protocol and ISO 14040/14044.1 Improving the accuracy of our carbon footprint is an ongoing process — as we learn more, we refine our carbon models and adjust our climate roadmap. We also regularly revisit the boundary of our carbon footprint as our data sources improve and our business evolves.

|                      |                                                                          | Fiscal year |            |            |            |            |  |
|----------------------|--------------------------------------------------------------------------|-------------|------------|------------|------------|------------|--|
|                      |                                                                          | 2023        | 2022       | 2021       | 2020       | 2019       |  |
| Corporate emissions  | Gross emissions                                                          | 324,100     | 324,000    | 166,380    | 334,430    | 573,730    |  |
| (metric tons CO2e)2  | Scope 1                                                                  | 55,200      | 55,200     | 55,200     | 47,430     | 52,730     |  |
|                      | Natural gas, diesel, propane                                             | 35,300      | 39,700     | 40,070     | 39,340     | 40,910     |  |
|                      | Fleet vehicles                                                           | 17,000      | 12,600     | 12,090     | 4,270      | 6,950      |  |
|                      | Other emissions3                                                         | 2,900       | 2,900      | 3,040      | 3,830      | 4,870      |  |
|                      | Scope 2 (market-based)4                                                  | 3,400       | 3,000      | 2,780      | 0          | 0          |  |
|                      | Electricity                                                              | 0           | 0          | 0          | 0          | 0          |  |
|                      | Steam, heating, and cooling5                                             | 3,400       | 3,000      | 2,780      | 0          | 0          |  |
|                      | Scope 3                                                                  | 412,800     | 265,800    | 108,400    | 287,000    | 521,000    |  |
|                      | Business travel                                                          | 225,700     | 113,500    | 22,850     | 153,000    | 326,000    |  |
|                      | Employee commute6                                                        | 164,100     | 134,200    | 85,570     | 134,000    | 195,000    |  |
|                      | Upstream impacts (scope 1)                                               | 18,300      | 10,600     | 0          | 0          | 0          |  |
|                      | Work from home (market-based)                                            | 4,700       | 7,500      | 0          | 0          | 0          |  |
|                      | Transmission and distribution loss (market-based)                        | N/A         | N/A        | N/A        | N/A        | N/A        |  |
|                      | Third-party cloud (market-based)                                         | 0           | 0          | 0          | 0          | 0          |  |
|                      | Carbon removals                                                          |             |            |            |            |            |  |
|                      | Corporate carbon offsets7                                                | -471,400    | -324,1008  | -167,0009  | -70,00010  | 0          |  |
| Product life         | Gross emissions (Scope 3)                                                | 15,570,000  | 20,280,000 | 23,020,000 | 22,260,000 | 24,460,000 |  |
| cycle emissions      | Manufacturing (purchased goods and services)                             | 9,400,000   | 13,400,000 | 16,200,000 | 16,100,000 | 18,900,000 |  |
| (metric tons CO2e)11 | Product transportation (upstream and downstream) 1,500,000               |             | 1,900,000  | 1,750,000  | 1,800,000  | 1,400,000  |  |
|                      | Product use (use of sold products)                                       | 4,600,000   | 4,900,000  | 4,990,000  | 4,300,000  | 4,100,000  |  |
|                      | End-of-life processing                                                   | 70,000      | 80,000     | 80,000     | 60,000     | 60,000     |  |
|                      | Carbon removals                                                          |             |            |            |            |            |  |
|                      | Product carbon offsets                                                   | -13,500     | 0          | -500,00012 | 0          | 0          |  |
|                      | Total gross scope 3 emissions (corporate and product) (metric tons CO2e) | 15,980,000  | 20,545,800 | 23,128,400 | 22,550,000 | 24,980,000 |  |
|                      | Total gross carbon footprint (without offsets) (metric tons CO2e)13      | 16,100,000  | 20,600,000 | 23,200,000 | 22,600,000 | 25,100,000 |  |
|                      | Total net carbon footprint (after applying offsets) (metric tons CO2e)12 | 15,600,000  | 20,300,000 | 22,530,000 | 22,530,000 | 25,100,000 |  |

Notes:

- For data on years prior to 2019, please reference past [Environmental Progress](www.apple.com/environment) Reports.
- Totals might not add up due to rounding.

1 Apple's carbon footprint boundary is aligned with the Greenhouse Gas (GHG) Protocol framework and includes emissions that are material and relevant to Apple, where data is available. Apple's carbon footprint includes direct scope 1 emissions; indirect scope 2 emissions from purchased electricity, steam, heating, and cooling; and indirect scope 3 emissions from purchased goods and services, transportation and distribution, business travel, employee commute, product use, and end of life.

- 2 Apple is carbon neutral for corporate emissions as of April 2020. Beginning in fiscal year 2022, we've expanded our footprint boundary to include scope 3 emissions associated with work from home, third-party cloud services, electricity transmission and distribution losses, and upstream impacts from scope 1 fuels.
- 3 Emissions from R&D processes and refrigerant leaks.
- 4 We estimate the life cycle emissions associated with our use of renewable electricity for our corporate facilities to be about 70,000 metric tons CO2e. We do not currently account for these emissions in our carbon footprint, due to the poor quality of this data.
- 5 Beginning in fiscal year 2021, we're accounting for scope 2 emissions from the purchase of district heating, chilled water, and steam.
- 6 Beginning in fiscal year 2020, we updated our methodology for calculating emissions from employee commute to reflect employees working from home during COVID-19.
- 7 For a detailed breakdown of carbon offset purchases applied to our corporate footprint, see the carbon offsets table on the following page.

- 8 We retired 324,100 metric tons of carbon credits from the [Alto Mayo project](http://registry.verra.org/app/projectDetail/VCS/944) in Peru and [Chyulu Hills project](https://registry.verra.org/app/projectDetail/VCS/1408) in Kenya to maintain carbon neutrality for our corporate emissions in fiscal year 2022. This project is certified to the VCS and CCB standards.
- 9 We retired 167,000 metric tons of carbon credits from the [Chyulu Hills project](https://registry.verra.org/app/projectDetail/VCS/1408) in Kenya to maintain carbon neutrality for our corporate emissions in fiscal year 2021. This project is certified to the VCS and CCB standards.
- 10 We retired 70,000 metrics tons of carbon credits — 53,000 from the [Chyulu Hills project](https://registry.verra.org/app/projectDetail/VCS/1408) in Kenya and 17,000 from the [Cispatá Mangrove project](https://registry.verra.org/app/projectDetail/VCS/2290)  in [Colombia.](https://registry.verra.org/app/projectDetail/VCS/2290)
- 11 Because we're committed to accuracy and transparency, we regularly refine our product life cycle assessment model and sources of data. For example, last year we obtained more granular data summarizing in which countries our products are sold and used, resulting in more granularity possible for grid emission factors used in the carbon footprint of the product use phase. The net result was an increase in our fiscal year 2021 carbon footprint. When using the same level of data granularity and model as fiscal year 2021, our product use greenhouse gas emissions in fiscal year 2021 would have been about 2.5 percent lower.
- 12 For fiscal year 2021, we retired credits from the [Chyulu Hills project](https://registry.verra.org/app/projectDetail/VCS/1408) in Kenya and purchased carbon credits from two additional projects to offset a total of 500,000 metric tons of direct emissions across our value chain. The [first project,](https://registry.verra.org/app/projectDetail/VCS/1622) a REDD+ coastal conservation project in Guatemala, protects and conserves forests from deforestation and degradation. The [second project](https://registry.verra.org/app/projectDetail/VCS/2070) aims to establish forests on about 46,000 hectares of barren land that isn't otherwise in use across seven counties in the Guizhou province of China. Both projects are certified to the same high standards that we require for projects in the Restore Fund, including VCS and CCB standards.
- 13 Due to rounding, our gross and net carbon footprints do not always equal the sum of the subtotals disclosed above.

# <span id="page-77-0"></span>**Data High quality carbon credits**

We retired the following high-quality carbon credits toward our corporate emissions footprint for 2023.

| Project name | Project description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Vintage              | Volume retired<br>(metric tons CO2e) | Registry link                                         |
|--------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------|--------------------------------------|-------------------------------------------------------|
| Chyulu Hills | The Chyulu Hills REDD+ Project (CHRP) is a multi-partner initiative designed to promote climate change mitigation and<br>adaptation, restore biodiversity, and create alternative livelihoods under the UN scheme of Reducing Emissions from<br>Deforestation and forest Degradation (REDD+). It's located in the Tsavo-Amboseli ecosystem in southeastern Kenya and<br>stretches over an area of over 410,000 hectares. Its main geographic feature is the volcanic Chyulu Hills mountain range, from<br>which the project derives its name. This project presents a broad ecosystem approach, including REDD+, to provide long-term<br>sustainable financing and management to maintain the ecological integrity of an iconic African landscape. The project will<br>help protect a very high-value wildlife and biodiversity area while supporting the development needs of Indigenous and other<br>local communities. | 2018                 | 230,000                              | registry.verra.org/app/projectDetail/VCS/1408         |
| Guinan       | The Guinan Afforestation Project is located in the Guizhou Province of China and contributes to carbon removal and local<br>sustainable development by planting trees on the barren lands. The project is planting across 46,000 ha on barren hills and<br>degraded lands. The project activity aims to enhance biodiversity conservation by increasing the connectivity of forests,<br>improve soil and water conservation, and generate income and job opportunities for local communities.                                                                                                                                                                                                                                                                                                                                                                                                                             | 2019, 2020, and 2021 | 255,000                              | https://registry.verra.org/app/projectDetail/VCS/2070 |

# <span id="page-78-0"></span>**Data Carbon footprint by product**

The following tables list the carbon footprints (in kilograms) of Apple products sold as of March 9, 2024, along with select configurations.1

|                            |         | Storage configurations |       |       |       |     |
|----------------------------|---------|------------------------|-------|-------|-------|-----|
| iPhone                     | Unit    | 64GB                   | 128GB | 256GB | 512GB | 1TB |
| iPhone 15                  | kg CO2e | –                      | 56    | 61    | 74    | –   |
| iPhone 15 Plus             | kg CO2e | –                      | 61    | 66    | 79    | –   |
| iPhone 15 Pro              | kg CO2e | –                      | 66    | 71    | 83    | 107 |
| iPhone 15 Pro Max          | kg CO2e | –                      | –     | 75    | 87    | 110 |
| iPhone 14                  | kg CO2e | –                      | 61    | 67    | 83    | –   |
| iPhone 14 Plus             | kg CO2e | –                      | 68    | 75    | 91    | –   |
| iPhone 13                  | kg CO2e | –                      | 64    | 71    | 83    | –   |
| iPhone SE (3rd generation) | kg CO2e | 46                     | 50    | 58    | –     | –   |

|                                                      |         | Storage configurations |       |       |       |     |      |  |
|------------------------------------------------------|---------|------------------------|-------|-------|-------|-----|------|--|
| iPad                                                 | Unit    | 64GB                   | 128GB | 256GB | 512GB | 1TB | 2 TB |  |
| iPad Pro 12.9-inch (6th generation) Wi-Fi + Cellular | kg CO2e | –                      | 135   | 142   | 156   | 183 | 284  |  |
| iPad Pro 11-inch (4th generation) Wi-Fi + Cellular   | kg CO2e | –                      | 100   | 107   | 121   | 148 | 249  |  |
| iPad Air (5th generation) Wi-Fi + Cellular           | kg CO2e | 80                     | 84    | 92    | –     | –   | –    |  |
| iPad (10th generation) Wi-Fi + Cellular              | kg CO2e | 72                     | 82    | –     | –     | –   | –    |  |
| iPad (9th generation) Wi-Fi + Cellular               | kg CO2e | 75                     | –     | 84    | –     | –   | –    |  |
| iPad mini (6th generation) Wi-Fi + Cellular          | kg CO2e | 68                     | 71    | 77    | 90    | –   | –    |  |

|                      |         | Select product configurations    |                                         |                                   |                                  |
|----------------------|---------|----------------------------------|-----------------------------------------|-----------------------------------|----------------------------------|
| Apple Watch2         | Unit    | Aluminum case with<br>Sport Loop | Stainless steel case<br>with Sport Loop | Titanium case with<br>Alpine Loop | Titanium case with<br>Trail Loop |
| Apple Watch Ultra 2  | kg CO2e | –                                | –                                       | 12                                | 11                               |
| Apple Watch Series 9 | kg CO2e | 8                                | 29                                      | –                                 | –                                |
| Apple Watch SE       | kg CO2e | 7                                | –                                       | –                                 | –                                |

## 2024 Environmental Progress Report

79

Note: Dashes indicate that the configuration does not exist.

- 1 Product carbon footprint data for Apple products are published in our [Product](http://apple.com/environment/#reports-product)  [Environmental Reports](http://apple.com/environment/#reports-product) and are accurate as of product launch. In instances where carbon models were developed prior to product launch, we use preproduction units.
- 2 Greenhouse gas emissions prior to applied high quality carbon credits are represented for all Apple Watch models with the exception of stainless steel Apple Watch Series 9 paired with sport loop.

| Laptops                                       | Unit    | 256GB | 512GB | 1TB |
|-----------------------------------------------|---------|-------|-------|-----|
| 16-inch MacBook Pro (2023), Apple M3 Pro chip | kg CO2e | –     | 290   | –   |
| 16-inch MacBook Pro (2023), Apple M3 Max chip | kg CO2e | –     | –     | 348 |
| 15-inch MacBook Air (2024), Apple M3 chip     | kg CO2e | 158   | 167   | –   |
| 14-inch MacBook Pro (2023), Apple M3 chip     | kg CO2e | –     | 202   | –   |
| 14-inch MacBook Pro (2023), Apple M3 Pro chip | kg CO2e | –     | 235   | –   |
| 14-inch MacBook Pro (2023), Apple M3 Max chip | kg CO2e | –     | –     | 296 |
| 13-inch MacBook Air (2022), Apple M2 chip     | kg CO2e | 147   | 171   | –   |
| 13-inch MacBook Air (2024), Apple M3 chip     | kg CO2e | 135   | 144   | –   |

| Category         | Product                        | Unit    | Value |
|------------------|--------------------------------|---------|-------|
| Displays         | Studio Display (2022)          | kg CO2e | 544   |
|                  | Pro Display XDR with Pro Stand | kg CO2e | 974   |
| HomePod          | HomePod (2nd generation)       | kg CO2e | 92    |
|                  | HomePod mini                   | kg CO2e | 42    |
| Apple Vision Pro | Apple Vision Pro               | kg CO2e | 335   |

| Desktops                           | Unit    | 256GB | 512GB | 1TB   | 4TB |
|------------------------------------|---------|-------|-------|-------|-----|
| iMac, Two ports                    | kg CO₂e | 359   | –     | –     | –   |
| iMac, Four ports                   | kg CO₂e | –     | 389   | –     | –   |
| Mac mini (2023), Apple M2 Pro chip | kg CO₂e | –     | 150   | –     | –   |
| Mac mini (2023), Apple M2 chip     | kg CO₂e | 112   | 126   | –     | –   |
| Mac Studio (2023), Apple M2 Max    | kg CO₂e | –     | 290   | –     | –   |
| Mac Studio (2023), Apple M2 Ultra  | kg CO₂e | –     | –     | 346   | –   |
| Mac Pro (2023)                     | kg CO₂e | –     | –     | 1,572 | –   |

| Apple TV                      | Unit    | Storage configurations | 64GB | 128GB |
|-------------------------------|---------|------------------------|------|-------|
| Apple TV 4K, Wi-Fi            | kg CO2e | 43                     | –    |       |
| Apple TV 4K, Wi-Fi + Ethernet | kg CO2e | –                      | 46   |       |

# <span id="page-80-0"></span>**Data**

# **Energy**

|                                |                                              |                          | Fiscal year   |               |               |            |           |
|--------------------------------|----------------------------------------------|--------------------------|---------------|---------------|---------------|------------|-----------|
|                                |                                              | Unit                     | 2023          | 2022          | 2021          | 2020       | 2019      |
| Corporate facilities<br>energy | Electricity                                  |                          |               |               |               |            |           |
|                                | Total                                        | MWh                      | 3,487,000     | 3,199,000     | 2,854,000     | 2,580,000  | 2,427,000 |
|                                | U.S.                                         | MWh                      | 2,830,000     | 2,614,000     | 2,377,000     | 2,192,000  | 2,075,000 |
|                                | International                                | MWh                      | 657,000       | 585,000       | 477,000       | 389,000    | 351,000   |
|                                | Fuel                                         |                          |               |               |               |            |           |
|                                | Total                                        | MWh                      | 662,950       | 334,250       | 467,280       | 439,170    | 462,680   |
|                                | Natural gas                                  | MWh                      | 312,490       | 188,630       | 203,010       | 202,360    | 202,340   |
|                                | Biogas                                       | MWh                      | 218,780       | 76,280        | 208,620       | 210,820    | 217,140   |
|                                | Propane liquid                               | MWh                      | 1,030         | 1,830         | 40            | 140        | 280       |
|                                | Gasoline                                     | MWh                      | 50,760        | 38,790        | 34,880        | 14,910     | 23,950    |
|                                | Diesel (other)                               | MWh                      | 57,030        | 15,610        | 9,780         | 9,610      | 16,450    |
|                                | Diesel (mobile combustion)                   | MWh                      | 22,860        | 13,120        | 10,950        | 1,330      | 2,520     |
|                                | Other                                        |                          |               |               |               |            |           |
|                                | Steam, heating, and cooling<br>1             | MWh                      | 45,370        | 19,800        | 22,480        | 0          | 0         |
| Energy efficiency              | Corporate facilities<br>2                    |                          |               |               |               |            |           |
|                                | Electricity savings                          | MWh/year                 | 298,500       | 290,220       | 223,940       | 215,260    | 118,830   |
|                                | Fuel savings                                 | MMBtu/year               | 126,540       | 116,190       | 110,330       | 136,820    | 162,280   |
|                                | 3<br>Supplier facilities                     |                          |               |               |               |            |           |
|                                | Electricity savings                          | MWh/year                 | 2,040,000,000 | 1,620,425,230 | 1,418,825,350 | 1,101,440  | 943,890   |
|                                | Fuel savings                                 | MMBtu/year               | 2,281,060     | 2,038,930     | 1,047,440     | 752,680    | 25,120    |
| Renewable electricity          | Corporate facilities                         |                          |               |               |               |            |           |
|                                | Renewable electricity used                   | MWh                      | 3,489,000     | 3,199,000     | 2,854,000     | 2,580,000  | 2,430,000 |
|                                | Renewable electricity percentage<br>4        | % of total energy        | 100           | 100           | 100           | 100        | 100       |
|                                | Scope 2 emissions avoided                    | metric tons CO<br>e<br>2 | 1,144,000     | 1,201,000     | 1,063,720     | 948,000    | 899,000   |
|                                | 5<br>Supply chain                            |                          |               |               |               |            |           |
|                                | Renewable electricity capacity (operational) | GW                       | 16.5          | 13.7          | 10.3          | 4.5        | 2.7       |
|                                | Renewable electricity capacity (committed)   | GW                       | 21.0          | 20.0          | 15.9          | 7.9        | 5.1       |
|                                | Renewable electricity used                   | MWh                      | 25,500,000    | 23,700,000    | 18,100,000    | 11,400,000 | 5,700,000 |

- 1 Beginning in fiscal year 2021, we're accounting for the purchase of district heating, chilled water, and steam.
- 2 Because energy efficiency measures have lasting benefits, energy efficiency savings are calculated cumulatively since 2012. All efficiency measures are retired based on their effective useful lifetime as documented by the California Energy Commission. In 2023, we accounted for our expired corporate energy efficiency savings and reflected these changes for fiscal years 2019 through 2023. Due to the COVID-19 pandemic, corporate facilities' energy use declined temporarily as we adjusted lighting and climate controls due to shutdowns and reduced occupancy. These savings are not included in the total savings from our energy efficiency program initiatives. We also recognize that energy use at our employees' homes likely increased during this period. We have not accounted for this energy use because we anticipated this impact is small relative to our overall energy use and we're still evolving our methodology.
- 3 Energy savings from supplier energy efficiency improvements are reported as annualized numbers. Beginning in 2020, supplier energy savings are calculated based on the fiscal year instead of on a calendar-year basis.
- 4 Beginning January 1, 2018, 100 percent of the electricity we use to power our global facilities is sourced from renewable energy.
- 5 Supply chain renewable electricity capacity (operational) and renewable electricity use for fiscal year 2021 do not include REC purchases Apple made, equivalent to 0.3 GW and 500,000 MWh, respectively, to address a small increase to its carbon footprint.

# <span id="page-81-0"></span>**Data Resources**

|                   |                                       |                 | Fiscal year |            |            |            |            |
|-------------------|---------------------------------------|-----------------|-------------|------------|------------|------------|------------|
|                   |                                       | Unit            | 2023        | 2022       | 2021       | 2020       | 2019       |
| Water             | Corporate facilities                  |                 |             |            |            |            |            |
|                   | Total                                 | million gallons | 1,610       | 1,527      | 1,407      | 1,287      | 1,291      |
|                   | Freshwater<br>1                       | million gallons | 1,411       | 1,380      | 1,259      | 1,168      | 1,178      |
|                   | Recycled water<br>2                   | million gallons | 151         | 142        | 141        | 113        | 106        |
|                   | Other alternative sources<br>3        | million gallons | 48          | 5          | 7          | 5          | 7          |
|                   | Supply chain                          |                 |             |            |            |            |            |
|                   | Freshwater saved                      | million gallons | 12,700      | 13,000     | 12,300     | 10,800     | 9,300      |
| Waste             | Corporate facilities                  |                 |             |            |            |            |            |
|                   | Landfill diversion rate               | %               | 74          | 71         | 68         | 70         | 66         |
|                   | Landfilled (municipal solid waste)    | pounds          | 38,343,490  | 33,260,990 | 33,202,200 | 25,826,550 | 38,317,120 |
|                   | Recycled                              | pounds          | 81,781,660  | 78,618,250 | 73,489,220 | 63,812,300 | 72,338,130 |
|                   | Composted                             | pounds          | 14,803,510  | 8,726,170  | 4,844,960  | 6,302,410  | 10,882,120 |
|                   | Hazardous waste                       | pounds          | 7,321,130   | 2,780,610  | 3,525,840  | 4,053,770  | 6,096,600  |
|                   | Waste to energy                       | pounds          | 5,713,790   | 1,197,570  | 657,890    | 786,250    | 1,129,080  |
|                   | Supply chain                          |                 |             |            |            |            |            |
|                   | Waste diverted from landfill          | metric tons     | 497,000     | 523,000    | 419,000    | 400,000    | 322,000    |
| Product packaging | Packaging                             |                 |             |            |            |            |            |
| footprint         | 4<br>Total packaging                  | metric tons     | 254,270     | 276,100    | 257,000    | 226,000    | 189,000    |
|                   | Recycled fiber                        | % of total      | 62          | 66         | 63         | 60         | 59         |
|                   | Responsibly sourced virgin fiber<br>5 | % of total      | 35          | 30         | 33         | 35         | 33         |
|                   | Plastic                               | % of total      | 3           | 4          | 4          | 6          | 8          |
|                   |                                       |                 |             |            |            |            |            |

# 2024 Environmental Progress Report

82

- 1 We define freshwater as drinking-water quality. The majority of our freshwater comes from municipal sources, and less than 5 percent comes from onsite groundwater sources.
- 2 Recycled water represents a key alternative water source. Our recycled water is sourced primarily from municipal treatment plants, with less than 5 percent coming from onsite treatment. Recycled water is primarily used for irrigation, makeup water in cooling, and toilet flushing.
- 3 Other alternative sources of water include rainwater and recovered condensate captured onsite. Water used for construction activities like dust control is not included in this total and represents 13 million gallons of water used in fiscal year 2021. Beginning with our fiscal year 2023 water footprint, we began allocating our Prineville data center water use, which comes from an Aquifer Storage and Recovery system, to alternative sources to better represent the impact of our water use.
- 4 Beginning in fiscal year 2022, we expanded our packaging goal boundary to better reflect our impact to include retail bags, all finished goods boxes (including plastic content in labels and in-box documentation), packaging sent to our customers as part of Apple Trade In, AppleCare packaging for whole units and service modules (with the exception of plastics needed to protect items from electrostatic discharge), and secondary packaging of Apple products and accessories sold by Apple. Our goal boundary does not include the inks, coatings, or adhesives used in our packaging In addition to our packaging footprint.
- 5 Responsible sourcing of wood fiber is defined in Apple's Sustainable Fiber Specification. Since 2017, all the virgin wood fiber used in our packaging has come from responsible sources.

# <span id="page-82-0"></span>**Data Normalizing factors\***

|                                          | 2023    | 2022    | 2021    | 2020    | 2019    |
|------------------------------------------|---------|---------|---------|---------|---------|
| Net sales (in millions, US\$)            | 383,285 | 394,328 | 365,817 | 274,515 | 260,174 |
| Number of full-time equivalent employees | 161,000 | 164,000 | 154,000 | 147,000 | 137,000 |

\* As reported in Apple's Form 10-K Annual Report filed with the SEC.

<span id="page-83-0"></span>**A: [Corporate facilities energy supplement](#page-84-0) B: [Apple's life cycle assessment methodology](#page-93-0) C: [Assurance and review statements](#page-95-0)** [Net comprehensive carbon footprint, facilities energy,](#page-96-0)  [carbon, waste, paper, and water data \(Apex\)](#page-96-0) [Product carbon footprint \(Fraunhofer Institute\)](#page-99-0) [Supplier Clean Energy Program \(Apex\)](#page-102-0)  [Supplier Energy Efficiency Program \(Apex\)](#page-103-0)  [Packaging fiber and plastic footprint](#page-104-0)  [\(Fraunhofer Institute\)](#page-104-0)  **D: [Environment, Health and Safety Policy](#page-106-0) E: [ISO 14001 certification](#page-108-0) [Report notes](#page-110-0) [End notes](#page-111-0)**

Image /page/83/Picture/3 description: {
 "image\_description": "This is a close-up image showing the internal components of a modern laptop, highlighting its sleek design, compact arrangement, and advanced hardware features."
}

# **Appendix**

**A: Corporate facilities energy supplement B: [Apple's life cycle assessment methodology](#page-93-0)**

**C: [Assurance and review statements](#page-95-0)**

<span id="page-84-0"></span>**D: [Environment, Health and Safety Policy](#page-106-0)**

**E: [ISO 14001 certification](#page-108-0)**

**[Report notes](#page-110-0)**

**[End notes](#page-111-0)**

# **Appendix A**

# **Appendix A**

# **Corporate facilities energy supplement**

Use of renewable energy at our facilities has been a central component of our emissions reduction strategy since 2011. We've learned a lot about how best to secure renewable energy, which has helped us educate suppliers and expand our renewable energy efforts into our supply chain. This appendix summarizes the types of renewable energy solutions we've deployed, and it details how we implement renewable energy at our data centers — our largest energy loads.

# **How we procure renewable energy**

Since launching our renewable energy program in 2011, we've implemented a number of solutions to procure renewable energy. Our strategy has evolved over time to create the most positive impact.

#### **2011**

## **Ownership and PURPA:** Apple's 100 percent equity ownership of our Maiden solar arrays was the first time a nonenergy commercial company built its own utility-scale solar PV project. We used a 1978 federal law called the Public Utility Regulatory Policies Act (PURPA) to structure the project. We then applied this same structure to two more large solar PV and biogas fuel cell projects in North Carolina and two microhydro projects in Oregon. This was a landmark moment in corporate renewable energy development and led to an increased use of PURPA in these states.

### **2012**

**Direct Access:** In California and Oregon, we've used a program called Direct Access to bypass the default electricity generation offered by the utilities servicing our data centers in those states. Instead, we contracted directly with independent power producers and electricity service providers who could supply 100 percent renewable electricity. After initially buying from existing, third-party-owned projects, we're now procuring renewable energy from projects we created: The Solar Star II and Montague Wind projects deliver renewables to our Oregon data center, and the California Flats solar project delivers renewables to our data centers, offices, and retail stores in California.

#### **2013**

## **GreenEnergy Rider:** We opened a new data center in Reno, Nevada. With no PURPA or Direct Access options in Nevada, we worked directly with the local utility, NV Energy, to create a whole new regulatory structure. The Nevada GreenEnergy Rider enables us to secure a long-term, fixed-price contract for renewable electricity from a new solar PV project built for us but managed by the utility. We've used this partnership to create four solar projects totaling 320 megawatts.

## **2014**

**Equity investment:** We invested in two 20-megawatt solar PV projects in Sichuan, China, to support all our in-country retail stores, corporate offices, and data storage facilities. This project represented the first time a commercial company created a new large-scale project in China for its own use. We've since replicated this model many times for Apple's supply chain.

#### **2015 & 2016**

**Portfolio solutions:** We adapted to land scarcity constraints in Singapore and Japan by contracting for solar PV on 800 rooftops in Singapore and 300 in Japan. We adapted our approach in each country to fit local partnerships and regulatory structures: We signed a long-term agreement similar to a power purchase agreement in Singapore and made an equity investment in Japan. These projects offer us long-term flexibility as our load grows.

#### **2017**

**Renewable microgrid:** We've been powering Apple Park with 100 percent renewable energy — more than 50 percent of which is generated onsite and managed by a microgrid. The onsite generation comes from 14 megawatts of rooftop solar PV and 4 megawatts of baseload biogas fuel cells. Any additional energy required is drawn by Direct Access from the California Flats solar project in nearby Monterey County. The microgrid system with battery storage manages the renewable energy generation and the building's energy use; optimizes demand management, load shifting, and frequency regulation services; and ensures uninterrupted energy reliability against local grid outages.

Facilities renewable energy projects To reach 100 percent renewable electricity for Apple's own facilities, Apple has helped create 1,647 MW of renewable energy around the world. The projects listed to the right represent Apple-created renewable energy projects that support Apple facilities' electricity use and contribute to cleaner grids around the world. Operational projects apply a mix of renewable energy technology, including wind (22 percent), solar (78 percent), microhydro (0.2 percent), and biogas fuel cells (0.2 percent).

This table represents all operational renewable energy projects that Apple has helped create.

| Location                  | Renewable energy technology | Size (MW) |
|---------------------------|-----------------------------|-----------|
| Australia                 | PV                          | 0.5       |
| Brazil                    | Wind                        | 0.5       |
| China mainland            | PV                          | 195       |
| Denmark                   | PV                          | 42        |
| Denmark                   | Wind                        | 17        |
| India                     | PV                          | 16        |
| Israel                    | PV                          | 5         |
| Japan                     | PV                          | 12        |
| Mexico                    | Wind                        | 0.8       |
| Power for Impact projects | PV                          | 1.2       |
| Rooftop solar projects    | PV                          | 5         |
| Singapore                 | PV                          | 54        |
| Taiwan                    | PV                          | 1         |
| Türkiye                   | PV                          | 4         |
| Arizona, U.S.             | PV                          | 62        |
| California, U.S.          | Biogas fuel cell            | 4         |
| California, U.S.          | PV                          | 144       |
| Illinois, U.S.            | Wind                        | 112       |
| Nevada, U.S.              | PV                          | 320       |
| North Carolina, U.S.      | PV                          | 164       |
| Oregon, U.S.              | Microhydro                  | 3         |
| Oregon, U.S.              | PV                          | 125       |
| Oregon, U.S.              | Wind                        | 200       |
| Texas, U.S.               | Wind                        | 25        |
| Virginia, U.S.            | PV                          | 134       |
| Total                     |                             | 1647      |

Note: Data current as of February 2024 (operational).

#### Dash indicates unavailable data.

N/A = Gas use at colocation facilities is considered outside of Apple's operational control.

1 Scope 2 market-based emissions from purchased electricity is zero. But, we also account for purchased steam, heating, and cooling, which resulted in 3,400 metric tons of emissions in fiscal year 2023.

#### **Fiscal year 2023 energy and carbon footprint (corporate facilities)**

The table below provides a detailed breakdown of 2023 energy use, which we used to calculate our greenhouse gas emissions.

|                                       | Scope 1              |                             |                                         | x Scope 2                    |                                        |                                                           |
|---------------------------------------|----------------------|-----------------------------|-----------------------------------------|------------------------------|----------------------------------------|-----------------------------------------------------------|
| Location                              | Total gas<br>(MMBtu) | Renewable<br>biogas (MMBtu) | Scope 1 emissions (metric<br>tons CO2e) | Electricity<br>(million kWh) | Renewable electricity<br>(million kWh) | Scope 2 emissions<br>(market-based, metric<br>tons CO2e)1 |
| Corporate                             | 1,007,071            | 746,506                     | 42,746                                  | 940                          | 940                                    | 0                                                         |
| Cupertino, CA                         | 805,271              | 202,306                     | 32,027                                  | 427                          | 427                                    | 0                                                         |
| Elk Grove, CA                         | 10,175               | 0                           | 540                                     | 14                           | 14                                     | 0                                                         |
| Austin, TX                            | 24,826               | 0                           | 1,319                                   | 113                          | 113                                    | 0                                                         |
| Other U.S.                            | 104,718              | 544,200                     | 5,562                                   | 143                          | 143                                    | 0                                                         |
| Cork, Ireland                         | 24,219               | 0                           | 1,286                                   | 16                           | 16                                     | 0                                                         |
| Singapore                             | 518                  | 0                           | 28                                      | 18                           | 18                                     | 0                                                         |
| China                                 | 960                  | 0                           | 51                                      | 41                           | 41                                     | 0                                                         |
| Other international                   | 36,384               | 0                           | 1,933                                   | 168                          | 168                                    | 0                                                         |
| Data center                           | 740                  | 0                           | 39                                      | 2,344                        | 2,344                                  | 0                                                         |
| Maiden, NC                            | 0                    | 0                           | 0                                       | 453                          | 453                                    | 0                                                         |
| Mesa, AZ                              | 524                  | 0                           | 28                                      | 488                          | 488                                    | 0                                                         |
| Newark, CA                            | 0                    | 0                           | 0                                       | 0                            | 0                                      | 0                                                         |
| Prineville, OR                        | 216                  | 0                           | 11                                      | 269                          | 269                                    | 0                                                         |
| Reno, NV                              | 0                    | 0                           | 0                                       | 440                          | 440                                    | 0                                                         |
| Viborg, Denmark                       | –                    | –                           | –                                       | 40                           | 40                                     | 0                                                         |
| Colocation facilities (U.S.)          | –                    | –                           | –                                       | 387                          | 387                                    | 0                                                         |
| Colocation facilities (international) | –                    | –                           | –                                       | 96                           | 96                                     | 0                                                         |
| China                                 | –                    | –                           | –                                       | 171                          | 171                                    | 0                                                         |
| Retail stores                         | 58,446               | 0                           | 3,105                                   | 203                          | 203                                    | 0                                                         |
| Domestic (U.S.)                       | 34,449               | 0                           | 1,830                                   | 96                           | 96                                     | 0                                                         |
| International                         | 23,997               | 0                           | 1,275                                   | 107                          | 107                                    | 0                                                         |
| Total                                 | 1,066,257            | 746,506                     | 45,890                                  | 3,199                        | 3,199                                  | 0                                                         |

#### **A focus on data centers**

We used over 2.3 billion kWh of electricity in 2023 to power our data centers and colocation facilities around the world. We're proud that 100 percent of that electricity came from renewable sources including solar, wind, biogas fuel cells, and lowimpact hydropower. To cover our needs, we build our own renewable power projects and work with utilities to purchase clean energy from locally obtained resources. We're staying at 100 percent even as Apple's data center presence continues to grow.

We now operate seven data centers, and more are being developed.2 These data centers are spread across North America, Europe, and Asia. Each has unique design features that conserve energy and reflect the climate, as well as other aspects, of its location.

#### **Maiden, North Carolina**

100 percent renewable since opening June 2010 Between 2011 and 2015, we installed 68 megawatts of Apple-created projects: two 20-megawatt solar projects, an 18-megawatt solar project, and 10 megawatts of biogas fuel cells. We then worked with the local utility, Duke Energy, to help build five solar projects through its Green Source Rider program. These solar projects came online beginning in 2015 and were Duke Energy's first Green Source Rider projects to become operational. We worked with Duke Energy for several years to develop this green energy tariff option, which allowed Apple

and Duke Energy to develop new renewable energy projects. The five Green Source Rider projects have a combined capacity of 22 megawatts. In 2017, we made long-term commitments to five more solar projects in North Carolina, for an additional 85 megawatts of renewable energy.

The energy efficiency measures we've implemented at our Maiden data centers include use of outside air cooling through a waterside economizer during night and cool-weather hours, which, along with water storage, allows the chillers to be idle 75 percent of the time.

#### 2 In our 2023 Environmental Progress Report, we stated that we operate eight data centers. For fiscal year 2023, we no longer include the Newark, CA data center as it has been sold in fiscal year 2022.

3 Emissions avoided are calculated using the GHG Protocol methodology for calculating marketbased emissions.

#### **Maiden, North Carolina: Grid mix versus. Apple-sourced renewable energy**

Electricity use in 2023: 453 million kWh Emissions avoided in 2023: 121,00 million MT CO2e<sup>3</sup>

| Default grid mix | %  | Apple actual renewable energy allocation | %  |
|------------------|----|------------------------------------------|----|
| Gas              | 43 | Apple's solar projects                   | 8  |
| Nuclear          | 32 | Apple's wind projects                    | 12 |
| Coal             | 11 | Source: 2023 energy data.                |    |
| Renewable        | 10 |                                          |    |
| Hydro            | 4  |                                          |    |

Source: eGRID 2022.

## **Prineville, Oregon**

100 percent renewable since opening May 2012 To support our Prineville data center, we signed a 200-megawatt power purchase agreement for a new Oregon wind farm, the Montague Wind Power Facility, which entered commercial operation at the end of 2019.

This is in addition to our power purchase agreement for the 56-megawatt Solar Star Oregon II project located just a few miles from our data center. This solar PV project came online and began supporting the data center in 2017. To strengthen the connection between Apple and these projects, we use Oregon's Direct Access program to supply the renewable energy from these projects directly to our data center.

Also supporting the data center are two microhydro projects that harness the power of water flowing through local irrigation canals that have been operating for over 60 years. To supplement these projects, we executed a long-term purchase agreement for all environmental attributes from a 69-megawatt portfolio of eight solar projects in Oregon.

Our Prineville data center takes advantage of the cool and dry climate by cooling its servers with outside air whenever possible. Indirect evaporative cooling is enabled when the outside air temperature gets too high to cool the servers with outside air alone.

## **Reno, Nevada**

## 100 percent renewable since opening December 2012

Unlike competitive energy markets where some of our data centers are located, the regulated electricity supply in Nevada did not offer a simple solution for us to create new renewable energy projects dedicated to our data center. In 2013, we created a partnership with the local utility, NV Energy, to develop the Fort Churchill Solar project. Apple designed, financed, and constructed the project. NV Energy owns and operates the facility and directs all the renewable energy it produces to our data center. The nearly 20-megawatt Fort Churchill Solar project was based on a unique tracker with curved mirrors that concentrate sunlight onto photovoltaic cells.

To facilitate further renewable development in Nevada, Apple worked with NV Energy and the Public Utility Commission of Nevada to create a green energy option open to all commercial customers, called the NV GreenEnergy Rider, that does not require the customer to fund project development up front. Thanks to this new option, in 2015 we announced our second Nevada solar project, the 50-megawatt Boulder Solar II project. This project came online in 2017. We've utilized the NV GreenEnergy Rider program to create two additional projects: the 200-megawatt Techren II solar project, online in 2019, and the 50-megawatt Turquoise Project, online in 2020.

Like in Prineville, our Reno data center takes advantage of the mild climate by cooling its servers with outside air whenever possible. When the outside air is too warm to cool the servers alone, it draws from indirect evaporative cooling.

- 4 Emissions avoided are calculated using the GHG Protocol methodology for calculating marketbased emissions.
- 5 Emissions avoided are calculated using the GHG Protocol methodology for calculating marketbased emissions.

#### **Prineville, Oregon: Grid mix versus Apple-sourced renewable energy**

Electricity use in 2023: 269 million kWh Emissions avoided in 2023: 79,800 million CO2e<sup>4</sup>

| Default grid mix    | %  | Apple actual renewable energy allocation | %  |
|---------------------|----|------------------------------------------|----|
| Hydro               | 51 | Apple's solar projects                   | 38 |
| Gas                 | 31 | Apple's wind projects                    | 60 |
| Renewable           | 18 | Apple's microhydro projects              | 2  |
| Source: eGrid 2022. |    | Source: 2023 energy data.                |    |

#### **Reno, Nevada: Grid mix versus Apple-sourced renewable energy**

Electricity use in 2023: 440 million kWh Emissions avoided in 2023: 130,600 million MT CO2e<sup>5</sup>

| Default grid mix          | %  |
|---------------------------|----|
| Gas                       | 59 |
| Renewable                 | 30 |
| Coal                      | 7  |
| Hydro                     | 4  |
| Apple actual renewable    |    |
| Apple's solar projects (N |    |
| Source: 2023 energy data  |    |

| Default grid mix | %  | Apple actual renewable energy allocation              | %   |
|------------------|----|-------------------------------------------------------|-----|
| Gas              | 59 | Apple's solar projects (NV GreenEnergy Rider program) | 100 |
| Renewable        | 30 | Source: 2023 energy data.                             |     |

Source: eGRID 2022.

## **Mesa, Arizona**

100 percent renewable since opening March 20176 Our global command data center in Mesa, Arizona, came online in 2016. To support this facility, we partnered with the local utility, Salt River Project (SRP), to build the 50-megawatt Bonnybrooke solar

As the Mesa data center grew, it became apparent that we needed additional sources of renewable energy to maintain our 100 percent renewable electricity goal.

project, which became operational in January 2017.

We began to explore onsite solar options at the data center and determined that we could provide valuable shaded parking that paid for itself through energy bill reductions while adding to our renewable energy portfolio. The resulting PV facility includes five elevated parking canopies and three groundmounted arrays, for a total generating capacity of 4.67 MW. The onsite PV system began commercial operation in March 2019.

#### **Denmark**

## 100 percent renewable energy from the first day of operations

Our data center came online in 2020. The data center's construction phase was powered with 100 percent wind energy from a local renewable energy retailer in Denmark. Our Northern Jutland PV project achieved commercial operation in late 2019, will meet all the data center's near-term energy needs, and at 42 megawatts, is one of Denmark's largest solar power plants. Our second renewable project in Denmark, a 17 MW wind project, also came

online in late 2020. We've secured long-term supply contracts with both Danish renewable projects, which will scale up as our data center loads grow.

The power system design at the data center is based on a resilient substation that eliminates the need for backup diesel generators. This reduces the carbon footprint of the data center and completely eliminates the need for large diesel fuel storage systems and diesel engine emissions that would impact the local community.

- 6 Apple took operational control of the building in October 2015 and converted it to a data center that began servicing customers in March 2017.
- 7 Emissions avoided are calculated using the GHG Protocol methodology for calculating marketbased emissions.
- 8 Emissions avoided are calculated using the GHG Protocol methodology for calculating marketbased emissions.

#### **Mesa, Arizona: Grid mix versus Apple-sourced renewable energy**

Electricity use in 2023: 488 million kWh Emissions avoided in 2023: 181,500 million MT CO2e<sup>7</sup>

| Default grid mix | %  | Apple actual renewable energy allocation | %  |
|------------------|----|------------------------------------------|----|
| Gas              | 43 | Apple's solar projects                   | 8  |
| Nuclear          | 31 | Apple's wind projects                    | 18 |
| Coal             | 13 | Source: 2023 energy data.                |    |
| Hydro            | 5  |                                          |    |
| Renewable        | 9  |                                          |    |

Source: eGRID 2022.

Note: Total doesn't add up to 100 percent due to rounding.

**Denmark: Grid mix versus Apple-sourced renewable energy** 

Electricity use in 2023: 40 million kWh Emissions avoided in 2023: 22,000 million MT CO2e<sup>8</sup>

| Default grid mix                                                     | %  |
|----------------------------------------------------------------------|----|
| Renewable                                                            | 62 |
| Hydro                                                                | 20 |
| Coal                                                                 | 8  |
| Gas                                                                  | 5  |
| Nuclear                                                              | 4  |
| Other                                                                | 1  |
| Source: Energinet. https://energinet.dk/data-om-energi/deklarationer |    |

[og-csr/lokationsbaseret-deklaration-miljodeklaration/](https://energinet.dk/data-om-energi/deklarationer-og-csr/lokationsbaseret-deklaration-miljodeklaration/).

| Default grid mix | %  | Apple actual renewable energy allocation | %   |
|------------------|----|------------------------------------------|-----|
| Renewable        | 62 | Apple's wind and solar projects          | 100 |
| Hydro            | 20 | Source: 2023 energy data.                |     |

## **China**

## 100 percent renewable energy from the first day of operations

To cover the electricity load at our two data centers in China, we secured long term agreements with solar and wind projects in China — both operational.

As the data centers further expand, we'll continue to source renewable electricity in-country to support the growth with renewable electricity.

#### **China: Grid mix versus Apple-sourced renewable energy**

Electricity use in 2023: 171 million kWh Emissions avoided in 2023: 105,000 million kWh<sup>9</sup>

| Default grid mix                                                | %  | Apple actual renewable energy allocation | %  |
|-----------------------------------------------------------------|----|------------------------------------------|----|
| Coal                                                            | 63 | Apple's solar projects                   | 50 |
| Hydro                                                           | 17 | Apple's wind projects                    | 50 |
| Renewable                                                       | 11 | Source: 2023 energy data.                |    |
| Nuclear                                                         | 5  |                                          |    |
| Gas                                                             | 3  |                                          |    |
| Source: IEA Electricity Information 2022, www.iea.org/data-and- |    |                                          |    |

[statistics/data-product/electricity-information](www.iea.org/data-and-statistics/data-product/electricity-information).

9 Emissions avoided are calculated using the GHG Protocol methodology for calculating marketbased emissions.

The majority of our online services are provided by our own data centers; however, we also use third-party colocation facilities for additional data center capacity. While we don't own these shared facilities and use only a portion of their total capacity, we include our portion of their energy use in our renewable energy goals.

Starting in January 2018, 100 percent of our power for colocation facilities was matched with renewable energy generated within the same country or regional grid. As our loads grow over time, we'll continue working with our colocation suppliers to match 100 percent of our energy use with renewables.

### **Third-party computing**

Beyond the use of our own data centers and colocation facilities, we also use third-party services to support some of our on-demand cloud computing and storage services. As of 2023 , all the electricity associated with Apple's load at our third-party computing vendors is matched with 100 percent clean energy.

|           | Total energy<br>use (kWh) | Renewable<br>energy (kWh) | Default utility emissions<br>(metric tons CO2e)10 | Apple's emissions –<br>including renewable energy<br>(metric tons CO2e)11 | Percent renewable<br>energy (%)12 |
|-----------|---------------------------|---------------------------|---------------------------------------------------|---------------------------------------------------------------------------|-----------------------------------|
| FY 2011   | 42,500                    | 0                         | 10                                                | 10                                                                        | 0                                 |
| FY 2012   | 38,552,300                | 1,471,680                 | 17,200                                            | 16,500                                                                    | 4                                 |
| FY 2013   | 79,462,900                | 46,966,900                | 31,800                                            | 14,500                                                                    | 59                                |
| FY 2014   | 108,659,700               | 88,553,400                | 44,300                                            | 11,000                                                                    | 81                                |
| FY 2015   | 142,615,000               | 121,086,100               | 60,500                                            | 12,700                                                                    | 85                                |
| FY 201613 | 145,520,900               | 143,083,200               | 66,300                                            | 1,600                                                                     | 98                                |
| FY 2017   | 289,195,800               | 286,378,100               | 125,600                                           | 1,500                                                                     | 99                                |
| FY 2018   | 327,663,800               | 326,959,700               | 146,600                                           | 400                                                                       | 100                               |
| FY 2019   | 339,047,649               | 339,047,649               | 146,400                                           | 0                                                                         | 100                               |
| FY 2020   | 372,901,398               | 372,901,398               | 153,459                                           | 0                                                                         | 100                               |
| FY 2021   | 384,727,076               | 384,727,076               | 146,780                                           | 0                                                                         | 100                               |
| FY 2022   | 487,921,930               | 487,921,930               | 182,700                                           | 0                                                                         | 100                               |
| FY 2023   | 483,299,062               | 483,299,062               | 186,141                                           | 0                                                                         | 100                               |

- 10 We calculate default utility emissions to provide baseline emissions of what our carbon footprint would have been without the use of renewable energy. This allows us to demonstrate the savings resulting from our renewable energy program.
- 11 Apple's greenhouse gas emissions are calculated using the World Resources Institute Greenhouse Gas Protocol methodology for calculating market-based emissions.
- 12 We calculate our progress toward our 100 percent renewable energy goal on a calendar-year basis, while the numbers reported in this table are based on fiscal year. Beginning January 1, 2018, all the electricity use at our colocation facilities is from 100 percent renewable energy.
- 13 Over the past few years, we've been installing submeters in colocation facilities to better track electricity usage. Beginning in fiscal year 2016, we started reporting this submetered electricity usage. Prior to fiscal year 2016, reported electricity usage was conservatively estimated based on maximum contract capacity quantities. We've updated our fiscal year 2016 colocation facilities footprint to more accurately reflect Apple's operational boundaries. Per the GHG Protocol, we've removed from our electricity usage and scope 2 calculations those emissions associated with colocation facility cooling and building operations.

**2024 Environmental Progress Report 94**

- **A: [Corporate facilities energy supplement](#page-84-0) B: Apple's life cycle assessment methodology C: [Assurance and review statements](#page-95-0)**
- <span id="page-93-0"></span>**D: [Environment, Health and Safety Policy](#page-106-0)**
- **E: [ISO 14001 certification](#page-108-0) [Report notes](#page-110-0)**
- **[End notes](#page-111-0)**

# **Appendix B**

# **Appendix B**

# **Apple's life cycle assessment methodology**

When conducting a product life cycle assessment (LCA), we calculate greenhouse gas emissions using the 100-year time horizon global warming potentials (GWP100) from the 2023 IPCC Sixth Assessment Report (AR6),1 including biogenic carbon.

There is inherent uncertainty in modeling greenhouse gas emissions due primarily to data limitations. For the top component contributors to Apple's greenhouse gas emissions, Apple addresses this uncertainty by developing detailed processbased environmental models with Apple-specific parameters. For the remaining elements of Apple's carbon footprint, we rely on industry average data and assumptions.

The following details the five steps we use to conduct our LCA:

#### **PRODUCT LCA PROCESS**

**How Apple conducts our product greenhouse gas life cycle assessment**

**To model transportation**

# **To model the manufacturing phase**

We use part-by-part measurements of the entire product along with data on part production. In some cases where part-by-part data is not readily available, we also use design-level data for size and weight detail. The measurements help us accurately determine the size and weight of the components and materials in the product, while data on manufacturing processes and yield loss during production allows us to account for the impact of manufacturing. The LCA includes accessories and packaging, as well as decreased emissions through Apple's Supplier Clean Energy Program. When calculating Apple's comprehensive carbon footprint, we also include units that are repaired and replaced through AppleCare.

We use data collected on shipments of single products and multipack units by land, sea, and air. We account for transporting materials between manufacturing sites; transporting products from manufacturing sites to regional distribution hubs; transporting products from regional distribution hubs to individual customers; and transporting products from final customers to recycling facilities.

#### **To model customer use**

We measure the power consumed by a product while it is running in a simulated scenario. Daily usage patterns are specific to each product and are a mixture of actual and modeled customer use data. For the purposes of our assessment, years of use, which are based on first owners, are modeled to be four years for macOS, visionOS, and tvOS devices and three years for iOS, iPadOS, and watchOS devices. Most Apple products last longer and are often passed along, resold, or returned to Apple by the first owner for others to use. More information on our product energy use is provided in our Product Environmental Reports.

#### **To model end of life**

We use material composition data on our products and estimate the ratio of products that are sent to recycling or disposal. For products sent to recycling, we capture the initial processing by the recycler to prepare the product for recovery of electronic, metal, plastic, and glass material streams. Subsequent downstream recycling processes are not included, as these are considered stages of production and not end-oflife processing. For products sent to disposal, we capture the emissions associated with landfilling or incineration of each type of material.

## **Putting it all together**

After we collect data about manufacturing, use, transportation, and end of life, we combine it with detailed greenhouse gas emission data. This emission data is based on a combination of Apple-specific and industry-average data sets for material production, manufacturing processes, electricity generation, and transportation. Renewable energy used in the supply chain, initiated by suppliers independently or through the Apple Supplier Clean Energy Program, is also accounted for within the LCA model. Combining productspecific information with emission data in our LCA allows us to compile detailed results for greenhouse gas emissions as they relate to each product. The data and modeling approaches are checked for quality and accuracy by the Fraunhofer Institute in Germany.

### 024 Environmental Progress Report 95

<span id="page-95-0"></span>**A: [Corporate facilities energy supplement](#page-84-0) B: [Apple's life cycle assessment methodology](#page-93-0) C: Assurance and review statements** [Net comprehensive carbon footprint, facilities energy,](#page-96-0)  [carbon, waste, paper, and water data \(Apex\)](#page-96-0) [Product carbon footprint \(Fraunhofer Institute\)](#page-99-0) [Supplier Clean Energy Program \(Apex\)](#page-102-0)  [Supplier Energy Efficiency Program \(Apex\)](#page-103-0)  [Packaging fiber and plastic footprint](#page-104-0)  [\(Fraunhofer Institute\)](#page-104-0)  **D: [Environment, Health and Safety Policy](#page-106-0) E: [ISO 14001 certification](#page-108-0) [Report notes](#page-110-0) [End notes](#page-111-0)**

# **Appendix C**

<span id="page-96-0"></span>**Net comprehensive carbon footprint, facilities energy, carbon, waste, paper, and water data (Apex)**

#### **INDEPENDENT ASSURANCE STATEMENT**

![Company Logo](https://example.com/logo.png)

**Apex**

**To: The Stakeholders of Apple Inc.**

#### **Introduction and objectives of work**

Apex Companies, LLC (Apex) was engaged by Apple Inc. (Apple) to conduct an independent assurance of select environmental data reported in its 2023 environmental report (the Report). This assurance statement applies to the related information included within the scope of work described below. The intended users of the assurance statement are the stakeholders of Apple. The overall aim of this process is to provide assurance to Apple's stakeholders on the accuracy, reliability and objectivity of Subject Matter included in the Report.

This information and its presentation in the Report are the sole responsibility of the management of Apple. Apex was not involved in the collection of the information or the drafting of the Report.

#### **Scope of Work**

Apple requested Apex to include in its independent review the following (Subject Matter):

- Assurance of select environmental data and information included in the Report for the fiscal year 2023 reporting period (September 25, 2022 through September 30, 2023), specifically, in accordance with Apple's definitions and World Resources Institute (WRI)/World Business Council for Sustainable Development (WBCSD) Greenhouse Gas Protocol:
  - o Energy: Direct (Million Therms) and Indirect (Million kilowatt hours (mkWh))
  - o Renewable Energy (mkWh)
  - o Water Withdrawal (Million Gallons)
- o Greenhouse Gas (GHG) Emissions: Direct Scope 1 emissions by weight, Indirect Scope 2 emissions by weight, Indirect Scope 3 emissions by weight (Purchased Goods and Services, Fuel and Energy Related Activities, Employee Commute and Business Travel) (Metric Tonnes of Carbon Dioxide equivalent)
- o Apple Comprehensive Carbon Footprint
- o Waste Quantities and Disposition (Metric Tonnes)
- o Paper Quantities (Metric Tonnes)

#### Excluded from the scope of our work is any assurance of information relating to:

- Text or other written statements associated with the Report
- Activities outside the defined assurance period

#### **Assessment Standards**

Our work was conducted against Apex's standard procedures and guidelines for external Verification of Sustainability Reports, based on current best practice in independent assurance. Apex procedures are based on principles and methods described in the International Standard on Assurance Engagements (ISAE) 3000 Revised, Assurance Engagements Other than Audits or Reviews of Historical Financial Information (effective for assurance reports dated on or after Dec. 15, 2015), issued by the International Auditing and Assurance Standards Board and ISO 14064-3: Greenhouse gases -- Part 3: Specification with guidance for the validation and verification of greenhouse gas statements.

#### **Methodology**

Apex undertook the following activities:

- 1. Site visits to Apple facilities in Rialto, California and Battersea, United Kingdom;
- 2. Interviews with relevant personnel of Apple;
- 3. Review of internal and external documentary evidence produced by Apple;
- 4. Audit of environmental performance data presented in the Report, including a detailed review of a sample of data against source data; and
- 5. Review of Apple information systems for collection, aggregation, analysis and internal verification and review of environmental data.

The work was planned and carried out to provide reasonable assurance for the following indicators, and we believe it provides an appropriate basis for our conclusions:

- Energy: Direct (Million Therms) and Indirect (Million kilowatt hours (mkWh))
- Renewable Energy (mkWh)
- Water Withdrawal (Million Gallons)
- Greenhouse Gas (GHG) Emissions: Direct Scope 1 emissions by weight, Indirect Scope 2 emissions by weight (Metric Tonnes of Carbon Dioxide equivalent)
- Paper Quantities (Metric Tonnes)

The work was planned and carried out to provide limited assurance for the following indicators, and we believe it provides an appropriate basis for our conclusions:

- Greenhouse Gas (GHG) Emissions: Indirect Scope 3 emissions by weight (Purchased Goods and Services, Fuel and Energy-Related Activities, Employee Commuting and Business Travel) (Metric Tonnes of Carbon Dioxide equivalent)
- Apple Comprehensive Carbon Footprint
- Waste Quantities and Disposition (Metric Tonnes)

#### **Our Findings**

Apex verified the following indicators for Apple's Fiscal Year 2022 reporting period (September 25, 2022 through September 30, 2023):

| Parameter                                                                                  | Quantity  | Units                                                    | Boundary / Protocol                                                                   |
|--------------------------------------------------------------------------------------------|-----------|----------------------------------------------------------|---------------------------------------------------------------------------------------|
| Natural Gas Consumption                                                                    | 1,066,300 | Metric million British<br>thermal unit                   | Worldwide occupied<br>properties / Apple Internal<br>Protocol                         |
| Electricity Consumption                                                                    | 3,500     | Million kilowatt<br>hours (mkWh)                         | Worldwide occupied<br>properties / Apple Internal<br>Protocol                         |
| Renewable Energy                                                                           | 3,500     | Million kilowatt<br>hours (mkWh)                         | Worldwide / Invoiced<br>quantities & self-generated                                   |
| Scope 1 GHG Emissions                                                                      | 55,200    | Metric tonnes of<br>carbon dioxide<br>equivalent (tCO2e) | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol                          |
| Scope 2 GHG Emissions<br>(Location-Based)                                                  | 1,206,700 | tCO2e                                                    | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol                          |
| Scope 2 GHG Emissions<br>(Market-Based)                                                    | 3,400     | tCO2e                                                    | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol                          |
| Scope 3 Transmission and<br>Distribution Loses (Market<br>Based)                           | 0         | tCO2e                                                    | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol Value Chain<br>(Scope 3) |
| Scope 3 GHG Emissions –<br>Upstream Fuel-Related<br>Activities                             | 18,300    | tCO2e                                                    | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol Value Chain<br>(Scope 3) |
| Scope 3 GHG Emissions –<br>Business Travel                                                 | 225,700   | tCO2e                                                    | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol Value Chain<br>(Scope 3) |
| Category                                                                                   | Value     | Unit                                                     | Scope/Source                                                                          |
| Scope 3 GHG Emissions – Employee Commute                                                   | 164,100   | tCO₂e                                                    | Worldwide occupied properties / WRI/WBCSD GHG Protocol Value Chain (Scope 3)          |
| Scope 3 GHG Emissions - Work From Home Emissions (Employee Commute) (Location-Based)       | 20,600    | tCO₂e                                                    | Worldwide occupied properties / WRI/WBCSD GHG Protocol Value Chain (Scope 3)          |
| Scope 3 GHG Emissions – Work From Home Emissions (Employee Commute) (Market-Based)         | 4,700     | tCO₂e                                                    | Worldwide occupied properties / WRI/WBCSD GHG Protocol Value Chain (Scope 3)          |
| Scope 3 GHG Emissions - Other Cloud Services (Purchased Goods and Services) (Market-Based) | 0         | tCO₂e                                                    | Worldwide occupied properties / WRI/WBCSD GHG Protocol Value Chain (Scope 3)          |
| Water Withdrawal                                                                           | 1600      | Million gallons                                          | Worldwide occupied properties / Apple Internal Protocol                               |
| Water Discharge                                                                            | 900       | Million gallons                                          | Worldwide occupied properties / Apple Internal Protocol                               |
| Trash Disposed in Landfill                                                                 | 17,400    | Metric tonnes                                            | Worldwide occupied properties / Apple Internal Protocol                               |
| Hazardous Waste (Regulated waste)                                                          | 3,300     | Metric tonnes                                            | Worldwide occupied properties / Apple Internal Protocol                               |
| Recycled Material (Removal by recycling contractor)                                        | 37,000    | Metric tonnes                                            | Worldwide occupied properties / Apple Internal Protocol                               |
| Composted Material                                                                         | 6,700     | Metric tonnes                                            | Worldwide occupied properties / Apple Internal Protocol                               |
| Waste to Energy                                                                            | 2,600     | Metric tonnes                                            | Worldwide occupied properties / Apple Internal Protocol                               |
| C&D Landfilled                                                                             | 3,200     | Metric tonnes                                            | Worldwide occupied properties / Apple Internal Protocol                               |
| C&D Recycled                                                                               | 23,600    | Metric tonnes                                            | Worldwide occupied properties / Apple Internal Protocol                               |
| Paper Used                                                                                 | 1,100     | Metric tonnes                                            | Worldwide occupied properties / Apple Internal Protocol                               |
| Product end use avoided emissions                                                          | 48,800    | tCO₂e                                                    | Worldwide occupied properties / WRI/WBCSD GHG Protocol Value Chain (Scope 3)          |

Apex Companies, LLC Page 2 of 5

Image /page/96/Picture/46 description: {
 "image\_description": "A logo consisting of the word 'APEX' below an abstract design with colored shapes."
}

|                                            |            | Comprehensive Carbon Footprint (Market Based) |                                                              |
|--------------------------------------------|------------|-----------------------------------------------|--------------------------------------------------------------|
| Corporate GHG Emissions<br>(Market-Based)1 | 471,400    | tCO2e                                         | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol |
| Product Use2                               | 4,600,000  | tCO2e                                         | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol |
| Manufacturing3                             | 9,400,000  | tCO2e                                         | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol |
| Transportation4                            | 1,500,000  | tCO2e                                         | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol |
| Recycling4                                 | 70,000     | tCO2e                                         | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol |
| Comprehensive Carbon<br>Footprint5         | 16,100,000 | tCO2e                                         | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol |

| Parameter       | Quantity   | Units | Boundary / Protocol                                                      |
|-----------------|------------|-------|--------------------------------------------------------------------------|
| Carbon Removals | 485,000    | tCO2e | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol Value Chain |
| Net Footprint6  | 15,600,000 | tCO2e | Worldwide occupied<br>properties / WRI/WBCSD<br>GHG Protocol Value Chain |

1. Corporate GHG Emissions = Scope 1 GHG Emissions + Scope 2 (Market-Based) GHG Emissions + Scope 3 GHG Emissions 2. Product Use emissions (4.65 million metric tonnes) reportedly verified by another third-party provider. Apex verified 0.05 million

metric tonnes reduction. 3. Manufacturing emissions (27.92 million metric tonnes) not verified by Apex - reportedly verified by another third-party provider - CEP emissions reductions (18.51 million metric tonnes).

4. Not Verified by Apex. Reportedly verified by another third-party provider.

5. Comprehensive Carbon Footprint = Corporate GHG Emissions + Product Use + Manufacturing + Transportation + Recycling 6. Net Footprint= Gross Carbon Footprint – Carbon Removals

#### **Our Conclusion**

Based on the assurance process and procedures conducted regarding the Subject Matter, we conclude that:

- The Energy, Water, Paper, and Scope 1, Scope 2, Scope 3 (Business Travel & Employee Commute) GHG Emissions assertions shown above are materially correct and are a fair representation of the data and information;
- There is no evidence that the Scope 3 (Business Travel, Employee Commute Work From Home, Other Cloud Services, and Fuel and Energy Related Activities) GHG emissions, Waste, and Comprehensive Carbon Footprint assertions shown above are not materially correct and are not a fair representation of the data and information;
- Apple has established appropriate systems for the collection, aggregation and analysis of relevant environmental information, and has implemented underlying internal assurance practices that provide a reasonable degree of confidence that such information is complete and accurate.

**Apex Companies, LLC**

Image /page/97/Picture/15 description: {
 "image\_description": "The image consists of a logo and text. The logo comprises stylized geometric shapes forming the letter 'A' in green, blue, and yellow, accompanied by the text 'APEX' below it. The image includes the text 'Apex Companies, LLC' in the upper left corner and 'Page 4 of 5' in the upper right corner."
}

Page 4 of 5

Apex Companies, LLC Page 3 of 5

Image /page/97/Picture/18 description: {
 "image\_description": "A logo consisting of a stylized letter 'A' made up of colored shapes (blue, green, orange), next to the word 'APEX' in gray text."
}

Sorry, I am unable to process this image as it is not sufficiently detailed or complete to extract meaningful text.

#### **Statement of independence, integrity and competence**

Apex has implemented a Code of Ethics across the business to maintain high ethical standards among staff in their day to day business activities. We are particularly vigilant in the prevention of conflicts of interest.

No member of the assurance team has a business relationship with Apple, its Directors or Managers beyond that required of this assignment. We have conducted this verification independently, and there has been no conflict of interest.

The assurance team has extensive experience in conducting verification and assurance over environmental, social, ethical and health and safety information, systems and processes, has over 30 years combined experience in this field and an excellent understanding of Apex standard methodology for the Assurance of Sustainability Reports.

**Attestation:** 

I'm sorry, but without access to the unaltered image text content, I cannot accurately reproduce the text in markdown format. If you can provide a clearer or textual description, I'd be happy to assist!

ESG Director, National Practice Lead ESG Program Manager Apex Companies, LLC Apex Companies, LLC

Trevor Donaghu, Lead Verifier Mary E. Armstrong-Friberg, Technical Reviewer

April 11, 2024

# Apex Companies, LLC

Page 5 of 5

# <span id="page-99-0"></span>**Product carbon footprint (Fraunhofer Institute)**

Image /page/99/Picture/4 description: {
 "image\_description": "A document bearing the Fraunhofer IZM logo emphasizing assurance of Apple's carbon footprint assessment methodology compliance according to specified international standards."
}

![Fraunhofer IZM Logo](https://www.fraunhofer.de/content/dam/izb/de/logo_Fraunhofer_IZM.png)

been regularly reviewed by Fraunhofer IZM experts since 2007 with a view to providing independent feedback that can facilitate continuous improvement and refinement in the LCA methodology applied by Apple Inc.

Data reported by Apple is as follows:

| Year | Manufacturing<br>[MMT CO2e] | Transportation<br>[MMT CO2e] | Product Use<br>[MMT CO2e] | Recycling<br>[MMT CO2e] | Total base product footprint<br>[MMT CO2e] |
|------|-----------------------------|------------------------------|---------------------------|-------------------------|--------------------------------------------|
| 2023 | 27.92                       | 1.50                         | 4.65                      | 0.07                    | 34.14                                      |

The total Scope 3 product-related carbon footprint is reported to be 34.14 million metric tons CO₂e, applying a location-based method reflecting the average emissions intensity of grids on which energy consumption occurs. This figure does not include greenhouse

Based on the process and procedures conducted, there is no evidence that the Greenhouse Gas (GHG) assertion with regards to scope 3 carbon footprint

## 2 Reviewed Data and Plausibility Check

A verification and sampling plan as required by ISO 14046-3 has been established for the comprehensive carbon footprint review and verification, defining the level of assurance, objectives, criteria, scope and materiality of the verification.

As part of this review and verification, Apple disclosed the following data to Fraunhofer IZM:

**Comprehensive Carbon Footprint Letter of Assurance**  
Client: Apple Inc.

The following table corrects and formats the provided content accurately: 

| Points from the provided text: | The breakdown of the carbon footprint into life cycle phases; manufacturing, transportation, product use, and recycling. Detailed product-specific split into life cycle phases. The contribution of individual products and product families to the overall carbon footprint. Assessment was conducted remotely. |
|--------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Findings:                      | ISO 14040/44 and ISO 14067 compliant LCAs were conducted for various products.                                                                                                                                                                                                                                    |
| Conclusions:                   | Assessment approach is excellent in granularity of data.                                                                                                                                                                                                                                                          |

The qualifications and credentials of the reviewers are available at the provided link, along with extensive experience and background in the field of carbon footprint analysis.

Image /page/101/Picture/2 description: {
 "image\_description": "This is a professional document page detailing the credentials and experiences of Marina Proske in the field of Life Cycle Assessments, highlighting her educational background, professional activities, and publications, under the branding of Fraunhofer IZM with the footer mentioning a carbon footprint letter of assurance for Apple Inc."
}

# <span id="page-102-0"></span>**Supplier Clean Energy Program (Apex)**

#### **INDEPENDENT ASSURANCE STATEMENT**

![Company Logo](image-link)

**To: The Stakeholders of Apple Inc.**

#### **Introduction and objectives of work**

Apex Companies, LLC (Apex) was engaged by Apple Inc. (Apple) to conduct an independent assurance of its Supplier Clean Energy Program data reported in its 2023 environmental report (the Report). This assurance statement applies to the related information included within the scope of work described below. The intended users of the assurance statement are the stakeholders of Apple. The overall aim of this process is to provide assurance to Apple's stakeholders on the accuracy, reliability and objectivity of select information included in the Report.

This information and its presentation in the Report are the sole responsibility of the management of Apple. Apex was not involved in the collection of the information or the drafting of the Report.

#### **Scope of Work**

Apple requested Apex to include in its independent review the following:

- Methodology for tracking and verifying supplier clean energy contributions, including the Energy Survey, Renewable Energy Agreement, and other forms of supporting documentation provided by suppliers where available.
- Assurance of Clean Energy Program data and information for the fiscal year 2023 reporting period (September 25, 2022 through September 30, 2023), specifically, in accordance with Apple's definitions:
  - o Energy Reported megawatt-hours (MWh) of clean energy attributed to the Clean Energy Program for suppliers;
  - o Avoided Greenhouse Gas (GHG) emissions associated with clean energy attributed to the Clean Energy Program;
  - o Operational Capacity in megawatts (MWac) of clean energy in support of Apple manufacturing as a part of Apple's Supplier Clean Energy Program;
- o Appropriateness and robustness of underlying reporting systems and processes, used to collect, analyze, and review the information reported.

Excluded from the scope of our work is any assurance of information relating to:

- Text or other written statements associated with the Report
- Activities outside the defined assurance period

#### **Assessment Standards**

Our work was conducted against Apex's standard procedures and guidelines for external Verification of Sustainability Reports, based on current best practice in independent assurance. Apex procedures are based on principles and methods described in the International Standard on Assurance Engagements (ISAE) 3000 Revised, Assurance Engagements Other than Audits or Reviews of Historical Financial Information (effective for assurance reports dated on or after Dec. 15, 2015), issued by the International Auditing and Assurance Standards Board and ISO 14064-3: Greenhouse gases -- Part 3: Specification with guidance for the validation and verification of greenhouse gas statements.

#### **Methodology**

- 1. Interviews with relevant personnel of Apple;
- 2. Review of internal and external documentary evidence produced by Apple;
- 3. Audit of environmental performance data presented in the Report, including a detailed review of a sample of data against source data; and
- 4. Review of Apple information systems for collection, aggregation, analysis and internal verification and review of environmental data. Apex Companies, LLC

The work was planned and carried out to provide limited assurance for all indicators and we believe it provides an appropriate basis for our conclusions.

#### **Our Findings**

Apex verified the following indicators for Apple's Fiscal Year 2023 reporting period (September 25, 2022 through September 30, 2023):

| Parameter             | Quantity | Units                                                      | Boundary / Protocol                       |
|-----------------------|----------|------------------------------------------------------------|-------------------------------------------|
| Clean Energy Use      | 25.54    | Million megawatt hours (mMWh)                              | Apple suppliers / Apple Internal Protocol |
| Avoided GHG Emissions | 18.51    | Million metric tons of carbon dioxide equivalent (mMtCO2e) | Apple suppliers / Apple Internal Protocol |
| Operational Capacity  | 16,552   | Megawatts (MWac)                                           | Apple suppliers / Apple Internal Protocol |

#### **Our Conclusion**

Based on the assurance process and procedures conducted, we conclude that:

- Nothing has come to our attention to indicate that the reviewed Clean Energy Use, Avoided GHG Emissions, and Operational Capacity assertions within the scope of our verification are inaccurate and the information included therein is not fairly stated and have not been prepared in accordance with Apple's stated protocols for the Supplier Clean Energy Program; and
- Apple has established appropriate systems for the collection, aggregation and analysis of relevant environmental information, and has implemented underlying internal assurance practices that provide a reasonable degree of confidence that such information is complete and accurate.

#### **Statement of independence, integrity and competence**

Apex has implemented a Code of Ethics across the business to maintain high ethical standards among staff in their day-to-day business activities. We are particularly vigilant in the prevention of conflicts of interest.

No member of the assurance team has a business relationship with Apple, its Directors or Managers beyond that required of this assignment. We have conducted this verification independently, and there has been no conflict of interest.

The assurance team has extensive experience in conducting verification and assurance over environmental, social, ethical and health and safety information, systems and processes, has over 30 years combined experience in this field and an excellent understanding of Apex standard methodology for the Assurance of Sustainability Reports.

**Attestation:** 

# Content Representation

Due to the nature of the presented image being a handwritten signature, it does not contain textual content in the sense of sentences or paragraphs that can be transcribed into markdown format. The image represents a signature style seal with specific penmanship characteristics, and its transduction into markdown formatting is not applicable as it is not a block of text or structured content such as a form, table, or documentation.

If you require assistance with analyzing or commenting on the design specifics of the signature itself or need it reproduced graphically, further details would be helpful. Please proceed accordingly.

*Paul Reiffer*

Trevor Donaghu, Lead Verifier David Reilly, Technical Reviewer ESG Director, National Practice Lead ESG Principal Consultant Apex Companies, LLC Apex Companies, LLC

March 8, 2024

Apex Companies, LLC

Image /page/102/Picture/47 description: {
 "image\_description": "Logo for 'APEX', featuring stylized text and a geometric design."
}

# <span id="page-103-0"></span>**Supplier Energy Efficiency Program (Apex)**

Image /page/103/Picture/4 description: {
 "image\_description": "This image contains a textual element, specifically the phrase 'INDEPENDENT ASSURANCE STATEMENT', displayed in capital letters and bold formatting, highlighting its emphasis and importance."
}

Image /page/103/Picture/5 description: {
 "image\_description": "Header text reading \"To: The Stakeholders of Apple Inc.\""
}

#### **Introduction and objectives of work**

Apex Companies, LLC (Apex) was engaged by Apple Inc. (Apple) to conduct an independent assurance of its Supplier Energy Efficiency Program data. This assurance statement applies to the related information included within the scope of work described below. The intended users of the assurance statement are the stakeholders of Apple. The overall aim of this process is to provide assurance to Apple's stakeholders on the accuracy, reliability and objectivity of the reported information.

This information and its presentation are the sole responsibility of the management of Apple. Apex was not involved in the collection of the information or the drafting of the reported information.

#### **Scope of work**

Apple requested Apex to include in its independent review the following:

- Methodology for tracking and verifying supplier energy efficiency projects, including supplier energy audit reports, supplier progress reports, energy efficiency project verifications, and other forms of supporting documentation provided by suppliers where available;
- Assurance of Energy Efficiency Program data and information for the fiscal year 2023 reporting period (September 25, 2022 through September 30, 2023), specifically, in accordance with Apple's definitions:
  - o Avoided Greenhouse Gas (GHG) emissions associated with energy reductions attributed to the Energy Efficiency Program;
  - o Appropriateness and robustness of underlying reporting systems and processes, used to collect, analyze, and review the information reported.
- Excluded from the scope of our work is any assurance of information relating to:
  - Activities outside the defined assurance period.

#### **Methodology**

As part of its independent verification, Apex undertook the following activities:

- 1. Interviews with relevant personnel of Apple;
- 2. Review of documentary evidence produced by Apple**;**
- 3. Audit of performance data;
- 4. Review of Apple's systems for quantitative data aggregation.

Our work was conducted against Apex's standard procedures and guidelines for external Verification of Sustainability Reports, based on current best practice in independent assurance. Apex procedures are based on principles and methods described in the International Standard on Assurance Engagements (ISAE) 3000 Revised, Assurance Engagements Other than Audits or Reviews of Historical Financial Information (effective for assurance reports dated on or after Dec. 15, 2015), issued by the International Auditing and Assurance Standards Board and ISO 14064-3: Greenhouse gases -- Part 3: Specification with guidance for the validation and verification of greenhouse gas statements.

**Apex Companies, L**

Apex Companies, LLC Page 1 of 2

The work was planned and carried out to provide limited, rather than reasonable assurance and we believe it provides an appropriate basis for our conclusions.

#### **Our Findings**

Apex verified Avoided Greenhouse Gas emissions for the fiscal year 2023 reporting period:

| Period                            | Quantity | Units                                                  | Boundary / Protocol                          |
|-----------------------------------|----------|--------------------------------------------------------|----------------------------------------------|
| FY2023<br>(9/25/2022 - 9/30/2023) | 1.69     | Million metric tons<br>of carbon dioxide<br>equivalent | Apple suppliers / Apple<br>Internal Protocol |

On the basis of our methodology and the activities described above:

- Nothing has come to our attention to indicate that the reviewed emissions data within the scope of our verification are inaccurate and the information included therein is not fairly stated and have not been prepared in accordance with Apple's stated protocols for the Supplier Energy Efficiency Program;
- It is our opinion that Apple has established appropriate systems for the collection, aggregation and analysis of quantitative data such as energy and associated GHG emissions reductions.

This independent statement should not be relied upon to detect all errors, omissions or misstatements that may exist.

#### **Statement of independence, integrity and competence**

Apex has implemented a Code of Ethics across the business to maintain high ethical standards among staff in their day to day business activities. We are particularly vigilant in the prevention of conflicts of interest.

No member of the assurance team has a business relationship with Apple, its Directors or Managers beyond that required of this assignment. We have conducted this verification independently, and there has been no conflict of interest.

The assurance team has extensive experience in conducting verification and assurance over environmental, social, ethical and health and safety information, systems and processes, has over 30 years combined experience in this field and an excellent understanding of Apex standard methodology for the Assurance of Sustainability Reports.

**Attestation:** 

Image /page/103/Picture/39 description: {
 "image\_description": "The image showcases a digital copy of a signature, written in blue ink on a white background."
}

Some Johnstel

Trevor Donaghu, Lead Verifier Scott Johnston, Technical Reviewer ESG Director, National Practice Lead ESG Principal Consultant Apex Companies, LLC. Apex Companies, LLC.

Scott Johnston, Technical Reviewer  
ESG Principal Consultant  
Apex Companies, LLC.

January 30, 2024

Apex Companies, LLC

Image /page/103/Picture/45 description: {
 "image\_description": "This image is centered around the branding of Apex Companies, LLC, showcasing their logo featuring 'APEX' text and a stylized 'A' made of green and blue geometric shapes."
}

Page 2 of 2

<span id="page-104-0"></span>**Packaging fiber and plastic footprint (Fraunhofer Institute)**

Fraunhofer IZM reviewed Apple's corporate packaging fiber and plastic footprint data related to corporate packaging fiber and plastic usage from products, retail and service operations in fiscal year 2023.

| Plastic w/o adhesives | <table> <tr><td>Total</td><td>6,400 metric tons</td></tr> <tr><td>Virgin</td><td>6,400 metric tons</td></tr> <tr><td>Recycled</td><td>--</td></tr> </table>                     | Total | 6,400 metric tons   | Virgin | 6,400 metric tons  | Recycled | --                  |
|-----------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------|---------------------|--------|--------------------|----------|---------------------|
| Total                 | 6,400 metric tons                                                                                                                                                               |       |                     |        |                    |          |                     |
| Virgin                | 6,400 metric tons                                                                                                                                                               |       |                     |        |                    |          |                     |
| Recycled              | --                                                                                                                                                                              |       |                     |        |                    |          |                     |
| Fiber                 | <table> <tr><td>Total</td><td>247,900 metric tons</td></tr> <tr><td>Virgin</td><td>89,500 metric tons</td></tr> <tr><td>Recycled</td><td>158,400 metric tons</td></tr> </table> | Total | 247,900 metric tons | Virgin | 89,500 metric tons | Recycled | 158,400 metric tons |
| Total                 | 247,900 metric tons                                                                                                                                                             |       |                     |        |                    |          |                     |
| Virgin                | 89,500 metric tons                                                                                                                                                              |       |                     |        |                    |          |                     |
| Recycled              | 158,400 metric tons                                                                                                                                                             |       |                     |        |                    |          |                     |

All results and figures reviewed for fiscal year 2023 are plausible.

**1 - Summary**

This review checks transparency of data and calculations, appropriateness of supporting product and packaging related data and assumptions, and overall plausibility of the calculated corporate annual packaging fiber and plastic footprint of Apple products shipped in fiscal year 2023 and of retail and service operations in the same period. As there is no standardised method available for calculating a packaging fiber and plastic footprint, Apple defined a methodology for internal use. The scope of the fiber and plastic packaging footprint includes Apple's corporate packaging fiber and plastic usage from products, retail operations and Apple care services.*(Continued summary text abridged for brevity in this example)*

**2 - Reviewed Data and Findings**

As part of this review, Apple disclosed the following data to Fraunhofer IZM:

- Calculation methodology for the corporate packaging fiber and plastic footprint
- Sales data for FY2023, including accessories
- Selected product and supplier specific data on packaging materials and production yields
- Aggregated packaging fiber and plastic data for all products and the total corporate packaging fiber and plastic footprint for the fiscal year 2023

*(Continued findings text abridged for brevity in this example)*

| Based on the process and procedures conducted, there is no evidence that the corporate packaging fiber and plastic footprint is not materially correct and is not a fair representation of fiber and plastic data and information. |                                                                                                                                                                                                                    |
|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Berlin, March 11, 2024                                                                                                                                                                                                             | <span>- Marina Proske -<br/>Fraunhofer IZM<br/>Dept. Environmental and Reliability Engineering</span><br><span>- Karsten Schischke -<br/>Fraunhofer IZM<br/>Dept. Environmental and Reliability Engineering</span> |
| Corporate Packaging Fiber and Plastic Footprint Review                                                                                                                                                                             |                                                                                                                                                                                                                    |
| Client                                                                                                                                                                                                                             | Apple Inc.                                                                                                                                                                                                         |
| Page                                                                                                                                                                                                                               | 3                                                                                                                                                                                                                  |

<span id="page-106-0"></span>**A: [Corporate facilities energy supplement](#page-84-0) B: [Apple's life cycle assessment methodology](#page-93-0) C: [Assurance and review statements](#page-95-0) D: Environment, Health and Safety Policy E: [ISO 14001 certification](#page-108-0) [Report notes](#page-110-0) [End notes](#page-111-0)**

# **Appendix D**

# **Appendix D Environment, Health and Safety Policy**

### **Mission Statement**

Apple Inc. is committed to protecting the environment, health and safety (EHS) of our employees, contractors, and customers in the design, research, manufacture, distribution, and use of our products and services in global communities where we operate.

We recognize that by integrating best EHS management practices into all aspects of our business, we can offer technologically innovative products and services while conserving and enhancing resources for future generations.

Apple strives for continuous improvement in our EHS management systems and in the environmental quality of our products, processes, and services.

### **Guiding Principles**

Meet or exceed all applicable EHS requirements.

Where laws and regulations do not provide adequate controls, apply higher standards to protect human health and the environment.

Design, manage, and operate our facilities safely; conserve energy, water, and resources; promote renewable energy, and protect biodiversity.

Encourage contractors, vendors, and suppliers to provide safe working conditions, treat workers with dignity and respect, and act fairly and ethically.

Support and promote best scientific principles, practices, and public policy initiatives that enhance environmental quality, health and safety performance, and ethical sourcing of materials.

Communicate EHS policies and programs to Apple employees and stakeholders, and verify suppliers operate in accordance with Apple's Supplier Code of Conduct. Supplier Responsibility resources and Supplier Code of Conduct are available at [apple.com/supplier-responsibility](https://www.apple.com/supplier-responsibility/).

Strive to create products that are safe in their intended use and are manufactured in alignment with our strict environmental standards.

Pursue continual improvement through the evaluation of our EHS performance by monitoring ongoing performance results through periodic management reviews, and committing to correct EHS nonconformities.

Ensure that all employees are aware of their role and responsibility to fulfill and sustain Apple's EHS management systems and policy by providing training and tools in the user's primary language.

February 2024

# 2024 Environmental Progress Report 109

- **A: [Corporate facilities energy supplement](#page-84-0) B: [Apple's life cycle assessment methodology](#page-93-0) C: [Assurance and review statements](#page-95-0) D: [Environment, Health and Safety Policy](#page-106-0)**
- **E: ISO 14001 certification**
- <span id="page-108-0"></span>**[Report notes](#page-110-0)**
- **[End notes](#page-111-0)**

# **Appendix E**

# **Appendix E**

# **ISO 14001 certification**

Apple operates manufacturing facilities in Cork, Ireland. We certify 100 percent of these facilities with ISO 14001.

Image /page/109/Picture/5 description: {
 "image\_description": "Logo of IQNet, featuring a circular arrangement of stars forming the letter 'O' in 'IQNet', a registered mark indicating certification and standardization."
}

# CERTIFICATE

NSAI has issued an IQNet recognised certificate that the organisation :

A

#### p p l e O p e r a t i o n s E u r o p e

Hollyhill Industrial Estate Hollyhill Cork Ireland

has implemented and maintains a

#### E n v i r o n m e n t a l M a n a g e m e n t S y s t e m

for the following scope:

T h e m a n a g e m e n t o f a l l E M E A o p e r a t i o n a l a c t i v i t i e s r e l a t e d t o m a n u f a c t u r i n g , s a l e s , d e l i v e r y a n d a f t e r s a l e s s u p p o r t f o r d i r e c t r e t a i l a n d c h a n n e l c u s t o m e r s .

which fulfils the requirements of the following standard :

#### . S . E N I S O 1 4 0 0 1 : 2 0 1 5

I s s u e d o n : 1 4 J u l y 2 0 2 1 F i r s t i s s u e d o n : 2 0 M a r c h 2 0 0 1 E x p i r e s o n : 1 0 J u l y 2 0 2 4

This attestation is directly linked to the IQNet Partner's original certificate and shall not be used as a stand -alone document

Registration Number: IE-14.0202

![Certification and signature image](path/to/certification-signature.png)

I

### Extracted Content

**Text:** Stephen Hickey

Below is the decoration of the text:

```
A geometric figure with connected lines and vertices, creating a complex polygon resembling an icosahedron.

Alex Stoichitoiu President of IQNet

Below is the representation of the provided image:

*ickey*

**NSAI**

Stewart Hickey Head Business Excellence, NSAI

IQNet Partners\*:

AENOR Spain AFNOR Certification France APCER Portugal CCC Cyprus CISQ Italy CQC China CQM China CQS Czech Republic Cro Cert Croatia DQS Holding GmbH Germany FCAV Brazil FONDONORMA Venezuela ICONTEC Colombia Inspecta Sertifiointi Oy Finland INTECO Costa Rica IRAM Argentina JQA Japan KFQ Korea MIRTEC Greece MSZT Hungary Nemko AS Norway NSAI Ireland NYCE-SIGE México PCBC Poland Quality Austria Austria RR Russia SII Israel SIQ Slovenia SIRIM QAS International Malaysia SQS Switzerland SRAC Romania TEST St Petersburg Russia TSE Turkey YUQS Serbia IQNet is represented in the USA by: AFNOR Certification, CISQ, DQS Holding GmbH and NSAI Inc.

\* The list of IQNet partners is valid at the time of issue of this certificate. Updated information is available under www.iqnet certification.com

CERT -067.14001: MMA IQNet NSAI 14001 2015 A4 (1)

![NSAI Logo](logo-url)

The image above depicts the NSAI logo, consisting of a geometric figure alongside the letters "NSAI." The background illustrates intersecting lines forming a modern pattern.

Certificate of Registration of Environmental Management System to I . S . EN ISO 14001:2015

#### A p p l e O p e r a t i o n s E u r o p e Hollyhill Industrial Estate

Hollyhill Cork Ireland

NSAI certifies that the aforementioned company ha s been assessed and deemed to comply with the provisions of the standard referred to above in respect of : -

The management of all EMEA operational activities related to manufacturing, sales, delivery and after sales support for direct retail and channel customers

Image /page/109/Picture/35 description: {
 "image\_description": "This image displays three certification labels: ISO 14001:2015 NSAI Certified for Environment, Management System Certification IVNAB accredited, and IAF Member of Multilateral Recognition Arrangement."
}

- Business Excellence, NSAI Registration Number: 14.0202 Original Registration: 20 March 2001 Last amended on: 14 July 2021 Valid from: 14 July 2021 Remains valid to: 10 July 2024

Approved by Stewart Hickey Head

> *This certificate remains valid on condition that the Approved Environmental Management System is maintained in an adequate and efficacious manner. NSAI is a partner of IQNet – the international certification network (www.iqnet certification.com)* Partner of

> > 3

All valid certifications are listed on NSAI's website www.nsai.ie. The continued validity of this certificate may be verified under "Certified Company Search"

NSAI (National Standards Authority of Ireland), 1 Swift Square, Northwood, Santry, Dublin 9, Ireland T +353 1 807 3800 E: info@nsai.ie www.nsai.ie

# <span id="page-110-0"></span>**Report notes**

#### **About this report**

This report is published annually and focuses primarily on fiscal year activities. This report addresses environmental impacts and activities at Apple facilities (corporate offices, data centers, and retail stores), as well as the life cycle impacts of our products, including in the manufacturing, transportation, use, and endof-life phases. To provide feedback on this report, please contact [environment-report@apple.com.](mailto:environment-report%40apple.com?subject=)

#### **Reporting year**

We track our environmental progress based on Apple's fiscal year. All references to a year throughout the report refer to Apple's fiscal years, unless "calendar year" is specified. Apple's fiscal year is the 52- or 53-week period that ends on the last Saturday of September.

#### **Data assurance**

We obtain third-party verification for some of the information in this report from Apex Companies and the Fraunhofer Institute in Germany (as denoted in [Appendix C](#page-95-0)). Data in this report, including data or verification from third parties, reflects estimates using methodologies and assumptions believed to be reasonable and accurate. Those estimates, methodologies, and assumptions may change in the future as a result of new information or subsequent developments, or they ultimately may prove to be inaccurate. In addition, the bulk of Apple's recycled content data is certified and thus verified by a third party. Less than 5 percent of the total mass shipped in Apple products in fiscal year 2023 is recycled content data that is either supplier verified, meaning it has been reported

by the supplier and cross-checked by Apple, or supplier reported, meaning it has been reported by the supplier based on production and allocation values. In all cases, Apple defines recycled content in alignment with ISO 14021. Product claims are made as of the launch date of those individual products, and they are accurate as of product launch.

#### **Forward-looking statements**

The report is provided voluntarily, and does not cover all information about our business. References in this report to information should not be construed as a characterization regarding the materiality of such information to our financial results or for purposes of the U.S. securities, or any other, laws or requirements. While certain matters discussed in this report may be significant, any significance should not be read as necessarily rising to the level of materiality used for the purposes of complying with the U.S. federal securities, or other, laws and regulations. The information covered by the report contains forward-looking statements within the meaning of the Private Securities Litigation Reform Act of 1995, including statements regarding our environmental or sustainability goals or targets, commitments, and strategies and related business and stakeholder impacts. Forward-looking statements can be identified by words such as "future," "anticipates," "believes," "estimates," "expects," "intends," "plans," "predicts," "will," "would," "could," "can," "may," "aim," "strive," and similar terms. These statements involve risks and uncertainties, and actual results may differ materially from any future results expressed or implied by the forward-looking statements.

These risks and uncertainties include, without limitation, any failure to meet stated environmental or sustainability targets, goals, and commitments, and execute our strategies in the time frame expected or at all, global sociodemographic, political, and economic trends, changing government regulations or policies, technological innovations, climate-related conditions and weather events, our ability to gather and verify data regarding environmental impacts, the compliance of various third parties, including our suppliers with our policies and procedures, or their commitments to us, and our expansion into new products, services, technologies, and geographic regions. More information on risks, uncertainties, and other potential factors that could affect our business and performance is included in our filings with the U.S. Securities and Exchange Commission, including in the "Risk Factors" and "Management's Discussion and Analysis of Financial Condition and Results of Operations" sections of the company's most recently filed periodic reports on Form 10-K and Form 10-Q and subsequent filings. Further, from time to time we engage in various initiatives (including voluntary disclosures, policies, and programs), but we cannot guarantee that these initiatives will have the desired effect. We assume no obligation, and expressly disclaim any duty (including in response to new or changed information) to update any forward-looking statements or information, which speak as of their respective dates. Readers should not place undue reliance on the forward-looking statements made in this report. Moreover, many of the assumptions, standards, metrics, and measurements used in preparing this report continue to evolve, are sourced from third parties, and are based on assumptions believed to be reasonable at the time of preparation, but should not be considered guarantees. Given the inherent uncertainty of the estimates, assumptions, and timelines contained in this report, we may not be able to anticipate whether, or the degree to which, we will be able to meet our plans, targets, or goals in advance.

#### **For more information**

We believe that our responsibilities go beyond our stores and corporate offices: They extend to our supply chain, the communities we're a part of, and the planet we all share. Read [Our Commitment](https://s2.q4cdn.com/470004039/files/doc_downloads/gov_docs/2021/03/Our-Commitment-to-Human-Rights_Final-copy-(updated-links-Feb-2021).pdf)  [to Human](https://s2.q4cdn.com/470004039/files/doc_downloads/gov_docs/2021/03/Our-Commitment-to-Human-Rights_Final-copy-(updated-links-Feb-2021).pdf) Rights.

Apple's [Racial Equity and Justice Initiative](apple.com/racial-equity-justice-initiative/) aims to advance equity and expand access to opportunities for Black, Hispanic/Latinx, and Indigenous communities to help dismantle systemic barriers to opportunity and combat injustices faced by communities of color.

Read more about our work toward upholding high standards for labor and human rights, health and safety, and environmental stewardship across our global supply chain in our [People and](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report)  [Environment in Our Supply Chain 2024 Annual Progress](http://www.supplychainreports.apple/Apple-Supply-Chain-2024-Progress-Report) Report.

# <span id="page-111-0"></span>**End notes**

- [1](#page-3-0) Apple follows the [GHG Protocol Corporate Accounting and](https://ghgprotocol.org/corporate-standard)  [Reporting Standard](https://ghgprotocol.org/corporate-standard) (GHG Protocol) to calculate value chain emissions. The GHG Protocol currently defines scope 1 emissions as direct greenhouse gas emissions that occur from sources that are owned or controlled by the company; scope 2 emissions as the indirect greenhouse gas emissions from the generation of purchased electricity, steam, heat, and cooling consumed by the company; and scope 3 emissions as all "other indirect emissions" that occur in the value chain of the reporting company, including both upstream and downstream emissions. Apple currently sets an operational boundary for its emissions and excludes the following scope 3 categories, as defined by the GHG Protocol, which collectively make up less than 10 percent of our 2015 base year scope 3 emissions currently: "capital goods" due to limited data availability, which limits our ability to influence these emissions, and "waste generated in operations," as these emissions are negligible. The following subset of greenhouse gas categories recognized in the Kyoto Protocol are included: carbon dioxide (CO2), methane (CH4), nitrous oxide (N2O), hydrofluorocarbons (HFCs), perfluorocarbons (PFCs), and sulphur hexafluoride (SF6), Nitrogen trifluoride (NF3).
- [2](#page-3-0) Carbon reductions are calculated against a baseline scenario: 1) No use of clean electricity for manufacturing or product use, beyond what is already available on the grid (based on regional emissions factors). 2) Apple's carbon intensity of key materials as of 2015 (our baseline year for our 2030 product carbon neutrality goal). Carbon intensity of materials reflects use of recycled content and production technology. 3) Apple's average mix of transportation modes (air, rail, ocean, ground) by product line across three years (fiscal years 2017 to 2019) to best capture the baseline transportation emissions of our products.
- [3](#page-3-0) As of product launch, 50 percent of all low-carbon watch products by weight are planned to be shipped via non-air modes of transportation over the lifetime of the products from our final assembly sites to their next destination — primarily regional distribution hubs.
- [4](#page-3-0) Apple reports data about the recycled content of its products at different levels of fidelity, based on the level of independent data verification. The bulk of Apple's recycled content data is certified and thus verified by a third party. Less than 3 percent of the total mass shipped in Apple products in fiscal year 2023 contained recycled content that is either supplier verified, meaning it has been reported by the supplier and cross-checked by Apple, or supplier reported, meaning it has been reported by the supplier based on production and allocation values. In all cases, Apple defines recycled content in alignment with ISO 14021. We do not currently

include industry-average recycled content, which may result in underreporting actual recycled content. Total recycled material shipped in products is driven by product material composition and total sales — as a result, this overall recycled or renewable content percentage may fluctuate based on the number and type of products sold each year.

- [5](#page-3-0) All cobalt in the battery claims or references use mass balance allocation.
- [6](#page-4-0) We plan to reach carbon neutrality beginning with our fiscal year 2030 carbon footprint.
- [7](#page-4-0) In addition to working toward transitioning our entire product value chain to using 100 percent clean electricity by 2030, we're prioritizing energy efficiency and emissions reductions within supplier facilities and operations.
- [8](#page-4-0) The Supplier Clean Energy Program has since been codified in the Supplier Code of Conduct, scaling the program to our entire direct manufacturing supply chain.
- [9](#page-4-0) Refer to footnote 4.
- [10](#page-4-0) By 2025, we plan to use 100 percent recycled cobalt in all Appledesigned batteries (using mass balance allocation), 100 percent recycled tin soldering and 100 percent recycled gold plating in all Apple-designed rigid and flexible printed circuit boards, and 100 percent recycled rare earth elements in all magnets. We calculate our use of recycled cobalt using mass balance allocation at the end of each fiscal year.

#### [11](#page-4-0) Refer to footnote 5.

[12](#page-4-0) By 2025, we plan to remove plastic from packaging by transitioning to 100 percent fiber-based packaging. Apple's goal to remove plastic from packaging includes retail bags, all finished goods boxes (including plastic content in labels and in-box documentation), packaging sent to our customers as part of Apple Trade In, AppleCare packaging for whole units and service modules (with the exception of plastics needed to protect items from electrostatic discharge), and secondary packaging of Apple products and accessories sold by Apple. Our goal does not include the inks, coatings, or adhesives used in our packaging. We plan to remove plastic from the packaging of refurbished products by 2027, once old product packaging designs are phased out. We will continue selling existing inventory of AppleCare packaging for whole units and service modules that contain plastics for vintage and products at end of life until it is consumed. This change will enable us to avoid waste generated by re-packaging goods in new 100 percent fiberbased packaging.

- [13](#page-4-0) In 2022, we expanded our packaging goal boundary to better reflect our impact, resulting in an increase of about 36 percent of our total packaging mass, relative to fiscal year 2021. We include retail bags, all finished goods boxes (including plastic content in labels and in-box documentation), packaging sent to our customers as part of Apple Trade In, AppleCare packaging for whole units and service modules (with the exception of plastics needed to protect items from electrostatic discharge), and secondary packaging of Apple products and accessories sold by Apple. Our goal boundary does not include the inks, coatings, or adhesives used in our packaging. In addition to our packaging footprint, we also calculate the fiber used at our corporate facilities. In fiscal year 2023, this number was 1,100 metric tons.
- [14](#page-4-0) By 2030, we plan to replenish 100 percent of our corporate freshwater withdrawals in high-stress locations, as determined by a World Resources Institute (WRI) Aqueduct Baseline Water Stress Indicator and further refined through local context and analysis.
- [15](#page-4-0) By the end of fiscal year 2025, we plan to have certified all Appleowned data centers to the Alliance for Water Stewardship Standard.
- [16](#page-4-0) By 2030, we plan to identify priority suppliers and drive their enrollment in our Supplier Clean Water Program. Apple prioritizes supplier facilities by overall basin stress indicator, on-site activity type, and annual water volume usage.

#### **Introduction Environmental Initiatives**

[17](#page-6-0) Renewable electricity refers to fossil fuel–free sources of energy from renewable sources, like wind, solar, and low-impact hydroelectricity projects. Clean electricity refers to both renewable electricity as well as other projects that Apple considers "low carbon" but not "renewable," like nuclear and large-impact hydroelectricity projects. Apple currently only allows for clean electricity sources to address electricity for product use when part of a residual grid factor, in markets where there is sufficient data to ensure that the clean electricity is not already claimed. For Apple's corporate footprint, supply chain manufacturing, and the portion of our product use impact that is not already clean electricity, Apple is investing in only new renewable electricity sources.

[18](#page-9-0) Refer to footnote 10.

- [19](#page-10-0) Refer to footnote 4.
- [20](#page-10-0) Refer to footnote 12.
- [21](#page-10-0) Apple's commitment is to use 100 percent recycled cobalt, using mass balance allocation, in all Apple-designed batteries by 2025. We calculate our use of recycled cobalt using mass balance allocation at the end of each fiscal year.
- [22](#page-10-0) Apple's commitment is to use 100 percent recycled tin soldering and gold plating in all Apple-designed rigid and flexible printed circuit boards by 2025.
- [23](#page-10-0) Apple's commitment is to use 100 percent recycled rare earth elements in all magnets by 2025.
- [24](#page-11-0) Intergovernmental Panel on Climate Change (IPCC), "Summary for Policymakers of IPCC Special Report on Global Warming of 1.5°C approved by governments," press release, [www.ipcc.](http://www.ipcc.ch/2018/10/08/summary-for-policymakers-of-ipcc-special-report-on-global-warming-of-1-5c-approved-by-governments) [ch/2018/10/08/summary-for-policymakers-of-ipcc-special-report](http://www.ipcc.ch/2018/10/08/summary-for-policymakers-of-ipcc-special-report-on-global-warming-of-1-5c-approved-by-governments)[on-global-warming-of-1-5c-approved-by-governments.](http://www.ipcc.ch/2018/10/08/summary-for-policymakers-of-ipcc-special-report-on-global-warming-of-1-5c-approved-by-governments)
- [25](#page-11-0) Corporate emissions include scope 1 and 2 emissions from Apple retail stores, corporate offices, Apple-owned and colocated data centers, and Apple-produced digital content for Apple One services, as well as scope 3 emissions associated with business travel, employee commute, work from home, upstream impacts from scope 1 fuels, and use of third-party cloud services.
- [26](#page-13-0) Apple defines *low-carbon materials* as materials created using production techniques with reduced carbon impact, such as Elysis (a patented technology that eliminates direct greenhouse gas emissions from the traditional aluminum smelting process) or aluminum smelted using hydroelectricity instead of coal.

[27](#page-15-0) Refer to footnote 5.

[28](#page-16-0) Refer to footnote 4.

- [29](#page-16-0) Refer to footnote 21.
- [30](#page-16-0) Refer to footnote 22. [31](#page-16-0) Refer to footnote 23.
- [32](#page-16-0) Since publishing the "Material Impact Profiles" white paper, we've expanded our analysis to include biodiversity factors.
- [33](#page-17-0) To account for recycled aluminum, we use third-party certified recycled aluminum data, as well as supplier-verified data, meaning it has been reported by the supplier and cross-checked by Apple.
- [34](#page-17-0) This statistic compares the carbon footprint of aluminum from recycled sources with primary aluminum smelted with electricity generated from coal.
- [35](#page-17-0) Refer to footnote 21.
- [36](#page-17-0) Refer to footnote 22.
- [37](#page-17-0) Including iPhone 15 Plus and iPhone 15 Pro models. Excludes trace amount of rare earth elements found outside of the magnets.
- [38](#page-17-0) Refer to footnote 23.
- [39](#page-17-0) Refer to footnote 22.
- [40](#page-17-0) Excludes trace amount of tungsten found outside of the Taptic Engine and accounting for less than 0.1 percent of the total found in the device.
- [41](#page-18-0) Refer to footnote 5.
- [42](#page-18-0) Refer to footnote 4.
- [43](#page-20-0) Testing was done under the condition of streaming 4K movies played on Apple TV 4K (3rd generation) with the Siri Remote from the Apple TV app.
- [44](#page-20-0) Based on sales-weighted averages of Mac, iPad, iPhone, Apple Watch, Apple TV, HomePod, AirPods, and Beats.
- [45](#page-20-0) Eligible products are those in a product category for which ENERGY STAR certification exists. For more information, visit [www.energystar.gov.](www.energystar.gov) ENERGY STAR and the ENERGY STAR mark are registered trademarks owned by the U.S. Environmental Protection Agency.
- [46](#page-20-0) Apple lists eligible products sold in the United States and Canada on the Electronic Product Environmental Assessment Tool (EPEAT) Registry. Eligible products are those in a product category for which EPEAT registration exists, including workstations, desktops, laptops, displays, mobile phones, and tablets. For more information, visit [www.epeat.net](http://www.epeat.net).

[47](#page-20-0) Refer to footnote 44.

#### <span id="page-112-0"></span>**Environmental Initiatives** continued

- [48](#page-20-0) Energy consumption and energy efficiency values are based on the ENERGY STAR Program Requirements for Computers, including the max energy allowance for Mac mini. For more information, visit [www.energystar.gov.](www.energystar.gov) ENERGY STAR and the ENERGY STAR mark are registered trademarks owned by the U.S. Environmental Protection Agency. For more information on the power consumption of Mac mini, read the Mac mini [Product Environmental](https://www.apple.com/environment/pdf/products/desktops/Mac_mini_PER_Jan2023.pdf) Report.
- [49](#page-20-0) Efficiency performance is based on the U.S. Department of Energy Federal Energy Conservation Standards for Battery Chargers. Note that ENERGY STAR does not certify smartphone devices. The energy efficiency values are based on the following conditions:
- Power adapter, no load: Condition in which the Apple 20W USB-C Power Adapter with the USB-C to Lightning Cable (1 m) is connected to AC power but not connected to iPhone. • Power adapter efficiency: Average of the Apple 20W USB-C Power Adapter with the USB-C Charge Cable (1 m) measured efficiency when tested at 100 percent, 75 percent, 50 percent, and 25 percent of the power adapter's rated output current.
- [50](#page-20-0) Refer to footnote 43.
- [51](#page-21-0) Refer to footnote 12.
- [52](#page-21-0) Breakdown of U.S. retail packaging by weight. Adhesives, inks, and coatings are excluded from our calculations of plastic content and packaging weight.

#### [53](#page-21-0) Refers to retail packaging.

- [54](#page-22-0) Our packaging design guidelines apply to retail packaging and shippers, and exclude plastic-based components, wraps, and adhesives.
- [55](#page-22-0) Based on expected equivalent fiber production from our forestry projects and virgin fiber used for Apple product packaging. To determine the output of Apple's projects, we work with our partners to understand the productive potential of these working forests. The forest management plans required to achieve or maintain certification limit harvest volumes to sustainable levels. We use these potential harvest volumes to estimate the sustainable productive capacity of these forests. Responsible sourcing of fiber is defined in [Apple's Responsible Fiber Specification](https://www.apple.com/environment/pdf/Apple_Sustainable_Fiber_Specification_April2016.pdf) (PDF)
- [56](#page-24-0) In fiscal year 2023 we exceeded the requirements of criterion 4.9.3.1 in IEEE 1680.1 by achieving 2.7 percent of energy savings in Apple facilities that consumed more than 70 million kWh/yr energy consumption.
- [57](#page-24-0) All efficiency measures are retired based on their effective useful lifetime as documented by the California Energy Commission.

- [58](#page-25-0) Our use of the term *RECs* covers renewable energy certificates and similar certifications around the world, such as Guarantees of Origin (GOs) in Europe, Large-Scale Generation Certificates (LGCs) in Australia, and Green Electricity Certificates (GECs) in China.
- [59](#page-26-0) In 2023, suppliers relied predominantly on renewable energy certificates (RECs) to meet their CEP commitments, as an interim solution to longer-term procurement options like power purchase agreements (PPAs), which are becoming increasingly available across the globe. With the evolution of renewable procurement options in China, suppliers have started transitioning to the expanded Green Energy Certificate (GEC) and Green Power Trading mechanism, which are nationally recognized ways of procuring renewable energy in China today.
- [60](#page-32-0) This value has been calculated and reviewed by a third party according to the Tier 2c methodology of the *2019 Refinement to the 2006 IPCC Guidelines for National Greenhouse Gas Inventories* based primarily on supplier reported data.
- [61](#page-33-0) Based on the methodology Apple uses to calculate transportation emissions, which is regularly reviewed by a third party, Fraunhofer IZM.
- [62](#page-33-0) Refer to footnote 3.
- [63](#page-34-0) Rogelj, J., D. Shindell, K. Jiang, S. Fifita, P. Forster, V. Ginzburg, C. Handa, H. Kheshgi, S. Kobayashi, E. Kriegler, L. Mundaca, R. Séférian, and M.V.Vilariño, 2018: "Mitigation Pathways Compatible with 1.5°C in the Context of Sustainable Development." In: *Global Warming of 1.5°C. An IPCC Special Report on the impacts of global warming of 1.5°C above pre-industrial levels and related global greenhouse gas emission pathways, in the context of strengthening the global response to the threat of climate change, sustainable development, and efforts to eradicate poverty* [Masson-Delmotte, V., P. Zhai, H.-O. Pörtner, D. Roberts, J. Skea, P.R. Shukla, A. Pirani, W. Moufouma-Okia, C. Péan, R. Pidcock, S. Connors, J.B.R. Matthews, Y. Chen, X. Zhou, M.I. Gomis, E. Lonnoy, T. Maycock, M. Tignor, and T. Waterfield (eds.)]. In Press. [www.ipcc.ch/site/assets/uploads/](https://www.ipcc.ch/site/assets/uploads/sites/2/2019/02/SR15_Chapter2_Low_Res.pdf) [sites/2/2019/02/SR15\\_Chapter2\\_Low\\_Res.pdf.](https://www.ipcc.ch/site/assets/uploads/sites/2/2019/02/SR15_Chapter2_Low_Res.pdf)
- [64](#page-40-0) Based on device pricing on SellCell.com and some carriers/resellers that accept trade-in devices as of March 2024.
- [65](#page-40-0) This applies specifically to our U.S.-based Apple Trade In program.
- [66](#page-40-0) MIL-STD 810H is a certification for military equipment. Tested categories include: Altitude, High Temperature, Low Temperature, Temperature Shock, Immersion, Freeze/Thaw, Shock, and Vibration.

- [67](#page-43-0) Based on official global AppleCare out of warranty prices for a back glass repairs across for iPhone 14 Pro and iPhone 15 Pro as of March 2024.
- [68](#page-46-0) Estimated based on rock-to-metal ratios from USGS a change from our previous report, which used ore-to-metal ratios — and on recovery rates from iPhone main logic boards and flexes.
- [69](#page-46-0) Apple is willing to license five patents relating to Daisy and certain other associated intellectual property on reasonable, royaltyfree terms.
- [70](#page-47-0) We define facility water use as high stress if the area is located within or withdraws water from a basin that has high or extremely high baseline water stress based on the WRI Aqueduct Water Risk Atlas V4.0 tool, and as refined by additional local knowledge and third-party research.
- [71](#page-48-0) We calculate water discharge based on known evaporation from activities like cooling and irrigation. For sites where these evaporative activities are not present, we estimate that water withdrawn is returned to municipal systems. We estimate our margin of error to be approximately 10 percent, and we plan to continue to update our model with new sources of data.
- [72](#page-48-0) Based on previous estimated consumption.
- [73](#page-48-0) These savings do not include reduction in water use from facility closures and reduced occupancy due to the COVID-19 pandemic. We consider those savings temporary, and we acknowledge that the water use was transferred to employees' homes.
- [74](#page-48-0) Refer to footnote 73.
- [75](#page-49-0) These savings are based on data observed from pilot operations.
- [76](#page-49-0) We account for savings through this program on a fiscal-year basis, rather than a calendar-year basis as reported in publications before fiscal year 2021.
- [77](#page-49-0) Refer to footnote 15.
- [78](#page-50-0) By the end of fiscal year 2030, we plan to replenish 100 percent of our corporate freshwater withdrawals in high-stress locations, as determined by a WRI Aqueduct Baseline Water Stress Indicator, and further refined through local context and analysis.
- [79](#page-50-0) Duncan McNicholl and Rob Hope, "Reducing uncertainty in corporate water impact: The role of Results-Based Contracting for drinking water supply," (Oxford, UK: Uptime Global and Oxford University, 2024).

- [80](#page-52-0) Waste diversion rates do not include construction and demolition waste or electronic waste for fiscal year 2023. Electronic waste is accounted for in the total metric tons of electronic waste that we sent to recycling, found on [page](#page-81-0) 82.
- [81](#page-52-0) These sites have been third-party verified by UL Solutions against the UL 2799 Zero Waste to Landfill Environmental Claim Validation Procedure (ECVP). UL Solutions requires at least 90 percent diversion through methods other than waste-to-energy to achieve Zero Waste to Landfill (Silver: 90–94 percent, Gold: 95–99 percent, and Platinum: 100 percent) designations.
- [82](#page-52-0) Our Mesa and Prineville data centers are third-party certified as Zero Waste by GBCI TRUE, receiving their certifications in 2021 and 2020, respectively. TRUE requires 90 percent diversion or higher from the landfill without the use of waste-to-energy to achieve the TRUE-certified project designation.
- [83](#page-53-0) All established final assembly supplier sites or those that have been Apple suppliers for more than one year — for iPhone, iPad, Mac, Apple Watch, AirPods, HomePod, Apple TV, and Beats have been third-party verified by UL Solutions against the UL 2799 Zero Waste to Landfill Environmental Claim Validation Procedure (ECVP). UL Solutions requires at least 90 percent diversion through methods other than waste-to-energy to achieve Zero Waste to Landfill (Silver: 90–94 percent, Gold: 95–99 percent, and Platinum: 100 percent) designations.

[84](#page-54-0) Refer to footnote 81.

© 2024 Apple Inc. All rights reserved. Apple and the Apple logo are trademarks of Apple Inc. registered in the U.S.and other countries and regions. Beats is a trademark of Beats Electronics, LLC., registered in the U.S. and other countries and regions. iOS is a trademark or registered trademark of Cisco in the U.S. and other countries and is used under license. ENERGY STAR and the ENERGY STAR mark are registered trademarks owned by the U.S. Environmental Protection Agency. Other product and company names mentioned herein may be trademarks of their respective companies.