Image /page/0/Picture/0 description: {
 "image\_description": "Logo of the Construction Industry Council, featuring a stylized geometric representation accompanied by textual elements in English and Chinese."
}

# **CONSTRUCTION INDUSTRY COUNCIL**

# **CIC GREEN PRODUCT CERTIFICATION**

# **GLAZING**

(Version 1.0a)

*Assessment Standard*

#### **Copyright © 2020 Construction Industry Council**

All rights reserved. No part of this document may be reproduced, stored in a retrieval system or transmitted, in any form or by any means, whether electronic or mechanical, including photocopying and recording, without the written permission of the Construction Industry Council. If there is any inconsistency or ambiguity between the English version and the Chinese version, the English version shall prevail.

# **GLAZING**

## *Summary of Assessment Criteria*

#### **CORE CRITERIA**

| Criteria                              | Requirements                                                                                                                                                                                                                                                                                                                                                              | Verification                                                                    | Points     | Index          |                   |
|---------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------|------------|----------------|-------------------|
| Product Information                   | Provide the following product information on the packaging of the product and/or company website:<br>— Instructions on the installation, adjustment, and protection of the product<br>— U-value, solar heat gain coefficient, and visible light transmittance<br>— Recommended maintenance for the product<br>— Details related to the end of service life of the product | Documentation related to the label and relevant information                     | 5          | 4.1.3 (page 4) |                   |
| Thermal Insulation Performance        | Single glazing:<br>— U-value: ≤ 5.8 W/m $^2$ K [5 basic]<br>— U-value: ≤ 3.7 W/m $^2$ K (+5 bonus)<br>Double or triple glazing:<br>— U-value: ≤ 3.3 W/m $^2$ K [5 basic]<br>— U-value: ≤ 2.3 W/m $^2$ K (+5 bonus)                                                                                                                                                        | Laboratory test report(s) on the U-value of the entire glazing product          | 5 + 5      | 4.2.1 (page 6) |                   |
| Shading Coefficient                   | The performance of the product shall meet:<br>— Shading coefficient:<br>15 [basic]: ≤ 0.90<br>+5 (bonus): ≤ 0.60<br>+10 (bonus): ≤ 0.40<br>— Solar heat gain coefficient:<br>15 [basic]: ≤ 0.78<br>+5 (bonus): ≤ 0.52<br>+10 (bonus): ≤ 0.35                                                                                                                              | Laboratory test report(s) on shading coefficient or solar heat gain coefficient | 15 + 5/+10 | 4.2.2 (page 6) |                   |
| Visible Light Transmittance           | The performance of the product shall meet:<br>— VLT:<br>10 [basic]: ≥ 50%<br>+5 (bonus): ≥ 70%                                                                                                                                                                                                                                                                            | Laboratory test report(s) on daylight transmittance                             | 10 + 5     | 4.2.3 (page 7) |                   |
| External Reflectance                  | — External reflectance: ≤ 20%                                                                                                                                                                                                                                                                                                                                             | Laboratory test report(s) on external reflectance                               | 10         | 4.2.4 (page 7) |                   |
| Energy Management<br>in Manufacturing | The manufacturer of the product shall have effective energy management policies and procedures and / or an energy management programme, including:<br>• Initiatives taken to reduce energy use and improve energy efficiency<br>• Initiatives or requirements for suppliers or contract manufacturers                                                                     | Detailed plan(s) of energy consumption and reduction programme                  | 5          |                | 4.2.5<br>(Page 7) |
|                                       |                                                                                                                                                                                                                                                                                                                                                                           | Subtotal:                                                                       | 50         | +20            |                   |

#### **NON-CORE CRITERIA**

| Criteria                              | Requirements                                                                                                                                                                                                                                                                                                           | Verification                                                                                                                                     | Points<br>+Bonus | Index             |
|---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------------------|
| Environmental<br>Management<br>System | o<br>Valid certification of ISO14001 or the EU<br>Eco-Management and Audit Scheme<br>(EMAS)                                                                                                                                                                                                                            | ISO14001 or EMAS<br>certificate issued by<br>accredited certification<br>body                                                                    | +5               | 4.1.2<br>(page 4) |
| Packaging<br>Requirements             | o<br>Product packaging shall not contain<br>halogenated plastics<br>o<br>All packaging materials shall<br>be either<br>comprised of 100% recycled material or<br>readily recyclable                                                                                                                                    | Documentation on the<br>packaging materials<br>used                                                                                              | +5               | 4.1.4<br>(page 5) |
| Extra<br>Environmental<br>Features    | The technology adopted enable the glazing<br>product<br>to reduce resources used in:<br>o<br>Maintenance, e.g. self-cleaning glass, etc.<br>Or<br>o<br>Energy, such as lighting, e.g. instantly<br>reactive glazing technology that changes the<br>glass from clear<br>to a dark blue tint, self<br>tinted glass, etc. | Documentation<br>describing the extra<br>environmental features<br>adopted as well as the<br>product functions<br>generated by the<br>technology | +5               | 4.1.5<br>(page 5) |
| Serviceability                        | o<br>Product shall fulfil the quality, safety, air<br>leakage and other functional requirements<br>o<br>Manufacturer shall provide a 10-year<br>guarantee to the product                                                                                                                                               | Laboratory test<br>report(s)<br>for all relevant quality<br>and performance tests                                                                | +5               | 4.1.1<br>(page 3) |

Version 1.0a

| Hazardous Substances | The following requirements are applicable to all glazing products:<br>Product shall NOT contain:  Substances listed in IARC Group 1, 2A and 2B ≥ 0.1% by weight of the product Organotin compounds Phthalates or polybrominated diphenylethers Substances classified as harmful, toxic or very toxic in accordance with European Union Directive 2001/59/EC          The following requirements are applicable to tinted glazing product only:<br>Product shall not contain toxic heavy metals, or ingredients containing heavy metals, including lead (Pb), cadmium (Cd), mercury (Hg), chromium (Cr), arsenic (As), selenium (Se), antimony (Sb), and cobalt (Co).        The following requirements are applicable to double/triple glazing product only:<br>Product shall not contain chlorinated / brominated paraffins Filler gases used in the insulating units: $≤ 5$ in $GWP_{100}$ | Laboratory test report(s), MSDS, self-declaration letter and production documentation | +10 | 4.3.1 (page 8) |
|----------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------|-----|----------------|
|                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Subtotal:                                                                             | +30 |                |

| Section | Subsection | Title and Page Number                         |
|---------|------------|-----------------------------------------------|
| 1.      |            | INTRODUCTION<br>1                             |
|         | 1.1        | PURPOSE<br>1                                  |
|         | 1.2        | BACKGROUND<br>1                               |
| 2.      |            | SCOPE<br>1                                    |
| 3.      |            | DEFINITIONS<br>2                              |
| 4.      |            | EVALUATION CRITERIA<br>3                      |
|         | 4.1        | GENERAL REQUIREMENTS<br>3                     |
|         |            | 4.1.1 Serviceability<br>3                     |
|         |            | 4.1.2 Environmental Management System<br>4    |
|         |            | 4.1.3 Product Information<br>4                |
|         |            | 4.1.4 Packaging Requirements<br>5             |
|         |            | 4.1.5 Extra Environmental Features<br>5       |
|         | 4.2        | RESOURCE CONSUMPTION<br>6                     |
|         |            | 4.2.1 Thermal Insulation Performance<br>6     |
|         |            | 4.2.2 Shading Coefficient<br>6                |
|         |            | 4.2.3 Visible Light Transmittance<br>7        |
|         |            | 4.2.4 External Reflectance<br>7               |
|         |            | 4.2.5 Energy Management in Manufacturing<br>7 |
|         | 4.3        | HUMAN TOXICITY AND ECOSYSTEM IMPACT<br>8      |
|         |            | 4.3.1 Hazardous Substances<br>8               |
| 5.      |            | SCORING AND GRADING<br>9                      |

## <span id="page-5-0"></span>**1. INTRODUCTION**

<span id="page-5-1"></span>

## **1.1 PURPOSE**

The CIC Green Product Certification *(formerly known as HKGBC Green Product Accreditation and Standards [HK G-PASS])* (herein after referred as the "Scheme") is an environmental labelling scheme owned by the Construction Industry Council (CIC) and implemented by the Hong Kong Green Building Council (HKGBC) which aims to help consumers, building professionals and policy makers identify environmentally preferable building materials and products. This Assessment Standard (hereafter referred as the "Standard") sets out the assessment criteria and their benchmarks for glazing products to govern the application and award of a label under the Scheme. The Standard also defines the verification methods to determine which labelling grade should be awarded to the product according to the assessment criteria.

This Standard neither modifies nor supersedes laws and regulations. Compliance with this Standard is not a substitute for, and does not assure, compliance with any applicable laws or regulations. Compliance with all applicable laws and regulations is a prerequisite for the manufacturing and marketing of the product.

<span id="page-5-2"></span>

## **1.2 BACKGROUND**

Glazing products are commonly used [building material](http://en.wikipedia.org/wiki/Building_material) for fixed and opening windows, window doors, curtain walls and other elements of the building envelop. The glazing area of a building could account for 10 to 25% of a building's exposed surface, serving as an interface to transmit light and provide outdoor view. Common types of glazing being used in architectural applications include clear and tinted float glass, tempered glass, and laminated glass as well as a variety of coated glasses, etc. Many of them contain substances that may be harmful to the environment and human health. However, the greatest environmental impact of glazing products is resulted from the energy losses during the building operation stage due to their long technical service life.

The purposes of the assessment criteria developed for glazing are, therefore, to promote the use of energy-efficient building envelop, and to minimise the environmental impact through stringent assessment criteria on the production process and use of materials.

## <span id="page-5-3"></span>**2. SCOPE**

The scope of this Standard is applicable to glass in fixed and opening windows, window doors, and other elements of building envelop. Glass blocks and bricks or glass used for internal partitions are excluded from this Standard.

*Note:*

Each application should specify its types (single / double glazing etc.) and product series. **ONE** application is only for **ONE** product series with same type of glazing. Subsequent applications can be made for similar products with different thickness and/or coatings under a labelled product series, which is only eligible for applying within the validity period of the label.

# <span id="page-6-0"></span>**3. DEFINITIONS**

*Applicant:* Organisations which apply for the label of the CIC Green Product Certification of the Construction Industry Council

*CIC:* Construction Industry Council

*CNAS:* China National Accreditation Service for Conformity Assessment

*Double or triple glazing:* Windows that have two layers of glass to keep a building warm or to reduce noise from outside

*External reflectance:* The percentage of daylight reflected from any external surface of any window, door, wall or roof of a building

*Glazing:* A part of the façade or window which is made of [glass,](http://en.wikipedia.org/wiki/Glass) and it could be transparent or semi-transparent to solar radiation

*HKAS:* Hong Kong Accreditation Service

*HKGBC:* The Hong Kong Green Building Council Limited

*HOKLAS:* The Hong Kong Laboratory Accreditation Scheme

*IARC:* International Agency for Research on Cancer

*ISO:* International Organisation for Standardisation

*MSDS:* Material Safety Data Sheet. To qualify as suitable, the MSDS and information therein must not be more than 5-years old

*Shading coefficient (SC):* The ratio of the rate of solar heat gain through a specific unit assembly of glass to the solar heat gain through a 3mm single lite of clear glass in the same

#### 2 **Copyright © 2020 Construction Industry Council**

situation

*Single glazing:* Windows that are made up of a single sheet of glass

*Solar heat gain coefficient (SHGC):* The ratio of solar heat gain entering the space through the glazing product to the incident solar radiation which is expressed as a value between 0 and 1

*Standard single glazing:* Standard single glazing refers to 3mm clear float glass

*Third-party:* An entity without any financial interest or stake in the sales of the product or service being evaluated or other conflict of interest

*U-value:* Overall heat transferred due to conduction, convection and long wave infra-red radiation, on average in unites of time per unit area (m<sup>2</sup> ) of the entire glazing product when the temperature difference between the indoor and outdoor sides of the product is one 1 degree under the Kelvin temperature scale. Expressed here in units of W/m<sup>2</sup>K

*Visible light transmittance (VLT):* The fraction of total visible light that transmits from the glazing's outdoor side to the indoor side, weighted by the sensitivity of human eye (wavelength range of 0.38 to 0.78 μm)

# <span id="page-7-0"></span>**4. EVALUATION CRITERIA**

A product to be assessed should meet all the minimum requirements of the "Core Criteria" in order to be awarded a "Green" (i.e. a "pass" grade) Label under the Scheme. Bonus points may be awarded if the product meets the "Non-core Criteria" and a "Bronze", "Silver", "Gold" or "Platinum" Label will be awarded according to the total points accumulated (see Section 5 for details). All submissions and documentations shall be endorsed by the Chief Executive Officer or other authorised persons of the Applicant to demonstrate conformance to the assessment criteria. All certification, laboratory report and documentation must be valid during the assessment process and labelling period. The validity of all laboratory report and documentation shall be 5 years from the date of issue. The chemical tests should be conducted by either a third party or the manufacturer who has received the ISO17025 certification or relevant national accreditation systems, e.g. HOKLAS, CNAS, etc.

#### <span id="page-7-1"></span>**4.1 GENERAL REQUIREMENTS**

#### <span id="page-7-2"></span>*4.1.1 Serviceability*

5 Points (Non-Core Criterion)

The product shall fulfil the quality, safety, air leakage and other functional requirements according to the British Standards (BS), BS EN (European Standard), American Society for Testing and Materials (ASTM), Chinese National Standard (GB) or equivalent national standards. In addition, glass manufacturer shall provide a 10-year guarantee covering functions and quality according to relevant standards.

#### Verification

Laboratory test report(s) for all relevant quality and performance tests. The tests should be conducted by either a third party or manufacturer who has received ISO 17025 certification or national accreditation systems e.g. HOKLAS, CNAS (same applied to the verification methods hereafter). Guarantee certificate supplied with the product or made available to the public, e.g. through manufacturer's website.

#### <span id="page-8-0"></span>*4.1.2 Environmental Management System*

#### 5 Points (Non-Core Criterion)

Manufacturer of the products shall possess valid certificates of ISO14001 or the EU Eco-Management and Audit Scheme (EMAS). Targets shall be set to reduce the environmental impacts during the manufacturing process which include but not limited to the reduction of hazardous substance emissions, energy consumption, CO<sup>2</sup> emissions, secondary environmental load, waste management, water management, etc.

#### Verification

A valid ISO14001 or EMAS Certificate issued by local or overseas accredited certification bodies.

#### <span id="page-8-1"></span>*4.1.3 Product Information*

#### 5 Points (Core Criterion)

The following essential information shall be provided by the product manufacturer with each delivery of the glazing products or made available to the public:

- o Instructions on how the product shall be installed, adjusted and protected in a sustainable manner, in order to prevent heat loss as a result of poor installation;
- o Information on the product's U-value, solar heat gain coefficient (SHGC) and visible light transmittance (VLT);
- o Instructions describing the recommended maintenance for the product. Care instructions should contain details on how often the product should be checked and maintained, and what surface treatment is recommended; and
- o Details of what should be done with the product at the end of its service life.

#### Verification

Documentation related to the above product information and instructions, web pages

and any other information freely available to customers or the public.

#### <span id="page-9-0"></span>*4.1.4 Packaging Requirements*

#### 5 Points (Non-Core Criterion)

The packaging requirements are relevant to all primary packaging materials, i.e. those being used to envelop the product and hold it. The primary packaging materials are usually in direct contact with the contents and shall be in the minimal amount of distribution and/or use as they may eventually be disposed by the consumers.

The packaging materials shall:

- o Not contain halogenated plastics; and
- o Be comprised of 100% recycled material or be readily recyclable, decomposable, or contain no coatings, impregnated chemicals or other materials that would prevent recycling or decomposition.

#### Verification

Documentation describing the packaging materials used as well as their chemical composition (if any and where applicable), treatment process and recyclability should be submitted.

#### <span id="page-9-1"></span>*4.1.5 Extra Environmental Features*

#### 5 Points (Non-Core Criterion)

Durability and environmental performance of glazing products is advocated in the glazing industry due to the increasing awareness of "green products" among the contractors, architects and end-users, etc. Manufacturers have been investigating and adopting innovative technologies to enhance the durability and environmental performance of the glazing products. For example, high durability of glazing products can reduce resource consumption. This criterion aims to increase manufacturers' incentives in embedding extra environmental features.

The technology adopted in the glazing manufacturing that can enable the glazing products to reduce resources used in:

- o Maintenance, e.g. self-cleaning glass, etc. Or
- o Energy, such as lighting, e.g. instantly reactive glazing technology that changes the glass from clear to a dark blue tint, self-tinted glass, etc.

#### Verification

Documentation describing the extra environmental features adopted as well as the product functions generated by the technology.

#### <span id="page-10-0"></span>**4.2 RESOURCE CONSUMPTION**

#### <span id="page-10-1"></span>*4.2.1 Thermal Insulation Performance*

#### 5 Basic + 5 Bonus Points (Core Criterion)

The overall heat transfer coefficient or U-value measures how well a glazing product transfer heat. U-value is a measure of the rate of heat transfer through a one-squaremetre area of a material for every temperature degree difference under a standardised condition. A low U-value indicates the glazing product is well insulated, resulting in a reduction of cooling load.

In this Standard, the U-value of the single, double or tripled glazing products shall meet the limits below (Table 1). Bonus points will be awarded if the U-value of the product reaches the standard in Table 1.

| U-value (W/m2K) | single glazing | double or tripled glazing | Points |
|-----------------|----------------|---------------------------|--------|
|                 | ≤ 5.8          | ≤ 3.30                    |        |
| ≤ 3.7           | ≤ 2.30         | +5<br>(bonus)             |        |

*Table 1: Limits of U-value for single, double or tripled glazing products*

#### Verification

Laboratory test report(s) on the U-value of the glazing product. The U-value should be measured according to the applicable ISO 8990 or EN-ISO 12567 standard. Alternatively, the U-value can be calculated according to the standard EN673 (Glazing) and EN ISO 10077 (Frame / Casement).

### <span id="page-10-2"></span>*4.2.2 Shading Coefficient*

#### 15 Basic + 5 / 10 Bonus Points (Core Criterion)

Shading coefficient (SC) and solar heat gain coefficient **(**SHGC) can portray how well a product blocks heat caused by sunlight. The lower the glazing's SHGC, the less solar heat it transmits into a building. These two coefficients can be converted according to the equation below:

*SHGC* = *SC* × 0.87

SC or SHGC of the glazing products shall meet the limits below (Table 2). Bonus points will be awarded if SC or SHGC of the product the standard in Table 2.

# **Copyright © 2020 Construction Industry Council**

*Table 2: Limits of shading coefficients and corresponding solar heat gain coefficient for glazing products*

|                             | 15 [basic] | +5 (bonus) | +10 (bonus) |
|-----------------------------|------------|------------|-------------|
| Shading coefficient         | ≤ 0.90     | ≤ 0.60     | ≤ 0.40      |
| Solar heat gain coefficient | ≤ 0.78     | ≤ 0.52     | ≤ 0.35      |

#### <span id="page-11-0"></span>*4.2.3 Visible Light Transmittance*

#### 10 Basic + 5 Bonus Points (Core Criterion)

Visible light transmittance (VLT) is an optical property which indicates the amount of visible light transmitted through the glass. VLT of the glazing product shall be greater than 50%. FIVE bonus points will be awarded if VLT of the product shall be reach 70%.

#### <span id="page-11-1"></span>*4.2.4 External Reflectance*

#### 10 Points (Core Criterion)

External reflectance measures how much light from external source is reflected by the glazing product. Limiting external reflectance on buildings are intended to minimise hindrances caused by sunlight. The external reflectance of glazing product shall be less than 20%.

#### Verification (for Criteria 4.2.2– 4.2.4)

Laboratory test report(s) on the SC, SHGC, external reflectance and VLT of the glazing product. Spectral measurements shall comply with ASTM E903 and the SHGC and VLT should be measured in accordance with the EN 410 or ISO 9050 standard.

#### <span id="page-11-2"></span>*4.2.5 Energy Management in Manufacturing*

#### 5 Points (Core Criterion)

The Applicant shall have effective energy management policies and procedures and / or an energy management programme. The followings shall be submitted as support:

- o Initiatives taken to reduce energy use and improve energy efficiency;
- o Initiatives or requirements for suppliers or contract manufacturers.

#### Verification

Energy management policies, procedures and programmes that is written or signed by Chief Executive Officer or other authorised representative of the Applicant.

#### <span id="page-12-0"></span>**4.3 HUMAN TOXICITY AND ECOSYSTEM IMPACTS**

#### <span id="page-12-1"></span>*4.3.1 Hazardous Substances*

#### 10 Points (Non-Core Criterion)

#### **(For to all glazing products**)

The glazing product shall not contain any carcinogenic substances or chemicals that are classified by the International Agency for Research on Cancer (IARC) in Group 1, 2A or 2B [\(http://monographs.iarc.fr/ENG/Classification/\)](http://monographs.iarc.fr/ENG/Classification/). Any such carcinogens which are known to be present as contaminants shall be less than 0.1% by weight of the product. The product shall also not contain organotin compounds, phthalates or polybrominated diphenyl ethers (PBDEs), and classified as harmful – R20, 21 or 22, toxic – R23, 24 or 25, or very toxic – R26, 27, in accordance with EU Directives 2001/59/EC.

#### (**For tinted glazing products only**)

The product shall not contain toxic heavy metals, or ingredients containing heavy metals, including lead (Pb), cadmium (Cd), mercury (Hg), chromium (Cr), arsenic (As), selenium (Se), antimony (Sb) and cobalt (Co).

#### (**For double/triple glazing products only**)

The product shall not contain chlorinated / brominated paraffins, and filler gases with 100-year global warming potential (GWP100) > 5 shall not be used in the insulating units.

#### Verification

Laboratory test report(s), MSDS, self-declaration letter and production documentation to demonstrate the compliance with the criteria mentioned above.

# <span id="page-13-0"></span>**5. SCORING AND GRADING**

The points for meeting each criterion stated in Section 4 are summarised in Table 2.

*Table 2: Points to be awarded under the assessment criteria of this Standard*

| Evaluation criteria |                                           | Points |            |
|---------------------|-------------------------------------------|--------|------------|
|                     | Basic                                     | +Bonus |            |
| 4.1.1               | Serviceability                            |        | +5         |
| 4.1.2               | Environmental Management System           |        | +5         |
| 4.1.3               | Product Information [CORE]                | 5      |            |
| 4.1.4               | Packaging Requirements                    |        | +5         |
| 4.1.5               | Extra Environmental Features              |        | +5         |
| 4.2.1               | Thermal Insulation Performance [CORE]     | 5      | +5         |
| 4.2.2               | Shading Coefficient [CORE]                | 15     | +5/<br>+10 |
| 4.2.3               | Visible Light Transmittance [CORE]        | 10     | +5         |
| 4.2.4               | External Reflectance [CORE]               | 10     |            |
| 4.2.5               | Energy Management in Manufacturing [CORE] | 5      |            |
| 4.3.1               | Hazardous Substances                      |        | +10        |
|                     |                                           | 50     | +50        |
|                     | Total:                                    |        | 100        |

The minimum requirement to be awarded a "Green" Label under this product category is to obtain 50 points by meeting all minimum requirements laid down in the "Core Criteria".

*Table 3: Benchmarks for grading glazing*

| Grade to be awarded | Points required |
|---------------------|-----------------|
| Platinum            | 90 or above     |
| Gold                | 80 - 89         |
| Silver              | 70 - 79         |
| Bronze              | 60 - 69         |
| Green               | 50 - 59         |
| No Label            | Below 50        |