"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/toolkit-cleaner/clean-objects.lambda.ts
var clean_objects_lambda_exports = {};
__export(clean_objects_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(clean_objects_lambda_exports);
var path = __toESM(require("path"));
var import_client_s3 = require("@aws-sdk/client-s3");
var s3Client = new import_client_s3.S3Client({});
async function handler(assetHashes) {
  if (!process.env.BUCKET_NAME) {
    throw new Error("Missing BUCKET_NAME");
  }
  let deleted = 0;
  let reclaimed = 0;
  let nextKeyMarker;
  let finished = false;
  while (!finished) {
    const response = await s3Client.send(new import_client_s3.ListObjectVersionsCommand({
      Bucket: process.env.BUCKET_NAME,
      KeyMarker: nextKeyMarker
    }));
    const toDelete = response.Versions?.filter((v) => {
      if (!v.Key) {
        return false;
      }
      const hash = path.basename(v.Key, path.extname(v.Key));
      let pred = !assetHashes.includes(hash);
      if (process.env.RETAIN_MILLISECONDS) {
        if (!v.LastModified) {
          return false;
        }
        const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
        pred = pred && v.LastModified < limitDate;
      }
      return pred;
    });
    if (toDelete && toDelete.length !== 0) {
      if (process.env.RUN) {
        await s3Client.send(new import_client_s3.DeleteObjectsCommand({
          Bucket: process.env.BUCKET_NAME,
          Delete: {
            Objects: toDelete.map((v) => ({ Key: v.Key, VersionId: v.VersionId }))
          }
        }));
      }
      deleted += toDelete.length;
      reclaimed += toDelete.reduce((acc, x) => acc + (x.Size ?? 0), 0);
    }
    nextKeyMarker = response.NextKeyMarker;
    if (nextKeyMarker === void 0) {
      finished = true;
    }
  }
  return {
    Deleted: deleted,
    Reclaimed: reclaimed
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
