"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/toolkit-cleaner/extract-template-hashes.lambda.ts
var extract_template_hashes_lambda_exports = {};
__export(extract_template_hashes_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(extract_template_hashes_lambda_exports);
var import_client_cloudformation = require("@aws-sdk/client-cloudformation");
var cloudFormationClient = new import_client_cloudformation.CloudFormationClient({});
async function handler(stackName) {
  const template = await cloudFormationClient.send(new import_client_cloudformation.GetTemplateCommand({
    StackName: stackName
  }));
  if (!template.TemplateBody) {
    return [];
  }
  if (!process.env.DOCKER_IMAGE_ASSET_HASH) {
    throw new Error("Missing DOCKER_IMAGE_ASSET_HASH environment variable");
  }
  const dockerTagPrefix = findDockerTagPrefix(process.env.DOCKER_IMAGE_ASSET_HASH);
  const regexp = new RegExp(`(${dockerTagPrefix})?[a-f0-9]{64}`, "g");
  const hashes = template.TemplateBody.match(regexp);
  return [...new Set(hashes)];
}
function findDockerTagPrefix(hash) {
  if (hash.length === 64) {
    return "";
  }
  return hash.substring(0, hash.length - 64);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
