"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/url-shortener/shortener.lambda.ts
var shortener_lambda_exports = {};
__export(shortener_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(shortener_lambda_exports);
var import_url = require("url");
var import_client_dynamodb = require("@aws-sdk/client-dynamodb");
var import_client_s3 = require("@aws-sdk/client-s3");
var import_lib_dynamodb = require("@aws-sdk/lib-dynamodb");
function base62Encode(int) {
  const characterSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  if (int === 0) return "0";
  let s = "";
  while (int > 0) {
    s = characterSet[int % 62] + s;
    int = Math.floor(int / 62);
  }
  return s;
}
function getEnv(name) {
  const value = process.env[name];
  if (!value) {
    throw new Error(`The environment variable ${name} is not defined`);
  }
  return value;
}
function isUrlValid(url) {
  if (!url) {
    return false;
  }
  try {
    new import_url.URL(url);
    return true;
  } catch (err) {
    return false;
  }
}
var dynamoDBClient = new import_client_dynamodb.DynamoDBClient({});
var documentClient = import_lib_dynamodb.DynamoDBDocumentClient.from(dynamoDBClient);
var s3Client = new import_client_s3.S3Client({});
async function handler(event) {
  console.log("Event: %j", event);
  const response = {
    statusCode: 201,
    body: "",
    headers: process.env.CORS_ALLOW_ORIGINS ? { "Access-Control-Allow-Origin": process.env.CORS_ALLOW_ORIGINS } : void 0
  };
  try {
    const body = JSON.parse(event.body ?? "{}");
    if (!isUrlValid(body.url)) {
      return {
        ...response,
        statusCode: 400
      };
    }
    const update = await documentClient.send(new import_lib_dynamodb.UpdateCommand({
      TableName: getEnv("TABLE_NAME"),
      Key: { key: "counter" },
      UpdateExpression: "ADD #value :incr",
      ExpressionAttributeNames: { "#value": "value" },
      ExpressionAttributeValues: { ":incr": 1 },
      ReturnValues: "UPDATED_NEW"
    }));
    const value = update.Attributes?.value;
    if (!value) {
      throw new Error("Cannot get next counter value");
    }
    const key = base62Encode(value);
    console.log("Key: %j", key);
    const putObject = await s3Client.send(new import_client_s3.PutObjectCommand({
      Bucket: getEnv("BUCKET_NAME"),
      Key: key,
      ContentType: "application/json",
      Body: JSON.stringify({ url: body.url })
    }));
    console.log("Put object: %j", putObject);
    return {
      ...response,
      body: JSON.stringify({
        url: body.url,
        shortUrl: `https://${getEnv("DOMAIN_NAME")}/${key}`
      })
    };
  } catch (err) {
    console.log(err);
    return {
      ...response,
      statusCode: 500
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
