import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as ses from 'aws-cdk-lib/aws-ses';
import * as sns from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
/**
 * Properties for an EmailReceiver
 */
export interface EmailReceiverProps {
    /**
     * The SES receipt rule set where a receipt rule will be added
     */
    readonly receiptRuleSet: ses.IReceiptRuleSet;
    /**
     * The recipients for which emails should be received
     */
    readonly recipients: string[];
    /**
     * A Lambda function to invoke after the message is saved to S3. The Lambda
     * function will be invoked with a SESMessage as event.
     */
    readonly function?: lambda.IFunction;
    /**
     * A regular expression to whitelist source email addresses
     *
     * @default - no whitelisting of source email addresses
     */
    readonly sourceWhitelist?: string;
    /**
     * An existing rule after which the new rule will be placed in the rule set.
     *
     * @default - The new rule is inserted at the beginning of the rule list.
     */
    readonly afterRule?: ses.IReceiptRule;
    /**
     * Whether the receiver is active.
     *
     * @default true
     */
    readonly enabled?: boolean;
}
/**
 * Receive emails through SES, save them to S3 and invokes a
 * Lambda function
 */
export declare class EmailReceiver extends Construct {
    /**
     * The S3 bucket where emails are delivered
     */
    readonly bucket: s3.Bucket;
    /**
     * The SNS topic that is notified when emails are delivered to S3
     */
    readonly topic: sns.ITopic;
    constructor(scope: Construct, id: string, props: EmailReceiverProps);
}
