"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailReceiver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const logs = require("aws-cdk-lib/aws-logs");
const s3 = require("aws-cdk-lib/aws-s3");
const ses = require("aws-cdk-lib/aws-ses");
const actions = require("aws-cdk-lib/aws-ses-actions");
const sns = require("aws-cdk-lib/aws-sns");
const subscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
const whitelist_function_1 = require("./whitelist-function");
/**
 * Receive emails through SES, save them to S3 and invokes a
 * Lambda function
 */
class EmailReceiver extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const receiptRule = new ses.ReceiptRule(this, 'ReceiptRule', {
            ruleSet: props.receiptRuleSet,
            recipients: props.recipients,
            after: props.afterRule,
            enabled: props.enabled,
        });
        this.bucket = new s3.Bucket(this, 'Bucket', {
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [{ expiration: aws_cdk_lib_1.Duration.days(1) }],
        });
        if (props.function) {
            this.bucket.grantRead(props.function); // Download email
        }
        this.topic = new sns.Topic(this, 'Topic');
        // Actions
        if (props.sourceWhitelist) {
            const whitelistHandler = new whitelist_function_1.WhitelistFunction(this, 'whitelist', {
                environment: {
                    SOURCE_WHITELIST: props.sourceWhitelist,
                },
                logRetention: logs.RetentionDays.ONE_MONTH,
            });
            receiptRule.addAction(new actions.Lambda({
                function: whitelistHandler,
                invocationType: actions.LambdaInvocationType.REQUEST_RESPONSE,
            }));
        }
        receiptRule.addAction(new actions.S3({
            bucket: this.bucket,
            topic: this.topic,
        }));
        if (props.function) {
            this.topic.addSubscription(new subscriptions.LambdaSubscription(props.function)); // Notify
        }
    }
}
exports.EmailReceiver = EmailReceiver;
_a = JSII_RTTI_SYMBOL_1;
EmailReceiver[_a] = { fqn: "cloudstructs.EmailReceiver", version: "0.9.38" };
//# sourceMappingURL=data:application/json;base64,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