"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MjmlTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ses_1 = require("aws-cdk-lib/aws-ses");
const constructs_1 = require("constructs");
const mjml2html = require("mjml"); // eslint-disable-line @typescript-eslint/no-require-imports
/**
 * SES email template from [MJML](https://mjml.io/)
 */
class MjmlTemplate extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const template = new aws_ses_1.CfnTemplate(this, 'Resource', {
            template: {
                templateName: props.templateName,
                subjectPart: props.subject,
                htmlPart: mjml2html(props.mjml).html,
            },
        });
        this.templateName = template.attrId;
    }
}
exports.MjmlTemplate = MjmlTemplate;
_a = JSII_RTTI_SYMBOL_1;
MjmlTemplate[_a] = { fqn: "cloudstructs.MjmlTemplate", version: "0.9.38" };
//# sourceMappingURL=data:application/json;base64,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