"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SslServerTest = exports.SslServerTestGrade = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_sns_1 = require("aws-cdk-lib/aws-sns");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const aws_stepfunctions_tasks_1 = require("aws-cdk-lib/aws-stepfunctions-tasks");
const constructs_1 = require("constructs");
const analyze_function_1 = require("./analyze-function");
const extract_grade_function_1 = require("./extract-grade-function");
/**
 * SSL Server test grade
 */
var SslServerTestGrade;
(function (SslServerTestGrade) {
    SslServerTestGrade["A_PLUS"] = "A+";
    SslServerTestGrade["A"] = "A";
    SslServerTestGrade["A_MINUS"] = "A-";
    SslServerTestGrade["B"] = "B";
    SslServerTestGrade["C"] = "C";
    SslServerTestGrade["D"] = "D";
    SslServerTestGrade["E"] = "E";
    SslServerTestGrade["F"] = "F";
})(SslServerTestGrade || (exports.SslServerTestGrade = SslServerTestGrade = {}));
/**
 * Perform SSL server test for a hostname
 */
class SslServerTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.alarmTopic = props.alarmTopic ?? new aws_sns_1.Topic(this, 'AlarmTopic');
        const stateMachine = SslServerTestStateMachine.getOrCreate(this);
        this.alarmTopic.grantPublish(stateMachine);
        const rule = new aws_events_1.Rule(this, 'Rule', {
            schedule: props.schedule ?? aws_events_1.Schedule.rate(aws_cdk_lib_1.Duration.days(1)),
        });
        rule.addTarget(new aws_events_targets_1.SfnStateMachine(stateMachine, {
            input: aws_events_1.RuleTargetInput.fromObject({
                host: props.host,
                minimumGrade: props.minimumGrade ?? SslServerTestGrade.A_PLUS,
                alarmTopicArn: this.alarmTopic.topicArn,
            }),
        }));
    }
}
exports.SslServerTest = SslServerTest;
_a = JSII_RTTI_SYMBOL_1;
SslServerTest[_a] = { fqn: "cloudstructs.SslServerTest", version: "0.9.38" };
class SslServerTestStateMachine extends constructs_1.Construct {
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const uid = 'cloudstructs/ssl-server-test.StateMachine';
        const construct = stack.node.tryFindChild(uid) ?? new SslServerTestStateMachine(stack, uid);
        return construct.stateMachine;
    }
    constructor(scope, id) {
        super(scope, id);
        const analyzeFunction = new analyze_function_1.AnalyzeFunction(this, 'AnalyzeFunction', {
            timeout: aws_cdk_lib_1.Duration.seconds(30),
        });
        const startAnalysis = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Start Analysis', {
            lambdaFunction: analyzeFunction,
            payload: aws_stepfunctions_1.TaskInput.fromObject({
                host: aws_stepfunctions_1.JsonPath.stringAt('$.host'),
                startNew: 'on',
            }),
            payloadResponseOnly: true,
        }).addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(2),
            errors: ['Lambda.Unknown'],
        });
        const wait = new aws_stepfunctions_1.Wait(this, 'Wait', {
            time: aws_stepfunctions_1.WaitTime.duration(aws_cdk_lib_1.Duration.seconds(30)),
        });
        const pollAnalysis = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Poll Analysis', {
            lambdaFunction: analyzeFunction,
            payload: aws_stepfunctions_1.TaskInput.fromObject({
                host: aws_stepfunctions_1.JsonPath.stringAt('$.host'),
            }),
            payloadResponseOnly: true,
        }).addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(2),
            errors: ['Lambda.Unknown'],
        });
        ;
        const extractGradeFunction = new extract_grade_function_1.ExtractGradeFunction(this, 'ExtractGradeFunction');
        const extractGrade = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Extract Grade', {
            lambdaFunction: extractGradeFunction,
            payloadResponseOnly: true,
            resultPath: '$.grade',
        });
        const notify = new SnsPublishToTopicAtPath(this, 'Notify', {
            path: '$$.Execution.Input.alarmTopicArn',
            message: aws_stepfunctions_1.TaskInput.fromJsonPathAt('States.JsonToString($)'),
            subject: aws_stepfunctions_1.JsonPath.stringAt("States.Format('SSL grade for {} is below minimum grade ({} < {})', $.host, $.grade, $$.Execution.Input.minimumGrade)"),
        });
        const fail = new aws_stepfunctions_1.Fail(this, 'Fail');
        this.stateMachine = new aws_stepfunctions_1.StateMachine(this, 'StateMachine', {
            definitionBody: aws_stepfunctions_1.DefinitionBody.fromChainable(startAnalysis
                .next(wait)
                .next(pollAnalysis)
                .next(new aws_stepfunctions_1.Choice(this, 'Is Ready ?')
                .when(aws_stepfunctions_1.Condition.stringEquals('$.status', 'READY'), extractGrade.next(new aws_stepfunctions_1.Choice(this, 'Is Grade Below Minimum?')
                .when(aws_stepfunctions_1.Condition.stringLessThanJsonPath('$$.Execution.Input.minimumGrade', '$.grade'), notify)
                .otherwise(new aws_stepfunctions_1.Pass(this, 'Pass'))))
                .when(aws_stepfunctions_1.Condition.stringEquals('$.status', 'ERROR'), fail)
                .otherwise(wait))),
            timeout: aws_cdk_lib_1.Duration.hours(1),
        });
    }
}
class SnsPublishToTopicAtPath extends aws_stepfunctions_1.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
    }
    _renderTask() {
        return {
            Resource: `arn:${aws_cdk_lib_1.Stack.of(this).partition}:states:::sns:publish`,
            Parameters: aws_stepfunctions_1.FieldUtils.renderObject({
                TopicArn: aws_stepfunctions_1.JsonPath.stringAt(this.props.path),
                Message: this.props.message.value,
                Subject: this.props.subject,
            }),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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