"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const client_ecr_1 = require("@aws-sdk/client-ecr");
const ecrClient = new client_ecr_1.ECRClient({});
async function handler(assetHashes) {
    if (!process.env.REPOSITORY_NAME) {
        throw new Error('Missing REPOSITORY_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await ecrClient.send(new client_ecr_1.DescribeImagesCommand({
            repositoryName: process.env.REPOSITORY_NAME,
            nextToken,
        }));
        const toDelete = response.imageDetails?.filter(x => {
            if (!x.imageTags) {
                return false;
            }
            let pred = !assetHashes.includes(x.imageTags[0]);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!x.imagePushedAt) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && x.imagePushedAt && x.imagePushedAt < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await ecrClient.send(new client_ecr_1.BatchDeleteImageCommand({
                    repositoryName: process.env.REPOSITORY_NAME,
                    imageIds: toDelete.map(x => ({ imageTag: x.imageTags[0] })),
                }));
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => acc + (x.imageSizeInBytes ?? 0), 0);
        }
        nextToken = response.nextToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
//# sourceMappingURL=data:application/json;base64,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