"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const path = require("path");
const client_s3_1 = require("@aws-sdk/client-s3");
const s3Client = new client_s3_1.S3Client({});
async function handler(assetHashes) {
    if (!process.env.BUCKET_NAME) {
        throw new Error('Missing BUCKET_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextKeyMarker;
    let finished = false;
    while (!finished) {
        const response = await s3Client.send(new client_s3_1.ListObjectVersionsCommand({
            Bucket: process.env.BUCKET_NAME,
            KeyMarker: nextKeyMarker,
        }));
        const toDelete = response.Versions?.filter(v => {
            if (!v.Key) {
                return false;
            }
            const hash = path.basename(v.Key, path.extname(v.Key));
            let pred = !assetHashes.includes(hash);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!v.LastModified) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && v.LastModified < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await s3Client.send(new client_s3_1.DeleteObjectsCommand({
                    Bucket: process.env.BUCKET_NAME,
                    Delete: {
                        Objects: toDelete.map(v => ({ Key: v.Key, VersionId: v.VersionId })),
                    },
                }));
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => acc + (x.Size ?? 0), 0);
        }
        nextKeyMarker = response.NextKeyMarker;
        if (nextKeyMarker === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
//# sourceMappingURL=data:application/json;base64,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